import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataTfeOauthClientConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/d/oauth_client#oauth_client_id DataTfeOauthClient#oauth_client_id}
    */
    readonly oauthClientId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/tfe/d/oauth_client tfe_oauth_client}
*/
export declare class DataTfeOauthClient extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/tfe/d/oauth_client tfe_oauth_client} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataTfeOauthClientConfig
    */
    constructor(scope: Construct, id: string, config: DataTfeOauthClientConfig);
    get apiUrl(): string;
    get httpUrl(): string;
    get id(): string;
    private _oauthClientId?;
    get oauthClientId(): string;
    set oauthClientId(value: string);
    get oauthClientIdInput(): string | undefined;
    get oauthTokenId(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
