import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataTfeOrganizationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/d/organization#name DataTfeOrganization#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/tfe/d/organization tfe_organization}
*/
export declare class DataTfeOrganization extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/tfe/d/organization tfe_organization} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataTfeOrganizationConfig
    */
    constructor(scope: Construct, id: string, config: DataTfeOrganizationConfig);
    get collaboratorAuthPolicy(): string;
    get costEstimationEnabled(): cdktf.IResolvable;
    get email(): string;
    get externalId(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get ownersTeamSamlRoleId(): string;
    get twoFactorConformant(): cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
