import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataTfeOutputsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The organization to fetch the remote state from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/d/outputs#organization DataTfeOutputs#organization}
    */
    readonly organization: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/d/outputs#values DataTfeOutputs#values}
    */
    readonly values?: {
        [key: string]: any;
    };
    /**
    * The workspace to fetch the remote state from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/d/outputs#workspace DataTfeOutputs#workspace}
    */
    readonly workspace: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/tfe/d/outputs tfe_outputs}
*/
export declare class DataTfeOutputs extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/tfe/d/outputs tfe_outputs} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataTfeOutputsConfig
    */
    constructor(scope: Construct, id: string, config: DataTfeOutputsConfig);
    get id(): string;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    private _values?;
    get values(): {
        [key: string]: any;
    };
    set values(value: {
        [key: string]: any;
    });
    resetValues(): void;
    get valuesInput(): {
        [key: string]: any;
    } | undefined;
    private _workspace?;
    get workspace(): string;
    set workspace(value: string);
    get workspaceInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
