import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataTfeTeamAccessConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/d/team_access#team_id DataTfeTeamAccess#team_id}
    */
    readonly teamId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/d/team_access#workspace_id DataTfeTeamAccess#workspace_id}
    */
    readonly workspaceId: string;
}
export declare class DataTfeTeamAccessPermissions extends cdktf.ComplexComputedList {
    get runs(): string;
    get sentinelMocks(): string;
    get stateVersions(): string;
    get variables(): string;
    get workspaceLocking(): cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/tfe/d/team_access tfe_team_access}
*/
export declare class DataTfeTeamAccess extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/tfe/d/team_access tfe_team_access} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataTfeTeamAccessConfig
    */
    constructor(scope: Construct, id: string, config: DataTfeTeamAccessConfig);
    get access(): string;
    get id(): string;
    permissions(index: string): DataTfeTeamAccessPermissions;
    private _teamId?;
    get teamId(): string;
    set teamId(value: string);
    get teamIdInput(): string | undefined;
    private _workspaceId?;
    get workspaceId(): string;
    set workspaceId(value: string);
    get workspaceIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
