import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataTfeTeamConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/d/team#name DataTfeTeam#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/d/team#organization DataTfeTeam#organization}
    */
    readonly organization: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/tfe/d/team tfe_team}
*/
export declare class DataTfeTeam extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/tfe/d/team tfe_team} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataTfeTeamConfig
    */
    constructor(scope: Construct, id: string, config: DataTfeTeamConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
