import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataTfeWorkspaceIdsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/d/workspace_ids#names DataTfeWorkspaceIds#names}
    */
    readonly names?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/d/workspace_ids#organization DataTfeWorkspaceIds#organization}
    */
    readonly organization: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/d/workspace_ids#tag_names DataTfeWorkspaceIds#tag_names}
    */
    readonly tagNames?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/tfe/d/workspace_ids tfe_workspace_ids}
*/
export declare class DataTfeWorkspaceIds extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/tfe/d/workspace_ids tfe_workspace_ids} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataTfeWorkspaceIdsConfig
    */
    constructor(scope: Construct, id: string, config: DataTfeWorkspaceIdsConfig);
    fullNames(key: string): string | cdktf.IResolvable;
    get id(): string;
    ids(key: string): string | cdktf.IResolvable;
    private _names?;
    get names(): string[];
    set names(value: string[]);
    resetNames(): void;
    get namesInput(): string[] | undefined;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    private _tagNames?;
    get tagNames(): string[];
    set tagNames(value: string[]);
    resetTagNames(): void;
    get tagNamesInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
