import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataTfeWorkspaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/d/workspace#name DataTfeWorkspace#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/d/workspace#organization DataTfeWorkspace#organization}
    */
    readonly organization: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/d/workspace#tag_names DataTfeWorkspace#tag_names}
    */
    readonly tagNames?: string[];
}
export declare class DataTfeWorkspaceVcsRepo extends cdktf.ComplexComputedList {
    get branch(): string;
    get identifier(): string;
    get ingressSubmodules(): cdktf.IResolvable;
    get oauthTokenId(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/tfe/d/workspace tfe_workspace}
*/
export declare class DataTfeWorkspace extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/tfe/d/workspace tfe_workspace} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataTfeWorkspaceConfig
    */
    constructor(scope: Construct, id: string, config: DataTfeWorkspaceConfig);
    get allowDestroyPlan(): cdktf.IResolvable;
    get autoApply(): cdktf.IResolvable;
    get description(): string;
    get fileTriggersEnabled(): cdktf.IResolvable;
    get globalRemoteState(): cdktf.IResolvable;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get operations(): cdktf.IResolvable;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    get policyCheckFailures(): number;
    get queueAllRuns(): cdktf.IResolvable;
    get remoteStateConsumerIds(): string[];
    get resourceCount(): number;
    get runFailures(): number;
    get runsCount(): number;
    get speculativeEnabled(): cdktf.IResolvable;
    get sshKeyId(): string;
    get structuredRunOutputEnabled(): cdktf.IResolvable;
    private _tagNames?;
    get tagNames(): string[];
    set tagNames(value: string[]);
    resetTagNames(): void;
    get tagNamesInput(): string[] | undefined;
    get terraformVersion(): string;
    get triggerPrefixes(): string[];
    vcsRepo(index: string): DataTfeWorkspaceVcsRepo;
    get workingDirectory(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
