import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OauthClientConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/oauth_client#api_url OauthClient#api_url}
    */
    readonly apiUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/oauth_client#http_url OauthClient#http_url}
    */
    readonly httpUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/oauth_client#oauth_token OauthClient#oauth_token}
    */
    readonly oauthToken: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/oauth_client#organization OauthClient#organization}
    */
    readonly organization: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/oauth_client#private_key OauthClient#private_key}
    */
    readonly privateKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/oauth_client#service_provider OauthClient#service_provider}
    */
    readonly serviceProvider: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/tfe/r/oauth_client tfe_oauth_client}
*/
export declare class OauthClient extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/tfe/r/oauth_client tfe_oauth_client} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OauthClientConfig
    */
    constructor(scope: Construct, id: string, config: OauthClientConfig);
    private _apiUrl?;
    get apiUrl(): string;
    set apiUrl(value: string);
    get apiUrlInput(): string | undefined;
    private _httpUrl?;
    get httpUrl(): string;
    set httpUrl(value: string);
    get httpUrlInput(): string | undefined;
    get id(): string;
    private _oauthToken?;
    get oauthToken(): string;
    set oauthToken(value: string);
    get oauthTokenInput(): string | undefined;
    get oauthTokenId(): string;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    private _privateKey?;
    get privateKey(): string;
    set privateKey(value: string);
    resetPrivateKey(): void;
    get privateKeyInput(): string | undefined;
    private _serviceProvider?;
    get serviceProvider(): string;
    set serviceProvider(value: string);
    get serviceProviderInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
