import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OrganizationMembershipConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/organization_membership#email OrganizationMembership#email}
    */
    readonly email: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/organization_membership#organization OrganizationMembership#organization}
    */
    readonly organization: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/tfe/r/organization_membership tfe_organization_membership}
*/
export declare class OrganizationMembership extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/tfe/r/organization_membership tfe_organization_membership} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OrganizationMembershipConfig
    */
    constructor(scope: Construct, id: string, config: OrganizationMembershipConfig);
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    get id(): string;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    get userId(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
