import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OrganizationTokenConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/organization_token#force_regenerate OrganizationToken#force_regenerate}
    */
    readonly forceRegenerate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/organization_token#organization OrganizationToken#organization}
    */
    readonly organization: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/tfe/r/organization_token tfe_organization_token}
*/
export declare class OrganizationToken extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/tfe/r/organization_token tfe_organization_token} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OrganizationTokenConfig
    */
    constructor(scope: Construct, id: string, config: OrganizationTokenConfig);
    private _forceRegenerate?;
    get forceRegenerate(): boolean | cdktf.IResolvable;
    set forceRegenerate(value: boolean | cdktf.IResolvable);
    resetForceRegenerate(): void;
    get forceRegenerateInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    get token(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
