import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OrganizationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/organization#collaborator_auth_policy Organization#collaborator_auth_policy}
    */
    readonly collaboratorAuthPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/organization#cost_estimation_enabled Organization#cost_estimation_enabled}
    */
    readonly costEstimationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/organization#email Organization#email}
    */
    readonly email: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/organization#name Organization#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/organization#owners_team_saml_role_id Organization#owners_team_saml_role_id}
    */
    readonly ownersTeamSamlRoleId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/organization#session_remember_minutes Organization#session_remember_minutes}
    */
    readonly sessionRememberMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/organization#session_timeout_minutes Organization#session_timeout_minutes}
    */
    readonly sessionTimeoutMinutes?: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/tfe/r/organization tfe_organization}
*/
export declare class Organization extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/tfe/r/organization tfe_organization} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OrganizationConfig
    */
    constructor(scope: Construct, id: string, config: OrganizationConfig);
    private _collaboratorAuthPolicy?;
    get collaboratorAuthPolicy(): string;
    set collaboratorAuthPolicy(value: string);
    resetCollaboratorAuthPolicy(): void;
    get collaboratorAuthPolicyInput(): string | undefined;
    private _costEstimationEnabled?;
    get costEstimationEnabled(): boolean | cdktf.IResolvable;
    set costEstimationEnabled(value: boolean | cdktf.IResolvable);
    resetCostEstimationEnabled(): void;
    get costEstimationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _ownersTeamSamlRoleId?;
    get ownersTeamSamlRoleId(): string;
    set ownersTeamSamlRoleId(value: string);
    resetOwnersTeamSamlRoleId(): void;
    get ownersTeamSamlRoleIdInput(): string | undefined;
    private _sessionRememberMinutes?;
    get sessionRememberMinutes(): number;
    set sessionRememberMinutes(value: number);
    resetSessionRememberMinutes(): void;
    get sessionRememberMinutesInput(): number | undefined;
    private _sessionTimeoutMinutes?;
    get sessionTimeoutMinutes(): number;
    set sessionTimeoutMinutes(value: number);
    resetSessionTimeoutMinutes(): void;
    get sessionTimeoutMinutesInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
