import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PolicySetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/policy_set#description PolicySet#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/policy_set#global PolicySet#global}
    */
    readonly global?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/policy_set#name PolicySet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/policy_set#organization PolicySet#organization}
    */
    readonly organization: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/policy_set#policies_path PolicySet#policies_path}
    */
    readonly policiesPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/policy_set#policy_ids PolicySet#policy_ids}
    */
    readonly policyIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/policy_set#slug PolicySet#slug}
    */
    readonly slug?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/policy_set#workspace_ids PolicySet#workspace_ids}
    */
    readonly workspaceIds?: string[];
    /**
    * vcs_repo block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/policy_set#vcs_repo PolicySet#vcs_repo}
    */
    readonly vcsRepo?: PolicySetVcsRepo;
}
export interface PolicySetVcsRepo {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/policy_set#branch PolicySet#branch}
    */
    readonly branch?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/policy_set#identifier PolicySet#identifier}
    */
    readonly identifier: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/policy_set#ingress_submodules PolicySet#ingress_submodules}
    */
    readonly ingressSubmodules?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/policy_set#oauth_token_id PolicySet#oauth_token_id}
    */
    readonly oauthTokenId: string;
}
export declare function policySetVcsRepoToTerraform(struct?: PolicySetVcsRepoOutputReference | PolicySetVcsRepo): any;
export declare class PolicySetVcsRepoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): PolicySetVcsRepo | undefined;
    set internalValue(value: PolicySetVcsRepo | undefined);
    private _branch?;
    get branch(): string;
    set branch(value: string);
    resetBranch(): void;
    get branchInput(): string | undefined;
    private _identifier?;
    get identifier(): string;
    set identifier(value: string);
    get identifierInput(): string | undefined;
    private _ingressSubmodules?;
    get ingressSubmodules(): boolean | cdktf.IResolvable;
    set ingressSubmodules(value: boolean | cdktf.IResolvable);
    resetIngressSubmodules(): void;
    get ingressSubmodulesInput(): boolean | cdktf.IResolvable | undefined;
    private _oauthTokenId?;
    get oauthTokenId(): string;
    set oauthTokenId(value: string);
    get oauthTokenIdInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/tfe/r/policy_set tfe_policy_set}
*/
export declare class PolicySet extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/tfe/r/policy_set tfe_policy_set} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PolicySetConfig
    */
    constructor(scope: Construct, id: string, config: PolicySetConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _global?;
    get global(): boolean | cdktf.IResolvable;
    set global(value: boolean | cdktf.IResolvable);
    resetGlobal(): void;
    get globalInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    private _policiesPath?;
    get policiesPath(): string;
    set policiesPath(value: string);
    resetPoliciesPath(): void;
    get policiesPathInput(): string | undefined;
    private _policyIds?;
    get policyIds(): string[];
    set policyIds(value: string[]);
    resetPolicyIds(): void;
    get policyIdsInput(): string[] | undefined;
    private _slug?;
    get slug(): {
        [key: string]: string;
    };
    set slug(value: {
        [key: string]: string;
    });
    resetSlug(): void;
    get slugInput(): {
        [key: string]: string;
    } | undefined;
    private _workspaceIds?;
    get workspaceIds(): string[];
    set workspaceIds(value: string[]);
    resetWorkspaceIds(): void;
    get workspaceIdsInput(): string[] | undefined;
    private _vcsRepo;
    get vcsRepo(): PolicySetVcsRepoOutputReference;
    putVcsRepo(value: PolicySetVcsRepo): void;
    resetVcsRepo(): void;
    get vcsRepoInput(): PolicySetVcsRepo | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
