import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RegistryModuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * vcs_repo block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/registry_module#vcs_repo RegistryModule#vcs_repo}
    */
    readonly vcsRepo: RegistryModuleVcsRepo;
}
export interface RegistryModuleVcsRepo {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/registry_module#display_identifier RegistryModule#display_identifier}
    */
    readonly displayIdentifier: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/registry_module#identifier RegistryModule#identifier}
    */
    readonly identifier: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/registry_module#oauth_token_id RegistryModule#oauth_token_id}
    */
    readonly oauthTokenId: string;
}
export declare function registryModuleVcsRepoToTerraform(struct?: RegistryModuleVcsRepoOutputReference | RegistryModuleVcsRepo): any;
export declare class RegistryModuleVcsRepoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): RegistryModuleVcsRepo | undefined;
    set internalValue(value: RegistryModuleVcsRepo | undefined);
    private _displayIdentifier?;
    get displayIdentifier(): string;
    set displayIdentifier(value: string);
    get displayIdentifierInput(): string | undefined;
    private _identifier?;
    get identifier(): string;
    set identifier(value: string);
    get identifierInput(): string | undefined;
    private _oauthTokenId?;
    get oauthTokenId(): string;
    set oauthTokenId(value: string);
    get oauthTokenIdInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/tfe/r/registry_module tfe_registry_module}
*/
export declare class RegistryModule extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/tfe/r/registry_module tfe_registry_module} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RegistryModuleConfig
    */
    constructor(scope: Construct, id: string, config: RegistryModuleConfig);
    get id(): string;
    get moduleProvider(): string;
    get name(): string;
    get organization(): string;
    private _vcsRepo;
    get vcsRepo(): RegistryModuleVcsRepoOutputReference;
    putVcsRepo(value: RegistryModuleVcsRepo): void;
    get vcsRepoInput(): RegistryModuleVcsRepo | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
