import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RunTriggerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/run_trigger#sourceable_id RunTrigger#sourceable_id}
    */
    readonly sourceableId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/run_trigger#workspace_id RunTrigger#workspace_id}
    */
    readonly workspaceId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/tfe/r/run_trigger tfe_run_trigger}
*/
export declare class RunTrigger extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/tfe/r/run_trigger tfe_run_trigger} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RunTriggerConfig
    */
    constructor(scope: Construct, id: string, config: RunTriggerConfig);
    get id(): string;
    private _sourceableId?;
    get sourceableId(): string;
    set sourceableId(value: string);
    get sourceableIdInput(): string | undefined;
    private _workspaceId?;
    get workspaceId(): string;
    set workspaceId(value: string);
    get workspaceIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
