import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TeamAccessConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/team_access#access TeamAccess#access}
    */
    readonly access?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/team_access#team_id TeamAccess#team_id}
    */
    readonly teamId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/team_access#workspace_id TeamAccess#workspace_id}
    */
    readonly workspaceId: string;
    /**
    * permissions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/team_access#permissions TeamAccess#permissions}
    */
    readonly permissions?: TeamAccessPermissions[] | cdktf.IResolvable;
}
export interface TeamAccessPermissions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/team_access#runs TeamAccess#runs}
    */
    readonly runs: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/team_access#sentinel_mocks TeamAccess#sentinel_mocks}
    */
    readonly sentinelMocks: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/team_access#state_versions TeamAccess#state_versions}
    */
    readonly stateVersions: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/team_access#variables TeamAccess#variables}
    */
    readonly variables: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/team_access#workspace_locking TeamAccess#workspace_locking}
    */
    readonly workspaceLocking: boolean | cdktf.IResolvable;
}
export declare function teamAccessPermissionsToTerraform(struct?: TeamAccessPermissions | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/tfe/r/team_access tfe_team_access}
*/
export declare class TeamAccess extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/tfe/r/team_access tfe_team_access} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TeamAccessConfig
    */
    constructor(scope: Construct, id: string, config: TeamAccessConfig);
    private _access?;
    get access(): string;
    set access(value: string);
    resetAccess(): void;
    get accessInput(): string | undefined;
    get id(): string;
    private _teamId?;
    get teamId(): string;
    set teamId(value: string);
    get teamIdInput(): string | undefined;
    private _workspaceId?;
    get workspaceId(): string;
    set workspaceId(value: string);
    get workspaceIdInput(): string | undefined;
    private _permissions?;
    get permissions(): TeamAccessPermissions[] | cdktf.IResolvable;
    set permissions(value: TeamAccessPermissions[] | cdktf.IResolvable);
    resetPermissions(): void;
    get permissionsInput(): cdktf.IResolvable | TeamAccessPermissions[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
