import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TeamMembersConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/team_members#team_id TeamMembers#team_id}
    */
    readonly teamId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/team_members#usernames TeamMembers#usernames}
    */
    readonly usernames: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/tfe/r/team_members tfe_team_members}
*/
export declare class TeamMembers extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/tfe/r/team_members tfe_team_members} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TeamMembersConfig
    */
    constructor(scope: Construct, id: string, config: TeamMembersConfig);
    get id(): string;
    private _teamId?;
    get teamId(): string;
    set teamId(value: string);
    get teamIdInput(): string | undefined;
    private _usernames?;
    get usernames(): string[];
    set usernames(value: string[]);
    get usernamesInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
