import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TeamOrganizationMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/team_organization_member#organization_membership_id TeamOrganizationMember#organization_membership_id}
    */
    readonly organizationMembershipId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/team_organization_member#team_id TeamOrganizationMember#team_id}
    */
    readonly teamId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/tfe/r/team_organization_member tfe_team_organization_member}
*/
export declare class TeamOrganizationMember extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/tfe/r/team_organization_member tfe_team_organization_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TeamOrganizationMemberConfig
    */
    constructor(scope: Construct, id: string, config: TeamOrganizationMemberConfig);
    get id(): string;
    private _organizationMembershipId?;
    get organizationMembershipId(): string;
    set organizationMembershipId(value: string);
    get organizationMembershipIdInput(): string | undefined;
    private _teamId?;
    get teamId(): string;
    set teamId(value: string);
    get teamIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
