import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TeamTokenConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/team_token#force_regenerate TeamToken#force_regenerate}
    */
    readonly forceRegenerate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/team_token#team_id TeamToken#team_id}
    */
    readonly teamId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/tfe/r/team_token tfe_team_token}
*/
export declare class TeamToken extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/tfe/r/team_token tfe_team_token} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TeamTokenConfig
    */
    constructor(scope: Construct, id: string, config: TeamTokenConfig);
    private _forceRegenerate?;
    get forceRegenerate(): boolean | cdktf.IResolvable;
    set forceRegenerate(value: boolean | cdktf.IResolvable);
    resetForceRegenerate(): void;
    get forceRegenerateInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _teamId?;
    get teamId(): string;
    set teamId(value: string);
    get teamIdInput(): string | undefined;
    get token(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
