import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TeamConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/team#name Team#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/team#organization Team#organization}
    */
    readonly organization: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/team#visibility Team#visibility}
    */
    readonly visibility?: string;
    /**
    * organization_access block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/team#organization_access Team#organization_access}
    */
    readonly organizationAccess?: TeamOrganizationAccess;
}
export interface TeamOrganizationAccess {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/team#manage_policies Team#manage_policies}
    */
    readonly managePolicies?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/team#manage_policy_overrides Team#manage_policy_overrides}
    */
    readonly managePolicyOverrides?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/team#manage_vcs_settings Team#manage_vcs_settings}
    */
    readonly manageVcsSettings?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/team#manage_workspaces Team#manage_workspaces}
    */
    readonly manageWorkspaces?: boolean | cdktf.IResolvable;
}
export declare function teamOrganizationAccessToTerraform(struct?: TeamOrganizationAccessOutputReference | TeamOrganizationAccess): any;
export declare class TeamOrganizationAccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): TeamOrganizationAccess | undefined;
    set internalValue(value: TeamOrganizationAccess | undefined);
    private _managePolicies?;
    get managePolicies(): boolean | cdktf.IResolvable;
    set managePolicies(value: boolean | cdktf.IResolvable);
    resetManagePolicies(): void;
    get managePoliciesInput(): boolean | cdktf.IResolvable | undefined;
    private _managePolicyOverrides?;
    get managePolicyOverrides(): boolean | cdktf.IResolvable;
    set managePolicyOverrides(value: boolean | cdktf.IResolvable);
    resetManagePolicyOverrides(): void;
    get managePolicyOverridesInput(): boolean | cdktf.IResolvable | undefined;
    private _manageVcsSettings?;
    get manageVcsSettings(): boolean | cdktf.IResolvable;
    set manageVcsSettings(value: boolean | cdktf.IResolvable);
    resetManageVcsSettings(): void;
    get manageVcsSettingsInput(): boolean | cdktf.IResolvable | undefined;
    private _manageWorkspaces?;
    get manageWorkspaces(): boolean | cdktf.IResolvable;
    set manageWorkspaces(value: boolean | cdktf.IResolvable);
    resetManageWorkspaces(): void;
    get manageWorkspacesInput(): boolean | cdktf.IResolvable | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/tfe/r/team tfe_team}
*/
export declare class Team extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/tfe/r/team tfe_team} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TeamConfig
    */
    constructor(scope: Construct, id: string, config: TeamConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    private _visibility?;
    get visibility(): string;
    set visibility(value: string);
    resetVisibility(): void;
    get visibilityInput(): string | undefined;
    private _organizationAccess;
    get organizationAccess(): TeamOrganizationAccessOutputReference;
    putOrganizationAccess(value: TeamOrganizationAccess): void;
    resetOrganizationAccess(): void;
    get organizationAccessInput(): TeamOrganizationAccess | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
