import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TfeProviderConfig {
    /**
    * The Terraform Enterprise hostname to connect to. Defaults to app.terraform.io.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe#hostname TfeProvider#hostname}
    */
    readonly hostname?: string;
    /**
    * Whether or not to skip certificate verifications.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe#ssl_skip_verify TfeProvider#ssl_skip_verify}
    */
    readonly sslSkipVerify?: boolean | cdktf.IResolvable;
    /**
    * The token used to authenticate with Terraform Enterprise. We recommend omitting
  the token which can be set as credentials in the CLI config file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe#token TfeProvider#token}
    */
    readonly token?: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe#alias TfeProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/tfe tfe}
*/
export declare class TfeProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/tfe tfe} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TfeProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: TfeProviderConfig);
    private _hostname?;
    get hostname(): string | undefined;
    set hostname(value: string | undefined);
    resetHostname(): void;
    get hostnameInput(): string | undefined;
    private _sslSkipVerify?;
    get sslSkipVerify(): boolean | cdktf.IResolvable | undefined;
    set sslSkipVerify(value: boolean | cdktf.IResolvable | undefined);
    resetSslSkipVerify(): void;
    get sslSkipVerifyInput(): boolean | cdktf.IResolvable | undefined;
    private _token?;
    get token(): string | undefined;
    set token(value: string | undefined);
    resetToken(): void;
    get tokenInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
