import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WorkspaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#agent_pool_id Workspace#agent_pool_id}
    */
    readonly agentPoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#allow_destroy_plan Workspace#allow_destroy_plan}
    */
    readonly allowDestroyPlan?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#auto_apply Workspace#auto_apply}
    */
    readonly autoApply?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#description Workspace#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#execution_mode Workspace#execution_mode}
    */
    readonly executionMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#file_triggers_enabled Workspace#file_triggers_enabled}
    */
    readonly fileTriggersEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#global_remote_state Workspace#global_remote_state}
    */
    readonly globalRemoteState?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#name Workspace#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#operations Workspace#operations}
    */
    readonly operations?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#organization Workspace#organization}
    */
    readonly organization: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#queue_all_runs Workspace#queue_all_runs}
    */
    readonly queueAllRuns?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#remote_state_consumer_ids Workspace#remote_state_consumer_ids}
    */
    readonly remoteStateConsumerIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#speculative_enabled Workspace#speculative_enabled}
    */
    readonly speculativeEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#ssh_key_id Workspace#ssh_key_id}
    */
    readonly sshKeyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#structured_run_output_enabled Workspace#structured_run_output_enabled}
    */
    readonly structuredRunOutputEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#tag_names Workspace#tag_names}
    */
    readonly tagNames?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#terraform_version Workspace#terraform_version}
    */
    readonly terraformVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#trigger_prefixes Workspace#trigger_prefixes}
    */
    readonly triggerPrefixes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#working_directory Workspace#working_directory}
    */
    readonly workingDirectory?: string;
    /**
    * vcs_repo block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#vcs_repo Workspace#vcs_repo}
    */
    readonly vcsRepo?: WorkspaceVcsRepo;
}
export interface WorkspaceVcsRepo {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#branch Workspace#branch}
    */
    readonly branch?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#identifier Workspace#identifier}
    */
    readonly identifier: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#ingress_submodules Workspace#ingress_submodules}
    */
    readonly ingressSubmodules?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/workspace#oauth_token_id Workspace#oauth_token_id}
    */
    readonly oauthTokenId: string;
}
export declare function workspaceVcsRepoToTerraform(struct?: WorkspaceVcsRepoOutputReference | WorkspaceVcsRepo): any;
export declare class WorkspaceVcsRepoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): WorkspaceVcsRepo | undefined;
    set internalValue(value: WorkspaceVcsRepo | undefined);
    private _branch?;
    get branch(): string;
    set branch(value: string);
    resetBranch(): void;
    get branchInput(): string | undefined;
    private _identifier?;
    get identifier(): string;
    set identifier(value: string);
    get identifierInput(): string | undefined;
    private _ingressSubmodules?;
    get ingressSubmodules(): boolean | cdktf.IResolvable;
    set ingressSubmodules(value: boolean | cdktf.IResolvable);
    resetIngressSubmodules(): void;
    get ingressSubmodulesInput(): boolean | cdktf.IResolvable | undefined;
    private _oauthTokenId?;
    get oauthTokenId(): string;
    set oauthTokenId(value: string);
    get oauthTokenIdInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/tfe/r/workspace tfe_workspace}
*/
export declare class Workspace extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/tfe/r/workspace tfe_workspace} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WorkspaceConfig
    */
    constructor(scope: Construct, id: string, config: WorkspaceConfig);
    private _agentPoolId?;
    get agentPoolId(): string;
    set agentPoolId(value: string);
    resetAgentPoolId(): void;
    get agentPoolIdInput(): string | undefined;
    private _allowDestroyPlan?;
    get allowDestroyPlan(): boolean | cdktf.IResolvable;
    set allowDestroyPlan(value: boolean | cdktf.IResolvable);
    resetAllowDestroyPlan(): void;
    get allowDestroyPlanInput(): boolean | cdktf.IResolvable | undefined;
    private _autoApply?;
    get autoApply(): boolean | cdktf.IResolvable;
    set autoApply(value: boolean | cdktf.IResolvable);
    resetAutoApply(): void;
    get autoApplyInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _executionMode?;
    get executionMode(): string;
    set executionMode(value: string);
    resetExecutionMode(): void;
    get executionModeInput(): string | undefined;
    private _fileTriggersEnabled?;
    get fileTriggersEnabled(): boolean | cdktf.IResolvable;
    set fileTriggersEnabled(value: boolean | cdktf.IResolvable);
    resetFileTriggersEnabled(): void;
    get fileTriggersEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _globalRemoteState?;
    get globalRemoteState(): boolean | cdktf.IResolvable;
    set globalRemoteState(value: boolean | cdktf.IResolvable);
    resetGlobalRemoteState(): void;
    get globalRemoteStateInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operations?;
    get operations(): boolean | cdktf.IResolvable;
    set operations(value: boolean | cdktf.IResolvable);
    resetOperations(): void;
    get operationsInput(): boolean | cdktf.IResolvable | undefined;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    private _queueAllRuns?;
    get queueAllRuns(): boolean | cdktf.IResolvable;
    set queueAllRuns(value: boolean | cdktf.IResolvable);
    resetQueueAllRuns(): void;
    get queueAllRunsInput(): boolean | cdktf.IResolvable | undefined;
    private _remoteStateConsumerIds?;
    get remoteStateConsumerIds(): string[];
    set remoteStateConsumerIds(value: string[]);
    resetRemoteStateConsumerIds(): void;
    get remoteStateConsumerIdsInput(): string[] | undefined;
    private _speculativeEnabled?;
    get speculativeEnabled(): boolean | cdktf.IResolvable;
    set speculativeEnabled(value: boolean | cdktf.IResolvable);
    resetSpeculativeEnabled(): void;
    get speculativeEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sshKeyId?;
    get sshKeyId(): string;
    set sshKeyId(value: string);
    resetSshKeyId(): void;
    get sshKeyIdInput(): string | undefined;
    private _structuredRunOutputEnabled?;
    get structuredRunOutputEnabled(): boolean | cdktf.IResolvable;
    set structuredRunOutputEnabled(value: boolean | cdktf.IResolvable);
    resetStructuredRunOutputEnabled(): void;
    get structuredRunOutputEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tagNames?;
    get tagNames(): string[];
    set tagNames(value: string[]);
    resetTagNames(): void;
    get tagNamesInput(): string[] | undefined;
    private _terraformVersion?;
    get terraformVersion(): string;
    set terraformVersion(value: string);
    resetTerraformVersion(): void;
    get terraformVersionInput(): string | undefined;
    private _triggerPrefixes?;
    get triggerPrefixes(): string[];
    set triggerPrefixes(value: string[]);
    resetTriggerPrefixes(): void;
    get triggerPrefixesInput(): string[] | undefined;
    private _workingDirectory?;
    get workingDirectory(): string;
    set workingDirectory(value: string);
    resetWorkingDirectory(): void;
    get workingDirectoryInput(): string | undefined;
    private _vcsRepo;
    get vcsRepo(): WorkspaceVcsRepoOutputReference;
    putVcsRepo(value: WorkspaceVcsRepo): void;
    resetVcsRepo(): void;
    get vcsRepoInput(): WorkspaceVcsRepo | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
