"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Workspace = exports.WorkspaceVcsRepoOutputReference = exports.workspaceVcsRepoToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function workspaceVcsRepoToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        branch: cdktf.stringToTerraform(struct.branch),
        identifier: cdktf.stringToTerraform(struct.identifier),
        ingress_submodules: cdktf.booleanToTerraform(struct.ingressSubmodules),
        oauth_token_id: cdktf.stringToTerraform(struct.oauthTokenId),
    };
}
exports.workspaceVcsRepoToTerraform = workspaceVcsRepoToTerraform;
class WorkspaceVcsRepoOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._branch !== undefined) {
            hasAnyValues = true;
            internalValueResult.branch = this._branch;
        }
        if (this._identifier !== undefined) {
            hasAnyValues = true;
            internalValueResult.identifier = this._identifier;
        }
        if (this._ingressSubmodules !== undefined) {
            hasAnyValues = true;
            internalValueResult.ingressSubmodules = this._ingressSubmodules;
        }
        if (this._oauthTokenId !== undefined) {
            hasAnyValues = true;
            internalValueResult.oauthTokenId = this._oauthTokenId;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._branch = undefined;
            this._identifier = undefined;
            this._ingressSubmodules = undefined;
            this._oauthTokenId = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._branch = value.branch;
            this._identifier = value.identifier;
            this._ingressSubmodules = value.ingressSubmodules;
            this._oauthTokenId = value.oauthTokenId;
        }
    }
    get branch() {
        return this.getStringAttribute('branch');
    }
    set branch(value) {
        this._branch = value;
    }
    resetBranch() {
        this._branch = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get branchInput() {
        return this._branch;
    }
    get identifier() {
        return this.getStringAttribute('identifier');
    }
    set identifier(value) {
        this._identifier = value;
    }
    // Temporarily expose input value. Use with caution.
    get identifierInput() {
        return this._identifier;
    }
    get ingressSubmodules() {
        return this.getBooleanAttribute('ingress_submodules');
    }
    set ingressSubmodules(value) {
        this._ingressSubmodules = value;
    }
    resetIngressSubmodules() {
        this._ingressSubmodules = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ingressSubmodulesInput() {
        return this._ingressSubmodules;
    }
    get oauthTokenId() {
        return this.getStringAttribute('oauth_token_id');
    }
    set oauthTokenId(value) {
        this._oauthTokenId = value;
    }
    // Temporarily expose input value. Use with caution.
    get oauthTokenIdInput() {
        return this._oauthTokenId;
    }
}
exports.WorkspaceVcsRepoOutputReference = WorkspaceVcsRepoOutputReference;
_a = JSII_RTTI_SYMBOL_1;
WorkspaceVcsRepoOutputReference[_a] = { fqn: "@cdktf/provider-tfe.WorkspaceVcsRepoOutputReference", version: "0.1.49" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/tfe/r/workspace tfe_workspace}
*/
class Workspace extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/tfe/r/workspace tfe_workspace} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WorkspaceConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'tfe_workspace',
            terraformGeneratorMetadata: {
                providerName: 'tfe'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // vcs_repo - computed: false, optional: true, required: false
        this._vcsRepo = new WorkspaceVcsRepoOutputReference(this, "vcs_repo", true);
        this._agentPoolId = config.agentPoolId;
        this._allowDestroyPlan = config.allowDestroyPlan;
        this._autoApply = config.autoApply;
        this._description = config.description;
        this._executionMode = config.executionMode;
        this._fileTriggersEnabled = config.fileTriggersEnabled;
        this._globalRemoteState = config.globalRemoteState;
        this._name = config.name;
        this._operations = config.operations;
        this._organization = config.organization;
        this._queueAllRuns = config.queueAllRuns;
        this._remoteStateConsumerIds = config.remoteStateConsumerIds;
        this._speculativeEnabled = config.speculativeEnabled;
        this._sshKeyId = config.sshKeyId;
        this._structuredRunOutputEnabled = config.structuredRunOutputEnabled;
        this._tagNames = config.tagNames;
        this._terraformVersion = config.terraformVersion;
        this._triggerPrefixes = config.triggerPrefixes;
        this._workingDirectory = config.workingDirectory;
        this._vcsRepo.internalValue = config.vcsRepo;
    }
    get agentPoolId() {
        return this.getStringAttribute('agent_pool_id');
    }
    set agentPoolId(value) {
        this._agentPoolId = value;
    }
    resetAgentPoolId() {
        this._agentPoolId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get agentPoolIdInput() {
        return this._agentPoolId;
    }
    get allowDestroyPlan() {
        return this.getBooleanAttribute('allow_destroy_plan');
    }
    set allowDestroyPlan(value) {
        this._allowDestroyPlan = value;
    }
    resetAllowDestroyPlan() {
        this._allowDestroyPlan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowDestroyPlanInput() {
        return this._allowDestroyPlan;
    }
    get autoApply() {
        return this.getBooleanAttribute('auto_apply');
    }
    set autoApply(value) {
        this._autoApply = value;
    }
    resetAutoApply() {
        this._autoApply = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoApplyInput() {
        return this._autoApply;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get executionMode() {
        return this.getStringAttribute('execution_mode');
    }
    set executionMode(value) {
        this._executionMode = value;
    }
    resetExecutionMode() {
        this._executionMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get executionModeInput() {
        return this._executionMode;
    }
    get fileTriggersEnabled() {
        return this.getBooleanAttribute('file_triggers_enabled');
    }
    set fileTriggersEnabled(value) {
        this._fileTriggersEnabled = value;
    }
    resetFileTriggersEnabled() {
        this._fileTriggersEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fileTriggersEnabledInput() {
        return this._fileTriggersEnabled;
    }
    get globalRemoteState() {
        return this.getBooleanAttribute('global_remote_state');
    }
    set globalRemoteState(value) {
        this._globalRemoteState = value;
    }
    resetGlobalRemoteState() {
        this._globalRemoteState = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get globalRemoteStateInput() {
        return this._globalRemoteState;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get operations() {
        return this.getBooleanAttribute('operations');
    }
    set operations(value) {
        this._operations = value;
    }
    resetOperations() {
        this._operations = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operationsInput() {
        return this._operations;
    }
    get organization() {
        return this.getStringAttribute('organization');
    }
    set organization(value) {
        this._organization = value;
    }
    // Temporarily expose input value. Use with caution.
    get organizationInput() {
        return this._organization;
    }
    get queueAllRuns() {
        return this.getBooleanAttribute('queue_all_runs');
    }
    set queueAllRuns(value) {
        this._queueAllRuns = value;
    }
    resetQueueAllRuns() {
        this._queueAllRuns = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get queueAllRunsInput() {
        return this._queueAllRuns;
    }
    get remoteStateConsumerIds() {
        return cdktf.Fn.tolist(this.getListAttribute('remote_state_consumer_ids'));
    }
    set remoteStateConsumerIds(value) {
        this._remoteStateConsumerIds = value;
    }
    resetRemoteStateConsumerIds() {
        this._remoteStateConsumerIds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get remoteStateConsumerIdsInput() {
        return this._remoteStateConsumerIds;
    }
    get speculativeEnabled() {
        return this.getBooleanAttribute('speculative_enabled');
    }
    set speculativeEnabled(value) {
        this._speculativeEnabled = value;
    }
    resetSpeculativeEnabled() {
        this._speculativeEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get speculativeEnabledInput() {
        return this._speculativeEnabled;
    }
    get sshKeyId() {
        return this.getStringAttribute('ssh_key_id');
    }
    set sshKeyId(value) {
        this._sshKeyId = value;
    }
    resetSshKeyId() {
        this._sshKeyId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sshKeyIdInput() {
        return this._sshKeyId;
    }
    get structuredRunOutputEnabled() {
        return this.getBooleanAttribute('structured_run_output_enabled');
    }
    set structuredRunOutputEnabled(value) {
        this._structuredRunOutputEnabled = value;
    }
    resetStructuredRunOutputEnabled() {
        this._structuredRunOutputEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get structuredRunOutputEnabledInput() {
        return this._structuredRunOutputEnabled;
    }
    get tagNames() {
        return cdktf.Fn.tolist(this.getListAttribute('tag_names'));
    }
    set tagNames(value) {
        this._tagNames = value;
    }
    resetTagNames() {
        this._tagNames = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagNamesInput() {
        return this._tagNames;
    }
    get terraformVersion() {
        return this.getStringAttribute('terraform_version');
    }
    set terraformVersion(value) {
        this._terraformVersion = value;
    }
    resetTerraformVersion() {
        this._terraformVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get terraformVersionInput() {
        return this._terraformVersion;
    }
    get triggerPrefixes() {
        return this.getListAttribute('trigger_prefixes');
    }
    set triggerPrefixes(value) {
        this._triggerPrefixes = value;
    }
    resetTriggerPrefixes() {
        this._triggerPrefixes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get triggerPrefixesInput() {
        return this._triggerPrefixes;
    }
    get workingDirectory() {
        return this.getStringAttribute('working_directory');
    }
    set workingDirectory(value) {
        this._workingDirectory = value;
    }
    resetWorkingDirectory() {
        this._workingDirectory = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get workingDirectoryInput() {
        return this._workingDirectory;
    }
    get vcsRepo() {
        return this._vcsRepo;
    }
    putVcsRepo(value) {
        this._vcsRepo.internalValue = value;
    }
    resetVcsRepo() {
        this._vcsRepo.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vcsRepoInput() {
        return this._vcsRepo.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            agent_pool_id: cdktf.stringToTerraform(this._agentPoolId),
            allow_destroy_plan: cdktf.booleanToTerraform(this._allowDestroyPlan),
            auto_apply: cdktf.booleanToTerraform(this._autoApply),
            description: cdktf.stringToTerraform(this._description),
            execution_mode: cdktf.stringToTerraform(this._executionMode),
            file_triggers_enabled: cdktf.booleanToTerraform(this._fileTriggersEnabled),
            global_remote_state: cdktf.booleanToTerraform(this._globalRemoteState),
            name: cdktf.stringToTerraform(this._name),
            operations: cdktf.booleanToTerraform(this._operations),
            organization: cdktf.stringToTerraform(this._organization),
            queue_all_runs: cdktf.booleanToTerraform(this._queueAllRuns),
            remote_state_consumer_ids: cdktf.listMapper(cdktf.stringToTerraform)(this._remoteStateConsumerIds),
            speculative_enabled: cdktf.booleanToTerraform(this._speculativeEnabled),
            ssh_key_id: cdktf.stringToTerraform(this._sshKeyId),
            structured_run_output_enabled: cdktf.booleanToTerraform(this._structuredRunOutputEnabled),
            tag_names: cdktf.listMapper(cdktf.stringToTerraform)(this._tagNames),
            terraform_version: cdktf.stringToTerraform(this._terraformVersion),
            trigger_prefixes: cdktf.listMapper(cdktf.stringToTerraform)(this._triggerPrefixes),
            working_directory: cdktf.stringToTerraform(this._workingDirectory),
            vcs_repo: workspaceVcsRepoToTerraform(this._vcsRepo.internalValue),
        };
    }
}
exports.Workspace = Workspace;
_b = JSII_RTTI_SYMBOL_1;
Workspace[_b] = { fqn: "@cdktf/provider-tfe.Workspace", version: "0.1.49" };
// =================
// STATIC PROPERTIES
// =================
Workspace.tfResourceType = "tfe_workspace";
//# sourceMappingURL=data:application/json;base64,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