//ϵͳ
#ifdef WIN32
#include "stdafx.h"
#endif

#include "vnxtp.h"
#include "pybind11/pybind11.h"
#include "xtp/xtp_trader_api.h"


using namespace pybind11;
using namespace XTP::API;


///-------------------------------------------------------------------------------------
///C++ SPIĻصʵ
///-------------------------------------------------------------------------------------

//APIļ̳ʵ
class TdApi : public TraderSpi
{
private:
	TraderApi* api = NULL;            //API
	bool active = false;       //״̬

public:
	TdApi()
	{
	};

	~TdApi()
	{
		if (this->active)
		{
			this->exit();
		}
	};

	//-------------------------------------------------------------------------------------
	//APIص
	//-------------------------------------------------------------------------------------

	///ͻ˵ĳ뽻׺̨ͨӶϿʱ÷á
	///@param reason ԭӦ
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ûlogoutµĶߣᴥ˺apiԶ߷ʱûѡڴ˺еLoginµ¼session_idʱûյݸ֮ǰ
	virtual void OnDisconnected(uint64_t session_id, int reason);

	///Ӧ
	///@param error_info ӦʱľĴʹϢ,error_infoΪգerror_info.error_idΪ0ʱûд
	///@remark ˺ֻڷʱŻãһû
	virtual void OnError(XTPRI *error_info);

	///֪ͨ
	///@param order_info ӦϢûͨorder_info.order_xtp_idͨGetClientIDByXTPID() == client_idԼĶorder_info.qty_leftֶڶΪδɽɡȫɡϵ״̬ʱʾ˶ûгɽڲȫ״̬ʱʾ˶order_info.order_cancel_xtp_idΪӦĳIDΪ0ʱʾ˵ɹ
	///@param error_info ܾ߷ʱʹϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ÿζ״̬ʱᱻãҪٷأϢʱᴥߣڶδɽȫɽȫֳѾܾЩ״̬ʱӦڲֳɽɶĳɽرȷϡе¼˴ûĿͻ˶յûĶӦ
	virtual void OnOrderEvent(XTPOrderInfo *order_info, XTPRI *error_info, uint64_t session_id);

	///ɽ֪ͨ
	///@param trade_info ɽرľϢûͨtrade_info.order_xtp_idͨGetClientIDByXTPID() == client_idԼĶϽexec_idΨһʶһʳɽ2ʳɽرӵͬexec_idΪ˱ʽԳɽˡexec_idΨһģʱ޴жϻơreport_index+marketֶοΨһʶʾɽر
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark гɽʱ򣬻ᱻãҪٷأϢʱᴥߡе¼˴ûĿͻ˶յûĳɽرضΪ״̬ҪûͨɽرĳɽȷOnOrderEvent()Ͳ״̬
	virtual void OnTradeEvent(XTPTradeReport *trade_info, uint64_t session_id);

	///Ӧ
	///@param cancel_info Ϣorder_cancel_xtp_idʹorder_xtp_id
	///@param error_info ܾ߷ʱʹϢҪٷأϢʱᴥߣerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark Ӧֻڳʱص
	virtual void OnCancelOrderError(XTPOrderCancelInfo *cancel_info, XTPRI *error_info, uint64_t session_id);

	///ѯӦ-°汾ӿ
	///@param order_info ѯһϢ
	///@param error_info ѯʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ַ֧ʱβѯһѯܶӦӦҪٷأϢʱᴥ
	virtual void OnQueryOrderEx(XTPOrderInfoEx *order_info, XTPRI *error_info, int request_id, bool is_last, uint64_t session_id);

	///ҳѯӦ-°汾ӿ
	///@param order_info ѯһ
	///@param req_count ҳ
	///@param order_sequence ҳĵǰر
	///@param query_reference ǰϢӦĲѯҪ¼ڽһηҳѯʱҪõ
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark order_sequenceΪ0βѯûв鵽κμ¼is_lastΪtrueʱorder_sequencereq_countôʾбԽһηҳѯȣʾбѾѯϡһѯܶӦӦҪٷأϢʱᴥߡ
	virtual void OnQueryOrderByPageEx(XTPOrderInfoEx *order_info, int64_t req_count, int64_t order_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id);

	///ѯɽӦ
	///@param trade_info ѯһɽر
	///@param error_info ѯɽرʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ַ֧ʱβѯһѯܶӦӦҪٷأϢʱᴥ
	virtual void OnQueryTrade(XTPQueryTradeRsp *trade_info, XTPRI *error_info, int request_id, bool is_last, uint64_t session_id);

	///ҳѯɽӦ
	///@param trade_info ѯһɽϢ
	///@param req_count ҳ
	///@param trade_sequence ҳĵǰر
	///@param query_reference ǰϢӦĲѯҪ¼ڽһηҳѯʱҪõ
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark trade_sequenceΪ0βѯûв鵽κμ¼is_lastΪtrueʱtrade_sequencereq_countôʾлرԽһηҳѯȣʾлرѾѯϡһѯܶӦӦҪٷأϢʱᴥߡ
	virtual void OnQueryTradeByPage(XTPQueryTradeRsp *trade_info, int64_t req_count, int64_t trade_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id);

	///ѯͶֲ߳Ӧ
	///@param position ѯһֻƱĳֲ
	///@param error_info ѯ˻ֲַʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ûܳжƱһѯܶӦӦҪٷأϢʱᴥ
	virtual void OnQueryPosition(XTPQueryStkPositionRsp *position, XTPRI *error_info, int request_id, bool is_last, uint64_t session_id);

	///ѯʽ˻ӦҪٷأϢʱᴥ
	///@param asset ѯʽ˻
	///@param error_info ѯʽ˻ʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ҪٷأϢʱᴥ
	virtual void OnQueryAsset(XTPQueryAssetRsp *asset, XTPRI *error_info, int request_id, bool is_last, uint64_t session_id);

	///ѯּϢӦҪٷأϢʱᴥ
	///@param fund_info ѯķּ
	///@param error_info ѯּʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ҪٷأϢʱᴥ
	virtual void OnQueryStructuredFund(XTPStructuredFundInfo *fund_info, XTPRI *error_info, int request_id, bool is_last, uint64_t session_id);

	///ѯʽ𻮲ӦҪٷأϢʱᴥ
	///@param fund_transfer_info ѯʽ˻
	///@param error_info ѯʽ˻ʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ҪٷأϢʱᴥ
	virtual void OnQueryFundTransfer(XTPFundTransferNotice *fund_transfer_info, XTPRI *error_info, int request_id, bool is_last, uint64_t session_id);

	///ʽ𻮲֪ͨ
	///@param fund_transfer_info ʽ𻮲֪ͨľϢûͨfund_transfer_info.serial_idͨGetClientIDByXTPID() == client_idԼĶ
	///@param error_info ʽ𻮲ܾ߷ʱʹϢerror_infoΪգerror_info.error_idΪ0ʱûд󡣵ʽ𻮲ΪһĽڵ֮仮error_info.error_id=11000384ʱerror_info.error_msgΪпڻʽΪ׼ûstringToIntתɾݴдʵʽٴη𻮲
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ʽ𻮲״̬仯ʱ򣬻ᱻãҪٷأϢʱᴥߡе¼˴ûĿͻ˶յûʽ𻮲֪ͨ
	virtual void OnFundTransfer(XTPFundTransferNotice *fund_transfer_info, XTPRI *error_info, uint64_t session_id);

	///ѯڵʽӦҪٷأϢʱᴥ
	///@param fund_info ѯڵʽ
	///@param error_info ѯڵʽʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ҪٷأϢʱᴥ
	virtual void OnQueryOtherServerFund(XTPFundQueryRsp *fund_info, XTPRI *error_info, int request_id, uint64_t session_id);

	///ѯETF嵥ļӦҪٷأϢʱᴥ
	///@param etf_info ѯETF嵥ļ
	///@param error_info ѯETF嵥ļʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ҪٷأϢʱᴥ
	virtual void OnQueryETF(XTPQueryETFBaseRsp *etf_info, XTPRI *error_info, int request_id, bool is_last, uint64_t session_id);

	///ѯETFƱӦҪٷأϢʱᴥ
	///@param etf_component_info ѯETFԼسɷֹϢ
	///@param error_info ѯETFƱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ҪٷأϢʱᴥ
	virtual void OnQueryETFBasket(XTPQueryETFComponentRsp *etf_component_info, XTPRI *error_info, int request_id, bool is_last, uint64_t session_id);

	///ѯ¹깺ϢбӦҪٷأϢʱᴥ
	///@param ipo_info ѯĽ¹깺һֻƱϢ
	///@param error_info ѯ¹깺ϢбʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ҪٷأϢʱᴥ
	virtual void OnQueryIPOInfoList(XTPQueryIPOTickerRsp *ipo_info, XTPRI *error_info, int request_id, bool is_last, uint64_t session_id);

	///ѯû¹깺ϢӦҪٷأϢʱᴥ
	///@param quota_info ѯûĳгĽ¹깺Ϣ
	///@param error_info ѯû¹깺ϢʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ҪٷأϢʱᴥ
	virtual void OnQueryIPOQuotaInfo(XTPQueryIPOQuotaRsp *quota_info, XTPRI *error_info, int request_id, bool is_last, uint64_t session_id);

	///ѯȨԼӦҪٷأϢʱᴥ
	///@param option_info ѯȨԼ
	///@param error_info ѯȨԼʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ҪٷأϢʱᴥ
	virtual void OnQueryOptionAuctionInfo(XTPQueryOptionAuctionInfoRsp *option_info, XTPRI *error_info, int request_id, bool is_last, uint64_t session_id);

	///ȯҵֱֽӻӦ
	///@param cash_repay_info ֱֽӻ֪ͨľϢûͨcash_repay_info.xtp_idͨGetClientIDByXTPID() == client_idԼĶ
	///@param error_info ֽ𻹿ʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ҪٷأϢʱᴥ
	virtual void OnCreditCashRepay(XTPCrdCashRepayRsp *cash_repay_info, XTPRI *error_info, uint64_t session_id);

	///ȯҵֽϢӦ
	///@param cash_repay_info ֽϢ֪ͨľϢûͨcash_repay_info.xtp_idͨGetClientIDByXTPID() == client_idԼĶ
	///@param error_info ֽϢʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ҪٷأϢʱᴥ
	virtual void OnCreditCashRepayDebtInterestFee(XTPCrdCashRepayDebtInterestFeeRsp *cash_repay_info, XTPRI *error_info, uint64_t session_id);

	///ѯȯҵеֱֽӻӦ
	///@param cash_repay_info ѯĳһֱֽӻ֪ͨľϢ
	///@param error_info ѯֱֽӱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ҪٷأϢʱᴥ
	virtual void OnQueryCreditCashRepayInfo(XTPCrdCashRepayInfo *cash_repay_info, XTPRI *error_info, int request_id, bool is_last, uint64_t session_id);

	///ѯ˻ϢӦҪٷأϢʱᴥ
	///@param fund_info ѯ˻Ϣ
	///@param error_info ѯ˻ϢʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ҪٷأϢʱᴥ
	virtual void OnQueryCreditFundInfo(XTPCrdFundInfo *fund_info, XTPRI *error_info, int request_id, uint64_t session_id);

	///ѯ˻ծϢӦҪٷأϢʱᴥ
	///@param debt_info ѯ˻Լծ
	///@param error_info ѯ˻ծϢʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ҪٷأϢʱᴥ
	virtual void OnQueryCreditDebtInfo(XTPCrdDebtInfo *debt_info, XTPRI *error_info, int request_id, bool is_last, uint64_t session_id);

	///ѯ˻ָ֤ȯծδϢӦҪٷأϢʱᴥ
	///@param debt_info ѯ˻ָ֤ȯծδϢ
	///@param error_info ѯ˻ָ֤ȯծδϢʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ҪٷأϢʱᴥ
	virtual void OnQueryCreditTickerDebtInfo(XTPCrdDebtStockInfo *debt_info, XTPRI *error_info, int request_id, bool is_last, uint64_t session_id);

	///ѯ˻ʽӦҪٷأϢʱᴥ
	///@param remain_amount ѯ˻ʽ
	///@param error_info ѯ˻ʽʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ҪٷأϢʱᴥ
	virtual void OnQueryCreditAssetDebtInfo(double remain_amount, XTPRI *error_info, int request_id, uint64_t session_id);

	///ѯ˻ȯͷϢӦҪٷأϢʱᴥ
	///@param assign_info ѯ˻ȯͷϢ
	///@param error_info ѯ˻ȯͷϢʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ҪٷأϢʱᴥ
	virtual void OnQueryCreditTickerAssignInfo(XTPClientQueryCrdPositionStkInfo *assign_info, XTPRI *error_info, int request_id, bool is_last, uint64_t session_id);

	///ȯҵѯָȯϢӦҪٷأϢʱᴥ
	///@param stock_info ѯȯϢ
	///@param error_info ѯ˻ȯϢʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ҪٷأϢʱᴥ
	virtual void OnQueryCreditExcessStock(XTPClientQueryCrdSurplusStkRspInfo* stock_info, XTPRI *error_info, int request_id, uint64_t session_id);

	///ȯҵѯȯϢӦҪٷأϢʱᴥ
	///@param stock_info ѯȯϢ
	///@param error_info ѯ˻ȯϢʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@remark ҪٷأϢʱᴥ
	virtual void OnQueryMulCreditExcessStock(XTPClientQueryCrdSurplusStkRspInfo* stock_info, XTPRI *error_info, int request_id, uint64_t session_id, bool is_last);

	///ȯҵиծԼչڵ֪ͨ
	///@param debt_extend_info ծԼչ֪ͨľϢûͨdebt_extend_info.xtpidͨGetClientIDByXTPID() == client_idԼĶ
	///@param error_info ծԼչڶܾ߷ʱʹϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ծԼչڶ״̬仯ʱ򣬻ᱻãҪٷأϢʱᴥߡе¼˴ûĿͻ˶յûĸծԼչ֪ͨ
	virtual void OnCreditExtendDebtDate(XTPCreditDebtExtendNotice *debt_extend_info, XTPRI *error_info, uint64_t session_id);

	///ѯȯҵиծԼչڶӦҪٷأϢʱᴥ
	///@param debt_extend_info ѯĸծԼչ
	///@param error_info ѯծԼչڷʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд󡣵error_info.error_id=11000350ʱûм¼Ϊ0ֵʱԼܵʱĴԭ
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ҪٷأϢʱᴥ
	virtual void OnQueryCreditExtendDebtDateOrders(XTPCreditDebtExtendNotice *debt_extend_info, XTPRI *error_info, int request_id, bool is_last, uint64_t session_id);

	///ѯȯҵ˻ϢӦҪٷأϢʱᴥ
	///@param fund_info ˻Ϣ
	///@param error_info ѯ˻ϢʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ҪٷأϢʱᴥ
	virtual void OnQueryCreditFundExtraInfo(XTPCrdFundExtraInfo *fund_info, XTPRI *error_info, int request_id, uint64_t session_id);

	///ѯȯҵ˻ָ֤ȯĸϢӦҪٷأϢʱᴥ
	///@param fund_info ˻ָ֤ȯĸϢ
	///@param error_info ѯ˻ϢʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ҪٷأϢʱᴥ
	virtual void OnQueryCreditPositionExtraInfo(XTPCrdPositionExtraInfo *fund_info, XTPRI *error_info, int request_id, bool is_last, uint64_t session_id);

	///ȨϲԱ֪ͨ
	///@param order_info ӦϢûͨorder_info.order_xtp_idͨGetClientIDByXTPID() == client_idԼĶorder_info.qty_leftֶڶΪδɽɡȫɡϵ״̬ʱʾ˶ûгɽڲȫ״̬ʱʾ˶order_info.order_cancel_xtp_idΪӦĳIDΪ0ʱʾ˵ɹ
	///@param error_info ܾ߷ʱʹϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ÿζ״̬ʱᱻãҪٷأϢʱᴥߣڶδɽȫɽȫֳѾܾЩ״̬ʱӦڲֳɽɶĳɽرȷϡе¼˴ûĿͻ˶յûĶӦ
	virtual void OnOptionCombinedOrderEvent(XTPOptCombOrderInfo *order_info, XTPRI *error_info, uint64_t session_id);

	///ȨϲԳɽ֪ͨ
	///@param trade_info ɽرľϢûͨtrade_info.order_xtp_idͨGetClientIDByXTPID() == client_idԼĶϽexec_idΨһʶһʳɽ2ʳɽرӵͬexec_idΪ˱ʽԳɽˡexec_idΨһģʱ޴жϻơreport_index+marketֶοΨһʶʾɽر
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark гɽʱ򣬻ᱻãҪٷأϢʱᴥߡе¼˴ûĿͻ˶յûĳɽرضΪ״̬ҪûͨɽرĳɽȷOnOrderEvent()Ͳ״̬
	virtual void OnOptionCombinedTradeEvent(XTPOptCombTradeReport *trade_info, uint64_t session_id);

	///ȨϲԳӦ
	///@param cancel_info Ϣorder_cancel_xtp_idʹorder_xtp_id
	///@param error_info ܾ߷ʱʹϢҪٷأϢʱᴥߣerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark Ӧֻڳʱص
	virtual void OnCancelOptionCombinedOrderError(XTPOptCombOrderCancelInfo *cancel_info, XTPRI *error_info, uint64_t session_id);

	///ѯȨϲԱӦ-°汾ӿ
	///@param order_info ѯһ
	///@param error_info ѯʱʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ַ֧ʱβѯһѯܶӦӦҪٷأϢʱᴥߡ˶Ӧѯʹãʱû·ӵ£api
	virtual void OnQueryOptionCombinedOrdersEx(XTPOptCombOrderInfoEx *order_info, XTPRI *error_info, int request_id, bool is_last, uint64_t session_id);

	///ҳѯȨϲԱӦ-°汾ӿ
	///@param order_info ѯһ
	///@param req_count ҳ
	///@param order_sequence ҳĵǰر
	///@param query_reference ǰϢӦĲѯҪ¼ڽһηҳѯʱҪõ
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark order_sequenceΪ0βѯûв鵽κμ¼is_lastΪtrueʱorder_sequencereq_countôʾбԽһηҳѯȣʾбѾѯϡһѯܶӦӦҪٷأϢʱᴥߡ
	virtual void OnQueryOptionCombinedOrdersByPageEx(XTPOptCombOrderInfoEx *order_info, int64_t req_count, int64_t order_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id);

	///ѯȨϲԳɽӦ
	///@param trade_info ѯһɽر
	///@param error_info ѯɽرʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark ַ֧ʱβѯһѯܶӦӦҪٷأϢʱᴥߡ˶Ӧѯʹãʱû·ӵ£api
	virtual void OnQueryOptionCombinedTrades(XTPQueryOptCombTradeRsp *trade_info, XTPRI *error_info, int request_id, bool is_last, uint64_t session_id);

	///ҳѯȨϲԳɽӦ
	///@param trade_info ѯһɽϢ
	///@param req_count ҳ
	///@param trade_sequence ҳĵǰر
	///@param query_reference ǰϢӦĲѯҪ¼ڽһηҳѯʱҪõ
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark trade_sequenceΪ0βѯûв鵽κμ¼is_lastΪtrueʱtrade_sequencereq_countôʾлرԽһηҳѯȣʾлرѾѯϡһѯܶӦӦҪٷأϢʱᴥߡ
	virtual void OnQueryOptionCombinedTradesByPage(XTPQueryOptCombTradeRsp *trade_info, int64_t req_count, int64_t trade_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id);

	///ѯȨϲԳֲӦ
	///@param position_info ѯһֲϢ
	///@param error_info ѯֲַʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark һѯܶӦӦҪٷأϢʱᴥߡ
	virtual void OnQueryOptionCombinedPosition(XTPQueryOptCombPositionRsp *position_info, XTPRI *error_info, int request_id, bool is_last, uint64_t session_id);

	///ѯȨϲϢӦ
	///@param strategy_info ѯһϲϢ
	///@param error_info ѯɽرʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark һѯܶӦӦҪٷأϢʱᴥߡ
	virtual void OnQueryOptionCombinedStrategyInfo(XTPQueryCombineStrategyInfoRsp *strategy_info, XTPRI *error_info, int request_id, bool is_last, uint64_t session_id);

	///ѯȨȨϲͷӦ
	///@param position_info ѯһȨϲͷϢ
	///@param error_info ѯֲַʱصĴϢerror_infoΪգerror_info.error_idΪ0ʱûд
	///@param request_id ϢӦӦID
	///@param is_last ϢӦǷΪrequest_idӦһӦΪһʱΪtrueΪfalseʾϢӦ
	///@param session_id ʽ˻Ӧsession_id¼ʱõ
	///@remark һѯܶӦӦҪٷأϢʱᴥߡ
	virtual void OnQueryOptionCombinedExecPosition(XTPQueryOptCombExecPosRsp *position_info, XTPRI *error_info, int request_id, bool is_last, uint64_t session_id);

	//-------------------------------------------------------------------------------------
	//dataصֵ
	//errorصĴֵ
	//-------------------------------------------------------------------------------------

	virtual void onDisconnected(uint64_t session_id, int reason) {};

	virtual void onError(const dict &error) {};

	virtual void onOrderEvent(const dict &data, const dict &error, uint64_t session_id) {};

	virtual void onTradeEvent(const dict &data, uint64_t session_id) {};

	virtual void onCancelOrderError(const dict &data, const dict &error, uint64_t session_id) {};

	virtual void onQueryOrderEx(const dict &data, const dict &error, int request_id, bool is_last, uint64_t session_id) {};

	virtual void onQueryOrderByPageEx(const dict &data, int64_t req_count, int64_t order_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id) {};

	virtual void onQueryTrade(const dict &data, const dict &error, int request_id, bool is_last, uint64_t session_id) {};

	virtual void onQueryTradeByPage(const dict &data, int64_t req_count, int64_t trade_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id) {};

	virtual void onQueryPosition(const dict &data, const dict &error, int request_id, bool is_last, uint64_t session_id) {};

	virtual void onQueryAsset(const dict &data, const dict &error, int request_id, bool is_last, uint64_t session_id) {};

	virtual void onQueryStructuredFund(const dict &data, const dict &error, int request_id, bool is_last, uint64_t session_id) {};

	virtual void onQueryFundTransfer(const dict &data, const dict &error, int request_id, bool is_last, uint64_t session_id) {};

	virtual void onFundTransfer(const dict &data, const dict &error, uint64_t session_id) {};

	virtual void onQueryOtherServerFund(const dict &data, const dict &error, int request_id, uint64_t session_id) {};

	virtual void onQueryETF(const dict &data, const dict &error, int request_id, bool is_last, uint64_t session_id) {};

	virtual void onQueryETFBasket(const dict &data, const dict &error, int request_id, bool is_last, uint64_t session_id) {};

	virtual void onQueryIPOInfoList(const dict &data, const dict &error, int request_id, bool is_last, uint64_t session_id) {};

	virtual void onQueryIPOQuotaInfo(const dict &data, const dict &error, int request_id, bool is_last, uint64_t session_id) {};

	virtual void onQueryOptionAuctionInfo(const dict &data, const dict &error, int request_id, bool is_last, uint64_t session_id) {};

	virtual void onCreditCashRepay(const dict &data, const dict &error, uint64_t session_id) {};

	virtual void onCreditCashRepayDebtInterestFee(const dict &data, const dict &error, uint64_t session_id) {};

	virtual void onQueryCreditCashRepayInfo(const dict &data, const dict &error, int request_id, bool is_last, uint64_t session_id) {};

	virtual void onQueryCreditFundInfo(const dict &data, const dict &error, int request_id, uint64_t session_id) {};

	virtual void onQueryCreditDebtInfo(const dict &data, const dict &error, int request_id, bool is_last, uint64_t session_id) {};

	virtual void onQueryCreditTickerDebtInfo(const dict &data, const dict &error, int request_id, bool is_last, uint64_t session_id) {};

	virtual void onQueryCreditAssetDebtInfo(double remain_amount, const dict &error, int request_id, uint64_t session_id) {};

	virtual void onQueryCreditTickerAssignInfo(const dict &data, const dict &error, int request_id, bool is_last, uint64_t session_id) {};

	virtual void onQueryCreditExcessStock(const dict &data, const dict &error, int request_id, uint64_t session_id) {};

	virtual void onQueryMulCreditExcessStock(const dict &data, const dict &error, int request_id, uint64_t session_id, bool is_last) {};

	virtual void onCreditExtendDebtDate(const dict &data, const dict &error, uint64_t session_id) {};

	virtual void onQueryCreditExtendDebtDateOrders(const dict &data, const dict &error, int request_id, bool is_last, uint64_t session_id) {};

	virtual void onQueryCreditFundExtraInfo(const dict &data, const dict &error, int request_id, uint64_t session_id) {};

	virtual void onQueryCreditPositionExtraInfo(const dict &data, const dict &error, int request_id, bool is_last, uint64_t session_id) {};

	virtual void onOptionCombinedOrderEvent(const dict &data, const dict &error, uint64_t session_id) {};

	virtual void onOptionCombinedTradeEvent(const dict &data, uint64_t session_id) {};

	virtual void onCancelOptionCombinedOrderError(const dict &data, const dict &error, uint64_t session_id) {};

	virtual void onQueryOptionCombinedOrdersEx(const dict &data, const dict &error, int request_id, bool is_last, uint64_t session_id) {};

	virtual void onQueryOptionCombinedOrdersByPageEx(const dict &data, int64_t req_count, int64_t order_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id) {};

	virtual void onQueryOptionCombinedTrades(const dict &data, const dict &error, int request_id, bool is_last, uint64_t session_id) {};

	virtual void onQueryOptionCombinedTradesByPage(const dict &data, int64_t req_count, int64_t trade_sequence, int64_t query_reference, int request_id, bool is_last, uint64_t session_id) {};

	virtual void onQueryOptionCombinedPosition(const dict &data, const dict &error, int request_id, bool is_last, uint64_t session_id) {};

	virtual void onQueryOptionCombinedStrategyInfo(const dict &data, const dict &error, int request_id, bool is_last, uint64_t session_id) {};

	virtual void onQueryOptionCombinedExecPosition(const dict &data, const dict &error, int request_id, bool is_last, uint64_t session_id) {};

	//-------------------------------------------------------------------------------------
	//req:ֵ
	//-------------------------------------------------------------------------------------

	void createTraderApi(int client_id, string save_file_path, int log_level);

	void release();

	void init();

	int exit();

	string getTradingDay();

	string getApiVersion();

	dict getApiLastError();

	int getClientIDByXTPID(uint64_t order_xtp_id);

	string getAccountByXTPID(uint64_t order_xtp_id);

	void subscribePublicTopic(int resume_type);

	void setSoftwareVersion(string version);

	void setSoftwareKey(string key);

	void setHeartBeatInterval(int interval);

	uint64_t login(string ip, int port, string user, string password, int sock_type);

	int logout(uint64_t session_id);

	bool isServerRestart(uint64_t session_id);

	int modifyUserTerminalInfo(const dict &req, uint64_t session_id);

	uint64_t insertOrder(const dict &req, uint64_t session_id);

	uint64_t cancelOrder(uint64_t order_xtp_id, uint64_t session_id);

	int queryOrderByXTPIDEx(const uint64_t order_xtp_id, uint64_t session_id, int request_id);

	int queryOrdersEx(const dict &req, uint64_t session_id, int request_id);

	int queryUnfinishedOrdersEx(uint64_t session_id, int request_id);

	int queryOrdersByPageEx(const dict &req, uint64_t session_id, int request_id);

	int queryTradesByXTPID(uint64_t order_xtp_id, uint64_t session_id, int request_id);

	int queryTrades(const dict &req, uint64_t session_id, int request_id);

	int queryTradesByPage(const dict &req, uint64_t session_id, int request_id);

	int queryPosition(string ticker, uint64_t session_id, int request_id);

	int queryAsset(uint64_t session_id, int request_id);

	int queryStructuredFund(const dict &req, uint64_t session_id, int request_id);

	int queryFundTransfer(const dict &req, uint64_t session_id, int request_id);

	int queryOtherServerFund(const dict &req, uint64_t session_id, int request_id);

	int queryETF(const dict &req, uint64_t session_id, int request_id);

	int queryETFTickerBasket(const dict &req, uint64_t session_id, int request_id);

	int queryIPOInfoList(uint64_t session_id, int request_id);

	int queryIPOQuotaInfo(uint64_t session_id, int request_id);

	int queryOptionAuctionInfo(const dict &req, uint64_t session_id, int request_id);

	int queryCreditCashRepayInfo(uint64_t session_id, int request_id);

	int queryCreditFundInfo(uint64_t session_id, int request_id);

	int queryCreditDebtInfo(uint64_t session_id, int request_id);

	int queryCreditTickerDebtInfo(const dict &req, uint64_t session_id, int request_id);

	int queryCreditAssetDebtInfo(uint64_t session_id, int request_id);

	int queryCreditTickerAssignInfo(const dict &req, uint64_t session_id, int request_id);

	int queryCreditExcessStock(const dict &req, uint64_t session_id, int request_id);

	int queryMulCreditExcessStock(const dict &req, uint64_t session_id, int request_id);

	int queryCreditExtendDebtDateOrders(uint64_t xtp_id, uint64_t session_id, int request_id);

	int queryCreditFundExtraInfo(uint64_t session_id, int request_id);

	int queryCreditPositionExtraInfo(const dict &req, uint64_t session_id, int request_id);

	int queryOptionCombinedUnfinishedOrdersEx(uint64_t session_id, int request_id);

	int queryOptionCombinedOrderByXTPIDEx(uint64_t order_xtp_id, uint64_t session_id, int request_id);

	int queryOptionCombinedOrdersEx(const dict &req, uint64_t session_id, int request_id);

	int queryOptionCombinedOrdersByPageEx(const dict &req, uint64_t session_id, int request_id);

	int queryOptionCombinedTradesByXTPID(uint64_t order_xtp_id, uint64_t session_id, int request_id);

	int queryOptionCombinedTrades(const dict &req, uint64_t session_id, int request_id);

	int queryOptionCombinedTradesByPage(const dict &req, uint64_t session_id, int request_id);

	int queryOptionCombinedPosition(const dict &req, uint64_t session_id, int request_id);

	int queryOptionCombinedStrategyInfo(uint64_t session_id, int request_id);

	int queryOptionCombinedExecPosition(const dict &req, uint64_t session_id, int request_id);
};
