
__version__ = "0.2.8"

from exploitfarm.utils import try_tcp_connection
from exploitfarm.model import ServiceDTO, AttackMode, SetupStatus
import requests, functools, random, os
from exploitfarm.utils.config import ClientConfig
from exploitfarm.cmd.config import inital_config_setup
from exploitfarm.cmd.login import login_required

def get_host():
    result = os.getenv("XFARM_HOST", None)
    if not result:
        raise ValueError("this exploit has to be run with xfarm")
    return result

def service_info() -> ServiceDTO|None:
    result = os.getenv("XFARM_SERVICE", None)
    if not result:
        return None
    try:
        return ServiceDTO.model_validate_json(result)
    except Exception:
        return None

def runtime_info() -> float:
    data = os.getenv("XFARM_RUNTIME", None)
    if data is None:
        raise ValueError("this exploit has to be run with xfarm")
    return float(data)

def get_config():
    config = ClientConfig.read()
    if not inital_config_setup(config):
        raise ValueError("It's required to setup the client first")
    login_required(config)
    return config

def random_str(
    length:int|None = None,
    length_range:int = (8,12),
    numbers:bool = True,
    lower:bool = True,
    upper:bool = True,
    specials:bool = False,
    exclude:str = "",
    include:str = ""
) -> str:
    alphabet = ""
    if numbers: alphabet += "0123456789"
    if lower: alphabet += "abcdefghijklmnopqrstuvwxyz"
    if upper: alphabet += "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
    if specials: alphabet += "!@#$%^&*()_+-=[]{}|;:,.<>?/~"
    if exclude: alphabet = alphabet.translate(str.maketrans("", "", exclude))
    if include: alphabet += include
    if not alphabet:
        raise ValueError("No alphabet selected")
    alphabet = "".join(list(set([ele for ele in alphabet])))
    if length is None:
        length = random.randint(*length_range)
    return "".join(random.choices(alphabet, k=length))

def session(
    random_agent:bool = True,
    additional_headers:list = [],
    user_agent:str = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/123.0.0.0 Safari/537.3",
) -> requests.Session:
    headers = {
        "User-Agent": random.choice(
            [
                "Mozilla/5.0 (X11; Linux x86_64; rv:124.0) Gecko/20100101 Firefox/124.0",
                "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/123.0.0.0 Safari/537.3",
                "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.3",
            ]+additional_headers
        ) if random_agent else user_agent,
        "Accept": "text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9",
        "Accept-Encoding": "gzip, deflate",
        "Accept-Language": "en-GB,en;q=0.8,it;q=0.7,en-US;q=0.6",
    } 
    s = requests.Session()
    s.headers.update(headers)
    return s

#Force flush print
print = functools.partial(print, flush = True)

#Exported functions
__all__ = [
    "try_tcp_connection",
    "AttackMode",
    "SetupStatus",
    "get_host",
    "service_info",
    "runtime_info",
    "get_config",
    "random_str",
    "session",
    "print",
]