import os, socket
from fasteners import InterProcessLock
import sys
import psutil

DEFAULT_SERVER_PORT = 5050

def parse_address(address:str, default_port:int|None = None) -> tuple[str, int]:
    parts = address.split(":")
    address = parts[0].strip()
    port = int(parts[1]) if len(parts) > 1 else default_port
    if port is None:
        raise ValueError("Port is required")
    return address, port

def try_tcp_connection(address:str, timeout:float|None = 3) -> tuple[bool, str|None]:
    address, port = parse_address(address, default_port=DEFAULT_SERVER_PORT)
    s = socket.socket()
    try:
        s.settimeout(timeout)
        s.connect((address, port))
    except Exception as e: 
        return False, f"Connection to {address}:{port} Failed: {e}"
    finally:
        s.close()
    return True, None

def create_lock(name:str) -> InterProcessLock:
    file_path = os.path.join(os.path.dirname(os.path.realpath(__file__)), name)
    base_path = os.path.dirname(file_path)
    if not os.path.exists(base_path): os.makedirs(base_path)
    return InterProcessLock(file_path)

def restart_program():
    """Restarts the current program, with file objects and descriptors
       cleanup
    """

    try:
        p = psutil.Process(os.getpid())
        for handler in p.get_open_files() + p.connections():
            os.close(handler.fd)
    except Exception as e:
        pass

    python = sys.executable
    os.execl(python, python, *sys.argv)