"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContainerMutatingHook = exports.ServiceExtension = exports.EnvironmentCapacityType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * The types of capacity that are supported. These capacity types may change the
 * behavior of an extension.
 */
var EnvironmentCapacityType;
(function (EnvironmentCapacityType) {
    /**
     * Specify that the environment should use AWS Fargate for
     * hosting containers.
     */
    EnvironmentCapacityType["FARGATE"] = "fargate";
    /**
     * Specify that the environment should launch containers onto
     * EC2 instances.
     */
    EnvironmentCapacityType["EC2"] = "ec2";
})(EnvironmentCapacityType = exports.EnvironmentCapacityType || (exports.EnvironmentCapacityType = {}));
/**
 * The shape of a service extension. This abstract class is implemented
 * by other extensions that extend the hooks to implement any custom
 * logic that they want to run during each step of preparing the service.
 */
class ServiceExtension {
    constructor(name) {
        // A list of other extensions which want to mutate the
        // container definition for this extension.
        this.containerMutatingHooks = [];
        this.name = name;
    }
    /**
     * A hook that allows the extension to add hooks to other
     * extensions that are registered.
     */
    addHooks() { } // tslint:disable-line
    /**
     * This hook allows another service extension to register a mutating hook for
     * changing the primary container of this extension. This is primarily used
     * for the application extension. For example, the Firelens extension wants to
     * be able to modify the settings of the application container to
     * route logs through Firelens.
     *
     * @param hook
     */
    addContainerMutatingHook(hook) {
        this.containerMutatingHooks.push(hook);
    }
    /**
     * This is a hook which allows extensions to modify the settings of the
     * task definition prior to it being created. For example, the App Mesh
     * extension needs to configure an Envoy proxy in the task definition,
     * or the Application extension wants to set the overall resource for
     * the task.
     *
     * @param props - Properties of the task definition to be created
     */
    modifyTaskDefinitionProps(props) {
        return {
            ...props,
        };
    }
    /**
     * A hook that is called for each extension ahead of time to
     * allow for any initial setup, such as creating resources in
     * advance.
     *
     * @param parent - The parent service which this extension has been added to
     * @param scope - The scope that this extension should create resources in
     */
    prehook(parent, scope) {
        this.parentService = parent;
        this.scope = scope;
    }
    /**
     * Once the task definition is created, this hook is called for each
     * extension to give it a chance to add containers to the task definition,
     * change the task definition's role to add permissions, etc.
     *
     * @param taskDefinition - The created task definition to add containers to
     */
    useTaskDefinition(taskDefinition) {
        taskDefinition = taskDefinition;
    }
    /**
     * Once all containers are added to the task definition, this hook is
     * called for each extension to give it a chance to resolve its dependency
     * graph so that its container starts in the right order based on the
     * other extensions that were enabled.
     */
    resolveContainerDependencies() {
        return;
    }
    /**
     * Prior to launching the task definition as a service, this hook
     * is called on each extension to give it a chance to mutate the properties
     * of the service to be created.
     *
     * @param props - The service properties to mutate.
     */
    modifyServiceProps(props) {
        return {
            ...props,
        };
    }
    /**
     * When this hook is implemented by extension, it allows the extension
     * to use the service which has been created. It is generally used to
     * create any final resources which might depend on the service itself.
     *
     * @param service - The generated service.
     */
    useService(service) {
        service = service;
    }
    /**
     * This hook allows the extension to establish a connection to
     * extensions from another service. Usually used for things like
     * allowing one service to talk to the load balancer or service mesh
     * proxy for another service.
     *
     * @param service - The other service to connect to.
     */
    connectToService(service, connectToProps) {
        service = service;
        connectToProps = connectToProps;
    }
}
exports.ServiceExtension = ServiceExtension;
_a = JSII_RTTI_SYMBOL_1;
ServiceExtension[_a] = { fqn: "@aws-cdk-containers/ecs-service-extensions.ServiceExtension", version: "2.0.0" };
/**
 * This is an abstract class wrapper for a mutating hook. It is
 * extended by any extension which wants to mutate other extension's containers.
 */
class ContainerMutatingHook {
    /**
     * This is a hook for modifying the container definition of any upstream
     * containers. This is primarily used for the main application container.
     * For example, the Firelens extension wants to be able to modify the logging
     * settings of the application container.
     *
     * @param props - The container definition to mutate.
     */
    mutateContainerDefinition(props) {
        return {
            ...props,
        };
    }
}
exports.ContainerMutatingHook = ContainerMutatingHook;
_b = JSII_RTTI_SYMBOL_1;
ContainerMutatingHook[_b] = { fqn: "@aws-cdk-containers/ecs-service-extensions.ContainerMutatingHook", version: "2.0.0" };
//# sourceMappingURL=data:application/json;base64,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