"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InjecterExtension = exports.InjectableTopic = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const extension_interfaces_1 = require("./extension-interfaces");
/**
 * The `InjectableTopic` class represents SNS Topic resource that can be published events to by the parent service.
 */
class InjectableTopic {
    constructor(props) {
        this.topic = props.topic;
    }
    grant(taskDefinition) {
        this.topic.grantPublish(taskDefinition.taskRole);
    }
    environmentVariables() {
        let environment = {};
        environment[`${this.topic.node.id.toUpperCase()}_TOPIC_ARN`] = this.topic.topicArn;
        return environment;
    }
}
exports.InjectableTopic = InjectableTopic;
_a = JSII_RTTI_SYMBOL_1;
InjectableTopic[_a] = { fqn: "@aws-cdk-containers/ecs-service-extensions.InjectableTopic", version: "2.0.0" };
/**
 * This hook modifies the application container's environment to
 * add the injectable resource environment variables.
 */
class InjecterExtensionMutatingHook extends extension_interfaces_1.ContainerMutatingHook {
    constructor(props) {
        super();
        this.environment = props.environment;
    }
    mutateContainerDefinition(props) {
        return {
            ...props,
            environment: { ...(props.environment || {}), ...this.environment },
        };
    }
}
/**
 * This extension accepts a list of `Injectable` resources that the parent service can publish events or write data to.
 * It sets up the corresponding permissions for the task role of the parent service.
 */
class InjecterExtension extends extension_interfaces_1.ServiceExtension {
    constructor(props) {
        super('injecter');
        this.environment = {};
        this.props = props;
    }
    // @ts-ignore - Ignore unused params that are required for abstract class extend
    prehook(service, scope) {
        this.parentService = service;
        for (const injectable of this.props.injectables) {
            for (const [key, val] of Object.entries(injectable.environmentVariables())) {
                this.environment[key] = val;
            }
        }
    }
    /**
     * Add hooks to the main application extension so that it is modified to
     * add the injectable resource environment variables to the container environment.
     */
    addHooks() {
        const container = this.parentService.serviceDescription.get('service-container');
        if (!container) {
            throw new Error('Injecter Extension requires an application extension');
        }
        container.addContainerMutatingHook(new InjecterExtensionMutatingHook({
            environment: this.environment,
        }));
    }
    /**
     * After the task definition has been created, this hook grants the required permissions to the task role for the
     * parent service.
     *
     * @param taskDefinition The created task definition
     */
    useTaskDefinition(taskDefinition) {
        for (const injectable of this.props.injectables) {
            if (injectable.grant !== undefined) {
                injectable.grant(taskDefinition);
            }
        }
    }
}
exports.InjecterExtension = InjecterExtension;
_b = JSII_RTTI_SYMBOL_1;
InjecterExtension[_b] = { fqn: "@aws-cdk-containers/ecs-service-extensions.InjecterExtension", version: "2.0.0" };
//# sourceMappingURL=data:application/json;base64,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