# generated by datamodel-codegen:
#   filename:  mcp-server.json

from __future__ import annotations

from typing import Any, Dict, List, TypedDict

from typing_extensions import NotRequired


class Airtable(TypedDict):
    airtableApiKey: str
    nodeenv: str


class Aks(TypedDict):
    accessLevel: str
    """
    Access level for the MCP server, One of [ readonly, readwrite, admin ]
    """
    additionalTools: NotRequired[str]
    """
    Comma-separated list of additional tools, One of [ helm, cilium ]
    """
    allowNamespaces: NotRequired[str]
    """
    Comma-separated list of namespaces to allow access to. If not specified, all namespaces are allowed.
    """
    azureDir: str
    """
    Path to the Azure configuration directory (e.g. /home/azureuser/.azure). Used for Azure CLI authentication, you should be logged in (e.g. run `az login`) on the host before starting the MCP server.
    """
    containerUser: NotRequired[str]
    """
    Username or UID of the container user (format <name|uid>[:<group|gid>] e.g. 10000), ensuring correct permissions to access the Azure and kubeconfig files. Leave empty to use default user in the container.
    """
    kubeconfig: str
    """
    Path to the kubeconfig file for the AKS cluster (e.g. /home/azureuser/.kube/config). Used to connect to the AKS cluster.
    """


class ApiGateway(TypedDict):
    api1HeaderAuthorization: str
    api1Name: str
    api1SwaggerUrl: str


class Apify(TypedDict):
    apifyToken: str
    tools: str
    """
    Comma-separated list of tools to enable. Can be either a tool category, a specific tool, or an Apify Actor. For example: "actors,docs,apify/rag-web-browser". For more details visit https://mcp.apify.com.
    """


class Arxiv(TypedDict):
    storagePath: str
    """
    Directory path where downloaded papers will be stored
    """


class AstGrep(TypedDict):
    path: str


class AstraDb(TypedDict):
    astraDbApplicationToken: str
    endpoint: str


class Atlan(TypedDict):
    apiKey: str
    baseUrl: str


class AtlasDocs(TypedDict):
    apiUrl: str


class Atlassian(TypedDict):
    confluenceApiToken: NotRequired[str]
    confluencePersonalToken: NotRequired[str]
    confluenceUrl: str
    confluenceUsername: NotRequired[str]
    jiraApiToken: NotRequired[str]
    jiraPersonalToken: NotRequired[str]
    jiraUrl: str
    jiraUsername: NotRequired[str]


class AudienseInsights(TypedDict):
    audienseClientSecret: NotRequired[str]
    clientId: str
    twitterBearerToken: NotRequired[str]


class AwsKbRetrievalServer(TypedDict):
    accessKeyId: str
    awsSecretAccessKey: NotRequired[str]


class BeagleSecurity(TypedDict):
    beagleSecurityApiToken: str


class Bitrefill(TypedDict):
    apiId: str
    apiSecret: NotRequired[str]


class Box(TypedDict):
    clientId: str
    clientSecret: NotRequired[str]


class Brave(TypedDict):
    apiKey: str


class Buildkite(TypedDict):
    apiToken: str


class Camunda(TypedDict):
    camundahost: str


class CdataConnectcloud(TypedDict):
    cdataPat: NotRequired[str]
    username: str


class Charmhealth(TypedDict):
    charmhealthApiKey: str
    charmhealthBaseUrl: str
    charmhealthClientId: str
    charmhealthClientSecret: str
    charmhealthRedirectUri: str
    charmhealthRefreshToken: str
    charmhealthTokenUrl: str


class Chroma(TypedDict):
    apiKey: str


class Circleci(TypedDict):
    token: str
    url: str


class Clickhouse(TypedDict):
    connectTimeout: str
    host: str
    password: str
    port: str
    secure: str
    sendReceiveTimeout: str
    user: str
    verify: str


class Close(TypedDict):
    apiKey: str


class CloudRun(TypedDict):
    credentialsPath: str
    """
    path to application-default credentials (eg $HOME/.config/gcloud/application_default_credentials.json )
    """


class Cockroachdb(TypedDict):
    caPath: str
    crdbPwd: str
    database: str
    host: str
    port: int
    sslCertfile: str
    sslKeyfile: str
    sslMode: str
    username: str


class Couchbase(TypedDict):
    cbBucketName: str
    """
    Bucket in the Couchbase cluster to use for the MCP server.
    """
    cbConnectionString: str
    """
    Connection string for the Couchbase cluster.
    """
    cbMcpReadOnlyQueryMode: str
    """
    Setting to "true" (default) enables read-only query mode while running SQL++ queries.
    """
    cbPassword: str
    cbUsername: str
    """
    Username for the Couchbase cluster with access to the bucket.
    """


class CyreslabAiShodan(TypedDict):
    shodanApiKey: str


class Dappier(TypedDict):
    apiKey: str


class DappierRemote(TypedDict):
    dappierRemoteApiKey: str


class Dart(TypedDict):
    host: str
    token: str


class DatabaseServer(TypedDict):
    databaseUrl: str
    """
    Connection string for your database. Examples: SQLite: sqlite+aiosqlite:///data/mydb.db, PostgreSQL: postgresql+asyncpg://user:password@localhost:5432/mydb, MySQL: mysql+aiomysql://user:password@localhost:3306/mydb
    """


class Descope(TypedDict):
    managementKey: NotRequired[str]
    projectId: str


class DesktopCommander(TypedDict):
    paths: List[str]
    """
    List of directories that Desktop Commander can access
    """


class DevhubCms(TypedDict):
    devhubApiKey: NotRequired[str]
    devhubApiSecret: NotRequired[str]
    url: str


class Discord(TypedDict):
    discordToken: str


class Dockerhub(TypedDict):
    hubPatToken: str
    username: str


class DodoPayments(TypedDict):
    dodoPaymentsApiKey: str


class Dreamfactory(TypedDict):
    dreamfactoryapikey: str
    dreamfactoryurl: str


class Dynatrace(TypedDict):
    oauthClientId: str
    oauthClientSecret: str
    url: str


class E2b(TypedDict):
    apiKey: str


class Edubase(TypedDict):
    apiKey: NotRequired[str]
    app: str
    url: str


class Elasticsearch(TypedDict):
    esApiKey: NotRequired[str]
    url: str


class Elevenlabs(TypedDict):
    apiKey: NotRequired[str]
    data: str


class Everart(TypedDict):
    apiKey: str


class Exa(TypedDict):
    apiKey: str


class Explorium(TypedDict):
    apiAccessToken: str


class Fibery(TypedDict):
    apiToken: str
    host: str


class Filesystem(TypedDict):
    paths: List[str]


class Firecrawl(TypedDict):
    apiKey: str
    creditCriticalThreshold: int
    creditWarningThreshold: int
    retryBackoffFactor: int
    retryDelay: int
    retryMax: int
    retryMaxDelay: int
    url: str


class Firewalla(TypedDict):
    boxId: str
    """
    Your Firewalla Box Global ID
    """
    firewallaMspToken: str
    mspId: str
    """
    Your Firewalla MSP domain (e.g., yourdomain.firewalla.net)
    """


class Flexprice(TypedDict):
    apiKey: str
    baseUrl: str


class Git(TypedDict):
    paths: List[str]


class Github(TypedDict):
    personalAccessToken: str


class GithubChat(TypedDict):
    githubApiKey: str


class GithubOfficial(TypedDict):
    githubPersonalAccessToken: str


class Gitlab(TypedDict):
    personalAccessToken: str
    url: str
    """
    api url - optional for self-hosted instances
    """


class Glif(TypedDict):
    apiToken: str
    ids: str
    ignoredSaved: bool


class Gmail(TypedDict):
    emailAddress: str
    """
    Your Gmail email address
    """
    emailPassword: NotRequired[str]


class GoogleMaps(TypedDict):
    googleMapsApiKey: str


class GoogleMapsComprehensive(TypedDict):
    googleMapsApiKey: str


class Grafana(TypedDict):
    apiKey: str
    url: str


class Gyazo(TypedDict):
    accessToken: str


class Hackle(TypedDict):
    apiKey: str


class HandwritingOcr(TypedDict):
    apiToken: str


class Hdx(TypedDict):
    appIdentifier: str


class Heroku(TypedDict):
    apiKey: str


class Hostinger(TypedDict):
    apitoken: str


class Hoverfly(TypedDict):
    data: str


class Hubspot(TypedDict):
    apiKey: str


class Hummingbot(TypedDict):
    apiUrl: str
    hummingbotApiPassword: NotRequired[str]
    hummingbotApiUsername: NotRequired[str]


class HusqvarnaAutomower(TypedDict):
    clientId: str
    husqvarnaClientSecret: str


class Hyperbrowser(TypedDict):
    apiKey: str


class Hyperspell(TypedDict):
    collection: str
    token: str
    useResources: bool


class Iaptic(TypedDict):
    apiKey: NotRequired[str]
    appName: str


class InspektorGadget(TypedDict):
    gadgetImages: NotRequired[str]
    """
    Comma-separated list of gadget images (trace_dns, trace_tcp, etc) to use, allowing control over which gadgets are available as MCP tools
    """
    kubeconfig: str
    """
    Path to the kubeconfig file for accessing Kubernetes clusters
    """


class Jetbrains(TypedDict):
    port: int


class KafkaSchemaReg(TypedDict):
    registryUrl: str
    """
    Schema Registry URL
    """
    schemaRegistryPassword: NotRequired[str]
    schemaRegistryUser: NotRequired[str]
    slimMode: NotRequired[str]
    """
    Enable SLIM_MODE for better performance
    """
    viewonly: NotRequired[str]
    """
    Enable read-only mode
    """


class Kagisearch(TypedDict):
    engine: str
    kagiApiKey: str


class Keboola(TypedDict):
    kbcStorageToken: str
    kbcWorkspaceSchema: str


class Kong(TypedDict):
    konnectAccessToken: str
    region: str


class Kubectl(TypedDict):
    kubeconfig: str


class Kubernetes(TypedDict):
    configPath: str
    """
    the path to the host .kube/config
    """


class Lara(TypedDict):
    accessKeySecret: NotRequired[str]
    keyId: str


class Line(TypedDict):
    channelAccessToken: NotRequired[str]
    userId: str


class Linkedin(TypedDict):
    linkedinCookie: str
    userAgent: str
    """
    Custom user agent string (optional, helps avoid detection and cookie login issues)
    """


class Maestro(TypedDict):
    apiKeyApiKey: str


class Mapbox(TypedDict):
    accessToken: str


class MapboxDevkit(TypedDict):
    mapboxAccessToken: str


class Markdownify(TypedDict):
    paths: List[str]


class Markitdown(TypedDict):
    paths: List[str]


class MercadoLibre(TypedDict):
    mercadoLibreApiKey: str


class MercadoPago(TypedDict):
    mercadoPagoApiKey: str


class Metabase(TypedDict):
    apiKey: str
    metabaseurl: str
    metabaseusername: str
    password: str


class Mongodb(TypedDict):
    mdbMcpConnectionString: str


class MultiversxMx(TypedDict):
    network: str
    wallet: str


class NasdaqDataLink(TypedDict):
    nasdaqDataLinkApiKey: str


class Needle(TypedDict):
    needleApiKey: str


class Neo4jCloudAuraApi(TypedDict):
    clientId: str
    neo4jAuraClientSecret: NotRequired[str]
    serverAllowOrigins: NotRequired[str]
    serverAllowedHosts: NotRequired[str]
    serverHost: NotRequired[str]
    serverPath: NotRequired[str]
    serverPort: NotRequired[str]
    transport: NotRequired[str]


class Neo4jCypher(TypedDict):
    database: NotRequired[str]
    namespace: NotRequired[str]
    neo4jPassword: NotRequired[str]
    readOnly: NotRequired[bool]
    readTimeout: NotRequired[str]
    responseTokenLimit: NotRequired[str]
    serverAllowOrigins: NotRequired[str]
    serverAllowedHosts: NotRequired[str]
    serverHost: NotRequired[str]
    serverPath: NotRequired[str]
    serverPort: NotRequired[str]
    transport: NotRequired[str]
    url: str
    username: str


class Neo4jDataModeling(TypedDict):
    serverAllowOrigins: str
    serverAllowedHosts: str
    serverHost: str
    serverPath: str
    serverPort: str
    transport: str


class Neo4jMemory(TypedDict):
    database: NotRequired[str]
    neo4jPassword: NotRequired[str]
    serverAllowOrigins: NotRequired[str]
    serverAllowedHosts: NotRequired[str]
    serverHost: NotRequired[str]
    serverPath: NotRequired[str]
    serverPort: NotRequired[str]
    transport: NotRequired[str]
    url: str
    username: str


class Neon(TypedDict):
    apiKey: str


class Notion(TypedDict):
    internalIntegrationToken: str


class Obsidian(TypedDict):
    apiKey: str


class OktaMcpFctr(TypedDict):
    clientOrgurl: str
    """
    Okta organization URL (e.g., https://dev-123456.okta.com)
    """
    concurrentLimit: NotRequired[str]
    """
    Maximum concurrent requests to Okta API
    """
    logLevel: NotRequired[str]
    """
    Logging level for server output
    """
    oktaApiToken: NotRequired[str]


class Omi(TypedDict):
    apiKey: str


class OnlyofficeDocspace(TypedDict):
    baseUrl: str
    docspaceApiKey: str
    docspaceAuthToken: str
    docspacePassword: str
    docspaceUsername: str
    dynamic: bool
    origin: str
    toolsets: str
    userAgent: str


class Openapi(TypedDict):
    mode: str


class Openweather(TypedDict):
    owmApiKey: str


class Opik(TypedDict):
    apiBaseUrl: str
    apiKey: str
    workspaceName: str


class Opine(TypedDict):
    opineApiKey: str


class Oracle(TypedDict):
    oracleConnectionString: str
    oracleUser: str
    password: str


class Oxylabs(TypedDict):
    password: NotRequired[str]
    username: str


class PerplexityAsk(TypedDict):
    perplexityApiKey: str


class Pia(TypedDict):
    apiKey: str


class Pinecone(TypedDict):
    apiKey: str
    assistantHost: str


class Playwright(TypedDict):
    data: str


class PluggedinMcpProxy(TypedDict):
    pluggedinApiBaseUrl: str
    """
    Base URL for the Plugged.in API (optional, defaults to https://plugged.in for cloud or http://localhost:12005 for self-hosted)
    """
    pluggedinApiKey: str


class PolarSignals(TypedDict):
    polarSignalsApiKey: str


class Pomodash(TypedDict):
    apiKey: str


class Postgres(TypedDict):
    url: str


class Postman(TypedDict):
    apiKey: str


class Prometheus(TypedDict):
    prometheusUrl: str
    """
    The URL of your Prometheus server
    """


class Quantconnect(TypedDict):
    agentname: str
    quantconnectapitoken: str
    quantconnectuserid: str


class Razorpay(TypedDict):
    keyId: str
    keySecret: NotRequired[str]


class Reddit(TypedDict):
    redditClientId: str
    redditClientSecret: str
    redditPassword: str
    username: str


class Redis(TypedDict):
    caCerts: str
    caPath: str
    certReqs: str
    clusterMode: bool
    host: str
    port: int
    pwd: str
    ssl: bool
    sslCertfile: str
    sslKeyfile: str
    username: str


class RedisCloud(TypedDict):
    apiKey: str
    secretKey: NotRequired[str]


class Ref(TypedDict):
    apiKey: str


class Render(TypedDict):
    apiKey: str


class Resend(TypedDict):
    apiKey: NotRequired[str]
    replyTo: str
    """
    comma separated list of reply to email addresses
    """
    sender: str
    """
    sender email address
    """


class Risken(TypedDict):
    accessToken: str
    url: str


class Root(TypedDict):
    apiAccessToken: str


class Rube(TypedDict):
    apiKey: str


class RustMcpFilesystem(TypedDict):
    allowWrite: bool
    """
    Enable read/write mode. If false, the app operates in read-only mode.
    """
    allowedDirectories: List[str]
    """
    List of directories that rust-mcp-filesystem can access.
    """
    enableRoots: bool
    """
    Enable dynamic directory access control via MCP client-side Roots.
    """


class SchemacrawlerAi(TypedDict):
    generalInfoLevel: str
    """
    --info-level How much database metadata to retrieve
    """
    generalLogLevel: NotRequired[str]
    schcrwlrDatabasePassword: NotRequired[str]
    schcrwlrDatabaseUser: NotRequired[str]
    serverConnectionDatabase: NotRequired[str]
    """
    --database Database to connect to (optional)
    """
    serverConnectionHost: NotRequired[str]
    """
    --host Database host (optional)
    """
    serverConnectionPort: NotRequired[int]
    """
    --port Database port (optional)
    """
    serverConnectionServer: str
    """
    --server SchemaCrawler database plugin
    """
    urlConnectionJdbcUrl: str
    """
    --url JDBC URL for database connection
    """
    volumeHostShare: str
    """
    Host volume to map within the Docker container
    """


class Scrapegraph(TypedDict):
    sgaiApiKey: str


class Scrapezy(TypedDict):
    apiKey: str


class Sentry(TypedDict):
    authToken: str


class Sequa(TypedDict):
    apiKey: str
    mcpServerUrl: str


class ShortIo(TypedDict):
    shortIoApiKey: str


class Singlestore(TypedDict):
    mcpApiKey: str


class Slack(TypedDict):
    botToken: NotRequired[str]
    channelIds: NotRequired[str]
    teamId: str


class Smartbear(TypedDict):
    apiHubApiKey: str
    bugsnagApiKey: str
    bugsnagAuthToken: str
    bugsnagEndpoint: str
    pactBrokerBaseUrl: str
    pactBrokerPassword: str
    pactBrokerToken: str
    pactBrokerUsername: str
    reflectApiToken: str


class Sonarqube(TypedDict):
    org: str
    """
    Organization key for SonarQube Cloud, not required for SonarQube Server or Community Build
    """
    token: str
    url: str
    """
    URL of the SonarQube instance, to provide only for SonarQube Server or Community Build
    """


class Stackgen(TypedDict):
    token: NotRequired[str]
    url: str
    """
    URL of your StackGen instance
    """


class Stackhawk(TypedDict):
    apiKey: str


class Stripe(TypedDict):
    secretKey: str


class Supadata(TypedDict):
    apiKey: str


class Suzieq(TypedDict):
    apiEndpoint: str
    apiKey: str


class Tavily(TypedDict):
    apiKey: str


class Teamwork(TypedDict):
    twMcpBearerToken: str


class Telnyx(TypedDict):
    apiKey: str


class Tembo(TypedDict):
    apiKey: str


class TextToGraphql(TypedDict):
    graphqlApiKey: str
    graphqlAuthType: str
    """
    Authentication method for GraphQL API
    """
    graphqlEndpoint: str
    modelName: str
    """
    OpenAI model to use
    """
    modelTemperature: float
    """
    Model temperature for responses
    """
    openaiApiKey: str


class Tigris(TypedDict):
    awsAccessKeyId: str
    awsEndpointUrlS3: str
    awsSecretAccessKey: NotRequired[str]


class Triplewhale(TypedDict):
    apiKey: str


class UnrealEngine(TypedDict):
    logLevel: NotRequired[str]
    """
    Logging level
    """
    ueHost: str
    """
    Unreal Engine host address. Use: host.docker.internal for local UE on Windows/Mac Docker, 127.0.0.1 for Linux without Docker, or actual IP address (e.g., 192.168.1.100) for remote UE
    """
    ueRcHttpPort: str
    """
    Remote Control HTTP port
    """
    ueRcWsPort: str
    """
    Remote Control WebSocket port
    """


class Veyrax(TypedDict):
    apiKey: str


class Wayfound(TypedDict):
    mcpApiKey: str


class Webflow(TypedDict):
    token: str


class WolframAlpha(TypedDict):
    wolframApiKey: str


class ZerodhaKite(TypedDict):
    kiteAccessToken: NotRequired[str]
    """
    Access token obtained after OAuth authentication (optional - can be generated at runtime)
    """
    kiteApiKey: str
    """
    Your Kite Connect API key from the developer console
    """
    kiteApiSecret: NotRequired[str]
    kiteRedirectUrl: NotRequired[str]
    """
    OAuth redirect URL configured in your Kite Connect app
    """


class McpServer(TypedDict):
    airtable: NotRequired[Airtable]
    aks: NotRequired[Aks]
    apiGateway: NotRequired[ApiGateway]
    apify: NotRequired[Apify]
    arxiv: NotRequired[Arxiv]
    astGrep: NotRequired[AstGrep]
    astraDb: NotRequired[AstraDb]
    astroDocs: NotRequired[Dict[str, Any]]
    atlan: NotRequired[Atlan]
    atlasDocs: NotRequired[AtlasDocs]
    atlassian: NotRequired[Atlassian]
    audienseInsights: NotRequired[AudienseInsights]
    awsCdk: NotRequired[Dict[str, Any]]
    awsCore: NotRequired[Dict[str, Any]]
    awsDiagram: NotRequired[Dict[str, Any]]
    awsDocumentation: NotRequired[Dict[str, Any]]
    awsKbRetrievalServer: NotRequired[AwsKbRetrievalServer]
    awsTerraform: NotRequired[Dict[str, Any]]
    azure: NotRequired[Dict[str, Any]]
    beagleSecurity: NotRequired[BeagleSecurity]
    bitrefill: NotRequired[Bitrefill]
    box: NotRequired[Box]
    brave: NotRequired[Brave]
    buildkite: NotRequired[Buildkite]
    camunda: NotRequired[Camunda]
    cdataConnectcloud: NotRequired[CdataConnectcloud]
    charmhealth: NotRequired[Charmhealth]
    chroma: NotRequired[Chroma]
    circleci: NotRequired[Circleci]
    clickhouse: NotRequired[Clickhouse]
    close: NotRequired[Close]
    cloudRun: NotRequired[CloudRun]
    cloudflareDocs: NotRequired[Dict[str, Any]]
    cockroachdb: NotRequired[Cockroachdb]
    codeInterpreter: NotRequired[Dict[str, Any]]
    context7: NotRequired[Dict[str, Any]]
    couchbase: NotRequired[Couchbase]
    cyreslabAiShodan: NotRequired[CyreslabAiShodan]
    dappier: NotRequired[Dappier]
    dappierRemote: NotRequired[DappierRemote]
    dart: NotRequired[Dart]
    databaseServer: NotRequired[DatabaseServer]
    databutton: NotRequired[Dict[str, Any]]
    deepwiki: NotRequired[Dict[str, Any]]
    descope: NotRequired[Descope]
    desktopCommander: NotRequired[DesktopCommander]
    devhubCms: NotRequired[DevhubCms]
    discord: NotRequired[Discord]
    dockerhub: NotRequired[Dockerhub]
    dodoPayments: NotRequired[DodoPayments]
    dreamfactory: NotRequired[Dreamfactory]
    duckduckgo: NotRequired[Dict[str, Any]]
    dynatrace: NotRequired[Dynatrace]
    e2b: NotRequired[E2b]
    edubase: NotRequired[Edubase]
    effect: NotRequired[Dict[str, Any]]
    elasticsearch: NotRequired[Elasticsearch]
    elevenlabs: NotRequired[Elevenlabs]
    everart: NotRequired[Everart]
    exa: NotRequired[Exa]
    explorium: NotRequired[Explorium]
    fetch: NotRequired[Dict[str, Any]]
    fibery: NotRequired[Fibery]
    filesystem: NotRequired[Filesystem]
    findADomain: NotRequired[Dict[str, Any]]
    firecrawl: NotRequired[Firecrawl]
    firewalla: NotRequired[Firewalla]
    flexprice: NotRequired[Flexprice]
    git: NotRequired[Git]
    github: NotRequired[Github]
    githubChat: NotRequired[GithubChat]
    githubOfficial: NotRequired[GithubOfficial]
    gitlab: NotRequired[Gitlab]
    gitmcp: NotRequired[Dict[str, Any]]
    glif: NotRequired[Glif]
    gmail: NotRequired[Gmail]
    googleMaps: NotRequired[GoogleMaps]
    googleMapsComprehensive: NotRequired[GoogleMapsComprehensive]
    grafana: NotRequired[Grafana]
    gyazo: NotRequired[Gyazo]
    hackernews: NotRequired[Dict[str, Any]]
    hackle: NotRequired[Hackle]
    handwritingOcr: NotRequired[HandwritingOcr]
    hdx: NotRequired[Hdx]
    heroku: NotRequired[Heroku]
    hostinger: NotRequired[Hostinger]
    hoverfly: NotRequired[Hoverfly]
    hubspot: NotRequired[Hubspot]
    huggingFace: NotRequired[Dict[str, Any]]
    hummingbot: NotRequired[Hummingbot]
    husqvarnaAutomower: NotRequired[HusqvarnaAutomower]
    hyperbrowser: NotRequired[Hyperbrowser]
    hyperspell: NotRequired[Hyperspell]
    iaptic: NotRequired[Iaptic]
    inspektorGadget: NotRequired[InspektorGadget]
    javadocs: NotRequired[Dict[str, Any]]
    jetbrains: NotRequired[Jetbrains]
    kafkaSchemaReg: NotRequired[KafkaSchemaReg]
    kagisearch: NotRequired[Kagisearch]
    keboola: NotRequired[Keboola]
    kong: NotRequired[Kong]
    kubectl: NotRequired[Kubectl]
    kubernetes: NotRequired[Kubernetes]
    lara: NotRequired[Lara]
    line: NotRequired[Line]
    linkedin: NotRequired[Linkedin]
    llmtxt: NotRequired[Dict[str, Any]]
    maestro: NotRequired[Maestro]
    manifold: NotRequired[Dict[str, Any]]
    mapbox: NotRequired[Mapbox]
    mapboxDevkit: NotRequired[MapboxDevkit]
    markdownify: NotRequired[Markdownify]
    markitdown: NotRequired[Markitdown]
    memory: NotRequired[Dict[str, Any]]
    mercadoLibre: NotRequired[MercadoLibre]
    mercadoPago: NotRequired[MercadoPago]
    metabase: NotRequired[Metabase]
    minecraftWiki: NotRequired[Dict[str, Any]]
    mongodb: NotRequired[Mongodb]
    multiversxMx: NotRequired[MultiversxMx]
    nasdaqDataLink: NotRequired[NasdaqDataLink]
    needle: NotRequired[Needle]
    neo4jCloudAuraApi: NotRequired[Neo4jCloudAuraApi]
    neo4jCypher: NotRequired[Neo4jCypher]
    neo4jDataModeling: NotRequired[Neo4jDataModeling]
    neo4jMemory: NotRequired[Neo4jMemory]
    neon: NotRequired[Neon]
    nodeCodeSandbox: NotRequired[Dict[str, Any]]
    notion: NotRequired[Notion]
    novita: NotRequired[Dict[str, Any]]
    npmSentinel: NotRequired[Dict[str, Any]]
    obsidian: NotRequired[Obsidian]
    oktaMcpFctr: NotRequired[OktaMcpFctr]
    omi: NotRequired[Omi]
    onlyofficeDocspace: NotRequired[OnlyofficeDocspace]
    openapi: NotRequired[Openapi]
    openbnbAirbnb: NotRequired[Dict[str, Any]]
    openmesh: NotRequired[Dict[str, Any]]
    openweather: NotRequired[Openweather]
    openzeppelinCairo: NotRequired[Dict[str, Any]]
    openzeppelinSolidity: NotRequired[Dict[str, Any]]
    openzeppelinStellar: NotRequired[Dict[str, Any]]
    openzeppelinStylus: NotRequired[Dict[str, Any]]
    opik: NotRequired[Opik]
    opine: NotRequired[Opine]
    oracle: NotRequired[Oracle]
    ospMarketingTools: NotRequired[Dict[str, Any]]
    oxylabs: NotRequired[Oxylabs]
    paperSearch: NotRequired[Dict[str, Any]]
    perplexityAsk: NotRequired[PerplexityAsk]
    pia: NotRequired[Pia]
    pinecone: NotRequired[Pinecone]
    playwright: NotRequired[Playwright]
    pluggedinMcpProxy: NotRequired[PluggedinMcpProxy]
    polarSignals: NotRequired[PolarSignals]
    pomodash: NotRequired[Pomodash]
    postgres: NotRequired[Postgres]
    postman: NotRequired[Postman]
    prefEditor: NotRequired[Dict[str, Any]]
    prometheus: NotRequired[Prometheus]
    puppeteer: NotRequired[Dict[str, Any]]
    pythonRefactoring: NotRequired[Dict[str, Any]]
    quantconnect: NotRequired[Quantconnect]
    ramparts: NotRequired[Dict[str, Any]]
    razorpay: NotRequired[Razorpay]
    reddit: NotRequired[Reddit]
    redis: NotRequired[Redis]
    redisCloud: NotRequired[RedisCloud]
    ref: NotRequired[Ref]
    remote: NotRequired[Dict[str, Any]]
    render: NotRequired[Render]
    resend: NotRequired[Resend]
    risken: NotRequired[Risken]
    root: NotRequired[Root]
    ros2: NotRequired[Dict[str, Any]]
    rube: NotRequired[Rube]
    rustMcpFilesystem: NotRequired[RustMcpFilesystem]
    schemacrawlerAi: NotRequired[SchemacrawlerAi]
    schoginiMcpImageBorder: NotRequired[Dict[str, Any]]
    scrapegraph: NotRequired[Scrapegraph]
    scrapezy: NotRequired[Scrapezy]
    securenoteLink: NotRequired[Dict[str, Any]]
    semgrep: NotRequired[Dict[str, Any]]
    sentry: NotRequired[Sentry]
    sequa: NotRequired[Sequa]
    sequentialthinking: NotRequired[Dict[str, Any]]
    shortIo: NotRequired[ShortIo]
    simplechecklist: NotRequired[Dict[str, Any]]
    singlestore: NotRequired[Singlestore]
    slack: NotRequired[Slack]
    smartbear: NotRequired[Smartbear]
    sonarqube: NotRequired[Sonarqube]
    sqlite: NotRequired[Dict[str, Any]]
    stackgen: NotRequired[Stackgen]
    stackhawk: NotRequired[Stackhawk]
    stripe: NotRequired[Stripe]
    supadata: NotRequired[Supadata]
    suzieq: NotRequired[Suzieq]
    taskOrchestrator: NotRequired[Dict[str, Any]]
    tavily: NotRequired[Tavily]
    teamwork: NotRequired[Teamwork]
    telnyx: NotRequired[Telnyx]
    tembo: NotRequired[Tembo]
    terraform: NotRequired[Dict[str, Any]]
    textToGraphql: NotRequired[TextToGraphql]
    tigris: NotRequired[Tigris]
    time: NotRequired[Dict[str, Any]]
    triplewhale: NotRequired[Triplewhale]
    unrealEngine: NotRequired[UnrealEngine]
    veyrax: NotRequired[Veyrax]
    vizro: NotRequired[Dict[str, Any]]
    vulnNist: NotRequired[Dict[str, Any]]
    wayfound: NotRequired[Wayfound]
    webflow: NotRequired[Webflow]
    wikipedia: NotRequired[Dict[str, Any]]
    wolframAlpha: NotRequired[WolframAlpha]
    youtubeTranscript: NotRequired[Dict[str, Any]]
    zerodhaKite: NotRequired[ZerodhaKite]
