# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'RegistryAuth',
]

@pulumi.output_type
class RegistryAuth(dict):
    def __init__(__self__, *,
                 address: str,
                 auth_disabled: Optional[bool] = None,
                 config_file: Optional[str] = None,
                 config_file_content: Optional[str] = None,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str address: Address of the registry
        :param str config_file: Path to docker json file for registry auth. Defaults to `~/.docker/config.json`. If `DOCKER_CONFIG` is set, the value of `DOCKER_CONFIG` is used as the path. `config_file` has predencen over all other options.
        :param str config_file_content: Plain content of the docker json file for registry auth. `config_file_content` has precedence over username/password.
        :param str password: Password for the registry. Defaults to `DOCKER_REGISTRY_PASS` env variable if set.
        :param str username: Username for the registry. Defaults to `DOCKER_REGISTRY_USER` env variable if set.
        """
        pulumi.set(__self__, "address", address)
        if auth_disabled is not None:
            pulumi.set(__self__, "auth_disabled", auth_disabled)
        if config_file is not None:
            pulumi.set(__self__, "config_file", config_file)
        if config_file_content is not None:
            pulumi.set(__self__, "config_file_content", config_file_content)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        Address of the registry
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="authDisabled")
    def auth_disabled(self) -> Optional[bool]:
        return pulumi.get(self, "auth_disabled")

    @property
    @pulumi.getter(name="configFile")
    def config_file(self) -> Optional[str]:
        """
        Path to docker json file for registry auth. Defaults to `~/.docker/config.json`. If `DOCKER_CONFIG` is set, the value of `DOCKER_CONFIG` is used as the path. `config_file` has predencen over all other options.
        """
        return pulumi.get(self, "config_file")

    @property
    @pulumi.getter(name="configFileContent")
    def config_file_content(self) -> Optional[str]:
        """
        Plain content of the docker json file for registry auth. `config_file_content` has precedence over username/password.
        """
        return pulumi.get(self, "config_file_content")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password for the registry. Defaults to `DOCKER_REGISTRY_PASS` env variable if set.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username for the registry. Defaults to `DOCKER_REGISTRY_USER` env variable if set.
        """
        return pulumi.get(self, "username")


