# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ContainerArgs', 'Container']

@pulumi.input_type
class ContainerArgs:
    def __init__(__self__, *,
                 image: pulumi.Input[str],
                 attach: Optional[pulumi.Input[bool]] = None,
                 capabilities: Optional[pulumi.Input['ContainerCapabilitiesArgs']] = None,
                 cgroupns_mode: Optional[pulumi.Input[str]] = None,
                 command: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 container_read_refresh_timeout_milliseconds: Optional[pulumi.Input[int]] = None,
                 cpu_set: Optional[pulumi.Input[str]] = None,
                 cpu_shares: Optional[pulumi.Input[int]] = None,
                 destroy_grace_seconds: Optional[pulumi.Input[int]] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerDeviceArgs']]]] = None,
                 dns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dns_opts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dns_searches: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 domainname: Optional[pulumi.Input[str]] = None,
                 entrypoints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gpus: Optional[pulumi.Input[str]] = None,
                 group_adds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 healthcheck: Optional[pulumi.Input['ContainerHealthcheckArgs']] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerHostArgs']]]] = None,
                 init: Optional[pulumi.Input[bool]] = None,
                 ipc_mode: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerLabelArgs']]]] = None,
                 log_driver: Optional[pulumi.Input[str]] = None,
                 log_opts: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 logs: Optional[pulumi.Input[bool]] = None,
                 max_retry_count: Optional[pulumi.Input[int]] = None,
                 memory: Optional[pulumi.Input[int]] = None,
                 memory_swap: Optional[pulumi.Input[int]] = None,
                 mounts: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerMountArgs']]]] = None,
                 must_run: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_mode: Optional[pulumi.Input[str]] = None,
                 networks_advanced: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerNetworksAdvancedArgs']]]] = None,
                 pid_mode: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerPortArgs']]]] = None,
                 privileged: Optional[pulumi.Input[bool]] = None,
                 publish_all_ports: Optional[pulumi.Input[bool]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 remove_volumes: Optional[pulumi.Input[bool]] = None,
                 restart: Optional[pulumi.Input[str]] = None,
                 rm: Optional[pulumi.Input[bool]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 security_opts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 shm_size: Optional[pulumi.Input[int]] = None,
                 start: Optional[pulumi.Input[bool]] = None,
                 stdin_open: Optional[pulumi.Input[bool]] = None,
                 stop_signal: Optional[pulumi.Input[str]] = None,
                 stop_timeout: Optional[pulumi.Input[int]] = None,
                 storage_opts: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 sysctls: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tmpfs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tty: Optional[pulumi.Input[bool]] = None,
                 ulimits: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerUlimitArgs']]]] = None,
                 uploads: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerUploadArgs']]]] = None,
                 user: Optional[pulumi.Input[str]] = None,
                 userns_mode: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerVolumeArgs']]]] = None,
                 wait: Optional[pulumi.Input[bool]] = None,
                 wait_timeout: Optional[pulumi.Input[int]] = None,
                 working_dir: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Container resource.
        :param pulumi.Input[str] image: The ID of the image to back this container. The easiest way to get this value is to use the `RemoteImage` resource as is shown in the example.
        :param pulumi.Input[bool] attach: If `true` attach to the container after its creation and waits the end of its execution. Defaults to `false`.
        :param pulumi.Input['ContainerCapabilitiesArgs'] capabilities: Add or drop certrain linux capabilities.
        :param pulumi.Input[str] cgroupns_mode: Cgroup namespace mode to use for the container. Possible values are: `private`, `host`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] command: The command to use to start the container. For example, to run `/usr/bin/myprogram -f baz.conf` set the command to be `["/usr/bin/myprogram","-f","baz.con"]`.
        :param pulumi.Input[int] container_read_refresh_timeout_milliseconds: The total number of milliseconds to wait for the container to reach status 'running'
        :param pulumi.Input[str] cpu_set: A comma-separated list or hyphen-separated range of CPUs a container can use, e.g. `0-1`.
        :param pulumi.Input[int] cpu_shares: CPU shares (relative weight) for the container.
        :param pulumi.Input[int] destroy_grace_seconds: If defined will attempt to stop the container before destroying. Container will be destroyed after `n` seconds or on successful stop.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerDeviceArgs']]] devices: Bind devices to the container.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns: DNS servers to use.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_opts: DNS options used by the DNS provider(s), see `resolv.conf` documentation for valid list of options.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_searches: DNS search domains that are used when bare unqualified hostnames are used inside of the container.
        :param pulumi.Input[str] domainname: Domain name of the container.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] entrypoints: The command to use as the Entrypoint for the container. The Entrypoint allows you to configure a container to run as an executable. For example, to run `/usr/bin/myprogram` when starting a container, set the entrypoint to be `"/usr/bin/myprogra"]`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] envs: Environment variables to set in the form of `KEY=VALUE`, e.g. `DEBUG=0`
        :param pulumi.Input[str] gpus: GPU devices to add to the container. Currently, only the value `all` is supported. Passing any other value will result in unexpected behavior.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_adds: Additional groups for the container user
        :param pulumi.Input['ContainerHealthcheckArgs'] healthcheck: A test to perform to check that the container is healthy
        :param pulumi.Input[str] hostname: Hostname of the container.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerHostArgs']]] hosts: Additional hosts to add to the container.
        :param pulumi.Input[bool] init: Configured whether an init process should be injected for this container. If unset this will default to the `dockerd` defaults.
        :param pulumi.Input[str] ipc_mode: IPC sharing mode for the container. Possible values are: `none`, `private`, `shareable`, `container:<name|id>` or `host`.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerLabelArgs']]] labels: User-defined key/value metadata
        :param pulumi.Input[str] log_driver: The logging driver to use for the container.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] log_opts: Key/value pairs to use as options for the logging driver.
        :param pulumi.Input[bool] logs: Save the container logs (`attach` must be enabled). Defaults to `false`.
        :param pulumi.Input[int] max_retry_count: The maximum amount of times to an attempt a restart when `restart` is set to 'on-failure'.
        :param pulumi.Input[int] memory: The memory limit for the container in MBs.
        :param pulumi.Input[int] memory_swap: The total memory limit (memory + swap) for the container in MBs. This setting may compute to `-1` after `pulumi up` if the target host doesn't support memory swap, when that is the case docker will use a soft limitation.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerMountArgs']]] mounts: Specification for mounts to be added to containers created as part of the service.
        :param pulumi.Input[str] name: The name of the container.
        :param pulumi.Input[str] network_mode: Network mode of the container.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerNetworksAdvancedArgs']]] networks_advanced: The networks the container is attached to
        :param pulumi.Input[str] pid_mode: he PID (Process) Namespace mode for the container. Either `container:<name|id>` or `host`.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerPortArgs']]] ports: Publish a container's port(s) to the host.
        :param pulumi.Input[bool] privileged: If `true`, the container runs in privileged mode.
        :param pulumi.Input[bool] publish_all_ports: Publish all ports of the container.
        :param pulumi.Input[bool] read_only: If `true`, the container will be started as readonly. Defaults to `false`.
        :param pulumi.Input[bool] remove_volumes: If `true`, it will remove anonymous volumes associated with the container. Defaults to `true`.
        :param pulumi.Input[str] restart: The restart policy for the container. Must be one of 'no', 'on-failure', 'always', 'unless-stopped'. Defaults to `no`.
        :param pulumi.Input[bool] rm: If `true`, then the container will be automatically removed when it exits. Defaults to `false`.
        :param pulumi.Input[str] runtime: Runtime to use for the container.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_opts: List of string values to customize labels for MLS systems, such as SELinux. See https://docs.docker.com/engine/reference/run/#security-configuration.
        :param pulumi.Input[int] shm_size: Size of `/dev/shm` in MBs.
        :param pulumi.Input[bool] start: If `true`, then the Docker container will be started after creation. If `false`, then the container is only created. Defaults to `true`.
        :param pulumi.Input[bool] stdin_open: If `true`, keep STDIN open even if not attached (`docker run -i`). Defaults to `false`.
        :param pulumi.Input[str] stop_signal: Signal to stop a container (default `SIGTERM`).
        :param pulumi.Input[int] stop_timeout: Timeout (in seconds) to stop a container.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] storage_opts: Key/value pairs for the storage driver options, e.g. `size`: `120G`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] sysctls: A map of kernel parameters (sysctls) to set in the container.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tmpfs: A map of container directories which should be replaced by `tmpfs mounts`, and their corresponding mount options.
        :param pulumi.Input[bool] tty: If `true`, allocate a pseudo-tty (`docker run -t`). Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerUlimitArgs']]] ulimits: Ulimit options to add.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerUploadArgs']]] uploads: Specifies files to upload to the container before starting it. Only one of `content` or `content_base64` can be set and at least one of them has to be set.
        :param pulumi.Input[str] user: User used for run the first process. Format is `user` or `user:group` which user and group can be passed literraly or by name.
        :param pulumi.Input[str] userns_mode: Sets the usernamespace mode for the container when usernamespace remapping option is enabled.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerVolumeArgs']]] volumes: Spec for mounting volumes in the container.
        :param pulumi.Input[bool] wait: If `true`, then the Docker container is waited for being healthy state after creation. If `false`, then the container health state is not checked. Defaults to `false`.
        :param pulumi.Input[int] wait_timeout: The timeout in seconds to wait the container to be healthy after creation. Defaults to `60`.
        :param pulumi.Input[str] working_dir: The working directory for commands to run in.
        """
        pulumi.set(__self__, "image", image)
        if attach is not None:
            pulumi.set(__self__, "attach", attach)
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if cgroupns_mode is not None:
            pulumi.set(__self__, "cgroupns_mode", cgroupns_mode)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if container_read_refresh_timeout_milliseconds is not None:
            pulumi.set(__self__, "container_read_refresh_timeout_milliseconds", container_read_refresh_timeout_milliseconds)
        if cpu_set is not None:
            pulumi.set(__self__, "cpu_set", cpu_set)
        if cpu_shares is not None:
            pulumi.set(__self__, "cpu_shares", cpu_shares)
        if destroy_grace_seconds is not None:
            pulumi.set(__self__, "destroy_grace_seconds", destroy_grace_seconds)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if dns is not None:
            pulumi.set(__self__, "dns", dns)
        if dns_opts is not None:
            pulumi.set(__self__, "dns_opts", dns_opts)
        if dns_searches is not None:
            pulumi.set(__self__, "dns_searches", dns_searches)
        if domainname is not None:
            pulumi.set(__self__, "domainname", domainname)
        if entrypoints is not None:
            pulumi.set(__self__, "entrypoints", entrypoints)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if gpus is not None:
            pulumi.set(__self__, "gpus", gpus)
        if group_adds is not None:
            pulumi.set(__self__, "group_adds", group_adds)
        if healthcheck is not None:
            pulumi.set(__self__, "healthcheck", healthcheck)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if init is not None:
            pulumi.set(__self__, "init", init)
        if ipc_mode is not None:
            pulumi.set(__self__, "ipc_mode", ipc_mode)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if log_driver is not None:
            pulumi.set(__self__, "log_driver", log_driver)
        if log_opts is not None:
            pulumi.set(__self__, "log_opts", log_opts)
        if logs is not None:
            pulumi.set(__self__, "logs", logs)
        if max_retry_count is not None:
            pulumi.set(__self__, "max_retry_count", max_retry_count)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if memory_swap is not None:
            pulumi.set(__self__, "memory_swap", memory_swap)
        if mounts is not None:
            pulumi.set(__self__, "mounts", mounts)
        if must_run is not None:
            pulumi.set(__self__, "must_run", must_run)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_mode is not None:
            pulumi.set(__self__, "network_mode", network_mode)
        if networks_advanced is not None:
            pulumi.set(__self__, "networks_advanced", networks_advanced)
        if pid_mode is not None:
            pulumi.set(__self__, "pid_mode", pid_mode)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if privileged is not None:
            pulumi.set(__self__, "privileged", privileged)
        if publish_all_ports is not None:
            pulumi.set(__self__, "publish_all_ports", publish_all_ports)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if remove_volumes is not None:
            pulumi.set(__self__, "remove_volumes", remove_volumes)
        if restart is not None:
            pulumi.set(__self__, "restart", restart)
        if rm is not None:
            pulumi.set(__self__, "rm", rm)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if security_opts is not None:
            pulumi.set(__self__, "security_opts", security_opts)
        if shm_size is not None:
            pulumi.set(__self__, "shm_size", shm_size)
        if start is not None:
            pulumi.set(__self__, "start", start)
        if stdin_open is not None:
            pulumi.set(__self__, "stdin_open", stdin_open)
        if stop_signal is not None:
            pulumi.set(__self__, "stop_signal", stop_signal)
        if stop_timeout is not None:
            pulumi.set(__self__, "stop_timeout", stop_timeout)
        if storage_opts is not None:
            pulumi.set(__self__, "storage_opts", storage_opts)
        if sysctls is not None:
            pulumi.set(__self__, "sysctls", sysctls)
        if tmpfs is not None:
            pulumi.set(__self__, "tmpfs", tmpfs)
        if tty is not None:
            pulumi.set(__self__, "tty", tty)
        if ulimits is not None:
            pulumi.set(__self__, "ulimits", ulimits)
        if uploads is not None:
            pulumi.set(__self__, "uploads", uploads)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if userns_mode is not None:
            pulumi.set(__self__, "userns_mode", userns_mode)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if wait is not None:
            pulumi.set(__self__, "wait", wait)
        if wait_timeout is not None:
            pulumi.set(__self__, "wait_timeout", wait_timeout)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def image(self) -> pulumi.Input[str]:
        """
        The ID of the image to back this container. The easiest way to get this value is to use the `RemoteImage` resource as is shown in the example.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[str]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def attach(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true` attach to the container after its creation and waits the end of its execution. Defaults to `false`.
        """
        return pulumi.get(self, "attach")

    @attach.setter
    def attach(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "attach", value)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input['ContainerCapabilitiesArgs']]:
        """
        Add or drop certrain linux capabilities.
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input['ContainerCapabilitiesArgs']]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter(name="cgroupnsMode")
    def cgroupns_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Cgroup namespace mode to use for the container. Possible values are: `private`, `host`.
        """
        return pulumi.get(self, "cgroupns_mode")

    @cgroupns_mode.setter
    def cgroupns_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cgroupns_mode", value)

    @property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The command to use to start the container. For example, to run `/usr/bin/myprogram -f baz.conf` set the command to be `["/usr/bin/myprogram","-f","baz.con"]`.
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter(name="containerReadRefreshTimeoutMilliseconds")
    def container_read_refresh_timeout_milliseconds(self) -> Optional[pulumi.Input[int]]:
        """
        The total number of milliseconds to wait for the container to reach status 'running'
        """
        return pulumi.get(self, "container_read_refresh_timeout_milliseconds")

    @container_read_refresh_timeout_milliseconds.setter
    def container_read_refresh_timeout_milliseconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "container_read_refresh_timeout_milliseconds", value)

    @property
    @pulumi.getter(name="cpuSet")
    def cpu_set(self) -> Optional[pulumi.Input[str]]:
        """
        A comma-separated list or hyphen-separated range of CPUs a container can use, e.g. `0-1`.
        """
        return pulumi.get(self, "cpu_set")

    @cpu_set.setter
    def cpu_set(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpu_set", value)

    @property
    @pulumi.getter(name="cpuShares")
    def cpu_shares(self) -> Optional[pulumi.Input[int]]:
        """
        CPU shares (relative weight) for the container.
        """
        return pulumi.get(self, "cpu_shares")

    @cpu_shares.setter
    def cpu_shares(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_shares", value)

    @property
    @pulumi.getter(name="destroyGraceSeconds")
    def destroy_grace_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        If defined will attempt to stop the container before destroying. Container will be destroyed after `n` seconds or on successful stop.
        """
        return pulumi.get(self, "destroy_grace_seconds")

    @destroy_grace_seconds.setter
    def destroy_grace_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "destroy_grace_seconds", value)

    @property
    @pulumi.getter
    def devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerDeviceArgs']]]]:
        """
        Bind devices to the container.
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerDeviceArgs']]]]):
        pulumi.set(self, "devices", value)

    @property
    @pulumi.getter
    def dns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        DNS servers to use.
        """
        return pulumi.get(self, "dns")

    @dns.setter
    def dns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns", value)

    @property
    @pulumi.getter(name="dnsOpts")
    def dns_opts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        DNS options used by the DNS provider(s), see `resolv.conf` documentation for valid list of options.
        """
        return pulumi.get(self, "dns_opts")

    @dns_opts.setter
    def dns_opts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_opts", value)

    @property
    @pulumi.getter(name="dnsSearches")
    def dns_searches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        DNS search domains that are used when bare unqualified hostnames are used inside of the container.
        """
        return pulumi.get(self, "dns_searches")

    @dns_searches.setter
    def dns_searches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_searches", value)

    @property
    @pulumi.getter
    def domainname(self) -> Optional[pulumi.Input[str]]:
        """
        Domain name of the container.
        """
        return pulumi.get(self, "domainname")

    @domainname.setter
    def domainname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domainname", value)

    @property
    @pulumi.getter
    def entrypoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The command to use as the Entrypoint for the container. The Entrypoint allows you to configure a container to run as an executable. For example, to run `/usr/bin/myprogram` when starting a container, set the entrypoint to be `"/usr/bin/myprogra"]`.
        """
        return pulumi.get(self, "entrypoints")

    @entrypoints.setter
    def entrypoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "entrypoints", value)

    @property
    @pulumi.getter
    def envs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Environment variables to set in the form of `KEY=VALUE`, e.g. `DEBUG=0`
        """
        return pulumi.get(self, "envs")

    @envs.setter
    def envs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "envs", value)

    @property
    @pulumi.getter
    def gpus(self) -> Optional[pulumi.Input[str]]:
        """
        GPU devices to add to the container. Currently, only the value `all` is supported. Passing any other value will result in unexpected behavior.
        """
        return pulumi.get(self, "gpus")

    @gpus.setter
    def gpus(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gpus", value)

    @property
    @pulumi.getter(name="groupAdds")
    def group_adds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Additional groups for the container user
        """
        return pulumi.get(self, "group_adds")

    @group_adds.setter
    def group_adds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "group_adds", value)

    @property
    @pulumi.getter
    def healthcheck(self) -> Optional[pulumi.Input['ContainerHealthcheckArgs']]:
        """
        A test to perform to check that the container is healthy
        """
        return pulumi.get(self, "healthcheck")

    @healthcheck.setter
    def healthcheck(self, value: Optional[pulumi.Input['ContainerHealthcheckArgs']]):
        pulumi.set(self, "healthcheck", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname of the container.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerHostArgs']]]]:
        """
        Additional hosts to add to the container.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerHostArgs']]]]):
        pulumi.set(self, "hosts", value)

    @property
    @pulumi.getter
    def init(self) -> Optional[pulumi.Input[bool]]:
        """
        Configured whether an init process should be injected for this container. If unset this will default to the `dockerd` defaults.
        """
        return pulumi.get(self, "init")

    @init.setter
    def init(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "init", value)

    @property
    @pulumi.getter(name="ipcMode")
    def ipc_mode(self) -> Optional[pulumi.Input[str]]:
        """
        IPC sharing mode for the container. Possible values are: `none`, `private`, `shareable`, `container:<name|id>` or `host`.
        """
        return pulumi.get(self, "ipc_mode")

    @ipc_mode.setter
    def ipc_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipc_mode", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerLabelArgs']]]]:
        """
        User-defined key/value metadata
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="logDriver")
    def log_driver(self) -> Optional[pulumi.Input[str]]:
        """
        The logging driver to use for the container.
        """
        return pulumi.get(self, "log_driver")

    @log_driver.setter
    def log_driver(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_driver", value)

    @property
    @pulumi.getter(name="logOpts")
    def log_opts(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key/value pairs to use as options for the logging driver.
        """
        return pulumi.get(self, "log_opts")

    @log_opts.setter
    def log_opts(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "log_opts", value)

    @property
    @pulumi.getter
    def logs(self) -> Optional[pulumi.Input[bool]]:
        """
        Save the container logs (`attach` must be enabled). Defaults to `false`.
        """
        return pulumi.get(self, "logs")

    @logs.setter
    def logs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "logs", value)

    @property
    @pulumi.getter(name="maxRetryCount")
    def max_retry_count(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum amount of times to an attempt a restart when `restart` is set to 'on-failure'.
        """
        return pulumi.get(self, "max_retry_count")

    @max_retry_count.setter
    def max_retry_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retry_count", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[int]]:
        """
        The memory limit for the container in MBs.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory", value)

    @property
    @pulumi.getter(name="memorySwap")
    def memory_swap(self) -> Optional[pulumi.Input[int]]:
        """
        The total memory limit (memory + swap) for the container in MBs. This setting may compute to `-1` after `pulumi up` if the target host doesn't support memory swap, when that is the case docker will use a soft limitation.
        """
        return pulumi.get(self, "memory_swap")

    @memory_swap.setter
    def memory_swap(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_swap", value)

    @property
    @pulumi.getter
    def mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerMountArgs']]]]:
        """
        Specification for mounts to be added to containers created as part of the service.
        """
        return pulumi.get(self, "mounts")

    @mounts.setter
    def mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerMountArgs']]]]):
        pulumi.set(self, "mounts", value)

    @property
    @pulumi.getter(name="mustRun")
    def must_run(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "must_run")

    @must_run.setter
    def must_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "must_run", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the container.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkMode")
    def network_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Network mode of the container.
        """
        return pulumi.get(self, "network_mode")

    @network_mode.setter
    def network_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_mode", value)

    @property
    @pulumi.getter(name="networksAdvanced")
    def networks_advanced(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerNetworksAdvancedArgs']]]]:
        """
        The networks the container is attached to
        """
        return pulumi.get(self, "networks_advanced")

    @networks_advanced.setter
    def networks_advanced(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerNetworksAdvancedArgs']]]]):
        pulumi.set(self, "networks_advanced", value)

    @property
    @pulumi.getter(name="pidMode")
    def pid_mode(self) -> Optional[pulumi.Input[str]]:
        """
        he PID (Process) Namespace mode for the container. Either `container:<name|id>` or `host`.
        """
        return pulumi.get(self, "pid_mode")

    @pid_mode.setter
    def pid_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pid_mode", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerPortArgs']]]]:
        """
        Publish a container's port(s) to the host.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerPortArgs']]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter
    def privileged(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true`, the container runs in privileged mode.
        """
        return pulumi.get(self, "privileged")

    @privileged.setter
    def privileged(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "privileged", value)

    @property
    @pulumi.getter(name="publishAllPorts")
    def publish_all_ports(self) -> Optional[pulumi.Input[bool]]:
        """
        Publish all ports of the container.
        """
        return pulumi.get(self, "publish_all_ports")

    @publish_all_ports.setter
    def publish_all_ports(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "publish_all_ports", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true`, the container will be started as readonly. Defaults to `false`.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="removeVolumes")
    def remove_volumes(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true`, it will remove anonymous volumes associated with the container. Defaults to `true`.
        """
        return pulumi.get(self, "remove_volumes")

    @remove_volumes.setter
    def remove_volumes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remove_volumes", value)

    @property
    @pulumi.getter
    def restart(self) -> Optional[pulumi.Input[str]]:
        """
        The restart policy for the container. Must be one of 'no', 'on-failure', 'always', 'unless-stopped'. Defaults to `no`.
        """
        return pulumi.get(self, "restart")

    @restart.setter
    def restart(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "restart", value)

    @property
    @pulumi.getter
    def rm(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true`, then the container will be automatically removed when it exits. Defaults to `false`.
        """
        return pulumi.get(self, "rm")

    @rm.setter
    def rm(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "rm", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[str]]:
        """
        Runtime to use for the container.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="securityOpts")
    def security_opts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of string values to customize labels for MLS systems, such as SELinux. See https://docs.docker.com/engine/reference/run/#security-configuration.
        """
        return pulumi.get(self, "security_opts")

    @security_opts.setter
    def security_opts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_opts", value)

    @property
    @pulumi.getter(name="shmSize")
    def shm_size(self) -> Optional[pulumi.Input[int]]:
        """
        Size of `/dev/shm` in MBs.
        """
        return pulumi.get(self, "shm_size")

    @shm_size.setter
    def shm_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "shm_size", value)

    @property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true`, then the Docker container will be started after creation. If `false`, then the container is only created. Defaults to `true`.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "start", value)

    @property
    @pulumi.getter(name="stdinOpen")
    def stdin_open(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true`, keep STDIN open even if not attached (`docker run -i`). Defaults to `false`.
        """
        return pulumi.get(self, "stdin_open")

    @stdin_open.setter
    def stdin_open(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "stdin_open", value)

    @property
    @pulumi.getter(name="stopSignal")
    def stop_signal(self) -> Optional[pulumi.Input[str]]:
        """
        Signal to stop a container (default `SIGTERM`).
        """
        return pulumi.get(self, "stop_signal")

    @stop_signal.setter
    def stop_signal(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stop_signal", value)

    @property
    @pulumi.getter(name="stopTimeout")
    def stop_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Timeout (in seconds) to stop a container.
        """
        return pulumi.get(self, "stop_timeout")

    @stop_timeout.setter
    def stop_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "stop_timeout", value)

    @property
    @pulumi.getter(name="storageOpts")
    def storage_opts(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key/value pairs for the storage driver options, e.g. `size`: `120G`
        """
        return pulumi.get(self, "storage_opts")

    @storage_opts.setter
    def storage_opts(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "storage_opts", value)

    @property
    @pulumi.getter
    def sysctls(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of kernel parameters (sysctls) to set in the container.
        """
        return pulumi.get(self, "sysctls")

    @sysctls.setter
    def sysctls(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "sysctls", value)

    @property
    @pulumi.getter
    def tmpfs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of container directories which should be replaced by `tmpfs mounts`, and their corresponding mount options.
        """
        return pulumi.get(self, "tmpfs")

    @tmpfs.setter
    def tmpfs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tmpfs", value)

    @property
    @pulumi.getter
    def tty(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true`, allocate a pseudo-tty (`docker run -t`). Defaults to `false`.
        """
        return pulumi.get(self, "tty")

    @tty.setter
    def tty(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tty", value)

    @property
    @pulumi.getter
    def ulimits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerUlimitArgs']]]]:
        """
        Ulimit options to add.
        """
        return pulumi.get(self, "ulimits")

    @ulimits.setter
    def ulimits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerUlimitArgs']]]]):
        pulumi.set(self, "ulimits", value)

    @property
    @pulumi.getter
    def uploads(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerUploadArgs']]]]:
        """
        Specifies files to upload to the container before starting it. Only one of `content` or `content_base64` can be set and at least one of them has to be set.
        """
        return pulumi.get(self, "uploads")

    @uploads.setter
    def uploads(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerUploadArgs']]]]):
        pulumi.set(self, "uploads", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[str]]:
        """
        User used for run the first process. Format is `user` or `user:group` which user and group can be passed literraly or by name.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter(name="usernsMode")
    def userns_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Sets the usernamespace mode for the container when usernamespace remapping option is enabled.
        """
        return pulumi.get(self, "userns_mode")

    @userns_mode.setter
    def userns_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "userns_mode", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerVolumeArgs']]]]:
        """
        Spec for mounting volumes in the container.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)

    @property
    @pulumi.getter
    def wait(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true`, then the Docker container is waited for being healthy state after creation. If `false`, then the container health state is not checked. Defaults to `false`.
        """
        return pulumi.get(self, "wait")

    @wait.setter
    def wait(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait", value)

    @property
    @pulumi.getter(name="waitTimeout")
    def wait_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout in seconds to wait the container to be healthy after creation. Defaults to `60`.
        """
        return pulumi.get(self, "wait_timeout")

    @wait_timeout.setter
    def wait_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "wait_timeout", value)

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[pulumi.Input[str]]:
        """
        The working directory for commands to run in.
        """
        return pulumi.get(self, "working_dir")

    @working_dir.setter
    def working_dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "working_dir", value)


@pulumi.input_type
class _ContainerState:
    def __init__(__self__, *,
                 attach: Optional[pulumi.Input[bool]] = None,
                 bridge: Optional[pulumi.Input[str]] = None,
                 capabilities: Optional[pulumi.Input['ContainerCapabilitiesArgs']] = None,
                 cgroupns_mode: Optional[pulumi.Input[str]] = None,
                 command: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 container_logs: Optional[pulumi.Input[str]] = None,
                 container_read_refresh_timeout_milliseconds: Optional[pulumi.Input[int]] = None,
                 cpu_set: Optional[pulumi.Input[str]] = None,
                 cpu_shares: Optional[pulumi.Input[int]] = None,
                 destroy_grace_seconds: Optional[pulumi.Input[int]] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerDeviceArgs']]]] = None,
                 dns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dns_opts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dns_searches: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 domainname: Optional[pulumi.Input[str]] = None,
                 entrypoints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 exit_code: Optional[pulumi.Input[int]] = None,
                 gpus: Optional[pulumi.Input[str]] = None,
                 group_adds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 healthcheck: Optional[pulumi.Input['ContainerHealthcheckArgs']] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerHostArgs']]]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 init: Optional[pulumi.Input[bool]] = None,
                 ipc_mode: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerLabelArgs']]]] = None,
                 log_driver: Optional[pulumi.Input[str]] = None,
                 log_opts: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 logs: Optional[pulumi.Input[bool]] = None,
                 max_retry_count: Optional[pulumi.Input[int]] = None,
                 memory: Optional[pulumi.Input[int]] = None,
                 memory_swap: Optional[pulumi.Input[int]] = None,
                 mounts: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerMountArgs']]]] = None,
                 must_run: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_datas: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerNetworkDataArgs']]]] = None,
                 network_mode: Optional[pulumi.Input[str]] = None,
                 networks_advanced: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerNetworksAdvancedArgs']]]] = None,
                 pid_mode: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerPortArgs']]]] = None,
                 privileged: Optional[pulumi.Input[bool]] = None,
                 publish_all_ports: Optional[pulumi.Input[bool]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 remove_volumes: Optional[pulumi.Input[bool]] = None,
                 restart: Optional[pulumi.Input[str]] = None,
                 rm: Optional[pulumi.Input[bool]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 security_opts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 shm_size: Optional[pulumi.Input[int]] = None,
                 start: Optional[pulumi.Input[bool]] = None,
                 stdin_open: Optional[pulumi.Input[bool]] = None,
                 stop_signal: Optional[pulumi.Input[str]] = None,
                 stop_timeout: Optional[pulumi.Input[int]] = None,
                 storage_opts: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 sysctls: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tmpfs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tty: Optional[pulumi.Input[bool]] = None,
                 ulimits: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerUlimitArgs']]]] = None,
                 uploads: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerUploadArgs']]]] = None,
                 user: Optional[pulumi.Input[str]] = None,
                 userns_mode: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerVolumeArgs']]]] = None,
                 wait: Optional[pulumi.Input[bool]] = None,
                 wait_timeout: Optional[pulumi.Input[int]] = None,
                 working_dir: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Container resources.
        :param pulumi.Input[bool] attach: If `true` attach to the container after its creation and waits the end of its execution. Defaults to `false`.
        :param pulumi.Input[str] bridge: The network bridge of the container as read from its NetworkSettings.
        :param pulumi.Input['ContainerCapabilitiesArgs'] capabilities: Add or drop certrain linux capabilities.
        :param pulumi.Input[str] cgroupns_mode: Cgroup namespace mode to use for the container. Possible values are: `private`, `host`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] command: The command to use to start the container. For example, to run `/usr/bin/myprogram -f baz.conf` set the command to be `["/usr/bin/myprogram","-f","baz.con"]`.
        :param pulumi.Input[str] container_logs: The logs of the container if its execution is done (`attach` must be disabled).
        :param pulumi.Input[int] container_read_refresh_timeout_milliseconds: The total number of milliseconds to wait for the container to reach status 'running'
        :param pulumi.Input[str] cpu_set: A comma-separated list or hyphen-separated range of CPUs a container can use, e.g. `0-1`.
        :param pulumi.Input[int] cpu_shares: CPU shares (relative weight) for the container.
        :param pulumi.Input[int] destroy_grace_seconds: If defined will attempt to stop the container before destroying. Container will be destroyed after `n` seconds or on successful stop.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerDeviceArgs']]] devices: Bind devices to the container.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns: DNS servers to use.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_opts: DNS options used by the DNS provider(s), see `resolv.conf` documentation for valid list of options.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_searches: DNS search domains that are used when bare unqualified hostnames are used inside of the container.
        :param pulumi.Input[str] domainname: Domain name of the container.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] entrypoints: The command to use as the Entrypoint for the container. The Entrypoint allows you to configure a container to run as an executable. For example, to run `/usr/bin/myprogram` when starting a container, set the entrypoint to be `"/usr/bin/myprogra"]`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] envs: Environment variables to set in the form of `KEY=VALUE`, e.g. `DEBUG=0`
        :param pulumi.Input[int] exit_code: The exit code of the container if its execution is done (`must_run` must be disabled).
        :param pulumi.Input[str] gpus: GPU devices to add to the container. Currently, only the value `all` is supported. Passing any other value will result in unexpected behavior.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_adds: Additional groups for the container user
        :param pulumi.Input['ContainerHealthcheckArgs'] healthcheck: A test to perform to check that the container is healthy
        :param pulumi.Input[str] hostname: Hostname of the container.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerHostArgs']]] hosts: Additional hosts to add to the container.
        :param pulumi.Input[str] image: The ID of the image to back this container. The easiest way to get this value is to use the `RemoteImage` resource as is shown in the example.
        :param pulumi.Input[bool] init: Configured whether an init process should be injected for this container. If unset this will default to the `dockerd` defaults.
        :param pulumi.Input[str] ipc_mode: IPC sharing mode for the container. Possible values are: `none`, `private`, `shareable`, `container:<name|id>` or `host`.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerLabelArgs']]] labels: User-defined key/value metadata
        :param pulumi.Input[str] log_driver: The logging driver to use for the container.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] log_opts: Key/value pairs to use as options for the logging driver.
        :param pulumi.Input[bool] logs: Save the container logs (`attach` must be enabled). Defaults to `false`.
        :param pulumi.Input[int] max_retry_count: The maximum amount of times to an attempt a restart when `restart` is set to 'on-failure'.
        :param pulumi.Input[int] memory: The memory limit for the container in MBs.
        :param pulumi.Input[int] memory_swap: The total memory limit (memory + swap) for the container in MBs. This setting may compute to `-1` after `pulumi up` if the target host doesn't support memory swap, when that is the case docker will use a soft limitation.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerMountArgs']]] mounts: Specification for mounts to be added to containers created as part of the service.
        :param pulumi.Input[str] name: The name of the container.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerNetworkDataArgs']]] network_datas: The data of the networks the container is connected to.
        :param pulumi.Input[str] network_mode: Network mode of the container.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerNetworksAdvancedArgs']]] networks_advanced: The networks the container is attached to
        :param pulumi.Input[str] pid_mode: he PID (Process) Namespace mode for the container. Either `container:<name|id>` or `host`.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerPortArgs']]] ports: Publish a container's port(s) to the host.
        :param pulumi.Input[bool] privileged: If `true`, the container runs in privileged mode.
        :param pulumi.Input[bool] publish_all_ports: Publish all ports of the container.
        :param pulumi.Input[bool] read_only: If `true`, the container will be started as readonly. Defaults to `false`.
        :param pulumi.Input[bool] remove_volumes: If `true`, it will remove anonymous volumes associated with the container. Defaults to `true`.
        :param pulumi.Input[str] restart: The restart policy for the container. Must be one of 'no', 'on-failure', 'always', 'unless-stopped'. Defaults to `no`.
        :param pulumi.Input[bool] rm: If `true`, then the container will be automatically removed when it exits. Defaults to `false`.
        :param pulumi.Input[str] runtime: Runtime to use for the container.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_opts: List of string values to customize labels for MLS systems, such as SELinux. See https://docs.docker.com/engine/reference/run/#security-configuration.
        :param pulumi.Input[int] shm_size: Size of `/dev/shm` in MBs.
        :param pulumi.Input[bool] start: If `true`, then the Docker container will be started after creation. If `false`, then the container is only created. Defaults to `true`.
        :param pulumi.Input[bool] stdin_open: If `true`, keep STDIN open even if not attached (`docker run -i`). Defaults to `false`.
        :param pulumi.Input[str] stop_signal: Signal to stop a container (default `SIGTERM`).
        :param pulumi.Input[int] stop_timeout: Timeout (in seconds) to stop a container.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] storage_opts: Key/value pairs for the storage driver options, e.g. `size`: `120G`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] sysctls: A map of kernel parameters (sysctls) to set in the container.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tmpfs: A map of container directories which should be replaced by `tmpfs mounts`, and their corresponding mount options.
        :param pulumi.Input[bool] tty: If `true`, allocate a pseudo-tty (`docker run -t`). Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerUlimitArgs']]] ulimits: Ulimit options to add.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerUploadArgs']]] uploads: Specifies files to upload to the container before starting it. Only one of `content` or `content_base64` can be set and at least one of them has to be set.
        :param pulumi.Input[str] user: User used for run the first process. Format is `user` or `user:group` which user and group can be passed literraly or by name.
        :param pulumi.Input[str] userns_mode: Sets the usernamespace mode for the container when usernamespace remapping option is enabled.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerVolumeArgs']]] volumes: Spec for mounting volumes in the container.
        :param pulumi.Input[bool] wait: If `true`, then the Docker container is waited for being healthy state after creation. If `false`, then the container health state is not checked. Defaults to `false`.
        :param pulumi.Input[int] wait_timeout: The timeout in seconds to wait the container to be healthy after creation. Defaults to `60`.
        :param pulumi.Input[str] working_dir: The working directory for commands to run in.
        """
        if attach is not None:
            pulumi.set(__self__, "attach", attach)
        if bridge is not None:
            pulumi.set(__self__, "bridge", bridge)
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if cgroupns_mode is not None:
            pulumi.set(__self__, "cgroupns_mode", cgroupns_mode)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if container_logs is not None:
            pulumi.set(__self__, "container_logs", container_logs)
        if container_read_refresh_timeout_milliseconds is not None:
            pulumi.set(__self__, "container_read_refresh_timeout_milliseconds", container_read_refresh_timeout_milliseconds)
        if cpu_set is not None:
            pulumi.set(__self__, "cpu_set", cpu_set)
        if cpu_shares is not None:
            pulumi.set(__self__, "cpu_shares", cpu_shares)
        if destroy_grace_seconds is not None:
            pulumi.set(__self__, "destroy_grace_seconds", destroy_grace_seconds)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if dns is not None:
            pulumi.set(__self__, "dns", dns)
        if dns_opts is not None:
            pulumi.set(__self__, "dns_opts", dns_opts)
        if dns_searches is not None:
            pulumi.set(__self__, "dns_searches", dns_searches)
        if domainname is not None:
            pulumi.set(__self__, "domainname", domainname)
        if entrypoints is not None:
            pulumi.set(__self__, "entrypoints", entrypoints)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if exit_code is not None:
            pulumi.set(__self__, "exit_code", exit_code)
        if gpus is not None:
            pulumi.set(__self__, "gpus", gpus)
        if group_adds is not None:
            pulumi.set(__self__, "group_adds", group_adds)
        if healthcheck is not None:
            pulumi.set(__self__, "healthcheck", healthcheck)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if init is not None:
            pulumi.set(__self__, "init", init)
        if ipc_mode is not None:
            pulumi.set(__self__, "ipc_mode", ipc_mode)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if log_driver is not None:
            pulumi.set(__self__, "log_driver", log_driver)
        if log_opts is not None:
            pulumi.set(__self__, "log_opts", log_opts)
        if logs is not None:
            pulumi.set(__self__, "logs", logs)
        if max_retry_count is not None:
            pulumi.set(__self__, "max_retry_count", max_retry_count)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if memory_swap is not None:
            pulumi.set(__self__, "memory_swap", memory_swap)
        if mounts is not None:
            pulumi.set(__self__, "mounts", mounts)
        if must_run is not None:
            pulumi.set(__self__, "must_run", must_run)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_datas is not None:
            pulumi.set(__self__, "network_datas", network_datas)
        if network_mode is not None:
            pulumi.set(__self__, "network_mode", network_mode)
        if networks_advanced is not None:
            pulumi.set(__self__, "networks_advanced", networks_advanced)
        if pid_mode is not None:
            pulumi.set(__self__, "pid_mode", pid_mode)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if privileged is not None:
            pulumi.set(__self__, "privileged", privileged)
        if publish_all_ports is not None:
            pulumi.set(__self__, "publish_all_ports", publish_all_ports)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if remove_volumes is not None:
            pulumi.set(__self__, "remove_volumes", remove_volumes)
        if restart is not None:
            pulumi.set(__self__, "restart", restart)
        if rm is not None:
            pulumi.set(__self__, "rm", rm)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if security_opts is not None:
            pulumi.set(__self__, "security_opts", security_opts)
        if shm_size is not None:
            pulumi.set(__self__, "shm_size", shm_size)
        if start is not None:
            pulumi.set(__self__, "start", start)
        if stdin_open is not None:
            pulumi.set(__self__, "stdin_open", stdin_open)
        if stop_signal is not None:
            pulumi.set(__self__, "stop_signal", stop_signal)
        if stop_timeout is not None:
            pulumi.set(__self__, "stop_timeout", stop_timeout)
        if storage_opts is not None:
            pulumi.set(__self__, "storage_opts", storage_opts)
        if sysctls is not None:
            pulumi.set(__self__, "sysctls", sysctls)
        if tmpfs is not None:
            pulumi.set(__self__, "tmpfs", tmpfs)
        if tty is not None:
            pulumi.set(__self__, "tty", tty)
        if ulimits is not None:
            pulumi.set(__self__, "ulimits", ulimits)
        if uploads is not None:
            pulumi.set(__self__, "uploads", uploads)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if userns_mode is not None:
            pulumi.set(__self__, "userns_mode", userns_mode)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if wait is not None:
            pulumi.set(__self__, "wait", wait)
        if wait_timeout is not None:
            pulumi.set(__self__, "wait_timeout", wait_timeout)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def attach(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true` attach to the container after its creation and waits the end of its execution. Defaults to `false`.
        """
        return pulumi.get(self, "attach")

    @attach.setter
    def attach(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "attach", value)

    @property
    @pulumi.getter
    def bridge(self) -> Optional[pulumi.Input[str]]:
        """
        The network bridge of the container as read from its NetworkSettings.
        """
        return pulumi.get(self, "bridge")

    @bridge.setter
    def bridge(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bridge", value)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input['ContainerCapabilitiesArgs']]:
        """
        Add or drop certrain linux capabilities.
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input['ContainerCapabilitiesArgs']]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter(name="cgroupnsMode")
    def cgroupns_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Cgroup namespace mode to use for the container. Possible values are: `private`, `host`.
        """
        return pulumi.get(self, "cgroupns_mode")

    @cgroupns_mode.setter
    def cgroupns_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cgroupns_mode", value)

    @property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The command to use to start the container. For example, to run `/usr/bin/myprogram -f baz.conf` set the command to be `["/usr/bin/myprogram","-f","baz.con"]`.
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter(name="containerLogs")
    def container_logs(self) -> Optional[pulumi.Input[str]]:
        """
        The logs of the container if its execution is done (`attach` must be disabled).
        """
        return pulumi.get(self, "container_logs")

    @container_logs.setter
    def container_logs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_logs", value)

    @property
    @pulumi.getter(name="containerReadRefreshTimeoutMilliseconds")
    def container_read_refresh_timeout_milliseconds(self) -> Optional[pulumi.Input[int]]:
        """
        The total number of milliseconds to wait for the container to reach status 'running'
        """
        return pulumi.get(self, "container_read_refresh_timeout_milliseconds")

    @container_read_refresh_timeout_milliseconds.setter
    def container_read_refresh_timeout_milliseconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "container_read_refresh_timeout_milliseconds", value)

    @property
    @pulumi.getter(name="cpuSet")
    def cpu_set(self) -> Optional[pulumi.Input[str]]:
        """
        A comma-separated list or hyphen-separated range of CPUs a container can use, e.g. `0-1`.
        """
        return pulumi.get(self, "cpu_set")

    @cpu_set.setter
    def cpu_set(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpu_set", value)

    @property
    @pulumi.getter(name="cpuShares")
    def cpu_shares(self) -> Optional[pulumi.Input[int]]:
        """
        CPU shares (relative weight) for the container.
        """
        return pulumi.get(self, "cpu_shares")

    @cpu_shares.setter
    def cpu_shares(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_shares", value)

    @property
    @pulumi.getter(name="destroyGraceSeconds")
    def destroy_grace_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        If defined will attempt to stop the container before destroying. Container will be destroyed after `n` seconds or on successful stop.
        """
        return pulumi.get(self, "destroy_grace_seconds")

    @destroy_grace_seconds.setter
    def destroy_grace_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "destroy_grace_seconds", value)

    @property
    @pulumi.getter
    def devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerDeviceArgs']]]]:
        """
        Bind devices to the container.
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerDeviceArgs']]]]):
        pulumi.set(self, "devices", value)

    @property
    @pulumi.getter
    def dns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        DNS servers to use.
        """
        return pulumi.get(self, "dns")

    @dns.setter
    def dns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns", value)

    @property
    @pulumi.getter(name="dnsOpts")
    def dns_opts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        DNS options used by the DNS provider(s), see `resolv.conf` documentation for valid list of options.
        """
        return pulumi.get(self, "dns_opts")

    @dns_opts.setter
    def dns_opts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_opts", value)

    @property
    @pulumi.getter(name="dnsSearches")
    def dns_searches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        DNS search domains that are used when bare unqualified hostnames are used inside of the container.
        """
        return pulumi.get(self, "dns_searches")

    @dns_searches.setter
    def dns_searches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_searches", value)

    @property
    @pulumi.getter
    def domainname(self) -> Optional[pulumi.Input[str]]:
        """
        Domain name of the container.
        """
        return pulumi.get(self, "domainname")

    @domainname.setter
    def domainname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domainname", value)

    @property
    @pulumi.getter
    def entrypoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The command to use as the Entrypoint for the container. The Entrypoint allows you to configure a container to run as an executable. For example, to run `/usr/bin/myprogram` when starting a container, set the entrypoint to be `"/usr/bin/myprogra"]`.
        """
        return pulumi.get(self, "entrypoints")

    @entrypoints.setter
    def entrypoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "entrypoints", value)

    @property
    @pulumi.getter
    def envs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Environment variables to set in the form of `KEY=VALUE`, e.g. `DEBUG=0`
        """
        return pulumi.get(self, "envs")

    @envs.setter
    def envs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "envs", value)

    @property
    @pulumi.getter(name="exitCode")
    def exit_code(self) -> Optional[pulumi.Input[int]]:
        """
        The exit code of the container if its execution is done (`must_run` must be disabled).
        """
        return pulumi.get(self, "exit_code")

    @exit_code.setter
    def exit_code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "exit_code", value)

    @property
    @pulumi.getter
    def gpus(self) -> Optional[pulumi.Input[str]]:
        """
        GPU devices to add to the container. Currently, only the value `all` is supported. Passing any other value will result in unexpected behavior.
        """
        return pulumi.get(self, "gpus")

    @gpus.setter
    def gpus(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gpus", value)

    @property
    @pulumi.getter(name="groupAdds")
    def group_adds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Additional groups for the container user
        """
        return pulumi.get(self, "group_adds")

    @group_adds.setter
    def group_adds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "group_adds", value)

    @property
    @pulumi.getter
    def healthcheck(self) -> Optional[pulumi.Input['ContainerHealthcheckArgs']]:
        """
        A test to perform to check that the container is healthy
        """
        return pulumi.get(self, "healthcheck")

    @healthcheck.setter
    def healthcheck(self, value: Optional[pulumi.Input['ContainerHealthcheckArgs']]):
        pulumi.set(self, "healthcheck", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname of the container.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerHostArgs']]]]:
        """
        Additional hosts to add to the container.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerHostArgs']]]]):
        pulumi.set(self, "hosts", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the image to back this container. The easiest way to get this value is to use the `RemoteImage` resource as is shown in the example.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def init(self) -> Optional[pulumi.Input[bool]]:
        """
        Configured whether an init process should be injected for this container. If unset this will default to the `dockerd` defaults.
        """
        return pulumi.get(self, "init")

    @init.setter
    def init(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "init", value)

    @property
    @pulumi.getter(name="ipcMode")
    def ipc_mode(self) -> Optional[pulumi.Input[str]]:
        """
        IPC sharing mode for the container. Possible values are: `none`, `private`, `shareable`, `container:<name|id>` or `host`.
        """
        return pulumi.get(self, "ipc_mode")

    @ipc_mode.setter
    def ipc_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipc_mode", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerLabelArgs']]]]:
        """
        User-defined key/value metadata
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="logDriver")
    def log_driver(self) -> Optional[pulumi.Input[str]]:
        """
        The logging driver to use for the container.
        """
        return pulumi.get(self, "log_driver")

    @log_driver.setter
    def log_driver(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_driver", value)

    @property
    @pulumi.getter(name="logOpts")
    def log_opts(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key/value pairs to use as options for the logging driver.
        """
        return pulumi.get(self, "log_opts")

    @log_opts.setter
    def log_opts(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "log_opts", value)

    @property
    @pulumi.getter
    def logs(self) -> Optional[pulumi.Input[bool]]:
        """
        Save the container logs (`attach` must be enabled). Defaults to `false`.
        """
        return pulumi.get(self, "logs")

    @logs.setter
    def logs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "logs", value)

    @property
    @pulumi.getter(name="maxRetryCount")
    def max_retry_count(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum amount of times to an attempt a restart when `restart` is set to 'on-failure'.
        """
        return pulumi.get(self, "max_retry_count")

    @max_retry_count.setter
    def max_retry_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retry_count", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[int]]:
        """
        The memory limit for the container in MBs.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory", value)

    @property
    @pulumi.getter(name="memorySwap")
    def memory_swap(self) -> Optional[pulumi.Input[int]]:
        """
        The total memory limit (memory + swap) for the container in MBs. This setting may compute to `-1` after `pulumi up` if the target host doesn't support memory swap, when that is the case docker will use a soft limitation.
        """
        return pulumi.get(self, "memory_swap")

    @memory_swap.setter
    def memory_swap(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_swap", value)

    @property
    @pulumi.getter
    def mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerMountArgs']]]]:
        """
        Specification for mounts to be added to containers created as part of the service.
        """
        return pulumi.get(self, "mounts")

    @mounts.setter
    def mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerMountArgs']]]]):
        pulumi.set(self, "mounts", value)

    @property
    @pulumi.getter(name="mustRun")
    def must_run(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "must_run")

    @must_run.setter
    def must_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "must_run", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the container.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkDatas")
    def network_datas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerNetworkDataArgs']]]]:
        """
        The data of the networks the container is connected to.
        """
        return pulumi.get(self, "network_datas")

    @network_datas.setter
    def network_datas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerNetworkDataArgs']]]]):
        pulumi.set(self, "network_datas", value)

    @property
    @pulumi.getter(name="networkMode")
    def network_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Network mode of the container.
        """
        return pulumi.get(self, "network_mode")

    @network_mode.setter
    def network_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_mode", value)

    @property
    @pulumi.getter(name="networksAdvanced")
    def networks_advanced(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerNetworksAdvancedArgs']]]]:
        """
        The networks the container is attached to
        """
        return pulumi.get(self, "networks_advanced")

    @networks_advanced.setter
    def networks_advanced(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerNetworksAdvancedArgs']]]]):
        pulumi.set(self, "networks_advanced", value)

    @property
    @pulumi.getter(name="pidMode")
    def pid_mode(self) -> Optional[pulumi.Input[str]]:
        """
        he PID (Process) Namespace mode for the container. Either `container:<name|id>` or `host`.
        """
        return pulumi.get(self, "pid_mode")

    @pid_mode.setter
    def pid_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pid_mode", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerPortArgs']]]]:
        """
        Publish a container's port(s) to the host.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerPortArgs']]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter
    def privileged(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true`, the container runs in privileged mode.
        """
        return pulumi.get(self, "privileged")

    @privileged.setter
    def privileged(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "privileged", value)

    @property
    @pulumi.getter(name="publishAllPorts")
    def publish_all_ports(self) -> Optional[pulumi.Input[bool]]:
        """
        Publish all ports of the container.
        """
        return pulumi.get(self, "publish_all_ports")

    @publish_all_ports.setter
    def publish_all_ports(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "publish_all_ports", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true`, the container will be started as readonly. Defaults to `false`.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="removeVolumes")
    def remove_volumes(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true`, it will remove anonymous volumes associated with the container. Defaults to `true`.
        """
        return pulumi.get(self, "remove_volumes")

    @remove_volumes.setter
    def remove_volumes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remove_volumes", value)

    @property
    @pulumi.getter
    def restart(self) -> Optional[pulumi.Input[str]]:
        """
        The restart policy for the container. Must be one of 'no', 'on-failure', 'always', 'unless-stopped'. Defaults to `no`.
        """
        return pulumi.get(self, "restart")

    @restart.setter
    def restart(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "restart", value)

    @property
    @pulumi.getter
    def rm(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true`, then the container will be automatically removed when it exits. Defaults to `false`.
        """
        return pulumi.get(self, "rm")

    @rm.setter
    def rm(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "rm", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[str]]:
        """
        Runtime to use for the container.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="securityOpts")
    def security_opts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of string values to customize labels for MLS systems, such as SELinux. See https://docs.docker.com/engine/reference/run/#security-configuration.
        """
        return pulumi.get(self, "security_opts")

    @security_opts.setter
    def security_opts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_opts", value)

    @property
    @pulumi.getter(name="shmSize")
    def shm_size(self) -> Optional[pulumi.Input[int]]:
        """
        Size of `/dev/shm` in MBs.
        """
        return pulumi.get(self, "shm_size")

    @shm_size.setter
    def shm_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "shm_size", value)

    @property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true`, then the Docker container will be started after creation. If `false`, then the container is only created. Defaults to `true`.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "start", value)

    @property
    @pulumi.getter(name="stdinOpen")
    def stdin_open(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true`, keep STDIN open even if not attached (`docker run -i`). Defaults to `false`.
        """
        return pulumi.get(self, "stdin_open")

    @stdin_open.setter
    def stdin_open(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "stdin_open", value)

    @property
    @pulumi.getter(name="stopSignal")
    def stop_signal(self) -> Optional[pulumi.Input[str]]:
        """
        Signal to stop a container (default `SIGTERM`).
        """
        return pulumi.get(self, "stop_signal")

    @stop_signal.setter
    def stop_signal(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stop_signal", value)

    @property
    @pulumi.getter(name="stopTimeout")
    def stop_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Timeout (in seconds) to stop a container.
        """
        return pulumi.get(self, "stop_timeout")

    @stop_timeout.setter
    def stop_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "stop_timeout", value)

    @property
    @pulumi.getter(name="storageOpts")
    def storage_opts(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key/value pairs for the storage driver options, e.g. `size`: `120G`
        """
        return pulumi.get(self, "storage_opts")

    @storage_opts.setter
    def storage_opts(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "storage_opts", value)

    @property
    @pulumi.getter
    def sysctls(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of kernel parameters (sysctls) to set in the container.
        """
        return pulumi.get(self, "sysctls")

    @sysctls.setter
    def sysctls(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "sysctls", value)

    @property
    @pulumi.getter
    def tmpfs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of container directories which should be replaced by `tmpfs mounts`, and their corresponding mount options.
        """
        return pulumi.get(self, "tmpfs")

    @tmpfs.setter
    def tmpfs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tmpfs", value)

    @property
    @pulumi.getter
    def tty(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true`, allocate a pseudo-tty (`docker run -t`). Defaults to `false`.
        """
        return pulumi.get(self, "tty")

    @tty.setter
    def tty(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tty", value)

    @property
    @pulumi.getter
    def ulimits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerUlimitArgs']]]]:
        """
        Ulimit options to add.
        """
        return pulumi.get(self, "ulimits")

    @ulimits.setter
    def ulimits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerUlimitArgs']]]]):
        pulumi.set(self, "ulimits", value)

    @property
    @pulumi.getter
    def uploads(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerUploadArgs']]]]:
        """
        Specifies files to upload to the container before starting it. Only one of `content` or `content_base64` can be set and at least one of them has to be set.
        """
        return pulumi.get(self, "uploads")

    @uploads.setter
    def uploads(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerUploadArgs']]]]):
        pulumi.set(self, "uploads", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[str]]:
        """
        User used for run the first process. Format is `user` or `user:group` which user and group can be passed literraly or by name.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter(name="usernsMode")
    def userns_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Sets the usernamespace mode for the container when usernamespace remapping option is enabled.
        """
        return pulumi.get(self, "userns_mode")

    @userns_mode.setter
    def userns_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "userns_mode", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerVolumeArgs']]]]:
        """
        Spec for mounting volumes in the container.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)

    @property
    @pulumi.getter
    def wait(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true`, then the Docker container is waited for being healthy state after creation. If `false`, then the container health state is not checked. Defaults to `false`.
        """
        return pulumi.get(self, "wait")

    @wait.setter
    def wait(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait", value)

    @property
    @pulumi.getter(name="waitTimeout")
    def wait_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout in seconds to wait the container to be healthy after creation. Defaults to `60`.
        """
        return pulumi.get(self, "wait_timeout")

    @wait_timeout.setter
    def wait_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "wait_timeout", value)

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[pulumi.Input[str]]:
        """
        The working directory for commands to run in.
        """
        return pulumi.get(self, "working_dir")

    @working_dir.setter
    def working_dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "working_dir", value)


class Container(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attach: Optional[pulumi.Input[bool]] = None,
                 capabilities: Optional[pulumi.Input[Union['ContainerCapabilitiesArgs', 'ContainerCapabilitiesArgsDict']]] = None,
                 cgroupns_mode: Optional[pulumi.Input[str]] = None,
                 command: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 container_read_refresh_timeout_milliseconds: Optional[pulumi.Input[int]] = None,
                 cpu_set: Optional[pulumi.Input[str]] = None,
                 cpu_shares: Optional[pulumi.Input[int]] = None,
                 destroy_grace_seconds: Optional[pulumi.Input[int]] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerDeviceArgs', 'ContainerDeviceArgsDict']]]]] = None,
                 dns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dns_opts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dns_searches: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 domainname: Optional[pulumi.Input[str]] = None,
                 entrypoints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gpus: Optional[pulumi.Input[str]] = None,
                 group_adds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 healthcheck: Optional[pulumi.Input[Union['ContainerHealthcheckArgs', 'ContainerHealthcheckArgsDict']]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerHostArgs', 'ContainerHostArgsDict']]]]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 init: Optional[pulumi.Input[bool]] = None,
                 ipc_mode: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerLabelArgs', 'ContainerLabelArgsDict']]]]] = None,
                 log_driver: Optional[pulumi.Input[str]] = None,
                 log_opts: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 logs: Optional[pulumi.Input[bool]] = None,
                 max_retry_count: Optional[pulumi.Input[int]] = None,
                 memory: Optional[pulumi.Input[int]] = None,
                 memory_swap: Optional[pulumi.Input[int]] = None,
                 mounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerMountArgs', 'ContainerMountArgsDict']]]]] = None,
                 must_run: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_mode: Optional[pulumi.Input[str]] = None,
                 networks_advanced: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerNetworksAdvancedArgs', 'ContainerNetworksAdvancedArgsDict']]]]] = None,
                 pid_mode: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerPortArgs', 'ContainerPortArgsDict']]]]] = None,
                 privileged: Optional[pulumi.Input[bool]] = None,
                 publish_all_ports: Optional[pulumi.Input[bool]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 remove_volumes: Optional[pulumi.Input[bool]] = None,
                 restart: Optional[pulumi.Input[str]] = None,
                 rm: Optional[pulumi.Input[bool]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 security_opts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 shm_size: Optional[pulumi.Input[int]] = None,
                 start: Optional[pulumi.Input[bool]] = None,
                 stdin_open: Optional[pulumi.Input[bool]] = None,
                 stop_signal: Optional[pulumi.Input[str]] = None,
                 stop_timeout: Optional[pulumi.Input[int]] = None,
                 storage_opts: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 sysctls: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tmpfs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tty: Optional[pulumi.Input[bool]] = None,
                 ulimits: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerUlimitArgs', 'ContainerUlimitArgsDict']]]]] = None,
                 uploads: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerUploadArgs', 'ContainerUploadArgsDict']]]]] = None,
                 user: Optional[pulumi.Input[str]] = None,
                 userns_mode: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerVolumeArgs', 'ContainerVolumeArgsDict']]]]] = None,
                 wait: Optional[pulumi.Input[bool]] = None,
                 wait_timeout: Optional[pulumi.Input[int]] = None,
                 working_dir: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        <!-- Bug: Type and Name are switched -->
        Manages the lifecycle of a Docker container.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_docker as docker

        # Find the latest Ubuntu precise image.
        ubuntu_remote_image = docker.RemoteImage("ubuntu", name="ubuntu:precise")
        # Start a container
        ubuntu = docker.Container("ubuntu",
            name="foo",
            image=ubuntu_remote_image.image_id)
        ```

        ## Import

        ### Example

        Assuming you created a `container` as follows

        #!/bin/bash

        docker run --name foo -p8080:80 -d nginx

        prints the container ID

        9a550c0f0163d39d77222d3efd58701b625d47676c25c686c95b5b92d1cba6fd

        you provide the definition for the resource as follows

        terraform

        resource "docker_container" "foo" {

          name  = "foo"

          image = "nginx"

          ports {

            internal = "80"
            
            external = "8080"

          }

        }

        then the import command is as follows

        #!/bin/bash

        ```sh
        $ pulumi import docker:index/container:Container foo 9a550c0f0163d39d77222d3efd58701b625d47676c25c686c95b5b92d1cba6fd
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] attach: If `true` attach to the container after its creation and waits the end of its execution. Defaults to `false`.
        :param pulumi.Input[Union['ContainerCapabilitiesArgs', 'ContainerCapabilitiesArgsDict']] capabilities: Add or drop certrain linux capabilities.
        :param pulumi.Input[str] cgroupns_mode: Cgroup namespace mode to use for the container. Possible values are: `private`, `host`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] command: The command to use to start the container. For example, to run `/usr/bin/myprogram -f baz.conf` set the command to be `["/usr/bin/myprogram","-f","baz.con"]`.
        :param pulumi.Input[int] container_read_refresh_timeout_milliseconds: The total number of milliseconds to wait for the container to reach status 'running'
        :param pulumi.Input[str] cpu_set: A comma-separated list or hyphen-separated range of CPUs a container can use, e.g. `0-1`.
        :param pulumi.Input[int] cpu_shares: CPU shares (relative weight) for the container.
        :param pulumi.Input[int] destroy_grace_seconds: If defined will attempt to stop the container before destroying. Container will be destroyed after `n` seconds or on successful stop.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerDeviceArgs', 'ContainerDeviceArgsDict']]]] devices: Bind devices to the container.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns: DNS servers to use.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_opts: DNS options used by the DNS provider(s), see `resolv.conf` documentation for valid list of options.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_searches: DNS search domains that are used when bare unqualified hostnames are used inside of the container.
        :param pulumi.Input[str] domainname: Domain name of the container.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] entrypoints: The command to use as the Entrypoint for the container. The Entrypoint allows you to configure a container to run as an executable. For example, to run `/usr/bin/myprogram` when starting a container, set the entrypoint to be `"/usr/bin/myprogra"]`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] envs: Environment variables to set in the form of `KEY=VALUE`, e.g. `DEBUG=0`
        :param pulumi.Input[str] gpus: GPU devices to add to the container. Currently, only the value `all` is supported. Passing any other value will result in unexpected behavior.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_adds: Additional groups for the container user
        :param pulumi.Input[Union['ContainerHealthcheckArgs', 'ContainerHealthcheckArgsDict']] healthcheck: A test to perform to check that the container is healthy
        :param pulumi.Input[str] hostname: Hostname of the container.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerHostArgs', 'ContainerHostArgsDict']]]] hosts: Additional hosts to add to the container.
        :param pulumi.Input[str] image: The ID of the image to back this container. The easiest way to get this value is to use the `RemoteImage` resource as is shown in the example.
        :param pulumi.Input[bool] init: Configured whether an init process should be injected for this container. If unset this will default to the `dockerd` defaults.
        :param pulumi.Input[str] ipc_mode: IPC sharing mode for the container. Possible values are: `none`, `private`, `shareable`, `container:<name|id>` or `host`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerLabelArgs', 'ContainerLabelArgsDict']]]] labels: User-defined key/value metadata
        :param pulumi.Input[str] log_driver: The logging driver to use for the container.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] log_opts: Key/value pairs to use as options for the logging driver.
        :param pulumi.Input[bool] logs: Save the container logs (`attach` must be enabled). Defaults to `false`.
        :param pulumi.Input[int] max_retry_count: The maximum amount of times to an attempt a restart when `restart` is set to 'on-failure'.
        :param pulumi.Input[int] memory: The memory limit for the container in MBs.
        :param pulumi.Input[int] memory_swap: The total memory limit (memory + swap) for the container in MBs. This setting may compute to `-1` after `pulumi up` if the target host doesn't support memory swap, when that is the case docker will use a soft limitation.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerMountArgs', 'ContainerMountArgsDict']]]] mounts: Specification for mounts to be added to containers created as part of the service.
        :param pulumi.Input[str] name: The name of the container.
        :param pulumi.Input[str] network_mode: Network mode of the container.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerNetworksAdvancedArgs', 'ContainerNetworksAdvancedArgsDict']]]] networks_advanced: The networks the container is attached to
        :param pulumi.Input[str] pid_mode: he PID (Process) Namespace mode for the container. Either `container:<name|id>` or `host`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerPortArgs', 'ContainerPortArgsDict']]]] ports: Publish a container's port(s) to the host.
        :param pulumi.Input[bool] privileged: If `true`, the container runs in privileged mode.
        :param pulumi.Input[bool] publish_all_ports: Publish all ports of the container.
        :param pulumi.Input[bool] read_only: If `true`, the container will be started as readonly. Defaults to `false`.
        :param pulumi.Input[bool] remove_volumes: If `true`, it will remove anonymous volumes associated with the container. Defaults to `true`.
        :param pulumi.Input[str] restart: The restart policy for the container. Must be one of 'no', 'on-failure', 'always', 'unless-stopped'. Defaults to `no`.
        :param pulumi.Input[bool] rm: If `true`, then the container will be automatically removed when it exits. Defaults to `false`.
        :param pulumi.Input[str] runtime: Runtime to use for the container.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_opts: List of string values to customize labels for MLS systems, such as SELinux. See https://docs.docker.com/engine/reference/run/#security-configuration.
        :param pulumi.Input[int] shm_size: Size of `/dev/shm` in MBs.
        :param pulumi.Input[bool] start: If `true`, then the Docker container will be started after creation. If `false`, then the container is only created. Defaults to `true`.
        :param pulumi.Input[bool] stdin_open: If `true`, keep STDIN open even if not attached (`docker run -i`). Defaults to `false`.
        :param pulumi.Input[str] stop_signal: Signal to stop a container (default `SIGTERM`).
        :param pulumi.Input[int] stop_timeout: Timeout (in seconds) to stop a container.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] storage_opts: Key/value pairs for the storage driver options, e.g. `size`: `120G`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] sysctls: A map of kernel parameters (sysctls) to set in the container.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tmpfs: A map of container directories which should be replaced by `tmpfs mounts`, and their corresponding mount options.
        :param pulumi.Input[bool] tty: If `true`, allocate a pseudo-tty (`docker run -t`). Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerUlimitArgs', 'ContainerUlimitArgsDict']]]] ulimits: Ulimit options to add.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerUploadArgs', 'ContainerUploadArgsDict']]]] uploads: Specifies files to upload to the container before starting it. Only one of `content` or `content_base64` can be set and at least one of them has to be set.
        :param pulumi.Input[str] user: User used for run the first process. Format is `user` or `user:group` which user and group can be passed literraly or by name.
        :param pulumi.Input[str] userns_mode: Sets the usernamespace mode for the container when usernamespace remapping option is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerVolumeArgs', 'ContainerVolumeArgsDict']]]] volumes: Spec for mounting volumes in the container.
        :param pulumi.Input[bool] wait: If `true`, then the Docker container is waited for being healthy state after creation. If `false`, then the container health state is not checked. Defaults to `false`.
        :param pulumi.Input[int] wait_timeout: The timeout in seconds to wait the container to be healthy after creation. Defaults to `60`.
        :param pulumi.Input[str] working_dir: The working directory for commands to run in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContainerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        <!-- Bug: Type and Name are switched -->
        Manages the lifecycle of a Docker container.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_docker as docker

        # Find the latest Ubuntu precise image.
        ubuntu_remote_image = docker.RemoteImage("ubuntu", name="ubuntu:precise")
        # Start a container
        ubuntu = docker.Container("ubuntu",
            name="foo",
            image=ubuntu_remote_image.image_id)
        ```

        ## Import

        ### Example

        Assuming you created a `container` as follows

        #!/bin/bash

        docker run --name foo -p8080:80 -d nginx

        prints the container ID

        9a550c0f0163d39d77222d3efd58701b625d47676c25c686c95b5b92d1cba6fd

        you provide the definition for the resource as follows

        terraform

        resource "docker_container" "foo" {

          name  = "foo"

          image = "nginx"

          ports {

            internal = "80"
            
            external = "8080"

          }

        }

        then the import command is as follows

        #!/bin/bash

        ```sh
        $ pulumi import docker:index/container:Container foo 9a550c0f0163d39d77222d3efd58701b625d47676c25c686c95b5b92d1cba6fd
        ```

        :param str resource_name: The name of the resource.
        :param ContainerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContainerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attach: Optional[pulumi.Input[bool]] = None,
                 capabilities: Optional[pulumi.Input[Union['ContainerCapabilitiesArgs', 'ContainerCapabilitiesArgsDict']]] = None,
                 cgroupns_mode: Optional[pulumi.Input[str]] = None,
                 command: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 container_read_refresh_timeout_milliseconds: Optional[pulumi.Input[int]] = None,
                 cpu_set: Optional[pulumi.Input[str]] = None,
                 cpu_shares: Optional[pulumi.Input[int]] = None,
                 destroy_grace_seconds: Optional[pulumi.Input[int]] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerDeviceArgs', 'ContainerDeviceArgsDict']]]]] = None,
                 dns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dns_opts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dns_searches: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 domainname: Optional[pulumi.Input[str]] = None,
                 entrypoints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 gpus: Optional[pulumi.Input[str]] = None,
                 group_adds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 healthcheck: Optional[pulumi.Input[Union['ContainerHealthcheckArgs', 'ContainerHealthcheckArgsDict']]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerHostArgs', 'ContainerHostArgsDict']]]]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 init: Optional[pulumi.Input[bool]] = None,
                 ipc_mode: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerLabelArgs', 'ContainerLabelArgsDict']]]]] = None,
                 log_driver: Optional[pulumi.Input[str]] = None,
                 log_opts: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 logs: Optional[pulumi.Input[bool]] = None,
                 max_retry_count: Optional[pulumi.Input[int]] = None,
                 memory: Optional[pulumi.Input[int]] = None,
                 memory_swap: Optional[pulumi.Input[int]] = None,
                 mounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerMountArgs', 'ContainerMountArgsDict']]]]] = None,
                 must_run: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_mode: Optional[pulumi.Input[str]] = None,
                 networks_advanced: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerNetworksAdvancedArgs', 'ContainerNetworksAdvancedArgsDict']]]]] = None,
                 pid_mode: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerPortArgs', 'ContainerPortArgsDict']]]]] = None,
                 privileged: Optional[pulumi.Input[bool]] = None,
                 publish_all_ports: Optional[pulumi.Input[bool]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 remove_volumes: Optional[pulumi.Input[bool]] = None,
                 restart: Optional[pulumi.Input[str]] = None,
                 rm: Optional[pulumi.Input[bool]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 security_opts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 shm_size: Optional[pulumi.Input[int]] = None,
                 start: Optional[pulumi.Input[bool]] = None,
                 stdin_open: Optional[pulumi.Input[bool]] = None,
                 stop_signal: Optional[pulumi.Input[str]] = None,
                 stop_timeout: Optional[pulumi.Input[int]] = None,
                 storage_opts: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 sysctls: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tmpfs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tty: Optional[pulumi.Input[bool]] = None,
                 ulimits: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerUlimitArgs', 'ContainerUlimitArgsDict']]]]] = None,
                 uploads: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerUploadArgs', 'ContainerUploadArgsDict']]]]] = None,
                 user: Optional[pulumi.Input[str]] = None,
                 userns_mode: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerVolumeArgs', 'ContainerVolumeArgsDict']]]]] = None,
                 wait: Optional[pulumi.Input[bool]] = None,
                 wait_timeout: Optional[pulumi.Input[int]] = None,
                 working_dir: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContainerArgs.__new__(ContainerArgs)

            __props__.__dict__["attach"] = attach
            __props__.__dict__["capabilities"] = capabilities
            __props__.__dict__["cgroupns_mode"] = cgroupns_mode
            __props__.__dict__["command"] = command
            __props__.__dict__["container_read_refresh_timeout_milliseconds"] = container_read_refresh_timeout_milliseconds
            __props__.__dict__["cpu_set"] = cpu_set
            __props__.__dict__["cpu_shares"] = cpu_shares
            __props__.__dict__["destroy_grace_seconds"] = destroy_grace_seconds
            __props__.__dict__["devices"] = devices
            __props__.__dict__["dns"] = dns
            __props__.__dict__["dns_opts"] = dns_opts
            __props__.__dict__["dns_searches"] = dns_searches
            __props__.__dict__["domainname"] = domainname
            __props__.__dict__["entrypoints"] = entrypoints
            __props__.__dict__["envs"] = envs
            __props__.__dict__["gpus"] = gpus
            __props__.__dict__["group_adds"] = group_adds
            __props__.__dict__["healthcheck"] = healthcheck
            __props__.__dict__["hostname"] = hostname
            __props__.__dict__["hosts"] = hosts
            if image is None and not opts.urn:
                raise TypeError("Missing required property 'image'")
            __props__.__dict__["image"] = image
            __props__.__dict__["init"] = init
            __props__.__dict__["ipc_mode"] = ipc_mode
            __props__.__dict__["labels"] = labels
            __props__.__dict__["log_driver"] = log_driver
            __props__.__dict__["log_opts"] = log_opts
            __props__.__dict__["logs"] = logs
            __props__.__dict__["max_retry_count"] = max_retry_count
            __props__.__dict__["memory"] = memory
            __props__.__dict__["memory_swap"] = memory_swap
            __props__.__dict__["mounts"] = mounts
            __props__.__dict__["must_run"] = must_run
            __props__.__dict__["name"] = name
            __props__.__dict__["network_mode"] = network_mode
            __props__.__dict__["networks_advanced"] = networks_advanced
            __props__.__dict__["pid_mode"] = pid_mode
            __props__.__dict__["ports"] = ports
            __props__.__dict__["privileged"] = privileged
            __props__.__dict__["publish_all_ports"] = publish_all_ports
            __props__.__dict__["read_only"] = read_only
            __props__.__dict__["remove_volumes"] = remove_volumes
            __props__.__dict__["restart"] = restart
            __props__.__dict__["rm"] = rm
            __props__.__dict__["runtime"] = runtime
            __props__.__dict__["security_opts"] = security_opts
            __props__.__dict__["shm_size"] = shm_size
            __props__.__dict__["start"] = start
            __props__.__dict__["stdin_open"] = stdin_open
            __props__.__dict__["stop_signal"] = stop_signal
            __props__.__dict__["stop_timeout"] = stop_timeout
            __props__.__dict__["storage_opts"] = storage_opts
            __props__.__dict__["sysctls"] = sysctls
            __props__.__dict__["tmpfs"] = tmpfs
            __props__.__dict__["tty"] = tty
            __props__.__dict__["ulimits"] = ulimits
            __props__.__dict__["uploads"] = uploads
            __props__.__dict__["user"] = user
            __props__.__dict__["userns_mode"] = userns_mode
            __props__.__dict__["volumes"] = volumes
            __props__.__dict__["wait"] = wait
            __props__.__dict__["wait_timeout"] = wait_timeout
            __props__.__dict__["working_dir"] = working_dir
            __props__.__dict__["bridge"] = None
            __props__.__dict__["container_logs"] = None
            __props__.__dict__["exit_code"] = None
            __props__.__dict__["network_datas"] = None
        super(Container, __self__).__init__(
            'docker:index/container:Container',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attach: Optional[pulumi.Input[bool]] = None,
            bridge: Optional[pulumi.Input[str]] = None,
            capabilities: Optional[pulumi.Input[Union['ContainerCapabilitiesArgs', 'ContainerCapabilitiesArgsDict']]] = None,
            cgroupns_mode: Optional[pulumi.Input[str]] = None,
            command: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            container_logs: Optional[pulumi.Input[str]] = None,
            container_read_refresh_timeout_milliseconds: Optional[pulumi.Input[int]] = None,
            cpu_set: Optional[pulumi.Input[str]] = None,
            cpu_shares: Optional[pulumi.Input[int]] = None,
            destroy_grace_seconds: Optional[pulumi.Input[int]] = None,
            devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerDeviceArgs', 'ContainerDeviceArgsDict']]]]] = None,
            dns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            dns_opts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            dns_searches: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            domainname: Optional[pulumi.Input[str]] = None,
            entrypoints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            envs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            exit_code: Optional[pulumi.Input[int]] = None,
            gpus: Optional[pulumi.Input[str]] = None,
            group_adds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            healthcheck: Optional[pulumi.Input[Union['ContainerHealthcheckArgs', 'ContainerHealthcheckArgsDict']]] = None,
            hostname: Optional[pulumi.Input[str]] = None,
            hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerHostArgs', 'ContainerHostArgsDict']]]]] = None,
            image: Optional[pulumi.Input[str]] = None,
            init: Optional[pulumi.Input[bool]] = None,
            ipc_mode: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerLabelArgs', 'ContainerLabelArgsDict']]]]] = None,
            log_driver: Optional[pulumi.Input[str]] = None,
            log_opts: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            logs: Optional[pulumi.Input[bool]] = None,
            max_retry_count: Optional[pulumi.Input[int]] = None,
            memory: Optional[pulumi.Input[int]] = None,
            memory_swap: Optional[pulumi.Input[int]] = None,
            mounts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerMountArgs', 'ContainerMountArgsDict']]]]] = None,
            must_run: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_datas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerNetworkDataArgs', 'ContainerNetworkDataArgsDict']]]]] = None,
            network_mode: Optional[pulumi.Input[str]] = None,
            networks_advanced: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerNetworksAdvancedArgs', 'ContainerNetworksAdvancedArgsDict']]]]] = None,
            pid_mode: Optional[pulumi.Input[str]] = None,
            ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerPortArgs', 'ContainerPortArgsDict']]]]] = None,
            privileged: Optional[pulumi.Input[bool]] = None,
            publish_all_ports: Optional[pulumi.Input[bool]] = None,
            read_only: Optional[pulumi.Input[bool]] = None,
            remove_volumes: Optional[pulumi.Input[bool]] = None,
            restart: Optional[pulumi.Input[str]] = None,
            rm: Optional[pulumi.Input[bool]] = None,
            runtime: Optional[pulumi.Input[str]] = None,
            security_opts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            shm_size: Optional[pulumi.Input[int]] = None,
            start: Optional[pulumi.Input[bool]] = None,
            stdin_open: Optional[pulumi.Input[bool]] = None,
            stop_signal: Optional[pulumi.Input[str]] = None,
            stop_timeout: Optional[pulumi.Input[int]] = None,
            storage_opts: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            sysctls: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tmpfs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tty: Optional[pulumi.Input[bool]] = None,
            ulimits: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerUlimitArgs', 'ContainerUlimitArgsDict']]]]] = None,
            uploads: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerUploadArgs', 'ContainerUploadArgsDict']]]]] = None,
            user: Optional[pulumi.Input[str]] = None,
            userns_mode: Optional[pulumi.Input[str]] = None,
            volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ContainerVolumeArgs', 'ContainerVolumeArgsDict']]]]] = None,
            wait: Optional[pulumi.Input[bool]] = None,
            wait_timeout: Optional[pulumi.Input[int]] = None,
            working_dir: Optional[pulumi.Input[str]] = None) -> 'Container':
        """
        Get an existing Container resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] attach: If `true` attach to the container after its creation and waits the end of its execution. Defaults to `false`.
        :param pulumi.Input[str] bridge: The network bridge of the container as read from its NetworkSettings.
        :param pulumi.Input[Union['ContainerCapabilitiesArgs', 'ContainerCapabilitiesArgsDict']] capabilities: Add or drop certrain linux capabilities.
        :param pulumi.Input[str] cgroupns_mode: Cgroup namespace mode to use for the container. Possible values are: `private`, `host`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] command: The command to use to start the container. For example, to run `/usr/bin/myprogram -f baz.conf` set the command to be `["/usr/bin/myprogram","-f","baz.con"]`.
        :param pulumi.Input[str] container_logs: The logs of the container if its execution is done (`attach` must be disabled).
        :param pulumi.Input[int] container_read_refresh_timeout_milliseconds: The total number of milliseconds to wait for the container to reach status 'running'
        :param pulumi.Input[str] cpu_set: A comma-separated list or hyphen-separated range of CPUs a container can use, e.g. `0-1`.
        :param pulumi.Input[int] cpu_shares: CPU shares (relative weight) for the container.
        :param pulumi.Input[int] destroy_grace_seconds: If defined will attempt to stop the container before destroying. Container will be destroyed after `n` seconds or on successful stop.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerDeviceArgs', 'ContainerDeviceArgsDict']]]] devices: Bind devices to the container.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns: DNS servers to use.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_opts: DNS options used by the DNS provider(s), see `resolv.conf` documentation for valid list of options.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_searches: DNS search domains that are used when bare unqualified hostnames are used inside of the container.
        :param pulumi.Input[str] domainname: Domain name of the container.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] entrypoints: The command to use as the Entrypoint for the container. The Entrypoint allows you to configure a container to run as an executable. For example, to run `/usr/bin/myprogram` when starting a container, set the entrypoint to be `"/usr/bin/myprogra"]`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] envs: Environment variables to set in the form of `KEY=VALUE`, e.g. `DEBUG=0`
        :param pulumi.Input[int] exit_code: The exit code of the container if its execution is done (`must_run` must be disabled).
        :param pulumi.Input[str] gpus: GPU devices to add to the container. Currently, only the value `all` is supported. Passing any other value will result in unexpected behavior.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_adds: Additional groups for the container user
        :param pulumi.Input[Union['ContainerHealthcheckArgs', 'ContainerHealthcheckArgsDict']] healthcheck: A test to perform to check that the container is healthy
        :param pulumi.Input[str] hostname: Hostname of the container.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerHostArgs', 'ContainerHostArgsDict']]]] hosts: Additional hosts to add to the container.
        :param pulumi.Input[str] image: The ID of the image to back this container. The easiest way to get this value is to use the `RemoteImage` resource as is shown in the example.
        :param pulumi.Input[bool] init: Configured whether an init process should be injected for this container. If unset this will default to the `dockerd` defaults.
        :param pulumi.Input[str] ipc_mode: IPC sharing mode for the container. Possible values are: `none`, `private`, `shareable`, `container:<name|id>` or `host`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerLabelArgs', 'ContainerLabelArgsDict']]]] labels: User-defined key/value metadata
        :param pulumi.Input[str] log_driver: The logging driver to use for the container.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] log_opts: Key/value pairs to use as options for the logging driver.
        :param pulumi.Input[bool] logs: Save the container logs (`attach` must be enabled). Defaults to `false`.
        :param pulumi.Input[int] max_retry_count: The maximum amount of times to an attempt a restart when `restart` is set to 'on-failure'.
        :param pulumi.Input[int] memory: The memory limit for the container in MBs.
        :param pulumi.Input[int] memory_swap: The total memory limit (memory + swap) for the container in MBs. This setting may compute to `-1` after `pulumi up` if the target host doesn't support memory swap, when that is the case docker will use a soft limitation.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerMountArgs', 'ContainerMountArgsDict']]]] mounts: Specification for mounts to be added to containers created as part of the service.
        :param pulumi.Input[str] name: The name of the container.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerNetworkDataArgs', 'ContainerNetworkDataArgsDict']]]] network_datas: The data of the networks the container is connected to.
        :param pulumi.Input[str] network_mode: Network mode of the container.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerNetworksAdvancedArgs', 'ContainerNetworksAdvancedArgsDict']]]] networks_advanced: The networks the container is attached to
        :param pulumi.Input[str] pid_mode: he PID (Process) Namespace mode for the container. Either `container:<name|id>` or `host`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerPortArgs', 'ContainerPortArgsDict']]]] ports: Publish a container's port(s) to the host.
        :param pulumi.Input[bool] privileged: If `true`, the container runs in privileged mode.
        :param pulumi.Input[bool] publish_all_ports: Publish all ports of the container.
        :param pulumi.Input[bool] read_only: If `true`, the container will be started as readonly. Defaults to `false`.
        :param pulumi.Input[bool] remove_volumes: If `true`, it will remove anonymous volumes associated with the container. Defaults to `true`.
        :param pulumi.Input[str] restart: The restart policy for the container. Must be one of 'no', 'on-failure', 'always', 'unless-stopped'. Defaults to `no`.
        :param pulumi.Input[bool] rm: If `true`, then the container will be automatically removed when it exits. Defaults to `false`.
        :param pulumi.Input[str] runtime: Runtime to use for the container.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_opts: List of string values to customize labels for MLS systems, such as SELinux. See https://docs.docker.com/engine/reference/run/#security-configuration.
        :param pulumi.Input[int] shm_size: Size of `/dev/shm` in MBs.
        :param pulumi.Input[bool] start: If `true`, then the Docker container will be started after creation. If `false`, then the container is only created. Defaults to `true`.
        :param pulumi.Input[bool] stdin_open: If `true`, keep STDIN open even if not attached (`docker run -i`). Defaults to `false`.
        :param pulumi.Input[str] stop_signal: Signal to stop a container (default `SIGTERM`).
        :param pulumi.Input[int] stop_timeout: Timeout (in seconds) to stop a container.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] storage_opts: Key/value pairs for the storage driver options, e.g. `size`: `120G`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] sysctls: A map of kernel parameters (sysctls) to set in the container.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tmpfs: A map of container directories which should be replaced by `tmpfs mounts`, and their corresponding mount options.
        :param pulumi.Input[bool] tty: If `true`, allocate a pseudo-tty (`docker run -t`). Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerUlimitArgs', 'ContainerUlimitArgsDict']]]] ulimits: Ulimit options to add.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerUploadArgs', 'ContainerUploadArgsDict']]]] uploads: Specifies files to upload to the container before starting it. Only one of `content` or `content_base64` can be set and at least one of them has to be set.
        :param pulumi.Input[str] user: User used for run the first process. Format is `user` or `user:group` which user and group can be passed literraly or by name.
        :param pulumi.Input[str] userns_mode: Sets the usernamespace mode for the container when usernamespace remapping option is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ContainerVolumeArgs', 'ContainerVolumeArgsDict']]]] volumes: Spec for mounting volumes in the container.
        :param pulumi.Input[bool] wait: If `true`, then the Docker container is waited for being healthy state after creation. If `false`, then the container health state is not checked. Defaults to `false`.
        :param pulumi.Input[int] wait_timeout: The timeout in seconds to wait the container to be healthy after creation. Defaults to `60`.
        :param pulumi.Input[str] working_dir: The working directory for commands to run in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContainerState.__new__(_ContainerState)

        __props__.__dict__["attach"] = attach
        __props__.__dict__["bridge"] = bridge
        __props__.__dict__["capabilities"] = capabilities
        __props__.__dict__["cgroupns_mode"] = cgroupns_mode
        __props__.__dict__["command"] = command
        __props__.__dict__["container_logs"] = container_logs
        __props__.__dict__["container_read_refresh_timeout_milliseconds"] = container_read_refresh_timeout_milliseconds
        __props__.__dict__["cpu_set"] = cpu_set
        __props__.__dict__["cpu_shares"] = cpu_shares
        __props__.__dict__["destroy_grace_seconds"] = destroy_grace_seconds
        __props__.__dict__["devices"] = devices
        __props__.__dict__["dns"] = dns
        __props__.__dict__["dns_opts"] = dns_opts
        __props__.__dict__["dns_searches"] = dns_searches
        __props__.__dict__["domainname"] = domainname
        __props__.__dict__["entrypoints"] = entrypoints
        __props__.__dict__["envs"] = envs
        __props__.__dict__["exit_code"] = exit_code
        __props__.__dict__["gpus"] = gpus
        __props__.__dict__["group_adds"] = group_adds
        __props__.__dict__["healthcheck"] = healthcheck
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["hosts"] = hosts
        __props__.__dict__["image"] = image
        __props__.__dict__["init"] = init
        __props__.__dict__["ipc_mode"] = ipc_mode
        __props__.__dict__["labels"] = labels
        __props__.__dict__["log_driver"] = log_driver
        __props__.__dict__["log_opts"] = log_opts
        __props__.__dict__["logs"] = logs
        __props__.__dict__["max_retry_count"] = max_retry_count
        __props__.__dict__["memory"] = memory
        __props__.__dict__["memory_swap"] = memory_swap
        __props__.__dict__["mounts"] = mounts
        __props__.__dict__["must_run"] = must_run
        __props__.__dict__["name"] = name
        __props__.__dict__["network_datas"] = network_datas
        __props__.__dict__["network_mode"] = network_mode
        __props__.__dict__["networks_advanced"] = networks_advanced
        __props__.__dict__["pid_mode"] = pid_mode
        __props__.__dict__["ports"] = ports
        __props__.__dict__["privileged"] = privileged
        __props__.__dict__["publish_all_ports"] = publish_all_ports
        __props__.__dict__["read_only"] = read_only
        __props__.__dict__["remove_volumes"] = remove_volumes
        __props__.__dict__["restart"] = restart
        __props__.__dict__["rm"] = rm
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["security_opts"] = security_opts
        __props__.__dict__["shm_size"] = shm_size
        __props__.__dict__["start"] = start
        __props__.__dict__["stdin_open"] = stdin_open
        __props__.__dict__["stop_signal"] = stop_signal
        __props__.__dict__["stop_timeout"] = stop_timeout
        __props__.__dict__["storage_opts"] = storage_opts
        __props__.__dict__["sysctls"] = sysctls
        __props__.__dict__["tmpfs"] = tmpfs
        __props__.__dict__["tty"] = tty
        __props__.__dict__["ulimits"] = ulimits
        __props__.__dict__["uploads"] = uploads
        __props__.__dict__["user"] = user
        __props__.__dict__["userns_mode"] = userns_mode
        __props__.__dict__["volumes"] = volumes
        __props__.__dict__["wait"] = wait
        __props__.__dict__["wait_timeout"] = wait_timeout
        __props__.__dict__["working_dir"] = working_dir
        return Container(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def attach(self) -> pulumi.Output[Optional[bool]]:
        """
        If `true` attach to the container after its creation and waits the end of its execution. Defaults to `false`.
        """
        return pulumi.get(self, "attach")

    @property
    @pulumi.getter
    def bridge(self) -> pulumi.Output[str]:
        """
        The network bridge of the container as read from its NetworkSettings.
        """
        return pulumi.get(self, "bridge")

    @property
    @pulumi.getter
    def capabilities(self) -> pulumi.Output[Optional['outputs.ContainerCapabilities']]:
        """
        Add or drop certrain linux capabilities.
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter(name="cgroupnsMode")
    def cgroupns_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Cgroup namespace mode to use for the container. Possible values are: `private`, `host`.
        """
        return pulumi.get(self, "cgroupns_mode")

    @property
    @pulumi.getter
    def command(self) -> pulumi.Output[Sequence[str]]:
        """
        The command to use to start the container. For example, to run `/usr/bin/myprogram -f baz.conf` set the command to be `["/usr/bin/myprogram","-f","baz.con"]`.
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter(name="containerLogs")
    def container_logs(self) -> pulumi.Output[str]:
        """
        The logs of the container if its execution is done (`attach` must be disabled).
        """
        return pulumi.get(self, "container_logs")

    @property
    @pulumi.getter(name="containerReadRefreshTimeoutMilliseconds")
    def container_read_refresh_timeout_milliseconds(self) -> pulumi.Output[Optional[int]]:
        """
        The total number of milliseconds to wait for the container to reach status 'running'
        """
        return pulumi.get(self, "container_read_refresh_timeout_milliseconds")

    @property
    @pulumi.getter(name="cpuSet")
    def cpu_set(self) -> pulumi.Output[Optional[str]]:
        """
        A comma-separated list or hyphen-separated range of CPUs a container can use, e.g. `0-1`.
        """
        return pulumi.get(self, "cpu_set")

    @property
    @pulumi.getter(name="cpuShares")
    def cpu_shares(self) -> pulumi.Output[Optional[int]]:
        """
        CPU shares (relative weight) for the container.
        """
        return pulumi.get(self, "cpu_shares")

    @property
    @pulumi.getter(name="destroyGraceSeconds")
    def destroy_grace_seconds(self) -> pulumi.Output[Optional[int]]:
        """
        If defined will attempt to stop the container before destroying. Container will be destroyed after `n` seconds or on successful stop.
        """
        return pulumi.get(self, "destroy_grace_seconds")

    @property
    @pulumi.getter
    def devices(self) -> pulumi.Output[Optional[Sequence['outputs.ContainerDevice']]]:
        """
        Bind devices to the container.
        """
        return pulumi.get(self, "devices")

    @property
    @pulumi.getter
    def dns(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        DNS servers to use.
        """
        return pulumi.get(self, "dns")

    @property
    @pulumi.getter(name="dnsOpts")
    def dns_opts(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        DNS options used by the DNS provider(s), see `resolv.conf` documentation for valid list of options.
        """
        return pulumi.get(self, "dns_opts")

    @property
    @pulumi.getter(name="dnsSearches")
    def dns_searches(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        DNS search domains that are used when bare unqualified hostnames are used inside of the container.
        """
        return pulumi.get(self, "dns_searches")

    @property
    @pulumi.getter
    def domainname(self) -> pulumi.Output[Optional[str]]:
        """
        Domain name of the container.
        """
        return pulumi.get(self, "domainname")

    @property
    @pulumi.getter
    def entrypoints(self) -> pulumi.Output[Sequence[str]]:
        """
        The command to use as the Entrypoint for the container. The Entrypoint allows you to configure a container to run as an executable. For example, to run `/usr/bin/myprogram` when starting a container, set the entrypoint to be `"/usr/bin/myprogra"]`.
        """
        return pulumi.get(self, "entrypoints")

    @property
    @pulumi.getter
    def envs(self) -> pulumi.Output[Sequence[str]]:
        """
        Environment variables to set in the form of `KEY=VALUE`, e.g. `DEBUG=0`
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter(name="exitCode")
    def exit_code(self) -> pulumi.Output[int]:
        """
        The exit code of the container if its execution is done (`must_run` must be disabled).
        """
        return pulumi.get(self, "exit_code")

    @property
    @pulumi.getter
    def gpus(self) -> pulumi.Output[Optional[str]]:
        """
        GPU devices to add to the container. Currently, only the value `all` is supported. Passing any other value will result in unexpected behavior.
        """
        return pulumi.get(self, "gpus")

    @property
    @pulumi.getter(name="groupAdds")
    def group_adds(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Additional groups for the container user
        """
        return pulumi.get(self, "group_adds")

    @property
    @pulumi.getter
    def healthcheck(self) -> pulumi.Output['outputs.ContainerHealthcheck']:
        """
        A test to perform to check that the container is healthy
        """
        return pulumi.get(self, "healthcheck")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[str]:
        """
        Hostname of the container.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def hosts(self) -> pulumi.Output[Optional[Sequence['outputs.ContainerHost']]]:
        """
        Additional hosts to add to the container.
        """
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter
    def image(self) -> pulumi.Output[str]:
        """
        The ID of the image to back this container. The easiest way to get this value is to use the `RemoteImage` resource as is shown in the example.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def init(self) -> pulumi.Output[bool]:
        """
        Configured whether an init process should be injected for this container. If unset this will default to the `dockerd` defaults.
        """
        return pulumi.get(self, "init")

    @property
    @pulumi.getter(name="ipcMode")
    def ipc_mode(self) -> pulumi.Output[str]:
        """
        IPC sharing mode for the container. Possible values are: `none`, `private`, `shareable`, `container:<name|id>` or `host`.
        """
        return pulumi.get(self, "ipc_mode")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Sequence['outputs.ContainerLabel']]:
        """
        User-defined key/value metadata
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="logDriver")
    def log_driver(self) -> pulumi.Output[str]:
        """
        The logging driver to use for the container.
        """
        return pulumi.get(self, "log_driver")

    @property
    @pulumi.getter(name="logOpts")
    def log_opts(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key/value pairs to use as options for the logging driver.
        """
        return pulumi.get(self, "log_opts")

    @property
    @pulumi.getter
    def logs(self) -> pulumi.Output[Optional[bool]]:
        """
        Save the container logs (`attach` must be enabled). Defaults to `false`.
        """
        return pulumi.get(self, "logs")

    @property
    @pulumi.getter(name="maxRetryCount")
    def max_retry_count(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum amount of times to an attempt a restart when `restart` is set to 'on-failure'.
        """
        return pulumi.get(self, "max_retry_count")

    @property
    @pulumi.getter
    def memory(self) -> pulumi.Output[Optional[int]]:
        """
        The memory limit for the container in MBs.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter(name="memorySwap")
    def memory_swap(self) -> pulumi.Output[Optional[int]]:
        """
        The total memory limit (memory + swap) for the container in MBs. This setting may compute to `-1` after `pulumi up` if the target host doesn't support memory swap, when that is the case docker will use a soft limitation.
        """
        return pulumi.get(self, "memory_swap")

    @property
    @pulumi.getter
    def mounts(self) -> pulumi.Output[Optional[Sequence['outputs.ContainerMount']]]:
        """
        Specification for mounts to be added to containers created as part of the service.
        """
        return pulumi.get(self, "mounts")

    @property
    @pulumi.getter(name="mustRun")
    def must_run(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "must_run")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the container.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkDatas")
    def network_datas(self) -> pulumi.Output[Sequence['outputs.ContainerNetworkData']]:
        """
        The data of the networks the container is connected to.
        """
        return pulumi.get(self, "network_datas")

    @property
    @pulumi.getter(name="networkMode")
    def network_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Network mode of the container.
        """
        return pulumi.get(self, "network_mode")

    @property
    @pulumi.getter(name="networksAdvanced")
    def networks_advanced(self) -> pulumi.Output[Optional[Sequence['outputs.ContainerNetworksAdvanced']]]:
        """
        The networks the container is attached to
        """
        return pulumi.get(self, "networks_advanced")

    @property
    @pulumi.getter(name="pidMode")
    def pid_mode(self) -> pulumi.Output[Optional[str]]:
        """
        he PID (Process) Namespace mode for the container. Either `container:<name|id>` or `host`.
        """
        return pulumi.get(self, "pid_mode")

    @property
    @pulumi.getter
    def ports(self) -> pulumi.Output[Optional[Sequence['outputs.ContainerPort']]]:
        """
        Publish a container's port(s) to the host.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter
    def privileged(self) -> pulumi.Output[Optional[bool]]:
        """
        If `true`, the container runs in privileged mode.
        """
        return pulumi.get(self, "privileged")

    @property
    @pulumi.getter(name="publishAllPorts")
    def publish_all_ports(self) -> pulumi.Output[Optional[bool]]:
        """
        Publish all ports of the container.
        """
        return pulumi.get(self, "publish_all_ports")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> pulumi.Output[Optional[bool]]:
        """
        If `true`, the container will be started as readonly. Defaults to `false`.
        """
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter(name="removeVolumes")
    def remove_volumes(self) -> pulumi.Output[Optional[bool]]:
        """
        If `true`, it will remove anonymous volumes associated with the container. Defaults to `true`.
        """
        return pulumi.get(self, "remove_volumes")

    @property
    @pulumi.getter
    def restart(self) -> pulumi.Output[Optional[str]]:
        """
        The restart policy for the container. Must be one of 'no', 'on-failure', 'always', 'unless-stopped'. Defaults to `no`.
        """
        return pulumi.get(self, "restart")

    @property
    @pulumi.getter
    def rm(self) -> pulumi.Output[Optional[bool]]:
        """
        If `true`, then the container will be automatically removed when it exits. Defaults to `false`.
        """
        return pulumi.get(self, "rm")

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[str]:
        """
        Runtime to use for the container.
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter(name="securityOpts")
    def security_opts(self) -> pulumi.Output[Sequence[str]]:
        """
        List of string values to customize labels for MLS systems, such as SELinux. See https://docs.docker.com/engine/reference/run/#security-configuration.
        """
        return pulumi.get(self, "security_opts")

    @property
    @pulumi.getter(name="shmSize")
    def shm_size(self) -> pulumi.Output[int]:
        """
        Size of `/dev/shm` in MBs.
        """
        return pulumi.get(self, "shm_size")

    @property
    @pulumi.getter
    def start(self) -> pulumi.Output[Optional[bool]]:
        """
        If `true`, then the Docker container will be started after creation. If `false`, then the container is only created. Defaults to `true`.
        """
        return pulumi.get(self, "start")

    @property
    @pulumi.getter(name="stdinOpen")
    def stdin_open(self) -> pulumi.Output[Optional[bool]]:
        """
        If `true`, keep STDIN open even if not attached (`docker run -i`). Defaults to `false`.
        """
        return pulumi.get(self, "stdin_open")

    @property
    @pulumi.getter(name="stopSignal")
    def stop_signal(self) -> pulumi.Output[str]:
        """
        Signal to stop a container (default `SIGTERM`).
        """
        return pulumi.get(self, "stop_signal")

    @property
    @pulumi.getter(name="stopTimeout")
    def stop_timeout(self) -> pulumi.Output[int]:
        """
        Timeout (in seconds) to stop a container.
        """
        return pulumi.get(self, "stop_timeout")

    @property
    @pulumi.getter(name="storageOpts")
    def storage_opts(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Key/value pairs for the storage driver options, e.g. `size`: `120G`
        """
        return pulumi.get(self, "storage_opts")

    @property
    @pulumi.getter
    def sysctls(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of kernel parameters (sysctls) to set in the container.
        """
        return pulumi.get(self, "sysctls")

    @property
    @pulumi.getter
    def tmpfs(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of container directories which should be replaced by `tmpfs mounts`, and their corresponding mount options.
        """
        return pulumi.get(self, "tmpfs")

    @property
    @pulumi.getter
    def tty(self) -> pulumi.Output[Optional[bool]]:
        """
        If `true`, allocate a pseudo-tty (`docker run -t`). Defaults to `false`.
        """
        return pulumi.get(self, "tty")

    @property
    @pulumi.getter
    def ulimits(self) -> pulumi.Output[Optional[Sequence['outputs.ContainerUlimit']]]:
        """
        Ulimit options to add.
        """
        return pulumi.get(self, "ulimits")

    @property
    @pulumi.getter
    def uploads(self) -> pulumi.Output[Optional[Sequence['outputs.ContainerUpload']]]:
        """
        Specifies files to upload to the container before starting it. Only one of `content` or `content_base64` can be set and at least one of them has to be set.
        """
        return pulumi.get(self, "uploads")

    @property
    @pulumi.getter
    def user(self) -> pulumi.Output[Optional[str]]:
        """
        User used for run the first process. Format is `user` or `user:group` which user and group can be passed literraly or by name.
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="usernsMode")
    def userns_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Sets the usernamespace mode for the container when usernamespace remapping option is enabled.
        """
        return pulumi.get(self, "userns_mode")

    @property
    @pulumi.getter
    def volumes(self) -> pulumi.Output[Optional[Sequence['outputs.ContainerVolume']]]:
        """
        Spec for mounting volumes in the container.
        """
        return pulumi.get(self, "volumes")

    @property
    @pulumi.getter
    def wait(self) -> pulumi.Output[Optional[bool]]:
        """
        If `true`, then the Docker container is waited for being healthy state after creation. If `false`, then the container health state is not checked. Defaults to `false`.
        """
        return pulumi.get(self, "wait")

    @property
    @pulumi.getter(name="waitTimeout")
    def wait_timeout(self) -> pulumi.Output[Optional[int]]:
        """
        The timeout in seconds to wait the container to be healthy after creation. Defaults to `60`.
        """
        return pulumi.get(self, "wait_timeout")

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> pulumi.Output[Optional[str]]:
        """
        The working directory for commands to run in.
        """
        return pulumi.get(self, "working_dir")

