# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetNetworkResult',
    'AwaitableGetNetworkResult',
    'get_network',
    'get_network_output',
]

@pulumi.output_type
class GetNetworkResult:
    """
    A collection of values returned by getNetwork.
    """
    def __init__(__self__, driver=None, id=None, internal=None, ipam_configs=None, name=None, options=None, scope=None):
        if driver and not isinstance(driver, str):
            raise TypeError("Expected argument 'driver' to be a str")
        pulumi.set(__self__, "driver", driver)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if internal and not isinstance(internal, bool):
            raise TypeError("Expected argument 'internal' to be a bool")
        pulumi.set(__self__, "internal", internal)
        if ipam_configs and not isinstance(ipam_configs, list):
            raise TypeError("Expected argument 'ipam_configs' to be a list")
        pulumi.set(__self__, "ipam_configs", ipam_configs)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if options and not isinstance(options, dict):
            raise TypeError("Expected argument 'options' to be a dict")
        pulumi.set(__self__, "options", options)
        if scope and not isinstance(scope, str):
            raise TypeError("Expected argument 'scope' to be a str")
        pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def driver(self) -> str:
        """
        The driver of the Docker network. Possible values are `bridge`, `host`, `overlay`, `macvlan`. See [network docs](https://docs.docker.com/network/#network-drivers) for more details.
        """
        return pulumi.get(self, "driver")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def internal(self) -> bool:
        """
        If `true`, the network is internal.
        """
        return pulumi.get(self, "internal")

    @property
    @pulumi.getter(name="ipamConfigs")
    def ipam_configs(self) -> Sequence['outputs.GetNetworkIpamConfigResult']:
        """
        The IPAM configuration options
        """
        return pulumi.get(self, "ipam_configs")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Docker network.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def options(self) -> Mapping[str, str]:
        """
        Only available with bridge networks. See [bridge options docs](https://docs.docker.com/engine/reference/commandline/network_create/#bridge-driver-options) for more details.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def scope(self) -> str:
        """
        Scope of the network. One of `swarm`, `global`, or `local`.
        """
        return pulumi.get(self, "scope")


class AwaitableGetNetworkResult(GetNetworkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkResult(
            driver=self.driver,
            id=self.id,
            internal=self.internal,
            ipam_configs=self.ipam_configs,
            name=self.name,
            options=self.options,
            scope=self.scope)


def get_network(name: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkResult:
    """
    `Network` provides details about a specific Docker Network.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_docker as docker

    main = docker.get_network(name="main")
    ```


    :param str name: The name of the Docker network.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('docker:index/getNetwork:getNetwork', __args__, opts=opts, typ=GetNetworkResult).value

    return AwaitableGetNetworkResult(
        driver=pulumi.get(__ret__, 'driver'),
        id=pulumi.get(__ret__, 'id'),
        internal=pulumi.get(__ret__, 'internal'),
        ipam_configs=pulumi.get(__ret__, 'ipam_configs'),
        name=pulumi.get(__ret__, 'name'),
        options=pulumi.get(__ret__, 'options'),
        scope=pulumi.get(__ret__, 'scope'))
def get_network_output(name: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNetworkResult]:
    """
    `Network` provides details about a specific Docker Network.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_docker as docker

    main = docker.get_network(name="main")
    ```


    :param str name: The name of the Docker network.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('docker:index/getNetwork:getNetwork', __args__, opts=opts, typ=GetNetworkResult)
    return __ret__.apply(lambda __response__: GetNetworkResult(
        driver=pulumi.get(__response__, 'driver'),
        id=pulumi.get(__response__, 'id'),
        internal=pulumi.get(__response__, 'internal'),
        ipam_configs=pulumi.get(__response__, 'ipam_configs'),
        name=pulumi.get(__response__, 'name'),
        options=pulumi.get(__response__, 'options'),
        scope=pulumi.get(__response__, 'scope')))
