# pulp_maven-client
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v3
- Package version: 0.1.0b31576617249
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import pulpcore.client.pulp_maven
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pulpcore.client.pulp_maven
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import pulpcore.client.pulp_maven
from pulpcore.client.pulp_maven.rest import ApiException
from pprint import pprint

configuration = pulpcore.client.pulp_maven.Configuration()
# Configure HTTP basic authorization: Basic
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# Defining host is optional and default to http://localhost:24817
configuration.host = "http://localhost:24817"
# Create an instance of the API class
api_instance = pulpcore.client.pulp_maven.ContentArtifactApi(pulpcore.client.pulp_maven.ApiClient(configuration))
data = pulpcore.client.pulp_maven.MavenMavenArtifact() # MavenMavenArtifact | 

try:
    # Create a maven artifact
    api_response = api_instance.create(data)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ContentArtifactApi->create: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:24817*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ContentArtifactApi* | [**create**](docs/ContentArtifactApi.md#create) | **POST** /pulp/api/v3/content/maven/artifact/ | Create a maven artifact
*ContentArtifactApi* | [**list**](docs/ContentArtifactApi.md#list) | **GET** /pulp/api/v3/content/maven/artifact/ | List maven artifacts
*ContentArtifactApi* | [**read**](docs/ContentArtifactApi.md#read) | **GET** {maven_artifact_href} | Inspect a maven artifact
*DistributionsMavenApi* | [**create**](docs/DistributionsMavenApi.md#create) | **POST** /pulp/api/v3/distributions/maven/maven/ | Create a maven distribution
*DistributionsMavenApi* | [**delete**](docs/DistributionsMavenApi.md#delete) | **DELETE** {maven_distribution_href} | Delete a maven distribution
*DistributionsMavenApi* | [**list**](docs/DistributionsMavenApi.md#list) | **GET** /pulp/api/v3/distributions/maven/maven/ | List maven distributions
*DistributionsMavenApi* | [**partial_update**](docs/DistributionsMavenApi.md#partial_update) | **PATCH** {maven_distribution_href} | Partially update a maven distribution
*DistributionsMavenApi* | [**read**](docs/DistributionsMavenApi.md#read) | **GET** {maven_distribution_href} | Inspect a maven distribution
*DistributionsMavenApi* | [**update**](docs/DistributionsMavenApi.md#update) | **PUT** {maven_distribution_href} | Update a maven distribution
*RemotesMavenApi* | [**create**](docs/RemotesMavenApi.md#create) | **POST** /pulp/api/v3/remotes/maven/maven/ | Create a maven remote
*RemotesMavenApi* | [**delete**](docs/RemotesMavenApi.md#delete) | **DELETE** {maven_remote_href} | Delete a maven remote
*RemotesMavenApi* | [**list**](docs/RemotesMavenApi.md#list) | **GET** /pulp/api/v3/remotes/maven/maven/ | List maven remotes
*RemotesMavenApi* | [**partial_update**](docs/RemotesMavenApi.md#partial_update) | **PATCH** {maven_remote_href} | Partially update a maven remote
*RemotesMavenApi* | [**read**](docs/RemotesMavenApi.md#read) | **GET** {maven_remote_href} | Inspect a maven remote
*RemotesMavenApi* | [**update**](docs/RemotesMavenApi.md#update) | **PUT** {maven_remote_href} | Update a maven remote
*RepositoriesMavenApi* | [**create**](docs/RepositoriesMavenApi.md#create) | **POST** /pulp/api/v3/repositories/maven/maven/ | Create a maven repository
*RepositoriesMavenApi* | [**delete**](docs/RepositoriesMavenApi.md#delete) | **DELETE** {maven_repository_href} | Delete a maven repository
*RepositoriesMavenApi* | [**list**](docs/RepositoriesMavenApi.md#list) | **GET** /pulp/api/v3/repositories/maven/maven/ | List maven repositorys
*RepositoriesMavenApi* | [**partial_update**](docs/RepositoriesMavenApi.md#partial_update) | **PATCH** {maven_repository_href} | Partially update a maven repository
*RepositoriesMavenApi* | [**read**](docs/RepositoriesMavenApi.md#read) | **GET** {maven_repository_href} | Inspect a maven repository
*RepositoriesMavenApi* | [**update**](docs/RepositoriesMavenApi.md#update) | **PUT** {maven_repository_href} | Update a maven repository
*RepositoriesMavenVersionsApi* | [**delete**](docs/RepositoriesMavenVersionsApi.md#delete) | **DELETE** {maven_repository_version_href} | Delete a repository version
*RepositoriesMavenVersionsApi* | [**list**](docs/RepositoriesMavenVersionsApi.md#list) | **GET** {maven_repository_href}versions/ | List repository versions
*RepositoriesMavenVersionsApi* | [**read**](docs/RepositoriesMavenVersionsApi.md#read) | **GET** {maven_repository_version_href} | Inspect a repository version


## Documentation For Models

 - [AsyncOperationResponse](docs/AsyncOperationResponse.md)
 - [ContentSummary](docs/ContentSummary.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse2002](docs/InlineResponse2002.md)
 - [InlineResponse2003](docs/InlineResponse2003.md)
 - [InlineResponse2004](docs/InlineResponse2004.md)
 - [MavenMavenArtifact](docs/MavenMavenArtifact.md)
 - [MavenMavenDistribution](docs/MavenMavenDistribution.md)
 - [MavenMavenRemote](docs/MavenMavenRemote.md)
 - [MavenMavenRepository](docs/MavenMavenRepository.md)
 - [RepositoryVersion](docs/RepositoryVersion.md)


## Documentation For Authorization


## Basic

- **Type**: HTTP basic authentication


## Author




