Module blaxel.core.client.models.private_cluster
================================================

Classes
-------

`PrivateCluster(created_at: blaxel.core.client.types.Unset | str = <blaxel.core.client.types.Unset object>, updated_at: blaxel.core.client.types.Unset | str = <blaxel.core.client.types.Unset object>, created_by: blaxel.core.client.types.Unset | str = <blaxel.core.client.types.Unset object>, updated_by: blaxel.core.client.types.Unset | str = <blaxel.core.client.types.Unset object>, continent: blaxel.core.client.types.Unset | str = <blaxel.core.client.types.Unset object>, country: blaxel.core.client.types.Unset | str = <blaxel.core.client.types.Unset object>, display_name: blaxel.core.client.types.Unset | str = <blaxel.core.client.types.Unset object>, healthy: blaxel.core.client.types.Unset | bool = <blaxel.core.client.types.Unset object>, last_health_check_time: blaxel.core.client.types.Unset | str = <blaxel.core.client.types.Unset object>, latitude: blaxel.core.client.types.Unset | str = <blaxel.core.client.types.Unset object>, longitude: blaxel.core.client.types.Unset | str = <blaxel.core.client.types.Unset object>, name: blaxel.core.client.types.Unset | str = <blaxel.core.client.types.Unset object>, owned_by: blaxel.core.client.types.Unset | str = <blaxel.core.client.types.Unset object>, workspace: blaxel.core.client.types.Unset | str = <blaxel.core.client.types.Unset object>)`
:   A private cluster where models can be located on.
    
    Attributes:
        created_at (Union[Unset, str]): The date and time when the resource was created
        updated_at (Union[Unset, str]): The date and time when the resource was updated
        created_by (Union[Unset, str]): The user or service account who created the resource
        updated_by (Union[Unset, str]): The user or service account who updated the resource
        continent (Union[Unset, str]): The private cluster's continent, used to determine the closest private cluster to
            serve inference requests based on the user's location
        country (Union[Unset, str]): The country where the private cluster is located, used to determine the closest
            private cluster to serve inference requests based on the user's location
        display_name (Union[Unset, str]): The private cluster's display Name
        healthy (Union[Unset, bool]): Whether the private cluster is healthy or not, used to determine if the private
            cluster is ready to run inference
        last_health_check_time (Union[Unset, str]): The private cluster's unique name
        latitude (Union[Unset, str]): The private cluster's latitude, used to determine the closest private cluster to
            serve inference requests based on the user's location
        longitude (Union[Unset, str]): The private cluster's longitude, used to determine the closest private cluster to
            serve inference requests based on the user's location
        name (Union[Unset, str]): The name of the private cluster, it must be unique
        owned_by (Union[Unset, str]): The service account (operator) that owns the cluster
        workspace (Union[Unset, str]): The workspace the private cluster belongs to
    
    Method generated by attrs for class PrivateCluster.

    ### Static methods

    `from_dict(src_dict: dict[str, typing.Any]) ‑> ~T`
    :

    ### Instance variables

    `additional_keys: list[str]`
    :

    `additional_properties: dict[str, typing.Any]`
    :

    `continent: blaxel.core.client.types.Unset | str`
    :

    `country: blaxel.core.client.types.Unset | str`
    :

    `created_at: blaxel.core.client.types.Unset | str`
    :

    `created_by: blaxel.core.client.types.Unset | str`
    :

    `display_name: blaxel.core.client.types.Unset | str`
    :

    `healthy: blaxel.core.client.types.Unset | bool`
    :

    `last_health_check_time: blaxel.core.client.types.Unset | str`
    :

    `latitude: blaxel.core.client.types.Unset | str`
    :

    `longitude: blaxel.core.client.types.Unset | str`
    :

    `name: blaxel.core.client.types.Unset | str`
    :

    `owned_by: blaxel.core.client.types.Unset | str`
    :

    `updated_at: blaxel.core.client.types.Unset | str`
    :

    `updated_by: blaxel.core.client.types.Unset | str`
    :

    `workspace: blaxel.core.client.types.Unset | str`
    :

    ### Methods

    `to_dict(self) ‑> dict[str, typing.Any]`
    :