from typing import Any, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

T = TypeVar("T", bound="ProcessLogs")


@_attrs_define
class ProcessLogs:
    """
    Attributes:
        logs (str):  Example: logs output.
        stderr (str):  Example: stderr output.
        stdout (str):  Example: stdout output.
    """

    logs: str
    stderr: str
    stdout: str
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        logs = self.logs

        stderr = self.stderr

        stdout = self.stdout

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "logs": logs,
                "stderr": stderr,
                "stdout": stdout,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: dict[str, Any]) -> T:
        if not src_dict:
            return None
        d = src_dict.copy()
        logs = d.pop("logs")

        stderr = d.pop("stderr")

        stdout = d.pop("stdout")

        process_logs = cls(
            logs=logs,
            stderr=stderr,
            stdout=stdout,
        )

        process_logs.additional_properties = d
        return process_logs

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
