import { Box, BoxProps } from "@chakra-ui/react";

export const RasaLogo = (props: BoxProps) => {
  return (
    <Box
      as="svg"
      {...props}
      xmlns="http://www.w3.org/2000/svg"
      width="41"
      height="51"
      fill="none"
      viewBox="0 0 41 51"
    >
      <path
        fill="#fff"
        fillRule="evenodd"
        d="M34.041 10.59V7.508H21.385v12.847h3.037v-3.867h6.582v3.854h3.037v-9.763.013zm-3.037 2.827h-6.582V10.59h6.582v2.826zM19.36 29.74V35.52H6.956v-3.083h9.366V30.64H6.956v-7.965H19.36v3.083H9.994v1.798h9.366v2.184zM34.041 25.75v-3.084H21.385v12.847h3.037v-3.867h6.582V35.5h3.037v-9.764.013zm-3.037 2.826h-6.582v-2.827h6.582v2.827z"
        clipRule="evenodd"
      ></path>
      <path
        fill="#fff"
        d="M36.826 4.689v33.578h-5.248v5.724l-9.487-5.318-.744-.417H4.179V4.69h32.654-.007zm3.298-3.34H.881v40.258h19.618l14.368 8.054v-8.054h5.25V1.349h.007z"
      ></path>
      <path
        fill="#fff"
        fillRule="evenodd"
        d="M15.287 15.464l3.888-1.436.185-.074V7.515H6.956v.257l-.028 12.59h3.038V17.43l2.278-.838 3.417 3.77h3.752l-4.126-4.897zM9.97 14.15v-3.55h6.351V11.8l-6.351 2.348z"
        clipRule="evenodd"
      ></path>
    </Box>
  );
};

export const RasaLogoDark = (props: BoxProps) => {
  return (
    <Box
      as="svg"
      {...props}
      xmlns="http://www.w3.org/2000/svg"
      width="41"
      height="51"
      fill="none"
      viewBox="0 0 41 51"
    >
      <path
        fill="#7622D2"
        fillRule="evenodd"
        d="M34.041 10.59V7.508H21.385v12.847h3.037v-3.867h6.582v3.854h3.037v-9.763.013zm-3.037 2.827h-6.582V10.59h6.582v2.826zM19.36 29.74V35.52H6.956v-3.083h9.366V30.64H6.956v-7.965H19.36v3.083H9.994v1.798h9.366v2.184zM34.041 25.75v-3.084H21.385v12.847h3.037v-3.867h6.582V35.5h3.037v-9.764.013zm-3.037 2.826h-6.582v-2.827h6.582v2.827z"
        clipRule="evenodd"
      ></path>
      <path
        fill="#7622D2"
        d="M36.826 4.689v33.578h-5.248v5.724l-9.487-5.318-.744-.417H4.179V4.69h32.654-.007zm3.298-3.34H.881v40.258h19.618l14.368 8.054v-8.054h5.25V1.349h.007z"
      ></path>
      <path
        fill="#7622D2"
        fillRule="evenodd"
        d="M15.287 15.464l3.888-1.436.185-.074V7.515H6.956v.257l-.028 12.59h3.038V17.43l2.278-.838 3.417 3.77h3.752l-4.126-4.897zM9.97 14.15v-3.55h6.351V11.8l-6.351 2.348z"
        clipRule="evenodd"
      ></path>
    </Box>
  );
};