/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.controlers;

import fr.orsay.lri.varna.applications.VARNAOnlineDemo;
import fr.orsay.lri.varna.exceptions.ExceptionNonEqualLength;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;

public class ControleurDemoTextField
implements CaretListener {
    private VARNAOnlineDemo _vod;
    private String _oldSeq;
    private String _oldStruct;
    private Highlighter _hilit;
    private Highlighter.HighlightPainter _painter;
    private final Color COLORERROR = Color.RED;
    private final Color COLORWARNING = Color.ORANGE;

    public ControleurDemoTextField(VARNAOnlineDemo vARNAOnlineDemo) {
        this._vod = vARNAOnlineDemo;
        this._oldSeq = this._vod.get_seq().getText();
        this._oldStruct = this._vod.get_struct().getText();
        this._hilit = new DefaultHighlighter();
        this._painter = new DefaultHighlighter.DefaultHighlightPainter(Color.BLACK);
        this._vod.get_struct().setHighlighter(this._hilit);
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        if (this._oldStruct != this._vod.get_struct().getText() || this._oldSeq != this._vod.get_seq().getText()) {
            int n;
            ArrayList<String> arrayList = new ArrayList<String>();
            this._vod.get_info().removeAll();
            this._hilit.removeAllHighlights();
            this._oldStruct = this._vod.get_struct().getText();
            this._oldSeq = this._vod.get_seq().getText();
            int n2 = 0;
            int n3 = 0;
            Stack<Integer> stack = new Stack<Integer>();
            boolean bl = false;
            for (n = 0; n < this._vod.get_struct().getText().length(); ++n) {
                if (this._vod.get_struct().getText().charAt(n) == '(') {
                    ++n2;
                    stack.push(n);
                    continue;
                }
                if (this._vod.get_struct().getText().charAt(n) != ')') continue;
                ++n3;
                if (stack.size() == 0) {
                    try {
                        this._hilit.addHighlight(n, n + 1, this._painter);
                    }
                    catch (BadLocationException badLocationException) {
                        this._vod.get_varnaPanel().errorDialog(badLocationException);
                    }
                    bl = true;
                    continue;
                }
                stack.pop();
            }
            if (bl || stack.size() > 0) {
                if (bl) {
                    arrayList.add("too many closing parentheses");
                }
                if (stack.size() > 0) {
                    while (!stack.isEmpty()) {
                        n = (Integer)stack.pop();
                        try {
                            this._hilit.addHighlight(n, n + 1, this._painter);
                        }
                        catch (BadLocationException badLocationException) {
                            this._vod.get_varnaPanel().errorDialog(badLocationException);
                        }
                    }
                    arrayList.add("too many opening parentheses");
                }
                this._vod.get_info().setForeground(this.COLORERROR);
                this._vod.get_seq().setForeground(this.COLORERROR);
                this._vod.get_struct().setForeground(this.COLORERROR);
            } else {
                try {
                    this._vod.get_varnaPanel().drawRNA(this._vod.get_seq().getText(), this._vod.get_struct().getText(), this._vod.get_varnaPanel().getRNA().get_drawMode());
                }
                catch (ExceptionNonEqualLength exceptionNonEqualLength) {
                    this._vod.get_varnaPanel().errorDialog(exceptionNonEqualLength);
                }
                if (this._vod.get_seq().getText().length() != this._vod.get_struct().getText().length()) {
                    arrayList.add("different lenghts");
                    this._vod.get_seq().setForeground(this.COLORWARNING);
                    this._vod.get_struct().setForeground(this.COLORWARNING);
                } else {
                    this._vod.get_seq().setForeground(Color.black);
                    this._vod.get_struct().setForeground(Color.black);
                }
            }
            this._vod.get_varnaPanel().getVARNAUI().UIReset();
            String string = new String();
            if (arrayList.size() != 0) {
                string = string + (String)arrayList.get(0);
                for (int i = 1; i < arrayList.size(); ++i) {
                    string = string + ", " + (String)arrayList.get(i);
                }
                string = string + ".";
            }
            this._vod.get_info().setText(string);
        }
    }
}

