/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.controlers;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.models.annotations.ChemProbAnnotation;
import fr.orsay.lri.varna.models.rna.ModeleColorMap;
import java.awt.Color;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class ControleurScriptParser {
    private static String SCRIPT_ERROR_PREFIX = "Error";
    private static Hashtable<String, Function> _name2Fun = new Hashtable();
    private static Hashtable<Function, ArgumentType[]> _fun2Prot = new Hashtable();

    private static void initFunctions() {
        if (_name2Fun.size() > 0) {
            return;
        }
        Function[] functionArray = Function.values();
        for (int i = 0; i < functionArray.length; ++i) {
            Function function = functionArray[i];
            _name2Fun.put(function.getFunName(), function);
            _fun2Prot.put(function, function.getPrototype());
        }
    }

    private static Function getFunction(String string) {
        String string2 = string.trim().toLowerCase();
        if (_name2Fun.containsKey(string2)) {
            return _name2Fun.get(string2);
        }
        return Function.UNKNOWN;
    }

    private static ArgumentType[] getPrototype(Function function) {
        if (_fun2Prot.containsKey((Object)function)) {
            return _fun2Prot.get((Object)function);
        }
        return new ArgumentType[0];
    }

    public static void executeScript(VARNAPanel vARNAPanel, String string) throws Exception {
        Vector<Command> vector = ControleurScriptParser.parseScript(string);
        for (int i = 0; i < vector.size(); ++i) {
            Command command = vector.get(i);
            switch (command._f) {
                case ADD_CHEM_PROB: {
                    int n = ((NumberArgument)command._argv.get(0)).getNumber().intValue();
                    int n2 = ((NumberArgument)command._argv.get(1)).getNumber().intValue();
                    ChemProbAnnotation.ChemProbAnnotationType chemProbAnnotationType = ChemProbAnnotation.annotTypeFromString(((StringArgument)command._argv.get(2)).toString());
                    double d = ((NumberArgument)command._argv.get(3)).getNumber().doubleValue();
                    Object object = ((ColorArgument)command._argv.get(4)).getColor();
                    boolean bl = ((BooleanArgument)command._argv.get(5)).getBoolean();
                    vARNAPanel.getRNA().addChemProbAnnotation(new ChemProbAnnotation(vARNAPanel.getRNA().getBaseAt(n), vARNAPanel.getRNA().getBaseAt(n2), chemProbAnnotationType, d, (Color)object, bl));
                    break;
                }
                case ERASE_SEQ: {
                    vARNAPanel.eraseSequence();
                    break;
                }
                case RESET_CHEM_PROB: {
                    vARNAPanel.getRNA().clearChemProbAnnotations();
                    vARNAPanel.repaint();
                    break;
                }
                case SET_COLOR_MAP_MIN: {
                    vARNAPanel.setColorMapMinValue(((NumberArgument)command._argv.get(0)).getNumber().doubleValue());
                    break;
                }
                case SET_COLOR_MAP_MAX: {
                    vARNAPanel.setColorMapMaxValue(((NumberArgument)command._argv.get(0)).getNumber().doubleValue());
                    break;
                }
                case SET_COLOR_MAP: {
                    vARNAPanel.setColorMap(ModeleColorMap.parseColorMap(command._argv.get(0).toString()));
                    break;
                }
                case SET_CUSTOM_COLOR_MAP: {
                    Argument argument;
                    Object object;
                    ModeleColorMap modeleColorMap = new ModeleColorMap();
                    ArrayArgument arrayArgument = (ArrayArgument)command._argv.get(0);
                    for (int j = 0; j < arrayArgument.getSize(); ++j) {
                        Argument argument2 = arrayArgument.getArgument(j);
                        if (argument2._t != ArgumentType.ARRAY_TYPE || ((ArrayArgument)(argument = (ArrayArgument)argument2)).getSize() != 2) continue;
                        object = ((ArrayArgument)argument).getArgument(0);
                        Argument argument3 = ((ArrayArgument)argument).getArgument(1);
                        if (((Argument)object).getType() != ArgumentType.NUMBER_TYPE || argument3.getType() != ArgumentType.COLOR_TYPE) continue;
                        modeleColorMap.addColor(((NumberArgument)object).getNumber().doubleValue(), ((ColorArgument)argument3).getColor());
                    }
                    vARNAPanel.setColorMap(modeleColorMap);
                    break;
                }
                case SET_RNA: {
                    String string2 = command._argv.get(0).toString();
                    String string3 = command._argv.get(1).toString();
                    vARNAPanel.drawRNA(string2, string3);
                    break;
                }
                case SET_RNA_SMOOTH: {
                    String string4 = command._argv.get(0).toString();
                    String string5 = command._argv.get(1).toString();
                    vARNAPanel.drawRNAInterpolated(string4, string5);
                    vARNAPanel.repaint();
                    break;
                }
                case SET_SELECTION: {
                    Argument argument;
                    ArrayArgument arrayArgument = (ArrayArgument)command._argv.get(0);
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    for (int j = 0; j < arrayArgument.getSize(); ++j) {
                        Argument argument4 = arrayArgument.getArgument(j);
                        if (argument4._t != ArgumentType.NUMBER_TYPE) continue;
                        argument = (NumberArgument)argument4;
                        arrayList.add(((NumberArgument)argument).getNumber().intValue());
                    }
                    vARNAPanel.setSelection(arrayList);
                    vARNAPanel.repaint();
                    break;
                }
                case SET_SEQ: {
                    String string6 = command._argv.get(0).toString();
                    vARNAPanel.setSequence(string6);
                    break;
                }
                case SET_STRUCT: {
                    String string7 = vARNAPanel.getRNA().getSeq();
                    String string8 = command._argv.get(0).toString();
                    vARNAPanel.drawRNA(string7, string8);
                    break;
                }
                case SET_STRUCT_SMOOTH: {
                    String string9 = vARNAPanel.getRNA().getSeq();
                    String string10 = command._argv.get(0).toString();
                    vARNAPanel.drawRNAInterpolated(string9, string10);
                    vARNAPanel.repaint();
                    break;
                }
                case SET_TITLE: {
                    vARNAPanel.setTitle(command._argv.get(0).toString());
                    break;
                }
                case SET_VALUES: {
                    Argument argument;
                    ArrayArgument arrayArgument = (ArrayArgument)command._argv.get(0);
                    Double[] doubleArray = new Double[arrayArgument.getSize()];
                    for (int j = 0; j < arrayArgument.getSize(); ++j) {
                        Argument argument5 = arrayArgument.getArgument(j);
                        if (argument5._t != ArgumentType.NUMBER_TYPE) continue;
                        argument = (NumberArgument)argument5;
                        doubleArray[j] = ((NumberArgument)argument).getNumber().doubleValue();
                    }
                    vARNAPanel.setColorMapValues(doubleArray);
                    vARNAPanel.repaint();
                    break;
                }
                case REDRAW: {
                    int n = -1;
                    String string11 = command._argv.get(0).toString().toLowerCase();
                    if (string11.equals("radiate")) {
                        n = 2;
                    } else if (string11.equals("circular")) {
                        n = 1;
                    } else if (string11.equals("naview")) {
                        n = 3;
                    } else if (string11.equals("linear")) {
                        n = 4;
                    }
                    if (n == -1) break;
                    vARNAPanel.drawRNA(vARNAPanel.getRNA(), n);
                    break;
                }
                case TOGGLE_SHOW_COLOR_MAP: {
                    vARNAPanel.setColorMapVisible(!vARNAPanel.getColorMapVisible());
                    break;
                }
                default: {
                    throw new Exception(SCRIPT_ERROR_PREFIX + ": Method '" + (Object)((Object)command._f) + "' unimplemented.");
                }
            }
            vARNAPanel.repaint();
        }
    }

    private static Color parseColor(String string) {
        Color color = null;
        try {
            color = Color.decode(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return color;
    }

    private static Boolean parseBoolean(String string) {
        Boolean bl = null;
        if (string.toLowerCase().equals("true")) {
            bl = new Boolean(true);
        }
        if (string.toLowerCase().equals("false")) {
            bl = new Boolean(false);
        }
        return bl;
    }

    private static Vector<Argument> parseArguments(StreamTokenizer streamTokenizer, boolean bl) throws Exception {
        Vector<Argument> vector = new Vector<Argument>();
        while (streamTokenizer.ttype != 41 && bl || streamTokenizer.ttype != 93 && !bl) {
            streamTokenizer.nextToken();
            switch (streamTokenizer.ttype) {
                case -2: {
                    vector.add(new NumberArgument(streamTokenizer.nval));
                    break;
                }
                case -3: {
                    Color color = ControleurScriptParser.parseColor(streamTokenizer.sval);
                    if (color != null) {
                        vector.add(new ColorArgument(color));
                        break;
                    }
                    Boolean bl2 = ControleurScriptParser.parseBoolean(streamTokenizer.sval);
                    if (bl2 != null) {
                        vector.add(new BooleanArgument(bl2));
                        break;
                    }
                    vector.add(new StringArgument(streamTokenizer.sval));
                    break;
                }
                case 34: {
                    vector.add(new StringArgument(streamTokenizer.sval));
                    break;
                }
                case 91: {
                    vector.add(new ArrayArgument(ControleurScriptParser.parseArguments(streamTokenizer, false)));
                    break;
                }
                case 40: {
                    vector.add(new ArrayArgument(ControleurScriptParser.parseArguments(streamTokenizer, true)));
                    break;
                }
                case 41: {
                    if (bl) {
                        return vector;
                    }
                    throw new Exception(SCRIPT_ERROR_PREFIX + ": Opening " + (bl ? "parenthesis" : "bracket") + " matched with a closing " + (!bl ? "parenthesis" : "bracket"));
                }
                case 93: {
                    if (!bl) {
                        return vector;
                    }
                    throw new Exception(SCRIPT_ERROR_PREFIX + ": Opening " + (bl ? "parenthesis" : "bracket") + " matched with a closing " + (!bl ? "parenthesis" : "bracket"));
                }
                case 44: {
                    break;
                }
                case -1: {
                    throw new Exception(SCRIPT_ERROR_PREFIX + ": Unmatched opening " + (bl ? "parenthesis" : "bracket"));
                }
            }
        }
        return vector;
    }

    private static Command parseCommand(String string) throws Exception {
        int n = string.indexOf("(");
        if (n == -1) {
            throw new Exception(SCRIPT_ERROR_PREFIX + ": Syntax error");
        }
        String string2 = string.substring(0, n);
        Function function = ControleurScriptParser.getFunction(string2);
        if (function == Function.UNKNOWN) {
            throw new Exception(SCRIPT_ERROR_PREFIX + ": Unknown function \"" + string2 + "\"");
        }
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string.substring(n + 1)));
        streamTokenizer.eolIsSignificant(false);
        streamTokenizer.parseNumbers();
        streamTokenizer.quoteChar(34);
        streamTokenizer.ordinaryChar(61);
        streamTokenizer.ordinaryChar(44);
        streamTokenizer.ordinaryChar(91);
        streamTokenizer.ordinaryChar(93);
        streamTokenizer.ordinaryChar(40);
        streamTokenizer.ordinaryChar(41);
        streamTokenizer.wordChars(35, 35);
        Vector<Argument> vector = ControleurScriptParser.parseArguments(streamTokenizer, true);
        ControleurScriptParser.checkArgs(function, vector);
        Command command = new Command(function, vector);
        return command;
    }

    private static boolean checkArgs(Function function, Vector<Argument> vector) throws Exception {
        ArgumentType[] argumentTypeArray = ControleurScriptParser.getPrototype(function);
        if (argumentTypeArray.length != vector.size()) {
            throw new Exception(SCRIPT_ERROR_PREFIX + ": Wrong number of argument for function \"" + (Object)((Object)function) + "\".");
        }
        for (int i = 0; i < argumentTypeArray.length; ++i) {
            if (argumentTypeArray[i] == vector.get((int)i)._t) continue;
            throw new Exception(SCRIPT_ERROR_PREFIX + ": Bad type (" + (Object)((Object)argumentTypeArray[i]) + "!=" + (Object)((Object)vector.get((int)i)._t) + ") for argument #" + (i + 1) + " in function \"" + (Object)((Object)function) + "\".");
        }
        return true;
    }

    private static Vector<Command> parseScript(String string) throws Exception {
        ControleurScriptParser.initFunctions();
        Vector<Command> vector = new Vector<Command>();
        String[] stringArray = string.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(ControleurScriptParser.parseCommand(stringArray[i].trim()));
        }
        return vector;
    }

    private static enum Function {
        ADD_CHEM_PROB("addchemprob", new ArgumentType[]{ArgumentType.NUMBER_TYPE, ArgumentType.NUMBER_TYPE, ArgumentType.STRING_TYPE, ArgumentType.NUMBER_TYPE, ArgumentType.COLOR_TYPE, ArgumentType.BOOLEAN_TYPE}),
        ERASE_SEQ("eraseseq", new ArgumentType[0]),
        RESET_CHEM_PROB("resetchemprob", new ArgumentType[0]),
        SET_COLOR_MAP_MIN("setcolormapminvalue", new ArgumentType[]{ArgumentType.NUMBER_TYPE}),
        SET_COLOR_MAP_MAX("setcolormapmaxvalue", new ArgumentType[]{ArgumentType.NUMBER_TYPE}),
        SET_COLOR_MAP("setcolormap", new ArgumentType[]{ArgumentType.STRING_TYPE}),
        SET_CUSTOM_COLOR_MAP("setcustomcolormap", new ArgumentType[]{ArgumentType.ARRAY_TYPE}),
        SET_SEQ("setseq", new ArgumentType[]{ArgumentType.STRING_TYPE}),
        SET_STRUCT("setstruct", new ArgumentType[]{ArgumentType.STRING_TYPE}),
        SET_STRUCT_SMOOTH("setstructsmooth", new ArgumentType[]{ArgumentType.STRING_TYPE}),
        SET_TITLE("settitle", new ArgumentType[]{ArgumentType.STRING_TYPE}),
        SET_RNA("setrna", new ArgumentType[]{ArgumentType.STRING_TYPE, ArgumentType.STRING_TYPE}),
        SET_RNA_SMOOTH("setrnasmooth", new ArgumentType[]{ArgumentType.STRING_TYPE, ArgumentType.STRING_TYPE}),
        SET_SELECTION("setselection", new ArgumentType[]{ArgumentType.ARRAY_TYPE}),
        SET_VALUES("setvalues", new ArgumentType[]{ArgumentType.ARRAY_TYPE}),
        TOGGLE_SHOW_COLOR_MAP("toggleshowcolormap", new ArgumentType[0]),
        REDRAW("redraw", new ArgumentType[]{ArgumentType.STRING_TYPE}),
        UNKNOWN("N/A", new ArgumentType[0]);

        String _funName;
        ArgumentType[] _args;

        private Function(String string2, ArgumentType[] argumentTypeArray) {
            this._funName = string2;
            this._args = argumentTypeArray;
        }

        ArgumentType[] getPrototype() {
            return this._args;
        }

        String getFunName() {
            return this._funName;
        }
    }

    private static enum ArgumentType {
        STRING_TYPE,
        NUMBER_TYPE,
        BOOLEAN_TYPE,
        ARRAY_TYPE,
        COLOR_TYPE;

    }

    private static class ArrayArgument
    extends Argument {
        Vector<Argument> _val;

        public ArrayArgument(Vector<Argument> vector) {
            super(ArgumentType.ARRAY_TYPE);
            this._val = vector;
        }

        public int getSize() {
            return this._val.size();
        }

        public Argument getArgument(int n) {
            return this._val.get(n);
        }

        @Override
        public String toString() {
            return this._val.toString();
        }
    }

    private static class StringArgument
    extends Argument {
        String _val;

        public StringArgument(String string) {
            super(ArgumentType.STRING_TYPE);
            this._val = string;
        }

        @Override
        public String toString() {
            return this._val.toString();
        }
    }

    private static class BooleanArgument
    extends Argument {
        boolean _val;

        public BooleanArgument(boolean bl) {
            super(ArgumentType.BOOLEAN_TYPE);
            this._val = bl;
        }

        public boolean getBoolean() {
            return this._val;
        }

        @Override
        public String toString() {
            return "" + this._val;
        }
    }

    private static class ColorArgument
    extends Argument {
        Color _val;

        public ColorArgument(Color color) {
            super(ArgumentType.COLOR_TYPE);
            this._val = color;
        }

        public Color getColor() {
            return this._val;
        }

        @Override
        public String toString() {
            return this._val.toString();
        }
    }

    private static class NumberArgument
    extends Argument {
        Number _val;

        public NumberArgument(Number number) {
            super(ArgumentType.NUMBER_TYPE);
            this._val = number;
        }

        public Number getNumber() {
            return this._val;
        }

        @Override
        public String toString() {
            return this._val.toString();
        }
    }

    private static abstract class Argument {
        ArgumentType _t;

        public Argument(ArgumentType argumentType) {
            this._t = argumentType;
        }

        public ArgumentType getType() {
            return this._t;
        }

        public abstract String toString();
    }

    private static class Command {
        Function _f;
        Vector<Argument> _argv;

        public Command(Function function, Vector<Argument> vector) {
            this._f = function;
            this._argv = vector;
        }
    }
}

