/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.annotations;

import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.VARNAPoint;
import fr.orsay.lri.varna.utils.XMLUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class TextAnnotation
implements Serializable {
    private static final long serialVersionUID = 465236085501860747L;
    public static final Color DEFAULTCOLOR = Color.black;
    public static final Font DEFAULTFONT = new Font("Arial", 0, 12);
    private String _text;
    private AnchorType _typeAnchor;
    private Color _color;
    private double _angle;
    private Object _anchor;
    private Font _font;
    public static String XML_ELEMENT_NAME = "textAnnotation";
    public static String XML_VAR_TYPE_NAME = "type";
    public static String XML_VAR_COLOR_NAME = "color";
    public static String XML_VAR_ANGLE_NAME = "angle";
    public static String XML_VAR_TEXT_NAME = "text";

    public void toXML(TransformerHandler transformerHandler) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "", XML_VAR_TYPE_NAME, "CDATA", "" + (Object)((Object)this._typeAnchor));
        attributesImpl.addAttribute("", "", XML_VAR_COLOR_NAME, "CDATA", "" + XMLUtils.toHTMLNotation(this._color));
        attributesImpl.addAttribute("", "", XML_VAR_ANGLE_NAME, "CDATA", "" + this._angle);
        transformerHandler.startElement("", "", XML_ELEMENT_NAME, attributesImpl);
        attributesImpl.clear();
        transformerHandler.startElement("", "", XML_VAR_TEXT_NAME, attributesImpl);
        XMLUtils.exportCDATAString(transformerHandler, this._text);
        transformerHandler.endElement("", "", XML_VAR_TEXT_NAME);
        switch (this._typeAnchor) {
            case POSITION: {
                ((VARNAPoint)this._anchor).toXML(transformerHandler, "pos");
                break;
            }
            case BASE: {
                XMLUtils.toXML(transformerHandler, (ModeleBase)this._anchor);
                break;
            }
            case HELIX: {
                XMLUtils.toXML(transformerHandler, (ArrayList)this._anchor);
                break;
            }
            case LOOP: {
                XMLUtils.toXML(transformerHandler, (ArrayList)this._anchor);
            }
        }
        XMLUtils.toXML(transformerHandler, this._font);
        transformerHandler.endElement("", "", XML_ELEMENT_NAME);
    }

    public TextAnnotation(String string) {
        this._text = string;
        this._color = DEFAULTCOLOR;
        this._font = DEFAULTFONT;
        this._angle = 0.0;
    }

    public TextAnnotation(String string, double d, double d2) {
        this(string);
        this._anchor = new VARNAPoint(d, d2);
        this._typeAnchor = AnchorType.POSITION;
    }

    public TextAnnotation(String string, ModeleBase modeleBase) {
        this(string);
        this._anchor = modeleBase;
        this._typeAnchor = AnchorType.BASE;
    }

    public TextAnnotation(String string, ArrayList<ModeleBase> arrayList, AnchorType anchorType) throws Exception {
        this(string);
        this._anchor = arrayList;
        if (anchorType == AnchorType.HELIX) {
            this._typeAnchor = AnchorType.HELIX;
        } else if (anchorType == AnchorType.LOOP) {
            this._typeAnchor = AnchorType.LOOP;
        } else {
            throw new Exception("Bad argument");
        }
    }

    public TextAnnotation(TextAnnotation textAnnotation) {
        this._anchor = textAnnotation.getAncrage();
        this._font = textAnnotation.getFont();
        this._text = textAnnotation.getTexte();
        this._typeAnchor = textAnnotation.getType();
    }

    public String getTexte() {
        return this._text;
    }

    public void setText(String string) {
        this._text = string;
    }

    public Font getFont() {
        return this._font;
    }

    public void setFont(Font font) {
        this._font = font;
    }

    public Object getAncrage() {
        return this._anchor;
    }

    public void setAncrage(ModeleBase modeleBase) {
        this._anchor = modeleBase;
        this._typeAnchor = AnchorType.BASE;
    }

    public void setAncrage(double d, double d2) {
        this._anchor = new VARNAPoint(d, d2);
        this._typeAnchor = AnchorType.POSITION;
    }

    public void setAncrage(ArrayList<ModeleBase> arrayList, AnchorType anchorType) throws Exception {
        this._anchor = arrayList;
        if (anchorType == AnchorType.HELIX) {
            this._typeAnchor = AnchorType.HELIX;
        } else if (anchorType == AnchorType.LOOP) {
            this._typeAnchor = AnchorType.LOOP;
        } else {
            throw new Exception("Bad argument");
        }
    }

    public AnchorType getType() {
        return this._typeAnchor;
    }

    public void setType(AnchorType anchorType) {
        this._typeAnchor = anchorType;
    }

    public Color getColor() {
        return this._color;
    }

    public void setColor(Color color) {
        this._color = color;
    }

    public String getHelixDescription() {
        ArrayList arrayList = (ArrayList)this._anchor;
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (ModeleBase modeleBase : arrayList) {
            int n5 = modeleBase.getBaseNumber();
            if (modeleBase.getElementStructure() > n5) {
                n = Math.min(n, n5);
                n2 = Math.max(n2, n5);
                continue;
            }
            n3 = Math.min(n3, n5);
            n4 = Math.max(n4, n5);
        }
        return "[" + n + "," + n2 + "] [" + n3 + "," + n4 + "]";
    }

    public String getLoopDescription() {
        ArrayList arrayList = (ArrayList)this._anchor;
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        for (ModeleBase modeleBase : arrayList) {
            int n3 = modeleBase.getBaseNumber();
            n = Math.min(n, n3);
            n2 = Math.max(n2, n3);
        }
        return "[" + n + "," + n2 + "]";
    }

    public String toString() {
        String string = "[" + this._text + "] ";
        switch (this._typeAnchor) {
            case POSITION: {
                DecimalFormat decimalFormat = new DecimalFormat(".00");
                return string + " at (" + decimalFormat.format(this.getCenterPosition().x) + "," + decimalFormat.format(this.getCenterPosition().y) + ")";
            }
            case BASE: {
                return string + " on base " + ((ModeleBase)this._anchor).getBaseNumber();
            }
            case HELIX: {
                return string + " on helix " + this.getHelixDescription();
            }
            case LOOP: {
                return string + " on loop " + this.getLoopDescription();
            }
        }
        return string;
    }

    public Point2D.Double getCenterPosition() {
        switch (this._typeAnchor) {
            case POSITION: {
                return ((VARNAPoint)this._anchor).toPoint2D();
            }
            case BASE: {
                return ((ModeleBase)this._anchor).getCoords();
            }
            case HELIX: {
                return this.calculLoopHelix();
            }
            case LOOP: {
                return this.calculLoop();
            }
        }
        return new Point2D.Double(0.0, 0.0);
    }

    private Point2D.Double calculLoop() {
        ArrayList<ModeleBase> arrayList = this.extractedArrayListModeleBaseFromAncrage();
        double d = 0.0;
        double d2 = 0.0;
        for (ModeleBase modeleBase : arrayList) {
            d += modeleBase.getCoords().x;
            d2 += modeleBase.getCoords().y;
        }
        return new Point2D.Double(d / (double)arrayList.size(), d2 / (double)arrayList.size());
    }

    private Point2D.Double calculLoopHelix() {
        ArrayList<ModeleBase> arrayList = this.extractedArrayListModeleBaseFromAncrage();
        Collections.sort(arrayList);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < arrayList.size(); ++i) {
            ModeleBase modeleBase = arrayList.get(i);
            if ((i <= 0 || i >= arrayList.size() - 1) && arrayList.size() / 2 % 2 != 0) continue;
            d += modeleBase.getCoords().x;
            d2 += modeleBase.getCoords().y;
            d3 += 1.0;
        }
        return new Point2D.Double(d / d3, d2 / d3);
    }

    private ArrayList<ModeleBase> extractedArrayListModeleBaseFromAncrage() {
        return (ArrayList)this._anchor;
    }

    public TextAnnotation clone() {
        TextAnnotation textAnnotation = null;
        try {
            switch (this._typeAnchor) {
                case BASE: {
                    textAnnotation = new TextAnnotation(this._text, (ModeleBase)this._anchor);
                    break;
                }
                case POSITION: {
                    textAnnotation = new TextAnnotation(this._text, ((VARNAPoint)this._anchor).x, ((VARNAPoint)this._anchor).y);
                    break;
                }
                case LOOP: {
                    textAnnotation = new TextAnnotation(this._text, this.extractedArrayListModeleBaseFromAncrage(), AnchorType.LOOP);
                    break;
                }
                case HELIX: {
                    textAnnotation = new TextAnnotation(this._text, this.extractedArrayListModeleBaseFromAncrage(), AnchorType.HELIX);
                    break;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        textAnnotation.setFont(this._font);
        textAnnotation.setColor(this._color);
        return textAnnotation;
    }

    public void copy(TextAnnotation textAnnotation) {
        this._anchor = textAnnotation.getAncrage();
        this._font = textAnnotation.getFont();
        this._text = textAnnotation.getTexte();
        this._typeAnchor = textAnnotation.getType();
        this._color = textAnnotation.getColor();
        this._angle = textAnnotation.getAngleInDegres();
    }

    public double getAngleInDegres() {
        return this._angle;
    }

    public double getAngleInRadians() {
        return this.getAngleInDegres() * Math.PI / 180.0;
    }

    public void setAngleInDegres(double d) {
        this._angle = d;
    }

    public void setAngleInRadians(double d) {
        this._angle = d * 180.0 / Math.PI;
    }

    public static enum AnchorType {
        POSITION,
        BASE,
        HELIX,
        LOOP;

    }
}

