/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.rna;

import fr.orsay.lri.varna.models.rna.ModelBaseStyle;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.VARNAPoint;
import fr.orsay.lri.varna.utils.XMLUtils;
import java.awt.Color;
import java.awt.geom.Point2D;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ModeleBasesComparison
extends ModeleBase {
    private static final long serialVersionUID = -2733063250714562463L;
    private Character _base1;
    private Character _base2;
    private int _appartenance = -1;
    private int _index;
    public static String XML_ELEMENT_NAME = "NTPair";
    public static String XML_VAR_FIRST_CONTENT_NAME = "base1";
    public static String XML_VAR_SECOND_CONTENT_NAME = "base2";
    public static String XML_VAR_MEMBERSHIP_NAME = "type";
    public static Color FIRST_RNA_COLOR = Color.decode("#FFDD99");
    public static Color SECOND_RNA_COLOR = Color.decode("#99DDFF");
    public static Color BOTH_RNA_COLOR = Color.decode("#99DD99");
    public static Color DEFAULT_RNA_COLOR = Color.white;

    @Override
    public void toXML(TransformerHandler transformerHandler) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "", XML_VAR_INDEX_NAME, "CDATA", "" + this._index);
        attributesImpl.addAttribute("", "", XML_VAR_NUMBER_NAME, "CDATA", "" + this._realIndex);
        attributesImpl.addAttribute("", "", XML_VAR_CUSTOM_DRAWN_NAME, "CDATA", "" + this._colorie);
        attributesImpl.addAttribute("", "", XML_VAR_LABEL_NAME, "CDATA", "" + this._label);
        attributesImpl.addAttribute("", "", XML_VAR_MEMBERSHIP_NAME, "CDATA", "" + this._appartenance);
        attributesImpl.addAttribute("", "", "VALUE", "CDATA", "" + this._value);
        transformerHandler.startElement("", "", XML_ELEMENT_NAME, attributesImpl);
        attributesImpl.clear();
        transformerHandler.startElement("", "", XML_VAR_FIRST_CONTENT_NAME, attributesImpl);
        XMLUtils.exportCDATAString(transformerHandler, "" + this._base1);
        transformerHandler.endElement("", "", XML_VAR_FIRST_CONTENT_NAME);
        attributesImpl.clear();
        transformerHandler.startElement("", "", XML_VAR_SECOND_CONTENT_NAME, attributesImpl);
        XMLUtils.exportCDATAString(transformerHandler, "" + this._base2);
        transformerHandler.endElement("", "", XML_VAR_SECOND_CONTENT_NAME);
        this._coords.toXML(transformerHandler, XML_VAR_POSITION_NAME);
        this._center.toXML(transformerHandler, XML_VAR_CENTER_NAME);
        if (this._colorie.booleanValue()) {
            this._styleBase.toXML(transformerHandler);
        }
        transformerHandler.endElement("", "", XML_ELEMENT_NAME);
    }

    public ModeleBasesComparison(int n) {
        this(' ', ' ', n);
    }

    public ModeleBasesComparison(Point2D point2D, int n) {
        this(' ', ' ', new Point2D.Double(point2D.getX(), point2D.getY()), n);
    }

    public ModeleBasesComparison(char c, char c2, int n) {
        this(c, c2, -1, n);
    }

    public ModeleBasesComparison(char c, char c2, Point2D point2D, int n) {
        this(new Point2D.Double(point2D.getX(), point2D.getY()), c, c2, true, new ModelBaseStyle(), -1, n);
    }

    public ModeleBasesComparison(char c, char c2, int n, int n2) {
        this(new Point2D.Double(), c, c2, true, new ModelBaseStyle(), n, n2);
    }

    public ModeleBasesComparison(Point2D point2D, char c, char c2, boolean bl, ModelBaseStyle modelBaseStyle, int n, int n2) {
        this._colorie = bl;
        this._base1 = Character.valueOf(c);
        this._base2 = Character.valueOf(c2);
        this._styleBase = modelBaseStyle;
        this._coords = new VARNAPoint(point2D.getX(), point2D.getY());
        this._index = n2;
    }

    @Override
    public ModelBaseStyle getStyleBase() {
        if (this._colorie.booleanValue()) {
            return this._styleBase;
        }
        return new ModelBaseStyle();
    }

    public Boolean getColored() {
        return this._colorie;
    }

    public void set_colored(Boolean bl) {
        this._colorie = bl;
    }

    public Character getBase1() {
        return this._base1;
    }

    public void setBase1(Character c) {
        this._base1 = c;
    }

    public Character getBase2() {
        return this._base2;
    }

    public void setBase2(Character c) {
        this._base2 = c;
    }

    public String getBases() {
        return String.valueOf(this._base1) + String.valueOf(this._base2);
    }

    @Override
    public String getContent() {
        return this.getBases();
    }

    public int get_appartenance() {
        return this._appartenance;
    }

    public void set_appartenance(int n) {
        if (n == 0) {
            this.getStyleBase().setBaseInnerColor(BOTH_RNA_COLOR);
        } else if (n == 1) {
            this.getStyleBase().setBaseInnerColor(FIRST_RNA_COLOR);
        } else if (n == 2) {
            this.getStyleBase().setBaseInnerColor(SECOND_RNA_COLOR);
        } else {
            this.getStyleBase().setBaseInnerColor(DEFAULT_RNA_COLOR);
        }
        this._appartenance = n;
    }

    @Override
    public int getIndex() {
        return this._index;
    }

    @Override
    public void setContent(String string) {
        this.setBase1(Character.valueOf(string.charAt(0)));
        this.setBase2(Character.valueOf(string.charAt(1)));
    }
}

