/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.treealign;

import fr.orsay.lri.varna.models.treealign.RNANodeValue2;
import fr.orsay.lri.varna.models.treealign.TreeAlignLabelDistanceSymmetric;
import java.util.ArrayList;

public class ExampleDistance3
implements TreeAlignLabelDistanceSymmetric<RNANodeValue2> {
    @Override
    public double f(RNANodeValue2 rNANodeValue2, RNANodeValue2 rNANodeValue22) {
        if (rNANodeValue2 == null) {
            if (rNANodeValue22 == null) {
                return 0.0;
            }
            if (!rNANodeValue22.isSingleNode()) {
                return rNANodeValue22.getNodes().size();
            }
            return 2.0;
        }
        if (!rNANodeValue2.isSingleNode()) {
            if (rNANodeValue22 == null) {
                return rNANodeValue2.getNodes().size();
            }
            if (!rNANodeValue22.isSingleNode()) {
                return this.alignSequenceNodes(rNANodeValue2, rNANodeValue22).getDistance();
            }
            return 2 + rNANodeValue2.getNodes().size();
        }
        if (rNANodeValue22 == null) {
            return 2.0;
        }
        if (!rNANodeValue22.isSingleNode()) {
            return 2 + rNANodeValue22.getNodes().size();
        }
        String string = rNANodeValue2.getNode().getLeftNucleotide();
        String string2 = rNANodeValue2.getNode().getRightNucleotide();
        String string3 = rNANodeValue22.getNode().getLeftNucleotide();
        String string4 = rNANodeValue22.getNode().getRightNucleotide();
        return (!string.equals(string3) ? 0.5 : 0.0) + (!string2.equals(string4) ? 0.5 : 0.0);
    }

    public SequenceAlignResult alignSequenceNodes(RNANodeValue2 rNANodeValue2, RNANodeValue2 rNANodeValue22) {
        char[] cArray = rNANodeValue2.computeSequence();
        char[] cArray2 = rNANodeValue22.computeSequence();
        return this.alignSequences(cArray, cArray2);
    }

    public SequenceAlignResult alignSequences(char[] cArray, char[] cArray2) {
        int n;
        SequenceAlignResult sequenceAlignResult = new SequenceAlignResult();
        int n2 = cArray.length;
        int n3 = cArray2.length;
        double[][] dArray = new double[n2 + 1][n3 + 1];
        int[][] nArray = new int[n2 + 1][n3 + 1];
        for (n = 0; n <= n2; ++n) {
            dArray[n][0] = 1.0 * (double)n;
        }
        for (n = 0; n <= n3; ++n) {
            dArray[0][n] = 1.0 * (double)n;
        }
        for (n = 1; n <= n2; ++n) {
            for (int i = 1; i <= n3; ++i) {
                double d;
                int n4;
                double d2;
                double d3 = dArray[n - 1][i - 1] + (cArray[n - 1] == cArray2[i - 1] ? 0.0 : 1.0);
                if (d3 < (d2 = dArray[n - 1][i] + 1.0)) {
                    n4 = 1;
                    d = d3;
                } else {
                    n4 = 2;
                    d = d2;
                }
                double d4 = dArray[n][i - 1] + 1.0;
                if (d4 < d) {
                    n4 = 3;
                    d = d4;
                }
                dArray[n][i] = d;
                nArray[n][i] = n4;
            }
        }
        sequenceAlignResult.setDistance(dArray[n2][n3]);
        int[][] nArray2 = this.computeAlignment(dArray, nArray, cArray, cArray2);
        sequenceAlignResult.setAlignment(nArray2);
        return sequenceAlignResult;
    }

    private int[][] computeAlignment(double[][] dArray, int[][] nArray, char[] cArray, char[] cArray2) {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(cArray.length + cArray2.length);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(cArray.length + cArray2.length);
        int n2 = cArray.length;
        int n3 = cArray2.length;
        block5: while (n2 > 0 && n3 > 0) {
            n = nArray[n2][n3];
            switch (n) {
                case 1: {
                    arrayList.add(n2 - 1);
                    arrayList2.add(n3 - 1);
                    --n2;
                    --n3;
                    continue block5;
                }
                case 2: {
                    arrayList.add(n2 - 1);
                    arrayList2.add(-1);
                    --n2;
                    continue block5;
                }
                case 3: {
                    arrayList.add(-1);
                    arrayList2.add(n3 - 1);
                    --n3;
                    continue block5;
                }
            }
            throw new Error("Bug in ExampleDistance3: decision = " + n);
        }
        while (n2 > 0) {
            arrayList.add(n2 - 1);
            arrayList2.add(-1);
            --n2;
        }
        while (n3 > 0) {
            arrayList.add(-1);
            arrayList2.add(n3 - 1);
            --n3;
        }
        n = arrayList.size();
        int[][] nArray2 = new int[2][n];
        for (n2 = 0; n2 < n; ++n2) {
            nArray2[0][n2] = (Integer)arrayList.get(n - 1 - n2);
            nArray2[1][n2] = (Integer)arrayList2.get(n - 1 - n2);
        }
        return nArray2;
    }

    public class SequenceAlignResult {
        private double distance;
        private int[][] alignment;

        public double getDistance() {
            return this.distance;
        }

        public void setDistance(double d) {
            this.distance = d;
        }

        public int[][] getAlignment() {
            return this.alignment;
        }

        public void setAlignment(int[][] nArray) {
            this.alignment = nArray;
        }
    }
}

