/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.views;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.controlers.ControleurMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class VueMenu
extends JPopupMenu {
    private static final long serialVersionUID = 1L;
    private VARNAPanel _vp;
    private ControleurMenu _controlerMenu;
    private JCheckBoxMenuItem _itemOptionSpecialBaseColored = new JCheckBoxMenuItem("Custom colored", false);
    private JCheckBoxMenuItem _itemShowWarnings = new JCheckBoxMenuItem("Show warnings", false);
    private JCheckBoxMenuItem _itemDrawBackbone = new JCheckBoxMenuItem("Draw backbone", true);
    private JCheckBoxMenuItem _itemOptionGapsBaseColored = new JCheckBoxMenuItem("Custom colored", false);
    private JCheckBoxMenuItem _itemOptionBondsColored = new JCheckBoxMenuItem("Use base color for base-pairs", false);
    private JCheckBoxMenuItem _itemShowNCBP = new JCheckBoxMenuItem("Show non-canonical BPs", true);
    private JCheckBoxMenuItem _itemShowOnlyPlanar = new JCheckBoxMenuItem("Hide tertiary BPs", false);
    private JCheckBoxMenuItem _itemFlatExteriorLoop = new JCheckBoxMenuItem("Flat exterior loop", false);
    private JCheckBoxMenuItem _itemShowColorMap = new JCheckBoxMenuItem("Show color map", false);
    private JMenuItem _dashBasesColor;
    private ArrayList<JComponent> _disabled = new ArrayList();
    private JMenuItem _rotation;
    private JMenuItem _bpHeightIncrement;
    private Point _spawnOrigin = new Point(-1, -1);
    JMenu _subMenuBases;
    private Component _selectionMenuIndex = null;

    public VueMenu(VARNAPanel vARNAPanel) {
        this._vp = vARNAPanel;
        this._controlerMenu = new ControleurMenu(this._vp, this);
    }

    private void addTitle(String string, boolean bl) {
        JSeparator jSeparator = new JSeparator();
        JLabel jLabel = new JLabel(" " + string);
        Font font = jLabel.getFont();
        Font font2 = font.deriveFont(1).deriveFont((float)font.getSize() + 1.0f);
        jLabel.setFont(font2);
        Color color = jLabel.getForeground();
        Color color2 = color.brighter().brighter();
        jLabel.setForeground(color2);
        this.add(jLabel);
        this.add(jSeparator);
        if (!bl) {
            this._disabled.add(jSeparator);
            this._disabled.add(jLabel);
        }
    }

    private void configMenuItem(JMenuItem jMenuItem, String string, String string2, Container container) {
        this.configMenuItem(jMenuItem, string, string2, container, false);
    }

    private void configMenuItem(JMenuItem jMenuItem, String string, String string2, Container container, boolean bl) {
        jMenuItem.setActionCommand(string);
        jMenuItem.addActionListener(this._controlerMenu);
        if (string2 != null && !string2.equals("")) {
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(string2));
        }
        if (bl) {
            this._disabled.add(jMenuItem);
        }
        container.add(jMenuItem);
    }

    private JMenuItem createMenuItem(String string, String string2, String string3, Container container, boolean bl) {
        JMenuItem jMenuItem = new JMenuItem(string);
        this.configMenuItem(jMenuItem, string2, string3, container, bl);
        return jMenuItem;
    }

    private JMenuItem createMenuItem(String string, String string2, String string3, Container container) {
        return this.createMenuItem(string, string2, string3, container, false);
    }

    public void updateDialog() {
        for (int i = 0; i < this._disabled.size(); ++i) {
            JComponent jComponent = this._disabled.get(i);
            jComponent.setVisible(this._vp.isModifiable());
        }
        this._itemOptionSpecialBaseColored.setState(this._vp.getColorSpecialBases());
        this._itemShowWarnings.setState(this._vp.getShowWarnings());
        this._itemOptionGapsBaseColored.setState(this._vp.getColorGapsBases());
        this._itemOptionGapsBaseColored.setEnabled(this._vp.isComparisonMode());
        this._dashBasesColor.setEnabled(this._vp.isComparisonMode());
        this._rotation.setEnabled(this._vp.getDrawMode() != 4);
        this._bpHeightIncrement.setEnabled(this._vp.getDrawMode() == 4);
        this._itemOptionBondsColored.setState(this._vp.getUseBaseColorsForBPs());
        this._itemShowNCBP.setState(this._vp.getShowNonCanonicalBP());
        this._itemShowOnlyPlanar.setState(!this._vp.getShowNonPlanarBP());
        this._itemShowColorMap.setState(this._vp.getColorMapVisible());
        this._itemFlatExteriorLoop.setState(this._vp.getFlatExteriorLoop());
        this._itemFlatExteriorLoop.setEnabled(this._vp.getDrawMode() == 2);
    }

    public void buildPopupMenu() {
        this.addTitle("File", true);
        this.fileMenu();
        this.exportMenu();
        this.createMenuItem("Print...", "print", "control P", this);
        this.addSeparator();
        this.addTitle("Display", true);
        this.viewMenu();
        this.displayMenu();
        JSeparator jSeparator = new JSeparator();
        this.add(jSeparator);
        this._disabled.add(jSeparator);
        this.addTitle("Edit", false);
        this.editRNAMenu();
        this.redrawMenu();
        this.colorClassesMenu();
        this.annotationMenu();
        this._disabled.add(this._itemShowNCBP);
        this._disabled.add(this._itemShowOnlyPlanar);
        this.aboutMenu();
    }

    private void annotationMenu() {
        JMenu jMenu = new JMenu("Annotations");
        JMenu jMenu2 = new JMenu("New");
        this.createMenuItem("Here", "annotationsaddPosition", "", jMenu2);
        this.createMenuItem("Base", "annotationsaddBase", "", jMenu2);
        this.createMenuItem("Loop", "annotationsaddLoop", "", jMenu2);
        this.createMenuItem("Helix", "annotationsaddHelix", "", jMenu2);
        JSeparator jSeparator = new JSeparator();
        jMenu2.add(jSeparator);
        this.createMenuItem("Region", "annotationsaddRegion", "", jMenu2);
        this.createMenuItem("Chem. prob.", "annotationsaddChemProb", "", jMenu2);
        jMenu.add(jMenu2);
        this.createMenuItem("Edit from list...", "annotationsedit", "", jMenu);
        this.createMenuItem("Remove from list...", "annotationsremove", "", jMenu);
        jMenu.addSeparator();
        this.createMenuItem("Auto 5'/3'", "annotationsautoextremites", "control alt Q", jMenu);
        this.createMenuItem("Auto helices", "annotationsautohelices", "control Q", jMenu);
        this.createMenuItem("Auto interior loops", "annotationsautointerior", "alt shift Q", jMenu);
        this.createMenuItem("Auto terminal loops", "annotationsautoterminal", "control shift Q", jMenu);
        this.add(jMenu);
    }

    private void fileMenu() {
        this.createMenuItem("New...", "userInput", "control N", this, true);
        this.createMenuItem("Open...", "file", "control O", this, true);
        this.createMenuItem("Save...", "saveas", "control S", this, true);
        JMenu jMenu = new JMenu("Save as");
        this.createMenuItem("DBN (Vienna)", "dbn", "", jMenu);
        this.createMenuItem("BPSEQ", "bpseq", "", jMenu);
        this.createMenuItem("CT", "ct", "", jMenu);
        this.add(jMenu);
    }

    private void exportMenu() {
        JMenu jMenu = new JMenu("Export");
        this.createMenuItem("SVG", "svg", "", jMenu);
        this.createMenuItem("XFIG", "xfig", "", jMenu);
        jMenu.addSeparator();
        this.createMenuItem("EPS", "eps", "", jMenu);
        jMenu.addSeparator();
        this.createMenuItem("PNG", "png", "", jMenu);
        this.createMenuItem("JPEG", "jpeg", "", jMenu);
        this.add(jMenu);
    }

    private void displayMenu() {
        JMenu jMenu = new JMenu("Base Pairs");
        this.createMenuItem("BP style...", "bpstyle", "control shift P", jMenu);
        this.configMenuItem(this._itemShowNCBP, "shownc", "control W", jMenu);
        this.configMenuItem(this._itemShowOnlyPlanar, "shownp", "control E", jMenu);
        JMenu jMenu2 = new JMenu("Non-standard bases");
        this.configMenuItem(this._itemOptionSpecialBaseColored, "specialbasecolored", "control J", jMenu2);
        this.createMenuItem("Color", "specialBasesColor", "control shift J", jMenu2);
        JMenu jMenu3 = new JMenu("'Gaps' bases");
        this.configMenuItem(this._itemOptionGapsBaseColored, "dashbasecolored", "control D", jMenu3);
        this._dashBasesColor = this.createMenuItem("Color", "dashBasesColor", "control shift D", jMenu3);
        JSeparator jSeparator = new JSeparator();
        this._disabled.add(jSeparator);
        JMenu jMenu4 = new JMenu("RNA style");
        this.createMenuItem("Toggle draw bases", "gaspin", "alt G", jMenu4, true);
        jMenu4.add(jMenu);
        jMenu4.addSeparator();
        jMenu4.add(jMenu2);
        jMenu4.add(jMenu3);
        jMenu4.add(jSeparator);
        this.createMenuItem("Backbone color", "backbone", "control K", jMenu4, true);
        this.configMenuItem(this._itemDrawBackbone, "showbackbone", "alt B", jMenu4);
        JMenu jMenu5 = new JMenu("Title");
        this.createMenuItem("Set Title", "setTitle", "control T", jMenu5, true);
        this.createMenuItem("Font", "titleDisplay", "control shift T", jMenu5, true);
        this.createMenuItem("Color", "titleColor", "control alt T", jMenu5, true);
        this._disabled.add(jMenu5);
        JMenu jMenu6 = new JMenu("Color map");
        this.configMenuItem(this._itemShowColorMap, "toggleshowcolormap", "control shift L", jMenu6, false);
        this.createMenuItem("Caption", "colormapcaption", "control shift C", jMenu6, true);
        this.createMenuItem("Style...", "colormapstyle", "control L", jMenu6, false);
        jMenu6.addSeparator();
        this.createMenuItem("Edit values...", "colormapvalues", "shift L", jMenu6, true);
        this.createMenuItem("Load values...", "colormaploadvalues", "control shift K", jMenu6, true);
        this._disabled.add(jMenu6);
        JMenu jMenu7 = new JMenu("Misc");
        this.createMenuItem("Num. period.", "numPeriod", "control M", jMenu7);
        this.createMenuItem("Background color", "background", "control G", jMenu7);
        jMenu7.add(jMenu5);
        this.add(jMenu4);
        this.add(jMenu6);
        this.add(jMenu7);
    }

    private void editRNAMenu() {
        this.createMenuItem("Bases...", "editallbases", "", this, true);
        this.createMenuItem("BasePairs...", "editallbps", "", this, true);
    }

    private void redrawMenu() {
        JMenu jMenu = new JMenu("Redraw");
        this._disabled.add(jMenu);
        JMenu jMenu2 = new JMenu("Algorithm");
        this._disabled.add(jMenu2);
        this.createMenuItem("Linear", "line", "control 1", jMenu2, true);
        this.createMenuItem("Circular", "circular", "control 2", jMenu2, true);
        this.createMenuItem("Radiate", "radiate", "control 3", jMenu2, true);
        this.createMenuItem("NAView", "naview", "control 4", jMenu2, true);
        jMenu.add(jMenu2);
        this._bpHeightIncrement = this.createMenuItem("BP height increment", "bpheightincrement", "control H", jMenu);
        this.configMenuItem(this._itemFlatExteriorLoop, "flat", "control F", jMenu, true);
        this.createMenuItem("Space between bases", "spaceBetweenBases", "control shift S", jMenu, true);
        this.createMenuItem("Reset", "reset", "control shift R", jMenu, true);
        this.add(jMenu);
    }

    private void warningMenu() {
        this.configMenuItem(this._itemShowWarnings, "showwarnings", "", this, true);
    }

    private void viewMenu() {
        JMenu jMenu = new JMenu("View");
        JMenu jMenu2 = new JMenu("Zoom");
        this.createMenuItem("25%", "zoom25", "", jMenu2);
        this.createMenuItem("50%", "zoom50", "", jMenu2);
        this.createMenuItem("100%", "zoom100", "", jMenu2);
        this.createMenuItem("150%", "zoom150", "", jMenu2);
        this.createMenuItem("200%", "zoom200", "", jMenu2);
        this.createMenuItem("Custom", "zoom", "control Z", jMenu2);
        jMenu.add(jMenu2);
        this._rotation = this.createMenuItem("Rotation...", "rotation", "control R", jMenu);
        this.createMenuItem("Rescale...", "rescale", "", jMenu);
        jMenu.addSeparator();
        this.createMenuItem("Border size", "borderSize", "control B", jMenu);
        this.add(jMenu);
    }

    public void addSelectionMenu(JMenuItem jMenuItem) {
        this._selectionMenuIndex = jMenuItem;
        this._disabled.add(jMenuItem);
        this.insert(jMenuItem, this.getComponentCount() - 2);
    }

    public void removeSelectionMenu() {
        if (this._selectionMenuIndex != null) {
            this.remove(this._selectionMenuIndex);
            this._selectionMenuIndex = null;
        }
    }

    private void colorClassesMenu() {
        this._subMenuBases = new JMenu("Colors");
        this._disabled.add(this._subMenuBases);
        this.createMenuItem("By Base", "eachKind", "control U", this._subMenuBases, true);
        this.createMenuItem("By BP", "eachCouple", "shift U", this._subMenuBases, true);
        this.createMenuItem("By Position", "eachBase", "alt U", this._subMenuBases, true);
        this.add(this._subMenuBases);
    }

    public void addColorOptions(JMenu jMenu) {
        this.createMenuItem("Fill Color", jMenu.getActionCommand() + ",InnerColor", "", jMenu, true);
        this.createMenuItem("Stroke Color", jMenu.getActionCommand() + ",OutlineColor", "", jMenu, true);
        this.createMenuItem("Label Color", jMenu.getActionCommand() + ",NameColor", "", jMenu, true);
        jMenu.addSeparator();
        this.createMenuItem("BP Color", jMenu.getActionCommand() + ",BPColor", "", jMenu, true);
        this.createMenuItem("BP Thickness", jMenu.getActionCommand() + ",BPThickness", "", jMenu, true);
        jMenu.addSeparator();
        this.createMenuItem("Number Color", jMenu.getActionCommand() + ",NumberColor", "", jMenu, true);
    }

    private void aboutMenu() {
        this.addSeparator();
        this.createMenuItem("About VARNA", "about", "control A", this);
    }

    public void addAnnotationMenu(JMenu jMenu) {
        this.addAnnotationMenu(jMenu, false);
    }

    public void addAnnotationMenu(JMenu jMenu, boolean bl) {
        Object object;
        String string = "Annotation";
        if (bl) {
            object = "";
            String string2 = this._vp.get_selectedAnnotation().getTexte();
            object = string2.length() < 5 ? string2 : string2.substring(0, 5) + "...";
            string = "Annotation: " + (String)object;
        }
        object = new JMenu(string);
        if (!bl) {
            this.createMenuItem("Add", jMenu.getActionCommand() + "annotationadd", "", (Container)object, true);
        }
        this.createMenuItem("Edit", jMenu.getActionCommand() + "annotationedit", "", (Container)object, true);
        this.createMenuItem("Remove", jMenu.getActionCommand() + "annotationremove", "", (Container)object, true);
        jMenu.add((JMenuItem)object);
    }

    public static long getSerialVersionUID() {
        return 1L;
    }

    public VARNAPanel get_vp() {
        return this._vp;
    }

    public ControleurMenu get_controleurMenu() {
        return this._controlerMenu;
    }

    public JCheckBoxMenuItem get_itemOptionSpecialBaseColored() {
        return this._itemOptionSpecialBaseColored;
    }

    public JCheckBoxMenuItem get_itemShowWarnings() {
        return this._itemShowWarnings;
    }

    public JCheckBoxMenuItem get_itemOptionDashBaseColored() {
        return this._itemOptionGapsBaseColored;
    }

    public void set_controleurMenu(ControleurMenu controleurMenu) {
        this._controlerMenu = controleurMenu;
    }

    public void set_itemOptionSpecialBaseColored(JCheckBoxMenuItem jCheckBoxMenuItem) {
        this._itemOptionSpecialBaseColored = jCheckBoxMenuItem;
    }

    public void set_itemShowWarnings(JCheckBoxMenuItem jCheckBoxMenuItem) {
        this._itemShowWarnings = jCheckBoxMenuItem;
    }

    public void set_itemOptionDashBaseColored(JCheckBoxMenuItem jCheckBoxMenuItem) {
        this._itemOptionGapsBaseColored = jCheckBoxMenuItem;
    }

    public JMenuItem get_rotation() {
        return this._rotation;
    }

    public void set_rotation(JMenuItem jMenuItem) {
        this._rotation = jMenuItem;
    }

    public JCheckBoxMenuItem get_itemOptionBondsColored() {
        return this._itemOptionBondsColored;
    }

    public void set_itemOptionBondsColored(JCheckBoxMenuItem jCheckBoxMenuItem) {
        this._itemOptionBondsColored = jCheckBoxMenuItem;
    }

    @Override
    public void show(Component component, int n, int n2) {
        this._spawnOrigin = new Point(n, n2);
        super.show(component, n, n2);
    }

    public Point getSpawnPoint() {
        return this._spawnOrigin;
    }
}

