"""
----------------------------------------------------------------

                     IBM MQ                                  

   FILE NAME:      CMQCFC                                    

   DESCRIPTION:    Declarations for PCF and Events           

----------------------------------------------------------------
                                                               
   <copyright                                                  
   notice="lm-source-program"                                  
   pids="5724-H72"                                             
   years="1993,2025"
   crc="0" >    
                                        
   Licensed Materials - Property of IBM                        
                                                               
   5724-H72                                                    
                                                               
   (C) Copyright IBM Corp. 1993, 2025 All Rights Reserved. 
                                                               
   US Government Users Restricted Rights - Use, duplication or 
   disclosure restricted by GSA ADP Schedule Contract with     
   IBM Corp.                                                   
   </copyright>                                                
                                                              
----------------------------------------------------------------

   FUNCTION:       This file declares the functions,           
                   structures and named constants for PCF       
                   and event messages.                          

   PROCESSOR:      Python

----------------------------------------------------------------
<BEGIN_BUILDINFO>
   Generated on:  10/3/25, 11:37 AM                           
   Build Level:   p944-L251003                                
   Build Type:    Production                                  
   Pointer Size:  64 Bit                                      
   Source File:
   @(#) MQMBID sn=p944-L251003                                
<END_BUILDINFO>
----------------------------------------------------------------
"""


#----------------------------------------------------------------#
# Values Related to MQCFH Structure                              #
#----------------------------------------------------------------#

# Structure Length
MQCFH_STRUC_LENGTH                       = 36

# Structure Version Number
MQCFH_VERSION_1                          = 1
MQCFH_VERSION_2                          = 2
MQCFH_VERSION_3                          = 3
MQCFH_CURRENT_VERSION                    = 3

# Command Codes
MQCMD_NONE                               = 0
MQCMD_CHANGE_Q_MGR                       = 1
MQCMD_INQUIRE_Q_MGR                      = 2
MQCMD_CHANGE_PROCESS                     = 3
MQCMD_COPY_PROCESS                       = 4
MQCMD_CREATE_PROCESS                     = 5
MQCMD_DELETE_PROCESS                     = 6
MQCMD_INQUIRE_PROCESS                    = 7
MQCMD_CHANGE_Q                           = 8
MQCMD_CLEAR_Q                            = 9
MQCMD_COPY_Q                             = 10
MQCMD_CREATE_Q                           = 11
MQCMD_DELETE_Q                           = 12
MQCMD_INQUIRE_Q                          = 13
MQCMD_REFRESH_Q_MGR                      = 16
MQCMD_RESET_Q_STATS                      = 17
MQCMD_INQUIRE_Q_NAMES                    = 18
MQCMD_INQUIRE_PROCESS_NAMES              = 19
MQCMD_INQUIRE_CHANNEL_NAMES              = 20
MQCMD_CHANGE_CHANNEL                     = 21
MQCMD_COPY_CHANNEL                       = 22
MQCMD_CREATE_CHANNEL                     = 23
MQCMD_DELETE_CHANNEL                     = 24
MQCMD_INQUIRE_CHANNEL                    = 25
MQCMD_PING_CHANNEL                       = 26
MQCMD_RESET_CHANNEL                      = 27
MQCMD_START_CHANNEL                      = 28
MQCMD_STOP_CHANNEL                       = 29
MQCMD_START_CHANNEL_INIT                 = 30
MQCMD_START_CHANNEL_LISTENER             = 31
MQCMD_CHANGE_NAMELIST                    = 32
MQCMD_COPY_NAMELIST                      = 33
MQCMD_CREATE_NAMELIST                    = 34
MQCMD_DELETE_NAMELIST                    = 35
MQCMD_INQUIRE_NAMELIST                   = 36
MQCMD_INQUIRE_NAMELIST_NAMES             = 37
MQCMD_ESCAPE                             = 38
MQCMD_RESOLVE_CHANNEL                    = 39
MQCMD_PING_Q_MGR                         = 40
MQCMD_INQUIRE_Q_STATUS                   = 41
MQCMD_INQUIRE_CHANNEL_STATUS             = 42
MQCMD_CONFIG_EVENT                       = 43
MQCMD_Q_MGR_EVENT                        = 44
MQCMD_PERFM_EVENT                        = 45
MQCMD_CHANNEL_EVENT                      = 46
MQCMD_DELETE_PUBLICATION                 = 60
MQCMD_DEREGISTER_PUBLISHER               = 61
MQCMD_DEREGISTER_SUBSCRIBER              = 62
MQCMD_PUBLISH                            = 63
MQCMD_REGISTER_PUBLISHER                 = 64
MQCMD_REGISTER_SUBSCRIBER                = 65
MQCMD_REQUEST_UPDATE                     = 66
MQCMD_BROKER_INTERNAL                    = 67
MQCMD_ACTIVITY_MSG                       = 69
MQCMD_INQUIRE_CLUSTER_Q_MGR              = 70
MQCMD_RESUME_Q_MGR_CLUSTER               = 71
MQCMD_SUSPEND_Q_MGR_CLUSTER              = 72
MQCMD_REFRESH_CLUSTER                    = 73
MQCMD_RESET_CLUSTER                      = 74
MQCMD_TRACE_ROUTE                        = 75
MQCMD_REFRESH_SECURITY                   = 78
MQCMD_CHANGE_AUTH_INFO                   = 79
MQCMD_COPY_AUTH_INFO                     = 80
MQCMD_CREATE_AUTH_INFO                   = 81
MQCMD_DELETE_AUTH_INFO                   = 82
MQCMD_INQUIRE_AUTH_INFO                  = 83
MQCMD_INQUIRE_AUTH_INFO_NAMES            = 84
MQCMD_INQUIRE_CONNECTION                 = 85
MQCMD_STOP_CONNECTION                    = 86
MQCMD_INQUIRE_AUTH_RECS                  = 87
MQCMD_INQUIRE_ENTITY_AUTH                = 88
MQCMD_DELETE_AUTH_REC                    = 89
MQCMD_SET_AUTH_REC                       = 90
MQCMD_LOGGER_EVENT                       = 91
MQCMD_RESET_Q_MGR                        = 92
MQCMD_CHANGE_LISTENER                    = 93
MQCMD_COPY_LISTENER                      = 94
MQCMD_CREATE_LISTENER                    = 95
MQCMD_DELETE_LISTENER                    = 96
MQCMD_INQUIRE_LISTENER                   = 97
MQCMD_INQUIRE_LISTENER_STATUS            = 98
MQCMD_COMMAND_EVENT                      = 99
MQCMD_CHANGE_SECURITY                    = 100
MQCMD_CHANGE_CF_STRUC                    = 101
MQCMD_CHANGE_STG_CLASS                   = 102
MQCMD_CHANGE_TRACE                       = 103
MQCMD_ARCHIVE_LOG                        = 104
MQCMD_BACKUP_CF_STRUC                    = 105
MQCMD_CREATE_BUFFER_POOL                 = 106
MQCMD_CREATE_PAGE_SET                    = 107
MQCMD_CREATE_CF_STRUC                    = 108
MQCMD_CREATE_STG_CLASS                   = 109
MQCMD_COPY_CF_STRUC                      = 110
MQCMD_COPY_STG_CLASS                     = 111
MQCMD_DELETE_CF_STRUC                    = 112
MQCMD_DELETE_STG_CLASS                   = 113
MQCMD_INQUIRE_ARCHIVE                    = 114
MQCMD_INQUIRE_CF_STRUC                   = 115
MQCMD_INQUIRE_CF_STRUC_STATUS            = 116
MQCMD_INQUIRE_CMD_SERVER                 = 117
MQCMD_INQUIRE_CHANNEL_INIT               = 118
MQCMD_INQUIRE_QSG                        = 119
MQCMD_INQUIRE_LOG                        = 120
MQCMD_INQUIRE_SECURITY                   = 121
MQCMD_INQUIRE_STG_CLASS                  = 122
MQCMD_INQUIRE_SYSTEM                     = 123
MQCMD_INQUIRE_THREAD                     = 124
MQCMD_INQUIRE_TRACE                      = 125
MQCMD_INQUIRE_USAGE                      = 126
MQCMD_MOVE_Q                             = 127
MQCMD_RECOVER_BSDS                       = 128
MQCMD_RECOVER_CF_STRUC                   = 129
MQCMD_RESET_TPIPE                        = 130
MQCMD_RESOLVE_INDOUBT                    = 131
MQCMD_RESUME_Q_MGR                       = 132
MQCMD_REVERIFY_SECURITY                  = 133
MQCMD_SET_ARCHIVE                        = 134
MQCMD_SET_LOG                            = 136
MQCMD_SET_SYSTEM                         = 137
MQCMD_START_CMD_SERVER                   = 138
MQCMD_START_Q_MGR                        = 139
MQCMD_START_TRACE                        = 140
MQCMD_STOP_CHANNEL_INIT                  = 141
MQCMD_STOP_CHANNEL_LISTENER              = 142
MQCMD_STOP_CMD_SERVER                    = 143
MQCMD_STOP_Q_MGR                         = 144
MQCMD_STOP_TRACE                         = 145
MQCMD_SUSPEND_Q_MGR                      = 146
MQCMD_INQUIRE_CF_STRUC_NAMES             = 147
MQCMD_INQUIRE_STG_CLASS_NAMES            = 148
MQCMD_CHANGE_SERVICE                     = 149
MQCMD_COPY_SERVICE                       = 150
MQCMD_CREATE_SERVICE                     = 151
MQCMD_DELETE_SERVICE                     = 152
MQCMD_INQUIRE_SERVICE                    = 153
MQCMD_INQUIRE_SERVICE_STATUS             = 154
MQCMD_START_SERVICE                      = 155
MQCMD_STOP_SERVICE                       = 156
MQCMD_DELETE_BUFFER_POOL                 = 157
MQCMD_DELETE_PAGE_SET                    = 158
MQCMD_CHANGE_BUFFER_POOL                 = 159
MQCMD_CHANGE_PAGE_SET                    = 160
MQCMD_INQUIRE_Q_MGR_STATUS               = 161
MQCMD_CREATE_LOG                         = 162
MQCMD_STATISTICS_MQI                     = 164
MQCMD_STATISTICS_Q                       = 165
MQCMD_STATISTICS_CHANNEL                 = 166
MQCMD_ACCOUNTING_MQI                     = 167
MQCMD_ACCOUNTING_Q                       = 168
MQCMD_INQUIRE_AUTH_SERVICE               = 169
MQCMD_CHANGE_TOPIC                       = 170
MQCMD_COPY_TOPIC                         = 171
MQCMD_CREATE_TOPIC                       = 172
MQCMD_DELETE_TOPIC                       = 173
MQCMD_INQUIRE_TOPIC                      = 174
MQCMD_INQUIRE_TOPIC_NAMES                = 175
MQCMD_INQUIRE_SUBSCRIPTION               = 176
MQCMD_CREATE_SUBSCRIPTION                = 177
MQCMD_CHANGE_SUBSCRIPTION                = 178
MQCMD_DELETE_SUBSCRIPTION                = 179
MQCMD_COPY_SUBSCRIPTION                  = 181
MQCMD_INQUIRE_SUB_STATUS                 = 182
MQCMD_INQUIRE_TOPIC_STATUS               = 183
MQCMD_CLEAR_TOPIC_STRING                 = 184
MQCMD_INQUIRE_PUBSUB_STATUS              = 185
MQCMD_INQUIRE_SMDS                       = 186
MQCMD_CHANGE_SMDS                        = 187
MQCMD_RESET_SMDS                         = 188
MQCMD_CREATE_COMM_INFO                   = 190
MQCMD_INQUIRE_COMM_INFO                  = 191
MQCMD_CHANGE_COMM_INFO                   = 192
MQCMD_COPY_COMM_INFO                     = 193
MQCMD_DELETE_COMM_INFO                   = 194
MQCMD_PURGE_CHANNEL                      = 195
MQCMD_MQXR_DIAGNOSTICS                   = 196
MQCMD_START_SMDSCONN                     = 197
MQCMD_STOP_SMDSCONN                      = 198
MQCMD_INQUIRE_SMDSCONN                   = 199
MQCMD_INQUIRE_MQXR_STATUS                = 200
MQCMD_START_CLIENT_TRACE                 = 201
MQCMD_STOP_CLIENT_TRACE                  = 202
MQCMD_SET_CHLAUTH_REC                    = 203
MQCMD_INQUIRE_CHLAUTH_RECS               = 204
MQCMD_INQUIRE_PROT_POLICY                = 205
MQCMD_CREATE_PROT_POLICY                 = 206
MQCMD_DELETE_PROT_POLICY                 = 207
MQCMD_CHANGE_PROT_POLICY                 = 208
MQCMD_SET_PROT_POLICY                    = 208
MQCMD_ACTIVITY_TRACE                     = 209
MQCMD_RESET_CF_STRUC                     = 213
MQCMD_INQUIRE_XR_CAPABILITY              = 214
MQCMD_INQUIRE_AMQP_CAPABILITY            = 216
MQCMD_AMQP_DIAGNOSTICS                   = 217
MQCMD_INTER_Q_MGR_STATUS                 = 218
MQCMD_INTER_Q_MGR_BALANCE                = 219
MQCMD_INQUIRE_APPL_STATUS                = 220

# Control Options
MQCFC_LAST                               = 1
MQCFC_NOT_LAST                           = 0

# Reason Codes
MQRCCF_CFH_TYPE_ERROR                    = 3001
MQRCCF_CFH_LENGTH_ERROR                  = 3002
MQRCCF_CFH_VERSION_ERROR                 = 3003
MQRCCF_CFH_MSG_SEQ_NUMBER_ERR            = 3004
MQRCCF_CFH_CONTROL_ERROR                 = 3005
MQRCCF_CFH_PARM_COUNT_ERROR              = 3006
MQRCCF_CFH_COMMAND_ERROR                 = 3007
MQRCCF_COMMAND_FAILED                    = 3008
MQRCCF_CFIN_LENGTH_ERROR                 = 3009
MQRCCF_CFST_LENGTH_ERROR                 = 3010
MQRCCF_CFST_STRING_LENGTH_ERR            = 3011
MQRCCF_FORCE_VALUE_ERROR                 = 3012
MQRCCF_STRUCTURE_TYPE_ERROR              = 3013
MQRCCF_CFIN_PARM_ID_ERROR                = 3014
MQRCCF_CFST_PARM_ID_ERROR                = 3015
MQRCCF_MSG_LENGTH_ERROR                  = 3016
MQRCCF_CFIN_DUPLICATE_PARM               = 3017
MQRCCF_CFST_DUPLICATE_PARM               = 3018
MQRCCF_PARM_COUNT_TOO_SMALL              = 3019
MQRCCF_PARM_COUNT_TOO_BIG                = 3020
MQRCCF_Q_ALREADY_IN_CELL                 = 3021
MQRCCF_Q_TYPE_ERROR                      = 3022
MQRCCF_MD_FORMAT_ERROR                   = 3023
MQRCCF_CFSL_LENGTH_ERROR                 = 3024
MQRCCF_REPLACE_VALUE_ERROR               = 3025
MQRCCF_CFIL_DUPLICATE_VALUE              = 3026
MQRCCF_CFIL_COUNT_ERROR                  = 3027
MQRCCF_CFIL_LENGTH_ERROR                 = 3028
MQRCCF_QUIESCE_VALUE_ERROR               = 3029
MQRCCF_MODE_VALUE_ERROR                  = 3029
MQRCCF_MSG_SEQ_NUMBER_ERROR              = 3030
MQRCCF_PING_DATA_COUNT_ERROR             = 3031
MQRCCF_PING_DATA_COMPARE_ERROR           = 3032
MQRCCF_CFSL_PARM_ID_ERROR                = 3033
MQRCCF_CHANNEL_TYPE_ERROR                = 3034
MQRCCF_PARM_SEQUENCE_ERROR               = 3035
MQRCCF_XMIT_PROTOCOL_TYPE_ERR            = 3036
MQRCCF_BATCH_SIZE_ERROR                  = 3037
MQRCCF_DISC_INT_ERROR                    = 3038
MQRCCF_SHORT_RETRY_ERROR                 = 3039
MQRCCF_SHORT_TIMER_ERROR                 = 3040
MQRCCF_LONG_RETRY_ERROR                  = 3041
MQRCCF_LONG_TIMER_ERROR                  = 3042
MQRCCF_SEQ_NUMBER_WRAP_ERROR             = 3043
MQRCCF_MAX_MSG_LENGTH_ERROR              = 3044
MQRCCF_PUT_AUTH_ERROR                    = 3045
MQRCCF_PURGE_VALUE_ERROR                 = 3046
MQRCCF_CFIL_PARM_ID_ERROR                = 3047
MQRCCF_MSG_TRUNCATED                     = 3048
MQRCCF_CCSID_ERROR                       = 3049
MQRCCF_ENCODING_ERROR                    = 3050
MQRCCF_QUEUES_VALUE_ERROR                = 3051
MQRCCF_DATA_CONV_VALUE_ERROR             = 3052
MQRCCF_INDOUBT_VALUE_ERROR               = 3053
MQRCCF_ESCAPE_TYPE_ERROR                 = 3054
MQRCCF_REPOS_VALUE_ERROR                 = 3055
MQRCCF_CHANNEL_TABLE_ERROR               = 3062
MQRCCF_MCA_TYPE_ERROR                    = 3063
MQRCCF_CHL_INST_TYPE_ERROR               = 3064
MQRCCF_CHL_STATUS_NOT_FOUND              = 3065
MQRCCF_CFSL_DUPLICATE_PARM               = 3066
MQRCCF_CFSL_TOTAL_LENGTH_ERROR           = 3067
MQRCCF_CFSL_COUNT_ERROR                  = 3068
MQRCCF_CFSL_STRING_LENGTH_ERR            = 3069
MQRCCF_BROKER_DELETED                    = 3070
MQRCCF_STREAM_ERROR                      = 3071
MQRCCF_TOPIC_ERROR                       = 3072
MQRCCF_NOT_REGISTERED                    = 3073
MQRCCF_Q_MGR_NAME_ERROR                  = 3074
MQRCCF_INCORRECT_STREAM                  = 3075
MQRCCF_Q_NAME_ERROR                      = 3076
MQRCCF_NO_RETAINED_MSG                   = 3077
MQRCCF_DUPLICATE_IDENTITY                = 3078
MQRCCF_INCORRECT_Q                       = 3079
MQRCCF_CORREL_ID_ERROR                   = 3080
MQRCCF_NOT_AUTHORIZED                    = 3081
MQRCCF_UNKNOWN_STREAM                    = 3082
MQRCCF_REG_OPTIONS_ERROR                 = 3083
MQRCCF_PUB_OPTIONS_ERROR                 = 3084
MQRCCF_UNKNOWN_BROKER                    = 3085
MQRCCF_Q_MGR_CCSID_ERROR                 = 3086
MQRCCF_DEL_OPTIONS_ERROR                 = 3087
MQRCCF_CLUSTER_NAME_CONFLICT             = 3088
MQRCCF_REPOS_NAME_CONFLICT               = 3089
MQRCCF_CLUSTER_Q_USAGE_ERROR             = 3090
MQRCCF_ACTION_VALUE_ERROR                = 3091
MQRCCF_COMMS_LIBRARY_ERROR               = 3092
MQRCCF_NETBIOS_NAME_ERROR                = 3093
MQRCCF_BROKER_COMMAND_FAILED             = 3094
MQRCCF_CFST_CONFLICTING_PARM             = 3095
MQRCCF_PATH_NOT_VALID                    = 3096
MQRCCF_PARM_SYNTAX_ERROR                 = 3097
MQRCCF_PWD_LENGTH_ERROR                  = 3098
MQRCCF_FILTER_ERROR                      = 3150
MQRCCF_WRONG_USER                        = 3151
MQRCCF_DUPLICATE_SUBSCRIPTION            = 3152
MQRCCF_SUB_NAME_ERROR                    = 3153
MQRCCF_SUB_IDENTITY_ERROR                = 3154
MQRCCF_SUBSCRIPTION_IN_USE               = 3155
MQRCCF_SUBSCRIPTION_LOCKED               = 3156
MQRCCF_ALREADY_JOINED                    = 3157
MQRCCF_OBJECT_IN_USE                     = 3160
MQRCCF_UNKNOWN_FILE_NAME                 = 3161
MQRCCF_FILE_NOT_AVAILABLE                = 3162
MQRCCF_DISC_RETRY_ERROR                  = 3163
MQRCCF_ALLOC_RETRY_ERROR                 = 3164
MQRCCF_ALLOC_SLOW_TIMER_ERROR            = 3165
MQRCCF_ALLOC_FAST_TIMER_ERROR            = 3166
MQRCCF_PORT_NUMBER_ERROR                 = 3167
MQRCCF_CHL_SYSTEM_NOT_ACTIVE             = 3168
MQRCCF_ENTITY_NAME_MISSING               = 3169
MQRCCF_PROFILE_NAME_ERROR                = 3170
MQRCCF_AUTH_VALUE_ERROR                  = 3171
MQRCCF_AUTH_VALUE_MISSING                = 3172
MQRCCF_OBJECT_TYPE_MISSING               = 3173
MQRCCF_CONNECTION_ID_ERROR               = 3174
MQRCCF_LOG_TYPE_ERROR                    = 3175
MQRCCF_PROGRAM_NOT_AVAILABLE             = 3176
MQRCCF_PROGRAM_AUTH_FAILED               = 3177
MQRCCF_NONE_FOUND                        = 3200
MQRCCF_SECURITY_SWITCH_OFF               = 3201
MQRCCF_SECURITY_REFRESH_FAILED           = 3202
MQRCCF_PARM_CONFLICT                     = 3203
MQRCCF_COMMAND_INHIBITED                 = 3204
MQRCCF_OBJECT_BEING_DELETED              = 3205
MQRCCF_STORAGE_CLASS_IN_USE              = 3207
MQRCCF_OBJECT_NAME_RESTRICTED            = 3208
MQRCCF_OBJECT_LIMIT_EXCEEDED             = 3209
MQRCCF_OBJECT_OPEN_FORCE                 = 3210
MQRCCF_DISPOSITION_CONFLICT              = 3211
MQRCCF_Q_MGR_NOT_IN_QSG                  = 3212
MQRCCF_ATTR_VALUE_FIXED                  = 3213
MQRCCF_NAMELIST_ERROR                    = 3215
MQRCCF_NO_CHANNEL_INITIATOR              = 3217
MQRCCF_CHANNEL_INITIATOR_ERROR           = 3218
MQRCCF_COMMAND_LEVEL_CONFLICT            = 3222
MQRCCF_Q_ATTR_CONFLICT                   = 3223
MQRCCF_EVENTS_DISABLED                   = 3224
MQRCCF_COMMAND_SCOPE_ERROR               = 3225
MQRCCF_COMMAND_REPLY_ERROR               = 3226
MQRCCF_FUNCTION_RESTRICTED               = 3227
MQRCCF_PARM_MISSING                      = 3228
MQRCCF_PARM_VALUE_ERROR                  = 3229
MQRCCF_COMMAND_LENGTH_ERROR              = 3230
MQRCCF_COMMAND_ORIGIN_ERROR              = 3231
MQRCCF_LISTENER_CONFLICT                 = 3232
MQRCCF_LISTENER_STARTED                  = 3233
MQRCCF_LISTENER_STOPPED                  = 3234
MQRCCF_CHANNEL_ERROR                     = 3235
MQRCCF_CF_STRUC_ERROR                    = 3236
MQRCCF_UNKNOWN_USER_ID                   = 3237
MQRCCF_UNEXPECTED_ERROR                  = 3238
MQRCCF_NO_XCF_PARTNER                    = 3239
MQRCCF_CFGR_PARM_ID_ERROR                = 3240
MQRCCF_CFIF_LENGTH_ERROR                 = 3241
MQRCCF_CFIF_OPERATOR_ERROR               = 3242
MQRCCF_CFIF_PARM_ID_ERROR                = 3243
MQRCCF_CFSF_FILTER_VAL_LEN_ERR           = 3244
MQRCCF_CFSF_LENGTH_ERROR                 = 3245
MQRCCF_CFSF_OPERATOR_ERROR               = 3246
MQRCCF_CFSF_PARM_ID_ERROR                = 3247
MQRCCF_TOO_MANY_FILTERS                  = 3248
MQRCCF_LISTENER_RUNNING                  = 3249
MQRCCF_LSTR_STATUS_NOT_FOUND             = 3250
MQRCCF_SERVICE_RUNNING                   = 3251
MQRCCF_SERV_STATUS_NOT_FOUND             = 3252
MQRCCF_SERVICE_STOPPED                   = 3253
MQRCCF_CFBS_DUPLICATE_PARM               = 3254
MQRCCF_CFBS_LENGTH_ERROR                 = 3255
MQRCCF_CFBS_PARM_ID_ERROR                = 3256
MQRCCF_CFBS_STRING_LENGTH_ERR            = 3257
MQRCCF_CFGR_LENGTH_ERROR                 = 3258
MQRCCF_CFGR_PARM_COUNT_ERROR             = 3259
MQRCCF_CONN_NOT_STOPPED                  = 3260
MQRCCF_SERVICE_REQUEST_PENDING           = 3261
MQRCCF_NO_START_CMD                      = 3262
MQRCCF_NO_STOP_CMD                       = 3263
MQRCCF_CFBF_LENGTH_ERROR                 = 3264
MQRCCF_CFBF_PARM_ID_ERROR                = 3265
MQRCCF_CFBF_OPERATOR_ERROR               = 3266
MQRCCF_CFBF_FILTER_VAL_LEN_ERR           = 3267
MQRCCF_LISTENER_STILL_ACTIVE             = 3268
MQRCCF_DEF_XMIT_Q_CLUS_ERROR             = 3269
MQRCCF_TOPICSTR_ALREADY_EXISTS           = 3300
MQRCCF_SHARING_CONVS_ERROR               = 3301
MQRCCF_SHARING_CONVS_TYPE                = 3302
MQRCCF_SECURITY_CASE_CONFLICT            = 3303
MQRCCF_TOPIC_TYPE_ERROR                  = 3305
MQRCCF_MAX_INSTANCES_ERROR               = 3306
MQRCCF_MAX_INSTS_PER_CLNT_ERR            = 3307
MQRCCF_TOPIC_STRING_NOT_FOUND            = 3308
MQRCCF_SUBSCRIPTION_POINT_ERR            = 3309
MQRCCF_SUB_ALREADY_EXISTS                = 3311
MQRCCF_UNKNOWN_OBJECT_NAME               = 3312
MQRCCF_REMOTE_Q_NAME_ERROR               = 3313
MQRCCF_DURABILITY_NOT_ALLOWED            = 3314
MQRCCF_HOBJ_ERROR                        = 3315
MQRCCF_DEST_NAME_ERROR                   = 3316
MQRCCF_INVALID_DESTINATION               = 3317
MQRCCF_PUBSUB_INHIBITED                  = 3318
MQRCCF_GROUPUR_CHECKS_FAILED             = 3319
MQRCCF_COMM_INFO_TYPE_ERROR              = 3320
MQRCCF_USE_CLIENT_ID_ERROR               = 3321
MQRCCF_CLIENT_ID_NOT_FOUND               = 3322
MQRCCF_CLIENT_ID_ERROR                   = 3323
MQRCCF_PORT_IN_USE                       = 3324
MQRCCF_SSL_ALT_PROVIDER_REQD             = 3325
MQRCCF_CHLAUTH_TYPE_ERROR                = 3326
MQRCCF_CHLAUTH_ACTION_ERROR              = 3327
MQRCCF_POLICY_NOT_FOUND                  = 3328
MQRCCF_ENCRYPTION_ALG_ERROR              = 3329
MQRCCF_SIGNATURE_ALG_ERROR               = 3330
MQRCCF_TOLERATION_POL_ERROR              = 3331
MQRCCF_POLICY_VERSION_ERROR              = 3332
MQRCCF_RECIPIENT_DN_MISSING              = 3333
MQRCCF_POLICY_NAME_MISSING               = 3334
MQRCCF_CHLAUTH_USERSRC_ERROR             = 3335
MQRCCF_WRONG_CHLAUTH_TYPE                = 3336
MQRCCF_CHLAUTH_ALREADY_EXISTS            = 3337
MQRCCF_CHLAUTH_NOT_FOUND                 = 3338
MQRCCF_WRONG_CHLAUTH_ACTION              = 3339
MQRCCF_WRONG_CHLAUTH_USERSRC             = 3340
MQRCCF_CHLAUTH_WARN_ERROR                = 3341
MQRCCF_WRONG_CHLAUTH_MATCH               = 3342
MQRCCF_IPADDR_RANGE_CONFLICT             = 3343
MQRCCF_CHLAUTH_MAX_EXCEEDED              = 3344
MQRCCF_IPADDR_ERROR                      = 3345
MQRCCF_ADDRESS_ERROR                     = 3345
MQRCCF_IPADDR_RANGE_ERROR                = 3346
MQRCCF_PROFILE_NAME_MISSING              = 3347
MQRCCF_CHLAUTH_CLNTUSER_ERROR            = 3348
MQRCCF_CHLAUTH_NAME_ERROR                = 3349
MQRCCF_CHLAUTH_RUNCHECK_ERROR            = 3350
MQRCCF_CF_STRUC_ALREADY_FAILED           = 3351
MQRCCF_CFCONLOS_CHECKS_FAILED            = 3352
MQRCCF_SUITE_B_ERROR                     = 3353
MQRCCF_CHANNEL_NOT_STARTED               = 3354
MQRCCF_CUSTOM_ERROR                      = 3355
MQRCCF_BACKLOG_OUT_OF_RANGE              = 3356
MQRCCF_CHLAUTH_DISABLED                  = 3357
MQRCCF_SMDS_REQUIRES_DSGROUP             = 3358
MQRCCF_PSCLUS_DISABLED_TOPDEF            = 3359
MQRCCF_PSCLUS_TOPIC_EXISTS               = 3360
MQRCCF_SSL_CIPHER_SUITE_ERROR            = 3361
MQRCCF_SOCKET_ERROR                      = 3362
MQRCCF_CLUS_XMIT_Q_USAGE_ERROR           = 3363
MQRCCF_CERT_VAL_POLICY_ERROR             = 3364
MQRCCF_INVALID_PROTOCOL                  = 3365
MQRCCF_REVDNS_DISABLED                   = 3366
MQRCCF_CLROUTE_NOT_ALTERABLE             = 3367
MQRCCF_CLUSTER_TOPIC_CONFLICT            = 3368
MQRCCF_DEFCLXQ_MODEL_Q_ERROR             = 3369
MQRCCF_CHLAUTH_CHKCLI_ERROR              = 3370
MQRCCF_CERT_LABEL_NOT_ALLOWED            = 3371
MQRCCF_Q_MGR_ATTR_CONFLICT               = 3372
MQRCCF_ENTITY_TYPE_MISSING               = 3373
MQRCCF_CLWL_EXIT_NAME_ERROR              = 3374
MQRCCF_SERVICE_NAME_ERROR                = 3375
MQRCCF_REMOTE_CHL_TYPE_ERROR             = 3376
MQRCCF_TOPIC_RESTRICTED                  = 3377
MQRCCF_CURRENT_LOG_EXTENT                = 3378
MQRCCF_LOG_EXTENT_NOT_FOUND              = 3379
MQRCCF_LOG_NOT_REDUCED                   = 3380
MQRCCF_LOG_EXTENT_ERROR                  = 3381
MQRCCF_ACCESS_BLOCKED                    = 3382
MQRCCF_PS_REQUIRED_MQUC                  = 3383
MQRCCF_STREAMQ_DEST_NOT_SUPP             = 3384
MQRCCF_STREAMQ_DEST_CONFLICT             = 3385
MQRCCF_STREAMQ_NOT_SUPPORTED             = 3386
MQRCCF_STREAMQ_CONFLICT                  = 3387
MQRCCF_INCOMPATIBLE_QM_IN_QSG            = 3389
MQRCCF_ATTR_VALUE_ERROR_QSG_QM           = 3390
MQRCCF_AUTHORIZED                        = 3391
MQRCCF_OBJECT_ALREADY_EXISTS             = 4001
MQRCCF_OBJECT_WRONG_TYPE                 = 4002
MQRCCF_LIKE_OBJECT_WRONG_TYPE            = 4003
MQRCCF_OBJECT_OPEN                       = 4004
MQRCCF_ATTR_VALUE_ERROR                  = 4005
MQRCCF_UNKNOWN_Q_MGR                     = 4006
MQRCCF_Q_WRONG_TYPE                      = 4007
MQRCCF_OBJECT_NAME_ERROR                 = 4008
MQRCCF_ALLOCATE_FAILED                   = 4009
MQRCCF_HOST_NOT_AVAILABLE                = 4010
MQRCCF_CONFIGURATION_ERROR               = 4011
MQRCCF_CONNECTION_REFUSED                = 4012
MQRCCF_ENTRY_ERROR                       = 4013
MQRCCF_SEND_FAILED                       = 4014
MQRCCF_RECEIVED_DATA_ERROR               = 4015
MQRCCF_RECEIVE_FAILED                    = 4016
MQRCCF_CONNECTION_CLOSED                 = 4017
MQRCCF_NO_STORAGE                        = 4018
MQRCCF_NO_COMMS_MANAGER                  = 4019
MQRCCF_LISTENER_NOT_STARTED              = 4020
MQRCCF_BIND_FAILED                       = 4024
MQRCCF_CHANNEL_INDOUBT                   = 4025
MQRCCF_MQCONN_FAILED                     = 4026
MQRCCF_MQOPEN_FAILED                     = 4027
MQRCCF_MQGET_FAILED                      = 4028
MQRCCF_MQPUT_FAILED                      = 4029
MQRCCF_PING_ERROR                        = 4030
MQRCCF_CHANNEL_IN_USE                    = 4031
MQRCCF_CHANNEL_NOT_FOUND                 = 4032
MQRCCF_UNKNOWN_REMOTE_CHANNEL            = 4033
MQRCCF_REMOTE_QM_UNAVAILABLE             = 4034
MQRCCF_REMOTE_QM_TERMINATING             = 4035
MQRCCF_MQINQ_FAILED                      = 4036
MQRCCF_NOT_XMIT_Q                        = 4037
MQRCCF_CHANNEL_DISABLED                  = 4038
MQRCCF_USER_EXIT_NOT_AVAILABLE           = 4039
MQRCCF_COMMIT_FAILED                     = 4040
MQRCCF_WRONG_CHANNEL_TYPE                = 4041
MQRCCF_CHANNEL_ALREADY_EXISTS            = 4042
MQRCCF_DATA_TOO_LARGE                    = 4043
MQRCCF_CHANNEL_NAME_ERROR                = 4044
MQRCCF_XMIT_Q_NAME_ERROR                 = 4045
MQRCCF_MCA_NAME_ERROR                    = 4047
MQRCCF_SEND_EXIT_NAME_ERROR              = 4048
MQRCCF_SEC_EXIT_NAME_ERROR               = 4049
MQRCCF_MSG_EXIT_NAME_ERROR               = 4050
MQRCCF_RCV_EXIT_NAME_ERROR               = 4051
MQRCCF_XMIT_Q_NAME_WRONG_TYPE            = 4052
MQRCCF_MCA_NAME_WRONG_TYPE               = 4053
MQRCCF_DISC_INT_WRONG_TYPE               = 4054
MQRCCF_SHORT_RETRY_WRONG_TYPE            = 4055
MQRCCF_SHORT_TIMER_WRONG_TYPE            = 4056
MQRCCF_LONG_RETRY_WRONG_TYPE             = 4057
MQRCCF_LONG_TIMER_WRONG_TYPE             = 4058
MQRCCF_PUT_AUTH_WRONG_TYPE               = 4059
MQRCCF_KEEP_ALIVE_INT_ERROR              = 4060
MQRCCF_MISSING_CONN_NAME                 = 4061
MQRCCF_CONN_NAME_ERROR                   = 4062
MQRCCF_MQSET_FAILED                      = 4063
MQRCCF_CHANNEL_NOT_ACTIVE                = 4064
MQRCCF_TERMINATED_BY_SEC_EXIT            = 4065
MQRCCF_DYNAMIC_Q_SCOPE_ERROR             = 4067
MQRCCF_CELL_DIR_NOT_AVAILABLE            = 4068
MQRCCF_MR_COUNT_ERROR                    = 4069
MQRCCF_MR_COUNT_WRONG_TYPE               = 4070
MQRCCF_MR_EXIT_NAME_ERROR                = 4071
MQRCCF_MR_EXIT_NAME_WRONG_TYPE           = 4072
MQRCCF_MR_INTERVAL_ERROR                 = 4073
MQRCCF_MR_INTERVAL_WRONG_TYPE            = 4074
MQRCCF_NPM_SPEED_ERROR                   = 4075
MQRCCF_NPM_SPEED_WRONG_TYPE              = 4076
MQRCCF_HB_INTERVAL_ERROR                 = 4077
MQRCCF_HB_INTERVAL_WRONG_TYPE            = 4078
MQRCCF_CHAD_ERROR                        = 4079
MQRCCF_CHAD_WRONG_TYPE                   = 4080
MQRCCF_CHAD_EVENT_ERROR                  = 4081
MQRCCF_CHAD_EVENT_WRONG_TYPE             = 4082
MQRCCF_CHAD_EXIT_ERROR                   = 4083
MQRCCF_CHAD_EXIT_WRONG_TYPE              = 4084
MQRCCF_SUPPRESSED_BY_EXIT                = 4085
MQRCCF_BATCH_INT_ERROR                   = 4086
MQRCCF_BATCH_INT_WRONG_TYPE              = 4087
MQRCCF_NET_PRIORITY_ERROR                = 4088
MQRCCF_NET_PRIORITY_WRONG_TYPE           = 4089
MQRCCF_CHANNEL_CLOSED                    = 4090
MQRCCF_Q_STATUS_NOT_FOUND                = 4091
MQRCCF_SSL_CIPHER_SPEC_ERROR             = 4092
MQRCCF_SSL_PEER_NAME_ERROR               = 4093
MQRCCF_SSL_CLIENT_AUTH_ERROR             = 4094
MQRCCF_RETAINED_NOT_SUPPORTED            = 4095
MQRCCF_KWD_VALUE_WRONG_TYPE              = 4096
MQRCCF_APPL_STATUS_NOT_FOUND             = 4097
MQRCCF_NHA_NOT_AVAILABLE                 = 4098
MQRCCF_Q_MGR_STATUS_NOT_FOUND            = 4099

#----------------------------------------------------------------#
# Values Related to MQCFBF Structure                             #
#----------------------------------------------------------------#

# Structure Length (Fixed Part)
MQCFBF_STRUC_LENGTH_FIXED                = 20

#----------------------------------------------------------------#
# Values Related to MQCFBS Structure                             #
#----------------------------------------------------------------#

# Structure Length (Fixed Part)
MQCFBS_STRUC_LENGTH_FIXED                = 16

#----------------------------------------------------------------#
# Values Related to MQCFGR Structure                             #
#----------------------------------------------------------------#

# Structure Length
MQCFGR_STRUC_LENGTH                      = 16

#----------------------------------------------------------------#
# Values Related to MQCFIF Structure                             #
#----------------------------------------------------------------#

# Structure Length
MQCFIF_STRUC_LENGTH                      = 20

#----------------------------------------------------------------#
# Values Related to MQCFIL Structure                             #
#----------------------------------------------------------------#

# Structure Length (Fixed Part)
MQCFIL_STRUC_LENGTH_FIXED                = 16

#----------------------------------------------------------------#
# Values Related to MQCFIL64 Structure                           #
#----------------------------------------------------------------#

# Structure Length (Fixed Part)
MQCFIL64_STRUC_LENGTH_FIXED              = 16

#----------------------------------------------------------------#
# Values Related to MQCFIN Structure                             #
#----------------------------------------------------------------#

# Structure Length
MQCFIN_STRUC_LENGTH                      = 16

#----------------------------------------------------------------#
# Values Related to MQCFIN64 Structure                           #
#----------------------------------------------------------------#

# Structure Length
MQCFIN64_STRUC_LENGTH                    = 24

#----------------------------------------------------------------#
# Values Related to MQCFSF Structure                             #
#----------------------------------------------------------------#

# Structure Length (Fixed Part)
MQCFSF_STRUC_LENGTH_FIXED                = 24

#----------------------------------------------------------------#
# Values Related to MQCFSL Structure                             #
#----------------------------------------------------------------#

# Structure Length (Fixed Part)
MQCFSL_STRUC_LENGTH_FIXED                = 24

#----------------------------------------------------------------#
# Values Related to MQCFST Structure                             #
#----------------------------------------------------------------#

# Structure Length (Fixed Part)
MQCFST_STRUC_LENGTH_FIXED                = 20

#----------------------------------------------------------------#
# Values Related to MQEPH Structure                              #
#----------------------------------------------------------------#

# Structure Identifier
MQEPH_STRUC_ID                           = b"EPH "

# Structure Identifier (array form)
MQEPH_STRUC_ID_ARRAY                     = [b"E", b"P", b"H", b" "]

# Structure Length (Fixed Part)
MQEPH_STRUC_LENGTH_FIXED                 = 68

# Structure Version Number
MQEPH_VERSION_1                          = 1
MQEPH_CURRENT_VERSION                    = 1

# Structure Length
MQEPH_LENGTH_1                           = 68
MQEPH_CURRENT_LENGTH                     = 68

# Flags
MQEPH_NONE                               = 0x00000000
MQEPH_CCSID_EMBEDDED                     = 0x00000001

#----------------------------------------------------------------#
# Values Related to All Structures                               #
#----------------------------------------------------------------#
# String Lengths
MQ_ARCHIVE_PFX_LENGTH                    = 36
MQ_ARCHIVE_UNIT_LENGTH                   = 8
MQ_ASID_LENGTH                           = 4
MQ_AUTH_PROFILE_NAME_LENGTH              = 48
MQ_CF_LEID_LENGTH                        = 12
MQ_COMMAND_MQSC_LENGTH                   = 32768
MQ_DATA_SET_NAME_LENGTH                  = 44
MQ_DB2_NAME_LENGTH                       = 4
MQ_DSG_NAME_LENGTH                       = 8
MQ_ENTITY_NAME_LENGTH                    = 1024
MQ_ENV_INFO_LENGTH                       = 96
MQ_GROUP_ADDRESS_LENGTH                  = 264
MQ_HOST_NAME_LENGTH                      = 256
MQ_IP_ADDRESS_LENGTH                     = 48
MQ_LOG_CORREL_ID_LENGTH                  = 8
MQ_LOG_EXTENT_NAME_LENGTH                = 24
MQ_LOG_PATH_LENGTH                       = 1024
MQ_LRSN_LENGTH                           = 12
MQ_LSN_LENGTH                            = 64
MQ_NHA_REPL_ADDRESS_LENGTH               = 264
MQ_ORIGIN_NAME_LENGTH                    = 8
MQ_PSB_NAME_LENGTH                       = 8
MQ_PST_ID_LENGTH                         = 8
MQ_Q_MGR_CPF_LENGTH                      = 4
MQ_Q_MGR_DATA_PATH_LENGTH                = 1024
MQ_RESPONSE_ID_LENGTH                    = 24
MQ_RBA_LENGTH                            = 16
MQ_REMOTE_PRODUCT_LENGTH                 = 4
MQ_REMOTE_VERSION_LENGTH                 = 8
MQ_SECURITY_PROFILE_LENGTH               = 40
MQ_SERVICE_COMPONENT_LENGTH              = 48
MQ_SUB_NAME_LENGTH                       = 10240
MQ_SYSP_SERVICE_LENGTH                   = 32
MQ_SYSTEM_NAME_LENGTH                    = 8
MQ_TASK_NUMBER_LENGTH                    = 8
MQ_TPIPE_PFX_LENGTH                      = 4
MQ_UOW_ID_LENGTH                         = 256
MQ_USER_DATA_LENGTH                      = 10240
MQ_VOLSER_LENGTH                         = 6

# Filter Operators
MQCFOP_LESS                              = 1
MQCFOP_EQUAL                             = 2
MQCFOP_GREATER                           = 4
MQCFOP_NOT_LESS                          = 6
MQCFOP_NOT_EQUAL                         = 5
MQCFOP_NOT_GREATER                       = 3
MQCFOP_LIKE                              = 18
MQCFOP_NOT_LIKE                          = 21
MQCFOP_CONTAINS                          = 10
MQCFOP_EXCLUDES                          = 13
MQCFOP_CONTAINS_GEN                      = 26
MQCFOP_EXCLUDES_GEN                      = 29

# Types of Structure
MQCFT_NONE                               = 0
MQCFT_COMMAND                            = 1
MQCFT_RESPONSE                           = 2
MQCFT_INTEGER                            = 3
MQCFT_STRING                             = 4
MQCFT_INTEGER_LIST                       = 5
MQCFT_STRING_LIST                        = 6
MQCFT_EVENT                              = 7
MQCFT_USER                               = 8
MQCFT_BYTE_STRING                        = 9
MQCFT_TRACE_ROUTE                        = 10
MQCFT_REPORT                             = 12
MQCFT_INTEGER_FILTER                     = 13
MQCFT_STRING_FILTER                      = 14
MQCFT_BYTE_STRING_FILTER                 = 15
MQCFT_COMMAND_XR                         = 16
MQCFT_XR_MSG                             = 17
MQCFT_XR_ITEM                            = 18
MQCFT_XR_SUMMARY                         = 19
MQCFT_GROUP                              = 20
MQCFT_STATISTICS                         = 21
MQCFT_ACCOUNTING                         = 22
MQCFT_INTEGER64                          = 23
MQCFT_INTEGER64_LIST                     = 25
MQCFT_APP_ACTIVITY                       = 26
MQCFT_STATUS                             = 27

# Major Release Function
MQOPMODE_COMPAT                          = 0
MQOPMODE_NEW_FUNCTION                    = 1

#----------------------------------------------------------------#
# Values Related to Byte Parameter Structures                    #
#----------------------------------------------------------------#
# Byte Parameter Types
MQBACF_FIRST                             = 7001
MQBACF_EVENT_ACCOUNTING_TOKEN            = 7001
MQBACF_EVENT_SECURITY_ID                 = 7002
MQBACF_RESPONSE_SET                      = 7003
MQBACF_RESPONSE_ID                       = 7004
MQBACF_EXTERNAL_UOW_ID                   = 7005
MQBACF_CONNECTION_ID                     = 7006
MQBACF_GENERIC_CONNECTION_ID             = 7007
MQBACF_ORIGIN_UOW_ID                     = 7008
MQBACF_Q_MGR_UOW_ID                      = 7009
MQBACF_ACCOUNTING_TOKEN                  = 7010
MQBACF_CORREL_ID                         = 7011
MQBACF_GROUP_ID                          = 7012
MQBACF_MSG_ID                            = 7013
MQBACF_CF_LEID                           = 7014
MQBACF_DESTINATION_CORREL_ID             = 7015
MQBACF_SUB_ID                            = 7016
MQBACF_ALTERNATE_SECURITYID              = 7019
MQBACF_MESSAGE_DATA                      = 7020
MQBACF_MQBO_STRUCT                       = 7021
MQBACF_MQCB_FUNCTION                     = 7022
MQBACF_MQCBC_STRUCT                      = 7023
MQBACF_MQCBD_STRUCT                      = 7024
MQBACF_MQCD_STRUCT                       = 7025
MQBACF_MQCNO_STRUCT                      = 7026
MQBACF_MQGMO_STRUCT                      = 7027
MQBACF_MQMD_STRUCT                       = 7028
MQBACF_MQPMO_STRUCT                      = 7029
MQBACF_MQSD_STRUCT                       = 7030
MQBACF_MQSTS_STRUCT                      = 7031
MQBACF_SUB_CORREL_ID                     = 7032
MQBACF_XA_XID                            = 7033
MQBACF_XQH_CORREL_ID                     = 7034
MQBACF_XQH_MSG_ID                        = 7035
MQBACF_REQUEST_ID                        = 7036
MQBACF_PROPERTIES_DATA                   = 7037
MQBACF_CONN_TAG                          = 7038
MQBACF_MQBNO_STRUCT                      = 7039
MQBACF_LAST_USED                         = 7039

#----------------------------------------------------------------#
# Values Related to Integer Parameter Structures                 #
#----------------------------------------------------------------#
# Integer Monitoring Parameter Types
MQIAMO_FIRST                             = 701
MQIAMO_AVG_BATCH_SIZE                    = 702
MQIAMO_AVG_Q_TIME                        = 703
MQIAMO64_AVG_Q_TIME                      = 703
MQIAMO_BACKOUTS                          = 704
MQIAMO_BROWSES                           = 705
MQIAMO_BROWSE_MAX_BYTES                  = 706
MQIAMO_BROWSE_MIN_BYTES                  = 707
MQIAMO_BROWSES_FAILED                    = 708
MQIAMO_CLOSES                            = 709
MQIAMO_COMMITS                           = 710
MQIAMO_COMMITS_FAILED                    = 711
MQIAMO_CONNS                             = 712
MQIAMO_CONNS_MAX                         = 713
MQIAMO_DISCS                             = 714
MQIAMO_DISCS_IMPLICIT                    = 715
MQIAMO_DISC_TYPE                         = 716
MQIAMO_EXIT_TIME_AVG                     = 717
MQIAMO_EXIT_TIME_MAX                     = 718
MQIAMO_EXIT_TIME_MIN                     = 719
MQIAMO_FULL_BATCHES                      = 720
MQIAMO_GENERATED_MSGS                    = 721
MQIAMO_GETS                              = 722
MQIAMO_GET_MAX_BYTES                     = 723
MQIAMO_GET_MIN_BYTES                     = 724
MQIAMO_GETS_FAILED                       = 725
MQIAMO_INCOMPLETE_BATCHES                = 726
MQIAMO_INQS                              = 727
MQIAMO_MSGS                              = 728
MQIAMO_NET_TIME_AVG                      = 729
MQIAMO_NET_TIME_MAX                      = 730
MQIAMO_NET_TIME_MIN                      = 731
MQIAMO_OBJECT_COUNT                      = 732
MQIAMO_OPENS                             = 733
MQIAMO_PUT1S                             = 734
MQIAMO_PUTS                              = 735
MQIAMO_PUT_MAX_BYTES                     = 736
MQIAMO_PUT_MIN_BYTES                     = 737
MQIAMO_PUT_RETRIES                       = 738
MQIAMO_Q_MAX_DEPTH                       = 739
MQIAMO_Q_MIN_DEPTH                       = 740
MQIAMO_Q_TIME_AVG                        = 741
MQIAMO64_Q_TIME_AVG                      = 741
MQIAMO_Q_TIME_MAX                        = 742
MQIAMO64_Q_TIME_MAX                      = 742
MQIAMO_Q_TIME_MIN                        = 743
MQIAMO64_Q_TIME_MIN                      = 743
MQIAMO_SETS                              = 744
MQIAMO64_BROWSE_BYTES                    = 745
MQIAMO64_BYTES                           = 746
MQIAMO64_GET_BYTES                       = 747
MQIAMO64_PUT_BYTES                       = 748
MQIAMO_CONNS_FAILED                      = 749
MQIAMO_OPENS_FAILED                      = 751
MQIAMO_INQS_FAILED                       = 752
MQIAMO_SETS_FAILED                       = 753
MQIAMO_PUTS_FAILED                       = 754
MQIAMO_PUT1S_FAILED                      = 755
MQIAMO_CLOSES_FAILED                     = 757
MQIAMO_MSGS_EXPIRED                      = 758
MQIAMO_MSGS_NOT_QUEUED                   = 759
MQIAMO_MSGS_PURGED                       = 760
MQIAMO_SUBS_DUR                          = 764
MQIAMO_SUBS_NDUR                         = 765
MQIAMO_SUBS_FAILED                       = 766
MQIAMO_SUBRQS                            = 767
MQIAMO_SUBRQS_FAILED                     = 768
MQIAMO_CBS                               = 769
MQIAMO_CBS_FAILED                        = 770
MQIAMO_CTLS                              = 771
MQIAMO_CTLS_FAILED                       = 772
MQIAMO_STATS                             = 773
MQIAMO_STATS_FAILED                      = 774
MQIAMO_SUB_DUR_HIGHWATER                 = 775
MQIAMO_SUB_DUR_LOWWATER                  = 776
MQIAMO_SUB_NDUR_HIGHWATER                = 777
MQIAMO_SUB_NDUR_LOWWATER                 = 778
MQIAMO_TOPIC_PUTS                        = 779
MQIAMO_TOPIC_PUTS_FAILED                 = 780
MQIAMO_TOPIC_PUT1S                       = 781
MQIAMO_TOPIC_PUT1S_FAILED                = 782
MQIAMO64_TOPIC_PUT_BYTES                 = 783
MQIAMO_PUBLISH_MSG_COUNT                 = 784
MQIAMO64_PUBLISH_MSG_BYTES               = 785
MQIAMO_UNSUBS_DUR                        = 786
MQIAMO_UNSUBS_NDUR                       = 787
MQIAMO_UNSUBS_FAILED                     = 788
MQIAMO_INTERVAL                          = 789
MQIAMO_MSGS_SENT                         = 790
MQIAMO_BYTES_SENT                        = 791
MQIAMO_REPAIR_BYTES                      = 792
MQIAMO_FEEDBACK_MODE                     = 793
MQIAMO_RELIABILITY_TYPE                  = 794
MQIAMO_LATE_JOIN_MARK                    = 795
MQIAMO_NACKS_RCVD                        = 796
MQIAMO_REPAIR_PKTS                       = 797
MQIAMO_HISTORY_PKTS                      = 798
MQIAMO_PENDING_PKTS                      = 799
MQIAMO_PKT_RATE                          = 800
MQIAMO_MCAST_XMIT_RATE                   = 801
MQIAMO_MCAST_BATCH_TIME                  = 802
MQIAMO_MCAST_HEARTBEAT                   = 803
MQIAMO_DEST_DATA_PORT                    = 804
MQIAMO_DEST_REPAIR_PORT                  = 805
MQIAMO_ACKS_RCVD                         = 806
MQIAMO_ACTIVE_ACKERS                     = 807
MQIAMO_PKTS_SENT                         = 808
MQIAMO_TOTAL_REPAIR_PKTS                 = 809
MQIAMO_TOTAL_PKTS_SENT                   = 810
MQIAMO_TOTAL_MSGS_SENT                   = 811
MQIAMO_TOTAL_BYTES_SENT                  = 812
MQIAMO_NUM_STREAMS                       = 813
MQIAMO_ACK_FEEDBACK                      = 814
MQIAMO_NACK_FEEDBACK                     = 815
MQIAMO_PKTS_LOST                         = 816
MQIAMO_MSGS_RCVD                         = 817
MQIAMO_MSG_BYTES_RCVD                    = 818
MQIAMO_MSGS_DELIVERED                    = 819
MQIAMO_PKTS_PROCESSED                    = 820
MQIAMO_PKTS_DELIVERED                    = 821
MQIAMO_PKTS_DROPPED                      = 822
MQIAMO_PKTS_DUPLICATED                   = 823
MQIAMO_NACKS_CREATED                     = 824
MQIAMO_NACK_PKTS_SENT                    = 825
MQIAMO_REPAIR_PKTS_RQSTD                 = 826
MQIAMO_REPAIR_PKTS_RCVD                  = 827
MQIAMO_PKTS_REPAIRED                     = 828
MQIAMO_TOTAL_MSGS_RCVD                   = 829
MQIAMO_TOTAL_MSG_BYTES_RCVD              = 830
MQIAMO_TOTAL_REPAIR_PKTS_RCVD            = 831
MQIAMO_TOTAL_REPAIR_PKTS_RQSTD           = 832
MQIAMO_TOTAL_MSGS_PROCESSED              = 833
MQIAMO_TOTAL_MSGS_SELECTED               = 834
MQIAMO_TOTAL_MSGS_EXPIRED                = 835
MQIAMO_TOTAL_MSGS_DELIVERED              = 836
MQIAMO_TOTAL_MSGS_RETURNED               = 837
MQIAMO64_HIGHRES_TIME                    = 838
MQIAMO_MONITOR_CLASS                     = 839
MQIAMO_MONITOR_TYPE                      = 840
MQIAMO_MONITOR_ELEMENT                   = 841
MQIAMO_MONITOR_DATATYPE                  = 842
MQIAMO_MONITOR_FLAGS                     = 843
MQIAMO64_QMGR_OP_DURATION                = 844
MQIAMO64_MONITOR_INTERVAL                = 845
MQIAMO_LAST_USED                         = 845

# Defined values for MQIAMO_MONITOR_FLAGS
MQIAMO_MONITOR_FLAGS_NONE                = 0
MQIAMO_MONITOR_FLAGS_OBJNAME             = 1

# Defined values for MQIAMO_MONITOR_DATATYPE
MQIAMO_MONITOR_UNIT                      = 1
MQIAMO_MONITOR_DELTA                     = 2
MQIAMO_MONITOR_LSN                       = 3
MQIAMO_MONITOR_HUNDREDTHS                = 100
MQIAMO_MONITOR_KB                        = 1024
MQIAMO_MONITOR_PERCENT                   = 10000
MQIAMO_MONITOR_MICROSEC                  = 1000000
MQIAMO_MONITOR_MB                        = 1048576
MQIAMO_MONITOR_GB                        = 100000000

# Integer Parameter Types
MQIACF_FIRST                             = 1001
MQIACF_Q_MGR_ATTRS                       = 1001
MQIACF_Q_ATTRS                           = 1002
MQIACF_PROCESS_ATTRS                     = 1003
MQIACF_NAMELIST_ATTRS                    = 1004
MQIACF_FORCE                             = 1005
MQIACF_REPLACE                           = 1006
MQIACF_PURGE                             = 1007
MQIACF_QUIESCE                           = 1008
MQIACF_MODE                              = 1008
MQIACF_ALL                               = 1009
MQIACF_EVENT_APPL_TYPE                   = 1010
MQIACF_EVENT_ORIGIN                      = 1011
MQIACF_PARAMETER_ID                      = 1012
MQIACF_ERROR_ID                          = 1013
MQIACF_ERROR_IDENTIFIER                  = 1013
MQIACF_SELECTOR                          = 1014
MQIACF_CHANNEL_ATTRS                     = 1015
MQIACF_OBJECT_TYPE                       = 1016
MQIACF_ESCAPE_TYPE                       = 1017
MQIACF_ERROR_OFFSET                      = 1018
MQIACF_AUTH_INFO_ATTRS                   = 1019
MQIACF_REASON_QUALIFIER                  = 1020
MQIACF_COMMAND                           = 1021
MQIACF_OPEN_OPTIONS                      = 1022
MQIACF_OPEN_TYPE                         = 1023
MQIACF_PROCESS_ID                        = 1024
MQIACF_THREAD_ID                         = 1025
MQIACF_Q_STATUS_ATTRS                    = 1026
MQIACF_UNCOMMITTED_MSGS                  = 1027
MQIACF_HANDLE_STATE                      = 1028
MQIACF_AUX_ERROR_DATA_INT_1              = 1070
MQIACF_AUX_ERROR_DATA_INT_2              = 1071
MQIACF_CONV_REASON_CODE                  = 1072
MQIACF_BRIDGE_TYPE                       = 1073
MQIACF_INQUIRY                           = 1074
MQIACF_WAIT_INTERVAL                     = 1075
MQIACF_OPTIONS                           = 1076
MQIACF_BROKER_OPTIONS                    = 1077
MQIACF_REFRESH_TYPE                      = 1078
MQIACF_SEQUENCE_NUMBER                   = 1079
MQIACF_INTEGER_DATA                      = 1080
MQIACF_REGISTRATION_OPTIONS              = 1081
MQIACF_PUBLICATION_OPTIONS               = 1082
MQIACF_CLUSTER_INFO                      = 1083
MQIACF_Q_MGR_DEFINITION_TYPE             = 1084
MQIACF_Q_MGR_TYPE                        = 1085
MQIACF_ACTION                            = 1086
MQIACF_SUSPEND                           = 1087
MQIACF_BROKER_COUNT                      = 1088
MQIACF_APPL_COUNT                        = 1089
MQIACF_ANONYMOUS_COUNT                   = 1090
MQIACF_REG_REG_OPTIONS                   = 1091
MQIACF_DELETE_OPTIONS                    = 1092
MQIACF_CLUSTER_Q_MGR_ATTRS               = 1093
MQIACF_REFRESH_INTERVAL                  = 1094
MQIACF_REFRESH_REPOSITORY                = 1095
MQIACF_REMOVE_QUEUES                     = 1096
MQIACF_OPEN_INPUT_TYPE                   = 1098
MQIACF_OPEN_OUTPUT                       = 1099
MQIACF_OPEN_SET                          = 1100
MQIACF_OPEN_INQUIRE                      = 1101
MQIACF_OPEN_BROWSE                       = 1102
MQIACF_Q_STATUS_TYPE                     = 1103
MQIACF_Q_HANDLE                          = 1104
MQIACF_Q_STATUS                          = 1105
MQIACF_SECURITY_TYPE                     = 1106
MQIACF_CONNECTION_ATTRS                  = 1107
MQIACF_CONNECT_OPTIONS                   = 1108
MQIACF_CONN_INFO_TYPE                    = 1110
MQIACF_CONN_INFO_CONN                    = 1111
MQIACF_CONN_INFO_HANDLE                  = 1112
MQIACF_CONN_INFO_ALL                     = 1113
MQIACF_AUTH_PROFILE_ATTRS                = 1114
MQIACF_AUTHORIZATION_LIST                = 1115
MQIACF_AUTH_ADD_AUTHS                    = 1116
MQIACF_AUTH_REMOVE_AUTHS                 = 1117
MQIACF_ENTITY_TYPE                       = 1118
MQIACF_COMMAND_INFO                      = 1120
MQIACF_CMDSCOPE_Q_MGR_COUNT              = 1121
MQIACF_Q_MGR_SYSTEM                      = 1122
MQIACF_Q_MGR_EVENT                       = 1123
MQIACF_Q_MGR_DQM                         = 1124
MQIACF_Q_MGR_CLUSTER                     = 1125
MQIACF_QSG_DISPS                         = 1126
MQIACF_UOW_STATE                         = 1128
MQIACF_SECURITY_ITEM                     = 1129
MQIACF_CF_STRUC_STATUS                   = 1130
MQIACF_UOW_TYPE                          = 1132
MQIACF_CF_STRUC_ATTRS                    = 1133
MQIACF_EXCLUDE_INTERVAL                  = 1134
MQIACF_CF_STATUS_TYPE                    = 1135
MQIACF_CF_STATUS_SUMMARY                 = 1136
MQIACF_CF_STATUS_CONNECT                 = 1137
MQIACF_CF_STATUS_BACKUP                  = 1138
MQIACF_CF_STRUC_TYPE                     = 1139
MQIACF_CF_STRUC_SIZE_MAX                 = 1140
MQIACF_CF_STRUC_SIZE_USED                = 1141
MQIACF_CF_STRUC_ENTRIES_MAX              = 1142
MQIACF_CF_STRUC_ENTRIES_USED             = 1143
MQIACF_CF_STRUC_BACKUP_SIZE              = 1144
MQIACF_MOVE_TYPE                         = 1145
MQIACF_MOVE_TYPE_MOVE                    = 1146
MQIACF_MOVE_TYPE_ADD                     = 1147
MQIACF_Q_MGR_NUMBER                      = 1148
MQIACF_Q_MGR_STATUS                      = 1149
MQIACF_DB2_CONN_STATUS                   = 1150
MQIACF_SECURITY_ATTRS                    = 1151
MQIACF_SECURITY_TIMEOUT                  = 1152
MQIACF_SECURITY_INTERVAL                 = 1153
MQIACF_SECURITY_SWITCH                   = 1154
MQIACF_SECURITY_SETTING                  = 1155
MQIACF_STORAGE_CLASS_ATTRS               = 1156
MQIACF_USAGE_TYPE                        = 1157
MQIACF_BUFFER_POOL_ID                    = 1158
MQIACF_USAGE_TOTAL_PAGES                 = 1159
MQIACF_USAGE_UNUSED_PAGES                = 1160
MQIACF_USAGE_PERSIST_PAGES               = 1161
MQIACF_USAGE_NONPERSIST_PAGES            = 1162
MQIACF_USAGE_RESTART_EXTENTS             = 1163
MQIACF_USAGE_EXPAND_COUNT                = 1164
MQIACF_PAGESET_STATUS                    = 1165
MQIACF_USAGE_TOTAL_BUFFERS               = 1166
MQIACF_USAGE_DATA_SET_TYPE               = 1167
MQIACF_USAGE_PAGESET                     = 1168
MQIACF_USAGE_DATA_SET                    = 1169
MQIACF_USAGE_BUFFER_POOL                 = 1170
MQIACF_MOVE_COUNT                        = 1171
MQIACF_EXPIRY_Q_COUNT                    = 1172
MQIACF_CONFIGURATION_OBJECTS             = 1173
MQIACF_CONFIGURATION_EVENTS              = 1174
MQIACF_SYSP_TYPE                         = 1175
MQIACF_SYSP_DEALLOC_INTERVAL             = 1176
MQIACF_SYSP_MAX_ARCHIVE                  = 1177
MQIACF_SYSP_MAX_READ_TAPES               = 1178
MQIACF_SYSP_IN_BUFFER_SIZE               = 1179
MQIACF_SYSP_OUT_BUFFER_SIZE              = 1180
MQIACF_SYSP_OUT_BUFFER_COUNT             = 1181
MQIACF_SYSP_ARCHIVE                      = 1182
MQIACF_SYSP_DUAL_ACTIVE                  = 1183
MQIACF_SYSP_DUAL_ARCHIVE                 = 1184
MQIACF_SYSP_DUAL_BSDS                    = 1185
MQIACF_SYSP_MAX_CONNS                    = 1186
MQIACF_SYSP_MAX_CONNS_FORE               = 1187
MQIACF_SYSP_MAX_CONNS_BACK               = 1188
MQIACF_SYSP_EXIT_INTERVAL                = 1189
MQIACF_SYSP_EXIT_TASKS                   = 1190
MQIACF_SYSP_CHKPOINT_COUNT               = 1191
MQIACF_SYSP_OTMA_INTERVAL                = 1192
MQIACF_SYSP_Q_INDEX_DEFER                = 1193
MQIACF_SYSP_DB2_TASKS                    = 1194
MQIACF_SYSP_RESLEVEL_AUDIT               = 1195
MQIACF_SYSP_ROUTING_CODE                 = 1196
MQIACF_SYSP_SMF_ACCOUNTING               = 1197
MQIACF_SYSP_SMF_STATS                    = 1198
MQIACF_SYSP_SMF_INTERVAL                 = 1199
MQIACF_SYSP_SMF_STAT_TIME_MINS           = 1199
MQIACF_SYSP_TRACE_CLASS                  = 1200
MQIACF_SYSP_TRACE_SIZE                   = 1201
MQIACF_SYSP_WLM_INTERVAL                 = 1202
MQIACF_SYSP_ALLOC_UNIT                   = 1203
MQIACF_SYSP_ARCHIVE_RETAIN               = 1204
MQIACF_SYSP_ARCHIVE_WTOR                 = 1205
MQIACF_SYSP_BLOCK_SIZE                   = 1206
MQIACF_SYSP_CATALOG                      = 1207
MQIACF_SYSP_COMPACT                      = 1208
MQIACF_SYSP_ALLOC_PRIMARY                = 1209
MQIACF_SYSP_ALLOC_SECONDARY              = 1210
MQIACF_SYSP_PROTECT                      = 1211
MQIACF_SYSP_QUIESCE_INTERVAL             = 1212
MQIACF_SYSP_TIMESTAMP                    = 1213
MQIACF_SYSP_UNIT_ADDRESS                 = 1214
MQIACF_SYSP_UNIT_STATUS                  = 1215
MQIACF_SYSP_LOG_COPY                     = 1216
MQIACF_SYSP_LOG_USED                     = 1217
MQIACF_SYSP_LOG_SUSPEND                  = 1218
MQIACF_SYSP_OFFLOAD_STATUS               = 1219
MQIACF_SYSP_TOTAL_LOGS                   = 1220
MQIACF_SYSP_FULL_LOGS                    = 1221
MQIACF_LISTENER_ATTRS                    = 1222
MQIACF_LISTENER_STATUS_ATTRS             = 1223
MQIACF_SERVICE_ATTRS                     = 1224
MQIACF_SERVICE_STATUS_ATTRS              = 1225
MQIACF_Q_TIME_INDICATOR                  = 1226
MQIACF_OLDEST_MSG_AGE                    = 1227
MQIACF_AUTH_OPTIONS                      = 1228
MQIACF_Q_MGR_STATUS_ATTRS                = 1229
MQIACF_CONNECTION_COUNT                  = 1230
MQIACF_Q_MGR_FACILITY                    = 1231
MQIACF_CHINIT_STATUS                     = 1232
MQIACF_CMD_SERVER_STATUS                 = 1233
MQIACF_ROUTE_DETAIL                      = 1234
MQIACF_RECORDED_ACTIVITIES               = 1235
MQIACF_MAX_ACTIVITIES                    = 1236
MQIACF_DISCONTINUITY_COUNT               = 1237
MQIACF_ROUTE_ACCUMULATION                = 1238
MQIACF_ROUTE_DELIVERY                    = 1239
MQIACF_OPERATION_TYPE                    = 1240
MQIACF_BACKOUT_COUNT                     = 1241
MQIACF_COMP_CODE                         = 1242
MQIACF_ENCODING                          = 1243
MQIACF_EXPIRY                            = 1244
MQIACF_FEEDBACK                          = 1245
MQIACF_MSG_FLAGS                         = 1247
MQIACF_MSG_LENGTH                        = 1248
MQIACF_MSG_TYPE                          = 1249
MQIACF_OFFSET                            = 1250
MQIACF_ORIGINAL_LENGTH                   = 1251
MQIACF_PERSISTENCE                       = 1252
MQIACF_PRIORITY                          = 1253
MQIACF_REASON_CODE                       = 1254
MQIACF_REPORT                            = 1255
MQIACF_VERSION                           = 1256
MQIACF_UNRECORDED_ACTIVITIES             = 1257
MQIACF_MONITORING                        = 1258
MQIACF_ROUTE_FORWARDING                  = 1259
MQIACF_SERVICE_STATUS                    = 1260
MQIACF_Q_TYPES                           = 1261
MQIACF_USER_ID_SUPPORT                   = 1262
MQIACF_INTERFACE_VERSION                 = 1263
MQIACF_AUTH_SERVICE_ATTRS                = 1264
MQIACF_USAGE_EXPAND_TYPE                 = 1265
MQIACF_SYSP_CLUSTER_CACHE                = 1266
MQIACF_SYSP_DB2_BLOB_TASKS               = 1267
MQIACF_SYSP_WLM_INT_UNITS                = 1268
MQIACF_TOPIC_ATTRS                       = 1269
MQIACF_PUBSUB_PROPERTIES                 = 1271
MQIACF_DESTINATION_CLASS                 = 1273
MQIACF_DURABLE_SUBSCRIPTION              = 1274
MQIACF_SUBSCRIPTION_SCOPE                = 1275
MQIACF_VARIABLE_USER_ID                  = 1277
MQIACF_REQUEST_ONLY                      = 1280
MQIACF_PUB_PRIORITY                      = 1283
MQIACF_SUB_ATTRS                         = 1287
MQIACF_WILDCARD_SCHEMA                   = 1288
MQIACF_SUB_TYPE                          = 1289
MQIACF_MESSAGE_COUNT                     = 1290
MQIACF_Q_MGR_PUBSUB                      = 1291
MQIACF_Q_MGR_VERSION                     = 1292
MQIACF_SUB_STATUS_ATTRS                  = 1294
MQIACF_TOPIC_STATUS                      = 1295
MQIACF_TOPIC_SUB                         = 1296
MQIACF_TOPIC_PUB                         = 1297
MQIACF_RETAINED_PUBLICATION              = 1300
MQIACF_TOPIC_STATUS_ATTRS                = 1301
MQIACF_TOPIC_STATUS_TYPE                 = 1302
MQIACF_SUB_OPTIONS                       = 1303
MQIACF_PUBLISH_COUNT                     = 1304
MQIACF_CLEAR_TYPE                        = 1305
MQIACF_CLEAR_SCOPE                       = 1306
MQIACF_SUB_LEVEL                         = 1307
MQIACF_ASYNC_STATE                       = 1308
MQIACF_SUB_SUMMARY                       = 1309
MQIACF_OBSOLETE_MSGS                     = 1310
MQIACF_PUBSUB_STATUS                     = 1311
MQIACF_PS_STATUS_TYPE                    = 1314
MQIACF_PUBSUB_STATUS_ATTRS               = 1318
MQIACF_SELECTOR_TYPE                     = 1321
MQIACF_LOG_COMPRESSION                   = 1322
MQIACF_GROUPUR_CHECK_ID                  = 1323
MQIACF_MULC_CAPTURE                      = 1324
MQIACF_PERMIT_STANDBY                    = 1325
MQIACF_OPERATION_MODE                    = 1326
MQIACF_COMM_INFO_ATTRS                   = 1327
MQIACF_CF_SMDS_BLOCK_SIZE                = 1328
MQIACF_CF_SMDS_EXPAND                    = 1329
MQIACF_USAGE_FREE_BUFF                   = 1330
MQIACF_USAGE_FREE_BUFF_PERC              = 1331
MQIACF_CF_STRUC_ACCESS                   = 1332
MQIACF_CF_STATUS_SMDS                    = 1333
MQIACF_SMDS_ATTRS                        = 1334
MQIACF_USAGE_SMDS                        = 1335
MQIACF_USAGE_BLOCK_SIZE                  = 1336
MQIACF_USAGE_DATA_BLOCKS                 = 1337
MQIACF_USAGE_EMPTY_BUFFERS               = 1338
MQIACF_USAGE_INUSE_BUFFERS               = 1339
MQIACF_USAGE_LOWEST_FREE                 = 1340
MQIACF_USAGE_OFFLOAD_MSGS                = 1341
MQIACF_USAGE_READS_SAVED                 = 1342
MQIACF_USAGE_SAVED_BUFFERS               = 1343
MQIACF_USAGE_TOTAL_BLOCKS                = 1344
MQIACF_USAGE_USED_BLOCKS                 = 1345
MQIACF_USAGE_USED_RATE                   = 1346
MQIACF_USAGE_WAIT_RATE                   = 1347
MQIACF_SMDS_OPENMODE                     = 1348
MQIACF_SMDS_STATUS                       = 1349
MQIACF_SMDS_AVAIL                        = 1350
MQIACF_MCAST_REL_INDICATOR               = 1351
MQIACF_CHLAUTH_TYPE                      = 1352
MQIACF_MQXR_DIAGNOSTICS_TYPE             = 1354
MQIACF_CHLAUTH_ATTRS                     = 1355
MQIACF_OPERATION_ID                      = 1356
MQIACF_API_CALLER_TYPE                   = 1357
MQIACF_API_ENVIRONMENT                   = 1358
MQIACF_TRACE_DETAIL                      = 1359
MQIACF_HOBJ                              = 1360
MQIACF_CALL_TYPE                         = 1361
MQIACF_MQCB_OPERATION                    = 1362
MQIACF_MQCB_TYPE                         = 1363
MQIACF_MQCB_OPTIONS                      = 1364
MQIACF_CLOSE_OPTIONS                     = 1365
MQIACF_CTL_OPERATION                     = 1366
MQIACF_GET_OPTIONS                       = 1367
MQIACF_RECS_PRESENT                      = 1368
MQIACF_KNOWN_DEST_COUNT                  = 1369
MQIACF_UNKNOWN_DEST_COUNT                = 1370
MQIACF_INVALID_DEST_COUNT                = 1371
MQIACF_RESOLVED_TYPE                     = 1372
MQIACF_PUT_OPTIONS                       = 1373
MQIACF_BUFFER_LENGTH                     = 1374
MQIACF_TRACE_DATA_LENGTH                 = 1375
MQIACF_SMDS_EXPANDST                     = 1376
MQIACF_STRUC_LENGTH                      = 1377
MQIACF_ITEM_COUNT                        = 1378
MQIACF_EXPIRY_TIME                       = 1379
MQIACF_CONNECT_TIME                      = 1380
MQIACF_DISCONNECT_TIME                   = 1381
MQIACF_HSUB                              = 1382
MQIACF_SUBRQ_OPTIONS                     = 1383
MQIACF_XA_RMID                           = 1384
MQIACF_XA_FLAGS                          = 1385
MQIACF_XA_RETCODE                        = 1386
MQIACF_XA_HANDLE                         = 1387
MQIACF_XA_RETVAL                         = 1388
MQIACF_STATUS_TYPE                       = 1389
MQIACF_XA_COUNT                          = 1390
MQIACF_SELECTOR_COUNT                    = 1391
MQIACF_SELECTORS                         = 1392
MQIACF_INTATTR_COUNT                     = 1393
MQIACF_INT_ATTRS                         = 1394
MQIACF_SUBRQ_ACTION                      = 1395
MQIACF_NUM_PUBS                          = 1396
MQIACF_POINTER_SIZE                      = 1397
MQIACF_REMOVE_AUTHREC                    = 1398
MQIACF_XR_ATTRS                          = 1399
MQIACF_APPL_FUNCTION_TYPE                = 1400
MQIACF_AMQP_ATTRS                        = 1401
MQIACF_EXPORT_TYPE                       = 1402
MQIACF_EXPORT_ATTRS                      = 1403
MQIACF_SYSTEM_OBJECTS                    = 1404
MQIACF_CONNECTION_SWAP                   = 1405
MQIACF_AMQP_DIAGNOSTICS_TYPE             = 1406
MQIACF_BUFFER_POOL_LOCATION              = 1408
MQIACF_LDAP_CONNECTION_STATUS            = 1409
MQIACF_SYSP_MAX_ACE_POOL                 = 1410
MQIACF_PAGECLAS                          = 1411
MQIACF_AUTH_REC_TYPE                     = 1412
MQIACF_SYSP_MAX_CONC_OFFLOADS            = 1413
MQIACF_SYSP_ZHYPERWRITE                  = 1414
MQIACF_Q_MGR_STATUS_LOG                  = 1415
MQIACF_ARCHIVE_LOG_SIZE                  = 1416
MQIACF_MEDIA_LOG_SIZE                    = 1417
MQIACF_RESTART_LOG_SIZE                  = 1418
MQIACF_REUSABLE_LOG_SIZE                 = 1419
MQIACF_LOG_IN_USE                        = 1420
MQIACF_LOG_UTILIZATION                   = 1421
MQIACF_LOG_REDUCTION                     = 1422
MQIACF_IGNORE_STATE                      = 1423
MQIACF_MOVABLE_APPL_COUNT                = 1424
MQIACF_APPL_INFO_ATTRS                   = 1425
MQIACF_APPL_MOVABLE                      = 1426
MQIACF_REMOTE_QMGR_ACTIVE                = 1427
MQIACF_APPL_INFO_TYPE                    = 1428
MQIACF_APPL_INFO_APPL                    = 1429
MQIACF_APPL_INFO_QMGR                    = 1430
MQIACF_APPL_INFO_LOCAL                   = 1431
MQIACF_APPL_IMMOVABLE_COUNT              = 1432
MQIACF_BALANCED                          = 1433
MQIACF_BALSTATE                          = 1434
MQIACF_APPL_IMMOVABLE_REASON             = 1435
MQIACF_DS_ENCRYPTED                      = 1436
MQIACF_CUR_Q_FILE_SIZE                   = 1437
MQIACF_CUR_MAX_FILE_SIZE                 = 1438
MQIACF_BALANCING_TYPE                    = 1439
MQIACF_BALANCING_OPTIONS                 = 1440
MQIACF_BALANCING_TIMEOUT                 = 1441
MQIACF_SYSP_SMF_STAT_TIME_SECS           = 1442
MQIACF_SYSP_SMF_ACCT_TIME_MINS           = 1443
MQIACF_SYSP_SMF_ACCT_TIME_SECS           = 1444
MQIACF_Q_MGR_STATUS_INFO_TYPE            = 1445
MQIACF_Q_MGR_STATUS_INFO_Q_MGR           = 1446
MQIACF_Q_MGR_STATUS_INFO_NHA             = 1447
MQIACF_AUTO_CLUSTER_TYPE                 = 1448
MQIACF_DATA_FS_IN_USE                    = 1449
MQIACF_DATA_FS_SIZE                      = 1450
MQIACF_LOG_EXTENT_SIZE                   = 1451
MQIACF_LOG_FS_IN_USE                     = 1452
MQIACF_LOG_FS_SIZE                       = 1453
MQIACF_LOG_PRIMARIES                     = 1454
MQIACF_LOG_SECONDARIES                   = 1455
MQIACF_LOG_TYPE                          = 1456
MQIACF_NHA_INSTANCE_ACTV_CONNS           = 1457
MQIACF_NHA_INSTANCE_BACKLOG              = 1458
MQIACF_NHA_INSTANCE_IN_SYNC              = 1459
MQIACF_NHA_INSTANCE_ROLE                 = 1460
MQIACF_NHA_IN_SYNC_INSTANCES             = 1461
MQIACF_NHA_TOTAL_INSTANCES               = 1462
MQIACF_Q_MGR_FS_ENCRYPTED                = 1463
MQIACF_Q_MGR_FS_IN_USE                   = 1464
MQIACF_Q_MGR_FS_SIZE                     = 1465
MQIACF_SYSP_ZHYPERLINK                   = 1466
MQIACF_CHECKPOINT_COUNT                  = 1468
MQIACF_CHECKPOINT_OPERATIONS             = 1469
MQIACF_CHECKPOINT_SIZE                   = 1470
MQIACF_NHA_GROUP_BACKLOG                 = 1471
MQIACF_NHA_GROUP_CONNECTED               = 1472
MQIACF_NHA_GROUP_IN_SYNC                 = 1473
MQIACF_NHA_GROUP_ROLE                    = 1474
MQIACF_NHA_GROUP_STATUS                  = 1475
MQIACF_NHA_INSTANCE_STATUS               = 1476
MQIACF_NHA_TYPE                          = 1477
MQIACF_EVENT_DUPLICATE_COUNT             = 1478
MQIACF_LAST_USED                         = 1478

# Access Options
MQCFACCESS_ENABLED                       = 0
MQCFACCESS_SUSPENDED                     = 1
MQCFACCESS_DISABLED                      = 2

# Open Mode Options
MQS_OPENMODE_NONE                        = 0
MQS_OPENMODE_READONLY                    = 1
MQS_OPENMODE_UPDATE                      = 2
MQS_OPENMODE_RECOVERY                    = 3

# SMDS Status Options
MQS_STATUS_CLOSED                        = 0
MQS_STATUS_CLOSING                       = 1
MQS_STATUS_OPENING                       = 2
MQS_STATUS_OPEN                          = 3
MQS_STATUS_NOTENABLED                    = 4
MQS_STATUS_ALLOCFAIL                     = 5
MQS_STATUS_OPENFAIL                      = 6
MQS_STATUS_STGFAIL                       = 7
MQS_STATUS_DATAFAIL                      = 8

# SMDS Availability Options
MQS_AVAIL_NORMAL                         = 0
MQS_AVAIL_ERROR                          = 1
MQS_AVAIL_STOPPED                        = 2

# Values for MQIACF_BUFFER_POOL_LOCATION.
MQBPLOCATION_BELOW                       = 0
MQBPLOCATION_ABOVE                       = 1
MQBPLOCATION_SWITCHING_ABOVE             = 2
MQBPLOCATION_SWITCHING_BELOW             = 3

# Values for MQIACF_PAGECLAS.
MQPAGECLAS_4KB                           = 0
MQPAGECLAS_FIXED4KB                      = 1

# Expandst Options
MQS_EXPANDST_NORMAL                      = 0
MQS_EXPANDST_FAILED                      = 1
MQS_EXPANDST_MAXIMUM                     = 2

# Usage SMDS Options
MQUSAGE_SMDS_AVAILABLE                   = 0
MQUSAGE_SMDS_NO_DATA                     = 1

# Integer Channel Types
MQIACH_FIRST                             = 1501
MQIACH_XMIT_PROTOCOL_TYPE                = 1501
MQIACH_BATCH_SIZE                        = 1502
MQIACH_DISC_INTERVAL                     = 1503
MQIACH_SHORT_TIMER                       = 1504
MQIACH_SHORT_RETRY                       = 1505
MQIACH_LONG_TIMER                        = 1506
MQIACH_LONG_RETRY                        = 1507
MQIACH_PUT_AUTHORITY                     = 1508
MQIACH_SEQUENCE_NUMBER_WRAP              = 1509
MQIACH_MAX_MSG_LENGTH                    = 1510
MQIACH_CHANNEL_TYPE                      = 1511
MQIACH_DATA_COUNT                        = 1512
MQIACH_NAME_COUNT                        = 1513
MQIACH_MSG_SEQUENCE_NUMBER               = 1514
MQIACH_DATA_CONVERSION                   = 1515
MQIACH_IN_DOUBT                          = 1516
MQIACH_MCA_TYPE                          = 1517
MQIACH_SESSION_COUNT                     = 1518
MQIACH_ADAPTER                           = 1519
MQIACH_COMMAND_COUNT                     = 1520
MQIACH_SOCKET                            = 1521
MQIACH_PORT                              = 1522
MQIACH_CHANNEL_INSTANCE_TYPE             = 1523
MQIACH_CHANNEL_INSTANCE_ATTRS            = 1524
MQIACH_CHANNEL_ERROR_DATA                = 1525
MQIACH_CHANNEL_TABLE                     = 1526
MQIACH_CHANNEL_STATUS                    = 1527
MQIACH_INDOUBT_STATUS                    = 1528
MQIACH_LAST_SEQ_NUMBER                   = 1529
MQIACH_LAST_SEQUENCE_NUMBER              = 1529
MQIACH_CURRENT_MSGS                      = 1531
MQIACH_CURRENT_SEQ_NUMBER                = 1532
MQIACH_CURRENT_SEQUENCE_NUMBER           = 1532
MQIACH_SSL_RETURN_CODE                   = 1533
MQIACH_MSGS                              = 1534
MQIACH_BYTES_SENT                        = 1535
MQIACH_BYTES_RCVD                        = 1536
MQIACH_BYTES_RECEIVED                    = 1536
MQIACH_BATCHES                           = 1537
MQIACH_BUFFERS_SENT                      = 1538
MQIACH_BUFFERS_RCVD                      = 1539
MQIACH_BUFFERS_RECEIVED                  = 1539
MQIACH_LONG_RETRIES_LEFT                 = 1540
MQIACH_SHORT_RETRIES_LEFT                = 1541
MQIACH_MCA_STATUS                        = 1542
MQIACH_STOP_REQUESTED                    = 1543
MQIACH_MR_COUNT                          = 1544
MQIACH_MR_INTERVAL                       = 1545
MQIACH_NPM_SPEED                         = 1562
MQIACH_HB_INTERVAL                       = 1563
MQIACH_BATCH_INTERVAL                    = 1564
MQIACH_NETWORK_PRIORITY                  = 1565
MQIACH_KEEP_ALIVE_INTERVAL               = 1566
MQIACH_BATCH_HB                          = 1567
MQIACH_SSL_CLIENT_AUTH                   = 1568
MQIACH_ALLOC_RETRY                       = 1570
MQIACH_ALLOC_FAST_TIMER                  = 1571
MQIACH_ALLOC_SLOW_TIMER                  = 1572
MQIACH_DISC_RETRY                        = 1573
MQIACH_PORT_NUMBER                       = 1574
MQIACH_HDR_COMPRESSION                   = 1575
MQIACH_MSG_COMPRESSION                   = 1576
MQIACH_CLWL_CHANNEL_RANK                 = 1577
MQIACH_CLWL_CHANNEL_PRIORITY             = 1578
MQIACH_CLWL_CHANNEL_WEIGHT               = 1579
MQIACH_CHANNEL_DISP                      = 1580
MQIACH_INBOUND_DISP                      = 1581
MQIACH_CHANNEL_TYPES                     = 1582
MQIACH_ADAPS_STARTED                     = 1583
MQIACH_ADAPS_MAX                         = 1584
MQIACH_DISPS_STARTED                     = 1585
MQIACH_DISPS_MAX                         = 1586
MQIACH_SSLTASKS_STARTED                  = 1587
MQIACH_SSLTASKS_MAX                      = 1588
MQIACH_CURRENT_CHL                       = 1589
MQIACH_CURRENT_CHL_MAX                   = 1590
MQIACH_CURRENT_CHL_TCP                   = 1591
MQIACH_CURRENT_CHL_LU62                  = 1592
MQIACH_ACTIVE_CHL                        = 1593
MQIACH_ACTIVE_CHL_MAX                    = 1594
MQIACH_ACTIVE_CHL_PAUSED                 = 1595
MQIACH_ACTIVE_CHL_STARTED                = 1596
MQIACH_ACTIVE_CHL_STOPPED                = 1597
MQIACH_ACTIVE_CHL_RETRY                  = 1598
MQIACH_LISTENER_STATUS                   = 1599
MQIACH_SHARED_CHL_RESTART                = 1600
MQIACH_LISTENER_CONTROL                  = 1601
MQIACH_BACKLOG                           = 1602
MQIACH_XMITQ_TIME_INDICATOR              = 1604
MQIACH_NETWORK_TIME_INDICATOR            = 1605
MQIACH_EXIT_TIME_INDICATOR               = 1606
MQIACH_BATCH_SIZE_INDICATOR              = 1607
MQIACH_XMITQ_MSGS_AVAILABLE              = 1608
MQIACH_CHANNEL_SUBSTATE                  = 1609
MQIACH_SSL_KEY_RESETS                    = 1610
MQIACH_COMPRESSION_RATE                  = 1611
MQIACH_COMPRESSION_TIME                  = 1612
MQIACH_MAX_XMIT_SIZE                     = 1613
MQIACH_DEF_CHANNEL_DISP                  = 1614
MQIACH_SHARING_CONVERSATIONS             = 1615
MQIACH_MAX_SHARING_CONVS                 = 1616
MQIACH_CURRENT_SHARING_CONVS             = 1617
MQIACH_MAX_INSTANCES                     = 1618
MQIACH_MAX_INSTS_PER_CLIENT              = 1619
MQIACH_CLIENT_CHANNEL_WEIGHT             = 1620
MQIACH_CONNECTION_AFFINITY               = 1621
MQIACH_AUTH_INFO_TYPES                   = 1622
MQIACH_RESET_REQUESTED                   = 1623
MQIACH_BATCH_DATA_LIMIT                  = 1624
MQIACH_MSG_HISTORY                       = 1625
MQIACH_MULTICAST_PROPERTIES              = 1626
MQIACH_NEW_SUBSCRIBER_HISTORY            = 1627
MQIACH_MC_HB_INTERVAL                    = 1628
MQIACH_USE_CLIENT_ID                     = 1629
MQIACH_MQTT_KEEP_ALIVE                   = 1630
MQIACH_IN_DOUBT_IN                       = 1631
MQIACH_IN_DOUBT_OUT                      = 1632
MQIACH_MSGS_SENT                         = 1633
MQIACH_MSGS_RECEIVED                     = 1634
MQIACH_MSGS_RCVD                         = 1634
MQIACH_PENDING_OUT                       = 1635
MQIACH_AVAILABLE_CIPHERSPECS             = 1636
MQIACH_MATCH                             = 1637
MQIACH_USER_SOURCE                       = 1638
MQIACH_WARNING                           = 1639
MQIACH_DEF_RECONNECT                     = 1640
MQIACH_CHANNEL_SUMMARY_ATTRS             = 1642
MQIACH_PROTOCOL                          = 1643
MQIACH_AMQP_KEEP_ALIVE                   = 1644
MQIACH_SECURITY_PROTOCOL                 = 1645
MQIACH_SPL_PROTECTION                    = 1646
MQIACH_LAST_USED                         = 1646

#----------------------------------------------------------------#
# Values Related to Character Parameter Structures               #
#----------------------------------------------------------------#
# Character Monitoring Parameter Types
MQCAMO_FIRST                             = 2701
MQCAMO_CLOSE_DATE                        = 2701
MQCAMO_CLOSE_TIME                        = 2702
MQCAMO_CONN_DATE                         = 2703
MQCAMO_CONN_TIME                         = 2704
MQCAMO_DISC_DATE                         = 2705
MQCAMO_DISC_TIME                         = 2706
MQCAMO_END_DATE                          = 2707
MQCAMO_END_TIME                          = 2708
MQCAMO_OPEN_DATE                         = 2709
MQCAMO_OPEN_TIME                         = 2710
MQCAMO_START_DATE                        = 2711
MQCAMO_START_TIME                        = 2712
MQCAMO_MONITOR_CLASS                     = 2713
MQCAMO_MONITOR_TYPE                      = 2714
MQCAMO_MONITOR_DESC                      = 2715
MQCAMO_LAST_USED                         = 2715

# Character Parameter Types
MQCACF_FIRST                             = 3001
MQCACF_FROM_Q_NAME                       = 3001
MQCACF_TO_Q_NAME                         = 3002
MQCACF_FROM_PROCESS_NAME                 = 3003
MQCACF_TO_PROCESS_NAME                   = 3004
MQCACF_FROM_NAMELIST_NAME                = 3005
MQCACF_TO_NAMELIST_NAME                  = 3006
MQCACF_FROM_CHANNEL_NAME                 = 3007
MQCACF_TO_CHANNEL_NAME                   = 3008
MQCACF_FROM_AUTH_INFO_NAME               = 3009
MQCACF_TO_AUTH_INFO_NAME                 = 3010
MQCACF_Q_NAMES                           = 3011
MQCACF_PROCESS_NAMES                     = 3012
MQCACF_NAMELIST_NAMES                    = 3013
MQCACF_ESCAPE_TEXT                       = 3014
MQCACF_LOCAL_Q_NAMES                     = 3015
MQCACF_MODEL_Q_NAMES                     = 3016
MQCACF_ALIAS_Q_NAMES                     = 3017
MQCACF_REMOTE_Q_NAMES                    = 3018
MQCACF_SENDER_CHANNEL_NAMES              = 3019
MQCACF_SERVER_CHANNEL_NAMES              = 3020
MQCACF_REQUESTER_CHANNEL_NAMES           = 3021
MQCACF_RECEIVER_CHANNEL_NAMES            = 3022
MQCACF_OBJECT_Q_MGR_NAME                 = 3023
MQCACF_APPL_NAME                         = 3024
MQCACF_USER_IDENTIFIER                   = 3025
MQCACF_AUX_ERROR_DATA_STR_1              = 3026
MQCACF_AUX_ERROR_DATA_STR_2              = 3027
MQCACF_AUX_ERROR_DATA_STR_3              = 3028
MQCACF_BRIDGE_NAME                       = 3029
MQCACF_STREAM_NAME                       = 3030
MQCACF_TOPIC                             = 3031
MQCACF_PARENT_Q_MGR_NAME                 = 3032
MQCACF_CORREL_ID                         = 3033
MQCACF_PUBLISH_TIMESTAMP                 = 3034
MQCACF_STRING_DATA                       = 3035
MQCACF_SUPPORTED_STREAM_NAME             = 3036
MQCACF_REG_TOPIC                         = 3037
MQCACF_REG_TIME                          = 3038
MQCACF_REG_USER_ID                       = 3039
MQCACF_CHILD_Q_MGR_NAME                  = 3040
MQCACF_REG_STREAM_NAME                   = 3041
MQCACF_REG_Q_MGR_NAME                    = 3042
MQCACF_REG_Q_NAME                        = 3043
MQCACF_REG_CORREL_ID                     = 3044
MQCACF_EVENT_USER_ID                     = 3045
MQCACF_OBJECT_NAME                       = 3046
MQCACF_EVENT_Q_MGR                       = 3047
MQCACF_AUTH_INFO_NAMES                   = 3048
MQCACF_EVENT_APPL_IDENTITY               = 3049
MQCACF_EVENT_APPL_NAME                   = 3050
MQCACF_EVENT_APPL_ORIGIN                 = 3051
MQCACF_SUBSCRIPTION_NAME                 = 3052
MQCACF_REG_SUB_NAME                      = 3053
MQCACF_SUBSCRIPTION_IDENTITY             = 3054
MQCACF_REG_SUB_IDENTITY                  = 3055
MQCACF_SUBSCRIPTION_USER_DATA            = 3056
MQCACF_REG_SUB_USER_DATA                 = 3057
MQCACF_APPL_TAG                          = 3058
MQCACF_DATA_SET_NAME                     = 3059
MQCACF_UOW_START_DATE                    = 3060
MQCACF_UOW_START_TIME                    = 3061
MQCACF_UOW_LOG_START_DATE                = 3062
MQCACF_UOW_LOG_START_TIME                = 3063
MQCACF_UOW_LOG_EXTENT_NAME               = 3064
MQCACF_PRINCIPAL_ENTITY_NAMES            = 3065
MQCACF_GROUP_ENTITY_NAMES                = 3066
MQCACF_AUTH_PROFILE_NAME                 = 3067
MQCACF_ENTITY_NAME                       = 3068
MQCACF_SERVICE_COMPONENT                 = 3069
MQCACF_RESPONSE_Q_MGR_NAME               = 3070
MQCACF_CURRENT_LOG_EXTENT_NAME           = 3071
MQCACF_RESTART_LOG_EXTENT_NAME           = 3072
MQCACF_MEDIA_LOG_EXTENT_NAME             = 3073
MQCACF_LOG_PATH                          = 3074
MQCACF_COMMAND_MQSC                      = 3075
MQCACF_Q_MGR_CPF                         = 3076
MQCACF_USAGE_LOG_RBA                     = 3078
MQCACF_USAGE_LOG_LRSN                    = 3079
MQCACF_COMMAND_SCOPE                     = 3080
MQCACF_ASID                              = 3081
MQCACF_PSB_NAME                          = 3082
MQCACF_PST_ID                            = 3083
MQCACF_TASK_NUMBER                       = 3084
MQCACF_TRANSACTION_ID                    = 3085
MQCACF_Q_MGR_UOW_ID                      = 3086
MQCACF_ORIGIN_NAME                       = 3088
MQCACF_ENV_INFO                          = 3089
MQCACF_SECURITY_PROFILE                  = 3090
MQCACF_CONFIGURATION_DATE                = 3091
MQCACF_CONFIGURATION_TIME                = 3092
MQCACF_FROM_CF_STRUC_NAME                = 3093
MQCACF_TO_CF_STRUC_NAME                  = 3094
MQCACF_CF_STRUC_NAMES                    = 3095
MQCACF_FAIL_DATE                         = 3096
MQCACF_FAIL_TIME                         = 3097
MQCACF_BACKUP_DATE                       = 3098
MQCACF_BACKUP_TIME                       = 3099
MQCACF_SYSTEM_NAME                       = 3100
MQCACF_CF_STRUC_BACKUP_START             = 3101
MQCACF_CF_STRUC_BACKUP_END               = 3102
MQCACF_CF_STRUC_LOG_Q_MGRS               = 3103
MQCACF_FROM_STORAGE_CLASS                = 3104
MQCACF_TO_STORAGE_CLASS                  = 3105
MQCACF_STORAGE_CLASS_NAMES               = 3106
MQCACF_DSG_NAME                          = 3108
MQCACF_DB2_NAME                          = 3109
MQCACF_SYSP_CMD_USER_ID                  = 3110
MQCACF_SYSP_OTMA_GROUP                   = 3111
MQCACF_SYSP_OTMA_MEMBER                  = 3112
MQCACF_SYSP_OTMA_DRU_EXIT                = 3113
MQCACF_SYSP_OTMA_TPIPE_PFX               = 3114
MQCACF_SYSP_ARCHIVE_PFX1                 = 3115
MQCACF_SYSP_ARCHIVE_UNIT1                = 3116
MQCACF_SYSP_LOG_CORREL_ID                = 3117
MQCACF_SYSP_UNIT_VOLSER                  = 3118
MQCACF_SYSP_Q_MGR_TIME                   = 3119
MQCACF_SYSP_Q_MGR_DATE                   = 3120
MQCACF_SYSP_Q_MGR_RBA                    = 3121
MQCACF_SYSP_LOG_RBA                      = 3122
MQCACF_SYSP_SERVICE                      = 3123
MQCACF_FROM_LISTENER_NAME                = 3124
MQCACF_TO_LISTENER_NAME                  = 3125
MQCACF_FROM_SERVICE_NAME                 = 3126
MQCACF_TO_SERVICE_NAME                   = 3127
MQCACF_LAST_PUT_DATE                     = 3128
MQCACF_LAST_PUT_TIME                     = 3129
MQCACF_LAST_GET_DATE                     = 3130
MQCACF_LAST_GET_TIME                     = 3131
MQCACF_OPERATION_DATE                    = 3132
MQCACF_OPERATION_TIME                    = 3133
MQCACF_ACTIVITY_DESC                     = 3134
MQCACF_APPL_IDENTITY_DATA                = 3135
MQCACF_APPL_ORIGIN_DATA                  = 3136
MQCACF_PUT_DATE                          = 3137
MQCACF_PUT_TIME                          = 3138
MQCACF_REPLY_TO_Q                        = 3139
MQCACF_REPLY_TO_Q_MGR                    = 3140
MQCACF_RESOLVED_Q_NAME                   = 3141
MQCACF_STRUC_ID                          = 3142
MQCACF_VALUE_NAME                        = 3143
MQCACF_SERVICE_START_DATE                = 3144
MQCACF_SERVICE_START_TIME                = 3145
MQCACF_SYSP_OFFLINE_RBA                  = 3146
MQCACF_SYSP_ARCHIVE_PFX2                 = 3147
MQCACF_SYSP_ARCHIVE_UNIT2                = 3148
MQCACF_TO_TOPIC_NAME                     = 3149
MQCACF_FROM_TOPIC_NAME                   = 3150
MQCACF_TOPIC_NAMES                       = 3151
MQCACF_SUB_NAME                          = 3152
MQCACF_DESTINATION_Q_MGR                 = 3153
MQCACF_DESTINATION                       = 3154
MQCACF_SUB_USER_ID                       = 3156
MQCACF_SUB_USER_DATA                     = 3159
MQCACF_SUB_SELECTOR                      = 3160
MQCACF_LAST_PUB_DATE                     = 3161
MQCACF_LAST_PUB_TIME                     = 3162
MQCACF_FROM_SUB_NAME                     = 3163
MQCACF_TO_SUB_NAME                       = 3164
MQCACF_LAST_MSG_TIME                     = 3167
MQCACF_LAST_MSG_DATE                     = 3168
MQCACF_SUBSCRIPTION_POINT                = 3169
MQCACF_FILTER                            = 3170
MQCACF_NONE                              = 3171
MQCACF_ADMIN_TOPIC_NAMES                 = 3172
MQCACF_ROUTING_FINGER_PRINT              = 3173
MQCACF_APPL_DESC                         = 3174
MQCACF_Q_MGR_START_DATE                  = 3175
MQCACF_Q_MGR_START_TIME                  = 3176
MQCACF_FROM_COMM_INFO_NAME               = 3177
MQCACF_TO_COMM_INFO_NAME                 = 3178
MQCACF_CF_OFFLOAD_SIZE1                  = 3179
MQCACF_CF_OFFLOAD_SIZE2                  = 3180
MQCACF_CF_OFFLOAD_SIZE3                  = 3181
MQCACF_CF_SMDS_GENERIC_NAME              = 3182
MQCACF_CF_SMDS                           = 3183
MQCACF_RECOVERY_DATE                     = 3184
MQCACF_RECOVERY_TIME                     = 3185
MQCACF_CF_SMDSCONN                       = 3186
MQCACF_CF_STRUC_NAME                     = 3187
MQCACF_ALTERNATE_USERID                  = 3188
MQCACF_CHAR_ATTRS                        = 3189
MQCACF_DYNAMIC_Q_NAME                    = 3190
MQCACF_HOST_NAME                         = 3191
MQCACF_MQCB_NAME                         = 3192
MQCACF_OBJECT_STRING                     = 3193
MQCACF_RESOLVED_LOCAL_Q_MGR              = 3194
MQCACF_RESOLVED_LOCAL_Q_NAME             = 3195
MQCACF_RESOLVED_OBJECT_STRING            = 3196
MQCACF_RESOLVED_Q_MGR                    = 3197
MQCACF_SELECTION_STRING                  = 3198
MQCACF_XA_INFO                           = 3199
MQCACF_APPL_FUNCTION                     = 3200
MQCACF_XQH_REMOTE_Q_NAME                 = 3201
MQCACF_XQH_REMOTE_Q_MGR                  = 3202
MQCACF_XQH_PUT_TIME                      = 3203
MQCACF_XQH_PUT_DATE                      = 3204
MQCACF_EXCL_OPERATOR_MESSAGES            = 3205
MQCACF_CSP_USER_IDENTIFIER               = 3206
MQCACF_AMQP_CLIENT_ID                    = 3207
MQCACF_ARCHIVE_LOG_EXTENT_NAME           = 3208
MQCACF_APPL_IMMOVABLE_DATE               = 3209
MQCACF_APPL_IMMOVABLE_TIME               = 3210
MQCACF_NHA_INSTANCE_NAME                 = 3211
MQCACF_Q_MGR_DATA_PATH                   = 3212
MQCACF_UNIFORM_CLUSTER_NAME              = 3213
MQCACF_LOG_START_DATE                    = 3214
MQCACF_LOG_START_LSN                     = 3215
MQCACF_LOG_START_TIME                    = 3216
MQCACF_NHA_GROUP_INITIAL_DATE            = 3217
MQCACF_NHA_GROUP_INITIAL_LSN             = 3218
MQCACF_NHA_GROUP_INITIAL_TIME            = 3219
MQCACF_NHA_REPL_ADDRESS                  = 3220
MQCACF_DISK_WRITTEN_LSN                  = 3221
MQCACF_NHA_ACKNOWLEDGED_LSN              = 3222
MQCACF_NHA_GROUP_ADDRESS                 = 3223
MQCACF_NHA_GROUP_SYNC_ISOTIME            = 3224
MQCACF_NHA_GROUP_INIT_ISOTIME            = 3225
MQCACF_NHA_GROUP_LIVE_ISOTIME            = 3226
MQCACF_NHA_GROUP_LSN                     = 3227
MQCACF_NHA_GROUP_NAME                    = 3228
MQCACF_NHA_GROUP_RECOV_LSN               = 3229
MQCACF_NHA_GROUP_RECOV_ISOTIME           = 3230
MQCACF_NHA_SYNC_ISOTIME                  = 3231
MQCACF_EVENT_DUPLICATE_FROM              = 3232
MQCACF_LAST_USED                         = 3232

# Character Channel Parameter Types
MQCACH_FIRST                             = 3501
MQCACH_CHANNEL_NAME                      = 3501
MQCACH_DESC                              = 3502
MQCACH_MODE_NAME                         = 3503
MQCACH_TP_NAME                           = 3504
MQCACH_XMIT_Q_NAME                       = 3505
MQCACH_CONNECTION_NAME                   = 3506
MQCACH_MCA_NAME                          = 3507
MQCACH_SEC_EXIT_NAME                     = 3508
MQCACH_MSG_EXIT_NAME                     = 3509
MQCACH_SEND_EXIT_NAME                    = 3510
MQCACH_RCV_EXIT_NAME                     = 3511
MQCACH_CHANNEL_NAMES                     = 3512
MQCACH_SEC_EXIT_USER_DATA                = 3513
MQCACH_MSG_EXIT_USER_DATA                = 3514
MQCACH_SEND_EXIT_USER_DATA               = 3515
MQCACH_RCV_EXIT_USER_DATA                = 3516
MQCACH_USER_ID                           = 3517
MQCACH_PASSWORD                          = 3518
MQCACH_LOCAL_ADDRESS                     = 3520
MQCACH_LOCAL_NAME                        = 3521
MQCACH_LAST_MSG_TIME                     = 3524
MQCACH_LAST_MSG_DATE                     = 3525
MQCACH_MCA_USER_ID                       = 3527
MQCACH_CHANNEL_START_TIME                = 3528
MQCACH_CHANNEL_START_DATE                = 3529
MQCACH_MCA_JOB_NAME                      = 3530
MQCACH_LAST_LUWID                        = 3531
MQCACH_CURRENT_LUWID                     = 3532
MQCACH_FORMAT_NAME                       = 3533
MQCACH_MR_EXIT_NAME                      = 3534
MQCACH_MR_EXIT_USER_DATA                 = 3535
MQCACH_SSL_CIPHER_SPEC                   = 3544
MQCACH_SSL_PEER_NAME                     = 3545
MQCACH_SSL_HANDSHAKE_STAGE               = 3546
MQCACH_SSL_SHORT_PEER_NAME               = 3547
MQCACH_REMOTE_APPL_TAG                   = 3548
MQCACH_SSL_CERT_USER_ID                  = 3549
MQCACH_SSL_CERT_ISSUER_NAME              = 3550
MQCACH_LU_NAME                           = 3551
MQCACH_IP_ADDRESS                        = 3552
MQCACH_TCP_NAME                          = 3553
MQCACH_LISTENER_NAME                     = 3554
MQCACH_LISTENER_DESC                     = 3555
MQCACH_LISTENER_START_DATE               = 3556
MQCACH_LISTENER_START_TIME               = 3557
MQCACH_SSL_KEY_RESET_DATE                = 3558
MQCACH_SSL_KEY_RESET_TIME                = 3559
MQCACH_REMOTE_VERSION                    = 3560
MQCACH_REMOTE_PRODUCT                    = 3561
MQCACH_GROUP_ADDRESS                     = 3562
MQCACH_JAAS_CONFIG                       = 3563
MQCACH_CLIENT_ID                         = 3564
MQCACH_SSL_KEY_PASSPHRASE                = 3565
MQCACH_CONNECTION_NAME_LIST              = 3566
MQCACH_CLIENT_USER_ID                    = 3567
MQCACH_MCA_USER_ID_LIST                  = 3568
MQCACH_SSL_CIPHER_SUITE                  = 3569
MQCACH_WEBCONTENT_PATH                   = 3570
MQCACH_TOPIC_ROOT                        = 3571
MQCACH_TEMPORARY_MODEL_Q                 = 3572
MQCACH_TEMPORARY_Q_PREFIX                = 3573
MQCACH_LAST_USED                         = 3573

#----------------------------------------------------------------#
# Values Related to Group Parameter Structures                   #
#----------------------------------------------------------------#
# Group Parameter Types
MQGACF_FIRST                             = 8001
MQGACF_COMMAND_CONTEXT                   = 8001
MQGACF_COMMAND_DATA                      = 8002
MQGACF_TRACE_ROUTE                       = 8003
MQGACF_OPERATION                         = 8004
MQGACF_ACTIVITY                          = 8005
MQGACF_EMBEDDED_MQMD                     = 8006
MQGACF_MESSAGE                           = 8007
MQGACF_MQMD                              = 8008
MQGACF_VALUE_NAMING                      = 8009
MQGACF_Q_ACCOUNTING_DATA                 = 8010
MQGACF_Q_STATISTICS_DATA                 = 8011
MQGACF_CHL_STATISTICS_DATA               = 8012
MQGACF_ACTIVITY_TRACE                    = 8013
MQGACF_APP_DIST_LIST                     = 8014
MQGACF_MONITOR_CLASS                     = 8015
MQGACF_MONITOR_TYPE                      = 8016
MQGACF_MONITOR_ELEMENT                   = 8017
MQGACF_APPL_STATUS                       = 8018
MQGACF_CHANGED_APPLS                     = 8019
MQGACF_ALL_APPLS                         = 8020
MQGACF_APPL_BALANCE                      = 8021
MQGACF_LAST_USED                         = 8021

#----------------------------------------------------------------#
# Parameter Values                                               #
#----------------------------------------------------------------#
# Action Options
MQACT_FORCE_REMOVE                       = 1
MQACT_ADVANCE_LOG                        = 2
MQACT_COLLECT_STATISTICS                 = 3
MQACT_PUBSUB                             = 4
MQACT_ADD                                = 5
MQACT_REPLACE                            = 6
MQACT_REMOVE                             = 7
MQACT_REMOVEALL                          = 8
MQACT_FAIL                               = 9
MQACT_REDUCE_LOG                         = 10
MQACT_ARCHIVE_LOG                        = 11

# State Options
MQIS_NO                                  = 0
MQIS_YES                                 = 1

# Movable Options
MQAPPL_IMMOVABLE                         = 0
MQAPPL_MOVABLE                           = 1

# Active Options
MQACTIVE_NO                              = 0
MQACTIVE_YES                             = 1

# Balance Options
MQBALANCED_NO                            = 0
MQBALANCED_YES                           = 1
MQBALANCED_NOT_APPLICABLE                = 2
MQBALANCED_UNKNOWN                       = 3

# Balance State
MQBALSTATE_NOT_APPLICABLE                = 0
MQBALSTATE_LOW                           = 1
MQBALSTATE_OK                            = 2
MQBALSTATE_HIGH                          = 3
MQBALSTATE_UNKNOWN                       = 4

# Immovable Reasons
MQIMMREASON_NONE                         = 0
MQIMMREASON_NOT_CLIENT                   = 1
MQIMMREASON_NOT_RECONNECTABLE            = 2
MQIMMREASON_MOVING                       = 3
MQIMMREASON_APPLNAME_CHANGED             = 4
MQIMMREASON_IN_TRANSACTION               = 5
MQIMMREASON_AWAITS_REPLY                 = 6
MQIMMREASON_NO_REDIRECT                  = 7

# Asynchronous State Values
MQAS_NONE                                = 0
MQAS_STARTED                             = 1
MQAS_START_WAIT                          = 2
MQAS_STOPPED                             = 3
MQAS_SUSPENDED                           = 4
MQAS_SUSPENDED_TEMPORARY                 = 5
MQAS_ACTIVE                              = 6
MQAS_INACTIVE                            = 7

# Authority Values
MQAUTH_NONE                              = 0
MQAUTH_ALT_USER_AUTHORITY                = 1
MQAUTH_BROWSE                            = 2
MQAUTH_CHANGE                            = 3
MQAUTH_CLEAR                             = 4
MQAUTH_CONNECT                           = 5
MQAUTH_CREATE                            = 6
MQAUTH_DELETE                            = 7
MQAUTH_DISPLAY                           = 8
MQAUTH_INPUT                             = 9
MQAUTH_INQUIRE                           = 10
MQAUTH_OUTPUT                            = 11
MQAUTH_PASS_ALL_CONTEXT                  = 12
MQAUTH_PASS_IDENTITY_CONTEXT             = 13
MQAUTH_SET                               = 14
MQAUTH_SET_ALL_CONTEXT                   = 15
MQAUTH_SET_IDENTITY_CONTEXT              = 16
MQAUTH_CONTROL                           = 17
MQAUTH_CONTROL_EXTENDED                  = 18
MQAUTH_PUBLISH                           = 19
MQAUTH_SUBSCRIBE                         = 20
MQAUTH_RESUME                            = 21
MQAUTH_SYSTEM                            = 22
MQAUTH_ALL                               = (-1)
MQAUTH_ALL_ADMIN                         = (-2)
MQAUTH_ALL_MQI                           = (-3)

# Authority Options
MQAUTHOPT_ENTITY_EXPLICIT                = 0x00000001
MQAUTHOPT_ENTITY_SET                     = 0x00000002
MQAUTHOPT_NAME_EXPLICIT                  = 0x00000010
MQAUTHOPT_NAME_ALL_MATCHING              = 0x00000020
MQAUTHOPT_NAME_AS_WILDCARD               = 0x00000040
MQAUTHOPT_CUMULATIVE                     = 0x00000100
MQAUTHOPT_EXCLUDE_TEMP                   = 0x00000200

# Bridge Types
MQBT_OTMA                                = 1

# Refresh Repository Options
MQCFO_REFRESH_REPOSITORY_YES             = 1
MQCFO_REFRESH_REPOSITORY_NO              = 0

# Remove Queues Options
MQCFO_REMOVE_QUEUES_YES                  = 1
MQCFO_REMOVE_QUEUES_NO                   = 0

# CHLAUTH Type
MQCAUT_ALL                               = 0
MQCAUT_BLOCKUSER                         = 1
MQCAUT_BLOCKADDR                         = 2
MQCAUT_SSLPEERMAP                        = 3
MQCAUT_ADDRESSMAP                        = 4
MQCAUT_USERMAP                           = 5
MQCAUT_QMGRMAP                           = 6

# CF Status
MQCFSTATUS_NOT_FOUND                     = 0
MQCFSTATUS_ACTIVE                        = 1
MQCFSTATUS_IN_RECOVER                    = 2
MQCFSTATUS_IN_BACKUP                     = 3
MQCFSTATUS_FAILED                        = 4
MQCFSTATUS_NONE                          = 5
MQCFSTATUS_UNKNOWN                       = 6
MQCFSTATUS_RECOVERED                     = 7
MQCFSTATUS_EMPTY                         = 8
MQCFSTATUS_NEW                           = 9
MQCFSTATUS_ADMIN_INCOMPLETE              = 20
MQCFSTATUS_NEVER_USED                    = 21
MQCFSTATUS_NO_BACKUP                     = 22
MQCFSTATUS_NOT_FAILED                    = 23
MQCFSTATUS_NOT_RECOVERABLE               = 24
MQCFSTATUS_XES_ERROR                     = 25

# CF Types
MQCFTYPE_APPL                            = 0
MQCFTYPE_ADMIN                           = 1

# Indoubt Status
MQCHIDS_NOT_INDOUBT                      = 0
MQCHIDS_INDOUBT                          = 1

# Channel Dispositions
MQCHLD_ALL                               = (-1)
MQCHLD_DEFAULT                           = 1
MQCHLD_SHARED                            = 2
MQCHLD_PRIVATE                           = 4
MQCHLD_FIXSHARED                         = 5

# Use ClientID
MQUCI_YES                                = 1
MQUCI_NO                                 = 0

# Channel Status
MQCHS_INACTIVE                           = 0
MQCHS_BINDING                            = 1
MQCHS_STARTING                           = 2
MQCHS_RUNNING                            = 3
MQCHS_STOPPING                           = 4
MQCHS_RETRYING                           = 5
MQCHS_STOPPED                            = 6
MQCHS_REQUESTING                         = 7
MQCHS_PAUSED                             = 8
MQCHS_DISCONNECTED                       = 9
MQCHS_INITIALIZING                       = 13
MQCHS_SWITCHING                          = 14

# Channel Substates
MQCHSSTATE_OTHER                         = 0
MQCHSSTATE_END_OF_BATCH                  = 100
MQCHSSTATE_SENDING                       = 200
MQCHSSTATE_RECEIVING                     = 300
MQCHSSTATE_SERIALIZING                   = 400
MQCHSSTATE_RESYNCHING                    = 500
MQCHSSTATE_HEARTBEATING                  = 600
MQCHSSTATE_IN_SCYEXIT                    = 700
MQCHSSTATE_IN_RCVEXIT                    = 800
MQCHSSTATE_IN_SENDEXIT                   = 900
MQCHSSTATE_IN_MSGEXIT                    = 1000
MQCHSSTATE_IN_MREXIT                     = 1100
MQCHSSTATE_IN_CHADEXIT                   = 1200
MQCHSSTATE_NET_CONNECTING                = 1250
MQCHSSTATE_SSL_HANDSHAKING               = 1300
MQCHSSTATE_NAME_SERVER                   = 1400
MQCHSSTATE_IN_MQPUT                      = 1500
MQCHSSTATE_IN_MQGET                      = 1600
MQCHSSTATE_IN_MQI_CALL                   = 1700
MQCHSSTATE_COMPRESSING                   = 1800

# Channel Shared Restart Options
MQCHSH_RESTART_NO                        = 0
MQCHSH_RESTART_YES                       = 1

# Channel Stop Options
MQCHSR_STOP_NOT_REQUESTED                = 0
MQCHSR_STOP_REQUESTED                    = 1

# Channel reset requested
MQCHRR_RESET_NOT_REQUESTED               = 0

# Channel Table Types
MQCHTAB_Q_MGR                            = 1
MQCHTAB_CLNTCONN                         = 2

# Clear Topic String Scope
MQCLRS_LOCAL                             = 1
MQCLRS_GLOBAL                            = 2

# Clear Topic String Type
MQCLRT_RETAINED                          = 1

# Command Information Values
MQCMDI_CMDSCOPE_ACCEPTED                 = 1
MQCMDI_CMDSCOPE_GENERATED                = 2
MQCMDI_CMDSCOPE_COMPLETED                = 3
MQCMDI_QSG_DISP_COMPLETED                = 4
MQCMDI_COMMAND_ACCEPTED                  = 5
MQCMDI_CLUSTER_REQUEST_QUEUED            = 6
MQCMDI_CHANNEL_INIT_STARTED              = 7
MQCMDI_RECOVER_STARTED                   = 11
MQCMDI_BACKUP_STARTED                    = 12
MQCMDI_RECOVER_COMPLETED                 = 13
MQCMDI_SEC_TIMER_ZERO                    = 14
MQCMDI_REFRESH_CONFIGURATION             = 16
MQCMDI_SEC_SIGNOFF_ERROR                 = 17
MQCMDI_IMS_BRIDGE_SUSPENDED              = 18
MQCMDI_DB2_SUSPENDED                     = 19
MQCMDI_DB2_OBSOLETE_MSGS                 = 20
MQCMDI_SEC_UPPERCASE                     = 21
MQCMDI_SEC_MIXEDCASE                     = 22

# Disconnect Types
MQDISCONNECT_NORMAL                      = 0
MQDISCONNECT_IMPLICIT                    = 1
MQDISCONNECT_Q_MGR                       = 2

# Escape Types
MQET_MQSC                                = 1

# Event Origins
MQEVO_OTHER                              = 0
MQEVO_CONSOLE                            = 1
MQEVO_INIT                               = 2
MQEVO_MSG                                = 3
MQEVO_MQSET                              = 4
MQEVO_INTERNAL                           = 5
MQEVO_MQSUB                              = 6
MQEVO_CTLMSG                             = 7
MQEVO_REST                               = 8

# Event Recording
MQEVR_DISABLED                           = 0
MQEVR_ENABLED                            = 1
MQEVR_EXCEPTION                          = 2
MQEVR_NO_DISPLAY                         = 3
MQEVR_API_ONLY                           = 4
MQEVR_ADMIN_ONLY                         = 5
MQEVR_USER_ONLY                          = 6

# Authority Event Scope
MQAUSC_FAILURES                          = 0
MQAUSC_ALLCONNS                          = 1
MQAUSC_ALLCHECKS                         = 2

# Force Options
MQFC_YES                                 = 1
MQFC_NO                                  = 0

# Handle States
MQHSTATE_INACTIVE                        = 0
MQHSTATE_ACTIVE                          = 1

# Inbound Dispositions
MQINBD_Q_MGR                             = 0
MQINBD_GROUP                             = 3

# Indoubt Options
MQIDO_COMMIT                             = 1
MQIDO_BACKOUT                            = 2

# Match Types
MQMATCH_GENERIC                          = 0
MQMATCH_RUNCHECK                         = 1
MQMATCH_EXACT                            = 2
MQMATCH_ALL                              = 3

# Message Channel Agent Status
MQMCAS_STOPPED                           = 0
MQMCAS_RUNNING                           = 3

# Mode Options
MQMODE_FORCE                             = 0
MQMODE_QUIESCE                           = 1
MQMODE_TERMINATE                         = 2

# Message Level Protection
MQMLP_TOLERATE_UNPROTECTED_NO            = 0
MQMLP_TOLERATE_UNPROTECTED_YES           = 1
MQMLP_ENCRYPTION_ALG_NONE                = 0
MQMLP_ENCRYPTION_ALG_RC2                 = 1
MQMLP_ENCRYPTION_ALG_DES                 = 2
MQMLP_ENCRYPTION_ALG_3DES                = 3
MQMLP_ENCRYPTION_ALG_AES128              = 4
MQMLP_ENCRYPTION_ALG_AES256              = 5
MQMLP_SIGN_ALG_NONE                      = 0
MQMLP_SIGN_ALG_MD5                       = 1
MQMLP_SIGN_ALG_SHA1                      = 2
MQMLP_SIGN_ALG_SHA224                    = 3
MQMLP_SIGN_ALG_SHA256                    = 4
MQMLP_SIGN_ALG_SHA384                    = 5
MQMLP_SIGN_ALG_SHA512                    = 6

# Purge Options
MQPO_YES                                 = 1
MQPO_NO                                  = 0

# Pub/Sub Status Counts
MQPSCT_NONE                              = (-1)

# Pub/Sub Status Type
MQPSST_ALL                               = 0
MQPSST_LOCAL                             = 1
MQPSST_PARENT                            = 2
MQPSST_CHILD                             = 3

# Pub/Sub Status
MQPS_STATUS_INACTIVE                     = 0
MQPS_STATUS_STARTING                     = 1
MQPS_STATUS_STOPPING                     = 2
MQPS_STATUS_ACTIVE                       = 3
MQPS_STATUS_COMPAT                       = 4
MQPS_STATUS_ERROR                        = 5
MQPS_STATUS_REFUSED                      = 6

# Queue Manager Definition Types
MQQMDT_EXPLICIT_CLUSTER_SENDER           = 1
MQQMDT_AUTO_CLUSTER_SENDER               = 2
MQQMDT_AUTO_EXP_CLUSTER_SENDER           = 4
MQQMDT_CLUSTER_RECEIVER                  = 3

# Queue Manager Facility
MQQMFAC_IMS_BRIDGE                       = 1
MQQMFAC_DB2                              = 2

# Queue Manager Status
MQQMSTA_STARTING                         = 1
MQQMSTA_RUNNING                          = 2
MQQMSTA_QUIESCING                        = 3
MQQMSTA_STANDBY                          = 4

# Queue Manager Types
MQQMT_NORMAL                             = 0
MQQMT_REPOSITORY                         = 1

# Quiesce Options
MQQO_YES                                 = 1
MQQO_NO                                  = 0

# Queue Service-Interval Events
MQQSIE_NONE                              = 0
MQQSIE_HIGH                              = 1
MQQSIE_OK                                = 2

# Queue Status Open Types
MQQSOT_ALL                               = 1
MQQSOT_INPUT                             = 2
MQQSOT_OUTPUT                            = 3

# QSG Status
MQQSGS_UNKNOWN                           = 0
MQQSGS_CREATED                           = 1
MQQSGS_ACTIVE                            = 2
MQQSGS_INACTIVE                          = 3
MQQSGS_FAILED                            = 4
MQQSGS_PENDING                           = 5

# Queue Status Open Options for SET, BROWSE, INPUT
MQQSO_NO                                 = 0
MQQSO_YES                                = 1
MQQSO_SHARED                             = 1
MQQSO_EXCLUSIVE                          = 2

# Queue Status Uncommitted Messages
MQQSUM_YES                               = 1
MQQSUM_NO                                = 0

# Remove Authority Record Options
MQRAR_YES                                = 1
MQRAR_NO                                 = 0

# Replace Options
MQRP_YES                                 = 1
MQRP_NO                                  = 0

# Reason Qualifiers
MQRQ_CONN_NOT_AUTHORIZED                 = 1
MQRQ_OPEN_NOT_AUTHORIZED                 = 2
MQRQ_CLOSE_NOT_AUTHORIZED                = 3
MQRQ_CMD_NOT_AUTHORIZED                  = 4
MQRQ_Q_MGR_STOPPING                      = 5
MQRQ_Q_MGR_QUIESCING                     = 6
MQRQ_CHANNEL_STOPPED_OK                  = 7
MQRQ_CHANNEL_STOPPED_ERROR               = 8
MQRQ_CHANNEL_STOPPED_RETRY               = 9
MQRQ_CHANNEL_STOPPED_DISABLED            = 10
MQRQ_BRIDGE_STOPPED_OK                   = 11
MQRQ_BRIDGE_STOPPED_ERROR                = 12
MQRQ_SSL_HANDSHAKE_ERROR                 = 13
MQRQ_SSL_CIPHER_SPEC_ERROR               = 14
MQRQ_SSL_CLIENT_AUTH_ERROR               = 15
MQRQ_SSL_PEER_NAME_ERROR                 = 16
MQRQ_SUB_NOT_AUTHORIZED                  = 17
MQRQ_SUB_DEST_NOT_AUTHORIZED             = 18
MQRQ_SSL_UNKNOWN_REVOCATION              = 19
MQRQ_SYS_CONN_NOT_AUTHORIZED             = 20
MQRQ_CHANNEL_BLOCKED_ADDRESS             = 21
MQRQ_CHANNEL_BLOCKED_USERID              = 22
MQRQ_CHANNEL_BLOCKED_NOACCESS            = 23
MQRQ_MAX_ACTIVE_CHANNELS                 = 24
MQRQ_MAX_CHANNELS                        = 25
MQRQ_SVRCONN_INST_LIMIT                  = 26
MQRQ_CLIENT_INST_LIMIT                   = 27
MQRQ_CAF_NOT_INSTALLED                   = 28
MQRQ_CSP_NOT_AUTHORIZED                  = 29
MQRQ_FAILOVER_PERMITTED                  = 30
MQRQ_FAILOVER_NOT_PERMITTED              = 31
MQRQ_STANDBY_ACTIVATED                   = 32
MQRQ_REPLICA_ACTIVATED                   = 33
MQRQ_CONN_AUTHORIZED                     = 65
MQRQ_OPEN_AUTHORIZED                     = 66
MQRQ_SUB_AUTHORIZED                      = 67
MQRQ_SUB_DEST_AUTHORIZED                 = 68

# Refresh Types
MQRT_CONFIGURATION                       = 1
MQRT_EXPIRY                              = 2
MQRT_NSPROC                              = 3
MQRT_PROXYSUB                            = 4
MQRT_SUB_CONFIGURATION                   = 5

# Queue Definition Scope
MQSCO_Q_MGR                              = 1
MQSCO_CELL                               = 2

# Security Items
MQSECITEM_ALL                            = 0
MQSECITEM_MQADMIN                        = 1
MQSECITEM_MQNLIST                        = 2
MQSECITEM_MQPROC                         = 3
MQSECITEM_MQQUEUE                        = 4
MQSECITEM_MQCONN                         = 5
MQSECITEM_MQCMDS                         = 6
MQSECITEM_MXADMIN                        = 7
MQSECITEM_MXNLIST                        = 8
MQSECITEM_MXPROC                         = 9
MQSECITEM_MXQUEUE                        = 10
MQSECITEM_MXTOPIC                        = 11

# Security Switches
MQSECSW_PROCESS                          = 1
MQSECSW_NAMELIST                         = 2
MQSECSW_Q                                = 3
MQSECSW_TOPIC                            = 4
MQSECSW_CONTEXT                          = 6
MQSECSW_ALTERNATE_USER                   = 7
MQSECSW_COMMAND                          = 8
MQSECSW_CONNECTION                       = 9
MQSECSW_SUBSYSTEM                        = 10
MQSECSW_COMMAND_RESOURCES                = 11
MQSECSW_Q_MGR                            = 15
MQSECSW_QSG                              = 16

# Security Switch States
MQSECSW_OFF_FOUND                        = 21
MQSECSW_ON_FOUND                         = 22
MQSECSW_OFF_NOT_FOUND                    = 23
MQSECSW_ON_NOT_FOUND                     = 24
MQSECSW_OFF_ERROR                        = 25
MQSECSW_ON_OVERRIDDEN                    = 26

# Security Types
MQSECTYPE_AUTHSERV                       = 1
MQSECTYPE_SSL                            = 2
MQSECTYPE_CLASSES                        = 3
MQSECTYPE_CONNAUTH                       = 4

# Authentication Validation Types
MQCHK_OPTIONAL                           = 0
MQCHK_NONE                               = 1
MQCHK_REQUIRED_ADMIN                     = 2
MQCHK_REQUIRED                           = 3
MQCHK_AS_Q_MGR                           = 4

# Authentication Adoption Context
MQADPCTX_NO                              = 0
MQADPCTX_YES                             = 1

# LDAP SSL/TLS Connection State
MQSECCOMM_NO                             = 0
MQSECCOMM_YES                            = 1
MQSECCOMM_ANON                           = 2

# LDAP Authorisation Method
MQLDAP_AUTHORMD_OS                       = 0
MQLDAP_AUTHORMD_SEARCHGRP                = 1
MQLDAP_AUTHORMD_SEARCHUSR                = 2
MQLDAP_AUTHORMD_SRCHGRPSN                = 3

# LDAP Nested Group Policy
MQLDAP_NESTGRP_NO                        = 0
MQLDAP_NESTGRP_YES                       = 1

# Authentication Method
MQAUTHENTICATE_OS                        = 0
MQAUTHENTICATE_PAM                       = 1

# QMgr LDAP Connection Status
MQLDAPC_INACTIVE                         = 0
MQLDAPC_CONNECTED                        = 1
MQLDAPC_ERROR                            = 2

# Selector types
MQSELTYPE_NONE                           = 0
MQSELTYPE_STANDARD                       = 1
MQSELTYPE_EXTENDED                       = 2

# CHLAUTH QMGR State
MQCHLA_DISABLED                          = 0
MQCHLA_ENABLED                           = 1

# REVDNS QMGR State
MQRDNS_ENABLED                           = 0
MQRDNS_DISABLED                          = 1

# CLROUTE Topic State
MQCLROUTE_DIRECT                         = 0
MQCLROUTE_TOPIC_HOST                     = 1
MQCLROUTE_NONE                           = 2

# CLSTATE Clustered Topic Definition State
MQCLST_ACTIVE                            = 0
MQCLST_PENDING                           = 1
MQCLST_INVALID                           = 2
MQCLST_ERROR                             = 3

# Transmission queue types
MQCLXQ_SCTQ                              = 0
MQCLXQ_CHANNEL                           = 1

# Suspend Status
MQSUS_YES                                = 1
MQSUS_NO                                 = 0

# Syncpoint values for Pub/Sub migration
MQSYNCPOINT_YES                          = 0
MQSYNCPOINT_IFPER                        = 1

# System Parameter Values
MQSYSP_NO                                = 0
MQSYSP_YES                               = 1
MQSYSP_EXTENDED                          = 2
MQSYSP_TYPE_INITIAL                      = 10
MQSYSP_TYPE_SET                          = 11
MQSYSP_TYPE_LOG_COPY                     = 12
MQSYSP_TYPE_LOG_STATUS                   = 13
MQSYSP_TYPE_ARCHIVE_TAPE                 = 14
MQSYSP_ALLOC_BLK                         = 20
MQSYSP_ALLOC_TRK                         = 21
MQSYSP_ALLOC_CYL                         = 22
MQSYSP_STATUS_BUSY                       = 30
MQSYSP_STATUS_PREMOUNT                   = 31
MQSYSP_STATUS_AVAILABLE                  = 32
MQSYSP_STATUS_UNKNOWN                    = 33
MQSYSP_STATUS_ALLOC_ARCHIVE              = 34
MQSYSP_STATUS_COPYING_BSDS               = 35
MQSYSP_STATUS_COPYING_LOG                = 36

# Export Type
MQEXT_ALL                                = 0
MQEXT_OBJECT                             = 1
MQEXT_AUTHORITY                          = 2

# Export Attrs
MQEXTATTRS_ALL                           = 0
MQEXTATTRS_NONDEF                        = 1

# System Objects
MQSYSOBJ_YES                             = 0
MQSYSOBJ_NO                              = 1

# Subscription Types
MQSUBTYPE_API                            = 1
MQSUBTYPE_ADMIN                          = 2
MQSUBTYPE_PROXY                          = 3
MQSUBTYPE_ALL                            = (-1)
MQSUBTYPE_USER                           = (-2)

# Display Subscription Types
MQDOPT_RESOLVED                          = 0
MQDOPT_DEFINED                           = 1

# Time units
MQTIME_UNIT_MINS                         = 0
MQTIME_UNIT_SECS                         = 1

# User ID Support
MQUIDSUPP_NO                             = 0
MQUIDSUPP_YES                            = 1

# Undelivered values for Pub/Sub migration
MQUNDELIVERED_NORMAL                     = 0
MQUNDELIVERED_SAFE                       = 1
MQUNDELIVERED_DISCARD                    = 2
MQUNDELIVERED_KEEP                       = 3

# UOW States
MQUOWST_NONE                             = 0
MQUOWST_ACTIVE                           = 1
MQUOWST_PREPARED                         = 2
MQUOWST_UNRESOLVED                       = 3

# UOW Types
MQUOWT_Q_MGR                             = 0
MQUOWT_CICS                              = 1
MQUOWT_RRS                               = 2
MQUOWT_IMS                               = 3
MQUOWT_XA                                = 4

# Page Set Usage Values
MQUSAGE_PS_AVAILABLE                     = 0
MQUSAGE_PS_DEFINED                       = 1
MQUSAGE_PS_OFFLINE                       = 2
MQUSAGE_PS_NOT_DEFINED                   = 3
MQUSAGE_PS_SUSPENDED                     = 4

# Expand Usage Values
MQUSAGE_EXPAND_USER                      = 1
MQUSAGE_EXPAND_SYSTEM                    = 2
MQUSAGE_EXPAND_NONE                      = 3

# Data Set Usage Values
MQUSAGE_DS_OLDEST_ACTIVE_UOW             = 10
MQUSAGE_DS_OLDEST_PS_RECOVERY            = 11
MQUSAGE_DS_OLDEST_CF_RECOVERY            = 12

# Multicast Properties Options
MQMCP_REPLY                              = 2
MQMCP_USER                               = 1
MQMCP_NONE                               = 0
MQMCP_ALL                                = (-1)
MQMCP_COMPAT                             = (-2)

# Multicast New Subscriber History Options
MQNSH_NONE                               = 0
MQNSH_ALL                                = (-1)

# Reduce Log Options
MQLR_ONE                                 = 1
MQLR_AUTO                                = (-1)
MQLR_MAX                                 = (-2)

# Automatic Cluster Types
MQAUTOCLUS_TYPE_NONE                     = 0
MQAUTOCLUS_TYPE_UNIFORM                  = 1

# File System Sharing Values
MQFS_SHARED                              = (-1)

# File System Encryption Values
MQFSENC_NO                               = 0
MQFSENC_YES                              = 1
MQFSENC_UNKNOWN                          = 2

# Log Types
MQLOGTYPE_CIRCULAR                       = 0
MQLOGTYPE_LINEAR                         = 1
MQLOGTYPE_REPLICATED                     = 2

# Native HA Active Connection Values
MQNHACONNACTV_NO                         = 0
MQNHACONNACTV_YES                        = 1

# Native HA Backlog Values
MQNHABACKLOG_UNKNOWN                     = (-1)

# Native HA Group Connected Values
MQNHACONNGRP_NO                          = 0
MQNHACONNGRP_YES                         = 1
MQNHACONNGRP_SUSPENDED                   = 2

# Native HA Group Roles
MQNHAGRPROLE_UNKNOWN                     = 0
MQNHAGRPROLE_NOT_CONFIGURED              = 1
MQNHAGRPROLE_LIVE                        = 2
MQNHAGRPROLE_RECOVERY                    = 3
MQNHAGRPROLE_PENDING_LIVE                = 4
MQNHAGRPROLE_PENDING_RECOVERY            = 5

# Native HA Instance Roles
MQNHAROLE_UNKNOWN                        = 0
MQNHAROLE_ACTIVE                         = 1
MQNHAROLE_REPLICA                        = 2
MQNHAROLE_LEADER                         = 3

# Native HA In Sync Values
MQNHAINSYNC_NO                           = 0
MQNHAINSYNC_YES                          = 1

# Native HA Status Values
MQNHASTATUS_UNKNOWN                      = 0
MQNHASTATUS_NORMAL                       = 1
MQNHASTATUS_CHECKING                     = 2
MQNHASTATUS_SYNCHRONIZING                = 3
MQNHASTATUS_REBASING                     = 4
MQNHASTATUS_DISK_FULL                    = 5
MQNHASTATUS_DISCONNECTED                 = 6
MQNHASTATUS_PARTITIONED                  = 7

# Native HA Types
MQNHATYPE_INSTANCE                       = 0
MQNHATYPE_GROUP                          = 1
MQNHATYPE_ALL                            = (-1)

#----------------------------------------------------------------#
# Values Related to Trace-route and Activity Operations          #
#----------------------------------------------------------------#
# Activity Operations
MQOPER_SYSTEM_FIRST                      = 0
MQOPER_UNKNOWN                           = 0
MQOPER_BROWSE                            = 1
MQOPER_DISCARD                           = 2
MQOPER_GET                               = 3
MQOPER_PUT                               = 4
MQOPER_PUT_REPLY                         = 5
MQOPER_PUT_REPORT                        = 6
MQOPER_RECEIVE                           = 7
MQOPER_SEND                              = 8
MQOPER_TRANSFORM                         = 9
MQOPER_PUBLISH                           = 10
MQOPER_EXCLUDED_PUBLISH                  = 11
MQOPER_DISCARDED_PUBLISH                 = 12
MQOPER_SYSTEM_LAST                       = 65535
MQOPER_APPL_FIRST                        = 65536
MQOPER_APPL_LAST                         = 999999999

# Trace-route Max Activities (MQIACF_MAX_ACTIVITIES)
MQROUTE_UNLIMITED_ACTIVITIES             = 0

# Trace-route Detail (MQIACF_ROUTE_DETAIL)
MQROUTE_DETAIL_LOW                       = 0x00000002
MQROUTE_DETAIL_MEDIUM                    = 0x00000008
MQROUTE_DETAIL_HIGH                      = 0x00000020

# Trace-route Forwarding (MQIACF_ROUTE_FORWARDING)
MQROUTE_FORWARD_ALL                      = 0x00000100
MQROUTE_FORWARD_IF_SUPPORTED             = 0x00000200
MQROUTE_FORWARD_REJ_UNSUP_MASK           = 0xffff0000

# Trace-route Delivery (MQIACF_ROUTE_DELIVERY)
MQROUTE_DELIVER_YES                      = 0x00001000
MQROUTE_DELIVER_NO                       = 0x00002000
MQROUTE_DELIVER_REJ_UNSUP_MASK           = 0xffff0000

# Trace-route Accumulation (MQIACF_ROUTE_ACCUMULATION)
MQROUTE_ACCUMULATE_NONE                  = 0x00010003
MQROUTE_ACCUMULATE_IN_MSG                = 0x00010004
MQROUTE_ACCUMULATE_AND_REPLY             = 0x00010005

#----------------------------------------------------------------#
# Values Related to Publish/Subscribe                            #
#----------------------------------------------------------------#
# Delete Options
MQDELO_NONE                              = 0x00000000
MQDELO_LOCAL                             = 0x00000004

# Publication Options
MQPUBO_NONE                              = 0x00000000
MQPUBO_CORREL_ID_AS_IDENTITY             = 0x00000001
MQPUBO_RETAIN_PUBLICATION                = 0x00000002
MQPUBO_OTHER_SUBSCRIBERS_ONLY            = 0x00000004
MQPUBO_NO_REGISTRATION                   = 0x00000008
MQPUBO_IS_RETAINED_PUBLICATION           = 0x00000010

# Registration Options
MQREGO_NONE                              = 0x00000000
MQREGO_CORREL_ID_AS_IDENTITY             = 0x00000001
MQREGO_ANONYMOUS                         = 0x00000002
MQREGO_LOCAL                             = 0x00000004
MQREGO_DIRECT_REQUESTS                   = 0x00000008
MQREGO_NEW_PUBLICATIONS_ONLY             = 0x00000010
MQREGO_PUBLISH_ON_REQUEST_ONLY           = 0x00000020
MQREGO_DEREGISTER_ALL                    = 0x00000040
MQREGO_INCLUDE_STREAM_NAME               = 0x00000080
MQREGO_INFORM_IF_RETAINED                = 0x00000100
MQREGO_DUPLICATES_OK                     = 0x00000200
MQREGO_NON_PERSISTENT                    = 0x00000400
MQREGO_PERSISTENT                        = 0x00000800
MQREGO_PERSISTENT_AS_PUBLISH             = 0x00001000
MQREGO_PERSISTENT_AS_Q                   = 0x00002000
MQREGO_ADD_NAME                          = 0x00004000
MQREGO_NO_ALTERATION                     = 0x00008000
MQREGO_FULL_RESPONSE                     = 0x00010000
MQREGO_JOIN_SHARED                       = 0x00020000
MQREGO_JOIN_EXCLUSIVE                    = 0x00040000
MQREGO_LEAVE_ONLY                        = 0x00080000
MQREGO_VARIABLE_USER_ID                  = 0x00100000
MQREGO_LOCKED                            = 0x00200000

# User Attribute Selectors
MQUA_FIRST                               = 65536
MQUA_LAST                                = 999999999

# Grouped Units of Recovery
MQGUR_DISABLED                           = 0
MQGUR_ENABLED                            = 1

# Measured usage by API
MQMULC_STANDARD                          = 0
MQMULC_REFINED                           = 1

# Multi-instance Queue Managers
MQSTDBY_NOT_PERMITTED                    = 0
MQSTDBY_PERMITTED                        = 1


#- end of CMQCFC -#

