"""

                      IBM MQ

   FILE NAME:      CMQSTRC

 -----------------------------------------------------------------

  <copyright
   notice="lm-source-program"
   pids="5724-H72"
   years="1993,2025"
   crc="0" >


   Licensed Materials - Property of IBM

   5724-H72

   (C) Copyright IBM Corp. 1993, 2025 All Rights Reserved.

   US Government Users Restricted Rights - Use, duplication or
   disclosure restricted by GSA ADP Schedule Contract with
   IBM Corp.
   </copyright>

  -----------------------------------------------------------------

   FUNCTION:       This file provides mappings between MQI
                   constant values and string versions of
                   their definitions.

   PROCESSOR:      Python

  -----------------------------------------------------------------
"""

"""
  -----------------------------------------------------------------
  <BEGIN_BUILDINFO>
  Generated on:  10/3/25, 11:37 AM
  Build Level:   p944-L251003
  Build Type:    Production
  <END_BUILDINFO>
  -----------------------------------------------------------------
"""

MQACTIVE_DICT = {
    0: "MQACTIVE_NO",
    1: "MQACTIVE_YES",
}

MQACTP_DICT = {
    0: "MQACTP_NEW",
    1: "MQACTP_FORWARD",
    2: "MQACTP_REPLY",
    3: "MQACTP_REPORT",
}

MQACTV_DICT = {
    1: "MQACTV_DETAIL_LOW",
    2: "MQACTV_DETAIL_MEDIUM",
    3: "MQACTV_DETAIL_HIGH",
}

MQACT_DICT = {
    1: "MQACT_FORCE_REMOVE",
    2: "MQACT_ADVANCE_LOG",
    3: "MQACT_COLLECT_STATISTICS",
    4: "MQACT_PUBSUB",
    5: "MQACT_ADD",
    6: "MQACT_REPLACE",
    7: "MQACT_REMOVE",
    8: "MQACT_REMOVEALL",
    9: "MQACT_FAIL",
    10: "MQACT_REDUCE_LOG",
    11: "MQACT_ARCHIVE_LOG",
}

MQADOPT_CHECK_DICT = {
    0: "MQADOPT_CHECK_NONE",
    1: "MQADOPT_CHECK_ALL",
    2: "MQADOPT_CHECK_Q_MGR_NAME",
    4: "MQADOPT_CHECK_NET_ADDR",
    8: "MQADOPT_CHECK_CHANNEL_NAME",
}

MQADOPT_TYPE_DICT = {
    0: "MQADOPT_TYPE_NO",
    1: "MQADOPT_TYPE_ALL",
    2: "MQADOPT_TYPE_SVR",
    4: "MQADOPT_TYPE_SDR",
    8: "MQADOPT_TYPE_RCVR",
    16: "MQADOPT_TYPE_CLUSRCVR",
}

MQADPCTX_DICT = {
    0: "MQADPCTX_NO",
    1: "MQADPCTX_YES",
}

MQAIT_DICT = {
    0: "MQAIT_ALL",
    1: "MQAIT_CRL_LDAP",
    2: "MQAIT_OCSP",
    3: "MQAIT_IDPW_OS",
    4: "MQAIT_IDPW_LDAP",
}

MQAPPL_DICT = {
    0: "MQAPPL_IMMOVABLE",
    1: "MQAPPL_MOVABLE",
}

MQAS_DICT = {
    0: "MQAS_NONE",
    1: "MQAS_STARTED",
    2: "MQAS_START_WAIT",
    3: "MQAS_STOPPED",
    4: "MQAS_SUSPENDED",
    5: "MQAS_SUSPENDED_TEMPORARY",
    6: "MQAS_ACTIVE",
    7: "MQAS_INACTIVE",
}

MQAT_DICT = {
    -1: "MQAT_UNKNOWN",
    0: "MQAT_NO_CONTEXT",
    1: "MQAT_CICS",
    2: "MQAT_ZOS",
    3: "MQAT_IMS",
    4: "MQAT_OS2",
    5: "MQAT_DOS",
    6: "MQAT_UNIX",
    7: "MQAT_QMGR",
    8: "MQAT_OS400",
    9: "MQAT_WINDOWS",
    10: "MQAT_CICS_VSE",
    11: "MQAT_WINDOWS_NT",
    12: "MQAT_VMS",
    13: "MQAT_NSK",
    14: "MQAT_VOS",
    15: "MQAT_OPEN_TP1",
    18: "MQAT_VM",
    19: "MQAT_IMS_BRIDGE",
    20: "MQAT_XCF",
    21: "MQAT_CICS_BRIDGE",
    22: "MQAT_NOTES_AGENT",
    23: "MQAT_TPF",
    25: "MQAT_USER",
    26: "MQAT_QMGR_PUBLISH",
    28: "MQAT_JAVA",
    29: "MQAT_DQM",
    30: "MQAT_CHANNEL_INITIATOR",
    31: "MQAT_WLM",
    32: "MQAT_BATCH",
    33: "MQAT_RRS_BATCH",
    34: "MQAT_SIB",
    35: "MQAT_SYSTEM_EXTENSION",
    36: "MQAT_MCAST_PUBLISH",
    37: "MQAT_AMQP",
}

MQAUSC_DICT = {
    0: "MQAUSC_FAILURES",
    1: "MQAUSC_ALLCONNS",
    2: "MQAUSC_ALLCHECKS",
}

MQAUTHENTICATE_DICT = {
    0: "MQAUTHENTICATE_OS",
    1: "MQAUTHENTICATE_PAM",
}

MQAUTHOPT_DICT = {
    1: "MQAUTHOPT_ENTITY_EXPLICIT",
    2: "MQAUTHOPT_ENTITY_SET",
    16: "MQAUTHOPT_NAME_EXPLICIT",
    32: "MQAUTHOPT_NAME_ALL_MATCHING",
    64: "MQAUTHOPT_NAME_AS_WILDCARD",
    256: "MQAUTHOPT_CUMULATIVE",
    512: "MQAUTHOPT_EXCLUDE_TEMP",
}

MQAUTH_DICT = {
    -3: "MQAUTH_ALL_MQI",
    -2: "MQAUTH_ALL_ADMIN",
    -1: "MQAUTH_ALL",
    0: "MQAUTH_NONE",
    1: "MQAUTH_ALT_USER_AUTHORITY",
    2: "MQAUTH_BROWSE",
    3: "MQAUTH_CHANGE",
    4: "MQAUTH_CLEAR",
    5: "MQAUTH_CONNECT",
    6: "MQAUTH_CREATE",
    7: "MQAUTH_DELETE",
    8: "MQAUTH_DISPLAY",
    9: "MQAUTH_INPUT",
    10: "MQAUTH_INQUIRE",
    11: "MQAUTH_OUTPUT",
    12: "MQAUTH_PASS_ALL_CONTEXT",
    13: "MQAUTH_PASS_IDENTITY_CONTEXT",
    14: "MQAUTH_SET",
    15: "MQAUTH_SET_ALL_CONTEXT",
    16: "MQAUTH_SET_IDENTITY_CONTEXT",
    17: "MQAUTH_CONTROL",
    18: "MQAUTH_CONTROL_EXTENDED",
    19: "MQAUTH_PUBLISH",
    20: "MQAUTH_SUBSCRIBE",
    21: "MQAUTH_RESUME",
    22: "MQAUTH_SYSTEM",
}

MQAUTOCLUS_DICT = {
    0: "MQAUTOCLUS_TYPE_NONE",
    1: "MQAUTOCLUS_TYPE_UNIFORM",
}

MQAUTO_DICT = {
    0: "MQAUTO_START_NO",
    1: "MQAUTO_START_YES",
}

MQBACF_DICT = {
    7001: "MQBACF_EVENT_ACCOUNTING_TOKEN",
    7002: "MQBACF_EVENT_SECURITY_ID",
    7003: "MQBACF_RESPONSE_SET",
    7004: "MQBACF_RESPONSE_ID",
    7005: "MQBACF_EXTERNAL_UOW_ID",
    7006: "MQBACF_CONNECTION_ID",
    7007: "MQBACF_GENERIC_CONNECTION_ID",
    7008: "MQBACF_ORIGIN_UOW_ID",
    7009: "MQBACF_Q_MGR_UOW_ID",
    7010: "MQBACF_ACCOUNTING_TOKEN",
    7011: "MQBACF_CORREL_ID",
    7012: "MQBACF_GROUP_ID",
    7013: "MQBACF_MSG_ID",
    7014: "MQBACF_CF_LEID",
    7015: "MQBACF_DESTINATION_CORREL_ID",
    7016: "MQBACF_SUB_ID",
    7019: "MQBACF_ALTERNATE_SECURITYID",
    7020: "MQBACF_MESSAGE_DATA",
    7021: "MQBACF_MQBO_STRUCT",
    7022: "MQBACF_MQCB_FUNCTION",
    7023: "MQBACF_MQCBC_STRUCT",
    7024: "MQBACF_MQCBD_STRUCT",
    7025: "MQBACF_MQCD_STRUCT",
    7026: "MQBACF_MQCNO_STRUCT",
    7027: "MQBACF_MQGMO_STRUCT",
    7028: "MQBACF_MQMD_STRUCT",
    7029: "MQBACF_MQPMO_STRUCT",
    7030: "MQBACF_MQSD_STRUCT",
    7031: "MQBACF_MQSTS_STRUCT",
    7032: "MQBACF_SUB_CORREL_ID",
    7033: "MQBACF_XA_XID",
    7034: "MQBACF_XQH_CORREL_ID",
    7035: "MQBACF_XQH_MSG_ID",
    7036: "MQBACF_REQUEST_ID",
    7037: "MQBACF_PROPERTIES_DATA",
    7038: "MQBACF_CONN_TAG",
    7039: "MQBACF_MQBNO_STRUCT",
}

MQBALANCED_DICT = {
    0: "MQBALANCED_NO",
    1: "MQBALANCED_YES",
    2: "MQBALANCED_NOT_APPLICABLE",
    3: "MQBALANCED_UNKNOWN",
}

MQBALSTATE_DICT = {
    0: "MQBALSTATE_NOT_APPLICABLE",
    1: "MQBALSTATE_LOW",
    2: "MQBALSTATE_OK",
    3: "MQBALSTATE_HIGH",
    4: "MQBALSTATE_UNKNOWN",
}

MQBL_DICT = {
    -1: "MQBL_NULL_TERMINATED",
}

MQBMHO_DICT = {
    0: "MQBMHO_NONE",
    1: "MQBMHO_DELETE_PROPERTIES",
}

MQBND_DICT = {
    0: "MQBND_BIND_ON_OPEN",
    1: "MQBND_BIND_NOT_FIXED",
    2: "MQBND_BIND_ON_GROUP",
}

MQBNO_BALTYPE_DICT = {
    0: "MQBNO_BALTYPE_SIMPLE",
    1: "MQBNO_BALTYPE_REQREP",
    65536: "MQBNO_BALTYPE_RA_MANAGED",
}

MQBNO_OPTIONS_DICT = {
    0: "MQBNO_OPTIONS_NONE",
    1: "MQBNO_OPTIONS_IGNORE_TRANS",
}

MQBNO_TIMEOUT_DICT = {
    -2: "MQBNO_TIMEOUT_NEVER",
    -1: "MQBNO_TIMEOUT_AS_DEFAULT",
    0: "MQBNO_TIMEOUT_IMMEDIATE",
}

MQBO_DICT = {
    0: "MQBO_NONE",
}

MQBPLOCATION_DICT = {
    0: "MQBPLOCATION_BELOW",
    1: "MQBPLOCATION_ABOVE",
    2: "MQBPLOCATION_SWITCHING_ABOVE",
    3: "MQBPLOCATION_SWITCHING_BELOW",
}

MQBT_DICT = {
    1: "MQBT_OTMA",
}

MQCACF_DICT = {
    3001: "MQCACF_FROM_Q_NAME",
    3002: "MQCACF_TO_Q_NAME",
    3003: "MQCACF_FROM_PROCESS_NAME",
    3004: "MQCACF_TO_PROCESS_NAME",
    3005: "MQCACF_FROM_NAMELIST_NAME",
    3006: "MQCACF_TO_NAMELIST_NAME",
    3007: "MQCACF_FROM_CHANNEL_NAME",
    3008: "MQCACF_TO_CHANNEL_NAME",
    3009: "MQCACF_FROM_AUTH_INFO_NAME",
    3010: "MQCACF_TO_AUTH_INFO_NAME",
    3011: "MQCACF_Q_NAMES",
    3012: "MQCACF_PROCESS_NAMES",
    3013: "MQCACF_NAMELIST_NAMES",
    3014: "MQCACF_ESCAPE_TEXT",
    3015: "MQCACF_LOCAL_Q_NAMES",
    3016: "MQCACF_MODEL_Q_NAMES",
    3017: "MQCACF_ALIAS_Q_NAMES",
    3018: "MQCACF_REMOTE_Q_NAMES",
    3019: "MQCACF_SENDER_CHANNEL_NAMES",
    3020: "MQCACF_SERVER_CHANNEL_NAMES",
    3021: "MQCACF_REQUESTER_CHANNEL_NAMES",
    3022: "MQCACF_RECEIVER_CHANNEL_NAMES",
    3023: "MQCACF_OBJECT_Q_MGR_NAME",
    3024: "MQCACF_APPL_NAME",
    3025: "MQCACF_USER_IDENTIFIER",
    3026: "MQCACF_AUX_ERROR_DATA_STR_1",
    3027: "MQCACF_AUX_ERROR_DATA_STR_2",
    3028: "MQCACF_AUX_ERROR_DATA_STR_3",
    3029: "MQCACF_BRIDGE_NAME",
    3030: "MQCACF_STREAM_NAME",
    3031: "MQCACF_TOPIC",
    3032: "MQCACF_PARENT_Q_MGR_NAME",
    3033: "MQCACF_CORREL_ID",
    3034: "MQCACF_PUBLISH_TIMESTAMP",
    3035: "MQCACF_STRING_DATA",
    3036: "MQCACF_SUPPORTED_STREAM_NAME",
    3037: "MQCACF_REG_TOPIC",
    3038: "MQCACF_REG_TIME",
    3039: "MQCACF_REG_USER_ID",
    3040: "MQCACF_CHILD_Q_MGR_NAME",
    3041: "MQCACF_REG_STREAM_NAME",
    3042: "MQCACF_REG_Q_MGR_NAME",
    3043: "MQCACF_REG_Q_NAME",
    3044: "MQCACF_REG_CORREL_ID",
    3045: "MQCACF_EVENT_USER_ID",
    3046: "MQCACF_OBJECT_NAME",
    3047: "MQCACF_EVENT_Q_MGR",
    3048: "MQCACF_AUTH_INFO_NAMES",
    3049: "MQCACF_EVENT_APPL_IDENTITY",
    3050: "MQCACF_EVENT_APPL_NAME",
    3051: "MQCACF_EVENT_APPL_ORIGIN",
    3052: "MQCACF_SUBSCRIPTION_NAME",
    3053: "MQCACF_REG_SUB_NAME",
    3054: "MQCACF_SUBSCRIPTION_IDENTITY",
    3055: "MQCACF_REG_SUB_IDENTITY",
    3056: "MQCACF_SUBSCRIPTION_USER_DATA",
    3057: "MQCACF_REG_SUB_USER_DATA",
    3058: "MQCACF_APPL_TAG",
    3059: "MQCACF_DATA_SET_NAME",
    3060: "MQCACF_UOW_START_DATE",
    3061: "MQCACF_UOW_START_TIME",
    3062: "MQCACF_UOW_LOG_START_DATE",
    3063: "MQCACF_UOW_LOG_START_TIME",
    3064: "MQCACF_UOW_LOG_EXTENT_NAME",
    3065: "MQCACF_PRINCIPAL_ENTITY_NAMES",
    3066: "MQCACF_GROUP_ENTITY_NAMES",
    3067: "MQCACF_AUTH_PROFILE_NAME",
    3068: "MQCACF_ENTITY_NAME",
    3069: "MQCACF_SERVICE_COMPONENT",
    3070: "MQCACF_RESPONSE_Q_MGR_NAME",
    3071: "MQCACF_CURRENT_LOG_EXTENT_NAME",
    3072: "MQCACF_RESTART_LOG_EXTENT_NAME",
    3073: "MQCACF_MEDIA_LOG_EXTENT_NAME",
    3074: "MQCACF_LOG_PATH",
    3075: "MQCACF_COMMAND_MQSC",
    3076: "MQCACF_Q_MGR_CPF",
    3078: "MQCACF_USAGE_LOG_RBA",
    3079: "MQCACF_USAGE_LOG_LRSN",
    3080: "MQCACF_COMMAND_SCOPE",
    3081: "MQCACF_ASID",
    3082: "MQCACF_PSB_NAME",
    3083: "MQCACF_PST_ID",
    3084: "MQCACF_TASK_NUMBER",
    3085: "MQCACF_TRANSACTION_ID",
    3086: "MQCACF_Q_MGR_UOW_ID",
    3088: "MQCACF_ORIGIN_NAME",
    3089: "MQCACF_ENV_INFO",
    3090: "MQCACF_SECURITY_PROFILE",
    3091: "MQCACF_CONFIGURATION_DATE",
    3092: "MQCACF_CONFIGURATION_TIME",
    3093: "MQCACF_FROM_CF_STRUC_NAME",
    3094: "MQCACF_TO_CF_STRUC_NAME",
    3095: "MQCACF_CF_STRUC_NAMES",
    3096: "MQCACF_FAIL_DATE",
    3097: "MQCACF_FAIL_TIME",
    3098: "MQCACF_BACKUP_DATE",
    3099: "MQCACF_BACKUP_TIME",
    3100: "MQCACF_SYSTEM_NAME",
    3101: "MQCACF_CF_STRUC_BACKUP_START",
    3102: "MQCACF_CF_STRUC_BACKUP_END",
    3103: "MQCACF_CF_STRUC_LOG_Q_MGRS",
    3104: "MQCACF_FROM_STORAGE_CLASS",
    3105: "MQCACF_TO_STORAGE_CLASS",
    3106: "MQCACF_STORAGE_CLASS_NAMES",
    3108: "MQCACF_DSG_NAME",
    3109: "MQCACF_DB2_NAME",
    3110: "MQCACF_SYSP_CMD_USER_ID",
    3111: "MQCACF_SYSP_OTMA_GROUP",
    3112: "MQCACF_SYSP_OTMA_MEMBER",
    3113: "MQCACF_SYSP_OTMA_DRU_EXIT",
    3114: "MQCACF_SYSP_OTMA_TPIPE_PFX",
    3115: "MQCACF_SYSP_ARCHIVE_PFX1",
    3116: "MQCACF_SYSP_ARCHIVE_UNIT1",
    3117: "MQCACF_SYSP_LOG_CORREL_ID",
    3118: "MQCACF_SYSP_UNIT_VOLSER",
    3119: "MQCACF_SYSP_Q_MGR_TIME",
    3120: "MQCACF_SYSP_Q_MGR_DATE",
    3121: "MQCACF_SYSP_Q_MGR_RBA",
    3122: "MQCACF_SYSP_LOG_RBA",
    3123: "MQCACF_SYSP_SERVICE",
    3124: "MQCACF_FROM_LISTENER_NAME",
    3125: "MQCACF_TO_LISTENER_NAME",
    3126: "MQCACF_FROM_SERVICE_NAME",
    3127: "MQCACF_TO_SERVICE_NAME",
    3128: "MQCACF_LAST_PUT_DATE",
    3129: "MQCACF_LAST_PUT_TIME",
    3130: "MQCACF_LAST_GET_DATE",
    3131: "MQCACF_LAST_GET_TIME",
    3132: "MQCACF_OPERATION_DATE",
    3133: "MQCACF_OPERATION_TIME",
    3134: "MQCACF_ACTIVITY_DESC",
    3135: "MQCACF_APPL_IDENTITY_DATA",
    3136: "MQCACF_APPL_ORIGIN_DATA",
    3137: "MQCACF_PUT_DATE",
    3138: "MQCACF_PUT_TIME",
    3139: "MQCACF_REPLY_TO_Q",
    3140: "MQCACF_REPLY_TO_Q_MGR",
    3141: "MQCACF_RESOLVED_Q_NAME",
    3142: "MQCACF_STRUC_ID",
    3143: "MQCACF_VALUE_NAME",
    3144: "MQCACF_SERVICE_START_DATE",
    3145: "MQCACF_SERVICE_START_TIME",
    3146: "MQCACF_SYSP_OFFLINE_RBA",
    3147: "MQCACF_SYSP_ARCHIVE_PFX2",
    3148: "MQCACF_SYSP_ARCHIVE_UNIT2",
    3149: "MQCACF_TO_TOPIC_NAME",
    3150: "MQCACF_FROM_TOPIC_NAME",
    3151: "MQCACF_TOPIC_NAMES",
    3152: "MQCACF_SUB_NAME",
    3153: "MQCACF_DESTINATION_Q_MGR",
    3154: "MQCACF_DESTINATION",
    3156: "MQCACF_SUB_USER_ID",
    3159: "MQCACF_SUB_USER_DATA",
    3160: "MQCACF_SUB_SELECTOR",
    3161: "MQCACF_LAST_PUB_DATE",
    3162: "MQCACF_LAST_PUB_TIME",
    3163: "MQCACF_FROM_SUB_NAME",
    3164: "MQCACF_TO_SUB_NAME",
    3167: "MQCACF_LAST_MSG_TIME",
    3168: "MQCACF_LAST_MSG_DATE",
    3169: "MQCACF_SUBSCRIPTION_POINT",
    3170: "MQCACF_FILTER",
    3171: "MQCACF_NONE",
    3172: "MQCACF_ADMIN_TOPIC_NAMES",
    3173: "MQCACF_ROUTING_FINGER_PRINT",
    3174: "MQCACF_APPL_DESC",
    3175: "MQCACF_Q_MGR_START_DATE",
    3176: "MQCACF_Q_MGR_START_TIME",
    3177: "MQCACF_FROM_COMM_INFO_NAME",
    3178: "MQCACF_TO_COMM_INFO_NAME",
    3179: "MQCACF_CF_OFFLOAD_SIZE1",
    3180: "MQCACF_CF_OFFLOAD_SIZE2",
    3181: "MQCACF_CF_OFFLOAD_SIZE3",
    3182: "MQCACF_CF_SMDS_GENERIC_NAME",
    3183: "MQCACF_CF_SMDS",
    3184: "MQCACF_RECOVERY_DATE",
    3185: "MQCACF_RECOVERY_TIME",
    3186: "MQCACF_CF_SMDSCONN",
    3187: "MQCACF_CF_STRUC_NAME",
    3188: "MQCACF_ALTERNATE_USERID",
    3189: "MQCACF_CHAR_ATTRS",
    3190: "MQCACF_DYNAMIC_Q_NAME",
    3191: "MQCACF_HOST_NAME",
    3192: "MQCACF_MQCB_NAME",
    3193: "MQCACF_OBJECT_STRING",
    3194: "MQCACF_RESOLVED_LOCAL_Q_MGR",
    3195: "MQCACF_RESOLVED_LOCAL_Q_NAME",
    3196: "MQCACF_RESOLVED_OBJECT_STRING",
    3197: "MQCACF_RESOLVED_Q_MGR",
    3198: "MQCACF_SELECTION_STRING",
    3199: "MQCACF_XA_INFO",
    3200: "MQCACF_APPL_FUNCTION",
    3201: "MQCACF_XQH_REMOTE_Q_NAME",
    3202: "MQCACF_XQH_REMOTE_Q_MGR",
    3203: "MQCACF_XQH_PUT_TIME",
    3204: "MQCACF_XQH_PUT_DATE",
    3205: "MQCACF_EXCL_OPERATOR_MESSAGES",
    3206: "MQCACF_CSP_USER_IDENTIFIER",
    3207: "MQCACF_AMQP_CLIENT_ID",
    3208: "MQCACF_ARCHIVE_LOG_EXTENT_NAME",
    3209: "MQCACF_APPL_IMMOVABLE_DATE",
    3210: "MQCACF_APPL_IMMOVABLE_TIME",
    3211: "MQCACF_NHA_INSTANCE_NAME",
    3212: "MQCACF_Q_MGR_DATA_PATH",
    3213: "MQCACF_UNIFORM_CLUSTER_NAME",
    3214: "MQCACF_LOG_START_DATE",
    3215: "MQCACF_LOG_START_LSN",
    3216: "MQCACF_LOG_START_TIME",
    3217: "MQCACF_NHA_GROUP_INITIAL_DATE",
    3218: "MQCACF_NHA_GROUP_INITIAL_LSN",
    3219: "MQCACF_NHA_GROUP_INITIAL_TIME",
    3220: "MQCACF_NHA_REPL_ADDRESS",
    3221: "MQCACF_DISK_WRITTEN_LSN",
    3222: "MQCACF_NHA_ACKNOWLEDGED_LSN",
    3223: "MQCACF_NHA_GROUP_ADDRESS",
    3224: "MQCACF_NHA_GROUP_SYNC_ISOTIME",
    3225: "MQCACF_NHA_GROUP_INIT_ISOTIME",
    3226: "MQCACF_NHA_GROUP_LIVE_ISOTIME",
    3227: "MQCACF_NHA_GROUP_LSN",
    3228: "MQCACF_NHA_GROUP_NAME",
    3229: "MQCACF_NHA_GROUP_RECOV_LSN",
    3230: "MQCACF_NHA_GROUP_RECOV_ISOTIME",
    3231: "MQCACF_NHA_SYNC_ISOTIME",
    3232: "MQCACF_EVENT_DUPLICATE_FROM",
}

MQCACH_DICT = {
    3501: "MQCACH_CHANNEL_NAME",
    3502: "MQCACH_DESC",
    3503: "MQCACH_MODE_NAME",
    3504: "MQCACH_TP_NAME",
    3505: "MQCACH_XMIT_Q_NAME",
    3506: "MQCACH_CONNECTION_NAME",
    3507: "MQCACH_MCA_NAME",
    3508: "MQCACH_SEC_EXIT_NAME",
    3509: "MQCACH_MSG_EXIT_NAME",
    3510: "MQCACH_SEND_EXIT_NAME",
    3511: "MQCACH_RCV_EXIT_NAME",
    3512: "MQCACH_CHANNEL_NAMES",
    3513: "MQCACH_SEC_EXIT_USER_DATA",
    3514: "MQCACH_MSG_EXIT_USER_DATA",
    3515: "MQCACH_SEND_EXIT_USER_DATA",
    3516: "MQCACH_RCV_EXIT_USER_DATA",
    3517: "MQCACH_USER_ID",
    3518: "MQCACH_PASSWORD",
    3520: "MQCACH_LOCAL_ADDRESS",
    3521: "MQCACH_LOCAL_NAME",
    3524: "MQCACH_LAST_MSG_TIME",
    3525: "MQCACH_LAST_MSG_DATE",
    3527: "MQCACH_MCA_USER_ID",
    3528: "MQCACH_CHANNEL_START_TIME",
    3529: "MQCACH_CHANNEL_START_DATE",
    3530: "MQCACH_MCA_JOB_NAME",
    3531: "MQCACH_LAST_LUWID",
    3532: "MQCACH_CURRENT_LUWID",
    3533: "MQCACH_FORMAT_NAME",
    3534: "MQCACH_MR_EXIT_NAME",
    3535: "MQCACH_MR_EXIT_USER_DATA",
    3544: "MQCACH_SSL_CIPHER_SPEC",
    3545: "MQCACH_SSL_PEER_NAME",
    3546: "MQCACH_SSL_HANDSHAKE_STAGE",
    3547: "MQCACH_SSL_SHORT_PEER_NAME",
    3548: "MQCACH_REMOTE_APPL_TAG",
    3549: "MQCACH_SSL_CERT_USER_ID",
    3550: "MQCACH_SSL_CERT_ISSUER_NAME",
    3551: "MQCACH_LU_NAME",
    3552: "MQCACH_IP_ADDRESS",
    3553: "MQCACH_TCP_NAME",
    3554: "MQCACH_LISTENER_NAME",
    3555: "MQCACH_LISTENER_DESC",
    3556: "MQCACH_LISTENER_START_DATE",
    3557: "MQCACH_LISTENER_START_TIME",
    3558: "MQCACH_SSL_KEY_RESET_DATE",
    3559: "MQCACH_SSL_KEY_RESET_TIME",
    3560: "MQCACH_REMOTE_VERSION",
    3561: "MQCACH_REMOTE_PRODUCT",
    3562: "MQCACH_GROUP_ADDRESS",
    3563: "MQCACH_JAAS_CONFIG",
    3564: "MQCACH_CLIENT_ID",
    3565: "MQCACH_SSL_KEY_PASSPHRASE",
    3566: "MQCACH_CONNECTION_NAME_LIST",
    3567: "MQCACH_CLIENT_USER_ID",
    3568: "MQCACH_MCA_USER_ID_LIST",
    3569: "MQCACH_SSL_CIPHER_SUITE",
    3570: "MQCACH_WEBCONTENT_PATH",
    3571: "MQCACH_TOPIC_ROOT",
    3572: "MQCACH_TEMPORARY_MODEL_Q",
    3573: "MQCACH_TEMPORARY_Q_PREFIX",
}

MQCADSD_DICT = {
    0: "MQCADSD_NONE",
    1: "MQCADSD_SEND",
    16: "MQCADSD_RECV",
    256: "MQCADSD_MSGFORMAT",
}

MQCAFTY_DICT = {
    0: "MQCAFTY_NONE",
    1: "MQCAFTY_PREFERRED",
}

MQCAMO_DICT = {
    2701: "MQCAMO_CLOSE_DATE",
    2702: "MQCAMO_CLOSE_TIME",
    2703: "MQCAMO_CONN_DATE",
    2704: "MQCAMO_CONN_TIME",
    2705: "MQCAMO_DISC_DATE",
    2706: "MQCAMO_DISC_TIME",
    2707: "MQCAMO_END_DATE",
    2708: "MQCAMO_END_TIME",
    2709: "MQCAMO_OPEN_DATE",
    2710: "MQCAMO_OPEN_TIME",
    2711: "MQCAMO_START_DATE",
    2712: "MQCAMO_START_TIME",
    2713: "MQCAMO_MONITOR_CLASS",
    2714: "MQCAMO_MONITOR_TYPE",
    2715: "MQCAMO_MONITOR_DESC",
}

MQCAP_DICT = {
    0: "MQCAP_NOT_SUPPORTED",
    1: "MQCAP_SUPPORTED",
    2: "MQCAP_EXPIRED",
}

MQCAUT_DICT = {
    0: "MQCAUT_ALL",
    1: "MQCAUT_BLOCKUSER",
    2: "MQCAUT_BLOCKADDR",
    3: "MQCAUT_SSLPEERMAP",
    4: "MQCAUT_ADDRESSMAP",
    5: "MQCAUT_USERMAP",
    6: "MQCAUT_QMGRMAP",
}

MQCA_DICT = {
    2001: "MQCA_APPL_ID",
    2002: "MQCA_BASE_OBJECT_NAME",
    2003: "MQCA_COMMAND_INPUT_Q_NAME",
    2004: "MQCA_CREATION_DATE",
    2005: "MQCA_CREATION_TIME",
    2006: "MQCA_DEAD_LETTER_Q_NAME",
    2007: "MQCA_ENV_DATA",
    2008: "MQCA_INITIATION_Q_NAME",
    2009: "MQCA_NAMELIST_DESC",
    2010: "MQCA_NAMELIST_NAME",
    2011: "MQCA_PROCESS_DESC",
    2012: "MQCA_PROCESS_NAME",
    2013: "MQCA_Q_DESC",
    2014: "MQCA_Q_MGR_DESC",
    2015: "MQCA_Q_MGR_NAME",
    2016: "MQCA_Q_NAME",
    2017: "MQCA_REMOTE_Q_MGR_NAME",
    2018: "MQCA_REMOTE_Q_NAME",
    2019: "MQCA_BACKOUT_REQ_Q_NAME",
    2020: "MQCA_NAMES",
    2021: "MQCA_USER_DATA",
    2022: "MQCA_STORAGE_CLASS",
    2023: "MQCA_TRIGGER_DATA",
    2024: "MQCA_XMIT_Q_NAME",
    2025: "MQCA_DEF_XMIT_Q_NAME",
    2026: "MQCA_CHANNEL_AUTO_DEF_EXIT",
    2027: "MQCA_ALTERATION_DATE",
    2028: "MQCA_ALTERATION_TIME",
    2029: "MQCA_CLUSTER_NAME",
    2030: "MQCA_CLUSTER_NAMELIST",
    2031: "MQCA_CLUSTER_Q_MGR_NAME",
    2032: "MQCA_Q_MGR_IDENTIFIER",
    2033: "MQCA_CLUSTER_WORKLOAD_EXIT",
    2034: "MQCA_CLUSTER_WORKLOAD_DATA",
    2035: "MQCA_REPOSITORY_NAME",
    2036: "MQCA_REPOSITORY_NAMELIST",
    2037: "MQCA_CLUSTER_DATE",
    2038: "MQCA_CLUSTER_TIME",
    2039: "MQCA_CF_STRUC_NAME",
    2040: "MQCA_QSG_NAME",
    2041: "MQCA_IGQ_USER_ID",
    2042: "MQCA_STORAGE_CLASS_DESC",
    2043: "MQCA_XCF_GROUP_NAME",
    2044: "MQCA_XCF_MEMBER_NAME",
    2045: "MQCA_AUTH_INFO_NAME",
    2046: "MQCA_AUTH_INFO_DESC",
    2047: "MQCA_LDAP_USER_NAME",
    2048: "MQCA_LDAP_PASSWORD",
    2049: "MQCA_SSL_KEY_REPOSITORY",
    2050: "MQCA_SSL_CRL_NAMELIST",
    2051: "MQCA_SSL_CRYPTO_HARDWARE",
    2052: "MQCA_CF_STRUC_DESC",
    2053: "MQCA_AUTH_INFO_CONN_NAME",
    2054: "MQCA_INITIAL_KEY",
    2055: "MQCA_SSL_KEY_REPO_PASSWORD",
    2060: "MQCA_CICS_FILE_NAME",
    2061: "MQCA_TRIGGER_TRANS_ID",
    2062: "MQCA_TRIGGER_PROGRAM_NAME",
    2063: "MQCA_TRIGGER_TERM_ID",
    2064: "MQCA_TRIGGER_CHANNEL_NAME",
    2065: "MQCA_SYSTEM_LOG_Q_NAME",
    2066: "MQCA_MONITOR_Q_NAME",
    2067: "MQCA_COMMAND_REPLY_Q_NAME",
    2068: "MQCA_BATCH_INTERFACE_ID",
    2069: "MQCA_SSL_KEY_LIBRARY",
    2070: "MQCA_SSL_KEY_MEMBER",
    2071: "MQCA_DNS_GROUP",
    2072: "MQCA_LU_GROUP_NAME",
    2073: "MQCA_LU_NAME",
    2074: "MQCA_LU62_ARM_SUFFIX",
    2075: "MQCA_TCP_NAME",
    2076: "MQCA_CHINIT_SERVICE_PARM",
    2077: "MQCA_SERVICE_NAME",
    2078: "MQCA_SERVICE_DESC",
    2079: "MQCA_SERVICE_START_COMMAND",
    2080: "MQCA_SERVICE_START_ARGS",
    2081: "MQCA_SERVICE_STOP_COMMAND",
    2082: "MQCA_SERVICE_STOP_ARGS",
    2083: "MQCA_STDOUT_DESTINATION",
    2084: "MQCA_STDERR_DESTINATION",
    2085: "MQCA_TPIPE_NAME",
    2086: "MQCA_PASS_TICKET_APPL",
    2090: "MQCA_AUTO_REORG_START_TIME",
    2091: "MQCA_AUTO_REORG_CATALOG",
    2092: "MQCA_TOPIC_NAME",
    2093: "MQCA_TOPIC_DESC",
    2094: "MQCA_TOPIC_STRING",
    2096: "MQCA_MODEL_DURABLE_Q",
    2097: "MQCA_MODEL_NON_DURABLE_Q",
    2098: "MQCA_RESUME_DATE",
    2099: "MQCA_RESUME_TIME",
    2101: "MQCA_CHILD",
    2102: "MQCA_PARENT",
    2105: "MQCA_ADMIN_TOPIC_NAME",
    2108: "MQCA_TOPIC_STRING_FILTER",
    2109: "MQCA_AUTH_INFO_OCSP_URL",
    2110: "MQCA_COMM_INFO_NAME",
    2111: "MQCA_COMM_INFO_DESC",
    2112: "MQCA_POLICY_NAME",
    2113: "MQCA_SIGNER_DN",
    2114: "MQCA_RECIPIENT_DN",
    2115: "MQCA_INSTALLATION_DESC",
    2116: "MQCA_INSTALLATION_NAME",
    2117: "MQCA_INSTALLATION_PATH",
    2118: "MQCA_CHLAUTH_DESC",
    2119: "MQCA_CUSTOM",
    2120: "MQCA_VERSION",
    2121: "MQCA_CERT_LABEL",
    2122: "MQCA_XR_VERSION",
    2123: "MQCA_XR_SSL_CIPHER_SUITES",
    2124: "MQCA_CLUS_CHL_NAME",
    2125: "MQCA_CONN_AUTH",
    2126: "MQCA_LDAP_BASE_DN_USERS",
    2127: "MQCA_LDAP_SHORT_USER_FIELD",
    2128: "MQCA_LDAP_USER_OBJECT_CLASS",
    2129: "MQCA_LDAP_USER_ATTR_FIELD",
    2130: "MQCA_SSL_CERT_ISSUER_NAME",
    2131: "MQCA_QSG_CERT_LABEL",
    2132: "MQCA_LDAP_BASE_DN_GROUPS",
    2133: "MQCA_LDAP_GROUP_OBJECT_CLASS",
    2134: "MQCA_LDAP_GROUP_ATTR_FIELD",
    2135: "MQCA_LDAP_FIND_GROUP_FIELD",
    2136: "MQCA_AMQP_VERSION",
    2137: "MQCA_AMQP_SSL_CIPHER_SUITES",
    2138: "MQCA_STREAM_QUEUE_NAME",
    4000: "MQCA_USER_LIST",
}

MQCBCF_DICT = {
    0: "MQCBCF_NONE",
    1: "MQCBCF_READA_BUFFER_EMPTY",
}

MQCBCT_DICT = {
    1: "MQCBCT_START_CALL",
    2: "MQCBCT_STOP_CALL",
    3: "MQCBCT_REGISTER_CALL",
    4: "MQCBCT_DEREGISTER_CALL",
    5: "MQCBCT_EVENT_CALL",
    6: "MQCBCT_MSG_REMOVED",
    7: "MQCBCT_MSG_NOT_REMOVED",
    8: "MQCBCT_MC_EVENT_CALL",
}

MQCBDO_DICT = {
    0: "MQCBDO_NONE",
    1: "MQCBDO_START_CALL",
    4: "MQCBDO_STOP_CALL",
    256: "MQCBDO_REGISTER_CALL",
    512: "MQCBDO_DEREGISTER_CALL",
    8192: "MQCBDO_FAIL_IF_QUIESCING",
    16384: "MQCBDO_EVENT_CALL",
    32768: "MQCBDO_MC_EVENT_CALL",
}

MQCBD_DICT = {
    -1: "MQCBD_FULL_MSG_LENGTH",
}

MQCBO_DICT = {
    0: "MQCBO_NONE",
    1: "MQCBO_ADMIN_BAG",
    2: "MQCBO_LIST_FORM_ALLOWED",
    4: "MQCBO_REORDER_AS_REQUIRED",
    8: "MQCBO_CHECK_SELECTORS",
    16: "MQCBO_COMMAND_BAG",
    32: "MQCBO_SYSTEM_BAG",
    64: "MQCBO_GROUP_BAG",
}

MQCBT_DICT = {
    1: "MQCBT_MESSAGE_CONSUMER",
    2: "MQCBT_EVENT_HANDLER",
}

MQCCSI_DICT = {
    -4: "MQCCSI_AS_PUBLISHED",
    -3: "MQCCSI_APPL",
    -2: "MQCCSI_INHERIT",
    -1: "MQCCSI_EMBEDDED",
    0: "MQCCSI_DEFAULT",
}

MQCCT_DICT = {
    0: "MQCCT_NO",
    1: "MQCCT_YES",
}

MQCC_DICT = {
    -1: "MQCC_UNKNOWN",
    0: "MQCC_OK",
    1: "MQCC_WARNING",
    2: "MQCC_FAILED",
}

MQCDC_DICT = {
    0: "MQCDC_NO_SENDER_CONVERSION",
    1: "MQCDC_SENDER_CONVERSION",
}

MQCEX_DICT = {
    -2: "MQCEX_AS_PARENT",
    -1: "MQCEX_NOLIMIT",
}

MQCFACCESS_DICT = {
    0: "MQCFACCESS_ENABLED",
    1: "MQCFACCESS_SUSPENDED",
    2: "MQCFACCESS_DISABLED",
}

MQCFCONLOS_DICT = {
    0: "MQCFCONLOS_TERMINATE",
    1: "MQCFCONLOS_TOLERATE",
    2: "MQCFCONLOS_ASQMGR",
}

MQCFC_DICT = {
    0: "MQCFC_NOT_LAST",
    1: "MQCFC_LAST",
}

MQCFOFFLD_DICT = {
    0: "MQCFOFFLD_NONE",
    1: "MQCFOFFLD_SMDS",
    2: "MQCFOFFLD_DB2",
    3: "MQCFOFFLD_BOTH",
}

MQCFOP_DICT = {
    1: "MQCFOP_LESS",
    2: "MQCFOP_EQUAL",
    3: "MQCFOP_NOT_GREATER",
    4: "MQCFOP_GREATER",
    5: "MQCFOP_NOT_EQUAL",
    6: "MQCFOP_NOT_LESS",
    10: "MQCFOP_CONTAINS",
    13: "MQCFOP_EXCLUDES",
    18: "MQCFOP_LIKE",
    21: "MQCFOP_NOT_LIKE",
    26: "MQCFOP_CONTAINS_GEN",
    29: "MQCFOP_EXCLUDES_GEN",
}

MQCFO_REFRESH_DICT = {
    0: "MQCFO_REFRESH_REPOSITORY_NO",
    1: "MQCFO_REFRESH_REPOSITORY_YES",
}

MQCFO_REMOVE_DICT = {
    0: "MQCFO_REMOVE_QUEUES_NO",
    1: "MQCFO_REMOVE_QUEUES_YES",
}

MQCFR_DICT = {
    0: "MQCFR_NO",
    1: "MQCFR_YES",
}

MQCFSTATUS_DICT = {
    0: "MQCFSTATUS_NOT_FOUND",
    1: "MQCFSTATUS_ACTIVE",
    2: "MQCFSTATUS_IN_RECOVER",
    3: "MQCFSTATUS_IN_BACKUP",
    4: "MQCFSTATUS_FAILED",
    5: "MQCFSTATUS_NONE",
    6: "MQCFSTATUS_UNKNOWN",
    7: "MQCFSTATUS_RECOVERED",
    8: "MQCFSTATUS_EMPTY",
    9: "MQCFSTATUS_NEW",
    20: "MQCFSTATUS_ADMIN_INCOMPLETE",
    21: "MQCFSTATUS_NEVER_USED",
    22: "MQCFSTATUS_NO_BACKUP",
    23: "MQCFSTATUS_NOT_FAILED",
    24: "MQCFSTATUS_NOT_RECOVERABLE",
    25: "MQCFSTATUS_XES_ERROR",
}

MQCFTYPE_DICT = {
    0: "MQCFTYPE_APPL",
    1: "MQCFTYPE_ADMIN",
}

MQCFT_DICT = {
    0: "MQCFT_NONE",
    1: "MQCFT_COMMAND",
    2: "MQCFT_RESPONSE",
    3: "MQCFT_INTEGER",
    4: "MQCFT_STRING",
    5: "MQCFT_INTEGER_LIST",
    6: "MQCFT_STRING_LIST",
    7: "MQCFT_EVENT",
    8: "MQCFT_USER",
    9: "MQCFT_BYTE_STRING",
    10: "MQCFT_TRACE_ROUTE",
    12: "MQCFT_REPORT",
    13: "MQCFT_INTEGER_FILTER",
    14: "MQCFT_STRING_FILTER",
    15: "MQCFT_BYTE_STRING_FILTER",
    16: "MQCFT_COMMAND_XR",
    17: "MQCFT_XR_MSG",
    18: "MQCFT_XR_ITEM",
    19: "MQCFT_XR_SUMMARY",
    20: "MQCFT_GROUP",
    21: "MQCFT_STATISTICS",
    22: "MQCFT_ACCOUNTING",
    23: "MQCFT_INTEGER64",
    25: "MQCFT_INTEGER64_LIST",
    26: "MQCFT_APP_ACTIVITY",
    27: "MQCFT_STATUS",
}

MQCF_DICT = {
    0: "MQCF_NONE",
    1: "MQCF_DIST_LISTS",
}

MQCGWI_DICT = {
    -2: "MQCGWI_DEFAULT",
}

MQCHAD_DICT = {
    0: "MQCHAD_DISABLED",
    1: "MQCHAD_ENABLED",
}

MQCHIDS_DICT = {
    0: "MQCHIDS_NOT_INDOUBT",
    1: "MQCHIDS_INDOUBT",
}

MQCHK_DICT = {
    0: "MQCHK_OPTIONAL",
    1: "MQCHK_NONE",
    2: "MQCHK_REQUIRED_ADMIN",
    3: "MQCHK_REQUIRED",
    4: "MQCHK_AS_Q_MGR",
}

MQCHLA_DICT = {
    0: "MQCHLA_DISABLED",
    1: "MQCHLA_ENABLED",
}

MQCHLD_DICT = {
    -1: "MQCHLD_ALL",
    1: "MQCHLD_DEFAULT",
    2: "MQCHLD_SHARED",
    4: "MQCHLD_PRIVATE",
    5: "MQCHLD_FIXSHARED",
}

MQCHRR_DICT = {
    0: "MQCHRR_RESET_NOT_REQUESTED",
}

MQCHSH_DICT = {
    0: "MQCHSH_RESTART_NO",
    1: "MQCHSH_RESTART_YES",
}

MQCHSR_DICT = {
    0: "MQCHSR_STOP_NOT_REQUESTED",
    1: "MQCHSR_STOP_REQUESTED",
}

MQCHSSTATE_DICT = {
    0: "MQCHSSTATE_OTHER",
    100: "MQCHSSTATE_END_OF_BATCH",
    200: "MQCHSSTATE_SENDING",
    300: "MQCHSSTATE_RECEIVING",
    400: "MQCHSSTATE_SERIALIZING",
    500: "MQCHSSTATE_RESYNCHING",
    600: "MQCHSSTATE_HEARTBEATING",
    700: "MQCHSSTATE_IN_SCYEXIT",
    800: "MQCHSSTATE_IN_RCVEXIT",
    900: "MQCHSSTATE_IN_SENDEXIT",
    1000: "MQCHSSTATE_IN_MSGEXIT",
    1100: "MQCHSSTATE_IN_MREXIT",
    1200: "MQCHSSTATE_IN_CHADEXIT",
    1250: "MQCHSSTATE_NET_CONNECTING",
    1300: "MQCHSSTATE_SSL_HANDSHAKING",
    1400: "MQCHSSTATE_NAME_SERVER",
    1500: "MQCHSSTATE_IN_MQPUT",
    1600: "MQCHSSTATE_IN_MQGET",
    1700: "MQCHSSTATE_IN_MQI_CALL",
    1800: "MQCHSSTATE_COMPRESSING",
}

MQCHS_DICT = {
    0: "MQCHS_INACTIVE",
    1: "MQCHS_BINDING",
    2: "MQCHS_STARTING",
    3: "MQCHS_RUNNING",
    4: "MQCHS_STOPPING",
    5: "MQCHS_RETRYING",
    6: "MQCHS_STOPPED",
    7: "MQCHS_REQUESTING",
    8: "MQCHS_PAUSED",
    9: "MQCHS_DISCONNECTED",
    13: "MQCHS_INITIALIZING",
    14: "MQCHS_SWITCHING",
}

MQCHTAB_DICT = {
    1: "MQCHTAB_Q_MGR",
    2: "MQCHTAB_CLNTCONN",
}

MQCHT_DICT = {
    1: "MQCHT_SENDER",
    2: "MQCHT_SERVER",
    3: "MQCHT_RECEIVER",
    4: "MQCHT_REQUESTER",
    5: "MQCHT_ALL",
    6: "MQCHT_CLNTCONN",
    7: "MQCHT_SVRCONN",
    8: "MQCHT_CLUSRCVR",
    9: "MQCHT_CLUSSDR",
    10: "MQCHT_MQTT",
    11: "MQCHT_AMQP",
}

MQCIH_DICT = {
    0: "MQCIH_NONE",
    1: "MQCIH_PASS_EXPIRATION",
    2: "MQCIH_REPLY_WITHOUT_NULLS",
    4: "MQCIH_SYNC_ON_RETURN",
}

MQCIT_DICT = {
    1: "MQCIT_MULTICAST",
}

MQCLCT_DICT = {
    0: "MQCLCT_STATIC",
    1: "MQCLCT_DYNAMIC",
}

MQCLROUTE_DICT = {
    0: "MQCLROUTE_DIRECT",
    1: "MQCLROUTE_TOPIC_HOST",
    2: "MQCLROUTE_NONE",
}

MQCLRS_DICT = {
    1: "MQCLRS_LOCAL",
    2: "MQCLRS_GLOBAL",
}

MQCLRT_DICT = {
    1: "MQCLRT_RETAINED",
}

MQCLST_DICT = {
    0: "MQCLST_ACTIVE",
    1: "MQCLST_PENDING",
    2: "MQCLST_INVALID",
    3: "MQCLST_ERROR",
}

MQCLT_DICT = {
    1: "MQCLT_PROGRAM",
    2: "MQCLT_TRANSACTION",
}

MQCLWL_DICT = {
    -3: "MQCLWL_USEQ_AS_Q_MGR",
    0: "MQCLWL_USEQ_LOCAL",
    1: "MQCLWL_USEQ_ANY",
}

MQCLXQ_DICT = {
    0: "MQCLXQ_SCTQ",
    1: "MQCLXQ_CHANNEL",
}

MQCMDI_DICT = {
    1: "MQCMDI_CMDSCOPE_ACCEPTED",
    2: "MQCMDI_CMDSCOPE_GENERATED",
    3: "MQCMDI_CMDSCOPE_COMPLETED",
    4: "MQCMDI_QSG_DISP_COMPLETED",
    5: "MQCMDI_COMMAND_ACCEPTED",
    6: "MQCMDI_CLUSTER_REQUEST_QUEUED",
    7: "MQCMDI_CHANNEL_INIT_STARTED",
    11: "MQCMDI_RECOVER_STARTED",
    12: "MQCMDI_BACKUP_STARTED",
    13: "MQCMDI_RECOVER_COMPLETED",
    14: "MQCMDI_SEC_TIMER_ZERO",
    16: "MQCMDI_REFRESH_CONFIGURATION",
    17: "MQCMDI_SEC_SIGNOFF_ERROR",
    18: "MQCMDI_IMS_BRIDGE_SUSPENDED",
    19: "MQCMDI_DB2_SUSPENDED",
    20: "MQCMDI_DB2_OBSOLETE_MSGS",
    21: "MQCMDI_SEC_UPPERCASE",
    22: "MQCMDI_SEC_MIXEDCASE",
}

MQCMDL_DICT = {
    100: "MQCMDL_LEVEL_1",
    101: "MQCMDL_LEVEL_101",
    110: "MQCMDL_LEVEL_110",
    114: "MQCMDL_LEVEL_114",
    120: "MQCMDL_LEVEL_120",
    200: "MQCMDL_LEVEL_200",
    201: "MQCMDL_LEVEL_201",
    210: "MQCMDL_LEVEL_210",
    211: "MQCMDL_LEVEL_211",
    220: "MQCMDL_LEVEL_220",
    221: "MQCMDL_LEVEL_221",
    230: "MQCMDL_LEVEL_230",
    320: "MQCMDL_LEVEL_320",
    420: "MQCMDL_LEVEL_420",
    500: "MQCMDL_LEVEL_500",
    510: "MQCMDL_LEVEL_510",
    520: "MQCMDL_LEVEL_520",
    530: "MQCMDL_LEVEL_530",
    531: "MQCMDL_LEVEL_531",
    600: "MQCMDL_LEVEL_600",
    700: "MQCMDL_LEVEL_700",
    701: "MQCMDL_LEVEL_701",
    710: "MQCMDL_LEVEL_710",
    711: "MQCMDL_LEVEL_711",
    750: "MQCMDL_LEVEL_750",
    800: "MQCMDL_LEVEL_800",
    801: "MQCMDL_LEVEL_801",
    802: "MQCMDL_LEVEL_802",
    900: "MQCMDL_LEVEL_900",
    901: "MQCMDL_LEVEL_901",
    902: "MQCMDL_LEVEL_902",
    903: "MQCMDL_LEVEL_903",
    904: "MQCMDL_LEVEL_904",
    905: "MQCMDL_LEVEL_905",
    910: "MQCMDL_LEVEL_910",
    911: "MQCMDL_LEVEL_911",
    912: "MQCMDL_LEVEL_912",
    913: "MQCMDL_LEVEL_913",
    914: "MQCMDL_LEVEL_914",
    915: "MQCMDL_LEVEL_915",
    920: "MQCMDL_LEVEL_920",
    921: "MQCMDL_LEVEL_921",
    922: "MQCMDL_LEVEL_922",
    923: "MQCMDL_LEVEL_923",
    924: "MQCMDL_LEVEL_924",
    925: "MQCMDL_LEVEL_925",
    930: "MQCMDL_LEVEL_930",
    931: "MQCMDL_LEVEL_931",
    932: "MQCMDL_LEVEL_932",
    933: "MQCMDL_LEVEL_933",
    934: "MQCMDL_LEVEL_934",
    935: "MQCMDL_LEVEL_935",
    940: "MQCMDL_LEVEL_940",
    941: "MQCMDL_LEVEL_941",
    942: "MQCMDL_LEVEL_942",
    943: "MQCMDL_LEVEL_943",
    944: "MQCMDL_LEVEL_944",
}

MQCMD_DICT = {
    0: "MQCMD_NONE",
    1: "MQCMD_CHANGE_Q_MGR",
    2: "MQCMD_INQUIRE_Q_MGR",
    3: "MQCMD_CHANGE_PROCESS",
    4: "MQCMD_COPY_PROCESS",
    5: "MQCMD_CREATE_PROCESS",
    6: "MQCMD_DELETE_PROCESS",
    7: "MQCMD_INQUIRE_PROCESS",
    8: "MQCMD_CHANGE_Q",
    9: "MQCMD_CLEAR_Q",
    10: "MQCMD_COPY_Q",
    11: "MQCMD_CREATE_Q",
    12: "MQCMD_DELETE_Q",
    13: "MQCMD_INQUIRE_Q",
    16: "MQCMD_REFRESH_Q_MGR",
    17: "MQCMD_RESET_Q_STATS",
    18: "MQCMD_INQUIRE_Q_NAMES",
    19: "MQCMD_INQUIRE_PROCESS_NAMES",
    20: "MQCMD_INQUIRE_CHANNEL_NAMES",
    21: "MQCMD_CHANGE_CHANNEL",
    22: "MQCMD_COPY_CHANNEL",
    23: "MQCMD_CREATE_CHANNEL",
    24: "MQCMD_DELETE_CHANNEL",
    25: "MQCMD_INQUIRE_CHANNEL",
    26: "MQCMD_PING_CHANNEL",
    27: "MQCMD_RESET_CHANNEL",
    28: "MQCMD_START_CHANNEL",
    29: "MQCMD_STOP_CHANNEL",
    30: "MQCMD_START_CHANNEL_INIT",
    31: "MQCMD_START_CHANNEL_LISTENER",
    32: "MQCMD_CHANGE_NAMELIST",
    33: "MQCMD_COPY_NAMELIST",
    34: "MQCMD_CREATE_NAMELIST",
    35: "MQCMD_DELETE_NAMELIST",
    36: "MQCMD_INQUIRE_NAMELIST",
    37: "MQCMD_INQUIRE_NAMELIST_NAMES",
    38: "MQCMD_ESCAPE",
    39: "MQCMD_RESOLVE_CHANNEL",
    40: "MQCMD_PING_Q_MGR",
    41: "MQCMD_INQUIRE_Q_STATUS",
    42: "MQCMD_INQUIRE_CHANNEL_STATUS",
    43: "MQCMD_CONFIG_EVENT",
    44: "MQCMD_Q_MGR_EVENT",
    45: "MQCMD_PERFM_EVENT",
    46: "MQCMD_CHANNEL_EVENT",
    60: "MQCMD_DELETE_PUBLICATION",
    61: "MQCMD_DEREGISTER_PUBLISHER",
    62: "MQCMD_DEREGISTER_SUBSCRIBER",
    63: "MQCMD_PUBLISH",
    64: "MQCMD_REGISTER_PUBLISHER",
    65: "MQCMD_REGISTER_SUBSCRIBER",
    66: "MQCMD_REQUEST_UPDATE",
    67: "MQCMD_BROKER_INTERNAL",
    69: "MQCMD_ACTIVITY_MSG",
    70: "MQCMD_INQUIRE_CLUSTER_Q_MGR",
    71: "MQCMD_RESUME_Q_MGR_CLUSTER",
    72: "MQCMD_SUSPEND_Q_MGR_CLUSTER",
    73: "MQCMD_REFRESH_CLUSTER",
    74: "MQCMD_RESET_CLUSTER",
    75: "MQCMD_TRACE_ROUTE",
    78: "MQCMD_REFRESH_SECURITY",
    79: "MQCMD_CHANGE_AUTH_INFO",
    80: "MQCMD_COPY_AUTH_INFO",
    81: "MQCMD_CREATE_AUTH_INFO",
    82: "MQCMD_DELETE_AUTH_INFO",
    83: "MQCMD_INQUIRE_AUTH_INFO",
    84: "MQCMD_INQUIRE_AUTH_INFO_NAMES",
    85: "MQCMD_INQUIRE_CONNECTION",
    86: "MQCMD_STOP_CONNECTION",
    87: "MQCMD_INQUIRE_AUTH_RECS",
    88: "MQCMD_INQUIRE_ENTITY_AUTH",
    89: "MQCMD_DELETE_AUTH_REC",
    90: "MQCMD_SET_AUTH_REC",
    91: "MQCMD_LOGGER_EVENT",
    92: "MQCMD_RESET_Q_MGR",
    93: "MQCMD_CHANGE_LISTENER",
    94: "MQCMD_COPY_LISTENER",
    95: "MQCMD_CREATE_LISTENER",
    96: "MQCMD_DELETE_LISTENER",
    97: "MQCMD_INQUIRE_LISTENER",
    98: "MQCMD_INQUIRE_LISTENER_STATUS",
    99: "MQCMD_COMMAND_EVENT",
    100: "MQCMD_CHANGE_SECURITY",
    101: "MQCMD_CHANGE_CF_STRUC",
    102: "MQCMD_CHANGE_STG_CLASS",
    103: "MQCMD_CHANGE_TRACE",
    104: "MQCMD_ARCHIVE_LOG",
    105: "MQCMD_BACKUP_CF_STRUC",
    106: "MQCMD_CREATE_BUFFER_POOL",
    107: "MQCMD_CREATE_PAGE_SET",
    108: "MQCMD_CREATE_CF_STRUC",
    109: "MQCMD_CREATE_STG_CLASS",
    110: "MQCMD_COPY_CF_STRUC",
    111: "MQCMD_COPY_STG_CLASS",
    112: "MQCMD_DELETE_CF_STRUC",
    113: "MQCMD_DELETE_STG_CLASS",
    114: "MQCMD_INQUIRE_ARCHIVE",
    115: "MQCMD_INQUIRE_CF_STRUC",
    116: "MQCMD_INQUIRE_CF_STRUC_STATUS",
    117: "MQCMD_INQUIRE_CMD_SERVER",
    118: "MQCMD_INQUIRE_CHANNEL_INIT",
    119: "MQCMD_INQUIRE_QSG",
    120: "MQCMD_INQUIRE_LOG",
    121: "MQCMD_INQUIRE_SECURITY",
    122: "MQCMD_INQUIRE_STG_CLASS",
    123: "MQCMD_INQUIRE_SYSTEM",
    124: "MQCMD_INQUIRE_THREAD",
    125: "MQCMD_INQUIRE_TRACE",
    126: "MQCMD_INQUIRE_USAGE",
    127: "MQCMD_MOVE_Q",
    128: "MQCMD_RECOVER_BSDS",
    129: "MQCMD_RECOVER_CF_STRUC",
    130: "MQCMD_RESET_TPIPE",
    131: "MQCMD_RESOLVE_INDOUBT",
    132: "MQCMD_RESUME_Q_MGR",
    133: "MQCMD_REVERIFY_SECURITY",
    134: "MQCMD_SET_ARCHIVE",
    136: "MQCMD_SET_LOG",
    137: "MQCMD_SET_SYSTEM",
    138: "MQCMD_START_CMD_SERVER",
    139: "MQCMD_START_Q_MGR",
    140: "MQCMD_START_TRACE",
    141: "MQCMD_STOP_CHANNEL_INIT",
    142: "MQCMD_STOP_CHANNEL_LISTENER",
    143: "MQCMD_STOP_CMD_SERVER",
    144: "MQCMD_STOP_Q_MGR",
    145: "MQCMD_STOP_TRACE",
    146: "MQCMD_SUSPEND_Q_MGR",
    147: "MQCMD_INQUIRE_CF_STRUC_NAMES",
    148: "MQCMD_INQUIRE_STG_CLASS_NAMES",
    149: "MQCMD_CHANGE_SERVICE",
    150: "MQCMD_COPY_SERVICE",
    151: "MQCMD_CREATE_SERVICE",
    152: "MQCMD_DELETE_SERVICE",
    153: "MQCMD_INQUIRE_SERVICE",
    154: "MQCMD_INQUIRE_SERVICE_STATUS",
    155: "MQCMD_START_SERVICE",
    156: "MQCMD_STOP_SERVICE",
    157: "MQCMD_DELETE_BUFFER_POOL",
    158: "MQCMD_DELETE_PAGE_SET",
    159: "MQCMD_CHANGE_BUFFER_POOL",
    160: "MQCMD_CHANGE_PAGE_SET",
    161: "MQCMD_INQUIRE_Q_MGR_STATUS",
    162: "MQCMD_CREATE_LOG",
    164: "MQCMD_STATISTICS_MQI",
    165: "MQCMD_STATISTICS_Q",
    166: "MQCMD_STATISTICS_CHANNEL",
    167: "MQCMD_ACCOUNTING_MQI",
    168: "MQCMD_ACCOUNTING_Q",
    169: "MQCMD_INQUIRE_AUTH_SERVICE",
    170: "MQCMD_CHANGE_TOPIC",
    171: "MQCMD_COPY_TOPIC",
    172: "MQCMD_CREATE_TOPIC",
    173: "MQCMD_DELETE_TOPIC",
    174: "MQCMD_INQUIRE_TOPIC",
    175: "MQCMD_INQUIRE_TOPIC_NAMES",
    176: "MQCMD_INQUIRE_SUBSCRIPTION",
    177: "MQCMD_CREATE_SUBSCRIPTION",
    178: "MQCMD_CHANGE_SUBSCRIPTION",
    179: "MQCMD_DELETE_SUBSCRIPTION",
    181: "MQCMD_COPY_SUBSCRIPTION",
    182: "MQCMD_INQUIRE_SUB_STATUS",
    183: "MQCMD_INQUIRE_TOPIC_STATUS",
    184: "MQCMD_CLEAR_TOPIC_STRING",
    185: "MQCMD_INQUIRE_PUBSUB_STATUS",
    186: "MQCMD_INQUIRE_SMDS",
    187: "MQCMD_CHANGE_SMDS",
    188: "MQCMD_RESET_SMDS",
    190: "MQCMD_CREATE_COMM_INFO",
    191: "MQCMD_INQUIRE_COMM_INFO",
    192: "MQCMD_CHANGE_COMM_INFO",
    193: "MQCMD_COPY_COMM_INFO",
    194: "MQCMD_DELETE_COMM_INFO",
    195: "MQCMD_PURGE_CHANNEL",
    196: "MQCMD_MQXR_DIAGNOSTICS",
    197: "MQCMD_START_SMDSCONN",
    198: "MQCMD_STOP_SMDSCONN",
    199: "MQCMD_INQUIRE_SMDSCONN",
    200: "MQCMD_INQUIRE_MQXR_STATUS",
    201: "MQCMD_START_CLIENT_TRACE",
    202: "MQCMD_STOP_CLIENT_TRACE",
    203: "MQCMD_SET_CHLAUTH_REC",
    204: "MQCMD_INQUIRE_CHLAUTH_RECS",
    205: "MQCMD_INQUIRE_PROT_POLICY",
    206: "MQCMD_CREATE_PROT_POLICY",
    207: "MQCMD_DELETE_PROT_POLICY",
    208: "MQCMD_CHANGE_PROT_POLICY",
    209: "MQCMD_ACTIVITY_TRACE",
    213: "MQCMD_RESET_CF_STRUC",
    214: "MQCMD_INQUIRE_XR_CAPABILITY",
    216: "MQCMD_INQUIRE_AMQP_CAPABILITY",
    217: "MQCMD_AMQP_DIAGNOSTICS",
    218: "MQCMD_INTER_Q_MGR_STATUS",
    219: "MQCMD_INTER_Q_MGR_BALANCE",
    220: "MQCMD_INQUIRE_APPL_STATUS",
}

MQCMHO_DICT = {
    0: "MQCMHO_NONE",
    1: "MQCMHO_NO_VALIDATION",
    2: "MQCMHO_VALIDATE",
}

MQCNO_DICT = {
    0: "MQCNO_NONE",
    1: "MQCNO_FASTPATH_BINDING",
    2: "MQCNO_SERIALIZE_CONN_TAG_Q_MGR",
    4: "MQCNO_SERIALIZE_CONN_TAG_QSG",
    8: "MQCNO_RESTRICT_CONN_TAG_Q_MGR",
    16: "MQCNO_RESTRICT_CONN_TAG_QSG",
    32: "MQCNO_HANDLE_SHARE_NONE",
    64: "MQCNO_HANDLE_SHARE_BLOCK",
    128: "MQCNO_HANDLE_SHARE_NO_BLOCK",
    256: "MQCNO_SHARED_BINDING",
    512: "MQCNO_ISOLATED_BINDING",
    1024: "MQCNO_LOCAL_BINDING",
    2048: "MQCNO_CLIENT_BINDING",
    4096: "MQCNO_ACCOUNTING_MQI_ENABLED",
    8192: "MQCNO_ACCOUNTING_MQI_DISABLED",
    16384: "MQCNO_ACCOUNTING_Q_ENABLED",
    32768: "MQCNO_ACCOUNTING_Q_DISABLED",
    65536: "MQCNO_NO_CONV_SHARING",
    262144: "MQCNO_ALL_CONVS_SHARE",
    524288: "MQCNO_CD_FOR_OUTPUT_ONLY",
    1048576: "MQCNO_USE_CD_SELECTION",
    2097152: "MQCNO_GENERATE_CONN_TAG",
    16777216: "MQCNO_RECONNECT",
    33554432: "MQCNO_RECONNECT_DISABLED",
    67108864: "MQCNO_RECONNECT_Q_MGR",
    134217728: "MQCNO_ACTIVITY_TRACE_ENABLED",
    268435456: "MQCNO_ACTIVITY_TRACE_DISABLED",
}

MQCODL_DICT = {
    -1: "MQCODL_AS_INPUT",
}

MQCOMPRESS_DICT = {
    -1: "MQCOMPRESS_NOT_AVAILABLE",
    0: "MQCOMPRESS_NONE",
    1: "MQCOMPRESS_RLE",
    2: "MQCOMPRESS_ZLIBFAST",
    4: "MQCOMPRESS_ZLIBHIGH",
    8: "MQCOMPRESS_SYSTEM",
    16: "MQCOMPRESS_LZ4FAST",
    32: "MQCOMPRESS_LZ4HIGH",
    268435455: "MQCOMPRESS_ANY",
}

MQCOPY_DICT = {
    0: "MQCOPY_NONE",
    1: "MQCOPY_ALL",
    2: "MQCOPY_FORWARD",
    4: "MQCOPY_PUBLISH",
    8: "MQCOPY_REPLY",
    16: "MQCOPY_REPORT",
    22: "MQCOPY_DEFAULT",
}

MQCO_DICT = {
    0: "MQCO_NONE",
    1: "MQCO_DELETE",
    2: "MQCO_DELETE_PURGE",
    4: "MQCO_KEEP_SUB",
    8: "MQCO_REMOVE_SUB",
    32: "MQCO_QUIESCE",
}

MQCQT_DICT = {
    1: "MQCQT_LOCAL_Q",
    2: "MQCQT_ALIAS_Q",
    3: "MQCQT_REMOTE_Q",
    4: "MQCQT_Q_MGR_ALIAS",
}

MQCRC_DICT = {
    0: "MQCRC_OK",
    1: "MQCRC_CICS_EXEC_ERROR",
    2: "MQCRC_MQ_API_ERROR",
    3: "MQCRC_BRIDGE_ERROR",
    4: "MQCRC_BRIDGE_ABEND",
    5: "MQCRC_APPLICATION_ABEND",
    6: "MQCRC_SECURITY_ERROR",
    7: "MQCRC_PROGRAM_NOT_AVAILABLE",
    8: "MQCRC_BRIDGE_TIMEOUT",
    9: "MQCRC_TRANSID_NOT_AVAILABLE",
}

MQCSP_DICT = {
    0: "MQCSP_AUTH_NONE",
    1: "MQCSP_AUTH_USER_ID_AND_PWD",
    2: "MQCSP_AUTH_ID_TOKEN",
}

MQCSRV_CONVERT_DICT = {
    0: "MQCSRV_CONVERT_NO",
    1: "MQCSRV_CONVERT_YES",
}

MQCSRV_DLQ_DICT = {
    0: "MQCSRV_DLQ_NO",
    1: "MQCSRV_DLQ_YES",
}

MQCS_DICT = {
    0: "MQCS_NONE",
    1: "MQCS_SUSPENDED_TEMPORARY",
    2: "MQCS_SUSPENDED_USER_ACTION",
    3: "MQCS_SUSPENDED",
    4: "MQCS_STOPPED",
}

MQCTES_DICT = {
    0: "MQCTES_NOSYNC",
    256: "MQCTES_COMMIT",
    4352: "MQCTES_BACKOUT",
    65536: "MQCTES_ENDTASK",
}

MQCTLO_DICT = {
    0: "MQCTLO_NONE",
    1: "MQCTLO_THREAD_AFFINITY",
    8192: "MQCTLO_FAIL_IF_QUIESCING",
}

MQCUOWC_DICT = {
    16: "MQCUOWC_MIDDLE",
    256: "MQCUOWC_COMMIT",
    273: "MQCUOWC_ONLY",
    4352: "MQCUOWC_BACKOUT",
    65536: "MQCUOWC_CONTINUE",
}

MQDCC_DICT = {
    0: "MQDCC_NONE",
    1: "MQDCC_DEFAULT_CONVERSION",
    2: "MQDCC_FILL_TARGET_BUFFER",
    4: "MQDCC_INT_DEFAULT_CONVERSION",
    16: "MQDCC_SOURCE_ENC_NORMAL",
    32: "MQDCC_SOURCE_ENC_REVERSED",
    240: "MQDCC_SOURCE_ENC_MASK",
    256: "MQDCC_TARGET_ENC_NORMAL",
    512: "MQDCC_TARGET_ENC_REVERSED",
    3840: "MQDCC_TARGET_ENC_MASK",
}

MQDC_DICT = {
    1: "MQDC_MANAGED",
    2: "MQDC_PROVIDED",
}

MQDELO_DICT = {
    0: "MQDELO_NONE",
    4: "MQDELO_LOCAL",
}

MQDHF_DICT = {
    0: "MQDHF_NONE",
    1: "MQDHF_NEW_MSG_IDS",
}

MQDISCONNECT_DICT = {
    0: "MQDISCONNECT_NORMAL",
    1: "MQDISCONNECT_IMPLICIT",
    2: "MQDISCONNECT_Q_MGR",
}

MQDLV_DICT = {
    0: "MQDLV_AS_PARENT",
    1: "MQDLV_ALL",
    2: "MQDLV_ALL_DUR",
    3: "MQDLV_ALL_AVAIL",
}

MQDL_DICT = {
    0: "MQDL_NOT_SUPPORTED",
    1: "MQDL_SUPPORTED",
}

MQDMHO_DICT = {
    0: "MQDMHO_NONE",
}

MQDMPO_DICT = {
    0: "MQDMPO_NONE",
    1: "MQDMPO_DEL_PROP_UNDER_CURSOR",
}

MQDNSWLM_DICT = {
    0: "MQDNSWLM_NO",
    1: "MQDNSWLM_YES",
}

MQDOPT_DICT = {
    0: "MQDOPT_RESOLVED",
    1: "MQDOPT_DEFINED",
}

MQDSB_DICT = {
    0: "MQDSB_DEFAULT",
    1: "MQDSB_8K",
    2: "MQDSB_16K",
    3: "MQDSB_32K",
    4: "MQDSB_64K",
    5: "MQDSB_128K",
    6: "MQDSB_256K",
    7: "MQDSB_512K",
    8: "MQDSB_1M",
}

MQDSE_DICT = {
    0: "MQDSE_DEFAULT",
    1: "MQDSE_YES",
    2: "MQDSE_NO",
}

MQEC_DICT = {
    2: "MQEC_MSG_ARRIVED",
    3: "MQEC_WAIT_INTERVAL_EXPIRED",
    4: "MQEC_WAIT_CANCELED",
    5: "MQEC_Q_MGR_QUIESCING",
    6: "MQEC_CONNECTION_QUIESCING",
}

MQEI_DICT = {
    -1: "MQEI_UNLIMITED",
}

MQENC_DICT = {
    -4096: "MQENC_RESERVED_MASK",
    -1: "MQENC_AS_PUBLISHED",
    1: "MQENC_INTEGER_NORMAL",
    2: "MQENC_INTEGER_REVERSED",
    15: "MQENC_INTEGER_MASK",
    16: "MQENC_DECIMAL_NORMAL",
    32: "MQENC_DECIMAL_REVERSED",
    240: "MQENC_DECIMAL_MASK",
    256: "MQENC_FLOAT_IEEE_NORMAL",
    273: "MQENC_NORMAL",
    512: "MQENC_FLOAT_IEEE_REVERSED",
    546: "MQENC_REVERSED",
    768: "MQENC_FLOAT_S390",
    785: "MQENC_S390",
    1024: "MQENC_FLOAT_TNS",
    1041: "MQENC_TNS",
    3840: "MQENC_FLOAT_MASK",
}

MQEPH_DICT = {
    0: "MQEPH_NONE",
    1: "MQEPH_CCSID_EMBEDDED",
}

MQET_DICT = {
    1: "MQET_MQSC",
}

MQEVO_DICT = {
    0: "MQEVO_OTHER",
    1: "MQEVO_CONSOLE",
    2: "MQEVO_INIT",
    3: "MQEVO_MSG",
    4: "MQEVO_MQSET",
    5: "MQEVO_INTERNAL",
    6: "MQEVO_MQSUB",
    7: "MQEVO_CTLMSG",
    8: "MQEVO_REST",
}

MQEVR_DICT = {
    0: "MQEVR_DISABLED",
    1: "MQEVR_ENABLED",
    2: "MQEVR_EXCEPTION",
    3: "MQEVR_NO_DISPLAY",
    4: "MQEVR_API_ONLY",
    5: "MQEVR_ADMIN_ONLY",
    6: "MQEVR_USER_ONLY",
}

MQEXPI_DICT = {
    0: "MQEXPI_OFF",
}

MQEXTATTRS_DICT = {
    0: "MQEXTATTRS_ALL",
    1: "MQEXTATTRS_NONDEF",
}

MQEXT_DICT = {
    0: "MQEXT_ALL",
    1: "MQEXT_OBJECT",
    2: "MQEXT_AUTHORITY",
}

MQFB_DICT = {
    0: "MQFB_NONE",
    256: "MQFB_QUIT",
    258: "MQFB_EXPIRATION",
    259: "MQFB_COA",
    260: "MQFB_COD",
    262: "MQFB_CHANNEL_COMPLETED",
    263: "MQFB_CHANNEL_FAIL_RETRY",
    264: "MQFB_CHANNEL_FAIL",
    265: "MQFB_APPL_CANNOT_BE_STARTED",
    266: "MQFB_TM_ERROR",
    267: "MQFB_APPL_TYPE_ERROR",
    268: "MQFB_STOPPED_BY_MSG_EXIT",
    269: "MQFB_ACTIVITY",
    271: "MQFB_XMIT_Q_MSG_ERROR",
    275: "MQFB_PAN",
    276: "MQFB_NAN",
    277: "MQFB_STOPPED_BY_CHAD_EXIT",
    279: "MQFB_STOPPED_BY_PUBSUB_EXIT",
    280: "MQFB_NOT_A_REPOSITORY_MSG",
    281: "MQFB_BIND_OPEN_CLUSRCVR_DEL",
    282: "MQFB_MAX_ACTIVITIES",
    283: "MQFB_NOT_FORWARDED",
    284: "MQFB_NOT_DELIVERED",
    285: "MQFB_UNSUPPORTED_FORWARDING",
    286: "MQFB_UNSUPPORTED_DELIVERY",
    291: "MQFB_DATA_LENGTH_ZERO",
    292: "MQFB_DATA_LENGTH_NEGATIVE",
    293: "MQFB_DATA_LENGTH_TOO_BIG",
    294: "MQFB_BUFFER_OVERFLOW",
    295: "MQFB_LENGTH_OFF_BY_ONE",
    296: "MQFB_IIH_ERROR",
    298: "MQFB_NOT_AUTHORIZED_FOR_IMS",
    299: "MQFB_DATA_LENGTH_TOO_SHORT",
    300: "MQFB_IMS_ERROR",
    401: "MQFB_CICS_INTERNAL_ERROR",
    402: "MQFB_CICS_NOT_AUTHORIZED",
    403: "MQFB_CICS_BRIDGE_FAILURE",
    404: "MQFB_CICS_CORREL_ID_ERROR",
    405: "MQFB_CICS_CCSID_ERROR",
    406: "MQFB_CICS_ENCODING_ERROR",
    407: "MQFB_CICS_CIH_ERROR",
    408: "MQFB_CICS_UOW_ERROR",
    409: "MQFB_CICS_COMMAREA_ERROR",
    410: "MQFB_CICS_APPL_NOT_STARTED",
    411: "MQFB_CICS_APPL_ABENDED",
    412: "MQFB_CICS_DLQ_ERROR",
    413: "MQFB_CICS_UOW_BACKED_OUT",
    501: "MQFB_PUBLICATIONS_ON_REQUEST",
    502: "MQFB_SUBSCRIBER_IS_PUBLISHER",
    503: "MQFB_MSG_SCOPE_MISMATCH",
    504: "MQFB_SELECTOR_MISMATCH",
    505: "MQFB_NOT_A_GROUPUR_MSG",
}

MQFC_DICT = {
    0: "MQFC_NO",
    1: "MQFC_YES",
}

MQFSENC_DICT = {
    0: "MQFSENC_NO",
    1: "MQFSENC_YES",
    2: "MQFSENC_UNKNOWN",
}

MQFS_DICT = {
    -1: "MQFS_SHARED",
}

MQFUN_DICT = {
    0: "MQFUN_TYPE_UNKNOWN",
    1: "MQFUN_TYPE_JVM",
    2: "MQFUN_TYPE_PROGRAM",
    3: "MQFUN_TYPE_PROCEDURE",
    4: "MQFUN_TYPE_USERDEF",
    5: "MQFUN_TYPE_COMMAND",
}

MQGACF_DICT = {
    8001: "MQGACF_COMMAND_CONTEXT",
    8002: "MQGACF_COMMAND_DATA",
    8003: "MQGACF_TRACE_ROUTE",
    8004: "MQGACF_OPERATION",
    8005: "MQGACF_ACTIVITY",
    8006: "MQGACF_EMBEDDED_MQMD",
    8007: "MQGACF_MESSAGE",
    8008: "MQGACF_MQMD",
    8009: "MQGACF_VALUE_NAMING",
    8010: "MQGACF_Q_ACCOUNTING_DATA",
    8011: "MQGACF_Q_STATISTICS_DATA",
    8012: "MQGACF_CHL_STATISTICS_DATA",
    8013: "MQGACF_ACTIVITY_TRACE",
    8014: "MQGACF_APP_DIST_LIST",
    8015: "MQGACF_MONITOR_CLASS",
    8016: "MQGACF_MONITOR_TYPE",
    8017: "MQGACF_MONITOR_ELEMENT",
    8018: "MQGACF_APPL_STATUS",
    8019: "MQGACF_CHANGED_APPLS",
    8020: "MQGACF_ALL_APPLS",
    8021: "MQGACF_APPL_BALANCE",
}

MQGMO_DICT = {
    0: "MQGMO_NONE",
    1: "MQGMO_WAIT",
    2: "MQGMO_SYNCPOINT",
    4: "MQGMO_NO_SYNCPOINT",
    8: "MQGMO_SET_SIGNAL",
    16: "MQGMO_BROWSE_FIRST",
    32: "MQGMO_BROWSE_NEXT",
    64: "MQGMO_ACCEPT_TRUNCATED_MSG",
    128: "MQGMO_MARK_SKIP_BACKOUT",
    256: "MQGMO_MSG_UNDER_CURSOR",
    512: "MQGMO_LOCK",
    1024: "MQGMO_UNLOCK",
    2048: "MQGMO_BROWSE_MSG_UNDER_CURSOR",
    4096: "MQGMO_SYNCPOINT_IF_PERSISTENT",
    8192: "MQGMO_FAIL_IF_QUIESCING",
    16384: "MQGMO_CONVERT",
    32768: "MQGMO_LOGICAL_ORDER",
    65536: "MQGMO_COMPLETE_MSG",
    131072: "MQGMO_ALL_MSGS_AVAILABLE",
    262144: "MQGMO_ALL_SEGMENTS_AVAILABLE",
    1048576: "MQGMO_MARK_BROWSE_HANDLE",
    2097152: "MQGMO_MARK_BROWSE_CO_OP",
    4194304: "MQGMO_UNMARK_BROWSE_CO_OP",
    8388608: "MQGMO_UNMARK_BROWSE_HANDLE",
    16777216: "MQGMO_UNMARKED_BROWSE_MSG",
    17825808: "MQGMO_BROWSE_HANDLE",
    18874384: "MQGMO_BROWSE_CO_OP",
    33554432: "MQGMO_PROPERTIES_FORCE_MQRFH2",
    67108864: "MQGMO_NO_PROPERTIES",
    134217728: "MQGMO_PROPERTIES_IN_HANDLE",
    268435456: "MQGMO_PROPERTIES_COMPATIBILITY",
}

MQGUR_DICT = {
    0: "MQGUR_DISABLED",
    1: "MQGUR_ENABLED",
}

MQHA_DICT = {
    4001: "MQHA_BAG_HANDLE",
}

MQHB_DICT = {
    -2: "MQHB_NONE",
    -1: "MQHB_UNUSABLE_HBAG",
}

MQHC_DICT = {
    -3: "MQHC_UNASSOCIATED_HCONN",
    -1: "MQHC_UNUSABLE_HCONN",
    0: "MQHC_DEF_HCONN",
}

MQHM_DICT = {
    -1: "MQHM_UNUSABLE_HMSG",
    0: "MQHM_NONE",
}

MQHO_DICT = {
    -1: "MQHO_UNUSABLE_HOBJ",
    0: "MQHO_NONE",
}

MQHSTATE_DICT = {
    0: "MQHSTATE_INACTIVE",
    1: "MQHSTATE_ACTIVE",
}

MQIACF_DICT = {
    1001: "MQIACF_Q_MGR_ATTRS",
    1002: "MQIACF_Q_ATTRS",
    1003: "MQIACF_PROCESS_ATTRS",
    1004: "MQIACF_NAMELIST_ATTRS",
    1005: "MQIACF_FORCE",
    1006: "MQIACF_REPLACE",
    1007: "MQIACF_PURGE",
    1008: "MQIACF_QUIESCE",
    1009: "MQIACF_ALL",
    1010: "MQIACF_EVENT_APPL_TYPE",
    1011: "MQIACF_EVENT_ORIGIN",
    1012: "MQIACF_PARAMETER_ID",
    1013: "MQIACF_ERROR_ID",
    1014: "MQIACF_SELECTOR",
    1015: "MQIACF_CHANNEL_ATTRS",
    1016: "MQIACF_OBJECT_TYPE",
    1017: "MQIACF_ESCAPE_TYPE",
    1018: "MQIACF_ERROR_OFFSET",
    1019: "MQIACF_AUTH_INFO_ATTRS",
    1020: "MQIACF_REASON_QUALIFIER",
    1021: "MQIACF_COMMAND",
    1022: "MQIACF_OPEN_OPTIONS",
    1023: "MQIACF_OPEN_TYPE",
    1024: "MQIACF_PROCESS_ID",
    1025: "MQIACF_THREAD_ID",
    1026: "MQIACF_Q_STATUS_ATTRS",
    1027: "MQIACF_UNCOMMITTED_MSGS",
    1028: "MQIACF_HANDLE_STATE",
    1070: "MQIACF_AUX_ERROR_DATA_INT_1",
    1071: "MQIACF_AUX_ERROR_DATA_INT_2",
    1072: "MQIACF_CONV_REASON_CODE",
    1073: "MQIACF_BRIDGE_TYPE",
    1074: "MQIACF_INQUIRY",
    1075: "MQIACF_WAIT_INTERVAL",
    1076: "MQIACF_OPTIONS",
    1077: "MQIACF_BROKER_OPTIONS",
    1078: "MQIACF_REFRESH_TYPE",
    1079: "MQIACF_SEQUENCE_NUMBER",
    1080: "MQIACF_INTEGER_DATA",
    1081: "MQIACF_REGISTRATION_OPTIONS",
    1082: "MQIACF_PUBLICATION_OPTIONS",
    1083: "MQIACF_CLUSTER_INFO",
    1084: "MQIACF_Q_MGR_DEFINITION_TYPE",
    1085: "MQIACF_Q_MGR_TYPE",
    1086: "MQIACF_ACTION",
    1087: "MQIACF_SUSPEND",
    1088: "MQIACF_BROKER_COUNT",
    1089: "MQIACF_APPL_COUNT",
    1090: "MQIACF_ANONYMOUS_COUNT",
    1091: "MQIACF_REG_REG_OPTIONS",
    1092: "MQIACF_DELETE_OPTIONS",
    1093: "MQIACF_CLUSTER_Q_MGR_ATTRS",
    1094: "MQIACF_REFRESH_INTERVAL",
    1095: "MQIACF_REFRESH_REPOSITORY",
    1096: "MQIACF_REMOVE_QUEUES",
    1098: "MQIACF_OPEN_INPUT_TYPE",
    1099: "MQIACF_OPEN_OUTPUT",
    1100: "MQIACF_OPEN_SET",
    1101: "MQIACF_OPEN_INQUIRE",
    1102: "MQIACF_OPEN_BROWSE",
    1103: "MQIACF_Q_STATUS_TYPE",
    1104: "MQIACF_Q_HANDLE",
    1105: "MQIACF_Q_STATUS",
    1106: "MQIACF_SECURITY_TYPE",
    1107: "MQIACF_CONNECTION_ATTRS",
    1108: "MQIACF_CONNECT_OPTIONS",
    1110: "MQIACF_CONN_INFO_TYPE",
    1111: "MQIACF_CONN_INFO_CONN",
    1112: "MQIACF_CONN_INFO_HANDLE",
    1113: "MQIACF_CONN_INFO_ALL",
    1114: "MQIACF_AUTH_PROFILE_ATTRS",
    1115: "MQIACF_AUTHORIZATION_LIST",
    1116: "MQIACF_AUTH_ADD_AUTHS",
    1117: "MQIACF_AUTH_REMOVE_AUTHS",
    1118: "MQIACF_ENTITY_TYPE",
    1120: "MQIACF_COMMAND_INFO",
    1121: "MQIACF_CMDSCOPE_Q_MGR_COUNT",
    1122: "MQIACF_Q_MGR_SYSTEM",
    1123: "MQIACF_Q_MGR_EVENT",
    1124: "MQIACF_Q_MGR_DQM",
    1125: "MQIACF_Q_MGR_CLUSTER",
    1126: "MQIACF_QSG_DISPS",
    1128: "MQIACF_UOW_STATE",
    1129: "MQIACF_SECURITY_ITEM",
    1130: "MQIACF_CF_STRUC_STATUS",
    1132: "MQIACF_UOW_TYPE",
    1133: "MQIACF_CF_STRUC_ATTRS",
    1134: "MQIACF_EXCLUDE_INTERVAL",
    1135: "MQIACF_CF_STATUS_TYPE",
    1136: "MQIACF_CF_STATUS_SUMMARY",
    1137: "MQIACF_CF_STATUS_CONNECT",
    1138: "MQIACF_CF_STATUS_BACKUP",
    1139: "MQIACF_CF_STRUC_TYPE",
    1140: "MQIACF_CF_STRUC_SIZE_MAX",
    1141: "MQIACF_CF_STRUC_SIZE_USED",
    1142: "MQIACF_CF_STRUC_ENTRIES_MAX",
    1143: "MQIACF_CF_STRUC_ENTRIES_USED",
    1144: "MQIACF_CF_STRUC_BACKUP_SIZE",
    1145: "MQIACF_MOVE_TYPE",
    1146: "MQIACF_MOVE_TYPE_MOVE",
    1147: "MQIACF_MOVE_TYPE_ADD",
    1148: "MQIACF_Q_MGR_NUMBER",
    1149: "MQIACF_Q_MGR_STATUS",
    1150: "MQIACF_DB2_CONN_STATUS",
    1151: "MQIACF_SECURITY_ATTRS",
    1152: "MQIACF_SECURITY_TIMEOUT",
    1153: "MQIACF_SECURITY_INTERVAL",
    1154: "MQIACF_SECURITY_SWITCH",
    1155: "MQIACF_SECURITY_SETTING",
    1156: "MQIACF_STORAGE_CLASS_ATTRS",
    1157: "MQIACF_USAGE_TYPE",
    1158: "MQIACF_BUFFER_POOL_ID",
    1159: "MQIACF_USAGE_TOTAL_PAGES",
    1160: "MQIACF_USAGE_UNUSED_PAGES",
    1161: "MQIACF_USAGE_PERSIST_PAGES",
    1162: "MQIACF_USAGE_NONPERSIST_PAGES",
    1163: "MQIACF_USAGE_RESTART_EXTENTS",
    1164: "MQIACF_USAGE_EXPAND_COUNT",
    1165: "MQIACF_PAGESET_STATUS",
    1166: "MQIACF_USAGE_TOTAL_BUFFERS",
    1167: "MQIACF_USAGE_DATA_SET_TYPE",
    1168: "MQIACF_USAGE_PAGESET",
    1169: "MQIACF_USAGE_DATA_SET",
    1170: "MQIACF_USAGE_BUFFER_POOL",
    1171: "MQIACF_MOVE_COUNT",
    1172: "MQIACF_EXPIRY_Q_COUNT",
    1173: "MQIACF_CONFIGURATION_OBJECTS",
    1174: "MQIACF_CONFIGURATION_EVENTS",
    1175: "MQIACF_SYSP_TYPE",
    1176: "MQIACF_SYSP_DEALLOC_INTERVAL",
    1177: "MQIACF_SYSP_MAX_ARCHIVE",
    1178: "MQIACF_SYSP_MAX_READ_TAPES",
    1179: "MQIACF_SYSP_IN_BUFFER_SIZE",
    1180: "MQIACF_SYSP_OUT_BUFFER_SIZE",
    1181: "MQIACF_SYSP_OUT_BUFFER_COUNT",
    1182: "MQIACF_SYSP_ARCHIVE",
    1183: "MQIACF_SYSP_DUAL_ACTIVE",
    1184: "MQIACF_SYSP_DUAL_ARCHIVE",
    1185: "MQIACF_SYSP_DUAL_BSDS",
    1186: "MQIACF_SYSP_MAX_CONNS",
    1187: "MQIACF_SYSP_MAX_CONNS_FORE",
    1188: "MQIACF_SYSP_MAX_CONNS_BACK",
    1189: "MQIACF_SYSP_EXIT_INTERVAL",
    1190: "MQIACF_SYSP_EXIT_TASKS",
    1191: "MQIACF_SYSP_CHKPOINT_COUNT",
    1192: "MQIACF_SYSP_OTMA_INTERVAL",
    1193: "MQIACF_SYSP_Q_INDEX_DEFER",
    1194: "MQIACF_SYSP_DB2_TASKS",
    1195: "MQIACF_SYSP_RESLEVEL_AUDIT",
    1196: "MQIACF_SYSP_ROUTING_CODE",
    1197: "MQIACF_SYSP_SMF_ACCOUNTING",
    1198: "MQIACF_SYSP_SMF_STATS",
    1199: "MQIACF_SYSP_SMF_INTERVAL",
    1200: "MQIACF_SYSP_TRACE_CLASS",
    1201: "MQIACF_SYSP_TRACE_SIZE",
    1202: "MQIACF_SYSP_WLM_INTERVAL",
    1203: "MQIACF_SYSP_ALLOC_UNIT",
    1204: "MQIACF_SYSP_ARCHIVE_RETAIN",
    1205: "MQIACF_SYSP_ARCHIVE_WTOR",
    1206: "MQIACF_SYSP_BLOCK_SIZE",
    1207: "MQIACF_SYSP_CATALOG",
    1208: "MQIACF_SYSP_COMPACT",
    1209: "MQIACF_SYSP_ALLOC_PRIMARY",
    1210: "MQIACF_SYSP_ALLOC_SECONDARY",
    1211: "MQIACF_SYSP_PROTECT",
    1212: "MQIACF_SYSP_QUIESCE_INTERVAL",
    1213: "MQIACF_SYSP_TIMESTAMP",
    1214: "MQIACF_SYSP_UNIT_ADDRESS",
    1215: "MQIACF_SYSP_UNIT_STATUS",
    1216: "MQIACF_SYSP_LOG_COPY",
    1217: "MQIACF_SYSP_LOG_USED",
    1218: "MQIACF_SYSP_LOG_SUSPEND",
    1219: "MQIACF_SYSP_OFFLOAD_STATUS",
    1220: "MQIACF_SYSP_TOTAL_LOGS",
    1221: "MQIACF_SYSP_FULL_LOGS",
    1222: "MQIACF_LISTENER_ATTRS",
    1223: "MQIACF_LISTENER_STATUS_ATTRS",
    1224: "MQIACF_SERVICE_ATTRS",
    1225: "MQIACF_SERVICE_STATUS_ATTRS",
    1226: "MQIACF_Q_TIME_INDICATOR",
    1227: "MQIACF_OLDEST_MSG_AGE",
    1228: "MQIACF_AUTH_OPTIONS",
    1229: "MQIACF_Q_MGR_STATUS_ATTRS",
    1230: "MQIACF_CONNECTION_COUNT",
    1231: "MQIACF_Q_MGR_FACILITY",
    1232: "MQIACF_CHINIT_STATUS",
    1233: "MQIACF_CMD_SERVER_STATUS",
    1234: "MQIACF_ROUTE_DETAIL",
    1235: "MQIACF_RECORDED_ACTIVITIES",
    1236: "MQIACF_MAX_ACTIVITIES",
    1237: "MQIACF_DISCONTINUITY_COUNT",
    1238: "MQIACF_ROUTE_ACCUMULATION",
    1239: "MQIACF_ROUTE_DELIVERY",
    1240: "MQIACF_OPERATION_TYPE",
    1241: "MQIACF_BACKOUT_COUNT",
    1242: "MQIACF_COMP_CODE",
    1243: "MQIACF_ENCODING",
    1244: "MQIACF_EXPIRY",
    1245: "MQIACF_FEEDBACK",
    1247: "MQIACF_MSG_FLAGS",
    1248: "MQIACF_MSG_LENGTH",
    1249: "MQIACF_MSG_TYPE",
    1250: "MQIACF_OFFSET",
    1251: "MQIACF_ORIGINAL_LENGTH",
    1252: "MQIACF_PERSISTENCE",
    1253: "MQIACF_PRIORITY",
    1254: "MQIACF_REASON_CODE",
    1255: "MQIACF_REPORT",
    1256: "MQIACF_VERSION",
    1257: "MQIACF_UNRECORDED_ACTIVITIES",
    1258: "MQIACF_MONITORING",
    1259: "MQIACF_ROUTE_FORWARDING",
    1260: "MQIACF_SERVICE_STATUS",
    1261: "MQIACF_Q_TYPES",
    1262: "MQIACF_USER_ID_SUPPORT",
    1263: "MQIACF_INTERFACE_VERSION",
    1264: "MQIACF_AUTH_SERVICE_ATTRS",
    1265: "MQIACF_USAGE_EXPAND_TYPE",
    1266: "MQIACF_SYSP_CLUSTER_CACHE",
    1267: "MQIACF_SYSP_DB2_BLOB_TASKS",
    1268: "MQIACF_SYSP_WLM_INT_UNITS",
    1269: "MQIACF_TOPIC_ATTRS",
    1271: "MQIACF_PUBSUB_PROPERTIES",
    1273: "MQIACF_DESTINATION_CLASS",
    1274: "MQIACF_DURABLE_SUBSCRIPTION",
    1275: "MQIACF_SUBSCRIPTION_SCOPE",
    1277: "MQIACF_VARIABLE_USER_ID",
    1280: "MQIACF_REQUEST_ONLY",
    1283: "MQIACF_PUB_PRIORITY",
    1287: "MQIACF_SUB_ATTRS",
    1288: "MQIACF_WILDCARD_SCHEMA",
    1289: "MQIACF_SUB_TYPE",
    1290: "MQIACF_MESSAGE_COUNT",
    1291: "MQIACF_Q_MGR_PUBSUB",
    1292: "MQIACF_Q_MGR_VERSION",
    1294: "MQIACF_SUB_STATUS_ATTRS",
    1295: "MQIACF_TOPIC_STATUS",
    1296: "MQIACF_TOPIC_SUB",
    1297: "MQIACF_TOPIC_PUB",
    1300: "MQIACF_RETAINED_PUBLICATION",
    1301: "MQIACF_TOPIC_STATUS_ATTRS",
    1302: "MQIACF_TOPIC_STATUS_TYPE",
    1303: "MQIACF_SUB_OPTIONS",
    1304: "MQIACF_PUBLISH_COUNT",
    1305: "MQIACF_CLEAR_TYPE",
    1306: "MQIACF_CLEAR_SCOPE",
    1307: "MQIACF_SUB_LEVEL",
    1308: "MQIACF_ASYNC_STATE",
    1309: "MQIACF_SUB_SUMMARY",
    1310: "MQIACF_OBSOLETE_MSGS",
    1311: "MQIACF_PUBSUB_STATUS",
    1314: "MQIACF_PS_STATUS_TYPE",
    1318: "MQIACF_PUBSUB_STATUS_ATTRS",
    1321: "MQIACF_SELECTOR_TYPE",
    1322: "MQIACF_LOG_COMPRESSION",
    1323: "MQIACF_GROUPUR_CHECK_ID",
    1324: "MQIACF_MULC_CAPTURE",
    1325: "MQIACF_PERMIT_STANDBY",
    1326: "MQIACF_OPERATION_MODE",
    1327: "MQIACF_COMM_INFO_ATTRS",
    1328: "MQIACF_CF_SMDS_BLOCK_SIZE",
    1329: "MQIACF_CF_SMDS_EXPAND",
    1330: "MQIACF_USAGE_FREE_BUFF",
    1331: "MQIACF_USAGE_FREE_BUFF_PERC",
    1332: "MQIACF_CF_STRUC_ACCESS",
    1333: "MQIACF_CF_STATUS_SMDS",
    1334: "MQIACF_SMDS_ATTRS",
    1335: "MQIACF_USAGE_SMDS",
    1336: "MQIACF_USAGE_BLOCK_SIZE",
    1337: "MQIACF_USAGE_DATA_BLOCKS",
    1338: "MQIACF_USAGE_EMPTY_BUFFERS",
    1339: "MQIACF_USAGE_INUSE_BUFFERS",
    1340: "MQIACF_USAGE_LOWEST_FREE",
    1341: "MQIACF_USAGE_OFFLOAD_MSGS",
    1342: "MQIACF_USAGE_READS_SAVED",
    1343: "MQIACF_USAGE_SAVED_BUFFERS",
    1344: "MQIACF_USAGE_TOTAL_BLOCKS",
    1345: "MQIACF_USAGE_USED_BLOCKS",
    1346: "MQIACF_USAGE_USED_RATE",
    1347: "MQIACF_USAGE_WAIT_RATE",
    1348: "MQIACF_SMDS_OPENMODE",
    1349: "MQIACF_SMDS_STATUS",
    1350: "MQIACF_SMDS_AVAIL",
    1351: "MQIACF_MCAST_REL_INDICATOR",
    1352: "MQIACF_CHLAUTH_TYPE",
    1354: "MQIACF_MQXR_DIAGNOSTICS_TYPE",
    1355: "MQIACF_CHLAUTH_ATTRS",
    1356: "MQIACF_OPERATION_ID",
    1357: "MQIACF_API_CALLER_TYPE",
    1358: "MQIACF_API_ENVIRONMENT",
    1359: "MQIACF_TRACE_DETAIL",
    1360: "MQIACF_HOBJ",
    1361: "MQIACF_CALL_TYPE",
    1362: "MQIACF_MQCB_OPERATION",
    1363: "MQIACF_MQCB_TYPE",
    1364: "MQIACF_MQCB_OPTIONS",
    1365: "MQIACF_CLOSE_OPTIONS",
    1366: "MQIACF_CTL_OPERATION",
    1367: "MQIACF_GET_OPTIONS",
    1368: "MQIACF_RECS_PRESENT",
    1369: "MQIACF_KNOWN_DEST_COUNT",
    1370: "MQIACF_UNKNOWN_DEST_COUNT",
    1371: "MQIACF_INVALID_DEST_COUNT",
    1372: "MQIACF_RESOLVED_TYPE",
    1373: "MQIACF_PUT_OPTIONS",
    1374: "MQIACF_BUFFER_LENGTH",
    1375: "MQIACF_TRACE_DATA_LENGTH",
    1376: "MQIACF_SMDS_EXPANDST",
    1378: "MQIACF_ITEM_COUNT",
    1379: "MQIACF_EXPIRY_TIME",
    1380: "MQIACF_CONNECT_TIME",
    1381: "MQIACF_DISCONNECT_TIME",
    1382: "MQIACF_HSUB",
    1383: "MQIACF_SUBRQ_OPTIONS",
    1384: "MQIACF_XA_RMID",
    1385: "MQIACF_XA_FLAGS",
    1386: "MQIACF_XA_RETCODE",
    1387: "MQIACF_XA_HANDLE",
    1388: "MQIACF_XA_RETVAL",
    1389: "MQIACF_STATUS_TYPE",
    1390: "MQIACF_XA_COUNT",
    1391: "MQIACF_SELECTOR_COUNT",
    1392: "MQIACF_SELECTORS",
    1393: "MQIACF_INTATTR_COUNT",
    1394: "MQIACF_INT_ATTRS",
    1395: "MQIACF_SUBRQ_ACTION",
    1396: "MQIACF_NUM_PUBS",
    1397: "MQIACF_POINTER_SIZE",
    1398: "MQIACF_REMOVE_AUTHREC",
    1399: "MQIACF_XR_ATTRS",
    1400: "MQIACF_APPL_FUNCTION_TYPE",
    1401: "MQIACF_AMQP_ATTRS",
    1402: "MQIACF_EXPORT_TYPE",
    1403: "MQIACF_EXPORT_ATTRS",
    1404: "MQIACF_SYSTEM_OBJECTS",
    1405: "MQIACF_CONNECTION_SWAP",
    1406: "MQIACF_AMQP_DIAGNOSTICS_TYPE",
    1408: "MQIACF_BUFFER_POOL_LOCATION",
    1409: "MQIACF_LDAP_CONNECTION_STATUS",
    1410: "MQIACF_SYSP_MAX_ACE_POOL",
    1411: "MQIACF_PAGECLAS",
    1412: "MQIACF_AUTH_REC_TYPE",
    1413: "MQIACF_SYSP_MAX_CONC_OFFLOADS",
    1414: "MQIACF_SYSP_ZHYPERWRITE",
    1415: "MQIACF_Q_MGR_STATUS_LOG",
    1416: "MQIACF_ARCHIVE_LOG_SIZE",
    1417: "MQIACF_MEDIA_LOG_SIZE",
    1418: "MQIACF_RESTART_LOG_SIZE",
    1419: "MQIACF_REUSABLE_LOG_SIZE",
    1420: "MQIACF_LOG_IN_USE",
    1421: "MQIACF_LOG_UTILIZATION",
    1422: "MQIACF_LOG_REDUCTION",
    1423: "MQIACF_IGNORE_STATE",
    1424: "MQIACF_MOVABLE_APPL_COUNT",
    1425: "MQIACF_APPL_INFO_ATTRS",
    1426: "MQIACF_APPL_MOVABLE",
    1427: "MQIACF_REMOTE_QMGR_ACTIVE",
    1428: "MQIACF_APPL_INFO_TYPE",
    1429: "MQIACF_APPL_INFO_APPL",
    1430: "MQIACF_APPL_INFO_QMGR",
    1431: "MQIACF_APPL_INFO_LOCAL",
    1432: "MQIACF_APPL_IMMOVABLE_COUNT",
    1433: "MQIACF_BALANCED",
    1434: "MQIACF_BALSTATE",
    1435: "MQIACF_APPL_IMMOVABLE_REASON",
    1436: "MQIACF_DS_ENCRYPTED",
    1437: "MQIACF_CUR_Q_FILE_SIZE",
    1438: "MQIACF_CUR_MAX_FILE_SIZE",
    1439: "MQIACF_BALANCING_TYPE",
    1440: "MQIACF_BALANCING_OPTIONS",
    1441: "MQIACF_BALANCING_TIMEOUT",
    1442: "MQIACF_SYSP_SMF_STAT_TIME_SECS",
    1443: "MQIACF_SYSP_SMF_ACCT_TIME_MINS",
    1444: "MQIACF_SYSP_SMF_ACCT_TIME_SECS",
    1445: "MQIACF_Q_MGR_STATUS_INFO_TYPE",
    1446: "MQIACF_Q_MGR_STATUS_INFO_Q_MGR",
    1447: "MQIACF_Q_MGR_STATUS_INFO_NHA",
    1448: "MQIACF_AUTO_CLUSTER_TYPE",
    1449: "MQIACF_DATA_FS_IN_USE",
    1450: "MQIACF_DATA_FS_SIZE",
    1451: "MQIACF_LOG_EXTENT_SIZE",
    1452: "MQIACF_LOG_FS_IN_USE",
    1453: "MQIACF_LOG_FS_SIZE",
    1454: "MQIACF_LOG_PRIMARIES",
    1455: "MQIACF_LOG_SECONDARIES",
    1456: "MQIACF_LOG_TYPE",
    1457: "MQIACF_NHA_INSTANCE_ACTV_CONNS",
    1458: "MQIACF_NHA_INSTANCE_BACKLOG",
    1459: "MQIACF_NHA_INSTANCE_IN_SYNC",
    1460: "MQIACF_NHA_INSTANCE_ROLE",
    1461: "MQIACF_NHA_IN_SYNC_INSTANCES",
    1462: "MQIACF_NHA_TOTAL_INSTANCES",
    1463: "MQIACF_Q_MGR_FS_ENCRYPTED",
    1464: "MQIACF_Q_MGR_FS_IN_USE",
    1465: "MQIACF_Q_MGR_FS_SIZE",
    1466: "MQIACF_SYSP_ZHYPERLINK",
    1468: "MQIACF_CHECKPOINT_COUNT",
    1469: "MQIACF_CHECKPOINT_OPERATIONS",
    1470: "MQIACF_CHECKPOINT_SIZE",
    1471: "MQIACF_NHA_GROUP_BACKLOG",
    1472: "MQIACF_NHA_GROUP_CONNECTED",
    1473: "MQIACF_NHA_GROUP_IN_SYNC",
    1474: "MQIACF_NHA_GROUP_ROLE",
    1475: "MQIACF_NHA_GROUP_STATUS",
    1476: "MQIACF_NHA_INSTANCE_STATUS",
    1477: "MQIACF_NHA_TYPE",
    1478: "MQIACF_EVENT_DUPLICATE_COUNT",
}

MQIACH_DICT = {
    1501: "MQIACH_XMIT_PROTOCOL_TYPE",
    1502: "MQIACH_BATCH_SIZE",
    1503: "MQIACH_DISC_INTERVAL",
    1504: "MQIACH_SHORT_TIMER",
    1505: "MQIACH_SHORT_RETRY",
    1506: "MQIACH_LONG_TIMER",
    1507: "MQIACH_LONG_RETRY",
    1508: "MQIACH_PUT_AUTHORITY",
    1509: "MQIACH_SEQUENCE_NUMBER_WRAP",
    1510: "MQIACH_MAX_MSG_LENGTH",
    1511: "MQIACH_CHANNEL_TYPE",
    1512: "MQIACH_DATA_COUNT",
    1513: "MQIACH_NAME_COUNT",
    1514: "MQIACH_MSG_SEQUENCE_NUMBER",
    1515: "MQIACH_DATA_CONVERSION",
    1516: "MQIACH_IN_DOUBT",
    1517: "MQIACH_MCA_TYPE",
    1518: "MQIACH_SESSION_COUNT",
    1519: "MQIACH_ADAPTER",
    1520: "MQIACH_COMMAND_COUNT",
    1521: "MQIACH_SOCKET",
    1522: "MQIACH_PORT",
    1523: "MQIACH_CHANNEL_INSTANCE_TYPE",
    1524: "MQIACH_CHANNEL_INSTANCE_ATTRS",
    1525: "MQIACH_CHANNEL_ERROR_DATA",
    1526: "MQIACH_CHANNEL_TABLE",
    1527: "MQIACH_CHANNEL_STATUS",
    1528: "MQIACH_INDOUBT_STATUS",
    1529: "MQIACH_LAST_SEQ_NUMBER",
    1531: "MQIACH_CURRENT_MSGS",
    1532: "MQIACH_CURRENT_SEQ_NUMBER",
    1533: "MQIACH_SSL_RETURN_CODE",
    1534: "MQIACH_MSGS",
    1535: "MQIACH_BYTES_SENT",
    1536: "MQIACH_BYTES_RCVD",
    1537: "MQIACH_BATCHES",
    1538: "MQIACH_BUFFERS_SENT",
    1539: "MQIACH_BUFFERS_RCVD",
    1540: "MQIACH_LONG_RETRIES_LEFT",
    1541: "MQIACH_SHORT_RETRIES_LEFT",
    1542: "MQIACH_MCA_STATUS",
    1543: "MQIACH_STOP_REQUESTED",
    1544: "MQIACH_MR_COUNT",
    1545: "MQIACH_MR_INTERVAL",
    1562: "MQIACH_NPM_SPEED",
    1563: "MQIACH_HB_INTERVAL",
    1564: "MQIACH_BATCH_INTERVAL",
    1565: "MQIACH_NETWORK_PRIORITY",
    1566: "MQIACH_KEEP_ALIVE_INTERVAL",
    1567: "MQIACH_BATCH_HB",
    1568: "MQIACH_SSL_CLIENT_AUTH",
    1570: "MQIACH_ALLOC_RETRY",
    1571: "MQIACH_ALLOC_FAST_TIMER",
    1572: "MQIACH_ALLOC_SLOW_TIMER",
    1573: "MQIACH_DISC_RETRY",
    1574: "MQIACH_PORT_NUMBER",
    1575: "MQIACH_HDR_COMPRESSION",
    1576: "MQIACH_MSG_COMPRESSION",
    1577: "MQIACH_CLWL_CHANNEL_RANK",
    1578: "MQIACH_CLWL_CHANNEL_PRIORITY",
    1579: "MQIACH_CLWL_CHANNEL_WEIGHT",
    1580: "MQIACH_CHANNEL_DISP",
    1581: "MQIACH_INBOUND_DISP",
    1582: "MQIACH_CHANNEL_TYPES",
    1583: "MQIACH_ADAPS_STARTED",
    1584: "MQIACH_ADAPS_MAX",
    1585: "MQIACH_DISPS_STARTED",
    1586: "MQIACH_DISPS_MAX",
    1587: "MQIACH_SSLTASKS_STARTED",
    1588: "MQIACH_SSLTASKS_MAX",
    1589: "MQIACH_CURRENT_CHL",
    1590: "MQIACH_CURRENT_CHL_MAX",
    1591: "MQIACH_CURRENT_CHL_TCP",
    1592: "MQIACH_CURRENT_CHL_LU62",
    1593: "MQIACH_ACTIVE_CHL",
    1594: "MQIACH_ACTIVE_CHL_MAX",
    1595: "MQIACH_ACTIVE_CHL_PAUSED",
    1596: "MQIACH_ACTIVE_CHL_STARTED",
    1597: "MQIACH_ACTIVE_CHL_STOPPED",
    1598: "MQIACH_ACTIVE_CHL_RETRY",
    1599: "MQIACH_LISTENER_STATUS",
    1600: "MQIACH_SHARED_CHL_RESTART",
    1601: "MQIACH_LISTENER_CONTROL",
    1602: "MQIACH_BACKLOG",
    1604: "MQIACH_XMITQ_TIME_INDICATOR",
    1605: "MQIACH_NETWORK_TIME_INDICATOR",
    1606: "MQIACH_EXIT_TIME_INDICATOR",
    1607: "MQIACH_BATCH_SIZE_INDICATOR",
    1608: "MQIACH_XMITQ_MSGS_AVAILABLE",
    1609: "MQIACH_CHANNEL_SUBSTATE",
    1610: "MQIACH_SSL_KEY_RESETS",
    1611: "MQIACH_COMPRESSION_RATE",
    1612: "MQIACH_COMPRESSION_TIME",
    1613: "MQIACH_MAX_XMIT_SIZE",
    1614: "MQIACH_DEF_CHANNEL_DISP",
    1615: "MQIACH_SHARING_CONVERSATIONS",
    1616: "MQIACH_MAX_SHARING_CONVS",
    1617: "MQIACH_CURRENT_SHARING_CONVS",
    1618: "MQIACH_MAX_INSTANCES",
    1619: "MQIACH_MAX_INSTS_PER_CLIENT",
    1620: "MQIACH_CLIENT_CHANNEL_WEIGHT",
    1621: "MQIACH_CONNECTION_AFFINITY",
    1622: "MQIACH_AUTH_INFO_TYPES",
    1623: "MQIACH_RESET_REQUESTED",
    1624: "MQIACH_BATCH_DATA_LIMIT",
    1625: "MQIACH_MSG_HISTORY",
    1626: "MQIACH_MULTICAST_PROPERTIES",
    1627: "MQIACH_NEW_SUBSCRIBER_HISTORY",
    1628: "MQIACH_MC_HB_INTERVAL",
    1629: "MQIACH_USE_CLIENT_ID",
    1630: "MQIACH_MQTT_KEEP_ALIVE",
    1631: "MQIACH_IN_DOUBT_IN",
    1632: "MQIACH_IN_DOUBT_OUT",
    1633: "MQIACH_MSGS_SENT",
    1634: "MQIACH_MSGS_RCVD",
    1635: "MQIACH_PENDING_OUT",
    1636: "MQIACH_AVAILABLE_CIPHERSPECS",
    1637: "MQIACH_MATCH",
    1638: "MQIACH_USER_SOURCE",
    1639: "MQIACH_WARNING",
    1640: "MQIACH_DEF_RECONNECT",
    1642: "MQIACH_CHANNEL_SUMMARY_ATTRS",
    1643: "MQIACH_PROTOCOL",
    1644: "MQIACH_AMQP_KEEP_ALIVE",
    1645: "MQIACH_SECURITY_PROTOCOL",
    1646: "MQIACH_SPL_PROTECTION",
}

MQIAMO64_DICT = {
    703: "MQIAMO64_AVG_Q_TIME",
    741: "MQIAMO64_Q_TIME_AVG",
    742: "MQIAMO64_Q_TIME_MAX",
    743: "MQIAMO64_Q_TIME_MIN",
    745: "MQIAMO64_BROWSE_BYTES",
    746: "MQIAMO64_BYTES",
    747: "MQIAMO64_GET_BYTES",
    748: "MQIAMO64_PUT_BYTES",
    783: "MQIAMO64_TOPIC_PUT_BYTES",
    785: "MQIAMO64_PUBLISH_MSG_BYTES",
    838: "MQIAMO64_HIGHRES_TIME",
    844: "MQIAMO64_QMGR_OP_DURATION",
    845: "MQIAMO64_MONITOR_INTERVAL",
}

MQIAMO_DICT = {
    702: "MQIAMO_AVG_BATCH_SIZE",
    703: "MQIAMO_AVG_Q_TIME",
    704: "MQIAMO_BACKOUTS",
    705: "MQIAMO_BROWSES",
    706: "MQIAMO_BROWSE_MAX_BYTES",
    707: "MQIAMO_BROWSE_MIN_BYTES",
    708: "MQIAMO_BROWSES_FAILED",
    709: "MQIAMO_CLOSES",
    710: "MQIAMO_COMMITS",
    711: "MQIAMO_COMMITS_FAILED",
    712: "MQIAMO_CONNS",
    713: "MQIAMO_CONNS_MAX",
    714: "MQIAMO_DISCS",
    715: "MQIAMO_DISCS_IMPLICIT",
    716: "MQIAMO_DISC_TYPE",
    717: "MQIAMO_EXIT_TIME_AVG",
    718: "MQIAMO_EXIT_TIME_MAX",
    719: "MQIAMO_EXIT_TIME_MIN",
    720: "MQIAMO_FULL_BATCHES",
    721: "MQIAMO_GENERATED_MSGS",
    722: "MQIAMO_GETS",
    723: "MQIAMO_GET_MAX_BYTES",
    724: "MQIAMO_GET_MIN_BYTES",
    725: "MQIAMO_GETS_FAILED",
    726: "MQIAMO_INCOMPLETE_BATCHES",
    727: "MQIAMO_INQS",
    728: "MQIAMO_MSGS",
    729: "MQIAMO_NET_TIME_AVG",
    730: "MQIAMO_NET_TIME_MAX",
    731: "MQIAMO_NET_TIME_MIN",
    732: "MQIAMO_OBJECT_COUNT",
    733: "MQIAMO_OPENS",
    734: "MQIAMO_PUT1S",
    735: "MQIAMO_PUTS",
    736: "MQIAMO_PUT_MAX_BYTES",
    737: "MQIAMO_PUT_MIN_BYTES",
    738: "MQIAMO_PUT_RETRIES",
    739: "MQIAMO_Q_MAX_DEPTH",
    740: "MQIAMO_Q_MIN_DEPTH",
    741: "MQIAMO_Q_TIME_AVG",
    742: "MQIAMO_Q_TIME_MAX",
    743: "MQIAMO_Q_TIME_MIN",
    744: "MQIAMO_SETS",
    749: "MQIAMO_CONNS_FAILED",
    751: "MQIAMO_OPENS_FAILED",
    752: "MQIAMO_INQS_FAILED",
    753: "MQIAMO_SETS_FAILED",
    754: "MQIAMO_PUTS_FAILED",
    755: "MQIAMO_PUT1S_FAILED",
    757: "MQIAMO_CLOSES_FAILED",
    758: "MQIAMO_MSGS_EXPIRED",
    759: "MQIAMO_MSGS_NOT_QUEUED",
    760: "MQIAMO_MSGS_PURGED",
    764: "MQIAMO_SUBS_DUR",
    765: "MQIAMO_SUBS_NDUR",
    766: "MQIAMO_SUBS_FAILED",
    767: "MQIAMO_SUBRQS",
    768: "MQIAMO_SUBRQS_FAILED",
    769: "MQIAMO_CBS",
    770: "MQIAMO_CBS_FAILED",
    771: "MQIAMO_CTLS",
    772: "MQIAMO_CTLS_FAILED",
    773: "MQIAMO_STATS",
    774: "MQIAMO_STATS_FAILED",
    775: "MQIAMO_SUB_DUR_HIGHWATER",
    776: "MQIAMO_SUB_DUR_LOWWATER",
    777: "MQIAMO_SUB_NDUR_HIGHWATER",
    778: "MQIAMO_SUB_NDUR_LOWWATER",
    779: "MQIAMO_TOPIC_PUTS",
    780: "MQIAMO_TOPIC_PUTS_FAILED",
    781: "MQIAMO_TOPIC_PUT1S",
    782: "MQIAMO_TOPIC_PUT1S_FAILED",
    784: "MQIAMO_PUBLISH_MSG_COUNT",
    786: "MQIAMO_UNSUBS_DUR",
    787: "MQIAMO_UNSUBS_NDUR",
    788: "MQIAMO_UNSUBS_FAILED",
    789: "MQIAMO_INTERVAL",
    790: "MQIAMO_MSGS_SENT",
    791: "MQIAMO_BYTES_SENT",
    792: "MQIAMO_REPAIR_BYTES",
    793: "MQIAMO_FEEDBACK_MODE",
    794: "MQIAMO_RELIABILITY_TYPE",
    795: "MQIAMO_LATE_JOIN_MARK",
    796: "MQIAMO_NACKS_RCVD",
    797: "MQIAMO_REPAIR_PKTS",
    798: "MQIAMO_HISTORY_PKTS",
    799: "MQIAMO_PENDING_PKTS",
    800: "MQIAMO_PKT_RATE",
    801: "MQIAMO_MCAST_XMIT_RATE",
    802: "MQIAMO_MCAST_BATCH_TIME",
    803: "MQIAMO_MCAST_HEARTBEAT",
    804: "MQIAMO_DEST_DATA_PORT",
    805: "MQIAMO_DEST_REPAIR_PORT",
    806: "MQIAMO_ACKS_RCVD",
    807: "MQIAMO_ACTIVE_ACKERS",
    808: "MQIAMO_PKTS_SENT",
    809: "MQIAMO_TOTAL_REPAIR_PKTS",
    810: "MQIAMO_TOTAL_PKTS_SENT",
    811: "MQIAMO_TOTAL_MSGS_SENT",
    812: "MQIAMO_TOTAL_BYTES_SENT",
    813: "MQIAMO_NUM_STREAMS",
    814: "MQIAMO_ACK_FEEDBACK",
    815: "MQIAMO_NACK_FEEDBACK",
    816: "MQIAMO_PKTS_LOST",
    817: "MQIAMO_MSGS_RCVD",
    818: "MQIAMO_MSG_BYTES_RCVD",
    819: "MQIAMO_MSGS_DELIVERED",
    820: "MQIAMO_PKTS_PROCESSED",
    821: "MQIAMO_PKTS_DELIVERED",
    822: "MQIAMO_PKTS_DROPPED",
    823: "MQIAMO_PKTS_DUPLICATED",
    824: "MQIAMO_NACKS_CREATED",
    825: "MQIAMO_NACK_PKTS_SENT",
    826: "MQIAMO_REPAIR_PKTS_RQSTD",
    827: "MQIAMO_REPAIR_PKTS_RCVD",
    828: "MQIAMO_PKTS_REPAIRED",
    829: "MQIAMO_TOTAL_MSGS_RCVD",
    830: "MQIAMO_TOTAL_MSG_BYTES_RCVD",
    831: "MQIAMO_TOTAL_REPAIR_PKTS_RCVD",
    832: "MQIAMO_TOTAL_REPAIR_PKTS_RQSTD",
    833: "MQIAMO_TOTAL_MSGS_PROCESSED",
    834: "MQIAMO_TOTAL_MSGS_SELECTED",
    835: "MQIAMO_TOTAL_MSGS_EXPIRED",
    836: "MQIAMO_TOTAL_MSGS_DELIVERED",
    837: "MQIAMO_TOTAL_MSGS_RETURNED",
    839: "MQIAMO_MONITOR_CLASS",
    840: "MQIAMO_MONITOR_TYPE",
    841: "MQIAMO_MONITOR_ELEMENT",
    842: "MQIAMO_MONITOR_DATATYPE",
    843: "MQIAMO_MONITOR_FLAGS",
}

MQIAMO_MONITOR_DATATYPE_DICT = {
    1: "MQIAMO_MONITOR_UNIT",
    2: "MQIAMO_MONITOR_DELTA",
    3: "MQIAMO_MONITOR_LSN",
    100: "MQIAMO_MONITOR_HUNDREDTHS",
    1024: "MQIAMO_MONITOR_KB",
    10000: "MQIAMO_MONITOR_PERCENT",
    1000000: "MQIAMO_MONITOR_MICROSEC",
    1048576: "MQIAMO_MONITOR_MB",
    100000000: "MQIAMO_MONITOR_GB",
}

MQIAMO_MONITOR_FLAGS_DICT = {
    0: "MQIAMO_MONITOR_FLAGS_NONE",
    1: "MQIAMO_MONITOR_FLAGS_OBJNAME",
}

MQIASY_DICT = {
    -9: "MQIASY_VERSION",
    -8: "MQIASY_BAG_OPTIONS",
    -7: "MQIASY_REASON",
    -6: "MQIASY_COMP_CODE",
    -5: "MQIASY_CONTROL",
    -4: "MQIASY_MSG_SEQ_NUMBER",
    -3: "MQIASY_COMMAND",
    -2: "MQIASY_TYPE",
    -1: "MQIASY_CODED_CHAR_SET_ID",
}

MQIAV_DICT = {
    -2: "MQIAV_UNDEFINED",
    -1: "MQIAV_NOT_APPLICABLE",
}

MQIA_DICT = {
    1: "MQIA_APPL_TYPE",
    2: "MQIA_CODED_CHAR_SET_ID",
    3: "MQIA_CURRENT_Q_DEPTH",
    4: "MQIA_DEF_INPUT_OPEN_OPTION",
    5: "MQIA_DEF_PERSISTENCE",
    6: "MQIA_DEF_PRIORITY",
    7: "MQIA_DEFINITION_TYPE",
    8: "MQIA_HARDEN_GET_BACKOUT",
    9: "MQIA_INHIBIT_GET",
    10: "MQIA_INHIBIT_PUT",
    11: "MQIA_MAX_HANDLES",
    12: "MQIA_USAGE",
    13: "MQIA_MAX_MSG_LENGTH",
    14: "MQIA_MAX_PRIORITY",
    15: "MQIA_MAX_Q_DEPTH",
    16: "MQIA_MSG_DELIVERY_SEQUENCE",
    17: "MQIA_OPEN_INPUT_COUNT",
    18: "MQIA_OPEN_OUTPUT_COUNT",
    19: "MQIA_NAME_COUNT",
    20: "MQIA_Q_TYPE",
    21: "MQIA_RETENTION_INTERVAL",
    22: "MQIA_BACKOUT_THRESHOLD",
    23: "MQIA_SHAREABILITY",
    24: "MQIA_TRIGGER_CONTROL",
    25: "MQIA_TRIGGER_INTERVAL",
    26: "MQIA_TRIGGER_MSG_PRIORITY",
    27: "MQIA_CPI_LEVEL",
    28: "MQIA_TRIGGER_TYPE",
    29: "MQIA_TRIGGER_DEPTH",
    30: "MQIA_SYNCPOINT",
    31: "MQIA_COMMAND_LEVEL",
    32: "MQIA_PLATFORM",
    33: "MQIA_MAX_UNCOMMITTED_MSGS",
    34: "MQIA_DIST_LISTS",
    35: "MQIA_TIME_SINCE_RESET",
    36: "MQIA_HIGH_Q_DEPTH",
    37: "MQIA_MSG_ENQ_COUNT",
    38: "MQIA_MSG_DEQ_COUNT",
    39: "MQIA_EXPIRY_INTERVAL",
    40: "MQIA_Q_DEPTH_HIGH_LIMIT",
    41: "MQIA_Q_DEPTH_LOW_LIMIT",
    42: "MQIA_Q_DEPTH_MAX_EVENT",
    43: "MQIA_Q_DEPTH_HIGH_EVENT",
    44: "MQIA_Q_DEPTH_LOW_EVENT",
    45: "MQIA_SCOPE",
    46: "MQIA_Q_SERVICE_INTERVAL_EVENT",
    47: "MQIA_AUTHORITY_EVENT",
    48: "MQIA_INHIBIT_EVENT",
    49: "MQIA_LOCAL_EVENT",
    50: "MQIA_REMOTE_EVENT",
    51: "MQIA_CONFIGURATION_EVENT",
    52: "MQIA_START_STOP_EVENT",
    53: "MQIA_PERFORMANCE_EVENT",
    54: "MQIA_Q_SERVICE_INTERVAL",
    55: "MQIA_CHANNEL_AUTO_DEF",
    56: "MQIA_CHANNEL_AUTO_DEF_EVENT",
    57: "MQIA_INDEX_TYPE",
    58: "MQIA_CLUSTER_WORKLOAD_LENGTH",
    59: "MQIA_CLUSTER_Q_TYPE",
    60: "MQIA_ARCHIVE",
    61: "MQIA_DEF_BIND",
    62: "MQIA_PAGESET_ID",
    63: "MQIA_QSG_DISP",
    64: "MQIA_INTRA_GROUP_QUEUING",
    65: "MQIA_IGQ_PUT_AUTHORITY",
    66: "MQIA_AUTH_INFO_TYPE",
    68: "MQIA_MSG_MARK_BROWSE_INTERVAL",
    69: "MQIA_SSL_TASKS",
    70: "MQIA_CF_LEVEL",
    71: "MQIA_CF_RECOVER",
    72: "MQIA_NAMELIST_TYPE",
    73: "MQIA_CHANNEL_EVENT",
    74: "MQIA_BRIDGE_EVENT",
    75: "MQIA_SSL_EVENT",
    76: "MQIA_SSL_RESET_COUNT",
    77: "MQIA_SHARED_Q_Q_MGR_NAME",
    78: "MQIA_NPM_CLASS",
    80: "MQIA_MAX_OPEN_Q",
    81: "MQIA_MONITOR_INTERVAL",
    82: "MQIA_Q_USERS",
    83: "MQIA_MAX_GLOBAL_LOCKS",
    84: "MQIA_MAX_LOCAL_LOCKS",
    85: "MQIA_LISTENER_PORT_NUMBER",
    86: "MQIA_BATCH_INTERFACE_AUTO",
    87: "MQIA_CMD_SERVER_AUTO",
    88: "MQIA_CMD_SERVER_CONVERT_MSG",
    89: "MQIA_CMD_SERVER_DLQ_MSG",
    90: "MQIA_MAX_Q_TRIGGERS",
    91: "MQIA_TRIGGER_RESTART",
    92: "MQIA_SSL_FIPS_REQUIRED",
    93: "MQIA_IP_ADDRESS_VERSION",
    94: "MQIA_LOGGER_EVENT",
    95: "MQIA_CLWL_Q_RANK",
    96: "MQIA_CLWL_Q_PRIORITY",
    97: "MQIA_CLWL_MRU_CHANNELS",
    98: "MQIA_CLWL_USEQ",
    99: "MQIA_COMMAND_EVENT",
    100: "MQIA_ACTIVE_CHANNELS",
    101: "MQIA_CHINIT_ADAPTERS",
    102: "MQIA_ADOPTNEWMCA_CHECK",
    103: "MQIA_ADOPTNEWMCA_TYPE",
    104: "MQIA_ADOPTNEWMCA_INTERVAL",
    105: "MQIA_CHINIT_DISPATCHERS",
    106: "MQIA_DNS_WLM",
    107: "MQIA_LISTENER_TIMER",
    108: "MQIA_LU62_CHANNELS",
    109: "MQIA_MAX_CHANNELS",
    110: "MQIA_OUTBOUND_PORT_MIN",
    111: "MQIA_RECEIVE_TIMEOUT",
    112: "MQIA_RECEIVE_TIMEOUT_TYPE",
    113: "MQIA_RECEIVE_TIMEOUT_MIN",
    114: "MQIA_TCP_CHANNELS",
    115: "MQIA_TCP_KEEP_ALIVE",
    116: "MQIA_TCP_STACK_TYPE",
    117: "MQIA_CHINIT_TRACE_AUTO_START",
    118: "MQIA_CHINIT_TRACE_TABLE_SIZE",
    119: "MQIA_CHINIT_CONTROL",
    120: "MQIA_CMD_SERVER_CONTROL",
    121: "MQIA_SERVICE_TYPE",
    122: "MQIA_MONITORING_CHANNEL",
    123: "MQIA_MONITORING_Q",
    124: "MQIA_MONITORING_AUTO_CLUSSDR",
    127: "MQIA_STATISTICS_MQI",
    128: "MQIA_STATISTICS_Q",
    129: "MQIA_STATISTICS_CHANNEL",
    130: "MQIA_STATISTICS_AUTO_CLUSSDR",
    131: "MQIA_STATISTICS_INTERVAL",
    133: "MQIA_ACCOUNTING_MQI",
    134: "MQIA_ACCOUNTING_Q",
    135: "MQIA_ACCOUNTING_INTERVAL",
    136: "MQIA_ACCOUNTING_CONN_OVERRIDE",
    137: "MQIA_TRACE_ROUTE_RECORDING",
    138: "MQIA_ACTIVITY_RECORDING",
    139: "MQIA_SERVICE_CONTROL",
    140: "MQIA_OUTBOUND_PORT_MAX",
    141: "MQIA_SECURITY_CASE",
    150: "MQIA_QMOPT_CSMT_ON_ERROR",
    151: "MQIA_QMOPT_CONS_INFO_MSGS",
    152: "MQIA_QMOPT_CONS_WARNING_MSGS",
    153: "MQIA_QMOPT_CONS_ERROR_MSGS",
    154: "MQIA_QMOPT_CONS_CRITICAL_MSGS",
    155: "MQIA_QMOPT_CONS_COMMS_MSGS",
    156: "MQIA_QMOPT_CONS_REORG_MSGS",
    157: "MQIA_QMOPT_CONS_SYSTEM_MSGS",
    158: "MQIA_QMOPT_LOG_INFO_MSGS",
    159: "MQIA_QMOPT_LOG_WARNING_MSGS",
    160: "MQIA_QMOPT_LOG_ERROR_MSGS",
    161: "MQIA_QMOPT_LOG_CRITICAL_MSGS",
    162: "MQIA_QMOPT_LOG_COMMS_MSGS",
    163: "MQIA_QMOPT_LOG_REORG_MSGS",
    164: "MQIA_QMOPT_LOG_SYSTEM_MSGS",
    165: "MQIA_QMOPT_TRACE_MQI_CALLS",
    166: "MQIA_QMOPT_TRACE_COMMS",
    167: "MQIA_QMOPT_TRACE_REORG",
    168: "MQIA_QMOPT_TRACE_CONVERSION",
    169: "MQIA_QMOPT_TRACE_SYSTEM",
    170: "MQIA_QMOPT_INTERNAL_DUMP",
    171: "MQIA_MAX_RECOVERY_TASKS",
    172: "MQIA_MAX_CLIENTS",
    173: "MQIA_AUTO_REORGANIZATION",
    174: "MQIA_AUTO_REORG_INTERVAL",
    175: "MQIA_DURABLE_SUB",
    176: "MQIA_MULTICAST",
    181: "MQIA_INHIBIT_PUB",
    182: "MQIA_INHIBIT_SUB",
    183: "MQIA_TREE_LIFE_TIME",
    184: "MQIA_DEF_PUT_RESPONSE_TYPE",
    185: "MQIA_TOPIC_DEF_PERSISTENCE",
    186: "MQIA_MASTER_ADMIN",
    187: "MQIA_PUBSUB_MODE",
    188: "MQIA_DEF_READ_AHEAD",
    189: "MQIA_READ_AHEAD",
    190: "MQIA_PROPERTY_CONTROL",
    192: "MQIA_MAX_PROPERTIES_LENGTH",
    193: "MQIA_BASE_TYPE",
    195: "MQIA_PM_DELIVERY",
    196: "MQIA_NPM_DELIVERY",
    199: "MQIA_PROXY_SUB",
    203: "MQIA_PUBSUB_NP_MSG",
    204: "MQIA_SUB_COUNT",
    205: "MQIA_PUBSUB_NP_RESP",
    206: "MQIA_PUBSUB_MAXMSG_RETRY_COUNT",
    207: "MQIA_PUBSUB_SYNC_PT",
    208: "MQIA_TOPIC_TYPE",
    215: "MQIA_PUB_COUNT",
    216: "MQIA_WILDCARD_OPERATION",
    218: "MQIA_SUB_SCOPE",
    219: "MQIA_PUB_SCOPE",
    221: "MQIA_GROUP_UR",
    222: "MQIA_UR_DISP",
    223: "MQIA_COMM_INFO_TYPE",
    224: "MQIA_CF_OFFLOAD",
    225: "MQIA_CF_OFFLOAD_THRESHOLD1",
    226: "MQIA_CF_OFFLOAD_THRESHOLD2",
    227: "MQIA_CF_OFFLOAD_THRESHOLD3",
    228: "MQIA_CF_SMDS_BUFFERS",
    229: "MQIA_CF_OFFLDUSE",
    230: "MQIA_MAX_RESPONSES",
    231: "MQIA_RESPONSE_RESTART_POINT",
    232: "MQIA_COMM_EVENT",
    233: "MQIA_MCAST_BRIDGE",
    234: "MQIA_USE_DEAD_LETTER_Q",
    235: "MQIA_TOLERATE_UNPROTECTED",
    236: "MQIA_SIGNATURE_ALGORITHM",
    237: "MQIA_ENCRYPTION_ALGORITHM",
    238: "MQIA_POLICY_VERSION",
    239: "MQIA_ACTIVITY_CONN_OVERRIDE",
    240: "MQIA_ACTIVITY_TRACE",
    242: "MQIA_SUB_CONFIGURATION_EVENT",
    243: "MQIA_XR_CAPABILITY",
    244: "MQIA_CF_RECAUTO",
    245: "MQIA_QMGR_CFCONLOS",
    246: "MQIA_CF_CFCONLOS",
    247: "MQIA_SUITE_B_STRENGTH",
    248: "MQIA_CHLAUTH_RECORDS",
    249: "MQIA_PUBSUB_CLUSTER",
    250: "MQIA_DEF_CLUSTER_XMIT_Q_TYPE",
    251: "MQIA_PROT_POLICY_CAPABILITY",
    252: "MQIA_CERT_VAL_POLICY",
    253: "MQIA_TOPIC_NODE_COUNT",
    254: "MQIA_REVERSE_DNS_LOOKUP",
    255: "MQIA_CLUSTER_PUB_ROUTE",
    256: "MQIA_CLUSTER_OBJECT_STATE",
    257: "MQIA_CHECK_LOCAL_BINDING",
    258: "MQIA_CHECK_CLIENT_BINDING",
    259: "MQIA_AUTHENTICATION_FAIL_DELAY",
    260: "MQIA_ADOPT_CONTEXT",
    261: "MQIA_LDAP_SECURE_COMM",
    262: "MQIA_DISPLAY_TYPE",
    263: "MQIA_LDAP_AUTHORMD",
    264: "MQIA_LDAP_NESTGRP",
    265: "MQIA_AMQP_CAPABILITY",
    266: "MQIA_AUTHENTICATION_METHOD",
    267: "MQIA_KEY_REUSE_COUNT",
    268: "MQIA_MEDIA_IMAGE_SCHEDULING",
    269: "MQIA_MEDIA_IMAGE_INTERVAL",
    270: "MQIA_MEDIA_IMAGE_LOG_LENGTH",
    271: "MQIA_MEDIA_IMAGE_RECOVER_OBJ",
    272: "MQIA_MEDIA_IMAGE_RECOVER_Q",
    273: "MQIA_ADVANCED_CAPABILITY",
    274: "MQIA_MAX_Q_FILE_SIZE",
    275: "MQIA_STREAM_QUEUE_QOS",
    276: "MQIA_CAP_EXPIRY",
    277: "MQIA_AUTHOREV_SCOPE",
    278: "MQIA_OTEL_TRACE",
    279: "MQIA_OTEL_PROPAGATION_CONTROL",
    2000: "MQIA_USER_LIST",
}

MQIDO_DICT = {
    1: "MQIDO_COMMIT",
    2: "MQIDO_BACKOUT",
}

MQIEPF_DICT = {
    0: "MQIEPF_NONE",
    1: "MQIEPF_THREADED_LIBRARY",
    2: "MQIEPF_LOCAL_LIBRARY",
}

MQIGQPA_DICT = {
    1: "MQIGQPA_DEFAULT",
    2: "MQIGQPA_CONTEXT",
    3: "MQIGQPA_ONLY_IGQ",
    4: "MQIGQPA_ALTERNATE_OR_IGQ",
}

MQIGQ_DICT = {
    0: "MQIGQ_DISABLED",
    1: "MQIGQ_ENABLED",
}

MQIIH_DICT = {
    0: "MQIIH_NONE",
    1: "MQIIH_PASS_EXPIRATION",
    8: "MQIIH_REPLY_FORMAT_NONE",
    16: "MQIIH_IGNORE_PURG",
    32: "MQIIH_CM0_REQUEST_RESPONSE",
}

MQIMGRCOV_DICT = {
    0: "MQIMGRCOV_NO",
    1: "MQIMGRCOV_YES",
    2: "MQIMGRCOV_AS_Q_MGR",
}

MQIMMREASON_DICT = {
    0: "MQIMMREASON_NONE",
    1: "MQIMMREASON_NOT_CLIENT",
    2: "MQIMMREASON_NOT_RECONNECTABLE",
    3: "MQIMMREASON_MOVING",
    4: "MQIMMREASON_APPLNAME_CHANGED",
    5: "MQIMMREASON_IN_TRANSACTION",
    6: "MQIMMREASON_AWAITS_REPLY",
    7: "MQIMMREASON_NO_REDIRECT",
}

MQIMPO_DICT = {
    0: "MQIMPO_NONE",
    2: "MQIMPO_CONVERT_TYPE",
    4: "MQIMPO_QUERY_LENGTH",
    8: "MQIMPO_INQ_NEXT",
    16: "MQIMPO_INQ_PROP_UNDER_CURSOR",
    32: "MQIMPO_CONVERT_VALUE",
}

MQINBD_DICT = {
    0: "MQINBD_Q_MGR",
    3: "MQINBD_GROUP",
}

MQIND_DICT = {
    -2: "MQIND_ALL",
    -1: "MQIND_NONE",
}

MQIPADDR_DICT = {
    0: "MQIPADDR_IPV4",
    1: "MQIPADDR_IPV6",
}

MQIS_DICT = {
    0: "MQIS_NO",
    1: "MQIS_YES",
}

MQIT_DICT = {
    0: "MQIT_NONE",
    1: "MQIT_MSG_ID",
    2: "MQIT_CORREL_ID",
    4: "MQIT_MSG_TOKEN",
    5: "MQIT_GROUP_ID",
}

MQKAI_DICT = {
    -1: "MQKAI_AUTO",
}

MQKEY_DICT = {
    -1: "MQKEY_REUSE_UNLIMITED",
    0: "MQKEY_REUSE_DISABLED",
}

MQLDAPC_DICT = {
    0: "MQLDAPC_INACTIVE",
    1: "MQLDAPC_CONNECTED",
    2: "MQLDAPC_ERROR",
}

MQLDAP_AUTHORMD_DICT = {
    0: "MQLDAP_AUTHORMD_OS",
    1: "MQLDAP_AUTHORMD_SEARCHGRP",
    2: "MQLDAP_AUTHORMD_SEARCHUSR",
    3: "MQLDAP_AUTHORMD_SRCHGRPSN",
}

MQLDAP_NESTGRP_DICT = {
    0: "MQLDAP_NESTGRP_NO",
    1: "MQLDAP_NESTGRP_YES",
}

MQLOGTYPE_DICT = {
    0: "MQLOGTYPE_CIRCULAR",
    1: "MQLOGTYPE_LINEAR",
    2: "MQLOGTYPE_REPLICATED",
}

MQLR_DICT = {
    -2: "MQLR_MAX",
    -1: "MQLR_AUTO",
    1: "MQLR_ONE",
}

MQMASTER_DICT = {
    0: "MQMASTER_NO",
    1: "MQMASTER_YES",
}

MQMATCH_DICT = {
    0: "MQMATCH_GENERIC",
    1: "MQMATCH_RUNCHECK",
    2: "MQMATCH_EXACT",
    3: "MQMATCH_ALL",
}

MQMCAS_DICT = {
    0: "MQMCAS_STOPPED",
    3: "MQMCAS_RUNNING",
}

MQMCAT_DICT = {
    1: "MQMCAT_PROCESS",
    2: "MQMCAT_THREAD",
}

MQMCB_DICT = {
    0: "MQMCB_DISABLED",
    1: "MQMCB_ENABLED",
}

MQMCEV_DICT = {
    1: "MQMCEV_PACKET_LOSS",
    2: "MQMCEV_HEARTBEAT_TIMEOUT",
    3: "MQMCEV_VERSION_CONFLICT",
    4: "MQMCEV_RELIABILITY",
    5: "MQMCEV_CLOSED_TRANS",
    6: "MQMCEV_STREAM_ERROR",
    10: "MQMCEV_NEW_SOURCE",
    11: "MQMCEV_RECEIVE_QUEUE_TRIMMED",
    12: "MQMCEV_PACKET_LOSS_NACK_EXPIRE",
    13: "MQMCEV_ACK_RETRIES_EXCEEDED",
    14: "MQMCEV_STREAM_SUSPEND_NACK",
    15: "MQMCEV_STREAM_RESUME_NACK",
    16: "MQMCEV_STREAM_EXPELLED",
    20: "MQMCEV_FIRST_MESSAGE",
    21: "MQMCEV_LATE_JOIN_FAILURE",
    22: "MQMCEV_MESSAGE_LOSS",
    23: "MQMCEV_SEND_PACKET_FAILURE",
    24: "MQMCEV_REPAIR_DELAY",
    25: "MQMCEV_MEMORY_ALERT_ON",
    26: "MQMCEV_MEMORY_ALERT_OFF",
    27: "MQMCEV_NACK_ALERT_ON",
    28: "MQMCEV_NACK_ALERT_OFF",
    29: "MQMCEV_REPAIR_ALERT_ON",
    30: "MQMCEV_REPAIR_ALERT_OFF",
    31: "MQMCEV_RELIABILITY_CHANGED",
    80: "MQMCEV_SHM_DEST_UNUSABLE",
    81: "MQMCEV_SHM_PORT_UNUSABLE",
    110: "MQMCEV_CCT_GETTIME_FAILED",
    120: "MQMCEV_DEST_INTERFACE_FAILURE",
    121: "MQMCEV_DEST_INTERFACE_FAILOVER",
    122: "MQMCEV_PORT_INTERFACE_FAILURE",
    123: "MQMCEV_PORT_INTERFACE_FAILOVER",
}

MQMCP_DICT = {
    -2: "MQMCP_COMPAT",
    -1: "MQMCP_ALL",
    0: "MQMCP_NONE",
    1: "MQMCP_USER",
    2: "MQMCP_REPLY",
}

MQMC_DICT = {
    0: "MQMC_AS_PARENT",
    1: "MQMC_ENABLED",
    2: "MQMC_DISABLED",
    3: "MQMC_ONLY",
}

MQMDEF_DICT = {
    0: "MQMDEF_NONE",
}

MQMDS_DICT = {
    0: "MQMDS_PRIORITY",
    1: "MQMDS_FIFO",
}

MQMEDIMGINTVL_DICT = {
    0: "MQMEDIMGINTVL_OFF",
}

MQMEDIMGLOGLN_DICT = {
    0: "MQMEDIMGLOGLN_OFF",
}

MQMEDIMGSCHED_DICT = {
    0: "MQMEDIMGSCHED_MANUAL",
    1: "MQMEDIMGSCHED_AUTO",
}

MQMF_DICT = {
    -1048576: "MQMF_ACCEPT_UNSUP_MASK",
    0: "MQMF_NONE",
    1: "MQMF_SEGMENTATION_ALLOWED",
    2: "MQMF_SEGMENT",
    4: "MQMF_LAST_SEGMENT",
    8: "MQMF_MSG_IN_GROUP",
    16: "MQMF_LAST_MSG_IN_GROUP",
    4095: "MQMF_REJECT_UNSUP_MASK",
    1044480: "MQMF_ACCEPT_UNSUP_IF_XMIT_MASK",
}

MQMHBO_DICT = {
    0: "MQMHBO_NONE",
    1: "MQMHBO_PROPERTIES_IN_MQRFH2",
    2: "MQMHBO_DELETE_PROPERTIES",
}

MQMLP_ENCRYPTION_DICT = {
    0: "MQMLP_ENCRYPTION_ALG_NONE",
    1: "MQMLP_ENCRYPTION_ALG_RC2",
    2: "MQMLP_ENCRYPTION_ALG_DES",
    3: "MQMLP_ENCRYPTION_ALG_3DES",
    4: "MQMLP_ENCRYPTION_ALG_AES128",
    5: "MQMLP_ENCRYPTION_ALG_AES256",
}

MQMLP_SIGN_DICT = {
    0: "MQMLP_SIGN_ALG_NONE",
    1: "MQMLP_SIGN_ALG_MD5",
    2: "MQMLP_SIGN_ALG_SHA1",
    3: "MQMLP_SIGN_ALG_SHA224",
    4: "MQMLP_SIGN_ALG_SHA256",
    5: "MQMLP_SIGN_ALG_SHA384",
    6: "MQMLP_SIGN_ALG_SHA512",
}

MQMLP_TOLERATE_DICT = {
    0: "MQMLP_TOLERATE_UNPROTECTED_NO",
    1: "MQMLP_TOLERATE_UNPROTECTED_YES",
}

MQMMBI_DICT = {
    -1: "MQMMBI_UNLIMITED",
}

MQMODE_DICT = {
    0: "MQMODE_FORCE",
    1: "MQMODE_QUIESCE",
    2: "MQMODE_TERMINATE",
}

MQMON_OVERRIDE_DICT = {
    0: "MQMON_DISABLED",
    1: "MQMON_ENABLED",
}

MQMON_DICT = {
    -3: "MQMON_Q_MGR",
    -1: "MQMON_NONE",
    0: "MQMON_OFF",
    1: "MQMON_ON",
    17: "MQMON_LOW",
    33: "MQMON_MEDIUM",
    65: "MQMON_HIGH",
}

MQMON_AVAILABILITY_DICT = {
    -1: "MQMON_NOT_AVAILABLE",
}

MQMO_DICT = {
    0: "MQMO_NONE",
    1: "MQMO_MATCH_MSG_ID",
    2: "MQMO_MATCH_CORREL_ID",
    4: "MQMO_MATCH_GROUP_ID",
    8: "MQMO_MATCH_MSG_SEQ_NUMBER",
    16: "MQMO_MATCH_OFFSET",
    32: "MQMO_MATCH_MSG_TOKEN",
}

MQMT_DICT = {
    1: "MQMT_REQUEST",
    2: "MQMT_REPLY",
    4: "MQMT_REPORT",
    8: "MQMT_DATAGRAM",
    112: "MQMT_MQE_FIELDS_FROM_MQE",
    113: "MQMT_MQE_FIELDS",
}

MQMULC_DICT = {
    0: "MQMULC_STANDARD",
    1: "MQMULC_REFINED",
}

MQNC_DICT = {
    256: "MQNC_MAX_NAMELIST_NAME_COUNT",
}

MQNHABACKLOG_DICT = {
    -1: "MQNHABACKLOG_UNKNOWN",
}

MQNHACONNACTV_DICT = {
    0: "MQNHACONNACTV_NO",
    1: "MQNHACONNACTV_YES",
}

MQNHACONNGRP_DICT = {
    0: "MQNHACONNGRP_NO",
    1: "MQNHACONNGRP_YES",
    2: "MQNHACONNGRP_SUSPENDED",
}

MQNHAGRPROLE_DICT = {
    0: "MQNHAGRPROLE_UNKNOWN",
    1: "MQNHAGRPROLE_NOT_CONFIGURED",
    2: "MQNHAGRPROLE_LIVE",
    3: "MQNHAGRPROLE_RECOVERY",
    4: "MQNHAGRPROLE_PENDING_LIVE",
    5: "MQNHAGRPROLE_PENDING_RECOVERY",
}

MQNHAINSYNC_DICT = {
    0: "MQNHAINSYNC_NO",
    1: "MQNHAINSYNC_YES",
}

MQNHAROLE_DICT = {
    0: "MQNHAROLE_UNKNOWN",
    1: "MQNHAROLE_ACTIVE",
    2: "MQNHAROLE_REPLICA",
    3: "MQNHAROLE_LEADER",
}

MQNHASTATUS_DICT = {
    0: "MQNHASTATUS_UNKNOWN",
    1: "MQNHASTATUS_NORMAL",
    2: "MQNHASTATUS_CHECKING",
    3: "MQNHASTATUS_SYNCHRONIZING",
    4: "MQNHASTATUS_REBASING",
    5: "MQNHASTATUS_DISK_FULL",
    6: "MQNHASTATUS_DISCONNECTED",
    7: "MQNHASTATUS_PARTITIONED",
}

MQNHATYPE_DICT = {
    -1: "MQNHATYPE_ALL",
    0: "MQNHATYPE_INSTANCE",
    1: "MQNHATYPE_GROUP",
}

MQNPMS_DICT = {
    1: "MQNPMS_NORMAL",
    2: "MQNPMS_FAST",
}

MQNPM_DICT = {
    0: "MQNPM_CLASS_NORMAL",
    10: "MQNPM_CLASS_HIGH",
}

MQNSH_DICT = {
    -1: "MQNSH_ALL",
    0: "MQNSH_NONE",
}

MQNT_DICT = {
    0: "MQNT_NONE",
    1: "MQNT_Q",
    2: "MQNT_CLUSTER",
    4: "MQNT_AUTH_INFO",
    1001: "MQNT_ALL",
}

MQOL_DICT = {
    -1: "MQOL_UNDEFINED",
}

MQOM_DICT = {
    0: "MQOM_NO",
    1: "MQOM_YES",
}

MQOO_DICT = {
    0: "MQOO_READ_AHEAD_AS_Q_DEF",
    1: "MQOO_INPUT_AS_Q_DEF",
    2: "MQOO_INPUT_SHARED",
    4: "MQOO_INPUT_EXCLUSIVE",
    8: "MQOO_BROWSE",
    16: "MQOO_OUTPUT",
    32: "MQOO_INQUIRE",
    64: "MQOO_SET",
    128: "MQOO_SAVE_ALL_CONTEXT",
    256: "MQOO_PASS_IDENTITY_CONTEXT",
    512: "MQOO_PASS_ALL_CONTEXT",
    1024: "MQOO_SET_IDENTITY_CONTEXT",
    2048: "MQOO_SET_ALL_CONTEXT",
    4096: "MQOO_ALTERNATE_USER_AUTHORITY",
    8192: "MQOO_FAIL_IF_QUIESCING",
    16384: "MQOO_BIND_ON_OPEN",
    32768: "MQOO_BIND_NOT_FIXED",
    65536: "MQOO_RESOLVE_NAMES",
    131072: "MQOO_CO_OP",
    262144: "MQOO_RESOLVE_LOCAL_Q",
    524288: "MQOO_NO_READ_AHEAD",
    1048576: "MQOO_READ_AHEAD",
    2097152: "MQOO_NO_MULTICAST",
    4194304: "MQOO_BIND_ON_GROUP",
}

MQOPER_DICT = {
    0: "MQOPER_UNKNOWN",
    1: "MQOPER_BROWSE",
    2: "MQOPER_DISCARD",
    3: "MQOPER_GET",
    4: "MQOPER_PUT",
    5: "MQOPER_PUT_REPLY",
    6: "MQOPER_PUT_REPORT",
    7: "MQOPER_RECEIVE",
    8: "MQOPER_SEND",
    9: "MQOPER_TRANSFORM",
    10: "MQOPER_PUBLISH",
    11: "MQOPER_EXCLUDED_PUBLISH",
    12: "MQOPER_DISCARDED_PUBLISH",
}

MQOPMODE_DICT = {
    0: "MQOPMODE_COMPAT",
    1: "MQOPMODE_NEW_FUNCTION",
}

MQOP_DICT = {
    1: "MQOP_START",
    2: "MQOP_START_WAIT",
    4: "MQOP_STOP",
    256: "MQOP_REGISTER",
    512: "MQOP_DEREGISTER",
    65536: "MQOP_SUSPEND",
    131072: "MQOP_RESUME",
}

MQOTEL_PCTL_DICT = {
    0: "MQOTEL_PCTL_QMGR",
    1: "MQOTEL_PCTL_MANUAL",
    2: "MQOTEL_PCTL_AUTO",
    3: "MQOTEL_PCTL_AS_PARENT",
}

MQOTEL_TRACE_DICT = {
    0: "MQOTEL_TRACE_QMGR",
    1: "MQOTEL_TRACE_OFF",
    2: "MQOTEL_TRACE_ON",
    3: "MQOTEL_TRACE_NONE",
    4: "MQOTEL_TRACE_AS_PARENT",
}

MQOT_DICT = {
    0: "MQOT_NONE",
    1: "MQOT_Q",
    2: "MQOT_NAMELIST",
    3: "MQOT_PROCESS",
    4: "MQOT_STORAGE_CLASS",
    5: "MQOT_Q_MGR",
    6: "MQOT_CHANNEL",
    7: "MQOT_AUTH_INFO",
    8: "MQOT_TOPIC",
    9: "MQOT_COMM_INFO",
    10: "MQOT_CF_STRUC",
    11: "MQOT_LISTENER",
    12: "MQOT_SERVICE",
    999: "MQOT_RESERVED_1",
    1001: "MQOT_ALL",
    1002: "MQOT_ALIAS_Q",
    1003: "MQOT_MODEL_Q",
    1004: "MQOT_LOCAL_Q",
    1005: "MQOT_REMOTE_Q",
    1007: "MQOT_SENDER_CHANNEL",
    1008: "MQOT_SERVER_CHANNEL",
    1009: "MQOT_REQUESTER_CHANNEL",
    1010: "MQOT_RECEIVER_CHANNEL",
    1011: "MQOT_CURRENT_CHANNEL",
    1012: "MQOT_SAVED_CHANNEL",
    1013: "MQOT_SVRCONN_CHANNEL",
    1014: "MQOT_CLNTCONN_CHANNEL",
    1015: "MQOT_SHORT_CHANNEL",
    1016: "MQOT_CHLAUTH",
    1017: "MQOT_REMOTE_Q_MGR_NAME",
    1019: "MQOT_PROT_POLICY",
    1020: "MQOT_TT_CHANNEL",
    1021: "MQOT_AMQP_CHANNEL",
    1022: "MQOT_AUTH_REC",
}

MQPAGECLAS_DICT = {
    0: "MQPAGECLAS_4KB",
    1: "MQPAGECLAS_FIXED4KB",
}

MQPA_DICT = {
    1: "MQPA_DEFAULT",
    2: "MQPA_CONTEXT",
    3: "MQPA_ONLY_MCA",
    4: "MQPA_ALTERNATE_OR_MCA",
}

MQPD_DICT = {
    -1048576: "MQPD_REJECT_UNSUP_MASK",
    0: "MQPD_NONE",
    1: "MQPD_SUPPORT_OPTIONAL",
    1023: "MQPD_ACCEPT_UNSUP_MASK",
    1024: "MQPD_SUPPORT_REQUIRED_IF_LOCAL",
    1047552: "MQPD_ACCEPT_UNSUP_IF_XMIT_MASK",
    1048576: "MQPD_SUPPORT_REQUIRED",
}

MQPER_DICT = {
    -1: "MQPER_PERSISTENCE_AS_PARENT",
    0: "MQPER_NOT_PERSISTENT",
    1: "MQPER_PERSISTENT",
    2: "MQPER_PERSISTENCE_AS_Q_DEF",
}

MQPL_DICT = {
    1: "MQPL_ZOS",
    2: "MQPL_OS2",
    3: "MQPL_UNIX",
    4: "MQPL_OS400",
    5: "MQPL_WINDOWS",
    11: "MQPL_WINDOWS_NT",
    12: "MQPL_VMS",
    13: "MQPL_NSK",
    15: "MQPL_OPEN_TP1",
    18: "MQPL_VM",
    23: "MQPL_TPF",
    27: "MQPL_VSE",
    28: "MQPL_APPLIANCE",
}

MQPMO_DICT = {
    0: "MQPMO_NONE",
    2: "MQPMO_SYNCPOINT",
    4: "MQPMO_NO_SYNCPOINT",
    32: "MQPMO_DEFAULT_CONTEXT",
    64: "MQPMO_NEW_MSG_ID",
    128: "MQPMO_NEW_CORREL_ID",
    256: "MQPMO_PASS_IDENTITY_CONTEXT",
    512: "MQPMO_PASS_ALL_CONTEXT",
    1024: "MQPMO_SET_IDENTITY_CONTEXT",
    2048: "MQPMO_SET_ALL_CONTEXT",
    4096: "MQPMO_ALTERNATE_USER_AUTHORITY",
    8192: "MQPMO_FAIL_IF_QUIESCING",
    16384: "MQPMO_NO_CONTEXT",
    32768: "MQPMO_LOGICAL_ORDER",
    65536: "MQPMO_ASYNC_RESPONSE",
    131072: "MQPMO_SYNC_RESPONSE",
    262144: "MQPMO_RESOLVE_LOCAL_Q",
    524288: "MQPMO_WARN_IF_NO_SUBS_MATCHED",
    2097152: "MQPMO_RETAIN",
    8388608: "MQPMO_MD_FOR_OUTPUT_ONLY",
    67108864: "MQPMO_SCOPE_QMGR",
    134217728: "MQPMO_SUPPRESS_REPLYTO",
    268435456: "MQPMO_NOT_OWN_SUBS",
}

MQPMRF_DICT = {
    0: "MQPMRF_NONE",
    1: "MQPMRF_MSG_ID",
    2: "MQPMRF_CORREL_ID",
    4: "MQPMRF_GROUP_ID",
    8: "MQPMRF_FEEDBACK",
    16: "MQPMRF_ACCOUNTING_TOKEN",
}

MQPO_DICT = {
    0: "MQPO_NO",
    1: "MQPO_YES",
}

MQPRI_DICT = {
    -3: "MQPRI_PRIORITY_AS_PUBLISHED",
    -2: "MQPRI_PRIORITY_AS_PARENT",
    -1: "MQPRI_PRIORITY_AS_Q_DEF",
}

MQPROP_DICT = {
    -1: "MQPROP_UNRESTRICTED_LENGTH",
    0: "MQPROP_COMPATIBILITY",
    1: "MQPROP_NONE",
    2: "MQPROP_ALL",
    3: "MQPROP_FORCE_MQRFH2",
    4: "MQPROP_V6COMPAT",
}

MQPROTO_DICT = {
    1: "MQPROTO_MQTTV3",
    2: "MQPROTO_HTTP",
    3: "MQPROTO_AMQP",
    4: "MQPROTO_MQTTV311",
}

MQPRT_DICT = {
    0: "MQPRT_RESPONSE_AS_PARENT",
    1: "MQPRT_SYNC_RESPONSE",
    2: "MQPRT_ASYNC_RESPONSE",
}

MQPSCLUS_DICT = {
    0: "MQPSCLUS_DISABLED",
    1: "MQPSCLUS_ENABLED",
}

MQPSCT_DICT = {
    -1: "MQPSCT_NONE",
}

MQPSM_DICT = {
    0: "MQPSM_DISABLED",
    1: "MQPSM_COMPAT",
    2: "MQPSM_ENABLED",
}

MQPSPROP_DICT = {
    0: "MQPSPROP_NONE",
    1: "MQPSPROP_COMPAT",
    2: "MQPSPROP_RFH2",
    3: "MQPSPROP_MSGPROP",
}

MQPSST_DICT = {
    0: "MQPSST_ALL",
    1: "MQPSST_LOCAL",
    2: "MQPSST_PARENT",
    3: "MQPSST_CHILD",
}

MQPS_DICT = {
    0: "MQPS_STATUS_INACTIVE",
    1: "MQPS_STATUS_STARTING",
    2: "MQPS_STATUS_STOPPING",
    3: "MQPS_STATUS_ACTIVE",
    4: "MQPS_STATUS_COMPAT",
    5: "MQPS_STATUS_ERROR",
    6: "MQPS_STATUS_REFUSED",
}

MQPUBO_DICT = {
    0: "MQPUBO_NONE",
    1: "MQPUBO_CORREL_ID_AS_IDENTITY",
    2: "MQPUBO_RETAIN_PUBLICATION",
    4: "MQPUBO_OTHER_SUBSCRIBERS_ONLY",
    8: "MQPUBO_NO_REGISTRATION",
    16: "MQPUBO_IS_RETAINED_PUBLICATION",
}

MQQA_BACKOUT_DICT = {
    0: "MQQA_BACKOUT_NOT_HARDENED",
    1: "MQQA_BACKOUT_HARDENED",
}

MQQA_GET_DICT = {
    0: "MQQA_GET_ALLOWED",
    1: "MQQA_GET_INHIBITED",
}

MQQA_PUT_DICT = {
    0: "MQQA_PUT_ALLOWED",
    1: "MQQA_PUT_INHIBITED",
}

MQQA_SHAREABLE_DICT = {
    0: "MQQA_NOT_SHAREABLE",
    1: "MQQA_SHAREABLE",
}

MQQDT_DICT = {
    1: "MQQDT_PREDEFINED",
    2: "MQQDT_PERMANENT_DYNAMIC",
    3: "MQQDT_TEMPORARY_DYNAMIC",
    4: "MQQDT_SHARED_DYNAMIC",
}

MQQFS_DICT = {
    -1: "MQQFS_DEFAULT",
}

MQQF_DICT = {
    1: "MQQF_LOCAL_Q",
    64: "MQQF_CLWL_USEQ_ANY",
    128: "MQQF_CLWL_USEQ_LOCAL",
}

MQQMDT_DICT = {
    1: "MQQMDT_EXPLICIT_CLUSTER_SENDER",
    2: "MQQMDT_AUTO_CLUSTER_SENDER",
    3: "MQQMDT_CLUSTER_RECEIVER",
    4: "MQQMDT_AUTO_EXP_CLUSTER_SENDER",
}

MQQMFAC_DICT = {
    1: "MQQMFAC_IMS_BRIDGE",
    2: "MQQMFAC_DB2",
}

MQQMF_DICT = {
    2: "MQQMF_REPOSITORY_Q_MGR",
    8: "MQQMF_CLUSSDR_USER_DEFINED",
    16: "MQQMF_CLUSSDR_AUTO_DEFINED",
    32: "MQQMF_AVAILABLE",
}

MQQMOPT_DICT = {
    0: "MQQMOPT_DISABLED",
    1: "MQQMOPT_ENABLED",
    2: "MQQMOPT_REPLY",
}

MQQMSTA_DICT = {
    1: "MQQMSTA_STARTING",
    2: "MQQMSTA_RUNNING",
    3: "MQQMSTA_QUIESCING",
    4: "MQQMSTA_STANDBY",
}

MQQMT_DICT = {
    0: "MQQMT_NORMAL",
    1: "MQQMT_REPOSITORY",
}

MQQO_DICT = {
    0: "MQQO_NO",
    1: "MQQO_YES",
}

MQQSGD_DICT = {
    -1: "MQQSGD_ALL",
    0: "MQQSGD_Q_MGR",
    1: "MQQSGD_COPY",
    2: "MQQSGD_SHARED",
    3: "MQQSGD_GROUP",
    4: "MQQSGD_PRIVATE",
    6: "MQQSGD_LIVE",
}

MQQSGS_DICT = {
    0: "MQQSGS_UNKNOWN",
    1: "MQQSGS_CREATED",
    2: "MQQSGS_ACTIVE",
    3: "MQQSGS_INACTIVE",
    4: "MQQSGS_FAILED",
    5: "MQQSGS_PENDING",
}

MQQSIE_DICT = {
    0: "MQQSIE_NONE",
    1: "MQQSIE_HIGH",
    2: "MQQSIE_OK",
}

MQQSOT_DICT = {
    1: "MQQSOT_ALL",
    2: "MQQSOT_INPUT",
    3: "MQQSOT_OUTPUT",
}

MQQSO_DICT = {
    0: "MQQSO_NO",
    1: "MQQSO_YES",
    2: "MQQSO_EXCLUSIVE",
}

MQQSUM_DICT = {
    0: "MQQSUM_NO",
    1: "MQQSUM_YES",
}

MQQT_DICT = {
    1: "MQQT_LOCAL",
    2: "MQQT_MODEL",
    3: "MQQT_ALIAS",
    6: "MQQT_REMOTE",
    7: "MQQT_CLUSTER",
    1001: "MQQT_ALL",
}

MQRAR_DICT = {
    0: "MQRAR_NO",
    1: "MQRAR_YES",
}

MQRCCF_DICT = {
    3001: "MQRCCF_CFH_TYPE_ERROR",
    3002: "MQRCCF_CFH_LENGTH_ERROR",
    3003: "MQRCCF_CFH_VERSION_ERROR",
    3004: "MQRCCF_CFH_MSG_SEQ_NUMBER_ERR",
    3005: "MQRCCF_CFH_CONTROL_ERROR",
    3006: "MQRCCF_CFH_PARM_COUNT_ERROR",
    3007: "MQRCCF_CFH_COMMAND_ERROR",
    3008: "MQRCCF_COMMAND_FAILED",
    3009: "MQRCCF_CFIN_LENGTH_ERROR",
    3010: "MQRCCF_CFST_LENGTH_ERROR",
    3011: "MQRCCF_CFST_STRING_LENGTH_ERR",
    3012: "MQRCCF_FORCE_VALUE_ERROR",
    3013: "MQRCCF_STRUCTURE_TYPE_ERROR",
    3014: "MQRCCF_CFIN_PARM_ID_ERROR",
    3015: "MQRCCF_CFST_PARM_ID_ERROR",
    3016: "MQRCCF_MSG_LENGTH_ERROR",
    3017: "MQRCCF_CFIN_DUPLICATE_PARM",
    3018: "MQRCCF_CFST_DUPLICATE_PARM",
    3019: "MQRCCF_PARM_COUNT_TOO_SMALL",
    3020: "MQRCCF_PARM_COUNT_TOO_BIG",
    3021: "MQRCCF_Q_ALREADY_IN_CELL",
    3022: "MQRCCF_Q_TYPE_ERROR",
    3023: "MQRCCF_MD_FORMAT_ERROR",
    3024: "MQRCCF_CFSL_LENGTH_ERROR",
    3025: "MQRCCF_REPLACE_VALUE_ERROR",
    3026: "MQRCCF_CFIL_DUPLICATE_VALUE",
    3027: "MQRCCF_CFIL_COUNT_ERROR",
    3028: "MQRCCF_CFIL_LENGTH_ERROR",
    3029: "MQRCCF_QUIESCE_VALUE_ERROR",
    3030: "MQRCCF_MSG_SEQ_NUMBER_ERROR",
    3031: "MQRCCF_PING_DATA_COUNT_ERROR",
    3032: "MQRCCF_PING_DATA_COMPARE_ERROR",
    3033: "MQRCCF_CFSL_PARM_ID_ERROR",
    3034: "MQRCCF_CHANNEL_TYPE_ERROR",
    3035: "MQRCCF_PARM_SEQUENCE_ERROR",
    3036: "MQRCCF_XMIT_PROTOCOL_TYPE_ERR",
    3037: "MQRCCF_BATCH_SIZE_ERROR",
    3038: "MQRCCF_DISC_INT_ERROR",
    3039: "MQRCCF_SHORT_RETRY_ERROR",
    3040: "MQRCCF_SHORT_TIMER_ERROR",
    3041: "MQRCCF_LONG_RETRY_ERROR",
    3042: "MQRCCF_LONG_TIMER_ERROR",
    3043: "MQRCCF_SEQ_NUMBER_WRAP_ERROR",
    3044: "MQRCCF_MAX_MSG_LENGTH_ERROR",
    3045: "MQRCCF_PUT_AUTH_ERROR",
    3046: "MQRCCF_PURGE_VALUE_ERROR",
    3047: "MQRCCF_CFIL_PARM_ID_ERROR",
    3048: "MQRCCF_MSG_TRUNCATED",
    3049: "MQRCCF_CCSID_ERROR",
    3050: "MQRCCF_ENCODING_ERROR",
    3051: "MQRCCF_QUEUES_VALUE_ERROR",
    3052: "MQRCCF_DATA_CONV_VALUE_ERROR",
    3053: "MQRCCF_INDOUBT_VALUE_ERROR",
    3054: "MQRCCF_ESCAPE_TYPE_ERROR",
    3055: "MQRCCF_REPOS_VALUE_ERROR",
    3062: "MQRCCF_CHANNEL_TABLE_ERROR",
    3063: "MQRCCF_MCA_TYPE_ERROR",
    3064: "MQRCCF_CHL_INST_TYPE_ERROR",
    3065: "MQRCCF_CHL_STATUS_NOT_FOUND",
    3066: "MQRCCF_CFSL_DUPLICATE_PARM",
    3067: "MQRCCF_CFSL_TOTAL_LENGTH_ERROR",
    3068: "MQRCCF_CFSL_COUNT_ERROR",
    3069: "MQRCCF_CFSL_STRING_LENGTH_ERR",
    3070: "MQRCCF_BROKER_DELETED",
    3071: "MQRCCF_STREAM_ERROR",
    3072: "MQRCCF_TOPIC_ERROR",
    3073: "MQRCCF_NOT_REGISTERED",
    3074: "MQRCCF_Q_MGR_NAME_ERROR",
    3075: "MQRCCF_INCORRECT_STREAM",
    3076: "MQRCCF_Q_NAME_ERROR",
    3077: "MQRCCF_NO_RETAINED_MSG",
    3078: "MQRCCF_DUPLICATE_IDENTITY",
    3079: "MQRCCF_INCORRECT_Q",
    3080: "MQRCCF_CORREL_ID_ERROR",
    3081: "MQRCCF_NOT_AUTHORIZED",
    3082: "MQRCCF_UNKNOWN_STREAM",
    3083: "MQRCCF_REG_OPTIONS_ERROR",
    3084: "MQRCCF_PUB_OPTIONS_ERROR",
    3085: "MQRCCF_UNKNOWN_BROKER",
    3086: "MQRCCF_Q_MGR_CCSID_ERROR",
    3087: "MQRCCF_DEL_OPTIONS_ERROR",
    3088: "MQRCCF_CLUSTER_NAME_CONFLICT",
    3089: "MQRCCF_REPOS_NAME_CONFLICT",
    3090: "MQRCCF_CLUSTER_Q_USAGE_ERROR",
    3091: "MQRCCF_ACTION_VALUE_ERROR",
    3092: "MQRCCF_COMMS_LIBRARY_ERROR",
    3093: "MQRCCF_NETBIOS_NAME_ERROR",
    3094: "MQRCCF_BROKER_COMMAND_FAILED",
    3095: "MQRCCF_CFST_CONFLICTING_PARM",
    3096: "MQRCCF_PATH_NOT_VALID",
    3097: "MQRCCF_PARM_SYNTAX_ERROR",
    3098: "MQRCCF_PWD_LENGTH_ERROR",
    3150: "MQRCCF_FILTER_ERROR",
    3151: "MQRCCF_WRONG_USER",
    3152: "MQRCCF_DUPLICATE_SUBSCRIPTION",
    3153: "MQRCCF_SUB_NAME_ERROR",
    3154: "MQRCCF_SUB_IDENTITY_ERROR",
    3155: "MQRCCF_SUBSCRIPTION_IN_USE",
    3156: "MQRCCF_SUBSCRIPTION_LOCKED",
    3157: "MQRCCF_ALREADY_JOINED",
    3160: "MQRCCF_OBJECT_IN_USE",
    3161: "MQRCCF_UNKNOWN_FILE_NAME",
    3162: "MQRCCF_FILE_NOT_AVAILABLE",
    3163: "MQRCCF_DISC_RETRY_ERROR",
    3164: "MQRCCF_ALLOC_RETRY_ERROR",
    3165: "MQRCCF_ALLOC_SLOW_TIMER_ERROR",
    3166: "MQRCCF_ALLOC_FAST_TIMER_ERROR",
    3167: "MQRCCF_PORT_NUMBER_ERROR",
    3168: "MQRCCF_CHL_SYSTEM_NOT_ACTIVE",
    3169: "MQRCCF_ENTITY_NAME_MISSING",
    3170: "MQRCCF_PROFILE_NAME_ERROR",
    3171: "MQRCCF_AUTH_VALUE_ERROR",
    3172: "MQRCCF_AUTH_VALUE_MISSING",
    3173: "MQRCCF_OBJECT_TYPE_MISSING",
    3174: "MQRCCF_CONNECTION_ID_ERROR",
    3175: "MQRCCF_LOG_TYPE_ERROR",
    3176: "MQRCCF_PROGRAM_NOT_AVAILABLE",
    3177: "MQRCCF_PROGRAM_AUTH_FAILED",
    3200: "MQRCCF_NONE_FOUND",
    3201: "MQRCCF_SECURITY_SWITCH_OFF",
    3202: "MQRCCF_SECURITY_REFRESH_FAILED",
    3203: "MQRCCF_PARM_CONFLICT",
    3204: "MQRCCF_COMMAND_INHIBITED",
    3205: "MQRCCF_OBJECT_BEING_DELETED",
    3207: "MQRCCF_STORAGE_CLASS_IN_USE",
    3208: "MQRCCF_OBJECT_NAME_RESTRICTED",
    3209: "MQRCCF_OBJECT_LIMIT_EXCEEDED",
    3210: "MQRCCF_OBJECT_OPEN_FORCE",
    3211: "MQRCCF_DISPOSITION_CONFLICT",
    3212: "MQRCCF_Q_MGR_NOT_IN_QSG",
    3213: "MQRCCF_ATTR_VALUE_FIXED",
    3215: "MQRCCF_NAMELIST_ERROR",
    3217: "MQRCCF_NO_CHANNEL_INITIATOR",
    3218: "MQRCCF_CHANNEL_INITIATOR_ERROR",
    3222: "MQRCCF_COMMAND_LEVEL_CONFLICT",
    3223: "MQRCCF_Q_ATTR_CONFLICT",
    3224: "MQRCCF_EVENTS_DISABLED",
    3225: "MQRCCF_COMMAND_SCOPE_ERROR",
    3226: "MQRCCF_COMMAND_REPLY_ERROR",
    3227: "MQRCCF_FUNCTION_RESTRICTED",
    3228: "MQRCCF_PARM_MISSING",
    3229: "MQRCCF_PARM_VALUE_ERROR",
    3230: "MQRCCF_COMMAND_LENGTH_ERROR",
    3231: "MQRCCF_COMMAND_ORIGIN_ERROR",
    3232: "MQRCCF_LISTENER_CONFLICT",
    3233: "MQRCCF_LISTENER_STARTED",
    3234: "MQRCCF_LISTENER_STOPPED",
    3235: "MQRCCF_CHANNEL_ERROR",
    3236: "MQRCCF_CF_STRUC_ERROR",
    3237: "MQRCCF_UNKNOWN_USER_ID",
    3238: "MQRCCF_UNEXPECTED_ERROR",
    3239: "MQRCCF_NO_XCF_PARTNER",
    3240: "MQRCCF_CFGR_PARM_ID_ERROR",
    3241: "MQRCCF_CFIF_LENGTH_ERROR",
    3242: "MQRCCF_CFIF_OPERATOR_ERROR",
    3243: "MQRCCF_CFIF_PARM_ID_ERROR",
    3244: "MQRCCF_CFSF_FILTER_VAL_LEN_ERR",
    3245: "MQRCCF_CFSF_LENGTH_ERROR",
    3246: "MQRCCF_CFSF_OPERATOR_ERROR",
    3247: "MQRCCF_CFSF_PARM_ID_ERROR",
    3248: "MQRCCF_TOO_MANY_FILTERS",
    3249: "MQRCCF_LISTENER_RUNNING",
    3250: "MQRCCF_LSTR_STATUS_NOT_FOUND",
    3251: "MQRCCF_SERVICE_RUNNING",
    3252: "MQRCCF_SERV_STATUS_NOT_FOUND",
    3253: "MQRCCF_SERVICE_STOPPED",
    3254: "MQRCCF_CFBS_DUPLICATE_PARM",
    3255: "MQRCCF_CFBS_LENGTH_ERROR",
    3256: "MQRCCF_CFBS_PARM_ID_ERROR",
    3257: "MQRCCF_CFBS_STRING_LENGTH_ERR",
    3258: "MQRCCF_CFGR_LENGTH_ERROR",
    3259: "MQRCCF_CFGR_PARM_COUNT_ERROR",
    3260: "MQRCCF_CONN_NOT_STOPPED",
    3261: "MQRCCF_SERVICE_REQUEST_PENDING",
    3262: "MQRCCF_NO_START_CMD",
    3263: "MQRCCF_NO_STOP_CMD",
    3264: "MQRCCF_CFBF_LENGTH_ERROR",
    3265: "MQRCCF_CFBF_PARM_ID_ERROR",
    3266: "MQRCCF_CFBF_OPERATOR_ERROR",
    3267: "MQRCCF_CFBF_FILTER_VAL_LEN_ERR",
    3268: "MQRCCF_LISTENER_STILL_ACTIVE",
    3269: "MQRCCF_DEF_XMIT_Q_CLUS_ERROR",
    3300: "MQRCCF_TOPICSTR_ALREADY_EXISTS",
    3301: "MQRCCF_SHARING_CONVS_ERROR",
    3302: "MQRCCF_SHARING_CONVS_TYPE",
    3303: "MQRCCF_SECURITY_CASE_CONFLICT",
    3305: "MQRCCF_TOPIC_TYPE_ERROR",
    3306: "MQRCCF_MAX_INSTANCES_ERROR",
    3307: "MQRCCF_MAX_INSTS_PER_CLNT_ERR",
    3308: "MQRCCF_TOPIC_STRING_NOT_FOUND",
    3309: "MQRCCF_SUBSCRIPTION_POINT_ERR",
    3311: "MQRCCF_SUB_ALREADY_EXISTS",
    3312: "MQRCCF_UNKNOWN_OBJECT_NAME",
    3313: "MQRCCF_REMOTE_Q_NAME_ERROR",
    3314: "MQRCCF_DURABILITY_NOT_ALLOWED",
    3315: "MQRCCF_HOBJ_ERROR",
    3316: "MQRCCF_DEST_NAME_ERROR",
    3317: "MQRCCF_INVALID_DESTINATION",
    3318: "MQRCCF_PUBSUB_INHIBITED",
    3319: "MQRCCF_GROUPUR_CHECKS_FAILED",
    3320: "MQRCCF_COMM_INFO_TYPE_ERROR",
    3321: "MQRCCF_USE_CLIENT_ID_ERROR",
    3322: "MQRCCF_CLIENT_ID_NOT_FOUND",
    3323: "MQRCCF_CLIENT_ID_ERROR",
    3324: "MQRCCF_PORT_IN_USE",
    3325: "MQRCCF_SSL_ALT_PROVIDER_REQD",
    3326: "MQRCCF_CHLAUTH_TYPE_ERROR",
    3327: "MQRCCF_CHLAUTH_ACTION_ERROR",
    3328: "MQRCCF_POLICY_NOT_FOUND",
    3329: "MQRCCF_ENCRYPTION_ALG_ERROR",
    3330: "MQRCCF_SIGNATURE_ALG_ERROR",
    3331: "MQRCCF_TOLERATION_POL_ERROR",
    3332: "MQRCCF_POLICY_VERSION_ERROR",
    3333: "MQRCCF_RECIPIENT_DN_MISSING",
    3334: "MQRCCF_POLICY_NAME_MISSING",
    3335: "MQRCCF_CHLAUTH_USERSRC_ERROR",
    3336: "MQRCCF_WRONG_CHLAUTH_TYPE",
    3337: "MQRCCF_CHLAUTH_ALREADY_EXISTS",
    3338: "MQRCCF_CHLAUTH_NOT_FOUND",
    3339: "MQRCCF_WRONG_CHLAUTH_ACTION",
    3340: "MQRCCF_WRONG_CHLAUTH_USERSRC",
    3341: "MQRCCF_CHLAUTH_WARN_ERROR",
    3342: "MQRCCF_WRONG_CHLAUTH_MATCH",
    3343: "MQRCCF_IPADDR_RANGE_CONFLICT",
    3344: "MQRCCF_CHLAUTH_MAX_EXCEEDED",
    3345: "MQRCCF_ADDRESS_ERROR",
    3346: "MQRCCF_IPADDR_RANGE_ERROR",
    3347: "MQRCCF_PROFILE_NAME_MISSING",
    3348: "MQRCCF_CHLAUTH_CLNTUSER_ERROR",
    3349: "MQRCCF_CHLAUTH_NAME_ERROR",
    3350: "MQRCCF_CHLAUTH_RUNCHECK_ERROR",
    3351: "MQRCCF_CF_STRUC_ALREADY_FAILED",
    3352: "MQRCCF_CFCONLOS_CHECKS_FAILED",
    3353: "MQRCCF_SUITE_B_ERROR",
    3354: "MQRCCF_CHANNEL_NOT_STARTED",
    3355: "MQRCCF_CUSTOM_ERROR",
    3356: "MQRCCF_BACKLOG_OUT_OF_RANGE",
    3357: "MQRCCF_CHLAUTH_DISABLED",
    3358: "MQRCCF_SMDS_REQUIRES_DSGROUP",
    3359: "MQRCCF_PSCLUS_DISABLED_TOPDEF",
    3360: "MQRCCF_PSCLUS_TOPIC_EXISTS",
    3361: "MQRCCF_SSL_CIPHER_SUITE_ERROR",
    3362: "MQRCCF_SOCKET_ERROR",
    3363: "MQRCCF_CLUS_XMIT_Q_USAGE_ERROR",
    3364: "MQRCCF_CERT_VAL_POLICY_ERROR",
    3365: "MQRCCF_INVALID_PROTOCOL",
    3366: "MQRCCF_REVDNS_DISABLED",
    3367: "MQRCCF_CLROUTE_NOT_ALTERABLE",
    3368: "MQRCCF_CLUSTER_TOPIC_CONFLICT",
    3369: "MQRCCF_DEFCLXQ_MODEL_Q_ERROR",
    3370: "MQRCCF_CHLAUTH_CHKCLI_ERROR",
    3371: "MQRCCF_CERT_LABEL_NOT_ALLOWED",
    3372: "MQRCCF_Q_MGR_ATTR_CONFLICT",
    3373: "MQRCCF_ENTITY_TYPE_MISSING",
    3374: "MQRCCF_CLWL_EXIT_NAME_ERROR",
    3375: "MQRCCF_SERVICE_NAME_ERROR",
    3376: "MQRCCF_REMOTE_CHL_TYPE_ERROR",
    3377: "MQRCCF_TOPIC_RESTRICTED",
    3378: "MQRCCF_CURRENT_LOG_EXTENT",
    3379: "MQRCCF_LOG_EXTENT_NOT_FOUND",
    3380: "MQRCCF_LOG_NOT_REDUCED",
    3381: "MQRCCF_LOG_EXTENT_ERROR",
    3382: "MQRCCF_ACCESS_BLOCKED",
    3383: "MQRCCF_PS_REQUIRED_MQUC",
    3384: "MQRCCF_STREAMQ_DEST_NOT_SUPP",
    3385: "MQRCCF_STREAMQ_DEST_CONFLICT",
    3386: "MQRCCF_STREAMQ_NOT_SUPPORTED",
    3387: "MQRCCF_STREAMQ_CONFLICT",
    3389: "MQRCCF_INCOMPATIBLE_QM_IN_QSG",
    3390: "MQRCCF_ATTR_VALUE_ERROR_QSG_QM",
    3391: "MQRCCF_AUTHORIZED",
    4001: "MQRCCF_OBJECT_ALREADY_EXISTS",
    4002: "MQRCCF_OBJECT_WRONG_TYPE",
    4003: "MQRCCF_LIKE_OBJECT_WRONG_TYPE",
    4004: "MQRCCF_OBJECT_OPEN",
    4005: "MQRCCF_ATTR_VALUE_ERROR",
    4006: "MQRCCF_UNKNOWN_Q_MGR",
    4007: "MQRCCF_Q_WRONG_TYPE",
    4008: "MQRCCF_OBJECT_NAME_ERROR",
    4009: "MQRCCF_ALLOCATE_FAILED",
    4010: "MQRCCF_HOST_NOT_AVAILABLE",
    4011: "MQRCCF_CONFIGURATION_ERROR",
    4012: "MQRCCF_CONNECTION_REFUSED",
    4013: "MQRCCF_ENTRY_ERROR",
    4014: "MQRCCF_SEND_FAILED",
    4015: "MQRCCF_RECEIVED_DATA_ERROR",
    4016: "MQRCCF_RECEIVE_FAILED",
    4017: "MQRCCF_CONNECTION_CLOSED",
    4018: "MQRCCF_NO_STORAGE",
    4019: "MQRCCF_NO_COMMS_MANAGER",
    4020: "MQRCCF_LISTENER_NOT_STARTED",
    4024: "MQRCCF_BIND_FAILED",
    4025: "MQRCCF_CHANNEL_INDOUBT",
    4026: "MQRCCF_MQCONN_FAILED",
    4027: "MQRCCF_MQOPEN_FAILED",
    4028: "MQRCCF_MQGET_FAILED",
    4029: "MQRCCF_MQPUT_FAILED",
    4030: "MQRCCF_PING_ERROR",
    4031: "MQRCCF_CHANNEL_IN_USE",
    4032: "MQRCCF_CHANNEL_NOT_FOUND",
    4033: "MQRCCF_UNKNOWN_REMOTE_CHANNEL",
    4034: "MQRCCF_REMOTE_QM_UNAVAILABLE",
    4035: "MQRCCF_REMOTE_QM_TERMINATING",
    4036: "MQRCCF_MQINQ_FAILED",
    4037: "MQRCCF_NOT_XMIT_Q",
    4038: "MQRCCF_CHANNEL_DISABLED",
    4039: "MQRCCF_USER_EXIT_NOT_AVAILABLE",
    4040: "MQRCCF_COMMIT_FAILED",
    4041: "MQRCCF_WRONG_CHANNEL_TYPE",
    4042: "MQRCCF_CHANNEL_ALREADY_EXISTS",
    4043: "MQRCCF_DATA_TOO_LARGE",
    4044: "MQRCCF_CHANNEL_NAME_ERROR",
    4045: "MQRCCF_XMIT_Q_NAME_ERROR",
    4047: "MQRCCF_MCA_NAME_ERROR",
    4048: "MQRCCF_SEND_EXIT_NAME_ERROR",
    4049: "MQRCCF_SEC_EXIT_NAME_ERROR",
    4050: "MQRCCF_MSG_EXIT_NAME_ERROR",
    4051: "MQRCCF_RCV_EXIT_NAME_ERROR",
    4052: "MQRCCF_XMIT_Q_NAME_WRONG_TYPE",
    4053: "MQRCCF_MCA_NAME_WRONG_TYPE",
    4054: "MQRCCF_DISC_INT_WRONG_TYPE",
    4055: "MQRCCF_SHORT_RETRY_WRONG_TYPE",
    4056: "MQRCCF_SHORT_TIMER_WRONG_TYPE",
    4057: "MQRCCF_LONG_RETRY_WRONG_TYPE",
    4058: "MQRCCF_LONG_TIMER_WRONG_TYPE",
    4059: "MQRCCF_PUT_AUTH_WRONG_TYPE",
    4060: "MQRCCF_KEEP_ALIVE_INT_ERROR",
    4061: "MQRCCF_MISSING_CONN_NAME",
    4062: "MQRCCF_CONN_NAME_ERROR",
    4063: "MQRCCF_MQSET_FAILED",
    4064: "MQRCCF_CHANNEL_NOT_ACTIVE",
    4065: "MQRCCF_TERMINATED_BY_SEC_EXIT",
    4067: "MQRCCF_DYNAMIC_Q_SCOPE_ERROR",
    4068: "MQRCCF_CELL_DIR_NOT_AVAILABLE",
    4069: "MQRCCF_MR_COUNT_ERROR",
    4070: "MQRCCF_MR_COUNT_WRONG_TYPE",
    4071: "MQRCCF_MR_EXIT_NAME_ERROR",
    4072: "MQRCCF_MR_EXIT_NAME_WRONG_TYPE",
    4073: "MQRCCF_MR_INTERVAL_ERROR",
    4074: "MQRCCF_MR_INTERVAL_WRONG_TYPE",
    4075: "MQRCCF_NPM_SPEED_ERROR",
    4076: "MQRCCF_NPM_SPEED_WRONG_TYPE",
    4077: "MQRCCF_HB_INTERVAL_ERROR",
    4078: "MQRCCF_HB_INTERVAL_WRONG_TYPE",
    4079: "MQRCCF_CHAD_ERROR",
    4080: "MQRCCF_CHAD_WRONG_TYPE",
    4081: "MQRCCF_CHAD_EVENT_ERROR",
    4082: "MQRCCF_CHAD_EVENT_WRONG_TYPE",
    4083: "MQRCCF_CHAD_EXIT_ERROR",
    4084: "MQRCCF_CHAD_EXIT_WRONG_TYPE",
    4085: "MQRCCF_SUPPRESSED_BY_EXIT",
    4086: "MQRCCF_BATCH_INT_ERROR",
    4087: "MQRCCF_BATCH_INT_WRONG_TYPE",
    4088: "MQRCCF_NET_PRIORITY_ERROR",
    4089: "MQRCCF_NET_PRIORITY_WRONG_TYPE",
    4090: "MQRCCF_CHANNEL_CLOSED",
    4091: "MQRCCF_Q_STATUS_NOT_FOUND",
    4092: "MQRCCF_SSL_CIPHER_SPEC_ERROR",
    4093: "MQRCCF_SSL_PEER_NAME_ERROR",
    4094: "MQRCCF_SSL_CLIENT_AUTH_ERROR",
    4095: "MQRCCF_RETAINED_NOT_SUPPORTED",
    4096: "MQRCCF_KWD_VALUE_WRONG_TYPE",
    4097: "MQRCCF_APPL_STATUS_NOT_FOUND",
    4098: "MQRCCF_NHA_NOT_AVAILABLE",
    4099: "MQRCCF_Q_MGR_STATUS_NOT_FOUND",
}

MQRCN_DICT = {
    0: "MQRCN_NO",
    1: "MQRCN_YES",
    2: "MQRCN_Q_MGR",
    3: "MQRCN_DISABLED",
}

MQRCVTIME_DICT = {
    0: "MQRCVTIME_MULTIPLY",
    1: "MQRCVTIME_ADD",
    2: "MQRCVTIME_EQUAL",
}

MQRC_DICT = {
    0: "MQRC_NONE",
    2001: "MQRC_ALIAS_BASE_Q_TYPE_ERROR",
    2002: "MQRC_ALREADY_CONNECTED",
    2003: "MQRC_BACKED_OUT",
    2004: "MQRC_BUFFER_ERROR",
    2005: "MQRC_BUFFER_LENGTH_ERROR",
    2006: "MQRC_CHAR_ATTR_LENGTH_ERROR",
    2007: "MQRC_CHAR_ATTRS_ERROR",
    2008: "MQRC_CHAR_ATTRS_TOO_SHORT",
    2009: "MQRC_CONNECTION_BROKEN",
    2010: "MQRC_DATA_LENGTH_ERROR",
    2011: "MQRC_DYNAMIC_Q_NAME_ERROR",
    2012: "MQRC_ENVIRONMENT_ERROR",
    2013: "MQRC_EXPIRY_ERROR",
    2014: "MQRC_FEEDBACK_ERROR",
    2016: "MQRC_GET_INHIBITED",
    2017: "MQRC_HANDLE_NOT_AVAILABLE",
    2018: "MQRC_HCONN_ERROR",
    2019: "MQRC_HOBJ_ERROR",
    2020: "MQRC_INHIBIT_VALUE_ERROR",
    2021: "MQRC_INT_ATTR_COUNT_ERROR",
    2022: "MQRC_INT_ATTR_COUNT_TOO_SMALL",
    2023: "MQRC_INT_ATTRS_ARRAY_ERROR",
    2024: "MQRC_SYNCPOINT_LIMIT_REACHED",
    2025: "MQRC_MAX_CONNS_LIMIT_REACHED",
    2026: "MQRC_MD_ERROR",
    2027: "MQRC_MISSING_REPLY_TO_Q",
    2029: "MQRC_MSG_TYPE_ERROR",
    2030: "MQRC_MSG_TOO_BIG_FOR_Q",
    2031: "MQRC_MSG_TOO_BIG_FOR_Q_MGR",
    2033: "MQRC_NO_MSG_AVAILABLE",
    2034: "MQRC_NO_MSG_UNDER_CURSOR",
    2035: "MQRC_NOT_AUTHORIZED",
    2036: "MQRC_NOT_OPEN_FOR_BROWSE",
    2037: "MQRC_NOT_OPEN_FOR_INPUT",
    2038: "MQRC_NOT_OPEN_FOR_INQUIRE",
    2039: "MQRC_NOT_OPEN_FOR_OUTPUT",
    2040: "MQRC_NOT_OPEN_FOR_SET",
    2041: "MQRC_OBJECT_CHANGED",
    2042: "MQRC_OBJECT_IN_USE",
    2043: "MQRC_OBJECT_TYPE_ERROR",
    2044: "MQRC_OD_ERROR",
    2045: "MQRC_OPTION_NOT_VALID_FOR_TYPE",
    2046: "MQRC_OPTIONS_ERROR",
    2047: "MQRC_PERSISTENCE_ERROR",
    2048: "MQRC_PERSISTENT_NOT_ALLOWED",
    2049: "MQRC_PRIORITY_EXCEEDS_MAXIMUM",
    2050: "MQRC_PRIORITY_ERROR",
    2051: "MQRC_PUT_INHIBITED",
    2052: "MQRC_Q_DELETED",
    2053: "MQRC_Q_FULL",
    2055: "MQRC_Q_NOT_EMPTY",
    2056: "MQRC_Q_SPACE_NOT_AVAILABLE",
    2057: "MQRC_Q_TYPE_ERROR",
    2058: "MQRC_Q_MGR_NAME_ERROR",
    2059: "MQRC_Q_MGR_NOT_AVAILABLE",
    2061: "MQRC_REPORT_OPTIONS_ERROR",
    2062: "MQRC_SECOND_MARK_NOT_ALLOWED",
    2063: "MQRC_SECURITY_ERROR",
    2064: "MQRC_TOKEN_TIMESTAMP_NOT_VALID",
    2065: "MQRC_SELECTOR_COUNT_ERROR",
    2066: "MQRC_SELECTOR_LIMIT_EXCEEDED",
    2067: "MQRC_SELECTOR_ERROR",
    2068: "MQRC_SELECTOR_NOT_FOR_TYPE",
    2069: "MQRC_SIGNAL_OUTSTANDING",
    2070: "MQRC_SIGNAL_REQUEST_ACCEPTED",
    2071: "MQRC_STORAGE_NOT_AVAILABLE",
    2072: "MQRC_SYNCPOINT_NOT_AVAILABLE",
    2075: "MQRC_TRIGGER_CONTROL_ERROR",
    2076: "MQRC_TRIGGER_DEPTH_ERROR",
    2077: "MQRC_TRIGGER_MSG_PRIORITY_ERR",
    2078: "MQRC_TRIGGER_TYPE_ERROR",
    2079: "MQRC_TRUNCATED_MSG_ACCEPTED",
    2080: "MQRC_TRUNCATED_MSG_FAILED",
    2082: "MQRC_UNKNOWN_ALIAS_BASE_Q",
    2085: "MQRC_UNKNOWN_OBJECT_NAME",
    2086: "MQRC_UNKNOWN_OBJECT_Q_MGR",
    2087: "MQRC_UNKNOWN_REMOTE_Q_MGR",
    2090: "MQRC_WAIT_INTERVAL_ERROR",
    2091: "MQRC_XMIT_Q_TYPE_ERROR",
    2092: "MQRC_XMIT_Q_USAGE_ERROR",
    2093: "MQRC_NOT_OPEN_FOR_PASS_ALL",
    2094: "MQRC_NOT_OPEN_FOR_PASS_IDENT",
    2095: "MQRC_NOT_OPEN_FOR_SET_ALL",
    2096: "MQRC_NOT_OPEN_FOR_SET_IDENT",
    2097: "MQRC_CONTEXT_HANDLE_ERROR",
    2098: "MQRC_CONTEXT_NOT_AVAILABLE",
    2099: "MQRC_SIGNAL1_ERROR",
    2100: "MQRC_OBJECT_ALREADY_EXISTS",
    2101: "MQRC_OBJECT_DAMAGED",
    2102: "MQRC_RESOURCE_PROBLEM",
    2103: "MQRC_ANOTHER_Q_MGR_CONNECTED",
    2104: "MQRC_UNKNOWN_REPORT_OPTION",
    2105: "MQRC_STORAGE_CLASS_ERROR",
    2106: "MQRC_COD_NOT_VALID_FOR_XCF_Q",
    2107: "MQRC_XWAIT_CANCELED",
    2108: "MQRC_XWAIT_ERROR",
    2109: "MQRC_SUPPRESSED_BY_EXIT",
    2110: "MQRC_FORMAT_ERROR",
    2111: "MQRC_SOURCE_CCSID_ERROR",
    2112: "MQRC_SOURCE_INTEGER_ENC_ERROR",
    2113: "MQRC_SOURCE_DECIMAL_ENC_ERROR",
    2114: "MQRC_SOURCE_FLOAT_ENC_ERROR",
    2115: "MQRC_TARGET_CCSID_ERROR",
    2116: "MQRC_TARGET_INTEGER_ENC_ERROR",
    2117: "MQRC_TARGET_DECIMAL_ENC_ERROR",
    2118: "MQRC_TARGET_FLOAT_ENC_ERROR",
    2119: "MQRC_NOT_CONVERTED",
    2120: "MQRC_CONVERTED_MSG_TOO_BIG",
    2121: "MQRC_NO_EXTERNAL_PARTICIPANTS",
    2122: "MQRC_PARTICIPANT_NOT_AVAILABLE",
    2123: "MQRC_OUTCOME_MIXED",
    2124: "MQRC_OUTCOME_PENDING",
    2125: "MQRC_BRIDGE_STARTED",
    2126: "MQRC_BRIDGE_STOPPED",
    2127: "MQRC_ADAPTER_STORAGE_SHORTAGE",
    2128: "MQRC_UOW_IN_PROGRESS",
    2129: "MQRC_ADAPTER_CONN_LOAD_ERROR",
    2130: "MQRC_ADAPTER_SERV_LOAD_ERROR",
    2131: "MQRC_ADAPTER_DEFS_ERROR",
    2132: "MQRC_ADAPTER_DEFS_LOAD_ERROR",
    2133: "MQRC_ADAPTER_CONV_LOAD_ERROR",
    2134: "MQRC_BO_ERROR",
    2135: "MQRC_DH_ERROR",
    2136: "MQRC_MULTIPLE_REASONS",
    2137: "MQRC_OPEN_FAILED",
    2138: "MQRC_ADAPTER_DISC_LOAD_ERROR",
    2139: "MQRC_CNO_ERROR",
    2140: "MQRC_CICS_WAIT_FAILED",
    2141: "MQRC_DLH_ERROR",
    2142: "MQRC_HEADER_ERROR",
    2143: "MQRC_SOURCE_LENGTH_ERROR",
    2144: "MQRC_TARGET_LENGTH_ERROR",
    2145: "MQRC_SOURCE_BUFFER_ERROR",
    2146: "MQRC_TARGET_BUFFER_ERROR",
    2147: "MQRC_INCOMPLETE_TRANSACTION",
    2148: "MQRC_IIH_ERROR",
    2149: "MQRC_PCF_ERROR",
    2150: "MQRC_DBCS_ERROR",
    2152: "MQRC_OBJECT_NAME_ERROR",
    2153: "MQRC_OBJECT_Q_MGR_NAME_ERROR",
    2154: "MQRC_RECS_PRESENT_ERROR",
    2155: "MQRC_OBJECT_RECORDS_ERROR",
    2156: "MQRC_RESPONSE_RECORDS_ERROR",
    2157: "MQRC_ASID_MISMATCH",
    2158: "MQRC_PMO_RECORD_FLAGS_ERROR",
    2159: "MQRC_PUT_MSG_RECORDS_ERROR",
    2160: "MQRC_CONN_ID_IN_USE",
    2161: "MQRC_Q_MGR_QUIESCING",
    2162: "MQRC_Q_MGR_STOPPING",
    2163: "MQRC_DUPLICATE_RECOV_COORD",
    2173: "MQRC_PMO_ERROR",
    2182: "MQRC_API_EXIT_NOT_FOUND",
    2183: "MQRC_API_EXIT_LOAD_ERROR",
    2184: "MQRC_REMOTE_Q_NAME_ERROR",
    2185: "MQRC_INCONSISTENT_PERSISTENCE",
    2186: "MQRC_GMO_ERROR",
    2187: "MQRC_CICS_BRIDGE_RESTRICTION",
    2188: "MQRC_STOPPED_BY_CLUSTER_EXIT",
    2189: "MQRC_CLUSTER_RESOLUTION_ERROR",
    2190: "MQRC_CONVERTED_STRING_TOO_BIG",
    2191: "MQRC_TMC_ERROR",
    2192: "MQRC_STORAGE_MEDIUM_FULL",
    2193: "MQRC_PAGESET_ERROR",
    2194: "MQRC_NAME_NOT_VALID_FOR_TYPE",
    2195: "MQRC_UNEXPECTED_ERROR",
    2196: "MQRC_UNKNOWN_XMIT_Q",
    2197: "MQRC_UNKNOWN_DEF_XMIT_Q",
    2198: "MQRC_DEF_XMIT_Q_TYPE_ERROR",
    2199: "MQRC_DEF_XMIT_Q_USAGE_ERROR",
    2200: "MQRC_MSG_MARKED_BROWSE_CO_OP",
    2201: "MQRC_NAME_IN_USE",
    2202: "MQRC_CONNECTION_QUIESCING",
    2203: "MQRC_CONNECTION_STOPPING",
    2204: "MQRC_ADAPTER_NOT_AVAILABLE",
    2206: "MQRC_MSG_ID_ERROR",
    2207: "MQRC_CORREL_ID_ERROR",
    2208: "MQRC_FILE_SYSTEM_ERROR",
    2209: "MQRC_NO_MSG_LOCKED",
    2210: "MQRC_SOAP_DOTNET_ERROR",
    2211: "MQRC_SOAP_AXIS_ERROR",
    2212: "MQRC_SOAP_URL_ERROR",
    2216: "MQRC_FILE_NOT_AUDITED",
    2217: "MQRC_CONNECTION_NOT_AUTHORIZED",
    2218: "MQRC_MSG_TOO_BIG_FOR_CHANNEL",
    2219: "MQRC_CALL_IN_PROGRESS",
    2220: "MQRC_RMH_ERROR",
    2222: "MQRC_Q_MGR_ACTIVE",
    2223: "MQRC_Q_MGR_NOT_ACTIVE",
    2224: "MQRC_Q_DEPTH_HIGH",
    2225: "MQRC_Q_DEPTH_LOW",
    2226: "MQRC_Q_SERVICE_INTERVAL_HIGH",
    2227: "MQRC_Q_SERVICE_INTERVAL_OK",
    2228: "MQRC_RFH_HEADER_FIELD_ERROR",
    2229: "MQRC_RAS_PROPERTY_ERROR",
    2232: "MQRC_UNIT_OF_WORK_NOT_STARTED",
    2233: "MQRC_CHANNEL_AUTO_DEF_OK",
    2234: "MQRC_CHANNEL_AUTO_DEF_ERROR",
    2235: "MQRC_CFH_ERROR",
    2236: "MQRC_CFIL_ERROR",
    2237: "MQRC_CFIN_ERROR",
    2238: "MQRC_CFSL_ERROR",
    2239: "MQRC_CFST_ERROR",
    2241: "MQRC_INCOMPLETE_GROUP",
    2242: "MQRC_INCOMPLETE_MSG",
    2243: "MQRC_INCONSISTENT_CCSIDS",
    2244: "MQRC_INCONSISTENT_ENCODINGS",
    2245: "MQRC_INCONSISTENT_UOW",
    2246: "MQRC_INVALID_MSG_UNDER_CURSOR",
    2247: "MQRC_MATCH_OPTIONS_ERROR",
    2248: "MQRC_MDE_ERROR",
    2249: "MQRC_MSG_FLAGS_ERROR",
    2250: "MQRC_MSG_SEQ_NUMBER_ERROR",
    2251: "MQRC_OFFSET_ERROR",
    2252: "MQRC_ORIGINAL_LENGTH_ERROR",
    2253: "MQRC_SEGMENT_LENGTH_ZERO",
    2255: "MQRC_UOW_NOT_AVAILABLE",
    2256: "MQRC_WRONG_GMO_VERSION",
    2257: "MQRC_WRONG_MD_VERSION",
    2258: "MQRC_GROUP_ID_ERROR",
    2259: "MQRC_INCONSISTENT_BROWSE",
    2260: "MQRC_XQH_ERROR",
    2261: "MQRC_SRC_ENV_ERROR",
    2262: "MQRC_SRC_NAME_ERROR",
    2263: "MQRC_DEST_ENV_ERROR",
    2264: "MQRC_DEST_NAME_ERROR",
    2265: "MQRC_TM_ERROR",
    2266: "MQRC_CLUSTER_EXIT_ERROR",
    2267: "MQRC_CLUSTER_EXIT_LOAD_ERROR",
    2268: "MQRC_CLUSTER_PUT_INHIBITED",
    2269: "MQRC_CLUSTER_RESOURCE_ERROR",
    2270: "MQRC_NO_DESTINATIONS_AVAILABLE",
    2271: "MQRC_CONN_TAG_IN_USE",
    2272: "MQRC_PARTIALLY_CONVERTED",
    2273: "MQRC_CONNECTION_ERROR",
    2274: "MQRC_OPTION_ENVIRONMENT_ERROR",
    2277: "MQRC_CD_ERROR",
    2278: "MQRC_CLIENT_CONN_ERROR",
    2279: "MQRC_CHANNEL_STOPPED_BY_USER",
    2280: "MQRC_HCONFIG_ERROR",
    2281: "MQRC_FUNCTION_ERROR",
    2282: "MQRC_CHANNEL_STARTED",
    2283: "MQRC_CHANNEL_STOPPED",
    2284: "MQRC_CHANNEL_CONV_ERROR",
    2285: "MQRC_SERVICE_NOT_AVAILABLE",
    2286: "MQRC_INITIALIZATION_FAILED",
    2287: "MQRC_TERMINATION_FAILED",
    2288: "MQRC_UNKNOWN_Q_NAME",
    2289: "MQRC_SERVICE_ERROR",
    2290: "MQRC_Q_ALREADY_EXISTS",
    2291: "MQRC_USER_ID_NOT_AVAILABLE",
    2292: "MQRC_UNKNOWN_ENTITY",
    2293: "MQRC_UNKNOWN_AUTH_ENTITY",
    2294: "MQRC_UNKNOWN_REF_OBJECT",
    2295: "MQRC_CHANNEL_ACTIVATED",
    2296: "MQRC_CHANNEL_NOT_ACTIVATED",
    2297: "MQRC_UOW_CANCELED",
    2298: "MQRC_FUNCTION_NOT_SUPPORTED",
    2299: "MQRC_SELECTOR_TYPE_ERROR",
    2300: "MQRC_COMMAND_TYPE_ERROR",
    2301: "MQRC_MULTIPLE_INSTANCE_ERROR",
    2302: "MQRC_SYSTEM_ITEM_NOT_ALTERABLE",
    2303: "MQRC_BAG_CONVERSION_ERROR",
    2304: "MQRC_SELECTOR_OUT_OF_RANGE",
    2305: "MQRC_SELECTOR_NOT_UNIQUE",
    2306: "MQRC_INDEX_NOT_PRESENT",
    2307: "MQRC_STRING_ERROR",
    2308: "MQRC_ENCODING_NOT_SUPPORTED",
    2309: "MQRC_SELECTOR_NOT_PRESENT",
    2310: "MQRC_OUT_SELECTOR_ERROR",
    2311: "MQRC_STRING_TRUNCATED",
    2312: "MQRC_SELECTOR_WRONG_TYPE",
    2313: "MQRC_INCONSISTENT_ITEM_TYPE",
    2314: "MQRC_INDEX_ERROR",
    2315: "MQRC_SYSTEM_BAG_NOT_ALTERABLE",
    2316: "MQRC_ITEM_COUNT_ERROR",
    2317: "MQRC_FORMAT_NOT_SUPPORTED",
    2318: "MQRC_SELECTOR_NOT_SUPPORTED",
    2319: "MQRC_ITEM_VALUE_ERROR",
    2320: "MQRC_HBAG_ERROR",
    2321: "MQRC_PARAMETER_MISSING",
    2322: "MQRC_CMD_SERVER_NOT_AVAILABLE",
    2323: "MQRC_STRING_LENGTH_ERROR",
    2324: "MQRC_INQUIRY_COMMAND_ERROR",
    2325: "MQRC_NESTED_BAG_NOT_SUPPORTED",
    2326: "MQRC_BAG_WRONG_TYPE",
    2327: "MQRC_ITEM_TYPE_ERROR",
    2328: "MQRC_SYSTEM_BAG_NOT_DELETABLE",
    2329: "MQRC_SYSTEM_ITEM_NOT_DELETABLE",
    2330: "MQRC_CODED_CHAR_SET_ID_ERROR",
    2331: "MQRC_MSG_TOKEN_ERROR",
    2332: "MQRC_MISSING_WIH",
    2333: "MQRC_WIH_ERROR",
    2334: "MQRC_RFH_ERROR",
    2335: "MQRC_RFH_STRING_ERROR",
    2336: "MQRC_RFH_COMMAND_ERROR",
    2337: "MQRC_RFH_PARM_ERROR",
    2338: "MQRC_RFH_DUPLICATE_PARM",
    2339: "MQRC_RFH_PARM_MISSING",
    2340: "MQRC_CHAR_CONVERSION_ERROR",
    2341: "MQRC_UCS2_CONVERSION_ERROR",
    2342: "MQRC_DB2_NOT_AVAILABLE",
    2343: "MQRC_OBJECT_NOT_UNIQUE",
    2344: "MQRC_CONN_TAG_NOT_RELEASED",
    2345: "MQRC_CF_NOT_AVAILABLE",
    2346: "MQRC_CF_STRUC_IN_USE",
    2347: "MQRC_CF_STRUC_LIST_HDR_IN_USE",
    2348: "MQRC_CF_STRUC_AUTH_FAILED",
    2349: "MQRC_CF_STRUC_ERROR",
    2350: "MQRC_CONN_TAG_NOT_USABLE",
    2351: "MQRC_GLOBAL_UOW_CONFLICT",
    2352: "MQRC_LOCAL_UOW_CONFLICT",
    2353: "MQRC_HANDLE_IN_USE_FOR_UOW",
    2354: "MQRC_UOW_ENLISTMENT_ERROR",
    2355: "MQRC_UOW_MIX_NOT_SUPPORTED",
    2356: "MQRC_WXP_ERROR",
    2357: "MQRC_CURRENT_RECORD_ERROR",
    2358: "MQRC_NEXT_OFFSET_ERROR",
    2359: "MQRC_NO_RECORD_AVAILABLE",
    2360: "MQRC_OBJECT_LEVEL_INCOMPATIBLE",
    2361: "MQRC_NEXT_RECORD_ERROR",
    2362: "MQRC_BACKOUT_THRESHOLD_REACHED",
    2363: "MQRC_MSG_NOT_MATCHED",
    2364: "MQRC_JMS_FORMAT_ERROR",
    2365: "MQRC_SEGMENTS_NOT_SUPPORTED",
    2366: "MQRC_WRONG_CF_LEVEL",
    2367: "MQRC_CONFIG_CREATE_OBJECT",
    2368: "MQRC_CONFIG_CHANGE_OBJECT",
    2369: "MQRC_CONFIG_DELETE_OBJECT",
    2370: "MQRC_CONFIG_REFRESH_OBJECT",
    2371: "MQRC_CHANNEL_SSL_ERROR",
    2372: "MQRC_PARTICIPANT_NOT_DEFINED",
    2373: "MQRC_CF_STRUC_FAILED",
    2374: "MQRC_API_EXIT_ERROR",
    2375: "MQRC_API_EXIT_INIT_ERROR",
    2376: "MQRC_API_EXIT_TERM_ERROR",
    2377: "MQRC_EXIT_REASON_ERROR",
    2378: "MQRC_RESERVED_VALUE_ERROR",
    2379: "MQRC_NO_DATA_AVAILABLE",
    2380: "MQRC_SCO_ERROR",
    2381: "MQRC_KEY_REPOSITORY_ERROR",
    2382: "MQRC_CRYPTO_HARDWARE_ERROR",
    2383: "MQRC_AUTH_INFO_REC_COUNT_ERROR",
    2384: "MQRC_AUTH_INFO_REC_ERROR",
    2385: "MQRC_AIR_ERROR",
    2386: "MQRC_AUTH_INFO_TYPE_ERROR",
    2387: "MQRC_AUTH_INFO_CONN_NAME_ERROR",
    2388: "MQRC_LDAP_USER_NAME_ERROR",
    2389: "MQRC_LDAP_USER_NAME_LENGTH_ERR",
    2390: "MQRC_LDAP_PASSWORD_ERROR",
    2391: "MQRC_SSL_ALREADY_INITIALIZED",
    2392: "MQRC_SSL_CONFIG_ERROR",
    2393: "MQRC_SSL_INITIALIZATION_ERROR",
    2394: "MQRC_Q_INDEX_TYPE_ERROR",
    2395: "MQRC_CFBS_ERROR",
    2396: "MQRC_SSL_NOT_ALLOWED",
    2397: "MQRC_JSSE_ERROR",
    2398: "MQRC_SSL_PEER_NAME_MISMATCH",
    2399: "MQRC_SSL_PEER_NAME_ERROR",
    2400: "MQRC_UNSUPPORTED_CIPHER_SUITE",
    2401: "MQRC_SSL_CERTIFICATE_REVOKED",
    2402: "MQRC_SSL_CERT_STORE_ERROR",
    2406: "MQRC_CLIENT_EXIT_LOAD_ERROR",
    2407: "MQRC_CLIENT_EXIT_ERROR",
    2408: "MQRC_UOW_COMMITTED",
    2409: "MQRC_SSL_KEY_RESET_ERROR",
    2410: "MQRC_UNKNOWN_COMPONENT_NAME",
    2411: "MQRC_LOGGER_STATUS",
    2412: "MQRC_COMMAND_MQSC",
    2413: "MQRC_COMMAND_PCF",
    2414: "MQRC_CFIF_ERROR",
    2415: "MQRC_CFSF_ERROR",
    2416: "MQRC_CFGR_ERROR",
    2417: "MQRC_MSG_NOT_ALLOWED_IN_GROUP",
    2418: "MQRC_FILTER_OPERATOR_ERROR",
    2419: "MQRC_NESTED_SELECTOR_ERROR",
    2420: "MQRC_EPH_ERROR",
    2421: "MQRC_RFH_FORMAT_ERROR",
    2422: "MQRC_CFBF_ERROR",
    2423: "MQRC_CLIENT_CHANNEL_CONFLICT",
    2424: "MQRC_SD_ERROR",
    2425: "MQRC_TOPIC_STRING_ERROR",
    2426: "MQRC_STS_ERROR",
    2428: "MQRC_NO_SUBSCRIPTION",
    2429: "MQRC_SUBSCRIPTION_IN_USE",
    2430: "MQRC_STAT_TYPE_ERROR",
    2431: "MQRC_SUB_USER_DATA_ERROR",
    2432: "MQRC_SUB_ALREADY_EXISTS",
    2434: "MQRC_IDENTITY_MISMATCH",
    2435: "MQRC_ALTER_SUB_ERROR",
    2436: "MQRC_DURABILITY_NOT_ALLOWED",
    2437: "MQRC_NO_RETAINED_MSG",
    2438: "MQRC_SRO_ERROR",
    2440: "MQRC_SUB_NAME_ERROR",
    2441: "MQRC_OBJECT_STRING_ERROR",
    2442: "MQRC_PROPERTY_NAME_ERROR",
    2443: "MQRC_SEGMENTATION_NOT_ALLOWED",
    2444: "MQRC_CBD_ERROR",
    2445: "MQRC_CTLO_ERROR",
    2446: "MQRC_NO_CALLBACKS_ACTIVE",
    2448: "MQRC_CALLBACK_NOT_REGISTERED",
    2457: "MQRC_OPTIONS_CHANGED",
    2458: "MQRC_READ_AHEAD_MSGS",
    2459: "MQRC_SELECTOR_SYNTAX_ERROR",
    2460: "MQRC_HMSG_ERROR",
    2461: "MQRC_CMHO_ERROR",
    2462: "MQRC_DMHO_ERROR",
    2463: "MQRC_SMPO_ERROR",
    2464: "MQRC_IMPO_ERROR",
    2465: "MQRC_PROPERTY_NAME_TOO_BIG",
    2466: "MQRC_PROP_VALUE_NOT_CONVERTED",
    2467: "MQRC_PROP_TYPE_NOT_SUPPORTED",
    2469: "MQRC_PROPERTY_VALUE_TOO_BIG",
    2470: "MQRC_PROP_CONV_NOT_SUPPORTED",
    2471: "MQRC_PROPERTY_NOT_AVAILABLE",
    2472: "MQRC_PROP_NUMBER_FORMAT_ERROR",
    2473: "MQRC_PROPERTY_TYPE_ERROR",
    2478: "MQRC_PROPERTIES_TOO_BIG",
    2479: "MQRC_PUT_NOT_RETAINED",
    2480: "MQRC_ALIAS_TARGTYPE_CHANGED",
    2481: "MQRC_DMPO_ERROR",
    2482: "MQRC_PD_ERROR",
    2483: "MQRC_CALLBACK_TYPE_ERROR",
    2484: "MQRC_CBD_OPTIONS_ERROR",
    2485: "MQRC_MAX_MSG_LENGTH_ERROR",
    2486: "MQRC_CALLBACK_ROUTINE_ERROR",
    2487: "MQRC_CALLBACK_LINK_ERROR",
    2488: "MQRC_OPERATION_ERROR",
    2489: "MQRC_BMHO_ERROR",
    2490: "MQRC_UNSUPPORTED_PROPERTY",
    2491: "MQRC_MSG_LENGTH_ERROR",
    2492: "MQRC_PROP_NAME_NOT_CONVERTED",
    2494: "MQRC_GET_ENABLED",
    2495: "MQRC_MODULE_NOT_FOUND",
    2496: "MQRC_MODULE_INVALID",
    2497: "MQRC_MODULE_ENTRY_NOT_FOUND",
    2498: "MQRC_MIXED_CONTENT_NOT_ALLOWED",
    2499: "MQRC_MSG_HANDLE_IN_USE",
    2500: "MQRC_HCONN_ASYNC_ACTIVE",
    2501: "MQRC_MHBO_ERROR",
    2502: "MQRC_PUBLICATION_FAILURE",
    2503: "MQRC_SUB_INHIBITED",
    2504: "MQRC_SELECTOR_ALWAYS_FALSE",
    2507: "MQRC_XEPO_ERROR",
    2509: "MQRC_DURABILITY_NOT_ALTERABLE",
    2510: "MQRC_TOPIC_NOT_ALTERABLE",
    2512: "MQRC_SUBLEVEL_NOT_ALTERABLE",
    2513: "MQRC_PROPERTY_NAME_LENGTH_ERR",
    2514: "MQRC_DUPLICATE_GROUP_SUB",
    2515: "MQRC_GROUPING_NOT_ALTERABLE",
    2516: "MQRC_SELECTOR_INVALID_FOR_TYPE",
    2517: "MQRC_HOBJ_QUIESCED",
    2518: "MQRC_HOBJ_QUIESCED_NO_MSGS",
    2519: "MQRC_SELECTION_STRING_ERROR",
    2520: "MQRC_RES_OBJECT_STRING_ERROR",
    2521: "MQRC_CONNECTION_SUSPENDED",
    2522: "MQRC_INVALID_DESTINATION",
    2523: "MQRC_INVALID_SUBSCRIPTION",
    2524: "MQRC_SELECTOR_NOT_ALTERABLE",
    2525: "MQRC_RETAINED_MSG_Q_ERROR",
    2526: "MQRC_RETAINED_NOT_DELIVERED",
    2527: "MQRC_RFH_RESTRICTED_FORMAT_ERR",
    2528: "MQRC_CONNECTION_STOPPED",
    2529: "MQRC_ASYNC_UOW_CONFLICT",
    2530: "MQRC_ASYNC_XA_CONFLICT",
    2531: "MQRC_PUBSUB_INHIBITED",
    2532: "MQRC_MSG_HANDLE_COPY_FAILURE",
    2533: "MQRC_DEST_CLASS_NOT_ALTERABLE",
    2534: "MQRC_OPERATION_NOT_ALLOWED",
    2535: "MQRC_ACTION_ERROR",
    2537: "MQRC_CHANNEL_NOT_AVAILABLE",
    2538: "MQRC_HOST_NOT_AVAILABLE",
    2539: "MQRC_CHANNEL_CONFIG_ERROR",
    2540: "MQRC_UNKNOWN_CHANNEL_NAME",
    2541: "MQRC_LOOPING_PUBLICATION",
    2542: "MQRC_ALREADY_JOINED",
    2543: "MQRC_STANDBY_Q_MGR",
    2544: "MQRC_RECONNECTING",
    2545: "MQRC_RECONNECTED",
    2546: "MQRC_RECONNECT_QMID_MISMATCH",
    2547: "MQRC_RECONNECT_INCOMPATIBLE",
    2548: "MQRC_RECONNECT_FAILED",
    2549: "MQRC_CALL_INTERRUPTED",
    2550: "MQRC_NO_SUBS_MATCHED",
    2551: "MQRC_SELECTION_NOT_AVAILABLE",
    2552: "MQRC_CHANNEL_SSL_WARNING",
    2553: "MQRC_OCSP_URL_ERROR",
    2554: "MQRC_CONTENT_ERROR",
    2555: "MQRC_RECONNECT_Q_MGR_REQD",
    2556: "MQRC_RECONNECT_TIMED_OUT",
    2557: "MQRC_PUBLISH_EXIT_ERROR",
    2558: "MQRC_COMMINFO_ERROR",
    2559: "MQRC_DEF_SYNCPOINT_INHIBITED",
    2560: "MQRC_MULTICAST_ONLY",
    2561: "MQRC_DATA_SET_NOT_AVAILABLE",
    2562: "MQRC_GROUPING_NOT_ALLOWED",
    2563: "MQRC_GROUP_ADDRESS_ERROR",
    2564: "MQRC_MULTICAST_CONFIG_ERROR",
    2565: "MQRC_MULTICAST_INTERFACE_ERROR",
    2566: "MQRC_MULTICAST_SEND_ERROR",
    2567: "MQRC_MULTICAST_INTERNAL_ERROR",
    2568: "MQRC_CONNECTION_NOT_AVAILABLE",
    2569: "MQRC_SYNCPOINT_NOT_ALLOWED",
    2570: "MQRC_SSL_ALT_PROVIDER_REQUIRED",
    2571: "MQRC_MCAST_PUB_STATUS",
    2572: "MQRC_MCAST_SUB_STATUS",
    2573: "MQRC_PRECONN_EXIT_LOAD_ERROR",
    2574: "MQRC_PRECONN_EXIT_NOT_FOUND",
    2575: "MQRC_PRECONN_EXIT_ERROR",
    2576: "MQRC_CD_ARRAY_ERROR",
    2577: "MQRC_CHANNEL_BLOCKED",
    2578: "MQRC_CHANNEL_BLOCKED_WARNING",
    2579: "MQRC_SUBSCRIPTION_CREATE",
    2580: "MQRC_SUBSCRIPTION_DELETE",
    2581: "MQRC_SUBSCRIPTION_CHANGE",
    2582: "MQRC_SUBSCRIPTION_REFRESH",
    2583: "MQRC_INSTALLATION_MISMATCH",
    2584: "MQRC_NOT_PRIVILEGED",
    2586: "MQRC_PROPERTIES_DISABLED",
    2587: "MQRC_HMSG_NOT_AVAILABLE",
    2588: "MQRC_EXIT_PROPS_NOT_SUPPORTED",
    2589: "MQRC_INSTALLATION_MISSING",
    2590: "MQRC_FASTPATH_NOT_AVAILABLE",
    2591: "MQRC_CIPHER_SPEC_NOT_SUITE_B",
    2592: "MQRC_SUITE_B_ERROR",
    2593: "MQRC_CERT_VAL_POLICY_ERROR",
    2594: "MQRC_PASSWORD_PROTECTION_ERROR",
    2595: "MQRC_CSP_ERROR",
    2596: "MQRC_CERT_LABEL_NOT_ALLOWED",
    2598: "MQRC_ADMIN_TOPIC_STRING_ERROR",
    2599: "MQRC_AMQP_NOT_AVAILABLE",
    2600: "MQRC_CCDT_URL_ERROR",
    2601: "MQRC_Q_MGR_RECONNECT_REQUESTED",
    2602: "MQRC_BNO_ERROR",
    2603: "MQRC_OUTBOUND_SNI_NOT_VALID",
    2604: "MQRC_HTTPS_KEYSTORE_ERROR",
    6100: "MQRC_REOPEN_EXCL_INPUT_ERROR",
    6101: "MQRC_REOPEN_INQUIRE_ERROR",
    6102: "MQRC_REOPEN_SAVED_CONTEXT_ERR",
    6103: "MQRC_REOPEN_TEMPORARY_Q_ERROR",
    6104: "MQRC_ATTRIBUTE_LOCKED",
    6105: "MQRC_CURSOR_NOT_VALID",
    6106: "MQRC_ENCODING_ERROR",
    6107: "MQRC_STRUC_ID_ERROR",
    6108: "MQRC_NULL_POINTER",
    6109: "MQRC_NO_CONNECTION_REFERENCE",
    6110: "MQRC_NO_BUFFER",
    6111: "MQRC_BINARY_DATA_LENGTH_ERROR",
    6112: "MQRC_BUFFER_NOT_AUTOMATIC",
    6113: "MQRC_INSUFFICIENT_BUFFER",
    6114: "MQRC_INSUFFICIENT_DATA",
    6115: "MQRC_DATA_TRUNCATED",
    6116: "MQRC_ZERO_LENGTH",
    6117: "MQRC_NEGATIVE_LENGTH",
    6118: "MQRC_NEGATIVE_OFFSET",
    6119: "MQRC_INCONSISTENT_FORMAT",
    6120: "MQRC_INCONSISTENT_OBJECT_STATE",
    6121: "MQRC_CONTEXT_OBJECT_NOT_VALID",
    6122: "MQRC_CONTEXT_OPEN_ERROR",
    6123: "MQRC_STRUC_LENGTH_ERROR",
    6124: "MQRC_NOT_CONNECTED",
    6125: "MQRC_NOT_OPEN",
    6126: "MQRC_DISTRIBUTION_LIST_EMPTY",
    6127: "MQRC_INCONSISTENT_OPEN_OPTIONS",
    6128: "MQRC_WRONG_VERSION",
    6129: "MQRC_REFERENCE_ERROR",
    6130: "MQRC_XR_NOT_AVAILABLE",
    29440: "MQRC_SUB_JOIN_NOT_ALTERABLE",
}

MQRDNS_DICT = {
    0: "MQRDNS_ENABLED",
    1: "MQRDNS_DISABLED",
}

MQRD_DICT = {
    -1: "MQRD_NO_RECONNECT",
    0: "MQRD_NO_DELAY",
}

MQREADA_DICT = {
    0: "MQREADA_NO",
    1: "MQREADA_YES",
    2: "MQREADA_DISABLED",
    3: "MQREADA_INHIBITED",
    4: "MQREADA_BACKLOG",
}

MQRECAUTO_DICT = {
    0: "MQRECAUTO_NO",
    1: "MQRECAUTO_YES",
}

MQRECORDING_DICT = {
    0: "MQRECORDING_DISABLED",
    1: "MQRECORDING_Q",
    2: "MQRECORDING_MSG",
}

MQREGO_DICT = {
    0: "MQREGO_NONE",
    1: "MQREGO_CORREL_ID_AS_IDENTITY",
    2: "MQREGO_ANONYMOUS",
    4: "MQREGO_LOCAL",
    8: "MQREGO_DIRECT_REQUESTS",
    16: "MQREGO_NEW_PUBLICATIONS_ONLY",
    32: "MQREGO_PUBLISH_ON_REQUEST_ONLY",
    64: "MQREGO_DEREGISTER_ALL",
    128: "MQREGO_INCLUDE_STREAM_NAME",
    256: "MQREGO_INFORM_IF_RETAINED",
    512: "MQREGO_DUPLICATES_OK",
    1024: "MQREGO_NON_PERSISTENT",
    2048: "MQREGO_PERSISTENT",
    4096: "MQREGO_PERSISTENT_AS_PUBLISH",
    8192: "MQREGO_PERSISTENT_AS_Q",
    16384: "MQREGO_ADD_NAME",
    32768: "MQREGO_NO_ALTERATION",
    65536: "MQREGO_FULL_RESPONSE",
    131072: "MQREGO_JOIN_SHARED",
    262144: "MQREGO_JOIN_EXCLUSIVE",
    524288: "MQREGO_LEAVE_ONLY",
    1048576: "MQREGO_VARIABLE_USER_ID",
    2097152: "MQREGO_LOCKED",
}

MQREORG_DICT = {
    0: "MQREORG_DISABLED",
    1: "MQREORG_ENABLED",
}

MQRFH_DICT = {
    -65536: "MQRFH_FLAGS_RESTRICTED_MASK",
    0: "MQRFH_NONE",
}

MQRL_DICT = {
    -1: "MQRL_UNDEFINED",
}

MQRMHF_DICT = {
    0: "MQRMHF_NOT_LAST",
    1: "MQRMHF_LAST",
}

MQROUTE_DICT = {
    -65536: "MQROUTE_DELIVER_REJ_UNSUP_MASK",
    0: "MQROUTE_UNLIMITED_ACTIVITIES",
    2: "MQROUTE_DETAIL_LOW",
    8: "MQROUTE_DETAIL_MEDIUM",
    32: "MQROUTE_DETAIL_HIGH",
    256: "MQROUTE_FORWARD_ALL",
    512: "MQROUTE_FORWARD_IF_SUPPORTED",
    4096: "MQROUTE_DELIVER_YES",
    8192: "MQROUTE_DELIVER_NO",
    65539: "MQROUTE_ACCUMULATE_NONE",
    65540: "MQROUTE_ACCUMULATE_IN_MSG",
    65541: "MQROUTE_ACCUMULATE_AND_REPLY",
}

MQRO_DICT = {
    -270532353: "MQRO_ACCEPT_UNSUP_MASK",
    0: "MQRO_NONE",
    1: "MQRO_PAN",
    2: "MQRO_NAN",
    4: "MQRO_ACTIVITY",
    64: "MQRO_PASS_CORREL_ID",
    128: "MQRO_PASS_MSG_ID",
    256: "MQRO_COA",
    768: "MQRO_COA_WITH_DATA",
    1792: "MQRO_COA_WITH_FULL_DATA",
    2048: "MQRO_COD",
    6144: "MQRO_COD_WITH_DATA",
    14336: "MQRO_COD_WITH_FULL_DATA",
    16384: "MQRO_PASS_DISCARD_AND_EXPIRY",
    261888: "MQRO_ACCEPT_UNSUP_IF_XMIT_MASK",
    2097152: "MQRO_EXPIRATION",
    6291456: "MQRO_EXPIRATION_WITH_DATA",
    14680064: "MQRO_EXPIRATION_WITH_FULL_DATA",
    16777216: "MQRO_EXCEPTION",
    50331648: "MQRO_EXCEPTION_WITH_DATA",
    117440512: "MQRO_EXCEPTION_WITH_FULL_DATA",
    134217728: "MQRO_DISCARD_MSG",
    270270464: "MQRO_REJECT_UNSUP_MASK",
}

MQRP_DICT = {
    0: "MQRP_NO",
    1: "MQRP_YES",
}

MQRQ_DICT = {
    1: "MQRQ_CONN_NOT_AUTHORIZED",
    2: "MQRQ_OPEN_NOT_AUTHORIZED",
    3: "MQRQ_CLOSE_NOT_AUTHORIZED",
    4: "MQRQ_CMD_NOT_AUTHORIZED",
    5: "MQRQ_Q_MGR_STOPPING",
    6: "MQRQ_Q_MGR_QUIESCING",
    7: "MQRQ_CHANNEL_STOPPED_OK",
    8: "MQRQ_CHANNEL_STOPPED_ERROR",
    9: "MQRQ_CHANNEL_STOPPED_RETRY",
    10: "MQRQ_CHANNEL_STOPPED_DISABLED",
    11: "MQRQ_BRIDGE_STOPPED_OK",
    12: "MQRQ_BRIDGE_STOPPED_ERROR",
    13: "MQRQ_SSL_HANDSHAKE_ERROR",
    14: "MQRQ_SSL_CIPHER_SPEC_ERROR",
    15: "MQRQ_SSL_CLIENT_AUTH_ERROR",
    16: "MQRQ_SSL_PEER_NAME_ERROR",
    17: "MQRQ_SUB_NOT_AUTHORIZED",
    18: "MQRQ_SUB_DEST_NOT_AUTHORIZED",
    19: "MQRQ_SSL_UNKNOWN_REVOCATION",
    20: "MQRQ_SYS_CONN_NOT_AUTHORIZED",
    21: "MQRQ_CHANNEL_BLOCKED_ADDRESS",
    22: "MQRQ_CHANNEL_BLOCKED_USERID",
    23: "MQRQ_CHANNEL_BLOCKED_NOACCESS",
    24: "MQRQ_MAX_ACTIVE_CHANNELS",
    25: "MQRQ_MAX_CHANNELS",
    26: "MQRQ_SVRCONN_INST_LIMIT",
    27: "MQRQ_CLIENT_INST_LIMIT",
    28: "MQRQ_CAF_NOT_INSTALLED",
    29: "MQRQ_CSP_NOT_AUTHORIZED",
    30: "MQRQ_FAILOVER_PERMITTED",
    31: "MQRQ_FAILOVER_NOT_PERMITTED",
    32: "MQRQ_STANDBY_ACTIVATED",
    33: "MQRQ_REPLICA_ACTIVATED",
    65: "MQRQ_CONN_AUTHORIZED",
    66: "MQRQ_OPEN_AUTHORIZED",
    67: "MQRQ_SUB_AUTHORIZED",
    68: "MQRQ_SUB_DEST_AUTHORIZED",
}

MQRT_DICT = {
    1: "MQRT_CONFIGURATION",
    2: "MQRT_EXPIRY",
    3: "MQRT_NSPROC",
    4: "MQRT_PROXYSUB",
    5: "MQRT_SUB_CONFIGURATION",
}

MQRU_DICT = {
    1: "MQRU_PUBLISH_ON_REQUEST",
    2: "MQRU_PUBLISH_ALL",
}

MQSCA_DICT = {
    0: "MQSCA_REQUIRED",
    1: "MQSCA_OPTIONAL",
    2: "MQSCA_NEVER_REQUIRED",
}

MQSCOPE_DICT = {
    0: "MQSCOPE_ALL",
    1: "MQSCOPE_AS_PARENT",
    4: "MQSCOPE_QMGR",
}

MQSCO_DICT = {
    1: "MQSCO_Q_MGR",
    2: "MQSCO_CELL",
}

MQSCYC_DICT = {
    0: "MQSCYC_UPPER",
    1: "MQSCYC_MIXED",
}

MQSECCOMM_DICT = {
    0: "MQSECCOMM_NO",
    1: "MQSECCOMM_YES",
    2: "MQSECCOMM_ANON",
}

MQSECITEM_DICT = {
    0: "MQSECITEM_ALL",
    1: "MQSECITEM_MQADMIN",
    2: "MQSECITEM_MQNLIST",
    3: "MQSECITEM_MQPROC",
    4: "MQSECITEM_MQQUEUE",
    5: "MQSECITEM_MQCONN",
    6: "MQSECITEM_MQCMDS",
    7: "MQSECITEM_MXADMIN",
    8: "MQSECITEM_MXNLIST",
    9: "MQSECITEM_MXPROC",
    10: "MQSECITEM_MXQUEUE",
    11: "MQSECITEM_MXTOPIC",
}

MQSECPROT_DICT = {
    0: "MQSECPROT_NONE",
    1: "MQSECPROT_SSLV30",
    2: "MQSECPROT_TLSV10",
    4: "MQSECPROT_TLSV12",
    8: "MQSECPROT_TLSV13",
}

MQSECSW_DICT = {
    1: "MQSECSW_PROCESS",
    2: "MQSECSW_NAMELIST",
    3: "MQSECSW_Q",
    4: "MQSECSW_TOPIC",
    6: "MQSECSW_CONTEXT",
    7: "MQSECSW_ALTERNATE_USER",
    8: "MQSECSW_COMMAND",
    9: "MQSECSW_CONNECTION",
    10: "MQSECSW_SUBSYSTEM",
    11: "MQSECSW_COMMAND_RESOURCES",
    15: "MQSECSW_Q_MGR",
    16: "MQSECSW_QSG",
    21: "MQSECSW_OFF_FOUND",
    22: "MQSECSW_ON_FOUND",
    23: "MQSECSW_OFF_NOT_FOUND",
    24: "MQSECSW_ON_NOT_FOUND",
    25: "MQSECSW_OFF_ERROR",
    26: "MQSECSW_ON_OVERRIDDEN",
}

MQSECTYPE_DICT = {
    1: "MQSECTYPE_AUTHSERV",
    2: "MQSECTYPE_SSL",
    3: "MQSECTYPE_CLASSES",
    4: "MQSECTYPE_CONNAUTH",
}

MQSELTYPE_DICT = {
    0: "MQSELTYPE_NONE",
    1: "MQSELTYPE_STANDARD",
    2: "MQSELTYPE_EXTENDED",
}

MQSEL_ALL_DICT = {
    -30003: "MQSEL_ALL_SYSTEM_SELECTORS",
    -30002: "MQSEL_ALL_USER_SELECTORS",
    -30001: "MQSEL_ALL_SELECTORS",
}

MQSEL_ANY_DICT = {
    -30003: "MQSEL_ANY_SYSTEM_SELECTOR",
    -30002: "MQSEL_ANY_USER_SELECTOR",
    -30001: "MQSEL_ANY_SELECTOR",
}

MQSMPO_DICT = {
    0: "MQSMPO_NONE",
    1: "MQSMPO_SET_PROP_UNDER_CURSOR",
    2: "MQSMPO_SET_PROP_AFTER_CURSOR",
    4: "MQSMPO_APPEND_PROPERTY",
    8: "MQSMPO_SET_PROP_BEFORE_CURSOR",
}

MQSO_DICT = {
    0: "MQSO_NONE",
    1: "MQSO_ALTER",
    2: "MQSO_CREATE",
    4: "MQSO_RESUME",
    8: "MQSO_DURABLE",
    16: "MQSO_GROUP_SUB",
    32: "MQSO_MANAGED",
    64: "MQSO_SET_IDENTITY_CONTEXT",
    128: "MQSO_NO_MULTICAST",
    256: "MQSO_FIXED_USERID",
    512: "MQSO_ANY_USERID",
    2048: "MQSO_PUBLICATIONS_ON_REQUEST",
    4096: "MQSO_NEW_PUBLICATIONS_ONLY",
    8192: "MQSO_FAIL_IF_QUIESCING",
    262144: "MQSO_ALTERNATE_USER_AUTHORITY",
    1048576: "MQSO_WILDCARD_CHAR",
    2097152: "MQSO_WILDCARD_TOPIC",
    4194304: "MQSO_SET_CORREL_ID",
    67108864: "MQSO_SCOPE_QMGR",
    134217728: "MQSO_NO_READ_AHEAD",
    268435456: "MQSO_READ_AHEAD",
}

MQSPL_DICT = {
    0: "MQSPL_PASSTHRU",
    1: "MQSPL_REMOVE",
    2: "MQSPL_AS_POLICY",
}

MQSP_DICT = {
    0: "MQSP_NOT_AVAILABLE",
    1: "MQSP_AVAILABLE",
}

MQSQQM_DICT = {
    0: "MQSQQM_USE",
    1: "MQSQQM_IGNORE",
}

MQSRO_DICT = {
    0: "MQSRO_NONE",
    8192: "MQSRO_FAIL_IF_QUIESCING",
}

MQSR_DICT = {
    1: "MQSR_ACTION_PUBLICATION",
}

MQSSL_DICT = {
    0: "MQSSL_FIPS_NO",
    1: "MQSSL_FIPS_YES",
}

MQSTAT_DICT = {
    0: "MQSTAT_TYPE_ASYNC_ERROR",
    1: "MQSTAT_TYPE_RECONNECTION",
    2: "MQSTAT_TYPE_RECONNECTION_ERROR",
}

MQSTDBY_DICT = {
    0: "MQSTDBY_NOT_PERMITTED",
    1: "MQSTDBY_PERMITTED",
}

MQST_DICT = {
    0: "MQST_BEST_EFFORT",
    1: "MQST_MUST_DUP",
}

MQSUBTYPE_DICT = {
    -2: "MQSUBTYPE_USER",
    -1: "MQSUBTYPE_ALL",
    1: "MQSUBTYPE_API",
    2: "MQSUBTYPE_ADMIN",
    3: "MQSUBTYPE_PROXY",
}

MQSUB_DURABILITY_DICT = {
    -1: "MQSUB_DURABLE_ALL",
    1: "MQSUB_DURABLE_YES",
    2: "MQSUB_DURABLE_NO",
}

MQSUB_DICT = {
    0: "MQSUB_DURABLE_AS_PARENT",
    1: "MQSUB_DURABLE_ALLOWED",
    2: "MQSUB_DURABLE_INHIBITED",
}

MQSUS_DICT = {
    0: "MQSUS_NO",
    1: "MQSUS_YES",
}

MQSVC_CONTROL_DICT = {
    0: "MQSVC_CONTROL_Q_MGR",
    1: "MQSVC_CONTROL_Q_MGR_START",
    2: "MQSVC_CONTROL_MANUAL",
}

MQSVC_STATUS_DICT = {
    0: "MQSVC_STATUS_STOPPED",
    1: "MQSVC_STATUS_STARTING",
    2: "MQSVC_STATUS_RUNNING",
    3: "MQSVC_STATUS_STOPPING",
    4: "MQSVC_STATUS_RETRYING",
}

MQSVC_TYPE_DICT = {
    0: "MQSVC_TYPE_COMMAND",
    1: "MQSVC_TYPE_SERVER",
}

MQSYNCPOINT_DICT = {
    0: "MQSYNCPOINT_YES",
    1: "MQSYNCPOINT_IFPER",
}

MQSYSOBJ_DICT = {
    0: "MQSYSOBJ_YES",
    1: "MQSYSOBJ_NO",
}

MQSYSP_DICT = {
    0: "MQSYSP_NO",
    1: "MQSYSP_YES",
    2: "MQSYSP_EXTENDED",
    10: "MQSYSP_TYPE_INITIAL",
    11: "MQSYSP_TYPE_SET",
    12: "MQSYSP_TYPE_LOG_COPY",
    13: "MQSYSP_TYPE_LOG_STATUS",
    14: "MQSYSP_TYPE_ARCHIVE_TAPE",
    20: "MQSYSP_ALLOC_BLK",
    21: "MQSYSP_ALLOC_TRK",
    22: "MQSYSP_ALLOC_CYL",
    30: "MQSYSP_STATUS_BUSY",
    31: "MQSYSP_STATUS_PREMOUNT",
    32: "MQSYSP_STATUS_AVAILABLE",
    33: "MQSYSP_STATUS_UNKNOWN",
    34: "MQSYSP_STATUS_ALLOC_ARCHIVE",
    35: "MQSYSP_STATUS_COPYING_BSDS",
    36: "MQSYSP_STATUS_COPYING_LOG",
}

MQS_AVAIL_DICT = {
    0: "MQS_AVAIL_NORMAL",
    1: "MQS_AVAIL_ERROR",
    2: "MQS_AVAIL_STOPPED",
}

MQS_EXPANDST_DICT = {
    0: "MQS_EXPANDST_NORMAL",
    1: "MQS_EXPANDST_FAILED",
    2: "MQS_EXPANDST_MAXIMUM",
}

MQS_OPENMODE_DICT = {
    0: "MQS_OPENMODE_NONE",
    1: "MQS_OPENMODE_READONLY",
    2: "MQS_OPENMODE_UPDATE",
    3: "MQS_OPENMODE_RECOVERY",
}

MQS_STATUS_DICT = {
    0: "MQS_STATUS_CLOSED",
    1: "MQS_STATUS_CLOSING",
    2: "MQS_STATUS_OPENING",
    3: "MQS_STATUS_OPEN",
    4: "MQS_STATUS_NOTENABLED",
    5: "MQS_STATUS_ALLOCFAIL",
    6: "MQS_STATUS_OPENFAIL",
    7: "MQS_STATUS_STGFAIL",
    8: "MQS_STATUS_DATAFAIL",
}

MQTA_DICT = {
    1: "MQTA_BLOCK",
    2: "MQTA_PASSTHRU",
}

MQTA_PROXY_DICT = {
    1: "MQTA_PROXY_SUB_FORCE",
    2: "MQTA_PROXY_SUB_FIRSTUSE",
}

MQTA_PUB_DICT = {
    0: "MQTA_PUB_AS_PARENT",
    1: "MQTA_PUB_INHIBITED",
    2: "MQTA_PUB_ALLOWED",
}

MQTA_SUB_DICT = {
    0: "MQTA_SUB_AS_PARENT",
    1: "MQTA_SUB_INHIBITED",
    2: "MQTA_SUB_ALLOWED",
}

MQTCPKEEP_DICT = {
    0: "MQTCPKEEP_NO",
    1: "MQTCPKEEP_YES",
}

MQTCPSTACK_DICT = {
    0: "MQTCPSTACK_SINGLE",
    1: "MQTCPSTACK_MULTIPLE",
}

MQTC_DICT = {
    0: "MQTC_OFF",
    1: "MQTC_ON",
}

MQTIME_DICT = {
    0: "MQTIME_UNIT_MINS",
    1: "MQTIME_UNIT_SECS",
}

MQTOPT_DICT = {
    0: "MQTOPT_LOCAL",
    1: "MQTOPT_CLUSTER",
    2: "MQTOPT_ALL",
}

MQTRAXSTR_DICT = {
    0: "MQTRAXSTR_NO",
    1: "MQTRAXSTR_YES",
}

MQTRIGGER_DICT = {
    0: "MQTRIGGER_RESTART_NO",
    1: "MQTRIGGER_RESTART_YES",
}

MQTSCOPE_DICT = {
    1: "MQTSCOPE_QMGR",
    2: "MQTSCOPE_ALL",
}

MQTT_DICT = {
    0: "MQTT_NONE",
    1: "MQTT_FIRST",
    2: "MQTT_EVERY",
    3: "MQTT_DEPTH",
}

MQTYPE_DICT = {
    0: "MQTYPE_AS_SET",
    2: "MQTYPE_NULL",
    4: "MQTYPE_BOOLEAN",
    8: "MQTYPE_BYTE_STRING",
    16: "MQTYPE_INT8",
    32: "MQTYPE_INT16",
    64: "MQTYPE_INT32",
    128: "MQTYPE_INT64",
    256: "MQTYPE_FLOAT32",
    512: "MQTYPE_FLOAT64",
    1024: "MQTYPE_STRING",
}

MQUCI_DICT = {
    0: "MQUCI_NO",
    1: "MQUCI_YES",
}

MQUIDSUPP_DICT = {
    0: "MQUIDSUPP_NO",
    1: "MQUIDSUPP_YES",
}

MQUNDELIVERED_DICT = {
    0: "MQUNDELIVERED_NORMAL",
    1: "MQUNDELIVERED_SAFE",
    2: "MQUNDELIVERED_DISCARD",
    3: "MQUNDELIVERED_KEEP",
}

MQUOWST_DICT = {
    0: "MQUOWST_NONE",
    1: "MQUOWST_ACTIVE",
    2: "MQUOWST_PREPARED",
    3: "MQUOWST_UNRESOLVED",
}

MQUOWT_DICT = {
    0: "MQUOWT_Q_MGR",
    1: "MQUOWT_CICS",
    2: "MQUOWT_RRS",
    3: "MQUOWT_IMS",
    4: "MQUOWT_XA",
}

MQUSAGE_DS_DICT = {
    10: "MQUSAGE_DS_OLDEST_ACTIVE_UOW",
    11: "MQUSAGE_DS_OLDEST_PS_RECOVERY",
    12: "MQUSAGE_DS_OLDEST_CF_RECOVERY",
}

MQUSAGE_EXPAND_DICT = {
    1: "MQUSAGE_EXPAND_USER",
    2: "MQUSAGE_EXPAND_SYSTEM",
    3: "MQUSAGE_EXPAND_NONE",
}

MQUSAGE_PS_DICT = {
    0: "MQUSAGE_PS_AVAILABLE",
    1: "MQUSAGE_PS_DEFINED",
    2: "MQUSAGE_PS_OFFLINE",
    3: "MQUSAGE_PS_NOT_DEFINED",
    4: "MQUSAGE_PS_SUSPENDED",
}

MQUSAGE_SMDS_DICT = {
    0: "MQUSAGE_SMDS_AVAILABLE",
    1: "MQUSAGE_SMDS_NO_DATA",
}

MQUSEDLQ_DICT = {
    0: "MQUSEDLQ_AS_PARENT",
    1: "MQUSEDLQ_NO",
    2: "MQUSEDLQ_YES",
}

MQUSRC_DICT = {
    0: "MQUSRC_MAP",
    1: "MQUSRC_NOACCESS",
    2: "MQUSRC_CHANNEL",
}

MQUS_DICT = {
    0: "MQUS_NORMAL",
    1: "MQUS_TRANSMISSION",
}

MQVL_DICT = {
    -1: "MQVL_NULL_TERMINATED",
    0: "MQVL_EMPTY_STRING",
}

MQVS_DICT = {
    -1: "MQVS_NULL_TERMINATED",
}

MQVU_DICT = {
    1: "MQVU_FIXED_USER",
    2: "MQVU_ANY_USER",
}

MQWARN_DICT = {
    0: "MQWARN_NO",
    1: "MQWARN_YES",
}

MQWIH_DICT = {
    0: "MQWIH_NONE",
}

MQWI_DICT = {
    -1: "MQWI_UNLIMITED",
}

MQWS_DICT = {
    0: "MQWS_DEFAULT",
    1: "MQWS_CHAR",
    2: "MQWS_TOPIC",
}

MQWXP_DICT = {
    2: "MQWXP_PUT_BY_CLUSTER_CHL",
}

MQXACT_DICT = {
    1: "MQXACT_EXTERNAL",
    2: "MQXACT_INTERNAL",
}

MQXCC_DICT = {
    -8: "MQXCC_FAILED",
    -7: "MQXCC_REQUEST_ACK",
    -6: "MQXCC_CLOSE_CHANNEL",
    -5: "MQXCC_SUPPRESS_EXIT",
    -4: "MQXCC_SEND_SEC_MSG",
    -3: "MQXCC_SEND_AND_REQUEST_SEC_MSG",
    -2: "MQXCC_SKIP_FUNCTION",
    -1: "MQXCC_SUPPRESS_FUNCTION",
    0: "MQXCC_OK",
}

MQXC_DICT = {
    1: "MQXC_MQOPEN",
    2: "MQXC_MQCLOSE",
    3: "MQXC_MQGET",
    4: "MQXC_MQPUT",
    5: "MQXC_MQPUT1",
    6: "MQXC_MQINQ",
    8: "MQXC_MQSET",
    9: "MQXC_MQBACK",
    10: "MQXC_MQCMIT",
    42: "MQXC_MQSUB",
    43: "MQXC_MQSUBRQ",
    44: "MQXC_MQCB",
    45: "MQXC_MQCTL",
    46: "MQXC_MQSTAT",
    48: "MQXC_CALLBACK",
}

MQXDR_DICT = {
    0: "MQXDR_OK",
    1: "MQXDR_CONVERSION_FAILED",
}

MQXEPO_DICT = {
    0: "MQXEPO_NONE",
}

MQXE_DICT = {
    0: "MQXE_OTHER",
    1: "MQXE_MCA",
    2: "MQXE_MCA_SVRCONN",
    3: "MQXE_COMMAND_SERVER",
    4: "MQXE_MQSC",
    5: "MQXE_MCA_CLNTCONN",
}

MQXF_DICT = {
    1: "MQXF_INIT",
    2: "MQXF_TERM",
    3: "MQXF_CONN",
    4: "MQXF_CONNX",
    5: "MQXF_DISC",
    6: "MQXF_OPEN",
    7: "MQXF_CLOSE",
    8: "MQXF_PUT1",
    9: "MQXF_PUT",
    10: "MQXF_GET",
    11: "MQXF_DATA_CONV_ON_GET",
    12: "MQXF_INQ",
    13: "MQXF_SET",
    14: "MQXF_BEGIN",
    15: "MQXF_CMIT",
    16: "MQXF_BACK",
    18: "MQXF_STAT",
    19: "MQXF_CB",
    20: "MQXF_CTL",
    21: "MQXF_CALLBACK",
    22: "MQXF_SUB",
    23: "MQXF_SUBRQ",
    24: "MQXF_XACLOSE",
    25: "MQXF_XACOMMIT",
    26: "MQXF_XACOMPLETE",
    27: "MQXF_XAEND",
    28: "MQXF_XAFORGET",
    29: "MQXF_XAOPEN",
    30: "MQXF_XAPREPARE",
    31: "MQXF_XARECOVER",
    32: "MQXF_XAROLLBACK",
    33: "MQXF_XASTART",
    34: "MQXF_AXREG",
    35: "MQXF_AXUNREG",
}

MQXPT_DICT = {
    -1: "MQXPT_ALL",
    0: "MQXPT_LOCAL",
    1: "MQXPT_LU62",
    2: "MQXPT_TCP",
    3: "MQXPT_NETBIOS",
    4: "MQXPT_SPX",
    5: "MQXPT_DECNET",
    6: "MQXPT_UDP",
}

MQXR2_DICT = {
    0: "MQXR2_DEFAULT_CONTINUATION",
    1: "MQXR2_PUT_WITH_DEF_USERID",
    2: "MQXR2_PUT_WITH_MSG_USERID",
    4: "MQXR2_USE_EXIT_BUFFER",
    8: "MQXR2_CONTINUE_CHAIN",
    16: "MQXR2_SUPPRESS_CHAIN",
    32: "MQXR2_DYNAMIC_CACHE",
}

MQXR_DICT = {
    1: "MQXR_BEFORE",
    2: "MQXR_AFTER",
    3: "MQXR_CONNECTION",
    4: "MQXR_BEFORE_CONVERT",
    11: "MQXR_INIT",
    12: "MQXR_TERM",
    13: "MQXR_MSG",
    14: "MQXR_XMIT",
    15: "MQXR_SEC_MSG",
    16: "MQXR_INIT_SEC",
    17: "MQXR_RETRY",
    18: "MQXR_AUTO_CLUSSDR",
    19: "MQXR_AUTO_RECEIVER",
    20: "MQXR_CLWL_OPEN",
    21: "MQXR_CLWL_PUT",
    22: "MQXR_CLWL_MOVE",
    23: "MQXR_CLWL_REPOS",
    24: "MQXR_CLWL_REPOS_MOVE",
    25: "MQXR_END_BATCH",
    26: "MQXR_ACK_RECEIVED",
    27: "MQXR_AUTO_SVRCONN",
    28: "MQXR_AUTO_CLUSRCVR",
    29: "MQXR_SEC_PARMS",
    30: "MQXR_PUBLICATION",
    31: "MQXR_PRECONNECT",
}

MQXT_DICT = {
    1: "MQXT_API_CROSSING_EXIT",
    2: "MQXT_API_EXIT",
    11: "MQXT_CHANNEL_SEC_EXIT",
    12: "MQXT_CHANNEL_MSG_EXIT",
    13: "MQXT_CHANNEL_SEND_EXIT",
    14: "MQXT_CHANNEL_RCV_EXIT",
    15: "MQXT_CHANNEL_MSG_RETRY_EXIT",
    16: "MQXT_CHANNEL_AUTO_DEF_EXIT",
    20: "MQXT_CLUSTER_WORKLOAD_EXIT",
    21: "MQXT_PUBSUB_ROUTING_EXIT",
    22: "MQXT_PUBLISH_EXIT",
    23: "MQXT_PRECONNECT_EXIT",
}

MQZAET_DICT = {
    0: "MQZAET_NONE",
    1: "MQZAET_PRINCIPAL",
    2: "MQZAET_GROUP",
    3: "MQZAET_UNKNOWN",
}

MQZAO_DICT = {
    0: "MQZAO_NONE",
    1: "MQZAO_CONNECT",
    2: "MQZAO_BROWSE",
    4: "MQZAO_INPUT",
    8: "MQZAO_OUTPUT",
    16: "MQZAO_INQUIRE",
    32: "MQZAO_SET",
    64: "MQZAO_PASS_IDENTITY_CONTEXT",
    128: "MQZAO_PASS_ALL_CONTEXT",
    256: "MQZAO_SET_IDENTITY_CONTEXT",
    512: "MQZAO_SET_ALL_CONTEXT",
    1024: "MQZAO_ALTERNATE_USER_AUTHORITY",
    2048: "MQZAO_PUBLISH",
    4096: "MQZAO_SUBSCRIBE",
    8192: "MQZAO_RESUME",
    16383: "MQZAO_ALL_MQI",
    65536: "MQZAO_CREATE",
    131072: "MQZAO_DELETE",
    262144: "MQZAO_DISPLAY",
    524288: "MQZAO_CHANGE",
    1048576: "MQZAO_CLEAR",
    2097152: "MQZAO_CONTROL",
    4194304: "MQZAO_CONTROL_EXTENDED",
    8388608: "MQZAO_AUTHORIZE",
    16646144: "MQZAO_ALL_ADMIN",
    16777216: "MQZAO_REMOVE",
    33554432: "MQZAO_SYSTEM",
    50216959: "MQZAO_ALL",
    67108864: "MQZAO_CREATE_ONLY",
}

MQZAT_DICT = {
    0: "MQZAT_INITIAL_CONTEXT",
    1: "MQZAT_CHANGE_CONTEXT",
}

MQZCI_DICT = {
    0: "MQZCI_CONTINUE",
    1: "MQZCI_STOP",
}

MQZID_AUTHORITY_DICT = {
    0: "MQZID_INIT_AUTHORITY",
    1: "MQZID_TERM_AUTHORITY",
    2: "MQZID_CHECK_AUTHORITY",
    3: "MQZID_COPY_ALL_AUTHORITY",
    4: "MQZID_DELETE_AUTHORITY",
    5: "MQZID_SET_AUTHORITY",
    6: "MQZID_GET_AUTHORITY",
    7: "MQZID_GET_EXPLICIT_AUTHORITY",
    8: "MQZID_REFRESH_CACHE",
    9: "MQZID_ENUMERATE_AUTHORITY_DATA",
    10: "MQZID_AUTHENTICATE_USER",
    11: "MQZID_FREE_USER",
    12: "MQZID_INQUIRE",
    13: "MQZID_CHECK_PRIVILEGED",
}

MQZID_NAME_DICT = {
    0: "MQZID_INIT_NAME",
    1: "MQZID_TERM_NAME",
    2: "MQZID_LOOKUP_NAME",
    3: "MQZID_INSERT_NAME",
    4: "MQZID_DELETE_NAME",
}

MQZID_USERID_DICT = {
    0: "MQZID_INIT_USERID",
    1: "MQZID_TERM_USERID",
    2: "MQZID_FIND_USERID",
}

MQZID_DICT = {
    0: "MQZID_INIT",
    1: "MQZID_TERM",
}

MQZIO_DICT = {
    0: "MQZIO_PRIMARY",
    1: "MQZIO_SECONDARY",
}

MQZSE_DICT = {
    0: "MQZSE_CONTINUE",
    1: "MQZSE_START",
}

MQZSL_DICT = {
    0: "MQZSL_NOT_RETURNED",
    1: "MQZSL_RETURNED",
}

MQZTO_DICT = {
    0: "MQZTO_PRIMARY",
    1: "MQZTO_SECONDARY",
}

MQ_CERT_DICT = {
    0: "MQ_CERT_VAL_POLICY_ANY",
    1: "MQ_CERT_VAL_POLICY_RFC5280",
    2: "MQ_CERT_VAL_POLICY_NONE",
}

MQ_HTTPSCERTREV_DICT = {
    0: "MQ_HTTPSCERTREV_DEFAULT",
    1: "MQ_HTTPSCERTREV_REQUIRED",
    2: "MQ_HTTPSCERTREV_DISABLED",
    3: "MQ_HTTPSCERTREV_OPTIONAL",
}

MQ_HTTPSCERTVAL_DICT = {
    0: "MQ_HTTPSCERTVAL_DEFAULT",
    1: "MQ_HTTPSCERTVAL_ANY",
    2: "MQ_HTTPSCERTVAL_NONE",
    3: "MQ_HTTPSCERTVAL_HOSTNAMECN",
}

MQ_MQTT_DICT = {
    65536: "MQ_MQTT_MAX_KEEP_ALIVE",
}

MQ_SUITE_DICT = {
    0: "MQ_SUITE_B_NOT_AVAILABLE",
    1: "MQ_SUITE_B_NONE",
    2: "MQ_SUITE_B_128_BIT",
    4: "MQ_SUITE_B_192_BIT",
}



# This list can be iterated to find all names matching a value
# or vice versa. Uppercase name to indicate it shouldn't be changed.
MQI_VALUE_NAME_LIST = [
    {  "value": -270532353, "name": "MQRO_ACCEPT_UNSUP_MASK" },
    {  "value":   -1048576, "name": "MQMF_ACCEPT_UNSUP_MASK" },
    {  "value":   -1048576, "name": "MQPD_REJECT_UNSUP_MASK" },
    {  "value":     -65536, "name": "MQRFH_FLAGS_RESTRICTED_MASK" },
    {  "value":     -65536, "name": "MQROUTE_DELIVER_REJ_UNSUP_MASK" },
    {  "value":     -65536, "name": "MQROUTE_FORWARD_REJ_UNSUP_MASK" },
    {  "value":     -30003, "name": "MQSEL_ALL_SYSTEM_SELECTORS" },
    {  "value":     -30003, "name": "MQSEL_ANY_SYSTEM_SELECTOR" },
    {  "value":     -30002, "name": "MQSEL_ALL_USER_SELECTORS" },
    {  "value":     -30002, "name": "MQSEL_ANY_USER_SELECTOR" },
    {  "value":     -30001, "name": "MQSEL_ALL_SELECTORS" },
    {  "value":     -30001, "name": "MQSEL_ANY_SELECTOR" },
    {  "value":      -4096, "name": "MQENC_RESERVED_MASK" },
    {  "value":      -2000, "name": "MQIASY_LAST" },
    {  "value":         -9, "name": "MQIASY_LAST_USED" },
    {  "value":         -9, "name": "MQIASY_VERSION" },
    {  "value":         -8, "name": "MQIASY_BAG_OPTIONS" },
    {  "value":         -8, "name": "MQXCC_FAILED" },
    {  "value":         -7, "name": "MQIASY_REASON" },
    {  "value":         -7, "name": "MQXCC_REQUEST_ACK" },
    {  "value":         -6, "name": "MQIASY_COMP_CODE" },
    {  "value":         -6, "name": "MQXCC_CLOSE_CHANNEL" },
    {  "value":         -5, "name": "MQIASY_CONTROL" },
    {  "value":         -5, "name": "MQXCC_SUPPRESS_EXIT" },
    {  "value":         -4, "name": "MQCCSI_AS_PUBLISHED" },
    {  "value":         -4, "name": "MQIASY_MSG_SEQ_NUMBER" },
    {  "value":         -4, "name": "MQXCC_SEND_SEC_MSG" },
    {  "value":         -3, "name": "MQAUTH_ALL_MQI" },
    {  "value":         -3, "name": "MQCCSI_APPL" },
    {  "value":         -3, "name": "MQCLWL_USEQ_AS_Q_MGR" },
    {  "value":         -3, "name": "MQHC_UNASSOCIATED_HCONN" },
    {  "value":         -3, "name": "MQIASY_COMMAND" },
    {  "value":         -3, "name": "MQMON_Q_MGR" },
    {  "value":         -3, "name": "MQPRI_PRIORITY_AS_PUBLISHED" },
    {  "value":         -3, "name": "MQXCC_SEND_AND_REQUEST_SEC_MSG" },
    {  "value":         -2, "name": "MQAUTH_ALL_ADMIN" },
    {  "value":         -2, "name": "MQBNO_TIMEOUT_NEVER" },
    {  "value":         -2, "name": "MQCCSI_INHERIT" },
    {  "value":         -2, "name": "MQCEX_AS_PARENT" },
    {  "value":         -2, "name": "MQCGWI_DEFAULT" },
    {  "value":         -2, "name": "MQHB_NONE" },
    {  "value":         -2, "name": "MQIASY_TYPE" },
    {  "value":         -2, "name": "MQIAV_UNDEFINED" },
    {  "value":         -2, "name": "MQIND_ALL" },
    {  "value":         -2, "name": "MQLR_MAX" },
    {  "value":         -2, "name": "MQMCP_COMPAT" },
    {  "value":         -2, "name": "MQPRI_PRIORITY_AS_PARENT" },
    {  "value":         -2, "name": "MQSUBTYPE_USER" },
    {  "value":         -2, "name": "MQXCC_SKIP_FUNCTION" },
    {  "value":         -1, "name": "MQAT_UNKNOWN" },
    {  "value":         -1, "name": "MQAUTH_ALL" },
    {  "value":         -1, "name": "MQBL_NULL_TERMINATED" },
    {  "value":         -1, "name": "MQBNO_TIMEOUT_AS_DEFAULT" },
    {  "value":         -1, "name": "MQCBD_FULL_MSG_LENGTH" },
    {  "value":         -1, "name": "MQCCSI_EMBEDDED" },
    {  "value":         -1, "name": "MQCC_UNKNOWN" },
    {  "value":         -1, "name": "MQCEX_NOLIMIT" },
    {  "value":         -1, "name": "MQCHLD_ALL" },
    {  "value":         -1, "name": "MQCODL_AS_INPUT" },
    {  "value":         -1, "name": "MQCOMPRESS_NOT_AVAILABLE" },
    {  "value":         -1, "name": "MQEI_UNLIMITED" },
    {  "value":         -1, "name": "MQENC_AS_PUBLISHED" },
    {  "value":         -1, "name": "MQFS_SHARED" },
    {  "value":         -1, "name": "MQHB_UNUSABLE_HBAG" },
    {  "value":         -1, "name": "MQHC_UNUSABLE_HCONN" },
    {  "value":         -1, "name": "MQHM_UNUSABLE_HMSG" },
    {  "value":         -1, "name": "MQHO_UNUSABLE_HOBJ" },
    {  "value":         -1, "name": "MQIASY_CODED_CHAR_SET_ID" },
    {  "value":         -1, "name": "MQIASY_FIRST" },
    {  "value":         -1, "name": "MQIAV_NOT_APPLICABLE" },
    {  "value":         -1, "name": "MQIND_NONE" },
    {  "value":         -1, "name": "MQKAI_AUTO" },
    {  "value":         -1, "name": "MQKEY_REUSE_UNLIMITED" },
    {  "value":         -1, "name": "MQLR_AUTO" },
    {  "value":         -1, "name": "MQMCP_ALL" },
    {  "value":         -1, "name": "MQMMBI_UNLIMITED" },
    {  "value":         -1, "name": "MQMON_NONE" },
    {  "value":         -1, "name": "MQMON_NOT_AVAILABLE" },
    {  "value":         -1, "name": "MQNHABACKLOG_UNKNOWN" },
    {  "value":         -1, "name": "MQNHATYPE_ALL" },
    {  "value":         -1, "name": "MQNSH_ALL" },
    {  "value":         -1, "name": "MQOL_UNDEFINED" },
    {  "value":         -1, "name": "MQPER_PERSISTENCE_AS_PARENT" },
    {  "value":         -1, "name": "MQPRI_PRIORITY_AS_Q_DEF" },
    {  "value":         -1, "name": "MQPRI_PRIORITY_AS_TOPIC_DEF" },
    {  "value":         -1, "name": "MQPROP_UNRESTRICTED_LENGTH" },
    {  "value":         -1, "name": "MQPSCT_NONE" },
    {  "value":         -1, "name": "MQQFS_DEFAULT" },
    {  "value":         -1, "name": "MQQSGD_ALL" },
    {  "value":         -1, "name": "MQRD_NO_RECONNECT" },
    {  "value":         -1, "name": "MQRL_UNDEFINED" },
    {  "value":         -1, "name": "MQSUBTYPE_ALL" },
    {  "value":         -1, "name": "MQSUB_DURABLE_ALL" },
    {  "value":         -1, "name": "MQVL_NULL_TERMINATED" },
    {  "value":         -1, "name": "MQVS_NULL_TERMINATED" },
    {  "value":         -1, "name": "MQWI_UNLIMITED" },
    {  "value":         -1, "name": "MQXCC_SUPPRESS_FUNCTION" },
    {  "value":         -1, "name": "MQXPT_ALL" },
    {  "value":          0, "name": "MQACTIVE_NO" },
    {  "value":          0, "name": "MQACTP_NEW" },
    {  "value":          0, "name": "MQADOPT_CHECK_NONE" },
    {  "value":          0, "name": "MQADOPT_TYPE_NO" },
    {  "value":          0, "name": "MQADPCTX_NO" },
    {  "value":          0, "name": "MQAIT_ALL" },
    {  "value":          0, "name": "MQAPPL_IMMOVABLE" },
    {  "value":          0, "name": "MQAS_NONE" },
    {  "value":          0, "name": "MQAT_NO_CONTEXT" },
    {  "value":          0, "name": "MQAUSC_FAILURES" },
    {  "value":          0, "name": "MQAUTHENTICATE_OS" },
    {  "value":          0, "name": "MQAUTH_NONE" },
    {  "value":          0, "name": "MQAUTOCLUS_TYPE_NONE" },
    {  "value":          0, "name": "MQAUTO_START_NO" },
    {  "value":          0, "name": "MQBALANCED_NO" },
    {  "value":          0, "name": "MQBALSTATE_NOT_APPLICABLE" },
    {  "value":          0, "name": "MQBMHO_NONE" },
    {  "value":          0, "name": "MQBND_BIND_ON_OPEN" },
    {  "value":          0, "name": "MQBNO_BALTYPE_SIMPLE" },
    {  "value":          0, "name": "MQBNO_OPTIONS_NONE" },
    {  "value":          0, "name": "MQBNO_TIMEOUT_IMMEDIATE" },
    {  "value":          0, "name": "MQBO_NONE" },
    {  "value":          0, "name": "MQBPLOCATION_BELOW" },
    {  "value":          0, "name": "MQCADSD_NONE" },
    {  "value":          0, "name": "MQCAFTY_NONE" },
    {  "value":          0, "name": "MQCAP_NOT_SUPPORTED" },
    {  "value":          0, "name": "MQCAUT_ALL" },
    {  "value":          0, "name": "MQCBCF_NONE" },
    {  "value":          0, "name": "MQCBDO_NONE" },
    {  "value":          0, "name": "MQCBO_DO_NOT_CHECK_SELECTORS" },
    {  "value":          0, "name": "MQCBO_DO_NOT_REORDER" },
    {  "value":          0, "name": "MQCBO_LIST_FORM_INHIBITED" },
    {  "value":          0, "name": "MQCBO_NONE" },
    {  "value":          0, "name": "MQCBO_USER_BAG" },
    {  "value":          0, "name": "MQCCSI_DEFAULT" },
    {  "value":          0, "name": "MQCCSI_Q_MGR" },
    {  "value":          0, "name": "MQCCSI_UNDEFINED" },
    {  "value":          0, "name": "MQCCT_NO" },
    {  "value":          0, "name": "MQCC_OK" },
    {  "value":          0, "name": "MQCDC_NO_SENDER_CONVERSION" },
    {  "value":          0, "name": "MQCFACCESS_ENABLED" },
    {  "value":          0, "name": "MQCFCONLOS_TERMINATE" },
    {  "value":          0, "name": "MQCFC_NOT_LAST" },
    {  "value":          0, "name": "MQCFOFFLD_NONE" },
    {  "value":          0, "name": "MQCFO_REFRESH_REPOSITORY_NO" },
    {  "value":          0, "name": "MQCFO_REMOVE_QUEUES_NO" },
    {  "value":          0, "name": "MQCFR_NO" },
    {  "value":          0, "name": "MQCFSTATUS_NOT_FOUND" },
    {  "value":          0, "name": "MQCFTYPE_APPL" },
    {  "value":          0, "name": "MQCFT_NONE" },
    {  "value":          0, "name": "MQCF_NONE" },
    {  "value":          0, "name": "MQCHAD_DISABLED" },
    {  "value":          0, "name": "MQCHIDS_NOT_INDOUBT" },
    {  "value":          0, "name": "MQCHK_OPTIONAL" },
    {  "value":          0, "name": "MQCHLA_DISABLED" },
    {  "value":          0, "name": "MQCHRR_RESET_NOT_REQUESTED" },
    {  "value":          0, "name": "MQCHSH_RESTART_NO" },
    {  "value":          0, "name": "MQCHSR_STOP_NOT_REQUESTED" },
    {  "value":          0, "name": "MQCHSSTATE_OTHER" },
    {  "value":          0, "name": "MQCHS_INACTIVE" },
    {  "value":          0, "name": "MQCIH_NONE" },
    {  "value":          0, "name": "MQCIH_NO_SYNC_ON_RETURN" },
    {  "value":          0, "name": "MQCIH_REPLY_WITH_NULLS" },
    {  "value":          0, "name": "MQCIH_UNLIMITED_EXPIRATION" },
    {  "value":          0, "name": "MQCLCT_STATIC" },
    {  "value":          0, "name": "MQCLROUTE_DIRECT" },
    {  "value":          0, "name": "MQCLST_ACTIVE" },
    {  "value":          0, "name": "MQCLWL_USEQ_LOCAL" },
    {  "value":          0, "name": "MQCLXQ_SCTQ" },
    {  "value":          0, "name": "MQCMD_NONE" },
    {  "value":          0, "name": "MQCMHO_DEFAULT_VALIDATION" },
    {  "value":          0, "name": "MQCMHO_NONE" },
    {  "value":          0, "name": "MQCNO_NONE" },
    {  "value":          0, "name": "MQCNO_RECONNECT_AS_DEF" },
    {  "value":          0, "name": "MQCNO_STANDARD_BINDING" },
    {  "value":          0, "name": "MQCOMPRESS_NONE" },
    {  "value":          0, "name": "MQCOPY_NONE" },
    {  "value":          0, "name": "MQCO_IMMEDIATE" },
    {  "value":          0, "name": "MQCO_NONE" },
    {  "value":          0, "name": "MQCRC_OK" },
    {  "value":          0, "name": "MQCSP_AUTH_NONE" },
    {  "value":          0, "name": "MQCSRV_CONVERT_NO" },
    {  "value":          0, "name": "MQCSRV_DLQ_NO" },
    {  "value":          0, "name": "MQCS_NONE" },
    {  "value":          0, "name": "MQCTES_NOSYNC" },
    {  "value":          0, "name": "MQCTLO_NONE" },
    {  "value":          0, "name": "MQDCC_NONE" },
    {  "value":          0, "name": "MQDCC_SOURCE_ENC_UNDEFINED" },
    {  "value":          0, "name": "MQDCC_TARGET_ENC_UNDEFINED" },
    {  "value":          0, "name": "MQDELO_NONE" },
    {  "value":          0, "name": "MQDHF_NONE" },
    {  "value":          0, "name": "MQDISCONNECT_NORMAL" },
    {  "value":          0, "name": "MQDLV_AS_PARENT" },
    {  "value":          0, "name": "MQDL_NOT_SUPPORTED" },
    {  "value":          0, "name": "MQDMHO_NONE" },
    {  "value":          0, "name": "MQDMPO_DEL_FIRST" },
    {  "value":          0, "name": "MQDMPO_NONE" },
    {  "value":          0, "name": "MQDNSWLM_NO" },
    {  "value":          0, "name": "MQDOPT_RESOLVED" },
    {  "value":          0, "name": "MQDSB_DEFAULT" },
    {  "value":          0, "name": "MQDSE_DEFAULT" },
    {  "value":          0, "name": "MQENC_DECIMAL_UNDEFINED" },
    {  "value":          0, "name": "MQENC_FLOAT_UNDEFINED" },
    {  "value":          0, "name": "MQENC_INTEGER_UNDEFINED" },
    {  "value":          0, "name": "MQEPH_NONE" },
    {  "value":          0, "name": "MQEVO_OTHER" },
    {  "value":          0, "name": "MQEVR_DISABLED" },
    {  "value":          0, "name": "MQEXPI_OFF" },
    {  "value":          0, "name": "MQEXTATTRS_ALL" },
    {  "value":          0, "name": "MQEXT_ALL" },
    {  "value":          0, "name": "MQFB_NONE" },
    {  "value":          0, "name": "MQFC_NO" },
    {  "value":          0, "name": "MQFSENC_NO" },
    {  "value":          0, "name": "MQFUN_TYPE_UNKNOWN" },
    {  "value":          0, "name": "MQGMO_NONE" },
    {  "value":          0, "name": "MQGMO_NO_WAIT" },
    {  "value":          0, "name": "MQGMO_PROPERTIES_AS_Q_DEF" },
    {  "value":          0, "name": "MQGUR_DISABLED" },
    {  "value":          0, "name": "MQHC_DEF_HCONN" },
    {  "value":          0, "name": "MQHM_NONE" },
    {  "value":          0, "name": "MQHO_NONE" },
    {  "value":          0, "name": "MQHSTATE_INACTIVE" },
    {  "value":          0, "name": "MQIAMO_MONITOR_FLAGS_NONE" },
    {  "value":          0, "name": "MQIEPF_CLIENT_LIBRARY" },
    {  "value":          0, "name": "MQIEPF_NONE" },
    {  "value":          0, "name": "MQIEPF_NON_THREADED_LIBRARY" },
    {  "value":          0, "name": "MQIGQ_DISABLED" },
    {  "value":          0, "name": "MQIIH_NONE" },
    {  "value":          0, "name": "MQIIH_UNLIMITED_EXPIRATION" },
    {  "value":          0, "name": "MQIMGRCOV_NO" },
    {  "value":          0, "name": "MQIMMREASON_NONE" },
    {  "value":          0, "name": "MQIMPO_INQ_FIRST" },
    {  "value":          0, "name": "MQIMPO_NONE" },
    {  "value":          0, "name": "MQINBD_Q_MGR" },
    {  "value":          0, "name": "MQIPADDR_IPV4" },
    {  "value":          0, "name": "MQIS_NO" },
    {  "value":          0, "name": "MQIT_NONE" },
    {  "value":          0, "name": "MQKEY_REUSE_DISABLED" },
    {  "value":          0, "name": "MQLDAPC_INACTIVE" },
    {  "value":          0, "name": "MQLDAP_AUTHORMD_OS" },
    {  "value":          0, "name": "MQLDAP_NESTGRP_NO" },
    {  "value":          0, "name": "MQLOGTYPE_CIRCULAR" },
    {  "value":          0, "name": "MQMASTER_NO" },
    {  "value":          0, "name": "MQMATCH_GENERIC" },
    {  "value":          0, "name": "MQMCAS_STOPPED" },
    {  "value":          0, "name": "MQMCB_DISABLED" },
    {  "value":          0, "name": "MQMCP_NONE" },
    {  "value":          0, "name": "MQMC_AS_PARENT" },
    {  "value":          0, "name": "MQMDEF_NONE" },
    {  "value":          0, "name": "MQMDS_PRIORITY" },
    {  "value":          0, "name": "MQMEDIMGINTVL_OFF" },
    {  "value":          0, "name": "MQMEDIMGLOGLN_OFF" },
    {  "value":          0, "name": "MQMEDIMGSCHED_MANUAL" },
    {  "value":          0, "name": "MQMF_NONE" },
    {  "value":          0, "name": "MQMF_SEGMENTATION_INHIBITED" },
    {  "value":          0, "name": "MQMHBO_NONE" },
    {  "value":          0, "name": "MQMLP_ENCRYPTION_ALG_NONE" },
    {  "value":          0, "name": "MQMLP_SIGN_ALG_NONE" },
    {  "value":          0, "name": "MQMLP_TOLERATE_UNPROTECTED_NO" },
    {  "value":          0, "name": "MQMODE_FORCE" },
    {  "value":          0, "name": "MQMON_DISABLED" },
    {  "value":          0, "name": "MQMON_OFF" },
    {  "value":          0, "name": "MQMO_NONE" },
    {  "value":          0, "name": "MQMULC_STANDARD" },
    {  "value":          0, "name": "MQNHACONNACTV_NO" },
    {  "value":          0, "name": "MQNHACONNGRP_NO" },
    {  "value":          0, "name": "MQNHAGRPROLE_UNKNOWN" },
    {  "value":          0, "name": "MQNHAINSYNC_NO" },
    {  "value":          0, "name": "MQNHAROLE_UNKNOWN" },
    {  "value":          0, "name": "MQNHASTATUS_UNKNOWN" },
    {  "value":          0, "name": "MQNHATYPE_INSTANCE" },
    {  "value":          0, "name": "MQNPM_CLASS_NORMAL" },
    {  "value":          0, "name": "MQNSH_NONE" },
    {  "value":          0, "name": "MQNT_NONE" },
    {  "value":          0, "name": "MQOM_NO" },
    {  "value":          0, "name": "MQOO_BIND_AS_Q_DEF" },
    {  "value":          0, "name": "MQOO_READ_AHEAD_AS_Q_DEF" },
    {  "value":          0, "name": "MQOPER_SYSTEM_FIRST" },
    {  "value":          0, "name": "MQOPER_UNKNOWN" },
    {  "value":          0, "name": "MQOPMODE_COMPAT" },
    {  "value":          0, "name": "MQOTEL_PCTL_QMGR" },
    {  "value":          0, "name": "MQOTEL_TRACE_QMGR" },
    {  "value":          0, "name": "MQOT_NONE" },
    {  "value":          0, "name": "MQPAGECLAS_4KB" },
    {  "value":          0, "name": "MQPD_NONE" },
    {  "value":          0, "name": "MQPD_NO_CONTEXT" },
    {  "value":          0, "name": "MQPER_NOT_PERSISTENT" },
    {  "value":          0, "name": "MQPMO_NONE" },
    {  "value":          0, "name": "MQPMO_RESPONSE_AS_Q_DEF" },
    {  "value":          0, "name": "MQPMO_RESPONSE_AS_TOPIC_DEF" },
    {  "value":          0, "name": "MQPMRF_NONE" },
    {  "value":          0, "name": "MQPO_NO" },
    {  "value":          0, "name": "MQPROP_COMPATIBILITY" },
    {  "value":          0, "name": "MQPRT_RESPONSE_AS_PARENT" },
    {  "value":          0, "name": "MQPSCLUS_DISABLED" },
    {  "value":          0, "name": "MQPSM_DISABLED" },
    {  "value":          0, "name": "MQPSPROP_NONE" },
    {  "value":          0, "name": "MQPSST_ALL" },
    {  "value":          0, "name": "MQPS_STATUS_INACTIVE" },
    {  "value":          0, "name": "MQPUBO_NONE" },
    {  "value":          0, "name": "MQQA_BACKOUT_NOT_HARDENED" },
    {  "value":          0, "name": "MQQA_GET_ALLOWED" },
    {  "value":          0, "name": "MQQA_NOT_SHAREABLE" },
    {  "value":          0, "name": "MQQA_PUT_ALLOWED" },
    {  "value":          0, "name": "MQQMOPT_DISABLED" },
    {  "value":          0, "name": "MQQMT_NORMAL" },
    {  "value":          0, "name": "MQQO_NO" },
    {  "value":          0, "name": "MQQSGD_Q_MGR" },
    {  "value":          0, "name": "MQQSGS_UNKNOWN" },
    {  "value":          0, "name": "MQQSIE_NONE" },
    {  "value":          0, "name": "MQQSO_NO" },
    {  "value":          0, "name": "MQQSUM_NO" },
    {  "value":          0, "name": "MQRAR_NO" },
    {  "value":          0, "name": "MQRCN_NO" },
    {  "value":          0, "name": "MQRCVTIME_MULTIPLY" },
    {  "value":          0, "name": "MQRC_NONE" },
    {  "value":          0, "name": "MQRDNS_ENABLED" },
    {  "value":          0, "name": "MQRD_NO_DELAY" },
    {  "value":          0, "name": "MQREADA_NO" },
    {  "value":          0, "name": "MQRECAUTO_NO" },
    {  "value":          0, "name": "MQRECORDING_DISABLED" },
    {  "value":          0, "name": "MQREGO_NONE" },
    {  "value":          0, "name": "MQREORG_DISABLED" },
    {  "value":          0, "name": "MQRFH_NONE" },
    {  "value":          0, "name": "MQRFH_NO_FLAGS" },
    {  "value":          0, "name": "MQRMHF_NOT_LAST" },
    {  "value":          0, "name": "MQROUTE_UNLIMITED_ACTIVITIES" },
    {  "value":          0, "name": "MQRO_COPY_MSG_ID_TO_CORREL_ID" },
    {  "value":          0, "name": "MQRO_DEAD_LETTER_Q" },
    {  "value":          0, "name": "MQRO_NEW_MSG_ID" },
    {  "value":          0, "name": "MQRO_NONE" },
    {  "value":          0, "name": "MQRP_NO" },
    {  "value":          0, "name": "MQSCA_REQUIRED" },
    {  "value":          0, "name": "MQSCOPE_ALL" },
    {  "value":          0, "name": "MQSCO_RESET_COUNT_DEFAULT" },
    {  "value":          0, "name": "MQSCYC_UPPER" },
    {  "value":          0, "name": "MQSECCOMM_NO" },
    {  "value":          0, "name": "MQSECITEM_ALL" },
    {  "value":          0, "name": "MQSECPROT_NONE" },
    {  "value":          0, "name": "MQSELTYPE_NONE" },
    {  "value":          0, "name": "MQSMPO_NONE" },
    {  "value":          0, "name": "MQSMPO_SET_FIRST" },
    {  "value":          0, "name": "MQSO_NONE" },
    {  "value":          0, "name": "MQSO_NON_DURABLE" },
    {  "value":          0, "name": "MQSO_READ_AHEAD_AS_Q_DEF" },
    {  "value":          0, "name": "MQSPL_PASSTHRU" },
    {  "value":          0, "name": "MQSP_NOT_AVAILABLE" },
    {  "value":          0, "name": "MQSQQM_USE" },
    {  "value":          0, "name": "MQSRO_NONE" },
    {  "value":          0, "name": "MQSSL_FIPS_NO" },
    {  "value":          0, "name": "MQSTAT_TYPE_ASYNC_ERROR" },
    {  "value":          0, "name": "MQSTDBY_NOT_PERMITTED" },
    {  "value":          0, "name": "MQST_BEST_EFFORT" },
    {  "value":          0, "name": "MQSUB_DURABLE_AS_PARENT" },
    {  "value":          0, "name": "MQSUS_NO" },
    {  "value":          0, "name": "MQSVC_CONTROL_Q_MGR" },
    {  "value":          0, "name": "MQSVC_STATUS_STOPPED" },
    {  "value":          0, "name": "MQSVC_TYPE_COMMAND" },
    {  "value":          0, "name": "MQSYNCPOINT_YES" },
    {  "value":          0, "name": "MQSYSOBJ_YES" },
    {  "value":          0, "name": "MQSYSP_NO" },
    {  "value":          0, "name": "MQS_AVAIL_NORMAL" },
    {  "value":          0, "name": "MQS_EXPANDST_NORMAL" },
    {  "value":          0, "name": "MQS_OPENMODE_NONE" },
    {  "value":          0, "name": "MQS_STATUS_CLOSED" },
    {  "value":          0, "name": "MQTA_PUB_AS_PARENT" },
    {  "value":          0, "name": "MQTA_SUB_AS_PARENT" },
    {  "value":          0, "name": "MQTCPKEEP_NO" },
    {  "value":          0, "name": "MQTCPSTACK_SINGLE" },
    {  "value":          0, "name": "MQTC_OFF" },
    {  "value":          0, "name": "MQTIME_UNIT_MINS" },
    {  "value":          0, "name": "MQTOPT_LOCAL" },
    {  "value":          0, "name": "MQTRAXSTR_NO" },
    {  "value":          0, "name": "MQTRIGGER_RESTART_NO" },
    {  "value":          0, "name": "MQTT_NONE" },
    {  "value":          0, "name": "MQTYPE_AS_SET" },
    {  "value":          0, "name": "MQUCI_NO" },
    {  "value":          0, "name": "MQUIDSUPP_NO" },
    {  "value":          0, "name": "MQUNDELIVERED_NORMAL" },
    {  "value":          0, "name": "MQUOWST_NONE" },
    {  "value":          0, "name": "MQUOWT_Q_MGR" },
    {  "value":          0, "name": "MQUSAGE_PS_AVAILABLE" },
    {  "value":          0, "name": "MQUSAGE_SMDS_AVAILABLE" },
    {  "value":          0, "name": "MQUSEDLQ_AS_PARENT" },
    {  "value":          0, "name": "MQUSRC_MAP" },
    {  "value":          0, "name": "MQUS_NORMAL" },
    {  "value":          0, "name": "MQVL_EMPTY_STRING" },
    {  "value":          0, "name": "MQWARN_NO" },
    {  "value":          0, "name": "MQWIH_NONE" },
    {  "value":          0, "name": "MQWS_DEFAULT" },
    {  "value":          0, "name": "MQXCC_OK" },
    {  "value":          0, "name": "MQXDR_OK" },
    {  "value":          0, "name": "MQXEPO_NONE" },
    {  "value":          0, "name": "MQXE_OTHER" },
    {  "value":          0, "name": "MQXPT_LOCAL" },
    {  "value":          0, "name": "MQXR2_DEFAULT_CONTINUATION" },
    {  "value":          0, "name": "MQXR2_PUT_WITH_DEF_ACTION" },
    {  "value":          0, "name": "MQXR2_STATIC_CACHE" },
    {  "value":          0, "name": "MQXR2_USE_AGENT_BUFFER" },
    {  "value":          0, "name": "MQZAET_NONE" },
    {  "value":          0, "name": "MQZAO_NONE" },
    {  "value":          0, "name": "MQZAT_INITIAL_CONTEXT" },
    {  "value":          0, "name": "MQZCI_CONTINUE" },
    {  "value":          0, "name": "MQZCI_DEFAULT" },
    {  "value":          0, "name": "MQZID_INIT" },
    {  "value":          0, "name": "MQZID_INIT_AUTHORITY" },
    {  "value":          0, "name": "MQZID_INIT_NAME" },
    {  "value":          0, "name": "MQZID_INIT_USERID" },
    {  "value":          0, "name": "MQZIO_PRIMARY" },
    {  "value":          0, "name": "MQZSE_CONTINUE" },
    {  "value":          0, "name": "MQZSL_NOT_RETURNED" },
    {  "value":          0, "name": "MQZTO_PRIMARY" },
    {  "value":          0, "name": "MQ_CERT_VAL_POLICY_ANY" },
    {  "value":          0, "name": "MQ_CERT_VAL_POLICY_DEFAULT" },
    {  "value":          0, "name": "MQ_HTTPSCERTREV_DEFAULT" },
    {  "value":          0, "name": "MQ_HTTPSCERTVAL_DEFAULT" },
    {  "value":          0, "name": "MQ_SUITE_B_NOT_AVAILABLE" },
    {  "value":          1, "name": "MQACH_CURRENT_VERSION" },
    {  "value":          1, "name": "MQACH_VERSION_1" },
    {  "value":          1, "name": "MQACTIVE_YES" },
    {  "value":          1, "name": "MQACTP_FORWARD" },
    {  "value":          1, "name": "MQACTV_DETAIL_LOW" },
    {  "value":          1, "name": "MQACT_FORCE_REMOVE" },
    {  "value":          1, "name": "MQADOPT_CHECK_ALL" },
    {  "value":          1, "name": "MQADOPT_TYPE_ALL" },
    {  "value":          1, "name": "MQADPCTX_YES" },
    {  "value":          1, "name": "MQAIR_VERSION_1" },
    {  "value":          1, "name": "MQAIT_CRL_LDAP" },
    {  "value":          1, "name": "MQAPPL_MOVABLE" },
    {  "value":          1, "name": "MQAS_STARTED" },
    {  "value":          1, "name": "MQAT_CICS" },
    {  "value":          1, "name": "MQAUSC_ALLCONNS" },
    {  "value":          1, "name": "MQAUTHENTICATE_PAM" },
    {  "value":          1, "name": "MQAUTHOPT_ENTITY_EXPLICIT" },
    {  "value":          1, "name": "MQAUTH_ALT_USER_AUTHORITY" },
    {  "value":          1, "name": "MQAUTOCLUS_TYPE_UNIFORM" },
    {  "value":          1, "name": "MQAUTO_START_YES" },
    {  "value":          1, "name": "MQAXC_VERSION_1" },
    {  "value":          1, "name": "MQAXP_VERSION_1" },
    {  "value":          1, "name": "MQBALANCED_YES" },
    {  "value":          1, "name": "MQBALSTATE_LOW" },
    {  "value":          1, "name": "MQBMHO_CURRENT_VERSION" },
    {  "value":          1, "name": "MQBMHO_DELETE_PROPERTIES" },
    {  "value":          1, "name": "MQBMHO_VERSION_1" },
    {  "value":          1, "name": "MQBND_BIND_NOT_FIXED" },
    {  "value":          1, "name": "MQBNO_BALTYPE_REQREP" },
    {  "value":          1, "name": "MQBNO_CURRENT_VERSION" },
    {  "value":          1, "name": "MQBNO_OPTIONS_IGNORE_TRANS" },
    {  "value":          1, "name": "MQBNO_VERSION_1" },
    {  "value":          1, "name": "MQBO_CURRENT_VERSION" },
    {  "value":          1, "name": "MQBO_VERSION_1" },
    {  "value":          1, "name": "MQBPLOCATION_ABOVE" },
    {  "value":          1, "name": "MQBT_OTMA" },
    {  "value":          1, "name": "MQCADSD_SEND" },
    {  "value":          1, "name": "MQCAFTY_PREFERRED" },
    {  "value":          1, "name": "MQCAP_SUPPORTED" },
    {  "value":          1, "name": "MQCAUT_BLOCKUSER" },
    {  "value":          1, "name": "MQCBCF_READA_BUFFER_EMPTY" },
    {  "value":          1, "name": "MQCBCT_START_CALL" },
    {  "value":          1, "name": "MQCBC_VERSION_1" },
    {  "value":          1, "name": "MQCBDO_START_CALL" },
    {  "value":          1, "name": "MQCBD_CURRENT_VERSION" },
    {  "value":          1, "name": "MQCBD_VERSION_1" },
    {  "value":          1, "name": "MQCBO_ADMIN_BAG" },
    {  "value":          1, "name": "MQCBT_MESSAGE_CONSUMER" },
    {  "value":          1, "name": "MQCCT_YES" },
    {  "value":          1, "name": "MQCC_WARNING" },
    {  "value":          1, "name": "MQCDC_SENDER_CONVERSION" },
    {  "value":          1, "name": "MQCDC_VERSION_1" },
    {  "value":          1, "name": "MQCD_VERSION_1" },
    {  "value":          1, "name": "MQCFACCESS_SUSPENDED" },
    {  "value":          1, "name": "MQCFCONLOS_TOLERATE" },
    {  "value":          1, "name": "MQCFC_LAST" },
    {  "value":          1, "name": "MQCFH_VERSION_1" },
    {  "value":          1, "name": "MQCFOFFLD_SMDS" },
    {  "value":          1, "name": "MQCFOP_LESS" },
    {  "value":          1, "name": "MQCFO_REFRESH_REPOSITORY_YES" },
    {  "value":          1, "name": "MQCFO_REMOVE_QUEUES_YES" },
    {  "value":          1, "name": "MQCFR_YES" },
    {  "value":          1, "name": "MQCFSTATUS_ACTIVE" },
    {  "value":          1, "name": "MQCFTYPE_ADMIN" },
    {  "value":          1, "name": "MQCFT_COMMAND" },
    {  "value":          1, "name": "MQCF_DIST_LISTS" },
    {  "value":          1, "name": "MQCHAD_ENABLED" },
    {  "value":          1, "name": "MQCHIDS_INDOUBT" },
    {  "value":          1, "name": "MQCHK_NONE" },
    {  "value":          1, "name": "MQCHLA_ENABLED" },
    {  "value":          1, "name": "MQCHLD_DEFAULT" },
    {  "value":          1, "name": "MQCHSH_RESTART_YES" },
    {  "value":          1, "name": "MQCHSR_STOP_REQUESTED" },
    {  "value":          1, "name": "MQCHS_BINDING" },
    {  "value":          1, "name": "MQCHTAB_Q_MGR" },
    {  "value":          1, "name": "MQCHT_SENDER" },
    {  "value":          1, "name": "MQCIH_PASS_EXPIRATION" },
    {  "value":          1, "name": "MQCIH_VERSION_1" },
    {  "value":          1, "name": "MQCIT_MULTICAST" },
    {  "value":          1, "name": "MQCLCT_DYNAMIC" },
    {  "value":          1, "name": "MQCLROUTE_TOPIC_HOST" },
    {  "value":          1, "name": "MQCLRS_LOCAL" },
    {  "value":          1, "name": "MQCLRT_RETAINED" },
    {  "value":          1, "name": "MQCLST_PENDING" },
    {  "value":          1, "name": "MQCLT_PROGRAM" },
    {  "value":          1, "name": "MQCLWL_USEQ_ANY" },
    {  "value":          1, "name": "MQCLXQ_CHANNEL" },
    {  "value":          1, "name": "MQCMDI_CMDSCOPE_ACCEPTED" },
    {  "value":          1, "name": "MQCMD_CHANGE_Q_MGR" },
    {  "value":          1, "name": "MQCMHO_CURRENT_VERSION" },
    {  "value":          1, "name": "MQCMHO_NO_VALIDATION" },
    {  "value":          1, "name": "MQCMHO_VERSION_1" },
    {  "value":          1, "name": "MQCNO_FASTPATH_BINDING" },
    {  "value":          1, "name": "MQCNO_VERSION_1" },
    {  "value":          1, "name": "MQCOMPRESS_RLE" },
    {  "value":          1, "name": "MQCOPY_ALL" },
    {  "value":          1, "name": "MQCO_DELETE" },
    {  "value":          1, "name": "MQCQT_LOCAL_Q" },
    {  "value":          1, "name": "MQCRC_CICS_EXEC_ERROR" },
    {  "value":          1, "name": "MQCSP_AUTH_USER_ID_AND_PWD" },
    {  "value":          1, "name": "MQCSP_VERSION_1" },
    {  "value":          1, "name": "MQCSRV_CONVERT_YES" },
    {  "value":          1, "name": "MQCSRV_DLQ_YES" },
    {  "value":          1, "name": "MQCS_SUSPENDED_TEMPORARY" },
    {  "value":          1, "name": "MQCTLO_CURRENT_VERSION" },
    {  "value":          1, "name": "MQCTLO_THREAD_AFFINITY" },
    {  "value":          1, "name": "MQCTLO_VERSION_1" },
    {  "value":          1, "name": "MQCXP_VERSION_1" },
    {  "value":          1, "name": "MQDCC_DEFAULT_CONVERSION" },
    {  "value":          1, "name": "MQDC_MANAGED" },
    {  "value":          1, "name": "MQDHF_NEW_MSG_IDS" },
    {  "value":          1, "name": "MQDH_CURRENT_VERSION" },
    {  "value":          1, "name": "MQDH_VERSION_1" },
    {  "value":          1, "name": "MQDISCONNECT_IMPLICIT" },
    {  "value":          1, "name": "MQDLH_CURRENT_VERSION" },
    {  "value":          1, "name": "MQDLH_VERSION_1" },
    {  "value":          1, "name": "MQDLV_ALL" },
    {  "value":          1, "name": "MQDL_SUPPORTED" },
    {  "value":          1, "name": "MQDMHO_CURRENT_VERSION" },
    {  "value":          1, "name": "MQDMHO_VERSION_1" },
    {  "value":          1, "name": "MQDMPO_CURRENT_VERSION" },
    {  "value":          1, "name": "MQDMPO_DEL_PROP_UNDER_CURSOR" },
    {  "value":          1, "name": "MQDMPO_VERSION_1" },
    {  "value":          1, "name": "MQDNSWLM_YES" },
    {  "value":          1, "name": "MQDOPT_DEFINED" },
    {  "value":          1, "name": "MQDSB_8K" },
    {  "value":          1, "name": "MQDSE_YES" },
    {  "value":          1, "name": "MQDXP_VERSION_1" },
    {  "value":          1, "name": "MQENC_INTEGER_NORMAL" },
    {  "value":          1, "name": "MQEPH_CCSID_EMBEDDED" },
    {  "value":          1, "name": "MQEPH_CURRENT_VERSION" },
    {  "value":          1, "name": "MQEPH_VERSION_1" },
    {  "value":          1, "name": "MQET_MQSC" },
    {  "value":          1, "name": "MQEVO_CONSOLE" },
    {  "value":          1, "name": "MQEVR_ENABLED" },
    {  "value":          1, "name": "MQEXTATTRS_NONDEF" },
    {  "value":          1, "name": "MQEXT_OBJECT" },
    {  "value":          1, "name": "MQFB_SYSTEM_FIRST" },
    {  "value":          1, "name": "MQFC_YES" },
    {  "value":          1, "name": "MQFSENC_YES" },
    {  "value":          1, "name": "MQFUN_TYPE_JVM" },
    {  "value":          1, "name": "MQGMO_VERSION_1" },
    {  "value":          1, "name": "MQGMO_WAIT" },
    {  "value":          1, "name": "MQGUR_ENABLED" },
    {  "value":          1, "name": "MQHSTATE_ACTIVE" },
    {  "value":          1, "name": "MQIAMO_MONITOR_FLAGS_OBJNAME" },
    {  "value":          1, "name": "MQIAMO_MONITOR_UNIT" },
    {  "value":          1, "name": "MQIA_APPL_TYPE" },
    {  "value":          1, "name": "MQIA_FIRST" },
    {  "value":          1, "name": "MQIDO_COMMIT" },
    {  "value":          1, "name": "MQIEPF_THREADED_LIBRARY" },
    {  "value":          1, "name": "MQIEP_CURRENT_VERSION" },
    {  "value":          1, "name": "MQIEP_VERSION_1" },
    {  "value":          1, "name": "MQIGQPA_DEFAULT" },
    {  "value":          1, "name": "MQIGQ_ENABLED" },
    {  "value":          1, "name": "MQIIH_CURRENT_VERSION" },
    {  "value":          1, "name": "MQIIH_PASS_EXPIRATION" },
    {  "value":          1, "name": "MQIIH_VERSION_1" },
    {  "value":          1, "name": "MQIMGRCOV_YES" },
    {  "value":          1, "name": "MQIMMREASON_NOT_CLIENT" },
    {  "value":          1, "name": "MQIMPO_CURRENT_VERSION" },
    {  "value":          1, "name": "MQIMPO_VERSION_1" },
    {  "value":          1, "name": "MQIPADDR_IPV6" },
    {  "value":          1, "name": "MQIS_YES" },
    {  "value":          1, "name": "MQITEM_INTEGER" },
    {  "value":          1, "name": "MQIT_INTEGER" },
    {  "value":          1, "name": "MQIT_MSG_ID" },
    {  "value":          1, "name": "MQLDAPC_CONNECTED" },
    {  "value":          1, "name": "MQLDAP_AUTHORMD_SEARCHGRP" },
    {  "value":          1, "name": "MQLDAP_NESTGRP_YES" },
    {  "value":          1, "name": "MQLOGTYPE_LINEAR" },
    {  "value":          1, "name": "MQLR_ONE" },
    {  "value":          1, "name": "MQMASTER_YES" },
    {  "value":          1, "name": "MQMATCH_RUNCHECK" },
    {  "value":          1, "name": "MQMCAT_PROCESS" },
    {  "value":          1, "name": "MQMCB_ENABLED" },
    {  "value":          1, "name": "MQMCEV_PACKET_LOSS" },
    {  "value":          1, "name": "MQMCP_USER" },
    {  "value":          1, "name": "MQMC_ENABLED" },
    {  "value":          1, "name": "MQMDS_FIFO" },
    {  "value":          1, "name": "MQMD_VERSION_1" },
    {  "value":          1, "name": "MQMEDIMGSCHED_AUTO" },
    {  "value":          1, "name": "MQMF_SEGMENTATION_ALLOWED" },
    {  "value":          1, "name": "MQMHBO_CURRENT_VERSION" },
    {  "value":          1, "name": "MQMHBO_PROPERTIES_IN_MQRFH2" },
    {  "value":          1, "name": "MQMHBO_VERSION_1" },
    {  "value":          1, "name": "MQMLP_ENCRYPTION_ALG_RC2" },
    {  "value":          1, "name": "MQMLP_SIGN_ALG_MD5" },
    {  "value":          1, "name": "MQMLP_TOLERATE_UNPROTECTED_YES" },
    {  "value":          1, "name": "MQMODE_QUIESCE" },
    {  "value":          1, "name": "MQMON_ENABLED" },
    {  "value":          1, "name": "MQMON_ON" },
    {  "value":          1, "name": "MQMO_MATCH_MSG_ID" },
    {  "value":          1, "name": "MQMT_REQUEST" },
    {  "value":          1, "name": "MQMT_SYSTEM_FIRST" },
    {  "value":          1, "name": "MQMULC_REFINED" },
    {  "value":          1, "name": "MQNHACONNACTV_YES" },
    {  "value":          1, "name": "MQNHACONNGRP_YES" },
    {  "value":          1, "name": "MQNHAGRPROLE_NOT_CONFIGURED" },
    {  "value":          1, "name": "MQNHAINSYNC_YES" },
    {  "value":          1, "name": "MQNHAROLE_ACTIVE" },
    {  "value":          1, "name": "MQNHASTATUS_NORMAL" },
    {  "value":          1, "name": "MQNHATYPE_GROUP" },
    {  "value":          1, "name": "MQNPMS_NORMAL" },
    {  "value":          1, "name": "MQNT_Q" },
    {  "value":          1, "name": "MQNXP_VERSION_1" },
    {  "value":          1, "name": "MQOA_FIRST" },
    {  "value":          1, "name": "MQOD_VERSION_1" },
    {  "value":          1, "name": "MQOM_YES" },
    {  "value":          1, "name": "MQOO_INPUT_AS_Q_DEF" },
    {  "value":          1, "name": "MQOPER_BROWSE" },
    {  "value":          1, "name": "MQOPMODE_NEW_FUNCTION" },
    {  "value":          1, "name": "MQOP_START" },
    {  "value":          1, "name": "MQOTEL_PCTL_MANUAL" },
    {  "value":          1, "name": "MQOTEL_TRACE_OFF" },
    {  "value":          1, "name": "MQOT_Q" },
    {  "value":          1, "name": "MQPAGECLAS_FIXED4KB" },
    {  "value":          1, "name": "MQPA_DEFAULT" },
    {  "value":          1, "name": "MQPBC_VERSION_1" },
    {  "value":          1, "name": "MQPD_CURRENT_VERSION" },
    {  "value":          1, "name": "MQPD_SUPPORT_OPTIONAL" },
    {  "value":          1, "name": "MQPD_USER_CONTEXT" },
    {  "value":          1, "name": "MQPD_VERSION_1" },
    {  "value":          1, "name": "MQPER_PERSISTENT" },
    {  "value":          1, "name": "MQPL_MVS" },
    {  "value":          1, "name": "MQPL_OS390" },
    {  "value":          1, "name": "MQPL_ZOS" },
    {  "value":          1, "name": "MQPMO_VERSION_1" },
    {  "value":          1, "name": "MQPMRF_MSG_ID" },
    {  "value":          1, "name": "MQPO_YES" },
    {  "value":          1, "name": "MQPROP_NONE" },
    {  "value":          1, "name": "MQPROTO_MQTTV3" },
    {  "value":          1, "name": "MQPRT_SYNC_RESPONSE" },
    {  "value":          1, "name": "MQPSCLUS_ENABLED" },
    {  "value":          1, "name": "MQPSM_COMPAT" },
    {  "value":          1, "name": "MQPSPROP_COMPAT" },
    {  "value":          1, "name": "MQPSST_LOCAL" },
    {  "value":          1, "name": "MQPSXP_VERSION_1" },
    {  "value":          1, "name": "MQPS_STATUS_STARTING" },
    {  "value":          1, "name": "MQPUBO_CORREL_ID_AS_IDENTITY" },
    {  "value":          1, "name": "MQQA_BACKOUT_HARDENED" },
    {  "value":          1, "name": "MQQA_GET_INHIBITED" },
    {  "value":          1, "name": "MQQA_PUT_INHIBITED" },
    {  "value":          1, "name": "MQQA_SHAREABLE" },
    {  "value":          1, "name": "MQQDT_PREDEFINED" },
    {  "value":          1, "name": "MQQF_LOCAL_Q" },
    {  "value":          1, "name": "MQQMDT_EXPLICIT_CLUSTER_SENDER" },
    {  "value":          1, "name": "MQQMFAC_IMS_BRIDGE" },
    {  "value":          1, "name": "MQQMOPT_ENABLED" },
    {  "value":          1, "name": "MQQMSTA_STARTING" },
    {  "value":          1, "name": "MQQMT_REPOSITORY" },
    {  "value":          1, "name": "MQQO_YES" },
    {  "value":          1, "name": "MQQSGD_COPY" },
    {  "value":          1, "name": "MQQSGS_CREATED" },
    {  "value":          1, "name": "MQQSIE_HIGH" },
    {  "value":          1, "name": "MQQSOT_ALL" },
    {  "value":          1, "name": "MQQSO_SHARED" },
    {  "value":          1, "name": "MQQSO_YES" },
    {  "value":          1, "name": "MQQSUM_YES" },
    {  "value":          1, "name": "MQQT_LOCAL" },
    {  "value":          1, "name": "MQRAR_YES" },
    {  "value":          1, "name": "MQRCN_YES" },
    {  "value":          1, "name": "MQRCVTIME_ADD" },
    {  "value":          1, "name": "MQRDNS_DISABLED" },
    {  "value":          1, "name": "MQREADA_YES" },
    {  "value":          1, "name": "MQRECAUTO_YES" },
    {  "value":          1, "name": "MQRECORDING_Q" },
    {  "value":          1, "name": "MQREGO_CORREL_ID_AS_IDENTITY" },
    {  "value":          1, "name": "MQREORG_ENABLED" },
    {  "value":          1, "name": "MQRFH_VERSION_1" },
    {  "value":          1, "name": "MQRMHF_LAST" },
    {  "value":          1, "name": "MQRMH_CURRENT_VERSION" },
    {  "value":          1, "name": "MQRMH_VERSION_1" },
    {  "value":          1, "name": "MQRO_PAN" },
    {  "value":          1, "name": "MQRP_YES" },
    {  "value":          1, "name": "MQRQ_CONN_NOT_AUTHORIZED" },
    {  "value":          1, "name": "MQRT_CONFIGURATION" },
    {  "value":          1, "name": "MQRU_PUBLISH_ON_REQUEST" },
    {  "value":          1, "name": "MQSBC_CURRENT_VERSION" },
    {  "value":          1, "name": "MQSBC_VERSION_1" },
    {  "value":          1, "name": "MQSCA_OPTIONAL" },
    {  "value":          1, "name": "MQSCOPE_AS_PARENT" },
    {  "value":          1, "name": "MQSCO_Q_MGR" },
    {  "value":          1, "name": "MQSCO_VERSION_1" },
    {  "value":          1, "name": "MQSCYC_MIXED" },
    {  "value":          1, "name": "MQSD_CURRENT_VERSION" },
    {  "value":          1, "name": "MQSD_VERSION_1" },
    {  "value":          1, "name": "MQSECCOMM_YES" },
    {  "value":          1, "name": "MQSECITEM_MQADMIN" },
    {  "value":          1, "name": "MQSECPROT_SSLV30" },
    {  "value":          1, "name": "MQSECSW_PROCESS" },
    {  "value":          1, "name": "MQSECTYPE_AUTHSERV" },
    {  "value":          1, "name": "MQSELTYPE_STANDARD" },
    {  "value":          1, "name": "MQSMPO_CURRENT_VERSION" },
    {  "value":          1, "name": "MQSMPO_SET_PROP_UNDER_CURSOR" },
    {  "value":          1, "name": "MQSMPO_VERSION_1" },
    {  "value":          1, "name": "MQSO_ALTER" },
    {  "value":          1, "name": "MQSPL_REMOVE" },
    {  "value":          1, "name": "MQSP_AVAILABLE" },
    {  "value":          1, "name": "MQSQQM_IGNORE" },
    {  "value":          1, "name": "MQSRO_CURRENT_VERSION" },
    {  "value":          1, "name": "MQSRO_VERSION_1" },
    {  "value":          1, "name": "MQSR_ACTION_PUBLICATION" },
    {  "value":          1, "name": "MQSSL_FIPS_YES" },
    {  "value":          1, "name": "MQSTAT_TYPE_RECONNECTION" },
    {  "value":          1, "name": "MQSTDBY_PERMITTED" },
    {  "value":          1, "name": "MQSTS_VERSION_1" },
    {  "value":          1, "name": "MQST_MUST_DUP" },
    {  "value":          1, "name": "MQSUBTYPE_API" },
    {  "value":          1, "name": "MQSUB_DURABLE_ALLOWED" },
    {  "value":          1, "name": "MQSUB_DURABLE_YES" },
    {  "value":          1, "name": "MQSUS_YES" },
    {  "value":          1, "name": "MQSVC_CONTROL_Q_MGR_START" },
    {  "value":          1, "name": "MQSVC_STATUS_STARTING" },
    {  "value":          1, "name": "MQSVC_TYPE_SERVER" },
    {  "value":          1, "name": "MQSYNCPOINT_IFPER" },
    {  "value":          1, "name": "MQSYSOBJ_NO" },
    {  "value":          1, "name": "MQSYSP_YES" },
    {  "value":          1, "name": "MQS_AVAIL_ERROR" },
    {  "value":          1, "name": "MQS_EXPANDST_FAILED" },
    {  "value":          1, "name": "MQS_OPENMODE_READONLY" },
    {  "value":          1, "name": "MQS_STATUS_CLOSING" },
    {  "value":          1, "name": "MQTA_BLOCK" },
    {  "value":          1, "name": "MQTA_PROXY_SUB_FORCE" },
    {  "value":          1, "name": "MQTA_PUB_INHIBITED" },
    {  "value":          1, "name": "MQTA_SUB_INHIBITED" },
    {  "value":          1, "name": "MQTCPKEEP_YES" },
    {  "value":          1, "name": "MQTCPSTACK_MULTIPLE" },
    {  "value":          1, "name": "MQTC_ON" },
    {  "value":          1, "name": "MQTIME_UNIT_SECS" },
    {  "value":          1, "name": "MQTM_CURRENT_VERSION" },
    {  "value":          1, "name": "MQTM_VERSION_1" },
    {  "value":          1, "name": "MQTOPT_CLUSTER" },
    {  "value":          1, "name": "MQTRAXSTR_YES" },
    {  "value":          1, "name": "MQTRIGGER_RESTART_YES" },
    {  "value":          1, "name": "MQTSCOPE_QMGR" },
    {  "value":          1, "name": "MQTT_FIRST" },
    {  "value":          1, "name": "MQUCI_YES" },
    {  "value":          1, "name": "MQUIDSUPP_YES" },
    {  "value":          1, "name": "MQUNDELIVERED_SAFE" },
    {  "value":          1, "name": "MQUOWST_ACTIVE" },
    {  "value":          1, "name": "MQUOWT_CICS" },
    {  "value":          1, "name": "MQUSAGE_EXPAND_USER" },
    {  "value":          1, "name": "MQUSAGE_PS_DEFINED" },
    {  "value":          1, "name": "MQUSAGE_SMDS_NO_DATA" },
    {  "value":          1, "name": "MQUSEDLQ_NO" },
    {  "value":          1, "name": "MQUSRC_NOACCESS" },
    {  "value":          1, "name": "MQUS_TRANSMISSION" },
    {  "value":          1, "name": "MQVU_FIXED_USER" },
    {  "value":          1, "name": "MQWARN_YES" },
    {  "value":          1, "name": "MQWDR_VERSION_1" },
    {  "value":          1, "name": "MQWIH_CURRENT_VERSION" },
    {  "value":          1, "name": "MQWIH_VERSION_1" },
    {  "value":          1, "name": "MQWQR_VERSION_1" },
    {  "value":          1, "name": "MQWS_CHAR" },
    {  "value":          1, "name": "MQWXP_VERSION_1" },
    {  "value":          1, "name": "MQXACT_EXTERNAL" },
    {  "value":          1, "name": "MQXC_MQOPEN" },
    {  "value":          1, "name": "MQXDR_CONVERSION_FAILED" },
    {  "value":          1, "name": "MQXEPO_CURRENT_VERSION" },
    {  "value":          1, "name": "MQXEPO_VERSION_1" },
    {  "value":          1, "name": "MQXE_MCA" },
    {  "value":          1, "name": "MQXF_INIT" },
    {  "value":          1, "name": "MQXPT_LU62" },
    {  "value":          1, "name": "MQXP_VERSION_1" },
    {  "value":          1, "name": "MQXQH_CURRENT_VERSION" },
    {  "value":          1, "name": "MQXQH_VERSION_1" },
    {  "value":          1, "name": "MQXR2_PUT_WITH_DEF_USERID" },
    {  "value":          1, "name": "MQXR_BEFORE" },
    {  "value":          1, "name": "MQXT_API_CROSSING_EXIT" },
    {  "value":          1, "name": "MQXWD_VERSION_1" },
    {  "value":          1, "name": "MQZAC_CURRENT_VERSION" },
    {  "value":          1, "name": "MQZAC_VERSION_1" },
    {  "value":          1, "name": "MQZAD_VERSION_1" },
    {  "value":          1, "name": "MQZAET_PRINCIPAL" },
    {  "value":          1, "name": "MQZAO_CONNECT" },
    {  "value":          1, "name": "MQZAS_VERSION_1" },
    {  "value":          1, "name": "MQZAT_CHANGE_CONTEXT" },
    {  "value":          1, "name": "MQZCI_STOP" },
    {  "value":          1, "name": "MQZED_VERSION_1" },
    {  "value":          1, "name": "MQZFP_CURRENT_VERSION" },
    {  "value":          1, "name": "MQZFP_VERSION_1" },
    {  "value":          1, "name": "MQZIC_VERSION_1" },
    {  "value":          1, "name": "MQZID_TERM" },
    {  "value":          1, "name": "MQZID_TERM_AUTHORITY" },
    {  "value":          1, "name": "MQZID_TERM_NAME" },
    {  "value":          1, "name": "MQZID_TERM_USERID" },
    {  "value":          1, "name": "MQZIO_SECONDARY" },
    {  "value":          1, "name": "MQZNS_VERSION_1" },
    {  "value":          1, "name": "MQZSE_START" },
    {  "value":          1, "name": "MQZSL_RETURNED" },
    {  "value":          1, "name": "MQZTO_SECONDARY" },
    {  "value":          1, "name": "MQZUS_VERSION_1" },
    {  "value":          1, "name": "MQ_CERT_VAL_POLICY_RFC5280" },
    {  "value":          1, "name": "MQ_HTTPSCERTREV_REQUIRED" },
    {  "value":          1, "name": "MQ_HTTPSCERTVAL_ANY" },
    {  "value":          1, "name": "MQ_SUITE_B_NONE" },
    {  "value":          2, "name": "MQACTP_REPLY" },
    {  "value":          2, "name": "MQACTV_DETAIL_MEDIUM" },
    {  "value":          2, "name": "MQACT_ADVANCE_LOG" },
    {  "value":          2, "name": "MQADOPT_CHECK_Q_MGR_NAME" },
    {  "value":          2, "name": "MQADOPT_TYPE_SVR" },
    {  "value":          2, "name": "MQAIR_CURRENT_VERSION" },
    {  "value":          2, "name": "MQAIR_VERSION_2" },
    {  "value":          2, "name": "MQAIT_OCSP" },
    {  "value":          2, "name": "MQAS_START_WAIT" },
    {  "value":          2, "name": "MQAT_MVS" },
    {  "value":          2, "name": "MQAT_OS390" },
    {  "value":          2, "name": "MQAT_ZOS" },
    {  "value":          2, "name": "MQAUSC_ALLCHECKS" },
    {  "value":          2, "name": "MQAUTHOPT_ENTITY_SET" },
    {  "value":          2, "name": "MQAUTH_BROWSE" },
    {  "value":          2, "name": "MQAXC_CURRENT_VERSION" },
    {  "value":          2, "name": "MQAXC_VERSION_2" },
    {  "value":          2, "name": "MQAXP_CURRENT_VERSION" },
    {  "value":          2, "name": "MQAXP_VERSION_2" },
    {  "value":          2, "name": "MQBALANCED_NOT_APPLICABLE" },
    {  "value":          2, "name": "MQBALSTATE_OK" },
    {  "value":          2, "name": "MQBND_BIND_ON_GROUP" },
    {  "value":          2, "name": "MQBPLOCATION_SWITCHING_ABOVE" },
    {  "value":          2, "name": "MQCAP_EXPIRED" },
    {  "value":          2, "name": "MQCAUT_BLOCKADDR" },
    {  "value":          2, "name": "MQCBCT_STOP_CALL" },
    {  "value":          2, "name": "MQCBC_CURRENT_VERSION" },
    {  "value":          2, "name": "MQCBC_VERSION_2" },
    {  "value":          2, "name": "MQCBO_LIST_FORM_ALLOWED" },
    {  "value":          2, "name": "MQCBT_EVENT_HANDLER" },
    {  "value":          2, "name": "MQCC_FAILED" },
    {  "value":          2, "name": "MQCDC_VERSION_2" },
    {  "value":          2, "name": "MQCD_VERSION_2" },
    {  "value":          2, "name": "MQCFACCESS_DISABLED" },
    {  "value":          2, "name": "MQCFCONLOS_ASQMGR" },
    {  "value":          2, "name": "MQCFH_VERSION_2" },
    {  "value":          2, "name": "MQCFOFFLD_DB2" },
    {  "value":          2, "name": "MQCFOP_EQUAL" },
    {  "value":          2, "name": "MQCFSTATUS_IN_RECOVER" },
    {  "value":          2, "name": "MQCFT_RESPONSE" },
    {  "value":          2, "name": "MQCHK_REQUIRED_ADMIN" },
    {  "value":          2, "name": "MQCHLD_SHARED" },
    {  "value":          2, "name": "MQCHS_STARTING" },
    {  "value":          2, "name": "MQCHTAB_CLNTCONN" },
    {  "value":          2, "name": "MQCHT_SERVER" },
    {  "value":          2, "name": "MQCIH_CURRENT_VERSION" },
    {  "value":          2, "name": "MQCIH_REPLY_WITHOUT_NULLS" },
    {  "value":          2, "name": "MQCIH_VERSION_2" },
    {  "value":          2, "name": "MQCLROUTE_NONE" },
    {  "value":          2, "name": "MQCLRS_GLOBAL" },
    {  "value":          2, "name": "MQCLST_INVALID" },
    {  "value":          2, "name": "MQCLT_TRANSACTION" },
    {  "value":          2, "name": "MQCMDI_CMDSCOPE_GENERATED" },
    {  "value":          2, "name": "MQCMD_INQUIRE_Q_MGR" },
    {  "value":          2, "name": "MQCMHO_VALIDATE" },
    {  "value":          2, "name": "MQCNO_SERIALIZE_CONN_TAG_Q_MGR" },
    {  "value":          2, "name": "MQCNO_VERSION_2" },
    {  "value":          2, "name": "MQCOMPRESS_ZLIBFAST" },
    {  "value":          2, "name": "MQCOPY_FORWARD" },
    {  "value":          2, "name": "MQCO_DELETE_PURGE" },
    {  "value":          2, "name": "MQCQT_ALIAS_Q" },
    {  "value":          2, "name": "MQCRC_MQ_API_ERROR" },
    {  "value":          2, "name": "MQCSP_AUTH_ID_TOKEN" },
    {  "value":          2, "name": "MQCSP_VERSION_2" },
    {  "value":          2, "name": "MQCS_SUSPENDED_USER_ACTION" },
    {  "value":          2, "name": "MQCXP_VERSION_2" },
    {  "value":          2, "name": "MQDCC_FILL_TARGET_BUFFER" },
    {  "value":          2, "name": "MQDC_PROVIDED" },
    {  "value":          2, "name": "MQDISCONNECT_Q_MGR" },
    {  "value":          2, "name": "MQDLV_ALL_DUR" },
    {  "value":          2, "name": "MQDSB_16K" },
    {  "value":          2, "name": "MQDSE_NO" },
    {  "value":          2, "name": "MQDXP_CURRENT_VERSION" },
    {  "value":          2, "name": "MQDXP_VERSION_2" },
    {  "value":          2, "name": "MQEC_MSG_ARRIVED" },
    {  "value":          2, "name": "MQENC_INTEGER_REVERSED" },
    {  "value":          2, "name": "MQEVO_INIT" },
    {  "value":          2, "name": "MQEVR_EXCEPTION" },
    {  "value":          2, "name": "MQEXT_AUTHORITY" },
    {  "value":          2, "name": "MQFSENC_UNKNOWN" },
    {  "value":          2, "name": "MQFUN_TYPE_PROGRAM" },
    {  "value":          2, "name": "MQGMO_SYNCPOINT" },
    {  "value":          2, "name": "MQGMO_VERSION_2" },
    {  "value":          2, "name": "MQIAMO_MONITOR_DELTA" },
    {  "value":          2, "name": "MQIA_CODED_CHAR_SET_ID" },
    {  "value":          2, "name": "MQIDO_BACKOUT" },
    {  "value":          2, "name": "MQIEPF_LOCAL_LIBRARY" },
    {  "value":          2, "name": "MQIGQPA_CONTEXT" },
    {  "value":          2, "name": "MQIMGRCOV_AS_Q_MGR" },
    {  "value":          2, "name": "MQIMMREASON_NOT_RECONNECTABLE" },
    {  "value":          2, "name": "MQIMPO_CONVERT_TYPE" },
    {  "value":          2, "name": "MQITEM_STRING" },
    {  "value":          2, "name": "MQIT_CORREL_ID" },
    {  "value":          2, "name": "MQIT_STRING" },
    {  "value":          2, "name": "MQLDAPC_ERROR" },
    {  "value":          2, "name": "MQLDAP_AUTHORMD_SEARCHUSR" },
    {  "value":          2, "name": "MQLOGTYPE_REPLICATED" },
    {  "value":          2, "name": "MQMATCH_EXACT" },
    {  "value":          2, "name": "MQMCAT_THREAD" },
    {  "value":          2, "name": "MQMCEV_HEARTBEAT_TIMEOUT" },
    {  "value":          2, "name": "MQMCP_REPLY" },
    {  "value":          2, "name": "MQMC_DISABLED" },
    {  "value":          2, "name": "MQMDE_CURRENT_VERSION" },
    {  "value":          2, "name": "MQMDE_VERSION_2" },
    {  "value":          2, "name": "MQMD_CURRENT_VERSION" },
    {  "value":          2, "name": "MQMD_VERSION_2" },
    {  "value":          2, "name": "MQMF_SEGMENT" },
    {  "value":          2, "name": "MQMHBO_DELETE_PROPERTIES" },
    {  "value":          2, "name": "MQMLP_ENCRYPTION_ALG_DES" },
    {  "value":          2, "name": "MQMLP_SIGN_ALG_SHA1" },
    {  "value":          2, "name": "MQMODE_TERMINATE" },
    {  "value":          2, "name": "MQMO_MATCH_CORREL_ID" },
    {  "value":          2, "name": "MQMT_REPLY" },
    {  "value":          2, "name": "MQNHACONNGRP_SUSPENDED" },
    {  "value":          2, "name": "MQNHAGRPROLE_LIVE" },
    {  "value":          2, "name": "MQNHAROLE_REPLICA" },
    {  "value":          2, "name": "MQNHASTATUS_CHECKING" },
    {  "value":          2, "name": "MQNPMS_FAST" },
    {  "value":          2, "name": "MQNT_CLUSTER" },
    {  "value":          2, "name": "MQNXP_CURRENT_VERSION" },
    {  "value":          2, "name": "MQNXP_VERSION_2" },
    {  "value":          2, "name": "MQOD_VERSION_2" },
    {  "value":          2, "name": "MQOO_INPUT_SHARED" },
    {  "value":          2, "name": "MQOPER_DISCARD" },
    {  "value":          2, "name": "MQOP_START_WAIT" },
    {  "value":          2, "name": "MQOTEL_PCTL_AUTO" },
    {  "value":          2, "name": "MQOTEL_TRACE_ON" },
    {  "value":          2, "name": "MQOT_NAMELIST" },
    {  "value":          2, "name": "MQPA_CONTEXT" },
    {  "value":          2, "name": "MQPBC_CURRENT_VERSION" },
    {  "value":          2, "name": "MQPBC_VERSION_2" },
    {  "value":          2, "name": "MQPER_PERSISTENCE_AS_Q_DEF" },
    {  "value":          2, "name": "MQPER_PERSISTENCE_AS_TOPIC_DEF" },
    {  "value":          2, "name": "MQPL_OS2" },
    {  "value":          2, "name": "MQPMO_SYNCPOINT" },
    {  "value":          2, "name": "MQPMO_VERSION_2" },
    {  "value":          2, "name": "MQPMRF_CORREL_ID" },
    {  "value":          2, "name": "MQPROP_ALL" },
    {  "value":          2, "name": "MQPROTO_HTTP" },
    {  "value":          2, "name": "MQPRT_ASYNC_RESPONSE" },
    {  "value":          2, "name": "MQPSM_ENABLED" },
    {  "value":          2, "name": "MQPSPROP_RFH2" },
    {  "value":          2, "name": "MQPSST_PARENT" },
    {  "value":          2, "name": "MQPSXP_CURRENT_VERSION" },
    {  "value":          2, "name": "MQPSXP_VERSION_2" },
    {  "value":          2, "name": "MQPS_STATUS_STOPPING" },
    {  "value":          2, "name": "MQPUBO_RETAIN_PUBLICATION" },
    {  "value":          2, "name": "MQQDT_PERMANENT_DYNAMIC" },
    {  "value":          2, "name": "MQQMDT_AUTO_CLUSTER_SENDER" },
    {  "value":          2, "name": "MQQMFAC_DB2" },
    {  "value":          2, "name": "MQQMF_REPOSITORY_Q_MGR" },
    {  "value":          2, "name": "MQQMOPT_REPLY" },
    {  "value":          2, "name": "MQQMSTA_RUNNING" },
    {  "value":          2, "name": "MQQSGD_SHARED" },
    {  "value":          2, "name": "MQQSGS_ACTIVE" },
    {  "value":          2, "name": "MQQSIE_OK" },
    {  "value":          2, "name": "MQQSOT_INPUT" },
    {  "value":          2, "name": "MQQSO_EXCLUSIVE" },
    {  "value":          2, "name": "MQQT_MODEL" },
    {  "value":          2, "name": "MQRCN_Q_MGR" },
    {  "value":          2, "name": "MQRCVTIME_EQUAL" },
    {  "value":          2, "name": "MQREADA_DISABLED" },
    {  "value":          2, "name": "MQRECORDING_MSG" },
    {  "value":          2, "name": "MQREGO_ANONYMOUS" },
    {  "value":          2, "name": "MQRFH_VERSION_2" },
    {  "value":          2, "name": "MQROUTE_DETAIL_LOW" },
    {  "value":          2, "name": "MQRO_NAN" },
    {  "value":          2, "name": "MQRQ_OPEN_NOT_AUTHORIZED" },
    {  "value":          2, "name": "MQRT_EXPIRY" },
    {  "value":          2, "name": "MQRU_PUBLISH_ALL" },
    {  "value":          2, "name": "MQSCA_NEVER_REQUIRED" },
    {  "value":          2, "name": "MQSCO_CELL" },
    {  "value":          2, "name": "MQSCO_VERSION_2" },
    {  "value":          2, "name": "MQSECCOMM_ANON" },
    {  "value":          2, "name": "MQSECITEM_MQNLIST" },
    {  "value":          2, "name": "MQSECPROT_TLSV10" },
    {  "value":          2, "name": "MQSECSW_NAMELIST" },
    {  "value":          2, "name": "MQSECTYPE_SSL" },
    {  "value":          2, "name": "MQSELTYPE_EXTENDED" },
    {  "value":          2, "name": "MQSMPO_SET_PROP_AFTER_CURSOR" },
    {  "value":          2, "name": "MQSO_CREATE" },
    {  "value":          2, "name": "MQSPL_AS_POLICY" },
    {  "value":          2, "name": "MQSTAT_TYPE_RECONNECTION_ERROR" },
    {  "value":          2, "name": "MQSTS_CURRENT_VERSION" },
    {  "value":          2, "name": "MQSTS_VERSION_2" },
    {  "value":          2, "name": "MQSUBTYPE_ADMIN" },
    {  "value":          2, "name": "MQSUB_DURABLE_INHIBITED" },
    {  "value":          2, "name": "MQSUB_DURABLE_NO" },
    {  "value":          2, "name": "MQSVC_CONTROL_MANUAL" },
    {  "value":          2, "name": "MQSVC_STATUS_RUNNING" },
    {  "value":          2, "name": "MQSYSP_EXTENDED" },
    {  "value":          2, "name": "MQS_AVAIL_STOPPED" },
    {  "value":          2, "name": "MQS_EXPANDST_MAXIMUM" },
    {  "value":          2, "name": "MQS_OPENMODE_UPDATE" },
    {  "value":          2, "name": "MQS_STATUS_OPENING" },
    {  "value":          2, "name": "MQTA_PASSTHRU" },
    {  "value":          2, "name": "MQTA_PROXY_SUB_FIRSTUSE" },
    {  "value":          2, "name": "MQTA_PUB_ALLOWED" },
    {  "value":          2, "name": "MQTA_SUB_ALLOWED" },
    {  "value":          2, "name": "MQTOPT_ALL" },
    {  "value":          2, "name": "MQTSCOPE_ALL" },
    {  "value":          2, "name": "MQTT_EVERY" },
    {  "value":          2, "name": "MQTYPE_NULL" },
    {  "value":          2, "name": "MQUNDELIVERED_DISCARD" },
    {  "value":          2, "name": "MQUOWST_PREPARED" },
    {  "value":          2, "name": "MQUOWT_RRS" },
    {  "value":          2, "name": "MQUSAGE_EXPAND_SYSTEM" },
    {  "value":          2, "name": "MQUSAGE_PS_OFFLINE" },
    {  "value":          2, "name": "MQUSEDLQ_YES" },
    {  "value":          2, "name": "MQUSRC_CHANNEL" },
    {  "value":          2, "name": "MQVU_ANY_USER" },
    {  "value":          2, "name": "MQWDR_CURRENT_VERSION" },
    {  "value":          2, "name": "MQWDR_VERSION_2" },
    {  "value":          2, "name": "MQWQR_VERSION_2" },
    {  "value":          2, "name": "MQWS_TOPIC" },
    {  "value":          2, "name": "MQWXP_PUT_BY_CLUSTER_CHL" },
    {  "value":          2, "name": "MQWXP_VERSION_2" },
    {  "value":          2, "name": "MQXACT_INTERNAL" },
    {  "value":          2, "name": "MQXC_MQCLOSE" },
    {  "value":          2, "name": "MQXE_MCA_SVRCONN" },
    {  "value":          2, "name": "MQXF_TERM" },
    {  "value":          2, "name": "MQXPT_TCP" },
    {  "value":          2, "name": "MQXR2_PUT_WITH_MSG_USERID" },
    {  "value":          2, "name": "MQXR_AFTER" },
    {  "value":          2, "name": "MQXT_API_EXIT" },
    {  "value":          2, "name": "MQZAD_CURRENT_VERSION" },
    {  "value":          2, "name": "MQZAD_VERSION_2" },
    {  "value":          2, "name": "MQZAET_GROUP" },
    {  "value":          2, "name": "MQZAO_BROWSE" },
    {  "value":          2, "name": "MQZAS_VERSION_2" },
    {  "value":          2, "name": "MQZED_CURRENT_VERSION" },
    {  "value":          2, "name": "MQZED_VERSION_2" },
    {  "value":          2, "name": "MQZIC_CURRENT_VERSION" },
    {  "value":          2, "name": "MQZIC_VERSION_2" },
    {  "value":          2, "name": "MQZID_CHECK_AUTHORITY" },
    {  "value":          2, "name": "MQZID_FIND_USERID" },
    {  "value":          2, "name": "MQZID_LOOKUP_NAME" },
    {  "value":          2, "name": "MQ_ARM_SUFFIX_LENGTH" },
    {  "value":          2, "name": "MQ_CERT_VAL_POLICY_NONE" },
    {  "value":          2, "name": "MQ_HTTPSCERTREV_DISABLED" },
    {  "value":          2, "name": "MQ_HTTPSCERTVAL_NONE" },
    {  "value":          2, "name": "MQ_SUITE_B_128_BIT" },
    {  "value":          3, "name": "MQACTP_REPORT" },
    {  "value":          3, "name": "MQACTV_DETAIL_HIGH" },
    {  "value":          3, "name": "MQACT_COLLECT_STATISTICS" },
    {  "value":          3, "name": "MQAIT_IDPW_OS" },
    {  "value":          3, "name": "MQAS_STOPPED" },
    {  "value":          3, "name": "MQAT_IMS" },
    {  "value":          3, "name": "MQAUTH_CHANGE" },
    {  "value":          3, "name": "MQBALANCED_UNKNOWN" },
    {  "value":          3, "name": "MQBALSTATE_HIGH" },
    {  "value":          3, "name": "MQBPLOCATION_SWITCHING_BELOW" },
    {  "value":          3, "name": "MQCAUT_SSLPEERMAP" },
    {  "value":          3, "name": "MQCBCT_REGISTER_CALL" },
    {  "value":          3, "name": "MQCDC_VERSION_3" },
    {  "value":          3, "name": "MQCD_VERSION_3" },
    {  "value":          3, "name": "MQCFH_CURRENT_VERSION" },
    {  "value":          3, "name": "MQCFH_VERSION_3" },
    {  "value":          3, "name": "MQCFOFFLD_BOTH" },
    {  "value":          3, "name": "MQCFOP_NOT_GREATER" },
    {  "value":          3, "name": "MQCFSTATUS_IN_BACKUP" },
    {  "value":          3, "name": "MQCFT_INTEGER" },
    {  "value":          3, "name": "MQCHK_REQUIRED" },
    {  "value":          3, "name": "MQCHS_RUNNING" },
    {  "value":          3, "name": "MQCHT_RECEIVER" },
    {  "value":          3, "name": "MQCLST_ERROR" },
    {  "value":          3, "name": "MQCMDI_CMDSCOPE_COMPLETED" },
    {  "value":          3, "name": "MQCMD_CHANGE_PROCESS" },
    {  "value":          3, "name": "MQCNO_VERSION_3" },
    {  "value":          3, "name": "MQCQT_REMOTE_Q" },
    {  "value":          3, "name": "MQCRC_BRIDGE_ERROR" },
    {  "value":          3, "name": "MQCSP_CURRENT_VERSION" },
    {  "value":          3, "name": "MQCSP_VERSION_3" },
    {  "value":          3, "name": "MQCS_SUSPENDED" },
    {  "value":          3, "name": "MQCXP_VERSION_3" },
    {  "value":          3, "name": "MQDLV_ALL_AVAIL" },
    {  "value":          3, "name": "MQDSB_32K" },
    {  "value":          3, "name": "MQEC_WAIT_INTERVAL_EXPIRED" },
    {  "value":          3, "name": "MQEVO_MSG" },
    {  "value":          3, "name": "MQEVR_NO_DISPLAY" },
    {  "value":          3, "name": "MQFUN_TYPE_PROCEDURE" },
    {  "value":          3, "name": "MQGMO_VERSION_3" },
    {  "value":          3, "name": "MQIAMO_MONITOR_LSN" },
    {  "value":          3, "name": "MQIA_CURRENT_Q_DEPTH" },
    {  "value":          3, "name": "MQIGQPA_ONLY_IGQ" },
    {  "value":          3, "name": "MQIMMREASON_MOVING" },
    {  "value":          3, "name": "MQINBD_GROUP" },
    {  "value":          3, "name": "MQITEM_BAG" },
    {  "value":          3, "name": "MQIT_BAG" },
    {  "value":          3, "name": "MQLDAP_AUTHORMD_SRCHGRPSN" },
    {  "value":          3, "name": "MQMATCH_ALL" },
    {  "value":          3, "name": "MQMCAS_RUNNING" },
    {  "value":          3, "name": "MQMCEV_VERSION_CONFLICT" },
    {  "value":          3, "name": "MQMC_ONLY" },
    {  "value":          3, "name": "MQMLP_ENCRYPTION_ALG_3DES" },
    {  "value":          3, "name": "MQMLP_SIGN_ALG_SHA224" },
    {  "value":          3, "name": "MQNHAGRPROLE_RECOVERY" },
    {  "value":          3, "name": "MQNHAROLE_LEADER" },
    {  "value":          3, "name": "MQNHASTATUS_SYNCHRONIZING" },
    {  "value":          3, "name": "MQOD_VERSION_3" },
    {  "value":          3, "name": "MQOPER_GET" },
    {  "value":          3, "name": "MQOTEL_PCTL_AS_PARENT" },
    {  "value":          3, "name": "MQOTEL_TRACE_NONE" },
    {  "value":          3, "name": "MQOT_PROCESS" },
    {  "value":          3, "name": "MQPA_ONLY_MCA" },
    {  "value":          3, "name": "MQPL_AIX" },
    {  "value":          3, "name": "MQPL_UNIX" },
    {  "value":          3, "name": "MQPMO_CURRENT_VERSION" },
    {  "value":          3, "name": "MQPMO_VERSION_3" },
    {  "value":          3, "name": "MQPROP_FORCE_MQRFH2" },
    {  "value":          3, "name": "MQPROTO_AMQP" },
    {  "value":          3, "name": "MQPSPROP_MSGPROP" },
    {  "value":          3, "name": "MQPSST_CHILD" },
    {  "value":          3, "name": "MQPS_STATUS_ACTIVE" },
    {  "value":          3, "name": "MQQDT_TEMPORARY_DYNAMIC" },
    {  "value":          3, "name": "MQQMDT_CLUSTER_RECEIVER" },
    {  "value":          3, "name": "MQQMSTA_QUIESCING" },
    {  "value":          3, "name": "MQQSGD_GROUP" },
    {  "value":          3, "name": "MQQSGS_INACTIVE" },
    {  "value":          3, "name": "MQQSOT_OUTPUT" },
    {  "value":          3, "name": "MQQT_ALIAS" },
    {  "value":          3, "name": "MQRCN_DISABLED" },
    {  "value":          3, "name": "MQREADA_INHIBITED" },
    {  "value":          3, "name": "MQRQ_CLOSE_NOT_AUTHORIZED" },
    {  "value":          3, "name": "MQRT_NSPROC" },
    {  "value":          3, "name": "MQSCO_VERSION_3" },
    {  "value":          3, "name": "MQSECITEM_MQPROC" },
    {  "value":          3, "name": "MQSECSW_Q" },
    {  "value":          3, "name": "MQSECTYPE_CLASSES" },
    {  "value":          3, "name": "MQSUBTYPE_PROXY" },
    {  "value":          3, "name": "MQSVC_STATUS_STOPPING" },
    {  "value":          3, "name": "MQS_OPENMODE_RECOVERY" },
    {  "value":          3, "name": "MQS_STATUS_OPEN" },
    {  "value":          3, "name": "MQTT_DEPTH" },
    {  "value":          3, "name": "MQUNDELIVERED_KEEP" },
    {  "value":          3, "name": "MQUOWST_UNRESOLVED" },
    {  "value":          3, "name": "MQUOWT_IMS" },
    {  "value":          3, "name": "MQUSAGE_EXPAND_NONE" },
    {  "value":          3, "name": "MQUSAGE_PS_NOT_DEFINED" },
    {  "value":          3, "name": "MQWQR_VERSION_3" },
    {  "value":          3, "name": "MQWXP_VERSION_3" },
    {  "value":          3, "name": "MQXC_MQGET" },
    {  "value":          3, "name": "MQXE_COMMAND_SERVER" },
    {  "value":          3, "name": "MQXF_CONN" },
    {  "value":          3, "name": "MQXPT_NETBIOS" },
    {  "value":          3, "name": "MQXR_CONNECTION" },
    {  "value":          3, "name": "MQZAET_UNKNOWN" },
    {  "value":          3, "name": "MQZAS_VERSION_3" },
    {  "value":          3, "name": "MQZID_COPY_ALL_AUTHORITY" },
    {  "value":          3, "name": "MQZID_INSERT_NAME" },
    {  "value":          3, "name": "MQ_HTTPSCERTREV_OPTIONAL" },
    {  "value":          3, "name": "MQ_HTTPSCERTVAL_HOSTNAMECN" },
    {  "value":          4, "name": "MQACT_PUBSUB" },
    {  "value":          4, "name": "MQADOPT_CHECK_NET_ADDR" },
    {  "value":          4, "name": "MQADOPT_TYPE_SDR" },
    {  "value":          4, "name": "MQAIT_IDPW_LDAP" },
    {  "value":          4, "name": "MQAS_SUSPENDED" },
    {  "value":          4, "name": "MQAT_OS2" },
    {  "value":          4, "name": "MQAUTH_CLEAR" },
    {  "value":          4, "name": "MQBALSTATE_UNKNOWN" },
    {  "value":          4, "name": "MQCAUT_ADDRESSMAP" },
    {  "value":          4, "name": "MQCBCT_DEREGISTER_CALL" },
    {  "value":          4, "name": "MQCBDO_STOP_CALL" },
    {  "value":          4, "name": "MQCBO_REORDER_AS_REQUIRED" },
    {  "value":          4, "name": "MQCDC_VERSION_4" },
    {  "value":          4, "name": "MQCD_VERSION_4" },
    {  "value":          4, "name": "MQCFOP_GREATER" },
    {  "value":          4, "name": "MQCFSTATUS_FAILED" },
    {  "value":          4, "name": "MQCFT_STRING" },
    {  "value":          4, "name": "MQCHK_AS_Q_MGR" },
    {  "value":          4, "name": "MQCHLD_PRIVATE" },
    {  "value":          4, "name": "MQCHS_STOPPING" },
    {  "value":          4, "name": "MQCHT_REQUESTER" },
    {  "value":          4, "name": "MQCIH_SYNC_ON_RETURN" },
    {  "value":          4, "name": "MQCMDI_QSG_DISP_COMPLETED" },
    {  "value":          4, "name": "MQCMD_COPY_PROCESS" },
    {  "value":          4, "name": "MQCNO_SERIALIZE_CONN_TAG_QSG" },
    {  "value":          4, "name": "MQCNO_VERSION_4" },
    {  "value":          4, "name": "MQCOMPRESS_ZLIBHIGH" },
    {  "value":          4, "name": "MQCOPY_PUBLISH" },
    {  "value":          4, "name": "MQCO_KEEP_SUB" },
    {  "value":          4, "name": "MQCQT_Q_MGR_ALIAS" },
    {  "value":          4, "name": "MQCRC_BRIDGE_ABEND" },
    {  "value":          4, "name": "MQCS_STOPPED" },
    {  "value":          4, "name": "MQCXP_VERSION_4" },
    {  "value":          4, "name": "MQDCC_INT_DEFAULT_CONVERSION" },
    {  "value":          4, "name": "MQDELO_LOCAL" },
    {  "value":          4, "name": "MQDSB_64K" },
    {  "value":          4, "name": "MQEC_WAIT_CANCELED" },
    {  "value":          4, "name": "MQEVO_MQSET" },
    {  "value":          4, "name": "MQEVR_API_ONLY" },
    {  "value":          4, "name": "MQFUN_TYPE_USERDEF" },
    {  "value":          4, "name": "MQGMO_CURRENT_VERSION" },
    {  "value":          4, "name": "MQGMO_NO_SYNCPOINT" },
    {  "value":          4, "name": "MQGMO_VERSION_4" },
    {  "value":          4, "name": "MQIA_DEF_INPUT_OPEN_OPTION" },
    {  "value":          4, "name": "MQIGQPA_ALTERNATE_OR_IGQ" },
    {  "value":          4, "name": "MQIMMREASON_APPLNAME_CHANGED" },
    {  "value":          4, "name": "MQIMPO_QUERY_LENGTH" },
    {  "value":          4, "name": "MQITEM_BYTE_STRING" },
    {  "value":          4, "name": "MQIT_MSG_TOKEN" },
    {  "value":          4, "name": "MQMCEV_RELIABILITY" },
    {  "value":          4, "name": "MQMF_LAST_SEGMENT" },
    {  "value":          4, "name": "MQMLP_ENCRYPTION_ALG_AES128" },
    {  "value":          4, "name": "MQMLP_SIGN_ALG_SHA256" },
    {  "value":          4, "name": "MQMO_MATCH_GROUP_ID" },
    {  "value":          4, "name": "MQMT_REPORT" },
    {  "value":          4, "name": "MQNHAGRPROLE_PENDING_LIVE" },
    {  "value":          4, "name": "MQNHASTATUS_REBASING" },
    {  "value":          4, "name": "MQNT_AUTH_INFO" },
    {  "value":          4, "name": "MQOD_CURRENT_VERSION" },
    {  "value":          4, "name": "MQOD_VERSION_4" },
    {  "value":          4, "name": "MQOO_INPUT_EXCLUSIVE" },
    {  "value":          4, "name": "MQOPER_PUT" },
    {  "value":          4, "name": "MQOP_STOP" },
    {  "value":          4, "name": "MQOTEL_TRACE_AS_PARENT" },
    {  "value":          4, "name": "MQOT_STORAGE_CLASS" },
    {  "value":          4, "name": "MQPA_ALTERNATE_OR_MCA" },
    {  "value":          4, "name": "MQPL_OS400" },
    {  "value":          4, "name": "MQPMO_NO_SYNCPOINT" },
    {  "value":          4, "name": "MQPMRF_GROUP_ID" },
    {  "value":          4, "name": "MQPROP_V6COMPAT" },
    {  "value":          4, "name": "MQPROTO_MQTTV311" },
    {  "value":          4, "name": "MQPS_STATUS_COMPAT" },
    {  "value":          4, "name": "MQPUBO_OTHER_SUBSCRIBERS_ONLY" },
    {  "value":          4, "name": "MQQDT_SHARED_DYNAMIC" },
    {  "value":          4, "name": "MQQMDT_AUTO_EXP_CLUSTER_SENDER" },
    {  "value":          4, "name": "MQQMSTA_STANDBY" },
    {  "value":          4, "name": "MQQSGD_PRIVATE" },
    {  "value":          4, "name": "MQQSGS_FAILED" },
    {  "value":          4, "name": "MQREADA_BACKLOG" },
    {  "value":          4, "name": "MQREGO_LOCAL" },
    {  "value":          4, "name": "MQRO_ACTIVITY" },
    {  "value":          4, "name": "MQRQ_CMD_NOT_AUTHORIZED" },
    {  "value":          4, "name": "MQRT_PROXYSUB" },
    {  "value":          4, "name": "MQSCOPE_QMGR" },
    {  "value":          4, "name": "MQSCO_VERSION_4" },
    {  "value":          4, "name": "MQSECITEM_MQQUEUE" },
    {  "value":          4, "name": "MQSECPROT_TLSV12" },
    {  "value":          4, "name": "MQSECSW_TOPIC" },
    {  "value":          4, "name": "MQSECTYPE_CONNAUTH" },
    {  "value":          4, "name": "MQSMPO_APPEND_PROPERTY" },
    {  "value":          4, "name": "MQSO_RESUME" },
    {  "value":          4, "name": "MQSVC_STATUS_RETRYING" },
    {  "value":          4, "name": "MQS_STATUS_NOTENABLED" },
    {  "value":          4, "name": "MQTYPE_BOOLEAN" },
    {  "value":          4, "name": "MQUOWT_XA" },
    {  "value":          4, "name": "MQUSAGE_PS_SUSPENDED" },
    {  "value":          4, "name": "MQWQR_CURRENT_VERSION" },
    {  "value":          4, "name": "MQWQR_VERSION_4" },
    {  "value":          4, "name": "MQWXP_CURRENT_VERSION" },
    {  "value":          4, "name": "MQWXP_VERSION_4" },
    {  "value":          4, "name": "MQXC_MQPUT" },
    {  "value":          4, "name": "MQXE_MQSC" },
    {  "value":          4, "name": "MQXF_CONNX" },
    {  "value":          4, "name": "MQXPT_SPX" },
    {  "value":          4, "name": "MQXR2_USE_EXIT_BUFFER" },
    {  "value":          4, "name": "MQXR_BEFORE_CONVERT" },
    {  "value":          4, "name": "MQZAO_INPUT" },
    {  "value":          4, "name": "MQZAS_VERSION_4" },
    {  "value":          4, "name": "MQZID_DELETE_AUTHORITY" },
    {  "value":          4, "name": "MQZID_DELETE_NAME" },
    {  "value":          4, "name": "MQ_ABEND_CODE_LENGTH" },
    {  "value":          4, "name": "MQ_APPL_ORIGIN_DATA_LENGTH" },
    {  "value":          4, "name": "MQ_ASID_LENGTH" },
    {  "value":          4, "name": "MQ_ATTENTION_ID_LENGTH" },
    {  "value":          4, "name": "MQ_AUTO_REORG_TIME_LENGTH" },
    {  "value":          4, "name": "MQ_CANCEL_CODE_LENGTH" },
    {  "value":          4, "name": "MQ_DB2_NAME_LENGTH" },
    {  "value":          4, "name": "MQ_FACILITY_LIKE_LENGTH" },
    {  "value":          4, "name": "MQ_FUNCTION_LENGTH" },
    {  "value":          4, "name": "MQ_OPERATOR_MESSAGE_LENGTH" },
    {  "value":          4, "name": "MQ_QSG_NAME_LENGTH" },
    {  "value":          4, "name": "MQ_Q_MGR_CPF_LENGTH" },
    {  "value":          4, "name": "MQ_REMOTE_PRODUCT_LENGTH" },
    {  "value":          4, "name": "MQ_REMOTE_SYS_ID_LENGTH" },
    {  "value":          4, "name": "MQ_SMDS_NAME_LENGTH" },
    {  "value":          4, "name": "MQ_START_CODE_LENGTH" },
    {  "value":          4, "name": "MQ_SUITE_B_192_BIT" },
    {  "value":          4, "name": "MQ_SUITE_B_SIZE" },
    {  "value":          4, "name": "MQ_TPIPE_PFX_LENGTH" },
    {  "value":          4, "name": "MQ_TRANSACTION_ID_LENGTH" },
    {  "value":          4, "name": "MQ_TRIGGER_TERM_ID_LENGTH" },
    {  "value":          4, "name": "MQ_TRIGGER_TRANS_ID_LENGTH" },
    {  "value":          5, "name": "MQACT_ADD" },
    {  "value":          5, "name": "MQAS_SUSPENDED_TEMPORARY" },
    {  "value":          5, "name": "MQAT_DOS" },
    {  "value":          5, "name": "MQAUTH_CONNECT" },
    {  "value":          5, "name": "MQCAUT_USERMAP" },
    {  "value":          5, "name": "MQCBCT_EVENT_CALL" },
    {  "value":          5, "name": "MQCDC_VERSION_5" },
    {  "value":          5, "name": "MQCD_VERSION_5" },
    {  "value":          5, "name": "MQCFOP_NOT_EQUAL" },
    {  "value":          5, "name": "MQCFSTATUS_NONE" },
    {  "value":          5, "name": "MQCFT_INTEGER_LIST" },
    {  "value":          5, "name": "MQCHLD_FIXSHARED" },
    {  "value":          5, "name": "MQCHS_RETRYING" },
    {  "value":          5, "name": "MQCHT_ALL" },
    {  "value":          5, "name": "MQCMDI_COMMAND_ACCEPTED" },
    {  "value":          5, "name": "MQCMD_CREATE_PROCESS" },
    {  "value":          5, "name": "MQCNO_VERSION_5" },
    {  "value":          5, "name": "MQCRC_APPLICATION_ABEND" },
    {  "value":          5, "name": "MQCXP_VERSION_5" },
    {  "value":          5, "name": "MQDSB_128K" },
    {  "value":          5, "name": "MQEC_Q_MGR_QUIESCING" },
    {  "value":          5, "name": "MQEVO_INTERNAL" },
    {  "value":          5, "name": "MQEVR_ADMIN_ONLY" },
    {  "value":          5, "name": "MQFUN_TYPE_COMMAND" },
    {  "value":          5, "name": "MQIA_DEF_PERSISTENCE" },
    {  "value":          5, "name": "MQIMMREASON_IN_TRANSACTION" },
    {  "value":          5, "name": "MQITEM_INTEGER_FILTER" },
    {  "value":          5, "name": "MQIT_GROUP_ID" },
    {  "value":          5, "name": "MQMCEV_CLOSED_TRANS" },
    {  "value":          5, "name": "MQMLP_ENCRYPTION_ALG_AES256" },
    {  "value":          5, "name": "MQMLP_SIGN_ALG_SHA384" },
    {  "value":          5, "name": "MQNHAGRPROLE_PENDING_RECOVERY" },
    {  "value":          5, "name": "MQNHASTATUS_DISK_FULL" },
    {  "value":          5, "name": "MQOPER_PUT_REPLY" },
    {  "value":          5, "name": "MQOT_Q_MGR" },
    {  "value":          5, "name": "MQPL_WINDOWS" },
    {  "value":          5, "name": "MQPS_STATUS_ERROR" },
    {  "value":          5, "name": "MQQSGS_PENDING" },
    {  "value":          5, "name": "MQRQ_Q_MGR_STOPPING" },
    {  "value":          5, "name": "MQRT_SUB_CONFIGURATION" },
    {  "value":          5, "name": "MQSCO_VERSION_5" },
    {  "value":          5, "name": "MQSECITEM_MQCONN" },
    {  "value":          5, "name": "MQS_STATUS_ALLOCFAIL" },
    {  "value":          5, "name": "MQXC_MQPUT1" },
    {  "value":          5, "name": "MQXE_MCA_CLNTCONN" },
    {  "value":          5, "name": "MQXF_DISC" },
    {  "value":          5, "name": "MQXPT_DECNET" },
    {  "value":          5, "name": "MQZAS_VERSION_5" },
    {  "value":          5, "name": "MQZID_SET_AUTHORITY" },
    {  "value":          6, "name": "MQACT_REPLACE" },
    {  "value":          6, "name": "MQAS_ACTIVE" },
    {  "value":          6, "name": "MQAT_AIX" },
    {  "value":          6, "name": "MQAT_DEFAULT" },
    {  "value":          6, "name": "MQAT_UNIX" },
    {  "value":          6, "name": "MQAUTH_CREATE" },
    {  "value":          6, "name": "MQCAUT_QMGRMAP" },
    {  "value":          6, "name": "MQCBCT_MSG_REMOVED" },
    {  "value":          6, "name": "MQCDC_VERSION_6" },
    {  "value":          6, "name": "MQCD_VERSION_6" },
    {  "value":          6, "name": "MQCFOP_NOT_LESS" },
    {  "value":          6, "name": "MQCFSTATUS_UNKNOWN" },
    {  "value":          6, "name": "MQCFT_STRING_LIST" },
    {  "value":          6, "name": "MQCHS_STOPPED" },
    {  "value":          6, "name": "MQCHT_CLNTCONN" },
    {  "value":          6, "name": "MQCMDI_CLUSTER_REQUEST_QUEUED" },
    {  "value":          6, "name": "MQCMD_DELETE_PROCESS" },
    {  "value":          6, "name": "MQCNO_VERSION_6" },
    {  "value":          6, "name": "MQCRC_SECURITY_ERROR" },
    {  "value":          6, "name": "MQCXP_VERSION_6" },
    {  "value":          6, "name": "MQDSB_256K" },
    {  "value":          6, "name": "MQEC_CONNECTION_QUIESCING" },
    {  "value":          6, "name": "MQEVO_MQSUB" },
    {  "value":          6, "name": "MQEVR_USER_ONLY" },
    {  "value":          6, "name": "MQIA_DEF_PRIORITY" },
    {  "value":          6, "name": "MQIMMREASON_AWAITS_REPLY" },
    {  "value":          6, "name": "MQITEM_STRING_FILTER" },
    {  "value":          6, "name": "MQMCEV_STREAM_ERROR" },
    {  "value":          6, "name": "MQMLP_SIGN_ALG_SHA512" },
    {  "value":          6, "name": "MQNHASTATUS_DISCONNECTED" },
    {  "value":          6, "name": "MQOPER_PUT_REPORT" },
    {  "value":          6, "name": "MQOT_CHANNEL" },
    {  "value":          6, "name": "MQPS_STATUS_REFUSED" },
    {  "value":          6, "name": "MQQSGD_LIVE" },
    {  "value":          6, "name": "MQQT_REMOTE" },
    {  "value":          6, "name": "MQRQ_Q_MGR_QUIESCING" },
    {  "value":          6, "name": "MQSCO_VERSION_6" },
    {  "value":          6, "name": "MQSECITEM_MQCMDS" },
    {  "value":          6, "name": "MQSECSW_CONTEXT" },
    {  "value":          6, "name": "MQS_STATUS_OPENFAIL" },
    {  "value":          6, "name": "MQXC_MQINQ" },
    {  "value":          6, "name": "MQXF_OPEN" },
    {  "value":          6, "name": "MQXPT_UDP" },
    {  "value":          6, "name": "MQZAS_VERSION_6" },
    {  "value":          6, "name": "MQZID_GET_AUTHORITY" },
    {  "value":          6, "name": "MQ_VOLSER_LENGTH" },
    {  "value":          7, "name": "MQACT_REMOVE" },
    {  "value":          7, "name": "MQAS_INACTIVE" },
    {  "value":          7, "name": "MQAT_QMGR" },
    {  "value":          7, "name": "MQAUTH_DELETE" },
    {  "value":          7, "name": "MQCBCT_MSG_NOT_REMOVED" },
    {  "value":          7, "name": "MQCDC_VERSION_7" },
    {  "value":          7, "name": "MQCD_VERSION_7" },
    {  "value":          7, "name": "MQCFSTATUS_RECOVERED" },
    {  "value":          7, "name": "MQCFT_EVENT" },
    {  "value":          7, "name": "MQCHS_REQUESTING" },
    {  "value":          7, "name": "MQCHT_SVRCONN" },
    {  "value":          7, "name": "MQCMDI_CHANNEL_INIT_STARTED" },
    {  "value":          7, "name": "MQCMD_INQUIRE_PROCESS" },
    {  "value":          7, "name": "MQCNO_VERSION_7" },
    {  "value":          7, "name": "MQCRC_PROGRAM_NOT_AVAILABLE" },
    {  "value":          7, "name": "MQCXP_VERSION_7" },
    {  "value":          7, "name": "MQDSB_512K" },
    {  "value":          7, "name": "MQEVO_CTLMSG" },
    {  "value":          7, "name": "MQIA_DEFINITION_TYPE" },
    {  "value":          7, "name": "MQIMMREASON_NO_REDIRECT" },
    {  "value":          7, "name": "MQITEM_INTEGER64" },
    {  "value":          7, "name": "MQNHASTATUS_PARTITIONED" },
    {  "value":          7, "name": "MQOPER_RECEIVE" },
    {  "value":          7, "name": "MQOT_AUTH_INFO" },
    {  "value":          7, "name": "MQQT_CLUSTER" },
    {  "value":          7, "name": "MQRQ_CHANNEL_STOPPED_OK" },
    {  "value":          7, "name": "MQSCO_CURRENT_VERSION" },
    {  "value":          7, "name": "MQSCO_VERSION_7" },
    {  "value":          7, "name": "MQSECITEM_MXADMIN" },
    {  "value":          7, "name": "MQSECSW_ALTERNATE_USER" },
    {  "value":          7, "name": "MQS_STATUS_STGFAIL" },
    {  "value":          7, "name": "MQXF_CLOSE" },
    {  "value":          7, "name": "MQZID_GET_EXPLICIT_AUTHORITY" },
    {  "value":          8, "name": "MQACT_REMOVEALL" },
    {  "value":          8, "name": "MQADOPT_CHECK_CHANNEL_NAME" },
    {  "value":          8, "name": "MQADOPT_TYPE_RCVR" },
    {  "value":          8, "name": "MQAT_OS400" },
    {  "value":          8, "name": "MQAUTH_DISPLAY" },
    {  "value":          8, "name": "MQCBCT_MC_EVENT_CALL" },
    {  "value":          8, "name": "MQCBO_CHECK_SELECTORS" },
    {  "value":          8, "name": "MQCDC_VERSION_8" },
    {  "value":          8, "name": "MQCD_VERSION_8" },
    {  "value":          8, "name": "MQCFSTATUS_EMPTY" },
    {  "value":          8, "name": "MQCFT_USER" },
    {  "value":          8, "name": "MQCHS_PAUSED" },
    {  "value":          8, "name": "MQCHT_CLUSRCVR" },
    {  "value":          8, "name": "MQCMD_CHANGE_Q" },
    {  "value":          8, "name": "MQCNO_CURRENT_VERSION" },
    {  "value":          8, "name": "MQCNO_RESTRICT_CONN_TAG_Q_MGR" },
    {  "value":          8, "name": "MQCNO_VERSION_8" },
    {  "value":          8, "name": "MQCOMPRESS_SYSTEM" },
    {  "value":          8, "name": "MQCOPY_REPLY" },
    {  "value":          8, "name": "MQCO_REMOVE_SUB" },
    {  "value":          8, "name": "MQCRC_BRIDGE_TIMEOUT" },
    {  "value":          8, "name": "MQCXP_VERSION_8" },
    {  "value":          8, "name": "MQDSB_1024K" },
    {  "value":          8, "name": "MQDSB_1M" },
    {  "value":          8, "name": "MQEVO_REST" },
    {  "value":          8, "name": "MQGMO_SET_SIGNAL" },
    {  "value":          8, "name": "MQIA_HARDEN_GET_BACKOUT" },
    {  "value":          8, "name": "MQIIH_REPLY_FORMAT_NONE" },
    {  "value":          8, "name": "MQIMPO_INQ_NEXT" },
    {  "value":          8, "name": "MQITEM_BYTE_STRING_FILTER" },
    {  "value":          8, "name": "MQMF_MSG_IN_GROUP" },
    {  "value":          8, "name": "MQMO_MATCH_MSG_SEQ_NUMBER" },
    {  "value":          8, "name": "MQMT_DATAGRAM" },
    {  "value":          8, "name": "MQOO_BROWSE" },
    {  "value":          8, "name": "MQOPER_SEND" },
    {  "value":          8, "name": "MQOT_TOPIC" },
    {  "value":          8, "name": "MQPMRF_FEEDBACK" },
    {  "value":          8, "name": "MQPUBO_NO_REGISTRATION" },
    {  "value":          8, "name": "MQQMF_CLUSSDR_USER_DEFINED" },
    {  "value":          8, "name": "MQREGO_DIRECT_REQUESTS" },
    {  "value":          8, "name": "MQROUTE_DETAIL_MEDIUM" },
    {  "value":          8, "name": "MQRQ_CHANNEL_STOPPED_ERROR" },
    {  "value":          8, "name": "MQSECITEM_MXNLIST" },
    {  "value":          8, "name": "MQSECPROT_TLSV13" },
    {  "value":          8, "name": "MQSECSW_COMMAND" },
    {  "value":          8, "name": "MQSMPO_SET_PROP_BEFORE_CURSOR" },
    {  "value":          8, "name": "MQSO_DURABLE" },
    {  "value":          8, "name": "MQS_STATUS_DATAFAIL" },
    {  "value":          8, "name": "MQTYPE_BYTE_STRING" },
    {  "value":          8, "name": "MQXC_MQSET" },
    {  "value":          8, "name": "MQXF_PUT1" },
    {  "value":          8, "name": "MQXR2_CONTINUE_CHAIN" },
    {  "value":          8, "name": "MQZAO_OUTPUT" },
    {  "value":          8, "name": "MQZID_REFRESH_CACHE" },
    {  "value":          8, "name": "MQ_ARCHIVE_UNIT_LENGTH" },
    {  "value":          8, "name": "MQ_AUTHENTICATOR_LENGTH" },
    {  "value":          8, "name": "MQ_BATCH_INTERFACE_ID_LENGTH" },
    {  "value":          8, "name": "MQ_CHANNEL_TIME_LENGTH" },
    {  "value":          8, "name": "MQ_CICS_FILE_NAME_LENGTH" },
    {  "value":          8, "name": "MQ_CREATION_TIME_LENGTH" },
    {  "value":          8, "name": "MQ_DSG_NAME_LENGTH" },
    {  "value":          8, "name": "MQ_FACILITY_LENGTH" },
    {  "value":          8, "name": "MQ_FORMAT_LENGTH" },
    {  "value":          8, "name": "MQ_LOG_CORREL_ID_LENGTH" },
    {  "value":          8, "name": "MQ_LTERM_OVERRIDE_LENGTH" },
    {  "value":          8, "name": "MQ_LU_NAME_LENGTH" },
    {  "value":          8, "name": "MQ_MFS_MAP_NAME_LENGTH" },
    {  "value":          8, "name": "MQ_MODE_NAME_LENGTH" },
    {  "value":          8, "name": "MQ_ORIGIN_NAME_LENGTH" },
    {  "value":          8, "name": "MQ_PASS_TICKET_APPL_LENGTH" },
    {  "value":          8, "name": "MQ_PSB_NAME_LENGTH" },
    {  "value":          8, "name": "MQ_PST_ID_LENGTH" },
    {  "value":          8, "name": "MQ_PUT_DATE_LENGTH" },
    {  "value":          8, "name": "MQ_PUT_TIME_LENGTH" },
    {  "value":          8, "name": "MQ_REMOTE_VERSION_LENGTH" },
    {  "value":          8, "name": "MQ_SERVICE_STEP_LENGTH" },
    {  "value":          8, "name": "MQ_SSL_KEY_MEMBER_LENGTH" },
    {  "value":          8, "name": "MQ_STORAGE_CLASS_LENGTH" },
    {  "value":          8, "name": "MQ_SYSTEM_NAME_LENGTH" },
    {  "value":          8, "name": "MQ_TASK_NUMBER_LENGTH" },
    {  "value":          8, "name": "MQ_TCP_NAME_LENGTH" },
    {  "value":          8, "name": "MQ_TIME_LENGTH" },
    {  "value":          8, "name": "MQ_TPIPE_NAME_LENGTH" },
    {  "value":          8, "name": "MQ_TRIGGER_PROGRAM_NAME_LENGTH" },
    {  "value":          8, "name": "MQ_VERSION_LENGTH" },
    {  "value":          8, "name": "MQ_XCF_GROUP_NAME_LENGTH" },
    {  "value":          9, "name": "MQACT_FAIL" },
    {  "value":          9, "name": "MQAT_WINDOWS" },
    {  "value":          9, "name": "MQAUTH_INPUT" },
    {  "value":          9, "name": "MQCDC_VERSION_9" },
    {  "value":          9, "name": "MQCD_VERSION_9" },
    {  "value":          9, "name": "MQCFSTATUS_NEW" },
    {  "value":          9, "name": "MQCFT_BYTE_STRING" },
    {  "value":          9, "name": "MQCHS_DISCONNECTED" },
    {  "value":          9, "name": "MQCHT_CLUSSDR" },
    {  "value":          9, "name": "MQCMD_CLEAR_Q" },
    {  "value":          9, "name": "MQCRC_TRANSID_NOT_AVAILABLE" },
    {  "value":          9, "name": "MQCXP_CURRENT_VERSION" },
    {  "value":          9, "name": "MQCXP_VERSION_9" },
    {  "value":          9, "name": "MQIA_INHIBIT_GET" },
    {  "value":          9, "name": "MQOPER_TRANSFORM" },
    {  "value":          9, "name": "MQOT_COMM_INFO" },
    {  "value":          9, "name": "MQRQ_CHANNEL_STOPPED_RETRY" },
    {  "value":          9, "name": "MQSECITEM_MXPROC" },
    {  "value":          9, "name": "MQSECSW_CONNECTION" },
    {  "value":          9, "name": "MQXC_MQBACK" },
    {  "value":          9, "name": "MQXF_PUT" },
    {  "value":          9, "name": "MQZID_ENUMERATE_AUTHORITY_DATA" },
    {  "value":         10, "name": "MQACT_REDUCE_LOG" },
    {  "value":         10, "name": "MQAT_CICS_VSE" },
    {  "value":         10, "name": "MQAUTH_INQUIRE" },
    {  "value":         10, "name": "MQCDC_VERSION_10" },
    {  "value":         10, "name": "MQCD_VERSION_10" },
    {  "value":         10, "name": "MQCFOP_CONTAINS" },
    {  "value":         10, "name": "MQCFT_TRACE_ROUTE" },
    {  "value":         10, "name": "MQCHT_MQTT" },
    {  "value":         10, "name": "MQCMD_COPY_Q" },
    {  "value":         10, "name": "MQIA_INHIBIT_PUT" },
    {  "value":         10, "name": "MQMCEV_NEW_SOURCE" },
    {  "value":         10, "name": "MQNPM_CLASS_HIGH" },
    {  "value":         10, "name": "MQOPER_PUBLISH" },
    {  "value":         10, "name": "MQOT_CF_STRUC" },
    {  "value":         10, "name": "MQRQ_CHANNEL_STOPPED_DISABLED" },
    {  "value":         10, "name": "MQSECITEM_MXQUEUE" },
    {  "value":         10, "name": "MQSECSW_SUBSYSTEM" },
    {  "value":         10, "name": "MQSYSP_TYPE_INITIAL" },
    {  "value":         10, "name": "MQUSAGE_DS_OLDEST_ACTIVE_UOW" },
    {  "value":         10, "name": "MQXC_MQCMIT" },
    {  "value":         10, "name": "MQXF_GET" },
    {  "value":         10, "name": "MQZID_AUTHENTICATE_USER" },
    {  "value":         10, "name": "MQ_APPL_FUNCTION_NAME_LENGTH" },
    {  "value":         11, "name": "MQACT_ARCHIVE_LOG" },
    {  "value":         11, "name": "MQAT_WINDOWS_NT" },
    {  "value":         11, "name": "MQAUTH_OUTPUT" },
    {  "value":         11, "name": "MQCDC_VERSION_11" },
    {  "value":         11, "name": "MQCD_VERSION_11" },
    {  "value":         11, "name": "MQCHT_AMQP" },
    {  "value":         11, "name": "MQCMDI_RECOVER_STARTED" },
    {  "value":         11, "name": "MQCMD_CREATE_Q" },
    {  "value":         11, "name": "MQIA_MAX_HANDLES" },
    {  "value":         11, "name": "MQMCEV_RECEIVE_QUEUE_TRIMMED" },
    {  "value":         11, "name": "MQOPER_EXCLUDED_PUBLISH" },
    {  "value":         11, "name": "MQOT_LISTENER" },
    {  "value":         11, "name": "MQPL_WINDOWS_NT" },
    {  "value":         11, "name": "MQRQ_BRIDGE_STOPPED_OK" },
    {  "value":         11, "name": "MQSECITEM_MXTOPIC" },
    {  "value":         11, "name": "MQSECSW_COMMAND_RESOURCES" },
    {  "value":         11, "name": "MQSYSP_TYPE_SET" },
    {  "value":         11, "name": "MQUSAGE_DS_OLDEST_PS_RECOVERY" },
    {  "value":         11, "name": "MQXF_DATA_CONV_ON_GET" },
    {  "value":         11, "name": "MQXR_INIT" },
    {  "value":         11, "name": "MQXT_CHANNEL_SEC_EXIT" },
    {  "value":         11, "name": "MQZID_FREE_USER" },
    {  "value":         12, "name": "MQAT_VMS" },
    {  "value":         12, "name": "MQAUTH_PASS_ALL_CONTEXT" },
    {  "value":         12, "name": "MQBMHO_CURRENT_LENGTH" },
    {  "value":         12, "name": "MQBMHO_LENGTH_1" },
    {  "value":         12, "name": "MQBO_CURRENT_LENGTH" },
    {  "value":         12, "name": "MQBO_LENGTH_1" },
    {  "value":         12, "name": "MQCDC_CURRENT_VERSION" },
    {  "value":         12, "name": "MQCDC_VERSION_12" },
    {  "value":         12, "name": "MQCD_CURRENT_VERSION" },
    {  "value":         12, "name": "MQCD_VERSION_12" },
    {  "value":         12, "name": "MQCFT_REPORT" },
    {  "value":         12, "name": "MQCMDI_BACKUP_STARTED" },
    {  "value":         12, "name": "MQCMD_DELETE_Q" },
    {  "value":         12, "name": "MQCMHO_CURRENT_LENGTH" },
    {  "value":         12, "name": "MQCMHO_LENGTH_1" },
    {  "value":         12, "name": "MQCNO_LENGTH_1" },
    {  "value":         12, "name": "MQDMHO_CURRENT_LENGTH" },
    {  "value":         12, "name": "MQDMHO_LENGTH_1" },
    {  "value":         12, "name": "MQDMPO_CURRENT_LENGTH" },
    {  "value":         12, "name": "MQDMPO_LENGTH_1" },
    {  "value":         12, "name": "MQIA_USAGE" },
    {  "value":         12, "name": "MQMCEV_PACKET_LOSS_NACK_EXPIRE" },
    {  "value":         12, "name": "MQMHBO_CURRENT_LENGTH" },
    {  "value":         12, "name": "MQMHBO_LENGTH_1" },
    {  "value":         12, "name": "MQOPER_DISCARDED_PUBLISH" },
    {  "value":         12, "name": "MQOT_SERVICE" },
    {  "value":         12, "name": "MQPL_VMS" },
    {  "value":         12, "name": "MQRQ_BRIDGE_STOPPED_ERROR" },
    {  "value":         12, "name": "MQSYSP_TYPE_LOG_COPY" },
    {  "value":         12, "name": "MQUSAGE_DS_OLDEST_CF_RECOVERY" },
    {  "value":         12, "name": "MQXF_INQ" },
    {  "value":         12, "name": "MQXR_TERM" },
    {  "value":         12, "name": "MQXT_CHANNEL_MSG_EXIT" },
    {  "value":         12, "name": "MQZID_INQUIRE" },
    {  "value":         12, "name": "MQ_CF_LEID_LENGTH" },
    {  "value":         12, "name": "MQ_CF_STRUC_NAME_LENGTH" },
    {  "value":         12, "name": "MQ_CHANNEL_DATE_LENGTH" },
    {  "value":         12, "name": "MQ_CREATION_DATE_LENGTH" },
    {  "value":         12, "name": "MQ_DATE_LENGTH" },
    {  "value":         12, "name": "MQ_LRSN_LENGTH" },
    {  "value":         12, "name": "MQ_MCA_USER_ID_LENGTH" },
    {  "value":         12, "name": "MQ_PASSWORD_LENGTH" },
    {  "value":         12, "name": "MQ_USER_ID_LENGTH" },
    {  "value":         13, "name": "MQAT_GUARDIAN" },
    {  "value":         13, "name": "MQAT_NSK" },
    {  "value":         13, "name": "MQAUTH_PASS_IDENTITY_CONTEXT" },
    {  "value":         13, "name": "MQCFOP_EXCLUDES" },
    {  "value":         13, "name": "MQCFT_INTEGER_FILTER" },
    {  "value":         13, "name": "MQCHS_INITIALIZING" },
    {  "value":         13, "name": "MQCMDI_RECOVER_COMPLETED" },
    {  "value":         13, "name": "MQCMD_INQUIRE_Q" },
    {  "value":         13, "name": "MQIA_MAX_MSG_LENGTH" },
    {  "value":         13, "name": "MQMCEV_ACK_RETRIES_EXCEEDED" },
    {  "value":         13, "name": "MQPL_NSK" },
    {  "value":         13, "name": "MQPL_NSS" },
    {  "value":         13, "name": "MQRQ_SSL_HANDSHAKE_ERROR" },
    {  "value":         13, "name": "MQSYSP_TYPE_LOG_STATUS" },
    {  "value":         13, "name": "MQXF_SET" },
    {  "value":         13, "name": "MQXR_MSG" },
    {  "value":         13, "name": "MQXT_CHANNEL_SEND_EXIT" },
    {  "value":         13, "name": "MQZID_CHECK_PRIVILEGED" },
    {  "value":         14, "name": "MQAT_VOS" },
    {  "value":         14, "name": "MQAUTH_SET" },
    {  "value":         14, "name": "MQCFT_STRING_FILTER" },
    {  "value":         14, "name": "MQCHS_SWITCHING" },
    {  "value":         14, "name": "MQCMDI_SEC_TIMER_ZERO" },
    {  "value":         14, "name": "MQIA_MAX_PRIORITY" },
    {  "value":         14, "name": "MQMCEV_STREAM_SUSPEND_NACK" },
    {  "value":         14, "name": "MQRQ_SSL_CIPHER_SPEC_ERROR" },
    {  "value":         14, "name": "MQSYSP_TYPE_ARCHIVE_TAPE" },
    {  "value":         14, "name": "MQXF_BEGIN" },
    {  "value":         14, "name": "MQXR_XMIT" },
    {  "value":         14, "name": "MQXT_CHANNEL_RCV_EXIT" },
    {  "value":         15, "name": "MQAT_OPEN_TP1" },
    {  "value":         15, "name": "MQAUTH_SET_ALL_CONTEXT" },
    {  "value":         15, "name": "MQCFT_BYTE_STRING_FILTER" },
    {  "value":         15, "name": "MQENC_INTEGER_MASK" },
    {  "value":         15, "name": "MQIA_MAX_Q_DEPTH" },
    {  "value":         15, "name": "MQMCEV_STREAM_RESUME_NACK" },
    {  "value":         15, "name": "MQPL_OPEN_TP1" },
    {  "value":         15, "name": "MQRQ_SSL_CLIENT_AUTH_ERROR" },
    {  "value":         15, "name": "MQSECSW_Q_MGR" },
    {  "value":         15, "name": "MQXF_CMIT" },
    {  "value":         15, "name": "MQXR_SEC_MSG" },
    {  "value":         15, "name": "MQXT_CHANNEL_MSG_RETRY_EXIT" },
    {  "value":         16, "name": "MQADOPT_TYPE_CLUSRCVR" },
    {  "value":         16, "name": "MQAUTHOPT_NAME_EXPLICIT" },
    {  "value":         16, "name": "MQAUTH_SET_IDENTITY_CONTEXT" },
    {  "value":         16, "name": "MQCADSD_RECV" },
    {  "value":         16, "name": "MQCBO_COMMAND_BAG" },
    {  "value":         16, "name": "MQCFBS_STRUC_LENGTH_FIXED" },
    {  "value":         16, "name": "MQCFGR_STRUC_LENGTH" },
    {  "value":         16, "name": "MQCFIL64_STRUC_LENGTH_FIXED" },
    {  "value":         16, "name": "MQCFIL_STRUC_LENGTH_FIXED" },
    {  "value":         16, "name": "MQCFIN_STRUC_LENGTH" },
    {  "value":         16, "name": "MQCFT_COMMAND_XR" },
    {  "value":         16, "name": "MQCMDI_REFRESH_CONFIGURATION" },
    {  "value":         16, "name": "MQCMD_REFRESH_Q_MGR" },
    {  "value":         16, "name": "MQCNO_RESTRICT_CONN_TAG_QSG" },
    {  "value":         16, "name": "MQCOMPRESS_LZ4FAST" },
    {  "value":         16, "name": "MQCOPY_REPORT" },
    {  "value":         16, "name": "MQCUOWC_MIDDLE" },
    {  "value":         16, "name": "MQDCC_SOURCE_ENC_FACTOR" },
    {  "value":         16, "name": "MQDCC_SOURCE_ENC_NORMAL" },
    {  "value":         16, "name": "MQENC_DECIMAL_NORMAL" },
    {  "value":         16, "name": "MQGMO_BROWSE_FIRST" },
    {  "value":         16, "name": "MQIA_MSG_DELIVERY_SEQUENCE" },
    {  "value":         16, "name": "MQIIH_IGNORE_PURG" },
    {  "value":         16, "name": "MQIMPO_INQ_PROP_UNDER_CURSOR" },
    {  "value":         16, "name": "MQMCEV_STREAM_EXPELLED" },
    {  "value":         16, "name": "MQMF_LAST_MSG_IN_GROUP" },
    {  "value":         16, "name": "MQMO_MATCH_OFFSET" },
    {  "value":         16, "name": "MQOO_OUTPUT" },
    {  "value":         16, "name": "MQPMRF_ACCOUNTING_TOKEN" },
    {  "value":         16, "name": "MQPUBO_IS_RETAINED_PUBLICATION" },
    {  "value":         16, "name": "MQQMF_CLUSSDR_AUTO_DEFINED" },
    {  "value":         16, "name": "MQREGO_NEW_PUBLICATIONS_ONLY" },
    {  "value":         16, "name": "MQRQ_SSL_PEER_NAME_ERROR" },
    {  "value":         16, "name": "MQSECSW_QSG" },
    {  "value":         16, "name": "MQSO_GROUP_SUB" },
    {  "value":         16, "name": "MQSRO_CURRENT_LENGTH" },
    {  "value":         16, "name": "MQSRO_LENGTH_1" },
    {  "value":         16, "name": "MQTYPE_INT8" },
    {  "value":         16, "name": "MQXF_BACK" },
    {  "value":         16, "name": "MQXR2_SUPPRESS_CHAIN" },
    {  "value":         16, "name": "MQXR_INIT_SEC" },
    {  "value":         16, "name": "MQXT_CHANNEL_AUTO_DEF_EXIT" },
    {  "value":         16, "name": "MQZAO_INQUIRE" },
    {  "value":         16, "name": "MQ_EXIT_USER_AREA_LENGTH" },
    {  "value":         16, "name": "MQ_INSTALLATION_NAME_LENGTH" },
    {  "value":         16, "name": "MQ_LUWID_LENGTH" },
    {  "value":         16, "name": "MQ_MSG_TOKEN_LENGTH" },
    {  "value":         16, "name": "MQ_RBA_LENGTH" },
    {  "value":         16, "name": "MQ_TRAN_INSTANCE_ID_LENGTH" },
    {  "value":         16, "name": "MQ_XCF_MEMBER_NAME_LENGTH" },
    {  "value":         17, "name": "MQAUTH_CONTROL" },
    {  "value":         17, "name": "MQCFT_XR_MSG" },
    {  "value":         17, "name": "MQCMDI_SEC_SIGNOFF_ERROR" },
    {  "value":         17, "name": "MQCMD_RESET_Q_STATS" },
    {  "value":         17, "name": "MQCUOWC_FIRST" },
    {  "value":         17, "name": "MQIA_OPEN_INPUT_COUNT" },
    {  "value":         17, "name": "MQMON_LOW" },
    {  "value":         17, "name": "MQRQ_SUB_NOT_AUTHORIZED" },
    {  "value":         17, "name": "MQXR_RETRY" },
    {  "value":         18, "name": "MQAT_VM" },
    {  "value":         18, "name": "MQAUTH_CONTROL_EXTENDED" },
    {  "value":         18, "name": "MQCFOP_LIKE" },
    {  "value":         18, "name": "MQCFT_XR_ITEM" },
    {  "value":         18, "name": "MQCMDI_IMS_BRIDGE_SUSPENDED" },
    {  "value":         18, "name": "MQCMD_INQUIRE_Q_NAMES" },
    {  "value":         18, "name": "MQIA_OPEN_OUTPUT_COUNT" },
    {  "value":         18, "name": "MQPL_VM" },
    {  "value":         18, "name": "MQRQ_SUB_DEST_NOT_AUTHORIZED" },
    {  "value":         18, "name": "MQXF_STAT" },
    {  "value":         18, "name": "MQXR_AUTO_CLUSSDR" },
    {  "value":         18, "name": "MQ_DNS_GROUP_NAME_LENGTH" },
    {  "value":         19, "name": "MQAT_IMS_BRIDGE" },
    {  "value":         19, "name": "MQAUTH_PUBLISH" },
    {  "value":         19, "name": "MQCFT_XR_SUMMARY" },
    {  "value":         19, "name": "MQCMDI_DB2_SUSPENDED" },
    {  "value":         19, "name": "MQCMD_INQUIRE_PROCESS_NAMES" },
    {  "value":         19, "name": "MQIA_NAME_COUNT" },
    {  "value":         19, "name": "MQRQ_SSL_UNKNOWN_REVOCATION" },
    {  "value":         19, "name": "MQXF_CB" },
    {  "value":         19, "name": "MQXR_AUTO_RECEIVER" },
    {  "value":         20, "name": "MQAT_XCF" },
    {  "value":         20, "name": "MQAUTH_SUBSCRIBE" },
    {  "value":         20, "name": "MQBNO_CURRENT_LENGTH" },
    {  "value":         20, "name": "MQBNO_LENGTH_1" },
    {  "value":         20, "name": "MQCFBF_STRUC_LENGTH_FIXED" },
    {  "value":         20, "name": "MQCFIF_STRUC_LENGTH" },
    {  "value":         20, "name": "MQCFSTATUS_ADMIN_INCOMPLETE" },
    {  "value":         20, "name": "MQCFST_STRUC_LENGTH_FIXED" },
    {  "value":         20, "name": "MQCFT_GROUP" },
    {  "value":         20, "name": "MQCMDI_DB2_OBSOLETE_MSGS" },
    {  "value":         20, "name": "MQCMD_INQUIRE_CHANNEL_NAMES" },
    {  "value":         20, "name": "MQCNO_LENGTH_2 (4 byte)" },
    {  "value":         20, "name": "MQCTLO_CURRENT_LENGTH (4 byte)" },
    {  "value":         20, "name": "MQCTLO_LENGTH_1 (4 byte)" },
    {  "value":         20, "name": "MQIA_Q_TYPE" },
    {  "value":         20, "name": "MQMCEV_FIRST_MESSAGE" },
    {  "value":         20, "name": "MQRQ_SYS_CONN_NOT_AUTHORIZED" },
    {  "value":         20, "name": "MQSMPO_CURRENT_LENGTH" },
    {  "value":         20, "name": "MQSMPO_LENGTH_1" },
    {  "value":         20, "name": "MQSYSP_ALLOC_BLK" },
    {  "value":         20, "name": "MQXF_CTL" },
    {  "value":         20, "name": "MQXR_CLWL_OPEN" },
    {  "value":         20, "name": "MQXT_CLUSTER_WORKLOAD_EXIT" },
    {  "value":         20, "name": "MQZFP_CURRENT_LENGTH (4 byte)" },
    {  "value":         20, "name": "MQZFP_LENGTH_1 (4 byte)" },
    {  "value":         20, "name": "MQ_CHANNEL_NAME_LENGTH" },
    {  "value":         20, "name": "MQ_MCA_NAME_LENGTH" },
    {  "value":         20, "name": "MQ_PROGRAM_NAME_LENGTH" },
    {  "value":         20, "name": "MQ_SHORT_CONN_NAME_LENGTH" },
    {  "value":         21, "name": "MQAT_CICS_BRIDGE" },
    {  "value":         21, "name": "MQAUTH_RESUME" },
    {  "value":         21, "name": "MQCFOP_NOT_LIKE" },
    {  "value":         21, "name": "MQCFSTATUS_NEVER_USED" },
    {  "value":         21, "name": "MQCFT_STATISTICS" },
    {  "value":         21, "name": "MQCMDI_SEC_UPPERCASE" },
    {  "value":         21, "name": "MQCMD_CHANGE_CHANNEL" },
    {  "value":         21, "name": "MQIA_RETENTION_INTERVAL" },
    {  "value":         21, "name": "MQMCEV_LATE_JOIN_FAILURE" },
    {  "value":         21, "name": "MQRQ_CHANNEL_BLOCKED_ADDRESS" },
    {  "value":         21, "name": "MQSECSW_OFF_FOUND" },
    {  "value":         21, "name": "MQSYSP_ALLOC_TRK" },
    {  "value":         21, "name": "MQXF_CALLBACK" },
    {  "value":         21, "name": "MQXR_CLWL_PUT" },
    {  "value":         21, "name": "MQXT_PUBSUB_ROUTING_EXIT" },
    {  "value":         22, "name": "MQAT_NOTES_AGENT" },
    {  "value":         22, "name": "MQAUTH_SYSTEM" },
    {  "value":         22, "name": "MQCFSTATUS_NO_BACKUP" },
    {  "value":         22, "name": "MQCFT_ACCOUNTING" },
    {  "value":         22, "name": "MQCMDI_SEC_MIXEDCASE" },
    {  "value":         22, "name": "MQCMD_COPY_CHANNEL" },
    {  "value":         22, "name": "MQCOPY_DEFAULT" },
    {  "value":         22, "name": "MQIA_BACKOUT_THRESHOLD" },
    {  "value":         22, "name": "MQMCEV_MESSAGE_LOSS" },
    {  "value":         22, "name": "MQRQ_CHANNEL_BLOCKED_USERID" },
    {  "value":         22, "name": "MQSECSW_ON_FOUND" },
    {  "value":         22, "name": "MQSYSP_ALLOC_CYL" },
    {  "value":         22, "name": "MQXF_SUB" },
    {  "value":         22, "name": "MQXR_CLWL_MOVE" },
    {  "value":         22, "name": "MQXT_PUBLISH_EXIT" },
    {  "value":         23, "name": "MQAT_TPF" },
    {  "value":         23, "name": "MQCFSTATUS_NOT_FAILED" },
    {  "value":         23, "name": "MQCFT_INTEGER64" },
    {  "value":         23, "name": "MQCMD_CREATE_CHANNEL" },
    {  "value":         23, "name": "MQIA_SHAREABILITY" },
    {  "value":         23, "name": "MQMCEV_SEND_PACKET_FAILURE" },
    {  "value":         23, "name": "MQPL_TPF" },
    {  "value":         23, "name": "MQRQ_CHANNEL_BLOCKED_NOACCESS" },
    {  "value":         23, "name": "MQSECSW_OFF_NOT_FOUND" },
    {  "value":         23, "name": "MQXF_SUBRQ" },
    {  "value":         23, "name": "MQXR_CLWL_REPOS" },
    {  "value":         23, "name": "MQXT_PRECONNECT_EXIT" },
    {  "value":         23, "name": "MQ_CLIENT_ID_LENGTH" },
    {  "value":         24, "name": "MQCFIN64_STRUC_LENGTH" },
    {  "value":         24, "name": "MQCFSF_STRUC_LENGTH_FIXED" },
    {  "value":         24, "name": "MQCFSL_STRUC_LENGTH_FIXED" },
    {  "value":         24, "name": "MQCFSTATUS_NOT_RECOVERABLE" },
    {  "value":         24, "name": "MQCMD_DELETE_CHANNEL" },
    {  "value":         24, "name": "MQCNO_LENGTH_2 (8 byte)" },
    {  "value":         24, "name": "MQCTLO_CURRENT_LENGTH (8 byte)" },
    {  "value":         24, "name": "MQCTLO_LENGTH_1 (8 byte)" },
    {  "value":         24, "name": "MQIA_TRIGGER_CONTROL" },
    {  "value":         24, "name": "MQMCEV_REPAIR_DELAY" },
    {  "value":         24, "name": "MQPD_CURRENT_LENGTH" },
    {  "value":         24, "name": "MQPD_LENGTH_1" },
    {  "value":         24, "name": "MQRQ_MAX_ACTIVE_CHANNELS" },
    {  "value":         24, "name": "MQSECSW_ON_NOT_FOUND" },
    {  "value":         24, "name": "MQXF_XACLOSE" },
    {  "value":         24, "name": "MQXR_CLWL_REPOS_MOVE" },
    {  "value":         24, "name": "MQXWD_CURRENT_LENGTH" },
    {  "value":         24, "name": "MQXWD_LENGTH_1" },
    {  "value":         24, "name": "MQZFP_CURRENT_LENGTH (8 byte)" },
    {  "value":         24, "name": "MQZFP_LENGTH_1 (8 byte)" },
    {  "value":         24, "name": "MQ_BRIDGE_NAME_LENGTH" },
    {  "value":         24, "name": "MQ_CONNECTION_ID_LENGTH" },
    {  "value":         24, "name": "MQ_CORREL_ID_LENGTH" },
    {  "value":         24, "name": "MQ_GROUP_ID_LENGTH" },
    {  "value":         24, "name": "MQ_LOG_EXTENT_NAME_LENGTH" },
    {  "value":         24, "name": "MQ_MSG_ID_LENGTH" },
    {  "value":         24, "name": "MQ_OBJECT_INSTANCE_ID_LENGTH" },
    {  "value":         24, "name": "MQ_RESPONSE_ID_LENGTH" },
    {  "value":         25, "name": "MQAT_USER" },
    {  "value":         25, "name": "MQCFSTATUS_XES_ERROR" },
    {  "value":         25, "name": "MQCFT_INTEGER64_LIST" },
    {  "value":         25, "name": "MQCMD_INQUIRE_CHANNEL" },
    {  "value":         25, "name": "MQIA_TRIGGER_INTERVAL" },
    {  "value":         25, "name": "MQMCEV_MEMORY_ALERT_ON" },
    {  "value":         25, "name": "MQRQ_MAX_CHANNELS" },
    {  "value":         25, "name": "MQSECSW_OFF_ERROR" },
    {  "value":         25, "name": "MQXF_XACOMMIT" },
    {  "value":         25, "name": "MQXR_END_BATCH" },
    {  "value":         26, "name": "MQAT_BROKER" },
    {  "value":         26, "name": "MQAT_QMGR_PUBLISH" },
    {  "value":         26, "name": "MQCFOP_CONTAINS_GEN" },
    {  "value":         26, "name": "MQCFT_APP_ACTIVITY" },
    {  "value":         26, "name": "MQCMD_PING_CHANNEL" },
    {  "value":         26, "name": "MQIA_TRIGGER_MSG_PRIORITY" },
    {  "value":         26, "name": "MQMCEV_MEMORY_ALERT_OFF" },
    {  "value":         26, "name": "MQRQ_SVRCONN_INST_LIMIT" },
    {  "value":         26, "name": "MQSECSW_ON_OVERRIDDEN" },
    {  "value":         26, "name": "MQXF_XACOMPLETE" },
    {  "value":         26, "name": "MQXR_ACK_RECEIVED" },
    {  "value":         27, "name": "MQCFT_STATUS" },
    {  "value":         27, "name": "MQCMD_RESET_CHANNEL" },
    {  "value":         27, "name": "MQIA_CPI_LEVEL" },
    {  "value":         27, "name": "MQMCEV_NACK_ALERT_ON" },
    {  "value":         27, "name": "MQPL_VSE" },
    {  "value":         27, "name": "MQRQ_CLIENT_INST_LIMIT" },
    {  "value":         27, "name": "MQXF_XAEND" },
    {  "value":         27, "name": "MQXR_AUTO_SVRCONN" },
    {  "value":         28, "name": "MQAT_JAVA" },
    {  "value":         28, "name": "MQCMD_START_CHANNEL" },
    {  "value":         28, "name": "MQIA_TRIGGER_TYPE" },
    {  "value":         28, "name": "MQMCEV_NACK_ALERT_OFF" },
    {  "value":         28, "name": "MQPBC_LENGTH_1 (4 byte)" },
    {  "value":         28, "name": "MQPL_APPLIANCE" },
    {  "value":         28, "name": "MQRQ_CAF_NOT_INSTALLED" },
    {  "value":         28, "name": "MQXF_XAFORGET" },
    {  "value":         28, "name": "MQXR_AUTO_CLUSRCVR" },
    {  "value":         28, "name": "MQ_APPL_NAME_LENGTH" },
    {  "value":         28, "name": "MQ_APPL_TAG_LENGTH" },
    {  "value":         28, "name": "MQ_MCA_JOB_NAME_LENGTH" },
    {  "value":         28, "name": "MQ_PUT_APPL_NAME_LENGTH" },
    {  "value":         29, "name": "MQAT_DQM" },
    {  "value":         29, "name": "MQCFOP_EXCLUDES_GEN" },
    {  "value":         29, "name": "MQCMD_STOP_CHANNEL" },
    {  "value":         29, "name": "MQIA_TRIGGER_DEPTH" },
    {  "value":         29, "name": "MQMCEV_REPAIR_ALERT_ON" },
    {  "value":         29, "name": "MQRQ_CSP_NOT_AUTHORIZED" },
    {  "value":         29, "name": "MQXF_XAOPEN" },
    {  "value":         29, "name": "MQXR_SEC_PARMS" },
    {  "value":         30, "name": "MQAT_CHANNEL_INITIATOR" },
    {  "value":         30, "name": "MQCMD_START_CHANNEL_INIT" },
    {  "value":         30, "name": "MQIA_SYNCPOINT" },
    {  "value":         30, "name": "MQMCEV_REPAIR_ALERT_OFF" },
    {  "value":         30, "name": "MQRQ_FAILOVER_PERMITTED" },
    {  "value":         30, "name": "MQSYSP_STATUS_BUSY" },
    {  "value":         30, "name": "MQXF_XAPREPARE" },
    {  "value":         30, "name": "MQXR_PUBLICATION" },
    {  "value":         31, "name": "MQAT_WLM" },
    {  "value":         31, "name": "MQCMD_START_CHANNEL_LISTENER" },
    {  "value":         31, "name": "MQIA_COMMAND_LEVEL" },
    {  "value":         31, "name": "MQMCEV_RELIABILITY_CHANGED" },
    {  "value":         31, "name": "MQRQ_FAILOVER_NOT_PERMITTED" },
    {  "value":         31, "name": "MQSYSP_STATUS_PREMOUNT" },
    {  "value":         31, "name": "MQXF_XARECOVER" },
    {  "value":         31, "name": "MQXR_PRECONNECT" },
    {  "value":         32, "name": "MQAT_BATCH" },
    {  "value":         32, "name": "MQAUTHOPT_NAME_ALL_MATCHING" },
    {  "value":         32, "name": "MQCBO_SYSTEM_BAG" },
    {  "value":         32, "name": "MQCMD_CHANGE_NAMELIST" },
    {  "value":         32, "name": "MQCNO_HANDLE_SHARE_NONE" },
    {  "value":         32, "name": "MQCOMPRESS_LZ4HIGH" },
    {  "value":         32, "name": "MQCO_QUIESCE" },
    {  "value":         32, "name": "MQDCC_SOURCE_ENC_NATIVE" },
    {  "value":         32, "name": "MQDCC_SOURCE_ENC_REVERSED" },
    {  "value":         32, "name": "MQENC_DECIMAL_REVERSED" },
    {  "value":         32, "name": "MQGMO_BROWSE_NEXT" },
    {  "value":         32, "name": "MQIA_PLATFORM" },
    {  "value":         32, "name": "MQIIH_CM0_REQUEST_RESPONSE" },
    {  "value":         32, "name": "MQIMPO_CONVERT_VALUE" },
    {  "value":         32, "name": "MQMO_MATCH_MSG_TOKEN" },
    {  "value":         32, "name": "MQOO_INQUIRE" },
    {  "value":         32, "name": "MQPBC_CURRENT_LENGTH (4 byte)" },
    {  "value":         32, "name": "MQPBC_LENGTH_1 (8 byte)" },
    {  "value":         32, "name": "MQPBC_LENGTH_2 (4 byte)" },
    {  "value":         32, "name": "MQPMO_DEFAULT_CONTEXT" },
    {  "value":         32, "name": "MQQMF_AVAILABLE" },
    {  "value":         32, "name": "MQREGO_PUBLISH_ON_REQUEST_ONLY" },
    {  "value":         32, "name": "MQRFH_CURRENT_LENGTH" },
    {  "value":         32, "name": "MQRFH_LENGTH_1" },
    {  "value":         32, "name": "MQRFH_STRUC_LENGTH_FIXED" },
    {  "value":         32, "name": "MQROUTE_DETAIL_HIGH" },
    {  "value":         32, "name": "MQRQ_STANDBY_ACTIVATED" },
    {  "value":         32, "name": "MQSO_MANAGED" },
    {  "value":         32, "name": "MQSYSP_STATUS_AVAILABLE" },
    {  "value":         32, "name": "MQTYPE_INT16" },
    {  "value":         32, "name": "MQXEPO_CURRENT_LENGTH (4 byte)" },
    {  "value":         32, "name": "MQXEPO_LENGTH_1 (4 byte)" },
    {  "value":         32, "name": "MQXF_XAROLLBACK" },
    {  "value":         32, "name": "MQXR2_DYNAMIC_CACHE" },
    {  "value":         32, "name": "MQZAO_SET" },
    {  "value":         32, "name": "MQ_ACCOUNTING_TOKEN_LENGTH" },
    {  "value":         32, "name": "MQ_APPL_IDENTITY_DATA_LENGTH" },
    {  "value":         32, "name": "MQ_CHINIT_SERVICE_PARM_LENGTH" },
    {  "value":         32, "name": "MQ_EXIT_DATA_LENGTH" },
    {  "value":         32, "name": "MQ_LDAP_PASSWORD_LENGTH" },
    {  "value":         32, "name": "MQ_MCA_USER_DATA_LENGTH" },
    {  "value":         32, "name": "MQ_SERVICE_NAME_LENGTH" },
    {  "value":         32, "name": "MQ_SSL_CIPHER_SPEC_LENGTH" },
    {  "value":         32, "name": "MQ_SSL_CIPHER_SUITE_LENGTH" },
    {  "value":         32, "name": "MQ_SSL_HANDSHAKE_STAGE_LENGTH" },
    {  "value":         32, "name": "MQ_SYSP_SERVICE_LENGTH" },
    {  "value":         32, "name": "MQ_TEMPORARY_Q_PREFIX_LENGTH" },
    {  "value":         33, "name": "MQAT_RRS_BATCH" },
    {  "value":         33, "name": "MQCMD_COPY_NAMELIST" },
    {  "value":         33, "name": "MQIA_MAX_UNCOMMITTED_MSGS" },
    {  "value":         33, "name": "MQMON_MEDIUM" },
    {  "value":         33, "name": "MQRQ_REPLICA_ACTIVATED" },
    {  "value":         33, "name": "MQSYSP_STATUS_UNKNOWN" },
    {  "value":         33, "name": "MQXF_XASTART" },
    {  "value":         34, "name": "MQAT_SIB" },
    {  "value":         34, "name": "MQCMD_CREATE_NAMELIST" },
    {  "value":         34, "name": "MQIA_DIST_LISTS" },
    {  "value":         34, "name": "MQSYSP_STATUS_ALLOC_ARCHIVE" },
    {  "value":         34, "name": "MQXF_AXREG" },
    {  "value":         35, "name": "MQAT_SYSTEM_EXTENSION" },
    {  "value":         35, "name": "MQCMD_DELETE_NAMELIST" },
    {  "value":         35, "name": "MQIA_TIME_SINCE_RESET" },
    {  "value":         35, "name": "MQSYSP_STATUS_COPYING_BSDS" },
    {  "value":         35, "name": "MQXF_AXUNREG" },
    {  "value":         36, "name": "MQAT_MCAST_PUBLISH" },
    {  "value":         36, "name": "MQCFH_STRUC_LENGTH" },
    {  "value":         36, "name": "MQCMD_INQUIRE_NAMELIST" },
    {  "value":         36, "name": "MQIA_HIGH_Q_DEPTH" },
    {  "value":         36, "name": "MQRFH2_CURRENT_LENGTH" },
    {  "value":         36, "name": "MQRFH2_LENGTH_2" },
    {  "value":         36, "name": "MQRFH_STRUC_LENGTH_FIXED_2" },
    {  "value":         36, "name": "MQSYSP_STATUS_COPYING_LOG" },
    {  "value":         36, "name": "MQ_ARCHIVE_PFX_LENGTH" },
    {  "value":         37, "name": "MQAT_AMQP" },
    {  "value":         37, "name": "MQCMD_INQUIRE_NAMELIST_NAMES" },
    {  "value":         37, "name": "MQIA_MSG_ENQ_COUNT" },
    {  "value":         38, "name": "MQCMD_ESCAPE" },
    {  "value":         38, "name": "MQIA_MSG_DEQ_COUNT" },
    {  "value":         39, "name": "MQCMD_RESOLVE_CHANNEL" },
    {  "value":         39, "name": "MQIA_EXPIRY_INTERVAL" },
    {  "value":         40, "name": "MQCMD_PING_Q_MGR" },
    {  "value":         40, "name": "MQIA_Q_DEPTH_HIGH_LIMIT" },
    {  "value":         40, "name": "MQPBC_CURRENT_LENGTH (8 byte)" },
    {  "value":         40, "name": "MQPBC_LENGTH_2 (8 byte)" },
    {  "value":         40, "name": "MQXEPO_CURRENT_LENGTH (8 byte)" },
    {  "value":         40, "name": "MQXEPO_LENGTH_1 (8 byte)" },
    {  "value":         40, "name": "MQ_SECURITY_ID_LENGTH" },
    {  "value":         40, "name": "MQ_SECURITY_PROFILE_LENGTH" },
    {  "value":         41, "name": "MQCMD_INQUIRE_Q_STATUS" },
    {  "value":         41, "name": "MQIA_Q_DEPTH_LOW_LIMIT" },
    {  "value":         42, "name": "MQCMD_INQUIRE_CHANNEL_STATUS" },
    {  "value":         42, "name": "MQIA_Q_DEPTH_MAX_EVENT" },
    {  "value":         42, "name": "MQXC_MQSUB" },
    {  "value":         43, "name": "MQCMD_CONFIG_EVENT" },
    {  "value":         43, "name": "MQIA_Q_DEPTH_HIGH_EVENT" },
    {  "value":         43, "name": "MQXC_MQSUBRQ" },
    {  "value":         44, "name": "MQCMD_Q_MGR_EVENT" },
    {  "value":         44, "name": "MQDXP_LENGTH_1" },
    {  "value":         44, "name": "MQIA_Q_DEPTH_LOW_EVENT" },
    {  "value":         44, "name": "MQXC_MQCB" },
    {  "value":         44, "name": "MQXP_CURRENT_LENGTH" },
    {  "value":         44, "name": "MQXP_LENGTH_1" },
    {  "value":         44, "name": "MQ_AUTO_REORG_CATALOG_LENGTH" },
    {  "value":         44, "name": "MQ_DATA_SET_NAME_LENGTH" },
    {  "value":         44, "name": "MQ_SSL_KEY_LIBRARY_LENGTH" },
    {  "value":         45, "name": "MQCMD_PERFM_EVENT" },
    {  "value":         45, "name": "MQIA_SCOPE" },
    {  "value":         45, "name": "MQXC_MQCTL" },
    {  "value":         46, "name": "MQCMD_CHANNEL_EVENT" },
    {  "value":         46, "name": "MQIA_Q_SERVICE_INTERVAL_EVENT" },
    {  "value":         46, "name": "MQXC_MQSTAT" },
    {  "value":         47, "name": "MQIA_AUTHORITY_EVENT" },
    {  "value":         48, "name": "MQCBC_LENGTH_1 (4 byte)" },
    {  "value":         48, "name": "MQCSP_LENGTH_1 (4 byte)" },
    {  "value":         48, "name": "MQDH_CURRENT_LENGTH" },
    {  "value":         48, "name": "MQDH_LENGTH_1" },
    {  "value":         48, "name": "MQDXP_CURRENT_LENGTH (4 byte)" },
    {  "value":         48, "name": "MQDXP_LENGTH_2 (4 byte)" },
    {  "value":         48, "name": "MQIA_INHIBIT_EVENT" },
    {  "value":         48, "name": "MQXC_CALLBACK" },
    {  "value":         48, "name": "MQ_AUTH_INFO_NAME_LENGTH" },
    {  "value":         48, "name": "MQ_AUTH_PROFILE_NAME_LENGTH" },
    {  "value":         48, "name": "MQ_CLUSTER_NAME_LENGTH" },
    {  "value":         48, "name": "MQ_COMM_INFO_NAME_LENGTH" },
    {  "value":         48, "name": "MQ_EXIT_INFO_NAME_LENGTH" },
    {  "value":         48, "name": "MQ_EXIT_PD_AREA_LENGTH" },
    {  "value":         48, "name": "MQ_IP_ADDRESS_LENGTH" },
    {  "value":         48, "name": "MQ_LISTENER_NAME_LENGTH" },
    {  "value":         48, "name": "MQ_LOCAL_ADDRESS_LENGTH" },
    {  "value":         48, "name": "MQ_NAMELIST_NAME_LENGTH" },
    {  "value":         48, "name": "MQ_NHA_GROUP_NAME_LENGTH" },
    {  "value":         48, "name": "MQ_NHA_INSTANCE_NAME_LENGTH" },
    {  "value":         48, "name": "MQ_OBJECT_NAME_LENGTH" },
    {  "value":         48, "name": "MQ_PROCESS_NAME_LENGTH" },
    {  "value":         48, "name": "MQ_Q_MGR_IDENTIFIER_LENGTH" },
    {  "value":         48, "name": "MQ_Q_MGR_NAME_LENGTH" },
    {  "value":         48, "name": "MQ_Q_NAME_LENGTH" },
    {  "value":         48, "name": "MQ_SERVICE_COMPONENT_LENGTH" },
    {  "value":         48, "name": "MQ_TOPIC_NAME_LENGTH" },
    {  "value":         49, "name": "MQIA_LOCAL_EVENT" },
    {  "value":         50, "name": "MQIA_REMOTE_EVENT" },
    {  "value":         51, "name": "MQIA_CONFIGURATION_EVENT" },
    {  "value":         52, "name": "MQCBC_CURRENT_LENGTH (4 byte)" },
    {  "value":         52, "name": "MQCBC_LENGTH_2 (4 byte)" },
    {  "value":         52, "name": "MQIA_START_STOP_EVENT" },
    {  "value":         52, "name": "MQNXP_LENGTH_1 (4 byte)" },
    {  "value":         53, "name": "MQIA_PERFORMANCE_EVENT" },
    {  "value":         54, "name": "MQIA_Q_SERVICE_INTERVAL" },
    {  "value":         55, "name": "MQIA_CHANNEL_AUTO_DEF" },
    {  "value":         56, "name": "MQCBC_LENGTH_1 (8 byte)" },
    {  "value":         56, "name": "MQCSP_LENGTH_1 (8 byte)" },
    {  "value":         56, "name": "MQDXP_CURRENT_LENGTH (8 byte)" },
    {  "value":         56, "name": "MQDXP_LENGTH_2 (8 byte)" },
    {  "value":         56, "name": "MQIA_CHANNEL_AUTO_DEF_EVENT" },
    {  "value":         56, "name": "MQNXP_CURRENT_LENGTH (4 byte)" },
    {  "value":         56, "name": "MQNXP_LENGTH_2 (4 byte)" },
    {  "value":         56, "name": "MQZED_LENGTH_1 (4 byte)" },
    {  "value":         57, "name": "MQIA_INDEX_TYPE" },
    {  "value":         58, "name": "MQIA_CLUSTER_WORKLOAD_LENGTH" },
    {  "value":         59, "name": "MQIA_CLUSTER_Q_TYPE" },
    {  "value":         60, "name": "MQCMD_DELETE_PUBLICATION" },
    {  "value":         60, "name": "MQIA_ARCHIVE" },
    {  "value":         60, "name": "MQIMPO_CURRENT_LENGTH (4 byte)" },
    {  "value":         60, "name": "MQIMPO_LENGTH_1 (4 byte)" },
    {  "value":         60, "name": "MQZED_CURRENT_LENGTH (4 byte)" },
    {  "value":         60, "name": "MQZED_LENGTH_2 (4 byte)" },
    {  "value":         61, "name": "MQCMD_DEREGISTER_PUBLISHER" },
    {  "value":         61, "name": "MQIA_DEF_BIND" },
    {  "value":         62, "name": "MQCMD_DEREGISTER_SUBSCRIBER" },
    {  "value":         62, "name": "MQIA_PAGESET_ID" },
    {  "value":         63, "name": "MQCMD_PUBLISH" },
    {  "value":         63, "name": "MQIA_QSG_DISP" },
    {  "value":         64, "name": "MQAUTHOPT_NAME_AS_WILDCARD" },
    {  "value":         64, "name": "MQCBC_CURRENT_LENGTH (8 byte)" },
    {  "value":         64, "name": "MQCBC_LENGTH_2 (8 byte)" },
    {  "value":         64, "name": "MQCBO_GROUP_BAG" },
    {  "value":         64, "name": "MQCMD_REGISTER_PUBLISHER" },
    {  "value":         64, "name": "MQCNO_HANDLE_SHARE_BLOCK" },
    {  "value":         64, "name": "MQGMO_ACCEPT_TRUNCATED_MSG" },
    {  "value":         64, "name": "MQIA_INTRA_GROUP_QUEUING" },
    {  "value":         64, "name": "MQIMPO_CURRENT_LENGTH (8 byte)" },
    {  "value":         64, "name": "MQIMPO_LENGTH_1 (8 byte)" },
    {  "value":         64, "name": "MQNXP_LENGTH_1 (8 byte)" },
    {  "value":         64, "name": "MQOO_SET" },
    {  "value":         64, "name": "MQPMO_NEW_MSG_ID" },
    {  "value":         64, "name": "MQQF_CLWL_USEQ_ANY" },
    {  "value":         64, "name": "MQREGO_DEREGISTER_ALL" },
    {  "value":         64, "name": "MQRO_PASS_CORREL_ID" },
    {  "value":         64, "name": "MQSO_SET_IDENTITY_CONTEXT" },
    {  "value":         64, "name": "MQTYPE_INT32" },
    {  "value":         64, "name": "MQTYPE_LONG" },
    {  "value":         64, "name": "MQZAO_PASS_IDENTITY_CONTEXT" },
    {  "value":         64, "name": "MQZED_LENGTH_1 (8 byte)" },
    {  "value":         64, "name": "MQ_APPL_DESC_LENGTH" },
    {  "value":         64, "name": "MQ_AUTH_INFO_DESC_LENGTH" },
    {  "value":         64, "name": "MQ_CERT_LABEL_LENGTH" },
    {  "value":         64, "name": "MQ_CF_STRUC_DESC_LENGTH" },
    {  "value":         64, "name": "MQ_CHANNEL_DESC_LENGTH" },
    {  "value":         64, "name": "MQ_CHLAUTH_DESC_LENGTH" },
    {  "value":         64, "name": "MQ_COMM_INFO_DESC_LENGTH" },
    {  "value":         64, "name": "MQ_INSTALLATION_DESC_LENGTH" },
    {  "value":         64, "name": "MQ_ISOTIME_LENGTH" },
    {  "value":         64, "name": "MQ_LISTENER_DESC_LENGTH" },
    {  "value":         64, "name": "MQ_LSN_LENGTH" },
    {  "value":         64, "name": "MQ_MAX_MCA_USER_ID_LENGTH" },
    {  "value":         64, "name": "MQ_MAX_USER_ID_LENGTH" },
    {  "value":         64, "name": "MQ_NAMELIST_DESC_LENGTH" },
    {  "value":         64, "name": "MQ_PROCESS_DESC_LENGTH" },
    {  "value":         64, "name": "MQ_Q_DESC_LENGTH" },
    {  "value":         64, "name": "MQ_Q_MGR_DESC_LENGTH" },
    {  "value":         64, "name": "MQ_SERVICE_DESC_LENGTH" },
    {  "value":         64, "name": "MQ_STORAGE_CLASS_DESC_LENGTH" },
    {  "value":         64, "name": "MQ_TOPIC_DESC_LENGTH" },
    {  "value":         64, "name": "MQ_TP_NAME_LENGTH" },
    {  "value":         64, "name": "MQ_TRIGGER_DATA_LENGTH" },
    {  "value":         65, "name": "MQCMD_REGISTER_SUBSCRIBER" },
    {  "value":         65, "name": "MQIA_IGQ_PUT_AUTHORITY" },
    {  "value":         65, "name": "MQMON_HIGH" },
    {  "value":         65, "name": "MQRQ_CONN_AUTHORIZED" },
    {  "value":         66, "name": "MQCMD_REQUEST_UPDATE" },
    {  "value":         66, "name": "MQIA_AUTH_INFO_TYPE" },
    {  "value":         66, "name": "MQRQ_OPEN_AUTHORIZED" },
    {  "value":         67, "name": "MQCMD_BROKER_INTERNAL" },
    {  "value":         67, "name": "MQRQ_SUB_AUTHORIZED" },
    {  "value":         68, "name": "MQACH_CURRENT_LENGTH (4 byte)" },
    {  "value":         68, "name": "MQACH_LENGTH_1 (4 byte)" },
    {  "value":         68, "name": "MQCSP_LENGTH_2 (4 byte)" },
    {  "value":         68, "name": "MQEPH_CURRENT_LENGTH" },
    {  "value":         68, "name": "MQEPH_LENGTH_1" },
    {  "value":         68, "name": "MQEPH_STRUC_LENGTH_FIXED" },
    {  "value":         68, "name": "MQIA_MSG_MARK_BROWSE_INTERVAL" },
    {  "value":         68, "name": "MQRQ_SUB_DEST_AUTHORIZED" },
    {  "value":         69, "name": "MQCMD_ACTIVITY_MSG" },
    {  "value":         69, "name": "MQIA_SSL_TASKS" },
    {  "value":         70, "name": "MQCMD_INQUIRE_CLUSTER_Q_MGR" },
    {  "value":         70, "name": "MQIA_CF_LEVEL" },
    {  "value":         71, "name": "MQCMD_RESUME_Q_MGR_CLUSTER" },
    {  "value":         71, "name": "MQIA_CF_RECOVER" },
    {  "value":         72, "name": "MQACH_CURRENT_LENGTH (8 byte)" },
    {  "value":         72, "name": "MQACH_LENGTH_1 (8 byte)" },
    {  "value":         72, "name": "MQCMD_SUSPEND_Q_MGR_CLUSTER" },
    {  "value":         72, "name": "MQGMO_LENGTH_1" },
    {  "value":         72, "name": "MQIA_NAMELIST_TYPE" },
    {  "value":         72, "name": "MQMDE_CURRENT_LENGTH" },
    {  "value":         72, "name": "MQMDE_LENGTH_2" },
    {  "value":         72, "name": "MQNXP_CURRENT_LENGTH (8 byte)" },
    {  "value":         72, "name": "MQNXP_LENGTH_2 (8 byte)" },
    {  "value":         72, "name": "MQZAD_LENGTH_1 (4 byte)" },
    {  "value":         72, "name": "MQZED_CURRENT_LENGTH (8 byte)" },
    {  "value":         72, "name": "MQZED_LENGTH_2 (8 byte)" },
    {  "value":         73, "name": "MQCMD_REFRESH_CLUSTER" },
    {  "value":         73, "name": "MQIA_CHANNEL_EVENT" },
    {  "value":         74, "name": "MQCMD_RESET_CLUSTER" },
    {  "value":         74, "name": "MQIA_BRIDGE_EVENT" },
    {  "value":         75, "name": "MQCMD_TRACE_ROUTE" },
    {  "value":         75, "name": "MQIA_SSL_EVENT" },
    {  "value":         76, "name": "MQIA_SSL_RESET_COUNT" },
    {  "value":         76, "name": "MQZAD_CURRENT_LENGTH (4 byte)" },
    {  "value":         76, "name": "MQZAD_LENGTH_2 (4 byte)" },
    {  "value":         77, "name": "MQIA_SHARED_Q_Q_MGR_NAME" },
    {  "value":         78, "name": "MQCMD_REFRESH_SECURITY" },
    {  "value":         78, "name": "MQIA_NPM_CLASS" },
    {  "value":         79, "name": "MQCMD_CHANGE_AUTH_INFO" },
    {  "value":         80, "name": "MQCMD_COPY_AUTH_INFO" },
    {  "value":         80, "name": "MQCSP_LENGTH_2 (8 byte)" },
    {  "value":         80, "name": "MQGMO_LENGTH_2" },
    {  "value":         80, "name": "MQIA_MAX_OPEN_Q" },
    {  "value":         80, "name": "MQMCEV_SHM_DEST_UNUSABLE" },
    {  "value":         80, "name": "MQZAD_CURRENT_LENGTH (8 byte)" },
    {  "value":         80, "name": "MQZAD_LENGTH_1 (8 byte)" },
    {  "value":         80, "name": "MQZAD_LENGTH_2 (8 byte)" },
    {  "value":         81, "name": "MQCMD_CREATE_AUTH_INFO" },
    {  "value":         81, "name": "MQIA_MONITOR_INTERVAL" },
    {  "value":         81, "name": "MQMCEV_SHM_PORT_UNUSABLE" },
    {  "value":         82, "name": "MQCMD_DELETE_AUTH_INFO" },
    {  "value":         82, "name": "MQIA_Q_USERS" },
    {  "value":         83, "name": "MQCMD_INQUIRE_AUTH_INFO" },
    {  "value":         83, "name": "MQIA_MAX_GLOBAL_LOCKS" },
    {  "value":         84, "name": "MQCMD_INQUIRE_AUTH_INFO_NAMES" },
    {  "value":         84, "name": "MQIA_MAX_LOCAL_LOCKS" },
    {  "value":         84, "name": "MQIIH_CURRENT_LENGTH" },
    {  "value":         84, "name": "MQIIH_LENGTH_1" },
    {  "value":         84, "name": "MQZAC_CURRENT_LENGTH" },
    {  "value":         84, "name": "MQZAC_LENGTH_1" },
    {  "value":         84, "name": "MQZIC_LENGTH_1" },
    {  "value":         85, "name": "MQCMD_INQUIRE_CONNECTION" },
    {  "value":         85, "name": "MQIA_LISTENER_PORT_NUMBER" },
    {  "value":         86, "name": "MQCMD_STOP_CONNECTION" },
    {  "value":         86, "name": "MQIA_BATCH_INTERFACE_AUTO" },
    {  "value":         87, "name": "MQCMD_INQUIRE_AUTH_RECS" },
    {  "value":         87, "name": "MQIA_CMD_SERVER_AUTO" },
    {  "value":         88, "name": "MQCMD_INQUIRE_ENTITY_AUTH" },
    {  "value":         88, "name": "MQCSP_CURRENT_LENGTH (4 byte)" },
    {  "value":         88, "name": "MQCSP_LENGTH_3 (4 byte)" },
    {  "value":         88, "name": "MQIA_CMD_SERVER_CONVERT_MSG" },
    {  "value":         89, "name": "MQCMD_DELETE_AUTH_REC" },
    {  "value":         89, "name": "MQIA_CMD_SERVER_DLQ_MSG" },
    {  "value":         90, "name": "MQCMD_SET_AUTH_REC" },
    {  "value":         90, "name": "MQIA_MAX_Q_TRIGGERS" },
    {  "value":         91, "name": "MQCMD_LOGGER_EVENT" },
    {  "value":         91, "name": "MQIA_TRIGGER_RESTART" },
    {  "value":         92, "name": "MQCMD_RESET_Q_MGR" },
    {  "value":         92, "name": "MQIA_SSL_FIPS_REQUIRED" },
    {  "value":         93, "name": "MQCMD_CHANGE_LISTENER" },
    {  "value":         93, "name": "MQIA_IP_ADDRESS_VERSION" },
    {  "value":         94, "name": "MQCMD_COPY_LISTENER" },
    {  "value":         94, "name": "MQIA_LOGGER_EVENT" },
    {  "value":         95, "name": "MQCMD_CREATE_LISTENER" },
    {  "value":         95, "name": "MQIA_CLWL_Q_RANK" },
    {  "value":         96, "name": "MQCMD_DELETE_LISTENER" },
    {  "value":         96, "name": "MQIA_CLWL_Q_PRIORITY" },
    {  "value":         96, "name": "MQ_ENV_INFO_LENGTH" },
    {  "value":         97, "name": "MQCMD_INQUIRE_LISTENER" },
    {  "value":         97, "name": "MQIA_CLWL_MRU_CHANNELS" },
    {  "value":         98, "name": "MQCMD_INQUIRE_LISTENER_STATUS" },
    {  "value":         98, "name": "MQIA_CLWL_USEQ" },
    {  "value":         99, "name": "MQCMD_COMMAND_EVENT" },
    {  "value":         99, "name": "MQIA_COMMAND_EVENT" },
    {  "value":        100, "name": "MQCHSSTATE_END_OF_BATCH" },
    {  "value":        100, "name": "MQCMDL_LEVEL_1" },
    {  "value":        100, "name": "MQCMD_CHANGE_SECURITY" },
    {  "value":        100, "name": "MQGMO_LENGTH_3" },
    {  "value":        100, "name": "MQIAMO_MONITOR_HUNDREDTHS" },
    {  "value":        100, "name": "MQIA_ACTIVE_CHANNELS" },
    {  "value":        101, "name": "MQCMDL_LEVEL_101" },
    {  "value":        101, "name": "MQCMD_CHANGE_CF_STRUC" },
    {  "value":        101, "name": "MQIA_CHINIT_ADAPTERS" },
    {  "value":        102, "name": "MQCMD_CHANGE_STG_CLASS" },
    {  "value":        102, "name": "MQIA_ADOPTNEWMCA_CHECK" },
    {  "value":        103, "name": "MQCMD_CHANGE_TRACE" },
    {  "value":        103, "name": "MQIA_ADOPTNEWMCA_TYPE" },
    {  "value":        104, "name": "MQCMD_ARCHIVE_LOG" },
    {  "value":        104, "name": "MQCSP_CURRENT_LENGTH (8 byte)" },
    {  "value":        104, "name": "MQCSP_LENGTH_3 (8 byte)" },
    {  "value":        104, "name": "MQIA_ADOPTNEWMCA_INTERVAL" },
    {  "value":        105, "name": "MQCMD_BACKUP_CF_STRUC" },
    {  "value":        105, "name": "MQIA_CHINIT_DISPATCHERS" },
    {  "value":        106, "name": "MQCMD_CREATE_BUFFER_POOL" },
    {  "value":        106, "name": "MQIA_DNS_WLM" },
    {  "value":        107, "name": "MQCMD_CREATE_PAGE_SET" },
    {  "value":        107, "name": "MQIA_LISTENER_TIMER" },
    {  "value":        108, "name": "MQCMD_CREATE_CF_STRUC" },
    {  "value":        108, "name": "MQIA_LU62_CHANNELS" },
    {  "value":        108, "name": "MQRMH_CURRENT_LENGTH" },
    {  "value":        108, "name": "MQRMH_LENGTH_1" },
    {  "value":        109, "name": "MQCMD_CREATE_STG_CLASS" },
    {  "value":        109, "name": "MQIA_MAX_CHANNELS" },
    {  "value":        110, "name": "MQCMDL_LEVEL_110" },
    {  "value":        110, "name": "MQCMD_COPY_CF_STRUC" },
    {  "value":        110, "name": "MQIA_OUTBOUND_PORT_MIN" },
    {  "value":        110, "name": "MQMCEV_CCT_GETTIME_FAILED" },
    {  "value":        111, "name": "MQCMD_COPY_STG_CLASS" },
    {  "value":        111, "name": "MQIA_RECEIVE_TIMEOUT" },
    {  "value":        112, "name": "MQCMD_DELETE_CF_STRUC" },
    {  "value":        112, "name": "MQGMO_CURRENT_LENGTH" },
    {  "value":        112, "name": "MQGMO_LENGTH_4" },
    {  "value":        112, "name": "MQIA_RECEIVE_TIMEOUT_TYPE" },
    {  "value":        112, "name": "MQMT_MQE_FIELDS_FROM_MQE" },
    {  "value":        113, "name": "MQCMD_DELETE_STG_CLASS" },
    {  "value":        113, "name": "MQIA_RECEIVE_TIMEOUT_MIN" },
    {  "value":        113, "name": "MQMT_MQE_FIELDS" },
    {  "value":        114, "name": "MQCMDL_LEVEL_114" },
    {  "value":        114, "name": "MQCMD_INQUIRE_ARCHIVE" },
    {  "value":        114, "name": "MQIA_TCP_CHANNELS" },
    {  "value":        115, "name": "MQCMD_INQUIRE_CF_STRUC" },
    {  "value":        115, "name": "MQIA_TCP_KEEP_ALIVE" },
    {  "value":        116, "name": "MQCMD_INQUIRE_CF_STRUC_STATUS" },
    {  "value":        116, "name": "MQIA_TCP_STACK_TYPE" },
    {  "value":        117, "name": "MQCMD_INQUIRE_CMD_SERVER" },
    {  "value":        117, "name": "MQIA_CHINIT_TRACE_AUTO_START" },
    {  "value":        118, "name": "MQCMD_INQUIRE_CHANNEL_INIT" },
    {  "value":        118, "name": "MQIA_CHINIT_TRACE_TABLE_SIZE" },
    {  "value":        119, "name": "MQCMD_INQUIRE_QSG" },
    {  "value":        119, "name": "MQIA_CHINIT_CONTROL" },
    {  "value":        120, "name": "MQCMDL_LEVEL_120" },
    {  "value":        120, "name": "MQCMD_INQUIRE_LOG" },
    {  "value":        120, "name": "MQIA_CMD_SERVER_CONTROL" },
    {  "value":        120, "name": "MQMCEV_DEST_INTERFACE_FAILURE" },
    {  "value":        120, "name": "MQWIH_CURRENT_LENGTH" },
    {  "value":        120, "name": "MQWIH_LENGTH_1" },
    {  "value":        121, "name": "MQCMD_INQUIRE_SECURITY" },
    {  "value":        121, "name": "MQIA_SERVICE_TYPE" },
    {  "value":        121, "name": "MQMCEV_DEST_INTERFACE_FAILOVER" },
    {  "value":        122, "name": "MQCMD_INQUIRE_STG_CLASS" },
    {  "value":        122, "name": "MQIA_MONITORING_CHANNEL" },
    {  "value":        122, "name": "MQMCEV_PORT_INTERFACE_FAILURE" },
    {  "value":        123, "name": "MQCMD_INQUIRE_SYSTEM" },
    {  "value":        123, "name": "MQIA_MONITORING_Q" },
    {  "value":        123, "name": "MQMCEV_PORT_INTERFACE_FAILOVER" },
    {  "value":        124, "name": "MQCMD_INQUIRE_THREAD" },
    {  "value":        124, "name": "MQIA_MONITORING_AUTO_CLUSSDR" },
    {  "value":        124, "name": "MQWDR1_CURRENT_LENGTH" },
    {  "value":        124, "name": "MQWDR1_LENGTH_1" },
    {  "value":        124, "name": "MQWDR2_LENGTH_1" },
    {  "value":        124, "name": "MQWDR_LENGTH_1" },
    {  "value":        125, "name": "MQCMD_INQUIRE_TRACE" },
    {  "value":        126, "name": "MQCMD_INQUIRE_USAGE" },
    {  "value":        127, "name": "MQCMD_MOVE_Q" },
    {  "value":        127, "name": "MQIA_STATISTICS_MQI" },
    {  "value":        128, "name": "MQCMD_RECOVER_BSDS" },
    {  "value":        128, "name": "MQCNO_HANDLE_SHARE_NO_BLOCK" },
    {  "value":        128, "name": "MQGMO_MARK_SKIP_BACKOUT" },
    {  "value":        128, "name": "MQIA_STATISTICS_Q" },
    {  "value":        128, "name": "MQOO_SAVE_ALL_CONTEXT" },
    {  "value":        128, "name": "MQPMO_LENGTH_1" },
    {  "value":        128, "name": "MQPMO_NEW_CORREL_ID" },
    {  "value":        128, "name": "MQQF_CLWL_USEQ_LOCAL" },
    {  "value":        128, "name": "MQREGO_INCLUDE_STREAM_NAME" },
    {  "value":        128, "name": "MQRO_PASS_MSG_ID" },
    {  "value":        128, "name": "MQSO_NO_MULTICAST" },
    {  "value":        128, "name": "MQTYPE_INT64" },
    {  "value":        128, "name": "MQZAO_PASS_ALL_CONTEXT" },
    {  "value":        128, "name": "MQ_CONN_TAG_LENGTH" },
    {  "value":        128, "name": "MQ_CUSTOM_LENGTH" },
    {  "value":        128, "name": "MQ_EXIT_NAME_LENGTH" },
    {  "value":        128, "name": "MQ_LDAP_CLASS_LENGTH" },
    {  "value":        128, "name": "MQ_LDAP_FIELD_LENGTH" },
    {  "value":        128, "name": "MQ_MAX_EXIT_NAME_LENGTH" },
    {  "value":        128, "name": "MQ_PROCESS_ENV_DATA_LENGTH" },
    {  "value":        128, "name": "MQ_PROCESS_USER_DATA_LENGTH" },
    {  "value":        128, "name": "MQ_SUB_IDENTITY_LENGTH" },
    {  "value":        128, "name": "MQ_SUB_POINT_LENGTH" },
    {  "value":        129, "name": "MQCMD_RECOVER_CF_STRUC" },
    {  "value":        129, "name": "MQIA_STATISTICS_CHANNEL" },
    {  "value":        130, "name": "MQCMD_RESET_TPIPE" },
    {  "value":        130, "name": "MQIA_STATISTICS_AUTO_CLUSSDR" },
    {  "value":        131, "name": "MQCMD_RESOLVE_INDOUBT" },
    {  "value":        131, "name": "MQIA_STATISTICS_INTERVAL" },
    {  "value":        132, "name": "MQCMD_RESUME_Q_MGR" },
    {  "value":        133, "name": "MQCMD_REVERIFY_SECURITY" },
    {  "value":        133, "name": "MQIA_ACCOUNTING_MQI" },
    {  "value":        134, "name": "MQCMD_SET_ARCHIVE" },
    {  "value":        134, "name": "MQIA_ACCOUNTING_Q" },
    {  "value":        135, "name": "MQIA_ACCOUNTING_INTERVAL" },
    {  "value":        136, "name": "MQCMD_SET_LOG" },
    {  "value":        136, "name": "MQIA_ACCOUNTING_CONN_OVERRIDE" },
    {  "value":        136, "name": "MQWDR2_CURRENT_LENGTH" },
    {  "value":        136, "name": "MQWDR2_LENGTH_2" },
    {  "value":        136, "name": "MQWDR_CURRENT_LENGTH" },
    {  "value":        136, "name": "MQWDR_LENGTH_2" },
    {  "value":        137, "name": "MQCMD_SET_SYSTEM" },
    {  "value":        137, "name": "MQIA_TRACE_ROUTE_RECORDING" },
    {  "value":        138, "name": "MQCMD_START_CMD_SERVER" },
    {  "value":        138, "name": "MQIA_ACTIVITY_RECORDING" },
    {  "value":        139, "name": "MQCMD_START_Q_MGR" },
    {  "value":        139, "name": "MQIA_SERVICE_CONTROL" },
    {  "value":        140, "name": "MQCMD_START_TRACE" },
    {  "value":        140, "name": "MQIA_OUTBOUND_PORT_MAX" },
    {  "value":        140, "name": "MQIEP_CURRENT_LENGTH (4 byte)" },
    {  "value":        140, "name": "MQIEP_LENGTH_1 (4 byte)" },
    {  "value":        141, "name": "MQCMD_STOP_CHANNEL_INIT" },
    {  "value":        141, "name": "MQIA_SECURITY_CASE" },
    {  "value":        142, "name": "MQCMD_STOP_CHANNEL_LISTENER" },
    {  "value":        143, "name": "MQCMD_STOP_CMD_SERVER" },
    {  "value":        144, "name": "MQCMD_STOP_Q_MGR" },
    {  "value":        145, "name": "MQCMD_STOP_TRACE" },
    {  "value":        146, "name": "MQCMD_SUSPEND_Q_MGR" },
    {  "value":        147, "name": "MQCMD_INQUIRE_CF_STRUC_NAMES" },
    {  "value":        148, "name": "MQCMD_INQUIRE_STG_CLASS_NAMES" },
    {  "value":        148, "name": "MQCNO_LENGTH_3 (4 byte)" },
    {  "value":        149, "name": "MQCMD_CHANGE_SERVICE" },
    {  "value":        150, "name": "MQCMD_COPY_SERVICE" },
    {  "value":        150, "name": "MQIA_QMOPT_CSMT_ON_ERROR" },
    {  "value":        151, "name": "MQCMD_CREATE_SERVICE" },
    {  "value":        151, "name": "MQIA_QMOPT_CONS_INFO_MSGS" },
    {  "value":        152, "name": "MQCMD_DELETE_SERVICE" },
    {  "value":        152, "name": "MQCNO_LENGTH_3 (8 byte)" },
    {  "value":        152, "name": "MQIA_QMOPT_CONS_WARNING_MSGS" },
    {  "value":        152, "name": "MQPMO_LENGTH_2 (4 byte)" },
    {  "value":        153, "name": "MQCMD_INQUIRE_SERVICE" },
    {  "value":        153, "name": "MQIA_QMOPT_CONS_ERROR_MSGS" },
    {  "value":        154, "name": "MQCMD_INQUIRE_SERVICE_STATUS" },
    {  "value":        154, "name": "MQIA_QMOPT_CONS_CRITICAL_MSGS" },
    {  "value":        155, "name": "MQCMD_START_SERVICE" },
    {  "value":        155, "name": "MQIA_QMOPT_CONS_COMMS_MSGS" },
    {  "value":        156, "name": "MQCBD_CURRENT_LENGTH (4 byte)" },
    {  "value":        156, "name": "MQCBD_LENGTH_1 (4 byte)" },
    {  "value":        156, "name": "MQCMD_STOP_SERVICE" },
    {  "value":        156, "name": "MQCNO_LENGTH_4 (4 byte)" },
    {  "value":        156, "name": "MQCXP_LENGTH_3" },
    {  "value":        156, "name": "MQCXP_LENGTH_4" },
    {  "value":        156, "name": "MQIA_QMOPT_CONS_REORG_MSGS" },
    {  "value":        156, "name": "MQPSXP_LENGTH_1 (4 byte)" },
    {  "value":        157, "name": "MQCMD_DELETE_BUFFER_POOL" },
    {  "value":        157, "name": "MQIA_QMOPT_CONS_SYSTEM_MSGS" },
    {  "value":        158, "name": "MQCMD_DELETE_PAGE_SET" },
    {  "value":        158, "name": "MQIA_QMOPT_LOG_INFO_MSGS" },
    {  "value":        159, "name": "MQCMD_CHANGE_BUFFER_POOL" },
    {  "value":        159, "name": "MQIA_QMOPT_LOG_WARNING_MSGS" },
    {  "value":        160, "name": "MQCMD_CHANGE_PAGE_SET" },
    {  "value":        160, "name": "MQCXP_LENGTH_5" },
    {  "value":        160, "name": "MQIA_QMOPT_LOG_ERROR_MSGS" },
    {  "value":        160, "name": "MQPMO_LENGTH_2 (8 byte)" },
    {  "value":        160, "name": "MQPSXP_CURRENT_LENGTH (4 byte)" },
    {  "value":        160, "name": "MQPSXP_LENGTH_2 (4 byte)" },
    {  "value":        161, "name": "MQCMD_INQUIRE_Q_MGR_STATUS" },
    {  "value":        161, "name": "MQIA_QMOPT_LOG_CRITICAL_MSGS" },
    {  "value":        162, "name": "MQCMD_CREATE_LOG" },
    {  "value":        162, "name": "MQIA_QMOPT_LOG_COMMS_MSGS" },
    {  "value":        163, "name": "MQIA_QMOPT_LOG_REORG_MSGS" },
    {  "value":        164, "name": "MQCIH_LENGTH_1" },
    {  "value":        164, "name": "MQCMD_STATISTICS_MQI" },
    {  "value":        164, "name": "MQIA_QMOPT_LOG_SYSTEM_MSGS" },
    {  "value":        165, "name": "MQCMD_STATISTICS_Q" },
    {  "value":        165, "name": "MQIA_QMOPT_TRACE_MQI_CALLS" },
    {  "value":        166, "name": "MQCMD_STATISTICS_CHANNEL" },
    {  "value":        166, "name": "MQIA_QMOPT_TRACE_COMMS" },
    {  "value":        167, "name": "MQCMD_ACCOUNTING_MQI" },
    {  "value":        167, "name": "MQIA_QMOPT_TRACE_REORG" },
    {  "value":        168, "name": "MQCBD_CURRENT_LENGTH (8 byte)" },
    {  "value":        168, "name": "MQCBD_LENGTH_1 (8 byte)" },
    {  "value":        168, "name": "MQCMD_ACCOUNTING_Q" },
    {  "value":        168, "name": "MQCNO_LENGTH_4 (8 byte)" },
    {  "value":        168, "name": "MQIA_QMOPT_TRACE_CONVERSION" },
    {  "value":        168, "name": "MQOD_LENGTH_1" },
    {  "value":        169, "name": "MQCMD_INQUIRE_AUTH_SERVICE" },
    {  "value":        169, "name": "MQIA_QMOPT_TRACE_SYSTEM" },
    {  "value":        170, "name": "MQCMD_CHANGE_TOPIC" },
    {  "value":        170, "name": "MQIA_QMOPT_INTERNAL_DUMP" },
    {  "value":        171, "name": "MQCMD_COPY_TOPIC" },
    {  "value":        171, "name": "MQIA_MAX_RECOVERY_TASKS" },
    {  "value":        172, "name": "MQCMD_CREATE_TOPIC" },
    {  "value":        172, "name": "MQDLH_CURRENT_LENGTH" },
    {  "value":        172, "name": "MQDLH_LENGTH_1" },
    {  "value":        172, "name": "MQIA_MAX_CLIENTS" },
    {  "value":        173, "name": "MQCMD_DELETE_TOPIC" },
    {  "value":        173, "name": "MQIA_AUTO_REORGANIZATION" },
    {  "value":        174, "name": "MQCMD_INQUIRE_TOPIC" },
    {  "value":        174, "name": "MQIA_AUTO_REORG_INTERVAL" },
    {  "value":        175, "name": "MQCMD_INQUIRE_TOPIC_NAMES" },
    {  "value":        175, "name": "MQIA_DURABLE_SUB" },
    {  "value":        176, "name": "MQCMD_INQUIRE_SUBSCRIPTION" },
    {  "value":        176, "name": "MQIA_MULTICAST" },
    {  "value":        176, "name": "MQPMO_CURRENT_LENGTH (4 byte)" },
    {  "value":        176, "name": "MQPMO_LENGTH_3 (4 byte)" },
    {  "value":        176, "name": "MQPSXP_LENGTH_1 (8 byte)" },
    {  "value":        177, "name": "MQCMD_CREATE_SUBSCRIPTION" },
    {  "value":        178, "name": "MQCMD_CHANGE_SUBSCRIPTION" },
    {  "value":        179, "name": "MQCMD_DELETE_SUBSCRIPTION" },
    {  "value":        180, "name": "MQCIH_CURRENT_LENGTH" },
    {  "value":        180, "name": "MQCIH_LENGTH_2" },
    {  "value":        181, "name": "MQCMD_COPY_SUBSCRIPTION" },
    {  "value":        181, "name": "MQIA_INHIBIT_PUB" },
    {  "value":        182, "name": "MQCMD_INQUIRE_SUB_STATUS" },
    {  "value":        182, "name": "MQIA_INHIBIT_SUB" },
    {  "value":        183, "name": "MQCMD_INQUIRE_TOPIC_STATUS" },
    {  "value":        183, "name": "MQIA_TREE_LIFE_TIME" },
    {  "value":        184, "name": "MQCMD_CLEAR_TOPIC_STRING" },
    {  "value":        184, "name": "MQIA_DEF_PUT_RESPONSE_TYPE" },
    {  "value":        184, "name": "MQPMO_CURRENT_LENGTH (8 byte)" },
    {  "value":        184, "name": "MQPMO_LENGTH_3 (8 byte)" },
    {  "value":        184, "name": "MQPSXP_CURRENT_LENGTH (8 byte)" },
    {  "value":        184, "name": "MQPSXP_LENGTH_2 (8 byte)" },
    {  "value":        185, "name": "MQCMD_INQUIRE_PUBSUB_STATUS" },
    {  "value":        185, "name": "MQIA_TOPIC_DEF_PERSISTENCE" },
    {  "value":        186, "name": "MQCMD_INQUIRE_SMDS" },
    {  "value":        186, "name": "MQIA_MASTER_ADMIN" },
    {  "value":        187, "name": "MQCMD_CHANGE_SMDS" },
    {  "value":        187, "name": "MQIA_PUBSUB_MODE" },
    {  "value":        188, "name": "MQCMD_RESET_SMDS" },
    {  "value":        188, "name": "MQCNO_LENGTH_5 (4 byte)" },
    {  "value":        188, "name": "MQIA_DEF_READ_AHEAD" },
    {  "value":        189, "name": "MQIA_READ_AHEAD" },
    {  "value":        190, "name": "MQCMD_CREATE_COMM_INFO" },
    {  "value":        190, "name": "MQIA_PROPERTY_CONTROL" },
    {  "value":        191, "name": "MQCMD_INQUIRE_COMM_INFO" },
    {  "value":        192, "name": "MQCMD_CHANGE_COMM_INFO" },
    {  "value":        192, "name": "MQCXP_LENGTH_6 (4 byte)" },
    {  "value":        192, "name": "MQIA_MAX_PROPERTIES_LENGTH" },
    {  "value":        193, "name": "MQCMD_COPY_COMM_INFO" },
    {  "value":        193, "name": "MQIA_BASE_TYPE" },
    {  "value":        194, "name": "MQCMD_DELETE_COMM_INFO" },
    {  "value":        195, "name": "MQCMD_PURGE_CHANNEL" },
    {  "value":        195, "name": "MQIA_PM_DELIVERY" },
    {  "value":        196, "name": "MQCMD_MQXR_DIAGNOSTICS" },
    {  "value":        196, "name": "MQIA_NPM_DELIVERY" },
    {  "value":        197, "name": "MQCMD_START_SMDSCONN" },
    {  "value":        198, "name": "MQCMD_STOP_SMDSCONN" },
    {  "value":        199, "name": "MQCMD_INQUIRE_SMDSCONN" },
    {  "value":        199, "name": "MQIA_PROXY_SUB" },
    {  "value":        200, "name": "MQCHSSTATE_SENDING" },
    {  "value":        200, "name": "MQCMDL_LEVEL_200" },
    {  "value":        200, "name": "MQCMD_INQUIRE_MQXR_STATUS" },
    {  "value":        200, "name": "MQCNO_LENGTH_5 (8 byte)" },
    {  "value":        200, "name": "MQCXP_LENGTH_6 (8 byte)" },
    {  "value":        200, "name": "MQCXP_LENGTH_7 (4 byte)" },
    {  "value":        200, "name": "MQOD_LENGTH_2 (4 byte)" },
    {  "value":        200, "name": "MQWQR1_CURRENT_LENGTH" },
    {  "value":        200, "name": "MQWQR1_LENGTH_1" },
    {  "value":        200, "name": "MQWQR2_LENGTH_1" },
    {  "value":        200, "name": "MQWQR3_LENGTH_1" },
    {  "value":        200, "name": "MQWQR4_LENGTH_1" },
    {  "value":        200, "name": "MQWQR_LENGTH_1" },
    {  "value":        201, "name": "MQCMDL_LEVEL_201" },
    {  "value":        201, "name": "MQCMD_START_CLIENT_TRACE" },
    {  "value":        202, "name": "MQCMD_STOP_CLIENT_TRACE" },
    {  "value":        203, "name": "MQCMD_SET_CHLAUTH_REC" },
    {  "value":        203, "name": "MQIA_PUBSUB_NP_MSG" },
    {  "value":        204, "name": "MQCMD_INQUIRE_CHLAUTH_RECS" },
    {  "value":        204, "name": "MQIA_SUB_COUNT" },
    {  "value":        205, "name": "MQCMD_INQUIRE_PROT_POLICY" },
    {  "value":        205, "name": "MQIA_PUBSUB_NP_RESP" },
    {  "value":        206, "name": "MQCMD_CREATE_PROT_POLICY" },
    {  "value":        206, "name": "MQIA_PUBSUB_MAXMSG_RETRY_COUNT" },
    {  "value":        207, "name": "MQCMD_DELETE_PROT_POLICY" },
    {  "value":        207, "name": "MQIA_PUBSUB_SYNC_PT" },
    {  "value":        208, "name": "MQCMD_CHANGE_PROT_POLICY" },
    {  "value":        208, "name": "MQCMD_SET_PROT_POLICY" },
    {  "value":        208, "name": "MQCNO_LENGTH_6 (4 byte)" },
    {  "value":        208, "name": "MQCXP_LENGTH_7 (8 byte)" },
    {  "value":        208, "name": "MQCXP_LENGTH_8 (4 byte)" },
    {  "value":        208, "name": "MQIA_TOPIC_TYPE" },
    {  "value":        208, "name": "MQOD_LENGTH_2 (8 byte)" },
    {  "value":        208, "name": "MQWQR2_CURRENT_LENGTH" },
    {  "value":        208, "name": "MQWQR2_LENGTH_2" },
    {  "value":        208, "name": "MQWQR3_LENGTH_2" },
    {  "value":        208, "name": "MQWQR4_LENGTH_2" },
    {  "value":        208, "name": "MQWQR_LENGTH_2" },
    {  "value":        208, "name": "MQWXP1_CURRENT_LENGTH (4 byte)" },
    {  "value":        208, "name": "MQWXP1_LENGTH_1 (4 byte)" },
    {  "value":        208, "name": "MQWXP2_LENGTH_1 (4 byte)" },
    {  "value":        208, "name": "MQWXP3_LENGTH_1 (4 byte)" },
    {  "value":        208, "name": "MQWXP4_LENGTH_1 (4 byte)" },
    {  "value":        208, "name": "MQWXP_LENGTH_1 (4 byte)" },
    {  "value":        209, "name": "MQCMD_ACTIVITY_TRACE" },
    {  "value":        210, "name": "MQCMDL_LEVEL_210" },
    {  "value":        211, "name": "MQCMDL_LEVEL_211" },
    {  "value":        212, "name": "MQWQR3_CURRENT_LENGTH" },
    {  "value":        212, "name": "MQWQR3_LENGTH_3" },
    {  "value":        212, "name": "MQWQR4_LENGTH_3" },
    {  "value":        212, "name": "MQWQR_LENGTH_3" },
    {  "value":        213, "name": "MQCMD_RESET_CF_STRUC" },
    {  "value":        214, "name": "MQCMD_INQUIRE_XR_CAPABILITY" },
    {  "value":        215, "name": "MQIA_PUB_COUNT" },
    {  "value":        216, "name": "MQCMD_INQUIRE_AMQP_CAPABILITY" },
    {  "value":        216, "name": "MQIA_WILDCARD_OPERATION" },
    {  "value":        216, "name": "MQWQR4_CURRENT_LENGTH" },
    {  "value":        216, "name": "MQWQR4_LENGTH_4" },
    {  "value":        216, "name": "MQWQR_CURRENT_LENGTH" },
    {  "value":        216, "name": "MQWQR_LENGTH_4" },
    {  "value":        216, "name": "MQWXP2_CURRENT_LENGTH (4 byte)" },
    {  "value":        216, "name": "MQWXP2_LENGTH_2 (4 byte)" },
    {  "value":        216, "name": "MQWXP3_LENGTH_2 (4 byte)" },
    {  "value":        216, "name": "MQWXP4_LENGTH_2 (4 byte)" },
    {  "value":        216, "name": "MQWXP_LENGTH_2 (4 byte)" },
    {  "value":        217, "name": "MQCMD_AMQP_DIAGNOSTICS" },
    {  "value":        218, "name": "MQCMD_INTER_Q_MGR_STATUS" },
    {  "value":        218, "name": "MQIA_SUB_SCOPE" },
    {  "value":        219, "name": "MQCMD_INTER_Q_MGR_BALANCE" },
    {  "value":        219, "name": "MQIA_PUB_SCOPE" },
    {  "value":        220, "name": "MQCMDL_LEVEL_220" },
    {  "value":        220, "name": "MQCMD_INQUIRE_APPL_STATUS" },
    {  "value":        220, "name": "MQCXP_CURRENT_LENGTH (4 byte)" },
    {  "value":        220, "name": "MQCXP_LENGTH_9 (4 byte)" },
    {  "value":        220, "name": "MQWXP3_CURRENT_LENGTH (4 byte)" },
    {  "value":        220, "name": "MQWXP3_LENGTH_3 (4 byte)" },
    {  "value":        220, "name": "MQWXP4_LENGTH_3 (4 byte)" },
    {  "value":        220, "name": "MQWXP_LENGTH_3 (4 byte)" },
    {  "value":        221, "name": "MQCMDL_LEVEL_221" },
    {  "value":        221, "name": "MQIA_GROUP_UR" },
    {  "value":        222, "name": "MQIA_UR_DISP" },
    {  "value":        223, "name": "MQIA_COMM_INFO_TYPE" },
    {  "value":        224, "name": "MQCNO_LENGTH_6 (8 byte)" },
    {  "value":        224, "name": "MQCXP_LENGTH_8 (8 byte)" },
    {  "value":        224, "name": "MQIA_CF_OFFLOAD" },
    {  "value":        224, "name": "MQSTS_LENGTH_1" },
    {  "value":        224, "name": "MQWXP1_CURRENT_LENGTH (8 byte)" },
    {  "value":        224, "name": "MQWXP1_LENGTH_1 (8 byte)" },
    {  "value":        224, "name": "MQWXP2_LENGTH_1 (8 byte)" },
    {  "value":        224, "name": "MQWXP3_LENGTH_1 (8 byte)" },
    {  "value":        224, "name": "MQWXP4_CURRENT_LENGTH (4 byte)" },
    {  "value":        224, "name": "MQWXP4_LENGTH_1 (8 byte)" },
    {  "value":        224, "name": "MQWXP4_LENGTH_4 (4 byte)" },
    {  "value":        224, "name": "MQWXP_CURRENT_LENGTH (4 byte)" },
    {  "value":        224, "name": "MQWXP_LENGTH_1 (8 byte)" },
    {  "value":        224, "name": "MQWXP_LENGTH_4 (4 byte)" },
    {  "value":        225, "name": "MQIA_CF_OFFLOAD_THRESHOLD1" },
    {  "value":        226, "name": "MQIA_CF_OFFLOAD_THRESHOLD2" },
    {  "value":        227, "name": "MQIA_CF_OFFLOAD_THRESHOLD3" },
    {  "value":        228, "name": "MQIA_CF_SMDS_BUFFERS" },
    {  "value":        229, "name": "MQIA_CF_OFFLDUSE" },
    {  "value":        230, "name": "MQCMDL_LEVEL_230" },
    {  "value":        230, "name": "MQIA_MAX_RESPONSES" },
    {  "value":        231, "name": "MQIA_RESPONSE_RESTART_POINT" },
    {  "value":        232, "name": "MQIA_COMM_EVENT" },
    {  "value":        233, "name": "MQIA_MCAST_BRIDGE" },
    {  "value":        234, "name": "MQIA_USE_DEAD_LETTER_Q" },
    {  "value":        235, "name": "MQIA_TOLERATE_UNPROTECTED" },
    {  "value":        236, "name": "MQIA_SIGNATURE_ALGORITHM" },
    {  "value":        237, "name": "MQIA_ENCRYPTION_ALGORITHM" },
    {  "value":        238, "name": "MQIA_POLICY_VERSION" },
    {  "value":        239, "name": "MQIA_ACTIVITY_CONN_OVERRIDE" },
    {  "value":        240, "name": "MQCNO_LENGTH_7 (4 byte)" },
    {  "value":        240, "name": "MQCXP_CURRENT_LENGTH (8 byte)" },
    {  "value":        240, "name": "MQCXP_LENGTH_9 (8 byte)" },
    {  "value":        240, "name": "MQDCC_SOURCE_ENC_MASK" },
    {  "value":        240, "name": "MQENC_DECIMAL_MASK" },
    {  "value":        240, "name": "MQIA_ACTIVITY_TRACE" },
    {  "value":        240, "name": "MQWXP2_CURRENT_LENGTH (8 byte)" },
    {  "value":        240, "name": "MQWXP2_LENGTH_2 (8 byte)" },
    {  "value":        240, "name": "MQWXP3_CURRENT_LENGTH (8 byte)" },
    {  "value":        240, "name": "MQWXP3_LENGTH_2 (8 byte)" },
    {  "value":        240, "name": "MQWXP3_LENGTH_3 (8 byte)" },
    {  "value":        240, "name": "MQWXP4_LENGTH_2 (8 byte)" },
    {  "value":        240, "name": "MQWXP4_LENGTH_3 (8 byte)" },
    {  "value":        240, "name": "MQWXP_LENGTH_2 (8 byte)" },
    {  "value":        240, "name": "MQWXP_LENGTH_3 (8 byte)" },
    {  "value":        242, "name": "MQIA_SUB_CONFIGURATION_EVENT" },
    {  "value":        243, "name": "MQIA_XR_CAPABILITY" },
    {  "value":        244, "name": "MQAXP_CURRENT_LENGTH (4 byte)" },
    {  "value":        244, "name": "MQAXP_LENGTH_1 (4 byte)" },
    {  "value":        244, "name": "MQIA_CF_RECAUTO" },
    {  "value":        245, "name": "MQIA_QMGR_CFCONLOS" },
    {  "value":        246, "name": "MQIA_CF_CFCONLOS" },
    {  "value":        247, "name": "MQIA_SUITE_B_STRENGTH" },
    {  "value":        248, "name": "MQIA_CHLAUTH_RECORDS" },
    {  "value":        248, "name": "MQWXP4_CURRENT_LENGTH (8 byte)" },
    {  "value":        248, "name": "MQWXP4_LENGTH_4 (8 byte)" },
    {  "value":        248, "name": "MQWXP_CURRENT_LENGTH (8 byte)" },
    {  "value":        248, "name": "MQWXP_LENGTH_4 (8 byte)" },
    {  "value":        249, "name": "MQIA_PUBSUB_CLUSTER" },
    {  "value":        250, "name": "MQIA_DEF_CLUSTER_XMIT_Q_TYPE" },
    {  "value":        251, "name": "MQIA_PROT_POLICY_CAPABILITY" },
    {  "value":        252, "name": "MQCNO_CURRENT_LENGTH (4 byte)" },
    {  "value":        252, "name": "MQCNO_LENGTH_8 (4 byte)" },
    {  "value":        252, "name": "MQIA_CERT_VAL_POLICY" },
    {  "value":        253, "name": "MQIA_TOPIC_NODE_COUNT" },
    {  "value":        254, "name": "MQIA_REVERSE_DNS_LOOKUP" },
    {  "value":        255, "name": "MQIA_CLUSTER_PUB_ROUTE" },
    {  "value":        255, "name": "MQ_SERVICE_ARGS_LENGTH" },
    {  "value":        255, "name": "MQ_SERVICE_COMMAND_LENGTH" },
    {  "value":        255, "name": "MQ_SERVICE_PATH_LENGTH" },
    {  "value":        256, "name": "MQAUTHOPT_CUMULATIVE" },
    {  "value":        256, "name": "MQAXP_CURRENT_LENGTH (8 byte)" },
    {  "value":        256, "name": "MQAXP_LENGTH_1 (8 byte)" },
    {  "value":        256, "name": "MQCADSD_MSGFORMAT" },
    {  "value":        256, "name": "MQCBDO_REGISTER_CALL" },
    {  "value":        256, "name": "MQCNO_LENGTH_7 (8 byte)" },
    {  "value":        256, "name": "MQCNO_SHARED_BINDING" },
    {  "value":        256, "name": "MQCTES_COMMIT" },
    {  "value":        256, "name": "MQCUOWC_COMMIT" },
    {  "value":        256, "name": "MQDCC_TARGET_ENC_FACTOR" },
    {  "value":        256, "name": "MQDCC_TARGET_ENC_NORMAL" },
    {  "value":        256, "name": "MQENC_FLOAT_IEEE_NORMAL" },
    {  "value":        256, "name": "MQFB_QUIT" },
    {  "value":        256, "name": "MQGMO_MSG_UNDER_CURSOR" },
    {  "value":        256, "name": "MQIA_CLUSTER_OBJECT_STATE" },
    {  "value":        256, "name": "MQNC_MAX_NAMELIST_NAME_COUNT" },
    {  "value":        256, "name": "MQOO_PASS_IDENTITY_CONTEXT" },
    {  "value":        256, "name": "MQOP_REGISTER" },
    {  "value":        256, "name": "MQPMO_PASS_IDENTITY_CONTEXT" },
    {  "value":        256, "name": "MQREGO_INFORM_IF_RETAINED" },
    {  "value":        256, "name": "MQROUTE_FORWARD_ALL" },
    {  "value":        256, "name": "MQRO_COA" },
    {  "value":        256, "name": "MQSO_FIXED_USERID" },
    {  "value":        256, "name": "MQTYPE_FLOAT32" },
    {  "value":        256, "name": "MQZAO_SET_IDENTITY_CONTEXT" },
    {  "value":        256, "name": "MQ_AMQP_CLIENT_ID_LENGTH" },
    {  "value":        256, "name": "MQ_AUTH_INFO_OCSP_URL_LENGTH" },
    {  "value":        256, "name": "MQ_CSP_PASSWORD_LENGTH" },
    {  "value":        256, "name": "MQ_ENCRYPTION_KEY_LENGTH" },
    {  "value":        256, "name": "MQ_HOST_NAME_LENGTH" },
    {  "value":        256, "name": "MQ_INITIAL_KEY_LENGTH" },
    {  "value":        256, "name": "MQ_INSTALLATION_PATH_LENGTH" },
    {  "value":        256, "name": "MQ_PROCESS_APPL_ID_LENGTH" },
    {  "value":        256, "name": "MQ_SHORT_DNAME_LENGTH" },
    {  "value":        256, "name": "MQ_SSL_CRYPTO_HARDWARE_LENGTH" },
    {  "value":        256, "name": "MQ_SSL_KEY_REPOSITORY_LENGTH" },
    {  "value":        256, "name": "MQ_SSL_SHORT_PEER_NAME_LENGTH" },
    {  "value":        256, "name": "MQ_UOW_ID_LENGTH" },
    {  "value":        257, "name": "MQIA_CHECK_LOCAL_BINDING" },
    {  "value":        258, "name": "MQFB_EXPIRATION" },
    {  "value":        258, "name": "MQIA_CHECK_CLIENT_BINDING" },
    {  "value":        259, "name": "MQFB_COA" },
    {  "value":        259, "name": "MQIA_AUTHENTICATION_FAIL_DELAY" },
    {  "value":        260, "name": "MQFB_COD" },
    {  "value":        260, "name": "MQIA_ADOPT_CONTEXT" },
    {  "value":        261, "name": "MQIA_LDAP_SECURE_COMM" },
    {  "value":        262, "name": "MQFB_CHANNEL_COMPLETED" },
    {  "value":        262, "name": "MQIA_DISPLAY_TYPE" },
    {  "value":        263, "name": "MQFB_CHANNEL_FAIL_RETRY" },
    {  "value":        263, "name": "MQIA_LDAP_AUTHORMD" },
    {  "value":        264, "name": "MQFB_CHANNEL_FAIL" },
    {  "value":        264, "name": "MQIA_LDAP_NESTGRP" },
    {  "value":        264, "name": "MQIEP_CURRENT_LENGTH (8 byte)" },
    {  "value":        264, "name": "MQIEP_LENGTH_1 (8 byte)" },
    {  "value":        264, "name": "MQ_AUTH_INFO_CONN_NAME_LENGTH" },
    {  "value":        264, "name": "MQ_CONN_NAME_LENGTH" },
    {  "value":        264, "name": "MQ_GROUP_ADDRESS_LENGTH" },
    {  "value":        264, "name": "MQ_NHA_REPL_ADDRESS_LENGTH" },
    {  "value":        265, "name": "MQFB_APPL_CANNOT_BE_STARTED" },
    {  "value":        265, "name": "MQIA_AMQP_CAPABILITY" },
    {  "value":        266, "name": "MQFB_TM_ERROR" },
    {  "value":        266, "name": "MQIA_AUTHENTICATION_METHOD" },
    {  "value":        267, "name": "MQFB_APPL_TYPE_ERROR" },
    {  "value":        267, "name": "MQIA_KEY_REUSE_COUNT" },
    {  "value":        268, "name": "MQFB_STOPPED_BY_MSG_EXIT" },
    {  "value":        268, "name": "MQIA_MEDIA_IMAGE_SCHEDULING" },
    {  "value":        269, "name": "MQFB_ACTIVITY" },
    {  "value":        269, "name": "MQIA_MEDIA_IMAGE_INTERVAL" },
    {  "value":        270, "name": "MQIA_MEDIA_IMAGE_LOG_LENGTH" },
    {  "value":        271, "name": "MQFB_XMIT_Q_MSG_ERROR" },
    {  "value":        271, "name": "MQIA_MEDIA_IMAGE_RECOVER_OBJ" },
    {  "value":        272, "name": "MQCNO_CURRENT_LENGTH (8 byte)" },
    {  "value":        272, "name": "MQCNO_LENGTH_8 (8 byte)" },
    {  "value":        272, "name": "MQCUOWC_LAST" },
    {  "value":        272, "name": "MQIA_MEDIA_IMAGE_RECOVER_Q" },
    {  "value":        272, "name": "MQSBC_CURRENT_LENGTH (4 byte)" },
    {  "value":        272, "name": "MQSBC_LENGTH_1 (4 byte)" },
    {  "value":        272, "name": "MQSTS_CURRENT_LENGTH (4 byte)" },
    {  "value":        272, "name": "MQSTS_LENGTH_2 (4 byte)" },
    {  "value":        273, "name": "MQCUOWC_ONLY" },
    {  "value":        273, "name": "MQENC_NORMAL" },
    {  "value":        273, "name": "MQIA_ADVANCED_CAPABILITY" },
    {  "value":        274, "name": "MQIA_MAX_Q_FILE_SIZE" },
    {  "value":        275, "name": "MQFB_PAN" },
    {  "value":        275, "name": "MQIA_STREAM_QUEUE_QOS" },
    {  "value":        276, "name": "MQFB_NAN" },
    {  "value":        276, "name": "MQIA_CAP_EXPIRY" },
    {  "value":        277, "name": "MQFB_STOPPED_BY_CHAD_EXIT" },
    {  "value":        277, "name": "MQIA_AUTHOREV_SCOPE" },
    {  "value":        278, "name": "MQIA_OTEL_TRACE" },
    {  "value":        279, "name": "MQFB_STOPPED_BY_PUBSUB_EXIT" },
    {  "value":        279, "name": "MQIA_LAST_USED" },
    {  "value":        279, "name": "MQIA_OTEL_PROPAGATION_CONTROL" },
    {  "value":        280, "name": "MQFB_NOT_A_REPOSITORY_MSG" },
    {  "value":        280, "name": "MQSTS_CURRENT_LENGTH (8 byte)" },
    {  "value":        280, "name": "MQSTS_LENGTH_2 (8 byte)" },
    {  "value":        281, "name": "MQFB_BIND_OPEN_CLUSRCVR_DEL" },
    {  "value":        282, "name": "MQFB_MAX_ACTIVITIES" },
    {  "value":        283, "name": "MQFB_NOT_FORWARDED" },
    {  "value":        284, "name": "MQFB_NOT_DELIVERED" },
    {  "value":        285, "name": "MQFB_UNSUPPORTED_FORWARDING" },
    {  "value":        286, "name": "MQFB_UNSUPPORTED_DELIVERY" },
    {  "value":        288, "name": "MQSBC_CURRENT_LENGTH (8 byte)" },
    {  "value":        288, "name": "MQSBC_LENGTH_1 (8 byte)" },
    {  "value":        291, "name": "MQFB_DATA_LENGTH_ZERO" },
    {  "value":        292, "name": "MQFB_DATA_LENGTH_NEGATIVE" },
    {  "value":        293, "name": "MQFB_DATA_LENGTH_TOO_BIG" },
    {  "value":        294, "name": "MQFB_BUFFER_OVERFLOW" },
    {  "value":        295, "name": "MQFB_LENGTH_OFF_BY_ONE" },
    {  "value":        296, "name": "MQFB_IIH_ERROR" },
    {  "value":        298, "name": "MQFB_NOT_AUTHORIZED_FOR_IMS" },
    {  "value":        299, "name": "MQFB_DATA_LENGTH_TOO_SHORT" },
    {  "value":        300, "name": "MQCHSSTATE_RECEIVING" },
    {  "value":        300, "name": "MQFB_IMS_ERROR" },
    {  "value":        301, "name": "MQFB_IMS_FIRST" },
    {  "value":        312, "name": "MQSD_CURRENT_LENGTH (4 byte)" },
    {  "value":        312, "name": "MQSD_LENGTH_1 (4 byte)" },
    {  "value":        320, "name": "MQAIR_LENGTH_1 (4 byte)" },
    {  "value":        320, "name": "MQCMDL_LEVEL_320" },
    {  "value":        324, "name": "MQMD1_CURRENT_LENGTH" },
    {  "value":        324, "name": "MQMD1_LENGTH_1" },
    {  "value":        324, "name": "MQMD2_LENGTH_1" },
    {  "value":        324, "name": "MQMD_LENGTH_1" },
    {  "value":        328, "name": "MQAIR_LENGTH_1 (8 byte)" },
    {  "value":        336, "name": "MQOD_LENGTH_3 (4 byte)" },
    {  "value":        344, "name": "MQOD_LENGTH_3 (8 byte)" },
    {  "value":        344, "name": "MQSD_CURRENT_LENGTH (8 byte)" },
    {  "value":        344, "name": "MQSD_LENGTH_1 (8 byte)" },
    {  "value":        364, "name": "MQMD2_CURRENT_LENGTH" },
    {  "value":        364, "name": "MQMD2_LENGTH_2" },
    {  "value":        364, "name": "MQMD_CURRENT_LENGTH" },
    {  "value":        364, "name": "MQMD_LENGTH_2" },
    {  "value":        384, "name": "MQAXC_LENGTH_1 (4 byte)" },
    {  "value":        392, "name": "MQAXC_LENGTH_1 (8 byte)" },
    {  "value":        399, "name": "MQFB_IMS_LAST" },
    {  "value":        400, "name": "MQCHSSTATE_SERIALIZING" },
    {  "value":        400, "name": "MQOD_CURRENT_LENGTH (4 byte)" },
    {  "value":        400, "name": "MQOD_LENGTH_4 (4 byte)" },
    {  "value":        401, "name": "MQFB_CICS_INTERNAL_ERROR" },
    {  "value":        402, "name": "MQFB_CICS_NOT_AUTHORIZED" },
    {  "value":        403, "name": "MQFB_CICS_BRIDGE_FAILURE" },
    {  "value":        404, "name": "MQFB_CICS_CORREL_ID_ERROR" },
    {  "value":        405, "name": "MQFB_CICS_CCSID_ERROR" },
    {  "value":        406, "name": "MQFB_CICS_ENCODING_ERROR" },
    {  "value":        407, "name": "MQFB_CICS_CIH_ERROR" },
    {  "value":        408, "name": "MQFB_CICS_UOW_ERROR" },
    {  "value":        409, "name": "MQFB_CICS_COMMAREA_ERROR" },
    {  "value":        410, "name": "MQFB_CICS_APPL_NOT_STARTED" },
    {  "value":        411, "name": "MQFB_CICS_APPL_ABENDED" },
    {  "value":        412, "name": "MQAXC_CURRENT_LENGTH (4 byte)" },
    {  "value":        412, "name": "MQAXC_LENGTH_2 (4 byte)" },
    {  "value":        412, "name": "MQFB_CICS_DLQ_ERROR" },
    {  "value":        413, "name": "MQFB_CICS_UOW_BACKED_OUT" },
    {  "value":        420, "name": "MQCMDL_LEVEL_420" },
    {  "value":        424, "name": "MQAXC_CURRENT_LENGTH (8 byte)" },
    {  "value":        424, "name": "MQAXC_LENGTH_2 (8 byte)" },
    {  "value":        424, "name": "MQOD_CURRENT_LENGTH (8 byte)" },
    {  "value":        424, "name": "MQOD_LENGTH_4 (8 byte)" },
    {  "value":        428, "name": "MQXQH_CURRENT_LENGTH" },
    {  "value":        428, "name": "MQXQH_LENGTH_1" },
    {  "value":        500, "name": "MQCHSSTATE_RESYNCHING" },
    {  "value":        500, "name": "MQCMDL_LEVEL_500" },
    {  "value":        501, "name": "MQFB_PUBLICATIONS_ON_REQUEST" },
    {  "value":        502, "name": "MQFB_SUBSCRIBER_IS_PUBLISHER" },
    {  "value":        503, "name": "MQFB_MSG_SCOPE_MISMATCH" },
    {  "value":        504, "name": "MQFB_SELECTOR_MISMATCH" },
    {  "value":        505, "name": "MQFB_NOT_A_GROUPUR_MSG" },
    {  "value":        510, "name": "MQCMDL_LEVEL_510" },
    {  "value":        512, "name": "MQAUTHOPT_EXCLUDE_TEMP" },
    {  "value":        512, "name": "MQCBDO_DEREGISTER_CALL" },
    {  "value":        512, "name": "MQCNO_ISOLATED_BINDING" },
    {  "value":        512, "name": "MQDCC_TARGET_ENC_NATIVE" },
    {  "value":        512, "name": "MQDCC_TARGET_ENC_REVERSED" },
    {  "value":        512, "name": "MQENC_FLOAT_IEEE_REVERSED" },
    {  "value":        512, "name": "MQGMO_LOCK" },
    {  "value":        512, "name": "MQOO_PASS_ALL_CONTEXT" },
    {  "value":        512, "name": "MQOP_DEREGISTER" },
    {  "value":        512, "name": "MQPMO_PASS_ALL_CONTEXT" },
    {  "value":        512, "name": "MQREGO_DUPLICATES_OK" },
    {  "value":        512, "name": "MQROUTE_FORWARD_IF_SUPPORTED" },
    {  "value":        512, "name": "MQSO_ANY_USERID" },
    {  "value":        512, "name": "MQTYPE_FLOAT64" },
    {  "value":        512, "name": "MQZAO_SET_ALL_CONTEXT" },
    {  "value":        520, "name": "MQCMDL_LEVEL_520" },
    {  "value":        530, "name": "MQCMDL_LEVEL_530" },
    {  "value":        531, "name": "MQCMDL_LEVEL_531" },
    {  "value":        532, "name": "MQSCO_LENGTH_1 (4 byte)" },
    {  "value":        536, "name": "MQSCO_LENGTH_1 (8 byte)" },
    {  "value":        540, "name": "MQSCO_LENGTH_2 (4 byte)" },
    {  "value":        544, "name": "MQSCO_LENGTH_2 (8 byte)" },
    {  "value":        546, "name": "MQENC_NATIVE" },
    {  "value":        546, "name": "MQENC_REVERSED" },
    {  "value":        556, "name": "MQSCO_LENGTH_3 (4 byte)" },
    {  "value":        560, "name": "MQSCO_LENGTH_3 (8 byte)" },
    {  "value":        560, "name": "MQSCO_LENGTH_4 (4 byte)" },
    {  "value":        568, "name": "MQSCO_LENGTH_4 (8 byte)" },
    {  "value":        576, "name": "MQAIR_CURRENT_LENGTH (4 byte)" },
    {  "value":        576, "name": "MQAIR_LENGTH_2 (4 byte)" },
    {  "value":        584, "name": "MQAIR_CURRENT_LENGTH (8 byte)" },
    {  "value":        584, "name": "MQAIR_LENGTH_2 (8 byte)" },
    {  "value":        600, "name": "MQCHSSTATE_HEARTBEATING" },
    {  "value":        600, "name": "MQCMDL_LEVEL_600" },
    {  "value":        600, "name": "MQFB_IMS_NACK_1A_REASON_FIRST" },
    {  "value":        624, "name": "MQSCO_LENGTH_5 (4 byte)" },
    {  "value":        632, "name": "MQSCO_LENGTH_5 (8 byte)" },
    {  "value":        636, "name": "MQSCO_LENGTH_6 (4 byte)" },
    {  "value":        648, "name": "MQSCO_LENGTH_6 (8 byte)" },
    {  "value":        656, "name": "MQSCO_CURRENT_LENGTH (4 byte)" },
    {  "value":        656, "name": "MQSCO_LENGTH_7 (4 byte)" },
    {  "value":        672, "name": "MQSCO_CURRENT_LENGTH (8 byte)" },
    {  "value":        672, "name": "MQSCO_LENGTH_7 (8 byte)" },
    {  "value":        684, "name": "MQTMC2_LENGTH_1" },
    {  "value":        684, "name": "MQTMC_CURRENT_LENGTH" },
    {  "value":        684, "name": "MQTMC_LENGTH_1" },
    {  "value":        684, "name": "MQTM_CURRENT_LENGTH" },
    {  "value":        684, "name": "MQTM_LENGTH_1" },
    {  "value":        700, "name": "MQCHSSTATE_IN_SCYEXIT" },
    {  "value":        700, "name": "MQCMDL_LEVEL_700" },
    {  "value":        701, "name": "MQCMDL_LEVEL_701" },
    {  "value":        701, "name": "MQIAMO_FIRST" },
    {  "value":        702, "name": "MQIAMO_AVG_BATCH_SIZE" },
    {  "value":        703, "name": "MQIAMO64_AVG_Q_TIME" },
    {  "value":        703, "name": "MQIAMO_AVG_Q_TIME" },
    {  "value":        704, "name": "MQIAMO_BACKOUTS" },
    {  "value":        705, "name": "MQIAMO_BROWSES" },
    {  "value":        706, "name": "MQIAMO_BROWSE_MAX_BYTES" },
    {  "value":        707, "name": "MQIAMO_BROWSE_MIN_BYTES" },
    {  "value":        708, "name": "MQIAMO_BROWSES_FAILED" },
    {  "value":        709, "name": "MQIAMO_CLOSES" },
    {  "value":        710, "name": "MQCMDL_LEVEL_710" },
    {  "value":        710, "name": "MQIAMO_COMMITS" },
    {  "value":        711, "name": "MQCMDL_LEVEL_711" },
    {  "value":        711, "name": "MQIAMO_COMMITS_FAILED" },
    {  "value":        712, "name": "MQIAMO_CONNS" },
    {  "value":        713, "name": "MQIAMO_CONNS_MAX" },
    {  "value":        714, "name": "MQIAMO_DISCS" },
    {  "value":        715, "name": "MQIAMO_DISCS_IMPLICIT" },
    {  "value":        716, "name": "MQIAMO_DISC_TYPE" },
    {  "value":        717, "name": "MQIAMO_EXIT_TIME_AVG" },
    {  "value":        718, "name": "MQIAMO_EXIT_TIME_MAX" },
    {  "value":        719, "name": "MQIAMO_EXIT_TIME_MIN" },
    {  "value":        720, "name": "MQIAMO_FULL_BATCHES" },
    {  "value":        721, "name": "MQIAMO_GENERATED_MSGS" },
    {  "value":        722, "name": "MQIAMO_GETS" },
    {  "value":        723, "name": "MQIAMO_GET_MAX_BYTES" },
    {  "value":        724, "name": "MQIAMO_GET_MIN_BYTES" },
    {  "value":        725, "name": "MQIAMO_GETS_FAILED" },
    {  "value":        726, "name": "MQIAMO_INCOMPLETE_BATCHES" },
    {  "value":        727, "name": "MQIAMO_INQS" },
    {  "value":        728, "name": "MQIAMO_MSGS" },
    {  "value":        729, "name": "MQIAMO_NET_TIME_AVG" },
    {  "value":        730, "name": "MQIAMO_NET_TIME_MAX" },
    {  "value":        731, "name": "MQIAMO_NET_TIME_MIN" },
    {  "value":        732, "name": "MQIAMO_OBJECT_COUNT" },
    {  "value":        732, "name": "MQTMC2_CURRENT_LENGTH" },
    {  "value":        732, "name": "MQTMC2_LENGTH_2" },
    {  "value":        733, "name": "MQIAMO_OPENS" },
    {  "value":        734, "name": "MQIAMO_PUT1S" },
    {  "value":        735, "name": "MQIAMO_PUTS" },
    {  "value":        736, "name": "MQIAMO_PUT_MAX_BYTES" },
    {  "value":        737, "name": "MQIAMO_PUT_MIN_BYTES" },
    {  "value":        738, "name": "MQIAMO_PUT_RETRIES" },
    {  "value":        739, "name": "MQIAMO_Q_MAX_DEPTH" },
    {  "value":        740, "name": "MQIAMO_Q_MIN_DEPTH" },
    {  "value":        741, "name": "MQIAMO64_Q_TIME_AVG" },
    {  "value":        741, "name": "MQIAMO_Q_TIME_AVG" },
    {  "value":        742, "name": "MQIAMO64_Q_TIME_MAX" },
    {  "value":        742, "name": "MQIAMO_Q_TIME_MAX" },
    {  "value":        743, "name": "MQIAMO64_Q_TIME_MIN" },
    {  "value":        743, "name": "MQIAMO_Q_TIME_MIN" },
    {  "value":        744, "name": "MQIAMO_SETS" },
    {  "value":        745, "name": "MQIAMO64_BROWSE_BYTES" },
    {  "value":        746, "name": "MQIAMO64_BYTES" },
    {  "value":        747, "name": "MQIAMO64_GET_BYTES" },
    {  "value":        748, "name": "MQIAMO64_PUT_BYTES" },
    {  "value":        749, "name": "MQIAMO_CONNS_FAILED" },
    {  "value":        750, "name": "MQCMDL_LEVEL_750" },
    {  "value":        751, "name": "MQIAMO_OPENS_FAILED" },
    {  "value":        752, "name": "MQIAMO_INQS_FAILED" },
    {  "value":        753, "name": "MQIAMO_SETS_FAILED" },
    {  "value":        754, "name": "MQIAMO_PUTS_FAILED" },
    {  "value":        755, "name": "MQIAMO_PUT1S_FAILED" },
    {  "value":        757, "name": "MQIAMO_CLOSES_FAILED" },
    {  "value":        758, "name": "MQIAMO_MSGS_EXPIRED" },
    {  "value":        759, "name": "MQIAMO_MSGS_NOT_QUEUED" },
    {  "value":        760, "name": "MQIAMO_MSGS_PURGED" },
    {  "value":        764, "name": "MQIAMO_SUBS_DUR" },
    {  "value":        765, "name": "MQIAMO_SUBS_NDUR" },
    {  "value":        766, "name": "MQIAMO_SUBS_FAILED" },
    {  "value":        767, "name": "MQIAMO_SUBRQS" },
    {  "value":        768, "name": "MQENC_FLOAT_S390" },
    {  "value":        768, "name": "MQIAMO_SUBRQS_FAILED" },
    {  "value":        768, "name": "MQRO_COA_WITH_DATA" },
    {  "value":        769, "name": "MQIAMO_CBS" },
    {  "value":        770, "name": "MQIAMO_CBS_FAILED" },
    {  "value":        771, "name": "MQIAMO_CTLS" },
    {  "value":        772, "name": "MQIAMO_CTLS_FAILED" },
    {  "value":        773, "name": "MQIAMO_STATS" },
    {  "value":        774, "name": "MQIAMO_STATS_FAILED" },
    {  "value":        775, "name": "MQIAMO_SUB_DUR_HIGHWATER" },
    {  "value":        776, "name": "MQIAMO_SUB_DUR_LOWWATER" },
    {  "value":        777, "name": "MQIAMO_SUB_NDUR_HIGHWATER" },
    {  "value":        778, "name": "MQIAMO_SUB_NDUR_LOWWATER" },
    {  "value":        779, "name": "MQIAMO_TOPIC_PUTS" },
    {  "value":        780, "name": "MQIAMO_TOPIC_PUTS_FAILED" },
    {  "value":        781, "name": "MQIAMO_TOPIC_PUT1S" },
    {  "value":        782, "name": "MQIAMO_TOPIC_PUT1S_FAILED" },
    {  "value":        783, "name": "MQIAMO64_TOPIC_PUT_BYTES" },
    {  "value":        784, "name": "MQIAMO_PUBLISH_MSG_COUNT" },
    {  "value":        785, "name": "MQENC_S390" },
    {  "value":        785, "name": "MQIAMO64_PUBLISH_MSG_BYTES" },
    {  "value":        786, "name": "MQIAMO_UNSUBS_DUR" },
    {  "value":        787, "name": "MQIAMO_UNSUBS_NDUR" },
    {  "value":        788, "name": "MQIAMO_UNSUBS_FAILED" },
    {  "value":        789, "name": "MQIAMO_INTERVAL" },
    {  "value":        790, "name": "MQIAMO_MSGS_SENT" },
    {  "value":        791, "name": "MQIAMO_BYTES_SENT" },
    {  "value":        792, "name": "MQIAMO_REPAIR_BYTES" },
    {  "value":        793, "name": "MQIAMO_FEEDBACK_MODE" },
    {  "value":        794, "name": "MQIAMO_RELIABILITY_TYPE" },
    {  "value":        795, "name": "MQIAMO_LATE_JOIN_MARK" },
    {  "value":        796, "name": "MQIAMO_NACKS_RCVD" },
    {  "value":        797, "name": "MQIAMO_REPAIR_PKTS" },
    {  "value":        798, "name": "MQIAMO_HISTORY_PKTS" },
    {  "value":        799, "name": "MQIAMO_PENDING_PKTS" },
    {  "value":        800, "name": "MQCHSSTATE_IN_RCVEXIT" },
    {  "value":        800, "name": "MQCMDL_LEVEL_800" },
    {  "value":        800, "name": "MQIAMO_PKT_RATE" },
    {  "value":        801, "name": "MQCMDL_LEVEL_801" },
    {  "value":        801, "name": "MQIAMO_MCAST_XMIT_RATE" },
    {  "value":        802, "name": "MQCMDL_LEVEL_802" },
    {  "value":        802, "name": "MQIAMO_MCAST_BATCH_TIME" },
    {  "value":        803, "name": "MQIAMO_MCAST_HEARTBEAT" },
    {  "value":        804, "name": "MQIAMO_DEST_DATA_PORT" },
    {  "value":        805, "name": "MQIAMO_DEST_REPAIR_PORT" },
    {  "value":        806, "name": "MQIAMO_ACKS_RCVD" },
    {  "value":        807, "name": "MQIAMO_ACTIVE_ACKERS" },
    {  "value":        808, "name": "MQIAMO_PKTS_SENT" },
    {  "value":        809, "name": "MQIAMO_TOTAL_REPAIR_PKTS" },
    {  "value":        810, "name": "MQIAMO_TOTAL_PKTS_SENT" },
    {  "value":        811, "name": "MQIAMO_TOTAL_MSGS_SENT" },
    {  "value":        812, "name": "MQIAMO_TOTAL_BYTES_SENT" },
    {  "value":        813, "name": "MQIAMO_NUM_STREAMS" },
    {  "value":        814, "name": "MQIAMO_ACK_FEEDBACK" },
    {  "value":        815, "name": "MQIAMO_NACK_FEEDBACK" },
    {  "value":        816, "name": "MQIAMO_PKTS_LOST" },
    {  "value":        817, "name": "MQIAMO_MSGS_RCVD" },
    {  "value":        818, "name": "MQIAMO_MSG_BYTES_RCVD" },
    {  "value":        819, "name": "MQIAMO_MSGS_DELIVERED" },
    {  "value":        820, "name": "MQIAMO_PKTS_PROCESSED" },
    {  "value":        821, "name": "MQIAMO_PKTS_DELIVERED" },
    {  "value":        822, "name": "MQIAMO_PKTS_DROPPED" },
    {  "value":        823, "name": "MQIAMO_PKTS_DUPLICATED" },
    {  "value":        824, "name": "MQIAMO_NACKS_CREATED" },
    {  "value":        825, "name": "MQIAMO_NACK_PKTS_SENT" },
    {  "value":        826, "name": "MQIAMO_REPAIR_PKTS_RQSTD" },
    {  "value":        827, "name": "MQIAMO_REPAIR_PKTS_RCVD" },
    {  "value":        828, "name": "MQIAMO_PKTS_REPAIRED" },
    {  "value":        829, "name": "MQIAMO_TOTAL_MSGS_RCVD" },
    {  "value":        830, "name": "MQIAMO_TOTAL_MSG_BYTES_RCVD" },
    {  "value":        831, "name": "MQIAMO_TOTAL_REPAIR_PKTS_RCVD" },
    {  "value":        832, "name": "MQIAMO_TOTAL_REPAIR_PKTS_RQSTD" },
    {  "value":        833, "name": "MQIAMO_TOTAL_MSGS_PROCESSED" },
    {  "value":        834, "name": "MQIAMO_TOTAL_MSGS_SELECTED" },
    {  "value":        835, "name": "MQIAMO_TOTAL_MSGS_EXPIRED" },
    {  "value":        836, "name": "MQIAMO_TOTAL_MSGS_DELIVERED" },
    {  "value":        837, "name": "MQIAMO_TOTAL_MSGS_RETURNED" },
    {  "value":        838, "name": "MQIAMO64_HIGHRES_TIME" },
    {  "value":        839, "name": "MQIAMO_MONITOR_CLASS" },
    {  "value":        840, "name": "MQIAMO_MONITOR_TYPE" },
    {  "value":        841, "name": "MQIAMO_MONITOR_ELEMENT" },
    {  "value":        842, "name": "MQIAMO_MONITOR_DATATYPE" },
    {  "value":        843, "name": "MQIAMO_MONITOR_FLAGS" },
    {  "value":        844, "name": "MQIAMO64_QMGR_OP_DURATION" },
    {  "value":        845, "name": "MQIAMO64_MONITOR_INTERVAL" },
    {  "value":        845, "name": "MQIAMO_LAST_USED" },
    {  "value":        855, "name": "MQFB_IMS_NACK_1A_REASON_LAST" },
    {  "value":        900, "name": "MQCHSSTATE_IN_SENDEXIT" },
    {  "value":        900, "name": "MQCMDL_LEVEL_900" },
    {  "value":        900, "name": "MQRC_APPL_FIRST" },
    {  "value":        901, "name": "MQCMDL_LEVEL_901" },
    {  "value":        902, "name": "MQCMDL_LEVEL_902" },
    {  "value":        903, "name": "MQCMDL_LEVEL_903" },
    {  "value":        904, "name": "MQCMDL_LEVEL_904" },
    {  "value":        905, "name": "MQCMDL_LEVEL_905" },
    {  "value":        910, "name": "MQCMDL_LEVEL_910" },
    {  "value":        911, "name": "MQCMDL_LEVEL_911" },
    {  "value":        912, "name": "MQCMDL_LEVEL_912" },
    {  "value":        913, "name": "MQCMDL_LEVEL_913" },
    {  "value":        914, "name": "MQCMDL_LEVEL_914" },
    {  "value":        915, "name": "MQCMDL_LEVEL_915" },
    {  "value":        920, "name": "MQCMDL_LEVEL_920" },
    {  "value":        921, "name": "MQCMDL_LEVEL_921" },
    {  "value":        922, "name": "MQCMDL_LEVEL_922" },
    {  "value":        923, "name": "MQCMDL_LEVEL_923" },
    {  "value":        924, "name": "MQCMDL_LEVEL_924" },
    {  "value":        925, "name": "MQCMDL_LEVEL_925" },
    {  "value":        930, "name": "MQCMDL_LEVEL_930" },
    {  "value":        931, "name": "MQCMDL_LEVEL_931" },
    {  "value":        932, "name": "MQCMDL_LEVEL_932" },
    {  "value":        933, "name": "MQCMDL_LEVEL_933" },
    {  "value":        934, "name": "MQCMDL_LEVEL_934" },
    {  "value":        935, "name": "MQCMDL_LEVEL_935" },
    {  "value":        940, "name": "MQCMDL_LEVEL_940" },
    {  "value":        941, "name": "MQCMDL_LEVEL_941" },
    {  "value":        942, "name": "MQCMDL_LEVEL_942" },
    {  "value":        943, "name": "MQCMDL_LEVEL_943" },
    {  "value":        944, "name": "MQCMDL_CURRENT_LEVEL" },
    {  "value":        944, "name": "MQCMDL_LEVEL_944" },
    {  "value":        984, "name": "MQCDC_LENGTH_1" },
    {  "value":        984, "name": "MQCD_LENGTH_1" },
    {  "value":        999, "name": "MQOT_RESERVED_1" },
    {  "value":        999, "name": "MQRC_APPL_LAST" },
    {  "value":        999, "name": "MQ_TOTAL_EXIT_DATA_LENGTH" },
    {  "value":        999, "name": "MQ_TOTAL_EXIT_NAME_LENGTH" },
    {  "value":       1000, "name": "MQCHSSTATE_IN_MSGEXIT" },
    {  "value":       1001, "name": "MQIACF_FIRST" },
    {  "value":       1001, "name": "MQIACF_Q_MGR_ATTRS" },
    {  "value":       1001, "name": "MQNT_ALL" },
    {  "value":       1001, "name": "MQOT_ALL" },
    {  "value":       1001, "name": "MQQT_ALL" },
    {  "value":       1002, "name": "MQIACF_Q_ATTRS" },
    {  "value":       1002, "name": "MQOT_ALIAS_Q" },
    {  "value":       1003, "name": "MQIACF_PROCESS_ATTRS" },
    {  "value":       1003, "name": "MQOT_MODEL_Q" },
    {  "value":       1004, "name": "MQIACF_NAMELIST_ATTRS" },
    {  "value":       1004, "name": "MQOT_LOCAL_Q" },
    {  "value":       1005, "name": "MQIACF_FORCE" },
    {  "value":       1005, "name": "MQOT_REMOTE_Q" },
    {  "value":       1006, "name": "MQIACF_REPLACE" },
    {  "value":       1007, "name": "MQIACF_PURGE" },
    {  "value":       1007, "name": "MQOT_SENDER_CHANNEL" },
    {  "value":       1008, "name": "MQIACF_MODE" },
    {  "value":       1008, "name": "MQIACF_QUIESCE" },
    {  "value":       1008, "name": "MQOT_SERVER_CHANNEL" },
    {  "value":       1009, "name": "MQIACF_ALL" },
    {  "value":       1009, "name": "MQOT_REQUESTER_CHANNEL" },
    {  "value":       1010, "name": "MQIACF_EVENT_APPL_TYPE" },
    {  "value":       1010, "name": "MQOT_RECEIVER_CHANNEL" },
    {  "value":       1011, "name": "MQIACF_EVENT_ORIGIN" },
    {  "value":       1011, "name": "MQOT_CURRENT_CHANNEL" },
    {  "value":       1012, "name": "MQIACF_PARAMETER_ID" },
    {  "value":       1012, "name": "MQOT_SAVED_CHANNEL" },
    {  "value":       1013, "name": "MQIACF_ERROR_ID" },
    {  "value":       1013, "name": "MQIACF_ERROR_IDENTIFIER" },
    {  "value":       1013, "name": "MQOT_SVRCONN_CHANNEL" },
    {  "value":       1014, "name": "MQIACF_SELECTOR" },
    {  "value":       1014, "name": "MQOT_CLNTCONN_CHANNEL" },
    {  "value":       1015, "name": "MQIACF_CHANNEL_ATTRS" },
    {  "value":       1015, "name": "MQOT_SHORT_CHANNEL" },
    {  "value":       1016, "name": "MQIACF_OBJECT_TYPE" },
    {  "value":       1016, "name": "MQOT_CHLAUTH" },
    {  "value":       1017, "name": "MQIACF_ESCAPE_TYPE" },
    {  "value":       1017, "name": "MQOT_REMOTE_Q_MGR_NAME" },
    {  "value":       1018, "name": "MQIACF_ERROR_OFFSET" },
    {  "value":       1019, "name": "MQIACF_AUTH_INFO_ATTRS" },
    {  "value":       1019, "name": "MQOT_PROT_POLICY" },
    {  "value":       1020, "name": "MQIACF_REASON_QUALIFIER" },
    {  "value":       1020, "name": "MQOT_TT_CHANNEL" },
    {  "value":       1021, "name": "MQIACF_COMMAND" },
    {  "value":       1021, "name": "MQOT_AMQP_CHANNEL" },
    {  "value":       1022, "name": "MQIACF_OPEN_OPTIONS" },
    {  "value":       1022, "name": "MQOT_AUTH_REC" },
    {  "value":       1023, "name": "MQIACF_OPEN_TYPE" },
    {  "value":       1023, "name": "MQPD_ACCEPT_UNSUP_MASK" },
    {  "value":       1024, "name": "MQCNO_LOCAL_BINDING" },
    {  "value":       1024, "name": "MQENC_FLOAT_TNS" },
    {  "value":       1024, "name": "MQGMO_UNLOCK" },
    {  "value":       1024, "name": "MQIACF_PROCESS_ID" },
    {  "value":       1024, "name": "MQIAMO_MONITOR_KB" },
    {  "value":       1024, "name": "MQOO_SET_IDENTITY_CONTEXT" },
    {  "value":       1024, "name": "MQPD_SUPPORT_REQUIRED_IF_LOCAL" },
    {  "value":       1024, "name": "MQPMO_SET_IDENTITY_CONTEXT" },
    {  "value":       1024, "name": "MQREGO_NON_PERSISTENT" },
    {  "value":       1024, "name": "MQTYPE_STRING" },
    {  "value":       1024, "name": "MQZAO_ALTERNATE_USER_AUTHORITY" },
    {  "value":       1024, "name": "MQ_CLIENT_USER_ID_LENGTH" },
    {  "value":       1024, "name": "MQ_DISTINGUISHED_NAME_LENGTH" },
    {  "value":       1024, "name": "MQ_ENTITY_NAME_LENGTH" },
    {  "value":       1024, "name": "MQ_JAAS_CONFIG_LENGTH" },
    {  "value":       1024, "name": "MQ_LDAP_BASE_DN_LENGTH" },
    {  "value":       1024, "name": "MQ_LDAP_MCA_USER_ID_LENGTH" },
    {  "value":       1024, "name": "MQ_LOG_PATH_LENGTH" },
    {  "value":       1024, "name": "MQ_LONG_USER_ID_LENGTH" },
    {  "value":       1024, "name": "MQ_MAX_LDAP_MCA_USER_ID_LENGTH" },
    {  "value":       1024, "name": "MQ_Q_MGR_DATA_PATH_LENGTH" },
    {  "value":       1024, "name": "MQ_SSL_KEY_PASSPHRASE_LENGTH" },
    {  "value":       1024, "name": "MQ_SSL_KEY_REPO_PWD_LEN" },
    {  "value":       1024, "name": "MQ_SSL_PEER_NAME_LENGTH" },
    {  "value":       1025, "name": "MQIACF_THREAD_ID" },
    {  "value":       1026, "name": "MQIACF_Q_STATUS_ATTRS" },
    {  "value":       1027, "name": "MQIACF_UNCOMMITTED_MSGS" },
    {  "value":       1028, "name": "MQIACF_HANDLE_STATE" },
    {  "value":       1041, "name": "MQENC_TNS" },
    {  "value":       1070, "name": "MQIACF_AUX_ERROR_DATA_INT_1" },
    {  "value":       1071, "name": "MQIACF_AUX_ERROR_DATA_INT_2" },
    {  "value":       1072, "name": "MQIACF_CONV_REASON_CODE" },
    {  "value":       1073, "name": "MQIACF_BRIDGE_TYPE" },
    {  "value":       1074, "name": "MQIACF_INQUIRY" },
    {  "value":       1075, "name": "MQIACF_WAIT_INTERVAL" },
    {  "value":       1076, "name": "MQIACF_OPTIONS" },
    {  "value":       1077, "name": "MQIACF_BROKER_OPTIONS" },
    {  "value":       1078, "name": "MQIACF_REFRESH_TYPE" },
    {  "value":       1079, "name": "MQIACF_SEQUENCE_NUMBER" },
    {  "value":       1080, "name": "MQIACF_INTEGER_DATA" },
    {  "value":       1081, "name": "MQIACF_REGISTRATION_OPTIONS" },
    {  "value":       1082, "name": "MQIACF_PUBLICATION_OPTIONS" },
    {  "value":       1083, "name": "MQIACF_CLUSTER_INFO" },
    {  "value":       1084, "name": "MQIACF_Q_MGR_DEFINITION_TYPE" },
    {  "value":       1085, "name": "MQIACF_Q_MGR_TYPE" },
    {  "value":       1086, "name": "MQIACF_ACTION" },
    {  "value":       1087, "name": "MQIACF_SUSPEND" },
    {  "value":       1088, "name": "MQIACF_BROKER_COUNT" },
    {  "value":       1089, "name": "MQIACF_APPL_COUNT" },
    {  "value":       1090, "name": "MQIACF_ANONYMOUS_COUNT" },
    {  "value":       1091, "name": "MQIACF_REG_REG_OPTIONS" },
    {  "value":       1092, "name": "MQIACF_DELETE_OPTIONS" },
    {  "value":       1093, "name": "MQIACF_CLUSTER_Q_MGR_ATTRS" },
    {  "value":       1094, "name": "MQIACF_REFRESH_INTERVAL" },
    {  "value":       1095, "name": "MQIACF_REFRESH_REPOSITORY" },
    {  "value":       1096, "name": "MQIACF_REMOVE_QUEUES" },
    {  "value":       1098, "name": "MQIACF_OPEN_INPUT_TYPE" },
    {  "value":       1099, "name": "MQIACF_OPEN_OUTPUT" },
    {  "value":       1100, "name": "MQCHSSTATE_IN_MREXIT" },
    {  "value":       1100, "name": "MQIACF_OPEN_SET" },
    {  "value":       1101, "name": "MQIACF_OPEN_INQUIRE" },
    {  "value":       1102, "name": "MQIACF_OPEN_BROWSE" },
    {  "value":       1103, "name": "MQIACF_Q_STATUS_TYPE" },
    {  "value":       1104, "name": "MQIACF_Q_HANDLE" },
    {  "value":       1105, "name": "MQIACF_Q_STATUS" },
    {  "value":       1106, "name": "MQIACF_SECURITY_TYPE" },
    {  "value":       1107, "name": "MQIACF_CONNECTION_ATTRS" },
    {  "value":       1108, "name": "MQIACF_CONNECT_OPTIONS" },
    {  "value":       1108, "name": "MQZIC_CURRENT_LENGTH" },
    {  "value":       1108, "name": "MQZIC_LENGTH_2" },
    {  "value":       1110, "name": "MQIACF_CONN_INFO_TYPE" },
    {  "value":       1111, "name": "MQIACF_CONN_INFO_CONN" },
    {  "value":       1112, "name": "MQIACF_CONN_INFO_HANDLE" },
    {  "value":       1113, "name": "MQIACF_CONN_INFO_ALL" },
    {  "value":       1114, "name": "MQIACF_AUTH_PROFILE_ATTRS" },
    {  "value":       1115, "name": "MQIACF_AUTHORIZATION_LIST" },
    {  "value":       1116, "name": "MQIACF_AUTH_ADD_AUTHS" },
    {  "value":       1117, "name": "MQIACF_AUTH_REMOVE_AUTHS" },
    {  "value":       1118, "name": "MQIACF_ENTITY_TYPE" },
    {  "value":       1120, "name": "MQIACF_COMMAND_INFO" },
    {  "value":       1121, "name": "MQIACF_CMDSCOPE_Q_MGR_COUNT" },
    {  "value":       1122, "name": "MQIACF_Q_MGR_SYSTEM" },
    {  "value":       1123, "name": "MQIACF_Q_MGR_EVENT" },
    {  "value":       1124, "name": "MQIACF_Q_MGR_DQM" },
    {  "value":       1125, "name": "MQIACF_Q_MGR_CLUSTER" },
    {  "value":       1126, "name": "MQIACF_QSG_DISPS" },
    {  "value":       1128, "name": "MQIACF_UOW_STATE" },
    {  "value":       1129, "name": "MQIACF_SECURITY_ITEM" },
    {  "value":       1130, "name": "MQIACF_CF_STRUC_STATUS" },
    {  "value":       1132, "name": "MQIACF_UOW_TYPE" },
    {  "value":       1133, "name": "MQIACF_CF_STRUC_ATTRS" },
    {  "value":       1134, "name": "MQIACF_EXCLUDE_INTERVAL" },
    {  "value":       1135, "name": "MQIACF_CF_STATUS_TYPE" },
    {  "value":       1136, "name": "MQIACF_CF_STATUS_SUMMARY" },
    {  "value":       1137, "name": "MQIACF_CF_STATUS_CONNECT" },
    {  "value":       1138, "name": "MQIACF_CF_STATUS_BACKUP" },
    {  "value":       1139, "name": "MQIACF_CF_STRUC_TYPE" },
    {  "value":       1140, "name": "MQIACF_CF_STRUC_SIZE_MAX" },
    {  "value":       1141, "name": "MQIACF_CF_STRUC_SIZE_USED" },
    {  "value":       1142, "name": "MQIACF_CF_STRUC_ENTRIES_MAX" },
    {  "value":       1143, "name": "MQIACF_CF_STRUC_ENTRIES_USED" },
    {  "value":       1144, "name": "MQIACF_CF_STRUC_BACKUP_SIZE" },
    {  "value":       1145, "name": "MQIACF_MOVE_TYPE" },
    {  "value":       1146, "name": "MQIACF_MOVE_TYPE_MOVE" },
    {  "value":       1147, "name": "MQIACF_MOVE_TYPE_ADD" },
    {  "value":       1148, "name": "MQIACF_Q_MGR_NUMBER" },
    {  "value":       1149, "name": "MQIACF_Q_MGR_STATUS" },
    {  "value":       1150, "name": "MQIACF_DB2_CONN_STATUS" },
    {  "value":       1151, "name": "MQIACF_SECURITY_ATTRS" },
    {  "value":       1152, "name": "MQIACF_SECURITY_TIMEOUT" },
    {  "value":       1153, "name": "MQIACF_SECURITY_INTERVAL" },
    {  "value":       1154, "name": "MQIACF_SECURITY_SWITCH" },
    {  "value":       1155, "name": "MQIACF_SECURITY_SETTING" },
    {  "value":       1156, "name": "MQIACF_STORAGE_CLASS_ATTRS" },
    {  "value":       1157, "name": "MQIACF_USAGE_TYPE" },
    {  "value":       1158, "name": "MQIACF_BUFFER_POOL_ID" },
    {  "value":       1159, "name": "MQIACF_USAGE_TOTAL_PAGES" },
    {  "value":       1160, "name": "MQIACF_USAGE_UNUSED_PAGES" },
    {  "value":       1161, "name": "MQIACF_USAGE_PERSIST_PAGES" },
    {  "value":       1162, "name": "MQIACF_USAGE_NONPERSIST_PAGES" },
    {  "value":       1163, "name": "MQIACF_USAGE_RESTART_EXTENTS" },
    {  "value":       1164, "name": "MQIACF_USAGE_EXPAND_COUNT" },
    {  "value":       1165, "name": "MQIACF_PAGESET_STATUS" },
    {  "value":       1166, "name": "MQIACF_USAGE_TOTAL_BUFFERS" },
    {  "value":       1167, "name": "MQIACF_USAGE_DATA_SET_TYPE" },
    {  "value":       1168, "name": "MQIACF_USAGE_PAGESET" },
    {  "value":       1169, "name": "MQIACF_USAGE_DATA_SET" },
    {  "value":       1170, "name": "MQIACF_USAGE_BUFFER_POOL" },
    {  "value":       1171, "name": "MQIACF_MOVE_COUNT" },
    {  "value":       1172, "name": "MQIACF_EXPIRY_Q_COUNT" },
    {  "value":       1173, "name": "MQIACF_CONFIGURATION_OBJECTS" },
    {  "value":       1174, "name": "MQIACF_CONFIGURATION_EVENTS" },
    {  "value":       1175, "name": "MQIACF_SYSP_TYPE" },
    {  "value":       1176, "name": "MQIACF_SYSP_DEALLOC_INTERVAL" },
    {  "value":       1177, "name": "MQIACF_SYSP_MAX_ARCHIVE" },
    {  "value":       1178, "name": "MQIACF_SYSP_MAX_READ_TAPES" },
    {  "value":       1179, "name": "MQIACF_SYSP_IN_BUFFER_SIZE" },
    {  "value":       1180, "name": "MQIACF_SYSP_OUT_BUFFER_SIZE" },
    {  "value":       1181, "name": "MQIACF_SYSP_OUT_BUFFER_COUNT" },
    {  "value":       1182, "name": "MQIACF_SYSP_ARCHIVE" },
    {  "value":       1183, "name": "MQIACF_SYSP_DUAL_ACTIVE" },
    {  "value":       1184, "name": "MQIACF_SYSP_DUAL_ARCHIVE" },
    {  "value":       1185, "name": "MQIACF_SYSP_DUAL_BSDS" },
    {  "value":       1186, "name": "MQIACF_SYSP_MAX_CONNS" },
    {  "value":       1187, "name": "MQIACF_SYSP_MAX_CONNS_FORE" },
    {  "value":       1188, "name": "MQIACF_SYSP_MAX_CONNS_BACK" },
    {  "value":       1189, "name": "MQIACF_SYSP_EXIT_INTERVAL" },
    {  "value":       1190, "name": "MQIACF_SYSP_EXIT_TASKS" },
    {  "value":       1191, "name": "MQIACF_SYSP_CHKPOINT_COUNT" },
    {  "value":       1192, "name": "MQIACF_SYSP_OTMA_INTERVAL" },
    {  "value":       1193, "name": "MQIACF_SYSP_Q_INDEX_DEFER" },
    {  "value":       1194, "name": "MQIACF_SYSP_DB2_TASKS" },
    {  "value":       1195, "name": "MQIACF_SYSP_RESLEVEL_AUDIT" },
    {  "value":       1196, "name": "MQIACF_SYSP_ROUTING_CODE" },
    {  "value":       1197, "name": "MQIACF_SYSP_SMF_ACCOUNTING" },
    {  "value":       1198, "name": "MQIACF_SYSP_SMF_STATS" },
    {  "value":       1199, "name": "MQIACF_SYSP_SMF_INTERVAL" },
    {  "value":       1199, "name": "MQIACF_SYSP_SMF_STAT_TIME_MINS" },
    {  "value":       1200, "name": "MQCHSSTATE_IN_CHADEXIT" },
    {  "value":       1200, "name": "MQIACF_SYSP_TRACE_CLASS" },
    {  "value":       1201, "name": "MQIACF_SYSP_TRACE_SIZE" },
    {  "value":       1202, "name": "MQIACF_SYSP_WLM_INTERVAL" },
    {  "value":       1203, "name": "MQIACF_SYSP_ALLOC_UNIT" },
    {  "value":       1204, "name": "MQIACF_SYSP_ARCHIVE_RETAIN" },
    {  "value":       1205, "name": "MQIACF_SYSP_ARCHIVE_WTOR" },
    {  "value":       1206, "name": "MQIACF_SYSP_BLOCK_SIZE" },
    {  "value":       1207, "name": "MQIACF_SYSP_CATALOG" },
    {  "value":       1208, "name": "MQIACF_SYSP_COMPACT" },
    {  "value":       1209, "name": "MQIACF_SYSP_ALLOC_PRIMARY" },
    {  "value":       1210, "name": "MQIACF_SYSP_ALLOC_SECONDARY" },
    {  "value":       1211, "name": "MQIACF_SYSP_PROTECT" },
    {  "value":       1212, "name": "MQIACF_SYSP_QUIESCE_INTERVAL" },
    {  "value":       1213, "name": "MQIACF_SYSP_TIMESTAMP" },
    {  "value":       1214, "name": "MQIACF_SYSP_UNIT_ADDRESS" },
    {  "value":       1215, "name": "MQIACF_SYSP_UNIT_STATUS" },
    {  "value":       1216, "name": "MQIACF_SYSP_LOG_COPY" },
    {  "value":       1217, "name": "MQIACF_SYSP_LOG_USED" },
    {  "value":       1218, "name": "MQIACF_SYSP_LOG_SUSPEND" },
    {  "value":       1219, "name": "MQIACF_SYSP_OFFLOAD_STATUS" },
    {  "value":       1220, "name": "MQIACF_SYSP_TOTAL_LOGS" },
    {  "value":       1221, "name": "MQIACF_SYSP_FULL_LOGS" },
    {  "value":       1222, "name": "MQIACF_LISTENER_ATTRS" },
    {  "value":       1223, "name": "MQIACF_LISTENER_STATUS_ATTRS" },
    {  "value":       1224, "name": "MQIACF_SERVICE_ATTRS" },
    {  "value":       1225, "name": "MQIACF_SERVICE_STATUS_ATTRS" },
    {  "value":       1226, "name": "MQIACF_Q_TIME_INDICATOR" },
    {  "value":       1227, "name": "MQIACF_OLDEST_MSG_AGE" },
    {  "value":       1228, "name": "MQIACF_AUTH_OPTIONS" },
    {  "value":       1229, "name": "MQIACF_Q_MGR_STATUS_ATTRS" },
    {  "value":       1230, "name": "MQIACF_CONNECTION_COUNT" },
    {  "value":       1231, "name": "MQIACF_Q_MGR_FACILITY" },
    {  "value":       1232, "name": "MQIACF_CHINIT_STATUS" },
    {  "value":       1233, "name": "MQIACF_CMD_SERVER_STATUS" },
    {  "value":       1234, "name": "MQIACF_ROUTE_DETAIL" },
    {  "value":       1235, "name": "MQIACF_RECORDED_ACTIVITIES" },
    {  "value":       1236, "name": "MQIACF_MAX_ACTIVITIES" },
    {  "value":       1237, "name": "MQIACF_DISCONTINUITY_COUNT" },
    {  "value":       1238, "name": "MQIACF_ROUTE_ACCUMULATION" },
    {  "value":       1239, "name": "MQIACF_ROUTE_DELIVERY" },
    {  "value":       1240, "name": "MQIACF_OPERATION_TYPE" },
    {  "value":       1241, "name": "MQIACF_BACKOUT_COUNT" },
    {  "value":       1242, "name": "MQIACF_COMP_CODE" },
    {  "value":       1243, "name": "MQIACF_ENCODING" },
    {  "value":       1244, "name": "MQIACF_EXPIRY" },
    {  "value":       1245, "name": "MQIACF_FEEDBACK" },
    {  "value":       1247, "name": "MQIACF_MSG_FLAGS" },
    {  "value":       1248, "name": "MQIACF_MSG_LENGTH" },
    {  "value":       1249, "name": "MQIACF_MSG_TYPE" },
    {  "value":       1250, "name": "MQCHSSTATE_NET_CONNECTING" },
    {  "value":       1250, "name": "MQIACF_OFFSET" },
    {  "value":       1251, "name": "MQIACF_ORIGINAL_LENGTH" },
    {  "value":       1252, "name": "MQIACF_PERSISTENCE" },
    {  "value":       1253, "name": "MQIACF_PRIORITY" },
    {  "value":       1254, "name": "MQIACF_REASON_CODE" },
    {  "value":       1255, "name": "MQIACF_REPORT" },
    {  "value":       1256, "name": "MQIACF_VERSION" },
    {  "value":       1257, "name": "MQIACF_UNRECORDED_ACTIVITIES" },
    {  "value":       1258, "name": "MQIACF_MONITORING" },
    {  "value":       1259, "name": "MQIACF_ROUTE_FORWARDING" },
    {  "value":       1260, "name": "MQIACF_SERVICE_STATUS" },
    {  "value":       1261, "name": "MQIACF_Q_TYPES" },
    {  "value":       1262, "name": "MQIACF_USER_ID_SUPPORT" },
    {  "value":       1263, "name": "MQIACF_INTERFACE_VERSION" },
    {  "value":       1264, "name": "MQIACF_AUTH_SERVICE_ATTRS" },
    {  "value":       1265, "name": "MQIACF_USAGE_EXPAND_TYPE" },
    {  "value":       1266, "name": "MQIACF_SYSP_CLUSTER_CACHE" },
    {  "value":       1267, "name": "MQIACF_SYSP_DB2_BLOB_TASKS" },
    {  "value":       1268, "name": "MQIACF_SYSP_WLM_INT_UNITS" },
    {  "value":       1269, "name": "MQIACF_TOPIC_ATTRS" },
    {  "value":       1271, "name": "MQIACF_PUBSUB_PROPERTIES" },
    {  "value":       1273, "name": "MQIACF_DESTINATION_CLASS" },
    {  "value":       1274, "name": "MQIACF_DURABLE_SUBSCRIPTION" },
    {  "value":       1275, "name": "MQIACF_SUBSCRIPTION_SCOPE" },
    {  "value":       1277, "name": "MQIACF_VARIABLE_USER_ID" },
    {  "value":       1280, "name": "MQIACF_REQUEST_ONLY" },
    {  "value":       1283, "name": "MQIACF_PUB_PRIORITY" },
    {  "value":       1287, "name": "MQIACF_SUB_ATTRS" },
    {  "value":       1288, "name": "MQIACF_WILDCARD_SCHEMA" },
    {  "value":       1289, "name": "MQIACF_SUB_TYPE" },
    {  "value":       1290, "name": "MQIACF_MESSAGE_COUNT" },
    {  "value":       1291, "name": "MQIACF_Q_MGR_PUBSUB" },
    {  "value":       1292, "name": "MQIACF_Q_MGR_VERSION" },
    {  "value":       1294, "name": "MQIACF_SUB_STATUS_ATTRS" },
    {  "value":       1295, "name": "MQIACF_TOPIC_STATUS" },
    {  "value":       1296, "name": "MQIACF_TOPIC_SUB" },
    {  "value":       1297, "name": "MQIACF_TOPIC_PUB" },
    {  "value":       1300, "name": "MQCHSSTATE_SSL_HANDSHAKING" },
    {  "value":       1300, "name": "MQIACF_RETAINED_PUBLICATION" },
    {  "value":       1301, "name": "MQIACF_TOPIC_STATUS_ATTRS" },
    {  "value":       1302, "name": "MQIACF_TOPIC_STATUS_TYPE" },
    {  "value":       1303, "name": "MQIACF_SUB_OPTIONS" },
    {  "value":       1304, "name": "MQIACF_PUBLISH_COUNT" },
    {  "value":       1305, "name": "MQIACF_CLEAR_TYPE" },
    {  "value":       1306, "name": "MQIACF_CLEAR_SCOPE" },
    {  "value":       1307, "name": "MQIACF_SUB_LEVEL" },
    {  "value":       1308, "name": "MQIACF_ASYNC_STATE" },
    {  "value":       1309, "name": "MQIACF_SUB_SUMMARY" },
    {  "value":       1310, "name": "MQIACF_OBSOLETE_MSGS" },
    {  "value":       1311, "name": "MQIACF_PUBSUB_STATUS" },
    {  "value":       1312, "name": "MQCDC_LENGTH_2" },
    {  "value":       1312, "name": "MQCD_LENGTH_2" },
    {  "value":       1314, "name": "MQIACF_PS_STATUS_TYPE" },
    {  "value":       1318, "name": "MQIACF_PUBSUB_STATUS_ATTRS" },
    {  "value":       1321, "name": "MQIACF_SELECTOR_TYPE" },
    {  "value":       1322, "name": "MQIACF_LOG_COMPRESSION" },
    {  "value":       1323, "name": "MQIACF_GROUPUR_CHECK_ID" },
    {  "value":       1324, "name": "MQIACF_MULC_CAPTURE" },
    {  "value":       1325, "name": "MQIACF_PERMIT_STANDBY" },
    {  "value":       1326, "name": "MQIACF_OPERATION_MODE" },
    {  "value":       1327, "name": "MQIACF_COMM_INFO_ATTRS" },
    {  "value":       1328, "name": "MQIACF_CF_SMDS_BLOCK_SIZE" },
    {  "value":       1329, "name": "MQIACF_CF_SMDS_EXPAND" },
    {  "value":       1330, "name": "MQIACF_USAGE_FREE_BUFF" },
    {  "value":       1331, "name": "MQIACF_USAGE_FREE_BUFF_PERC" },
    {  "value":       1332, "name": "MQIACF_CF_STRUC_ACCESS" },
    {  "value":       1333, "name": "MQIACF_CF_STATUS_SMDS" },
    {  "value":       1334, "name": "MQIACF_SMDS_ATTRS" },
    {  "value":       1335, "name": "MQIACF_USAGE_SMDS" },
    {  "value":       1336, "name": "MQIACF_USAGE_BLOCK_SIZE" },
    {  "value":       1337, "name": "MQIACF_USAGE_DATA_BLOCKS" },
    {  "value":       1338, "name": "MQIACF_USAGE_EMPTY_BUFFERS" },
    {  "value":       1339, "name": "MQIACF_USAGE_INUSE_BUFFERS" },
    {  "value":       1340, "name": "MQIACF_USAGE_LOWEST_FREE" },
    {  "value":       1341, "name": "MQIACF_USAGE_OFFLOAD_MSGS" },
    {  "value":       1342, "name": "MQIACF_USAGE_READS_SAVED" },
    {  "value":       1343, "name": "MQIACF_USAGE_SAVED_BUFFERS" },
    {  "value":       1344, "name": "MQIACF_USAGE_TOTAL_BLOCKS" },
    {  "value":       1345, "name": "MQIACF_USAGE_USED_BLOCKS" },
    {  "value":       1346, "name": "MQIACF_USAGE_USED_RATE" },
    {  "value":       1347, "name": "MQIACF_USAGE_WAIT_RATE" },
    {  "value":       1348, "name": "MQIACF_SMDS_OPENMODE" },
    {  "value":       1349, "name": "MQIACF_SMDS_STATUS" },
    {  "value":       1350, "name": "MQIACF_SMDS_AVAIL" },
    {  "value":       1351, "name": "MQIACF_MCAST_REL_INDICATOR" },
    {  "value":       1352, "name": "MQIACF_CHLAUTH_TYPE" },
    {  "value":       1354, "name": "MQIACF_MQXR_DIAGNOSTICS_TYPE" },
    {  "value":       1355, "name": "MQIACF_CHLAUTH_ATTRS" },
    {  "value":       1356, "name": "MQIACF_OPERATION_ID" },
    {  "value":       1357, "name": "MQIACF_API_CALLER_TYPE" },
    {  "value":       1358, "name": "MQIACF_API_ENVIRONMENT" },
    {  "value":       1359, "name": "MQIACF_TRACE_DETAIL" },
    {  "value":       1360, "name": "MQIACF_HOBJ" },
    {  "value":       1361, "name": "MQIACF_CALL_TYPE" },
    {  "value":       1362, "name": "MQIACF_MQCB_OPERATION" },
    {  "value":       1363, "name": "MQIACF_MQCB_TYPE" },
    {  "value":       1364, "name": "MQIACF_MQCB_OPTIONS" },
    {  "value":       1365, "name": "MQIACF_CLOSE_OPTIONS" },
    {  "value":       1366, "name": "MQIACF_CTL_OPERATION" },
    {  "value":       1367, "name": "MQIACF_GET_OPTIONS" },
    {  "value":       1368, "name": "MQIACF_RECS_PRESENT" },
    {  "value":       1369, "name": "MQIACF_KNOWN_DEST_COUNT" },
    {  "value":       1370, "name": "MQIACF_UNKNOWN_DEST_COUNT" },
    {  "value":       1371, "name": "MQIACF_INVALID_DEST_COUNT" },
    {  "value":       1372, "name": "MQIACF_RESOLVED_TYPE" },
    {  "value":       1373, "name": "MQIACF_PUT_OPTIONS" },
    {  "value":       1374, "name": "MQIACF_BUFFER_LENGTH" },
    {  "value":       1375, "name": "MQIACF_TRACE_DATA_LENGTH" },
    {  "value":       1376, "name": "MQIACF_SMDS_EXPANDST" },
    {  "value":       1377, "name": "MQIACF_STRUC_LENGTH" },
    {  "value":       1378, "name": "MQIACF_ITEM_COUNT" },
    {  "value":       1379, "name": "MQIACF_EXPIRY_TIME" },
    {  "value":       1380, "name": "MQIACF_CONNECT_TIME" },
    {  "value":       1381, "name": "MQIACF_DISCONNECT_TIME" },
    {  "value":       1382, "name": "MQIACF_HSUB" },
    {  "value":       1383, "name": "MQIACF_SUBRQ_OPTIONS" },
    {  "value":       1384, "name": "MQIACF_XA_RMID" },
    {  "value":       1385, "name": "MQIACF_XA_FLAGS" },
    {  "value":       1386, "name": "MQIACF_XA_RETCODE" },
    {  "value":       1387, "name": "MQIACF_XA_HANDLE" },
    {  "value":       1388, "name": "MQIACF_XA_RETVAL" },
    {  "value":       1389, "name": "MQIACF_STATUS_TYPE" },
    {  "value":       1390, "name": "MQIACF_XA_COUNT" },
    {  "value":       1391, "name": "MQIACF_SELECTOR_COUNT" },
    {  "value":       1392, "name": "MQIACF_SELECTORS" },
    {  "value":       1393, "name": "MQIACF_INTATTR_COUNT" },
    {  "value":       1394, "name": "MQIACF_INT_ATTRS" },
    {  "value":       1395, "name": "MQIACF_SUBRQ_ACTION" },
    {  "value":       1396, "name": "MQIACF_NUM_PUBS" },
    {  "value":       1397, "name": "MQIACF_POINTER_SIZE" },
    {  "value":       1398, "name": "MQIACF_REMOVE_AUTHREC" },
    {  "value":       1399, "name": "MQIACF_XR_ATTRS" },
    {  "value":       1400, "name": "MQCHSSTATE_NAME_SERVER" },
    {  "value":       1400, "name": "MQIACF_APPL_FUNCTION_TYPE" },
    {  "value":       1401, "name": "MQIACF_AMQP_ATTRS" },
    {  "value":       1402, "name": "MQIACF_EXPORT_TYPE" },
    {  "value":       1403, "name": "MQIACF_EXPORT_ATTRS" },
    {  "value":       1404, "name": "MQIACF_SYSTEM_OBJECTS" },
    {  "value":       1405, "name": "MQIACF_CONNECTION_SWAP" },
    {  "value":       1406, "name": "MQIACF_AMQP_DIAGNOSTICS_TYPE" },
    {  "value":       1408, "name": "MQIACF_BUFFER_POOL_LOCATION" },
    {  "value":       1409, "name": "MQIACF_LDAP_CONNECTION_STATUS" },
    {  "value":       1410, "name": "MQIACF_SYSP_MAX_ACE_POOL" },
    {  "value":       1411, "name": "MQIACF_PAGECLAS" },
    {  "value":       1412, "name": "MQIACF_AUTH_REC_TYPE" },
    {  "value":       1413, "name": "MQIACF_SYSP_MAX_CONC_OFFLOADS" },
    {  "value":       1414, "name": "MQIACF_SYSP_ZHYPERWRITE" },
    {  "value":       1415, "name": "MQIACF_Q_MGR_STATUS_LOG" },
    {  "value":       1416, "name": "MQIACF_ARCHIVE_LOG_SIZE" },
    {  "value":       1417, "name": "MQIACF_MEDIA_LOG_SIZE" },
    {  "value":       1418, "name": "MQIACF_RESTART_LOG_SIZE" },
    {  "value":       1419, "name": "MQIACF_REUSABLE_LOG_SIZE" },
    {  "value":       1420, "name": "MQIACF_LOG_IN_USE" },
    {  "value":       1421, "name": "MQIACF_LOG_UTILIZATION" },
    {  "value":       1422, "name": "MQIACF_LOG_REDUCTION" },
    {  "value":       1423, "name": "MQIACF_IGNORE_STATE" },
    {  "value":       1424, "name": "MQIACF_MOVABLE_APPL_COUNT" },
    {  "value":       1425, "name": "MQIACF_APPL_INFO_ATTRS" },
    {  "value":       1426, "name": "MQIACF_APPL_MOVABLE" },
    {  "value":       1427, "name": "MQIACF_REMOTE_QMGR_ACTIVE" },
    {  "value":       1428, "name": "MQIACF_APPL_INFO_TYPE" },
    {  "value":       1429, "name": "MQIACF_APPL_INFO_APPL" },
    {  "value":       1430, "name": "MQIACF_APPL_INFO_QMGR" },
    {  "value":       1431, "name": "MQIACF_APPL_INFO_LOCAL" },
    {  "value":       1432, "name": "MQIACF_APPL_IMMOVABLE_COUNT" },
    {  "value":       1433, "name": "MQIACF_BALANCED" },
    {  "value":       1434, "name": "MQIACF_BALSTATE" },
    {  "value":       1435, "name": "MQIACF_APPL_IMMOVABLE_REASON" },
    {  "value":       1436, "name": "MQIACF_DS_ENCRYPTED" },
    {  "value":       1437, "name": "MQIACF_CUR_Q_FILE_SIZE" },
    {  "value":       1438, "name": "MQIACF_CUR_MAX_FILE_SIZE" },
    {  "value":       1439, "name": "MQIACF_BALANCING_TYPE" },
    {  "value":       1440, "name": "MQIACF_BALANCING_OPTIONS" },
    {  "value":       1441, "name": "MQIACF_BALANCING_TIMEOUT" },
    {  "value":       1442, "name": "MQIACF_SYSP_SMF_STAT_TIME_SECS" },
    {  "value":       1443, "name": "MQIACF_SYSP_SMF_ACCT_TIME_MINS" },
    {  "value":       1444, "name": "MQIACF_SYSP_SMF_ACCT_TIME_SECS" },
    {  "value":       1445, "name": "MQIACF_Q_MGR_STATUS_INFO_TYPE" },
    {  "value":       1446, "name": "MQIACF_Q_MGR_STATUS_INFO_Q_MGR" },
    {  "value":       1447, "name": "MQIACF_Q_MGR_STATUS_INFO_NHA" },
    {  "value":       1448, "name": "MQIACF_AUTO_CLUSTER_TYPE" },
    {  "value":       1449, "name": "MQIACF_DATA_FS_IN_USE" },
    {  "value":       1450, "name": "MQIACF_DATA_FS_SIZE" },
    {  "value":       1451, "name": "MQIACF_LOG_EXTENT_SIZE" },
    {  "value":       1452, "name": "MQIACF_LOG_FS_IN_USE" },
    {  "value":       1453, "name": "MQIACF_LOG_FS_SIZE" },
    {  "value":       1454, "name": "MQIACF_LOG_PRIMARIES" },
    {  "value":       1455, "name": "MQIACF_LOG_SECONDARIES" },
    {  "value":       1456, "name": "MQIACF_LOG_TYPE" },
    {  "value":       1457, "name": "MQIACF_NHA_INSTANCE_ACTV_CONNS" },
    {  "value":       1458, "name": "MQIACF_NHA_INSTANCE_BACKLOG" },
    {  "value":       1459, "name": "MQIACF_NHA_INSTANCE_IN_SYNC" },
    {  "value":       1460, "name": "MQIACF_NHA_INSTANCE_ROLE" },
    {  "value":       1461, "name": "MQIACF_NHA_IN_SYNC_INSTANCES" },
    {  "value":       1462, "name": "MQIACF_NHA_TOTAL_INSTANCES" },
    {  "value":       1463, "name": "MQIACF_Q_MGR_FS_ENCRYPTED" },
    {  "value":       1464, "name": "MQIACF_Q_MGR_FS_IN_USE" },
    {  "value":       1465, "name": "MQIACF_Q_MGR_FS_SIZE" },
    {  "value":       1466, "name": "MQIACF_SYSP_ZHYPERLINK" },
    {  "value":       1468, "name": "MQIACF_CHECKPOINT_COUNT" },
    {  "value":       1469, "name": "MQIACF_CHECKPOINT_OPERATIONS" },
    {  "value":       1470, "name": "MQIACF_CHECKPOINT_SIZE" },
    {  "value":       1471, "name": "MQIACF_NHA_GROUP_BACKLOG" },
    {  "value":       1472, "name": "MQIACF_NHA_GROUP_CONNECTED" },
    {  "value":       1473, "name": "MQIACF_NHA_GROUP_IN_SYNC" },
    {  "value":       1474, "name": "MQIACF_NHA_GROUP_ROLE" },
    {  "value":       1475, "name": "MQIACF_NHA_GROUP_STATUS" },
    {  "value":       1476, "name": "MQIACF_NHA_INSTANCE_STATUS" },
    {  "value":       1477, "name": "MQIACF_NHA_TYPE" },
    {  "value":       1478, "name": "MQIACF_EVENT_DUPLICATE_COUNT" },
    {  "value":       1478, "name": "MQIACF_LAST_USED" },
    {  "value":       1480, "name": "MQCDC_LENGTH_3" },
    {  "value":       1480, "name": "MQCD_LENGTH_3" },
    {  "value":       1500, "name": "MQCHSSTATE_IN_MQPUT" },
    {  "value":       1501, "name": "MQIACH_FIRST" },
    {  "value":       1501, "name": "MQIACH_XMIT_PROTOCOL_TYPE" },
    {  "value":       1502, "name": "MQIACH_BATCH_SIZE" },
    {  "value":       1503, "name": "MQIACH_DISC_INTERVAL" },
    {  "value":       1504, "name": "MQIACH_SHORT_TIMER" },
    {  "value":       1505, "name": "MQIACH_SHORT_RETRY" },
    {  "value":       1506, "name": "MQIACH_LONG_TIMER" },
    {  "value":       1507, "name": "MQIACH_LONG_RETRY" },
    {  "value":       1508, "name": "MQIACH_PUT_AUTHORITY" },
    {  "value":       1509, "name": "MQIACH_SEQUENCE_NUMBER_WRAP" },
    {  "value":       1510, "name": "MQIACH_MAX_MSG_LENGTH" },
    {  "value":       1511, "name": "MQIACH_CHANNEL_TYPE" },
    {  "value":       1512, "name": "MQIACH_DATA_COUNT" },
    {  "value":       1513, "name": "MQIACH_NAME_COUNT" },
    {  "value":       1514, "name": "MQIACH_MSG_SEQUENCE_NUMBER" },
    {  "value":       1515, "name": "MQIACH_DATA_CONVERSION" },
    {  "value":       1516, "name": "MQIACH_IN_DOUBT" },
    {  "value":       1517, "name": "MQIACH_MCA_TYPE" },
    {  "value":       1518, "name": "MQIACH_SESSION_COUNT" },
    {  "value":       1519, "name": "MQIACH_ADAPTER" },
    {  "value":       1520, "name": "MQIACH_COMMAND_COUNT" },
    {  "value":       1521, "name": "MQIACH_SOCKET" },
    {  "value":       1522, "name": "MQIACH_PORT" },
    {  "value":       1523, "name": "MQIACH_CHANNEL_INSTANCE_TYPE" },
    {  "value":       1524, "name": "MQIACH_CHANNEL_INSTANCE_ATTRS" },
    {  "value":       1525, "name": "MQIACH_CHANNEL_ERROR_DATA" },
    {  "value":       1526, "name": "MQIACH_CHANNEL_TABLE" },
    {  "value":       1527, "name": "MQIACH_CHANNEL_STATUS" },
    {  "value":       1528, "name": "MQIACH_INDOUBT_STATUS" },
    {  "value":       1529, "name": "MQIACH_LAST_SEQUENCE_NUMBER" },
    {  "value":       1529, "name": "MQIACH_LAST_SEQ_NUMBER" },
    {  "value":       1531, "name": "MQIACH_CURRENT_MSGS" },
    {  "value":       1532, "name": "MQIACH_CURRENT_SEQUENCE_NUMBER" },
    {  "value":       1532, "name": "MQIACH_CURRENT_SEQ_NUMBER" },
    {  "value":       1533, "name": "MQIACH_SSL_RETURN_CODE" },
    {  "value":       1534, "name": "MQIACH_MSGS" },
    {  "value":       1535, "name": "MQIACH_BYTES_SENT" },
    {  "value":       1536, "name": "MQIACH_BYTES_RCVD" },
    {  "value":       1536, "name": "MQIACH_BYTES_RECEIVED" },
    {  "value":       1536, "name": "MQ_SSL_ENCRYP_KEY_REPO_PWD_LEN" },
    {  "value":       1537, "name": "MQIACH_BATCHES" },
    {  "value":       1538, "name": "MQIACH_BUFFERS_SENT" },
    {  "value":       1539, "name": "MQIACH_BUFFERS_RCVD" },
    {  "value":       1539, "name": "MQIACH_BUFFERS_RECEIVED" },
    {  "value":       1540, "name": "MQCDC_LENGTH_4 (4 byte)" },
    {  "value":       1540, "name": "MQCD_LENGTH_4 (4 byte)" },
    {  "value":       1540, "name": "MQIACH_LONG_RETRIES_LEFT" },
    {  "value":       1541, "name": "MQIACH_SHORT_RETRIES_LEFT" },
    {  "value":       1542, "name": "MQIACH_MCA_STATUS" },
    {  "value":       1543, "name": "MQIACH_STOP_REQUESTED" },
    {  "value":       1544, "name": "MQIACH_MR_COUNT" },
    {  "value":       1545, "name": "MQIACH_MR_INTERVAL" },
    {  "value":       1552, "name": "MQCDC_LENGTH_5 (4 byte)" },
    {  "value":       1552, "name": "MQCD_LENGTH_5 (4 byte)" },
    {  "value":       1562, "name": "MQIACH_NPM_SPEED" },
    {  "value":       1563, "name": "MQIACH_HB_INTERVAL" },
    {  "value":       1564, "name": "MQIACH_BATCH_INTERVAL" },
    {  "value":       1565, "name": "MQIACH_NETWORK_PRIORITY" },
    {  "value":       1566, "name": "MQIACH_KEEP_ALIVE_INTERVAL" },
    {  "value":       1567, "name": "MQIACH_BATCH_HB" },
    {  "value":       1568, "name": "MQCDC_LENGTH_4 (8 byte)" },
    {  "value":       1568, "name": "MQCD_LENGTH_4 (8 byte)" },
    {  "value":       1568, "name": "MQIACH_SSL_CLIENT_AUTH" },
    {  "value":       1570, "name": "MQIACH_ALLOC_RETRY" },
    {  "value":       1571, "name": "MQIACH_ALLOC_FAST_TIMER" },
    {  "value":       1572, "name": "MQIACH_ALLOC_SLOW_TIMER" },
    {  "value":       1573, "name": "MQIACH_DISC_RETRY" },
    {  "value":       1574, "name": "MQIACH_PORT_NUMBER" },
    {  "value":       1575, "name": "MQIACH_HDR_COMPRESSION" },
    {  "value":       1576, "name": "MQIACH_MSG_COMPRESSION" },
    {  "value":       1577, "name": "MQIACH_CLWL_CHANNEL_RANK" },
    {  "value":       1578, "name": "MQIACH_CLWL_CHANNEL_PRIORITY" },
    {  "value":       1579, "name": "MQIACH_CLWL_CHANNEL_WEIGHT" },
    {  "value":       1580, "name": "MQIACH_CHANNEL_DISP" },
    {  "value":       1581, "name": "MQIACH_INBOUND_DISP" },
    {  "value":       1582, "name": "MQIACH_CHANNEL_TYPES" },
    {  "value":       1583, "name": "MQIACH_ADAPS_STARTED" },
    {  "value":       1584, "name": "MQCDC_LENGTH_5 (8 byte)" },
    {  "value":       1584, "name": "MQCD_LENGTH_5 (8 byte)" },
    {  "value":       1584, "name": "MQIACH_ADAPS_MAX" },
    {  "value":       1585, "name": "MQIACH_DISPS_STARTED" },
    {  "value":       1586, "name": "MQIACH_DISPS_MAX" },
    {  "value":       1587, "name": "MQIACH_SSLTASKS_STARTED" },
    {  "value":       1588, "name": "MQIACH_SSLTASKS_MAX" },
    {  "value":       1589, "name": "MQIACH_CURRENT_CHL" },
    {  "value":       1590, "name": "MQIACH_CURRENT_CHL_MAX" },
    {  "value":       1591, "name": "MQIACH_CURRENT_CHL_TCP" },
    {  "value":       1592, "name": "MQIACH_CURRENT_CHL_LU62" },
    {  "value":       1593, "name": "MQIACH_ACTIVE_CHL" },
    {  "value":       1594, "name": "MQIACH_ACTIVE_CHL_MAX" },
    {  "value":       1595, "name": "MQIACH_ACTIVE_CHL_PAUSED" },
    {  "value":       1596, "name": "MQIACH_ACTIVE_CHL_STARTED" },
    {  "value":       1597, "name": "MQIACH_ACTIVE_CHL_STOPPED" },
    {  "value":       1598, "name": "MQIACH_ACTIVE_CHL_RETRY" },
    {  "value":       1599, "name": "MQIACH_LISTENER_STATUS" },
    {  "value":       1600, "name": "MQCHSSTATE_IN_MQGET" },
    {  "value":       1600, "name": "MQIACH_SHARED_CHL_RESTART" },
    {  "value":       1601, "name": "MQIACH_LISTENER_CONTROL" },
    {  "value":       1602, "name": "MQIACH_BACKLOG" },
    {  "value":       1604, "name": "MQIACH_XMITQ_TIME_INDICATOR" },
    {  "value":       1605, "name": "MQIACH_NETWORK_TIME_INDICATOR" },
    {  "value":       1606, "name": "MQIACH_EXIT_TIME_INDICATOR" },
    {  "value":       1607, "name": "MQIACH_BATCH_SIZE_INDICATOR" },
    {  "value":       1608, "name": "MQIACH_XMITQ_MSGS_AVAILABLE" },
    {  "value":       1609, "name": "MQIACH_CHANNEL_SUBSTATE" },
    {  "value":       1610, "name": "MQIACH_SSL_KEY_RESETS" },
    {  "value":       1611, "name": "MQIACH_COMPRESSION_RATE" },
    {  "value":       1612, "name": "MQIACH_COMPRESSION_TIME" },
    {  "value":       1613, "name": "MQIACH_MAX_XMIT_SIZE" },
    {  "value":       1614, "name": "MQIACH_DEF_CHANNEL_DISP" },
    {  "value":       1615, "name": "MQIACH_SHARING_CONVERSATIONS" },
    {  "value":       1616, "name": "MQIACH_MAX_SHARING_CONVS" },
    {  "value":       1617, "name": "MQIACH_CURRENT_SHARING_CONVS" },
    {  "value":       1618, "name": "MQIACH_MAX_INSTANCES" },
    {  "value":       1619, "name": "MQIACH_MAX_INSTS_PER_CLIENT" },
    {  "value":       1620, "name": "MQIACH_CLIENT_CHANNEL_WEIGHT" },
    {  "value":       1621, "name": "MQIACH_CONNECTION_AFFINITY" },
    {  "value":       1622, "name": "MQIACH_AUTH_INFO_TYPES" },
    {  "value":       1623, "name": "MQIACH_RESET_REQUESTED" },
    {  "value":       1624, "name": "MQIACH_BATCH_DATA_LIMIT" },
    {  "value":       1625, "name": "MQIACH_MSG_HISTORY" },
    {  "value":       1626, "name": "MQIACH_MULTICAST_PROPERTIES" },
    {  "value":       1627, "name": "MQIACH_NEW_SUBSCRIBER_HISTORY" },
    {  "value":       1628, "name": "MQIACH_MC_HB_INTERVAL" },
    {  "value":       1629, "name": "MQIACH_USE_CLIENT_ID" },
    {  "value":       1630, "name": "MQIACH_MQTT_KEEP_ALIVE" },
    {  "value":       1631, "name": "MQIACH_IN_DOUBT_IN" },
    {  "value":       1632, "name": "MQIACH_IN_DOUBT_OUT" },
    {  "value":       1633, "name": "MQIACH_MSGS_SENT" },
    {  "value":       1634, "name": "MQIACH_MSGS_RCVD" },
    {  "value":       1634, "name": "MQIACH_MSGS_RECEIVED" },
    {  "value":       1635, "name": "MQIACH_PENDING_OUT" },
    {  "value":       1636, "name": "MQIACH_AVAILABLE_CIPHERSPECS" },
    {  "value":       1637, "name": "MQIACH_MATCH" },
    {  "value":       1638, "name": "MQIACH_USER_SOURCE" },
    {  "value":       1639, "name": "MQIACH_WARNING" },
    {  "value":       1640, "name": "MQIACH_DEF_RECONNECT" },
    {  "value":       1642, "name": "MQIACH_CHANNEL_SUMMARY_ATTRS" },
    {  "value":       1643, "name": "MQIACH_PROTOCOL" },
    {  "value":       1644, "name": "MQIACH_AMQP_KEEP_ALIVE" },
    {  "value":       1645, "name": "MQIACH_SECURITY_PROTOCOL" },
    {  "value":       1646, "name": "MQIACH_LAST_USED" },
    {  "value":       1646, "name": "MQIACH_SPL_PROTECTION" },
    {  "value":       1648, "name": "MQCDC_LENGTH_6 (4 byte)" },
    {  "value":       1648, "name": "MQCD_LENGTH_6 (4 byte)" },
    {  "value":       1688, "name": "MQCDC_LENGTH_6 (8 byte)" },
    {  "value":       1688, "name": "MQCD_LENGTH_6 (8 byte)" },
    {  "value":       1700, "name": "MQCHSSTATE_IN_MQI_CALL" },
    {  "value":       1748, "name": "MQCDC_LENGTH_7 (4 byte)" },
    {  "value":       1748, "name": "MQCD_LENGTH_7 (4 byte)" },
    {  "value":       1792, "name": "MQCDC_LENGTH_7 (8 byte)" },
    {  "value":       1792, "name": "MQCD_LENGTH_7 (8 byte)" },
    {  "value":       1792, "name": "MQRO_COA_WITH_FULL_DATA" },
    {  "value":       1800, "name": "MQCHSSTATE_COMPRESSING" },
    {  "value":       1840, "name": "MQCDC_LENGTH_8 (4 byte)" },
    {  "value":       1840, "name": "MQCD_LENGTH_8 (4 byte)" },
    {  "value":       1864, "name": "MQCDC_LENGTH_9 (4 byte)" },
    {  "value":       1864, "name": "MQCD_LENGTH_9 (4 byte)" },
    {  "value":       1876, "name": "MQCDC_LENGTH_10 (4 byte)" },
    {  "value":       1876, "name": "MQCD_LENGTH_10 (4 byte)" },
    {  "value":       1888, "name": "MQCDC_LENGTH_8 (8 byte)" },
    {  "value":       1888, "name": "MQCD_LENGTH_8 (8 byte)" },
    {  "value":       1912, "name": "MQCDC_LENGTH_9 (8 byte)" },
    {  "value":       1912, "name": "MQCD_LENGTH_9 (8 byte)" },
    {  "value":       1920, "name": "MQCDC_LENGTH_10 (8 byte)" },
    {  "value":       1920, "name": "MQCD_LENGTH_10 (8 byte)" },
    {  "value":       1940, "name": "MQCDC_LENGTH_11 (4 byte)" },
    {  "value":       1940, "name": "MQCD_LENGTH_11 (4 byte)" },
    {  "value":       1944, "name": "MQCDC_CURRENT_LENGTH (4 byte)" },
    {  "value":       1944, "name": "MQCDC_LENGTH_12 (4 byte)" },
    {  "value":       1944, "name": "MQCD_CURRENT_LENGTH (4 byte)" },
    {  "value":       1944, "name": "MQCD_LENGTH_12 (4 byte)" },
    {  "value":       1984, "name": "MQCDC_LENGTH_11 (8 byte)" },
    {  "value":       1984, "name": "MQCD_LENGTH_11 (8 byte)" },
    {  "value":       1992, "name": "MQCDC_CURRENT_LENGTH (8 byte)" },
    {  "value":       1992, "name": "MQCDC_LENGTH_12 (8 byte)" },
    {  "value":       1992, "name": "MQCD_CURRENT_LENGTH (8 byte)" },
    {  "value":       1992, "name": "MQCD_LENGTH_12 (8 byte)" },
    {  "value":       2000, "name": "MQIA_LAST" },
    {  "value":       2000, "name": "MQIA_USER_LIST" },
    {  "value":       2001, "name": "MQCA_APPL_ID" },
    {  "value":       2001, "name": "MQCA_FIRST" },
    {  "value":       2001, "name": "MQRC_ALIAS_BASE_Q_TYPE_ERROR" },
    {  "value":       2002, "name": "MQCA_BASE_OBJECT_NAME" },
    {  "value":       2002, "name": "MQCA_BASE_Q_NAME" },
    {  "value":       2002, "name": "MQRC_ALREADY_CONNECTED" },
    {  "value":       2003, "name": "MQCA_COMMAND_INPUT_Q_NAME" },
    {  "value":       2003, "name": "MQRC_BACKED_OUT" },
    {  "value":       2004, "name": "MQCA_CREATION_DATE" },
    {  "value":       2004, "name": "MQRC_BUFFER_ERROR" },
    {  "value":       2005, "name": "MQCA_CREATION_TIME" },
    {  "value":       2005, "name": "MQRC_BUFFER_LENGTH_ERROR" },
    {  "value":       2006, "name": "MQCA_DEAD_LETTER_Q_NAME" },
    {  "value":       2006, "name": "MQRC_CHAR_ATTR_LENGTH_ERROR" },
    {  "value":       2007, "name": "MQCA_ENV_DATA" },
    {  "value":       2007, "name": "MQRC_CHAR_ATTRS_ERROR" },
    {  "value":       2008, "name": "MQCA_INITIATION_Q_NAME" },
    {  "value":       2008, "name": "MQRC_CHAR_ATTRS_TOO_SHORT" },
    {  "value":       2009, "name": "MQCA_NAMELIST_DESC" },
    {  "value":       2009, "name": "MQRC_CONNECTION_BROKEN" },
    {  "value":       2010, "name": "MQCA_NAMELIST_NAME" },
    {  "value":       2010, "name": "MQRC_DATA_LENGTH_ERROR" },
    {  "value":       2011, "name": "MQCA_PROCESS_DESC" },
    {  "value":       2011, "name": "MQRC_DYNAMIC_Q_NAME_ERROR" },
    {  "value":       2012, "name": "MQCA_PROCESS_NAME" },
    {  "value":       2012, "name": "MQRC_ENVIRONMENT_ERROR" },
    {  "value":       2013, "name": "MQCA_Q_DESC" },
    {  "value":       2013, "name": "MQRC_EXPIRY_ERROR" },
    {  "value":       2014, "name": "MQCA_Q_MGR_DESC" },
    {  "value":       2014, "name": "MQRC_FEEDBACK_ERROR" },
    {  "value":       2015, "name": "MQCA_Q_MGR_NAME" },
    {  "value":       2016, "name": "MQCA_Q_NAME" },
    {  "value":       2016, "name": "MQRC_GET_INHIBITED" },
    {  "value":       2017, "name": "MQCA_REMOTE_Q_MGR_NAME" },
    {  "value":       2017, "name": "MQRC_HANDLE_NOT_AVAILABLE" },
    {  "value":       2018, "name": "MQCA_REMOTE_Q_NAME" },
    {  "value":       2018, "name": "MQRC_HCONN_ERROR" },
    {  "value":       2019, "name": "MQCA_BACKOUT_REQ_Q_NAME" },
    {  "value":       2019, "name": "MQRC_HOBJ_ERROR" },
    {  "value":       2020, "name": "MQCA_NAMES" },
    {  "value":       2020, "name": "MQRC_INHIBIT_VALUE_ERROR" },
    {  "value":       2021, "name": "MQCA_USER_DATA" },
    {  "value":       2021, "name": "MQRC_INT_ATTR_COUNT_ERROR" },
    {  "value":       2022, "name": "MQCA_STORAGE_CLASS" },
    {  "value":       2022, "name": "MQRC_INT_ATTR_COUNT_TOO_SMALL" },
    {  "value":       2023, "name": "MQCA_TRIGGER_DATA" },
    {  "value":       2023, "name": "MQRC_INT_ATTRS_ARRAY_ERROR" },
    {  "value":       2024, "name": "MQCA_XMIT_Q_NAME" },
    {  "value":       2024, "name": "MQRC_SYNCPOINT_LIMIT_REACHED" },
    {  "value":       2025, "name": "MQCA_DEF_XMIT_Q_NAME" },
    {  "value":       2025, "name": "MQRC_MAX_CONNS_LIMIT_REACHED" },
    {  "value":       2026, "name": "MQCA_CHANNEL_AUTO_DEF_EXIT" },
    {  "value":       2026, "name": "MQRC_MD_ERROR" },
    {  "value":       2027, "name": "MQCA_ALTERATION_DATE" },
    {  "value":       2027, "name": "MQRC_MISSING_REPLY_TO_Q" },
    {  "value":       2028, "name": "MQCA_ALTERATION_TIME" },
    {  "value":       2029, "name": "MQCA_CLUSTER_NAME" },
    {  "value":       2029, "name": "MQRC_MSG_TYPE_ERROR" },
    {  "value":       2030, "name": "MQCA_CLUSTER_NAMELIST" },
    {  "value":       2030, "name": "MQRC_MSG_TOO_BIG_FOR_Q" },
    {  "value":       2031, "name": "MQCA_CLUSTER_Q_MGR_NAME" },
    {  "value":       2031, "name": "MQRC_MSG_TOO_BIG_FOR_Q_MGR" },
    {  "value":       2032, "name": "MQCA_Q_MGR_IDENTIFIER" },
    {  "value":       2033, "name": "MQCA_CLUSTER_WORKLOAD_EXIT" },
    {  "value":       2033, "name": "MQRC_NO_MSG_AVAILABLE" },
    {  "value":       2034, "name": "MQCA_CLUSTER_WORKLOAD_DATA" },
    {  "value":       2034, "name": "MQRC_NO_MSG_UNDER_CURSOR" },
    {  "value":       2035, "name": "MQCA_REPOSITORY_NAME" },
    {  "value":       2035, "name": "MQRC_NOT_AUTHORIZED" },
    {  "value":       2036, "name": "MQCA_REPOSITORY_NAMELIST" },
    {  "value":       2036, "name": "MQRC_NOT_OPEN_FOR_BROWSE" },
    {  "value":       2037, "name": "MQCA_CLUSTER_DATE" },
    {  "value":       2037, "name": "MQRC_NOT_OPEN_FOR_INPUT" },
    {  "value":       2038, "name": "MQCA_CLUSTER_TIME" },
    {  "value":       2038, "name": "MQRC_NOT_OPEN_FOR_INQUIRE" },
    {  "value":       2039, "name": "MQCA_CF_STRUC_NAME" },
    {  "value":       2039, "name": "MQRC_NOT_OPEN_FOR_OUTPUT" },
    {  "value":       2040, "name": "MQCA_QSG_NAME" },
    {  "value":       2040, "name": "MQRC_NOT_OPEN_FOR_SET" },
    {  "value":       2041, "name": "MQCA_IGQ_USER_ID" },
    {  "value":       2041, "name": "MQRC_OBJECT_CHANGED" },
    {  "value":       2042, "name": "MQCA_STORAGE_CLASS_DESC" },
    {  "value":       2042, "name": "MQRC_OBJECT_IN_USE" },
    {  "value":       2043, "name": "MQCA_XCF_GROUP_NAME" },
    {  "value":       2043, "name": "MQRC_OBJECT_TYPE_ERROR" },
    {  "value":       2044, "name": "MQCA_XCF_MEMBER_NAME" },
    {  "value":       2044, "name": "MQRC_OD_ERROR" },
    {  "value":       2045, "name": "MQCA_AUTH_INFO_NAME" },
    {  "value":       2045, "name": "MQRC_OPTION_NOT_VALID_FOR_TYPE" },
    {  "value":       2046, "name": "MQCA_AUTH_INFO_DESC" },
    {  "value":       2046, "name": "MQRC_OPTIONS_ERROR" },
    {  "value":       2047, "name": "MQCA_LDAP_USER_NAME" },
    {  "value":       2047, "name": "MQRC_PERSISTENCE_ERROR" },
    {  "value":       2048, "name": "MQCA_LDAP_PASSWORD" },
    {  "value":       2048, "name": "MQCNO_CLIENT_BINDING" },
    {  "value":       2048, "name": "MQGMO_BROWSE_MSG_UNDER_CURSOR" },
    {  "value":       2048, "name": "MQOO_SET_ALL_CONTEXT" },
    {  "value":       2048, "name": "MQPMO_SET_ALL_CONTEXT" },
    {  "value":       2048, "name": "MQRC_PERSISTENT_NOT_ALLOWED" },
    {  "value":       2048, "name": "MQREGO_PERSISTENT" },
    {  "value":       2048, "name": "MQRO_COD" },
    {  "value":       2048, "name": "MQSO_PUBLICATIONS_ON_REQUEST" },
    {  "value":       2048, "name": "MQZAO_PUBLISH" },
    {  "value":       2049, "name": "MQCA_SSL_KEY_REPOSITORY" },
    {  "value":       2049, "name": "MQRC_PRIORITY_EXCEEDS_MAXIMUM" },
    {  "value":       2050, "name": "MQCA_SSL_CRL_NAMELIST" },
    {  "value":       2050, "name": "MQRC_PRIORITY_ERROR" },
    {  "value":       2051, "name": "MQCA_SSL_CRYPTO_HARDWARE" },
    {  "value":       2051, "name": "MQRC_PUT_INHIBITED" },
    {  "value":       2052, "name": "MQCA_CF_STRUC_DESC" },
    {  "value":       2052, "name": "MQRC_Q_DELETED" },
    {  "value":       2053, "name": "MQCA_AUTH_INFO_CONN_NAME" },
    {  "value":       2053, "name": "MQRC_Q_FULL" },
    {  "value":       2054, "name": "MQCA_INITIAL_KEY" },
    {  "value":       2055, "name": "MQCA_SSL_KEY_REPO_PASSWORD" },
    {  "value":       2055, "name": "MQRC_Q_NOT_EMPTY" },
    {  "value":       2056, "name": "MQRC_Q_SPACE_NOT_AVAILABLE" },
    {  "value":       2057, "name": "MQRC_Q_TYPE_ERROR" },
    {  "value":       2058, "name": "MQRC_Q_MGR_NAME_ERROR" },
    {  "value":       2059, "name": "MQRC_Q_MGR_NOT_AVAILABLE" },
    {  "value":       2060, "name": "MQCA_CICS_FILE_NAME" },
    {  "value":       2061, "name": "MQCA_TRIGGER_TRANS_ID" },
    {  "value":       2061, "name": "MQRC_REPORT_OPTIONS_ERROR" },
    {  "value":       2062, "name": "MQCA_TRIGGER_PROGRAM_NAME" },
    {  "value":       2062, "name": "MQRC_SECOND_MARK_NOT_ALLOWED" },
    {  "value":       2063, "name": "MQCA_TRIGGER_TERM_ID" },
    {  "value":       2063, "name": "MQRC_SECURITY_ERROR" },
    {  "value":       2064, "name": "MQCA_TRIGGER_CHANNEL_NAME" },
    {  "value":       2064, "name": "MQRC_TOKEN_TIMESTAMP_NOT_VALID" },
    {  "value":       2065, "name": "MQCA_SYSTEM_LOG_Q_NAME" },
    {  "value":       2065, "name": "MQRC_SELECTOR_COUNT_ERROR" },
    {  "value":       2066, "name": "MQCA_MONITOR_Q_NAME" },
    {  "value":       2066, "name": "MQRC_SELECTOR_LIMIT_EXCEEDED" },
    {  "value":       2067, "name": "MQCA_COMMAND_REPLY_Q_NAME" },
    {  "value":       2067, "name": "MQRC_SELECTOR_ERROR" },
    {  "value":       2068, "name": "MQCA_BATCH_INTERFACE_ID" },
    {  "value":       2068, "name": "MQRC_SELECTOR_NOT_FOR_TYPE" },
    {  "value":       2069, "name": "MQCA_SSL_KEY_LIBRARY" },
    {  "value":       2069, "name": "MQRC_SIGNAL_OUTSTANDING" },
    {  "value":       2070, "name": "MQCA_SSL_KEY_MEMBER" },
    {  "value":       2070, "name": "MQRC_SIGNAL_REQUEST_ACCEPTED" },
    {  "value":       2071, "name": "MQCA_DNS_GROUP" },
    {  "value":       2071, "name": "MQRC_STORAGE_NOT_AVAILABLE" },
    {  "value":       2072, "name": "MQCA_LU_GROUP_NAME" },
    {  "value":       2072, "name": "MQRC_SYNCPOINT_NOT_AVAILABLE" },
    {  "value":       2073, "name": "MQCA_LU_NAME" },
    {  "value":       2074, "name": "MQCA_LU62_ARM_SUFFIX" },
    {  "value":       2075, "name": "MQCA_TCP_NAME" },
    {  "value":       2075, "name": "MQRC_TRIGGER_CONTROL_ERROR" },
    {  "value":       2076, "name": "MQCA_CHINIT_SERVICE_PARM" },
    {  "value":       2076, "name": "MQRC_TRIGGER_DEPTH_ERROR" },
    {  "value":       2077, "name": "MQCA_SERVICE_NAME" },
    {  "value":       2077, "name": "MQRC_TRIGGER_MSG_PRIORITY_ERR" },
    {  "value":       2078, "name": "MQCA_SERVICE_DESC" },
    {  "value":       2078, "name": "MQRC_TRIGGER_TYPE_ERROR" },
    {  "value":       2079, "name": "MQCA_SERVICE_START_COMMAND" },
    {  "value":       2079, "name": "MQRC_TRUNCATED_MSG_ACCEPTED" },
    {  "value":       2080, "name": "MQCA_SERVICE_START_ARGS" },
    {  "value":       2080, "name": "MQRC_TRUNCATED_MSG_FAILED" },
    {  "value":       2081, "name": "MQCA_SERVICE_STOP_COMMAND" },
    {  "value":       2082, "name": "MQCA_SERVICE_STOP_ARGS" },
    {  "value":       2082, "name": "MQRC_UNKNOWN_ALIAS_BASE_Q" },
    {  "value":       2083, "name": "MQCA_STDOUT_DESTINATION" },
    {  "value":       2084, "name": "MQCA_STDERR_DESTINATION" },
    {  "value":       2085, "name": "MQCA_TPIPE_NAME" },
    {  "value":       2085, "name": "MQRC_UNKNOWN_OBJECT_NAME" },
    {  "value":       2086, "name": "MQCA_PASS_TICKET_APPL" },
    {  "value":       2086, "name": "MQRC_UNKNOWN_OBJECT_Q_MGR" },
    {  "value":       2087, "name": "MQRC_UNKNOWN_REMOTE_Q_MGR" },
    {  "value":       2090, "name": "MQCA_AUTO_REORG_START_TIME" },
    {  "value":       2090, "name": "MQRC_WAIT_INTERVAL_ERROR" },
    {  "value":       2091, "name": "MQCA_AUTO_REORG_CATALOG" },
    {  "value":       2091, "name": "MQRC_XMIT_Q_TYPE_ERROR" },
    {  "value":       2092, "name": "MQCA_TOPIC_NAME" },
    {  "value":       2092, "name": "MQRC_XMIT_Q_USAGE_ERROR" },
    {  "value":       2093, "name": "MQCA_TOPIC_DESC" },
    {  "value":       2093, "name": "MQRC_NOT_OPEN_FOR_PASS_ALL" },
    {  "value":       2094, "name": "MQCA_TOPIC_STRING" },
    {  "value":       2094, "name": "MQRC_NOT_OPEN_FOR_PASS_IDENT" },
    {  "value":       2095, "name": "MQRC_NOT_OPEN_FOR_SET_ALL" },
    {  "value":       2096, "name": "MQCA_MODEL_DURABLE_Q" },
    {  "value":       2096, "name": "MQRC_NOT_OPEN_FOR_SET_IDENT" },
    {  "value":       2097, "name": "MQCA_MODEL_NON_DURABLE_Q" },
    {  "value":       2097, "name": "MQRC_CONTEXT_HANDLE_ERROR" },
    {  "value":       2098, "name": "MQCA_RESUME_DATE" },
    {  "value":       2098, "name": "MQRC_CONTEXT_NOT_AVAILABLE" },
    {  "value":       2099, "name": "MQCA_RESUME_TIME" },
    {  "value":       2099, "name": "MQRC_SIGNAL1_ERROR" },
    {  "value":       2100, "name": "MQRC_OBJECT_ALREADY_EXISTS" },
    {  "value":       2101, "name": "MQCA_CHILD" },
    {  "value":       2101, "name": "MQRC_OBJECT_DAMAGED" },
    {  "value":       2102, "name": "MQCA_PARENT" },
    {  "value":       2102, "name": "MQRC_RESOURCE_PROBLEM" },
    {  "value":       2103, "name": "MQRC_ANOTHER_Q_MGR_CONNECTED" },
    {  "value":       2104, "name": "MQRC_UNKNOWN_REPORT_OPTION" },
    {  "value":       2105, "name": "MQCA_ADMIN_TOPIC_NAME" },
    {  "value":       2105, "name": "MQRC_STORAGE_CLASS_ERROR" },
    {  "value":       2106, "name": "MQRC_COD_NOT_VALID_FOR_XCF_Q" },
    {  "value":       2107, "name": "MQRC_XWAIT_CANCELED" },
    {  "value":       2108, "name": "MQCA_TOPIC_STRING_FILTER" },
    {  "value":       2108, "name": "MQRC_XWAIT_ERROR" },
    {  "value":       2109, "name": "MQCA_AUTH_INFO_OCSP_URL" },
    {  "value":       2109, "name": "MQRC_SUPPRESSED_BY_EXIT" },
    {  "value":       2110, "name": "MQCA_COMM_INFO_NAME" },
    {  "value":       2110, "name": "MQRC_FORMAT_ERROR" },
    {  "value":       2111, "name": "MQCA_COMM_INFO_DESC" },
    {  "value":       2111, "name": "MQRC_SOURCE_CCSID_ERROR" },
    {  "value":       2112, "name": "MQCA_POLICY_NAME" },
    {  "value":       2112, "name": "MQRC_SOURCE_INTEGER_ENC_ERROR" },
    {  "value":       2113, "name": "MQCA_SIGNER_DN" },
    {  "value":       2113, "name": "MQRC_SOURCE_DECIMAL_ENC_ERROR" },
    {  "value":       2114, "name": "MQCA_RECIPIENT_DN" },
    {  "value":       2114, "name": "MQRC_SOURCE_FLOAT_ENC_ERROR" },
    {  "value":       2115, "name": "MQCA_INSTALLATION_DESC" },
    {  "value":       2115, "name": "MQRC_TARGET_CCSID_ERROR" },
    {  "value":       2116, "name": "MQCA_INSTALLATION_NAME" },
    {  "value":       2116, "name": "MQRC_TARGET_INTEGER_ENC_ERROR" },
    {  "value":       2117, "name": "MQCA_INSTALLATION_PATH" },
    {  "value":       2117, "name": "MQRC_TARGET_DECIMAL_ENC_ERROR" },
    {  "value":       2118, "name": "MQCA_CHLAUTH_DESC" },
    {  "value":       2118, "name": "MQRC_TARGET_FLOAT_ENC_ERROR" },
    {  "value":       2119, "name": "MQCA_CUSTOM" },
    {  "value":       2119, "name": "MQRC_NOT_CONVERTED" },
    {  "value":       2120, "name": "MQCA_VERSION" },
    {  "value":       2120, "name": "MQRC_CONVERTED_MSG_TOO_BIG" },
    {  "value":       2121, "name": "MQCA_CERT_LABEL" },
    {  "value":       2121, "name": "MQRC_NO_EXTERNAL_PARTICIPANTS" },
    {  "value":       2122, "name": "MQCA_XR_VERSION" },
    {  "value":       2122, "name": "MQRC_PARTICIPANT_NOT_AVAILABLE" },
    {  "value":       2123, "name": "MQCA_XR_SSL_CIPHER_SUITES" },
    {  "value":       2123, "name": "MQRC_OUTCOME_MIXED" },
    {  "value":       2124, "name": "MQCA_CLUS_CHL_NAME" },
    {  "value":       2124, "name": "MQRC_OUTCOME_PENDING" },
    {  "value":       2125, "name": "MQCA_CONN_AUTH" },
    {  "value":       2125, "name": "MQRC_BRIDGE_STARTED" },
    {  "value":       2126, "name": "MQCA_LDAP_BASE_DN_USERS" },
    {  "value":       2126, "name": "MQRC_BRIDGE_STOPPED" },
    {  "value":       2127, "name": "MQCA_LDAP_SHORT_USER_FIELD" },
    {  "value":       2127, "name": "MQRC_ADAPTER_STORAGE_SHORTAGE" },
    {  "value":       2128, "name": "MQCA_LDAP_USER_OBJECT_CLASS" },
    {  "value":       2128, "name": "MQRC_UOW_IN_PROGRESS" },
    {  "value":       2129, "name": "MQCA_LDAP_USER_ATTR_FIELD" },
    {  "value":       2129, "name": "MQRC_ADAPTER_CONN_LOAD_ERROR" },
    {  "value":       2130, "name": "MQCA_SSL_CERT_ISSUER_NAME" },
    {  "value":       2130, "name": "MQRC_ADAPTER_SERV_LOAD_ERROR" },
    {  "value":       2131, "name": "MQCA_QSG_CERT_LABEL" },
    {  "value":       2131, "name": "MQRC_ADAPTER_DEFS_ERROR" },
    {  "value":       2132, "name": "MQCA_LDAP_BASE_DN_GROUPS" },
    {  "value":       2132, "name": "MQRC_ADAPTER_DEFS_LOAD_ERROR" },
    {  "value":       2133, "name": "MQCA_LDAP_GROUP_OBJECT_CLASS" },
    {  "value":       2133, "name": "MQRC_ADAPTER_CONV_LOAD_ERROR" },
    {  "value":       2134, "name": "MQCA_LDAP_GROUP_ATTR_FIELD" },
    {  "value":       2134, "name": "MQRC_BO_ERROR" },
    {  "value":       2135, "name": "MQCA_LDAP_FIND_GROUP_FIELD" },
    {  "value":       2135, "name": "MQRC_DH_ERROR" },
    {  "value":       2136, "name": "MQCA_AMQP_VERSION" },
    {  "value":       2136, "name": "MQRC_MULTIPLE_REASONS" },
    {  "value":       2137, "name": "MQCA_AMQP_SSL_CIPHER_SUITES" },
    {  "value":       2137, "name": "MQRC_OPEN_FAILED" },
    {  "value":       2138, "name": "MQCA_LAST_USED" },
    {  "value":       2138, "name": "MQCA_STREAM_QUEUE_NAME" },
    {  "value":       2138, "name": "MQRC_ADAPTER_DISC_LOAD_ERROR" },
    {  "value":       2139, "name": "MQRC_CNO_ERROR" },
    {  "value":       2140, "name": "MQRC_CICS_WAIT_FAILED" },
    {  "value":       2141, "name": "MQRC_DLH_ERROR" },
    {  "value":       2142, "name": "MQRC_HEADER_ERROR" },
    {  "value":       2143, "name": "MQRC_SOURCE_LENGTH_ERROR" },
    {  "value":       2144, "name": "MQRC_TARGET_LENGTH_ERROR" },
    {  "value":       2145, "name": "MQRC_SOURCE_BUFFER_ERROR" },
    {  "value":       2146, "name": "MQRC_TARGET_BUFFER_ERROR" },
    {  "value":       2147, "name": "MQRC_INCOMPLETE_TRANSACTION" },
    {  "value":       2148, "name": "MQRC_IIH_ERROR" },
    {  "value":       2149, "name": "MQRC_PCF_ERROR" },
    {  "value":       2150, "name": "MQRC_DBCS_ERROR" },
    {  "value":       2152, "name": "MQRC_OBJECT_NAME_ERROR" },
    {  "value":       2153, "name": "MQRC_OBJECT_Q_MGR_NAME_ERROR" },
    {  "value":       2154, "name": "MQRC_RECS_PRESENT_ERROR" },
    {  "value":       2155, "name": "MQRC_OBJECT_RECORDS_ERROR" },
    {  "value":       2156, "name": "MQRC_RESPONSE_RECORDS_ERROR" },
    {  "value":       2157, "name": "MQRC_ASID_MISMATCH" },
    {  "value":       2158, "name": "MQRC_PMO_RECORD_FLAGS_ERROR" },
    {  "value":       2159, "name": "MQRC_PUT_MSG_RECORDS_ERROR" },
    {  "value":       2160, "name": "MQRC_CONN_ID_IN_USE" },
    {  "value":       2161, "name": "MQRC_Q_MGR_QUIESCING" },
    {  "value":       2162, "name": "MQRC_Q_MGR_STOPPING" },
    {  "value":       2163, "name": "MQRC_DUPLICATE_RECOV_COORD" },
    {  "value":       2173, "name": "MQRC_PMO_ERROR" },
    {  "value":       2182, "name": "MQRC_API_EXIT_NOT_FOUND" },
    {  "value":       2183, "name": "MQRC_API_EXIT_LOAD_ERROR" },
    {  "value":       2184, "name": "MQRC_REMOTE_Q_NAME_ERROR" },
    {  "value":       2185, "name": "MQRC_INCONSISTENT_PERSISTENCE" },
    {  "value":       2186, "name": "MQRC_GMO_ERROR" },
    {  "value":       2187, "name": "MQRC_CICS_BRIDGE_RESTRICTION" },
    {  "value":       2188, "name": "MQRC_STOPPED_BY_CLUSTER_EXIT" },
    {  "value":       2189, "name": "MQRC_CLUSTER_RESOLUTION_ERROR" },
    {  "value":       2190, "name": "MQRC_CONVERTED_STRING_TOO_BIG" },
    {  "value":       2191, "name": "MQRC_TMC_ERROR" },
    {  "value":       2192, "name": "MQRC_STORAGE_MEDIUM_FULL" },
    {  "value":       2193, "name": "MQRC_PAGESET_ERROR" },
    {  "value":       2194, "name": "MQRC_NAME_NOT_VALID_FOR_TYPE" },
    {  "value":       2195, "name": "MQRC_UNEXPECTED_ERROR" },
    {  "value":       2196, "name": "MQRC_UNKNOWN_XMIT_Q" },
    {  "value":       2197, "name": "MQRC_UNKNOWN_DEF_XMIT_Q" },
    {  "value":       2198, "name": "MQRC_DEF_XMIT_Q_TYPE_ERROR" },
    {  "value":       2199, "name": "MQRC_DEF_XMIT_Q_USAGE_ERROR" },
    {  "value":       2200, "name": "MQRC_MSG_MARKED_BROWSE_CO_OP" },
    {  "value":       2201, "name": "MQRC_NAME_IN_USE" },
    {  "value":       2202, "name": "MQRC_CONNECTION_QUIESCING" },
    {  "value":       2203, "name": "MQRC_CONNECTION_STOPPING" },
    {  "value":       2204, "name": "MQRC_ADAPTER_NOT_AVAILABLE" },
    {  "value":       2206, "name": "MQRC_MSG_ID_ERROR" },
    {  "value":       2207, "name": "MQRC_CORREL_ID_ERROR" },
    {  "value":       2208, "name": "MQRC_FILE_SYSTEM_ERROR" },
    {  "value":       2209, "name": "MQRC_NO_MSG_LOCKED" },
    {  "value":       2210, "name": "MQRC_SOAP_DOTNET_ERROR" },
    {  "value":       2211, "name": "MQRC_SOAP_AXIS_ERROR" },
    {  "value":       2212, "name": "MQRC_SOAP_URL_ERROR" },
    {  "value":       2216, "name": "MQRC_FILE_NOT_AUDITED" },
    {  "value":       2217, "name": "MQRC_CONNECTION_NOT_AUTHORIZED" },
    {  "value":       2218, "name": "MQRC_MSG_TOO_BIG_FOR_CHANNEL" },
    {  "value":       2219, "name": "MQRC_CALL_IN_PROGRESS" },
    {  "value":       2220, "name": "MQRC_RMH_ERROR" },
    {  "value":       2222, "name": "MQRC_Q_MGR_ACTIVE" },
    {  "value":       2223, "name": "MQRC_Q_MGR_NOT_ACTIVE" },
    {  "value":       2224, "name": "MQRC_Q_DEPTH_HIGH" },
    {  "value":       2225, "name": "MQRC_Q_DEPTH_LOW" },
    {  "value":       2226, "name": "MQRC_Q_SERVICE_INTERVAL_HIGH" },
    {  "value":       2227, "name": "MQRC_Q_SERVICE_INTERVAL_OK" },
    {  "value":       2228, "name": "MQRC_RFH_HEADER_FIELD_ERROR" },
    {  "value":       2229, "name": "MQRC_RAS_PROPERTY_ERROR" },
    {  "value":       2232, "name": "MQRC_UNIT_OF_WORK_NOT_STARTED" },
    {  "value":       2233, "name": "MQRC_CHANNEL_AUTO_DEF_OK" },
    {  "value":       2234, "name": "MQRC_CHANNEL_AUTO_DEF_ERROR" },
    {  "value":       2235, "name": "MQRC_CFH_ERROR" },
    {  "value":       2236, "name": "MQRC_CFIL_ERROR" },
    {  "value":       2237, "name": "MQRC_CFIN_ERROR" },
    {  "value":       2238, "name": "MQRC_CFSL_ERROR" },
    {  "value":       2239, "name": "MQRC_CFST_ERROR" },
    {  "value":       2241, "name": "MQRC_INCOMPLETE_GROUP" },
    {  "value":       2242, "name": "MQRC_INCOMPLETE_MSG" },
    {  "value":       2243, "name": "MQRC_INCONSISTENT_CCSIDS" },
    {  "value":       2244, "name": "MQRC_INCONSISTENT_ENCODINGS" },
    {  "value":       2245, "name": "MQRC_INCONSISTENT_UOW" },
    {  "value":       2246, "name": "MQRC_INVALID_MSG_UNDER_CURSOR" },
    {  "value":       2247, "name": "MQRC_MATCH_OPTIONS_ERROR" },
    {  "value":       2248, "name": "MQRC_MDE_ERROR" },
    {  "value":       2249, "name": "MQRC_MSG_FLAGS_ERROR" },
    {  "value":       2250, "name": "MQRC_MSG_SEQ_NUMBER_ERROR" },
    {  "value":       2251, "name": "MQRC_OFFSET_ERROR" },
    {  "value":       2252, "name": "MQRC_ORIGINAL_LENGTH_ERROR" },
    {  "value":       2253, "name": "MQRC_SEGMENT_LENGTH_ZERO" },
    {  "value":       2255, "name": "MQRC_UOW_NOT_AVAILABLE" },
    {  "value":       2256, "name": "MQRC_WRONG_GMO_VERSION" },
    {  "value":       2257, "name": "MQRC_WRONG_MD_VERSION" },
    {  "value":       2258, "name": "MQRC_GROUP_ID_ERROR" },
    {  "value":       2259, "name": "MQRC_INCONSISTENT_BROWSE" },
    {  "value":       2260, "name": "MQRC_XQH_ERROR" },
    {  "value":       2261, "name": "MQRC_SRC_ENV_ERROR" },
    {  "value":       2262, "name": "MQRC_SRC_NAME_ERROR" },
    {  "value":       2263, "name": "MQRC_DEST_ENV_ERROR" },
    {  "value":       2264, "name": "MQRC_DEST_NAME_ERROR" },
    {  "value":       2265, "name": "MQRC_TM_ERROR" },
    {  "value":       2266, "name": "MQRC_CLUSTER_EXIT_ERROR" },
    {  "value":       2267, "name": "MQRC_CLUSTER_EXIT_LOAD_ERROR" },
    {  "value":       2268, "name": "MQRC_CLUSTER_PUT_INHIBITED" },
    {  "value":       2269, "name": "MQRC_CLUSTER_RESOURCE_ERROR" },
    {  "value":       2270, "name": "MQRC_NO_DESTINATIONS_AVAILABLE" },
    {  "value":       2271, "name": "MQRC_CONN_TAG_IN_USE" },
    {  "value":       2272, "name": "MQRC_PARTIALLY_CONVERTED" },
    {  "value":       2273, "name": "MQRC_CONNECTION_ERROR" },
    {  "value":       2274, "name": "MQRC_OPTION_ENVIRONMENT_ERROR" },
    {  "value":       2277, "name": "MQRC_CD_ERROR" },
    {  "value":       2278, "name": "MQRC_CLIENT_CONN_ERROR" },
    {  "value":       2279, "name": "MQRC_CHANNEL_STOPPED_BY_USER" },
    {  "value":       2280, "name": "MQRC_HCONFIG_ERROR" },
    {  "value":       2281, "name": "MQRC_FUNCTION_ERROR" },
    {  "value":       2282, "name": "MQRC_CHANNEL_STARTED" },
    {  "value":       2283, "name": "MQRC_CHANNEL_STOPPED" },
    {  "value":       2284, "name": "MQRC_CHANNEL_CONV_ERROR" },
    {  "value":       2285, "name": "MQRC_SERVICE_NOT_AVAILABLE" },
    {  "value":       2286, "name": "MQRC_INITIALIZATION_FAILED" },
    {  "value":       2287, "name": "MQRC_TERMINATION_FAILED" },
    {  "value":       2288, "name": "MQRC_UNKNOWN_Q_NAME" },
    {  "value":       2289, "name": "MQRC_SERVICE_ERROR" },
    {  "value":       2290, "name": "MQRC_Q_ALREADY_EXISTS" },
    {  "value":       2291, "name": "MQRC_USER_ID_NOT_AVAILABLE" },
    {  "value":       2292, "name": "MQRC_UNKNOWN_ENTITY" },
    {  "value":       2293, "name": "MQRC_UNKNOWN_AUTH_ENTITY" },
    {  "value":       2294, "name": "MQRC_UNKNOWN_REF_OBJECT" },
    {  "value":       2295, "name": "MQRC_CHANNEL_ACTIVATED" },
    {  "value":       2296, "name": "MQRC_CHANNEL_NOT_ACTIVATED" },
    {  "value":       2297, "name": "MQRC_UOW_CANCELED" },
    {  "value":       2298, "name": "MQRC_FUNCTION_NOT_SUPPORTED" },
    {  "value":       2299, "name": "MQRC_SELECTOR_TYPE_ERROR" },
    {  "value":       2300, "name": "MQRC_COMMAND_TYPE_ERROR" },
    {  "value":       2301, "name": "MQRC_MULTIPLE_INSTANCE_ERROR" },
    {  "value":       2302, "name": "MQRC_SYSTEM_ITEM_NOT_ALTERABLE" },
    {  "value":       2303, "name": "MQRC_BAG_CONVERSION_ERROR" },
    {  "value":       2304, "name": "MQRC_SELECTOR_OUT_OF_RANGE" },
    {  "value":       2305, "name": "MQRC_SELECTOR_NOT_UNIQUE" },
    {  "value":       2306, "name": "MQRC_INDEX_NOT_PRESENT" },
    {  "value":       2307, "name": "MQRC_STRING_ERROR" },
    {  "value":       2308, "name": "MQRC_ENCODING_NOT_SUPPORTED" },
    {  "value":       2309, "name": "MQRC_SELECTOR_NOT_PRESENT" },
    {  "value":       2310, "name": "MQRC_OUT_SELECTOR_ERROR" },
    {  "value":       2311, "name": "MQRC_STRING_TRUNCATED" },
    {  "value":       2312, "name": "MQRC_SELECTOR_WRONG_TYPE" },
    {  "value":       2313, "name": "MQRC_INCONSISTENT_ITEM_TYPE" },
    {  "value":       2314, "name": "MQRC_INDEX_ERROR" },
    {  "value":       2315, "name": "MQRC_SYSTEM_BAG_NOT_ALTERABLE" },
    {  "value":       2316, "name": "MQRC_ITEM_COUNT_ERROR" },
    {  "value":       2317, "name": "MQRC_FORMAT_NOT_SUPPORTED" },
    {  "value":       2318, "name": "MQRC_SELECTOR_NOT_SUPPORTED" },
    {  "value":       2319, "name": "MQRC_ITEM_VALUE_ERROR" },
    {  "value":       2320, "name": "MQRC_HBAG_ERROR" },
    {  "value":       2321, "name": "MQRC_PARAMETER_MISSING" },
    {  "value":       2322, "name": "MQRC_CMD_SERVER_NOT_AVAILABLE" },
    {  "value":       2323, "name": "MQRC_STRING_LENGTH_ERROR" },
    {  "value":       2324, "name": "MQRC_INQUIRY_COMMAND_ERROR" },
    {  "value":       2325, "name": "MQRC_NESTED_BAG_NOT_SUPPORTED" },
    {  "value":       2326, "name": "MQRC_BAG_WRONG_TYPE" },
    {  "value":       2327, "name": "MQRC_ITEM_TYPE_ERROR" },
    {  "value":       2328, "name": "MQRC_SYSTEM_BAG_NOT_DELETABLE" },
    {  "value":       2329, "name": "MQRC_SYSTEM_ITEM_NOT_DELETABLE" },
    {  "value":       2330, "name": "MQRC_CODED_CHAR_SET_ID_ERROR" },
    {  "value":       2331, "name": "MQRC_MSG_TOKEN_ERROR" },
    {  "value":       2332, "name": "MQRC_MISSING_WIH" },
    {  "value":       2333, "name": "MQRC_WIH_ERROR" },
    {  "value":       2334, "name": "MQRC_RFH_ERROR" },
    {  "value":       2335, "name": "MQRC_RFH_STRING_ERROR" },
    {  "value":       2336, "name": "MQRC_RFH_COMMAND_ERROR" },
    {  "value":       2337, "name": "MQRC_RFH_PARM_ERROR" },
    {  "value":       2338, "name": "MQRC_RFH_DUPLICATE_PARM" },
    {  "value":       2339, "name": "MQRC_RFH_PARM_MISSING" },
    {  "value":       2340, "name": "MQRC_CHAR_CONVERSION_ERROR" },
    {  "value":       2341, "name": "MQRC_UCS2_CONVERSION_ERROR" },
    {  "value":       2342, "name": "MQRC_DB2_NOT_AVAILABLE" },
    {  "value":       2343, "name": "MQRC_OBJECT_NOT_UNIQUE" },
    {  "value":       2344, "name": "MQRC_CONN_TAG_NOT_RELEASED" },
    {  "value":       2345, "name": "MQRC_CF_NOT_AVAILABLE" },
    {  "value":       2346, "name": "MQRC_CF_STRUC_IN_USE" },
    {  "value":       2347, "name": "MQRC_CF_STRUC_LIST_HDR_IN_USE" },
    {  "value":       2348, "name": "MQRC_CF_STRUC_AUTH_FAILED" },
    {  "value":       2349, "name": "MQRC_CF_STRUC_ERROR" },
    {  "value":       2350, "name": "MQRC_CONN_TAG_NOT_USABLE" },
    {  "value":       2351, "name": "MQRC_GLOBAL_UOW_CONFLICT" },
    {  "value":       2352, "name": "MQRC_LOCAL_UOW_CONFLICT" },
    {  "value":       2353, "name": "MQRC_HANDLE_IN_USE_FOR_UOW" },
    {  "value":       2354, "name": "MQRC_UOW_ENLISTMENT_ERROR" },
    {  "value":       2355, "name": "MQRC_UOW_MIX_NOT_SUPPORTED" },
    {  "value":       2356, "name": "MQRC_WXP_ERROR" },
    {  "value":       2357, "name": "MQRC_CURRENT_RECORD_ERROR" },
    {  "value":       2358, "name": "MQRC_NEXT_OFFSET_ERROR" },
    {  "value":       2359, "name": "MQRC_NO_RECORD_AVAILABLE" },
    {  "value":       2360, "name": "MQRC_OBJECT_LEVEL_INCOMPATIBLE" },
    {  "value":       2361, "name": "MQRC_NEXT_RECORD_ERROR" },
    {  "value":       2362, "name": "MQRC_BACKOUT_THRESHOLD_REACHED" },
    {  "value":       2363, "name": "MQRC_MSG_NOT_MATCHED" },
    {  "value":       2364, "name": "MQRC_JMS_FORMAT_ERROR" },
    {  "value":       2365, "name": "MQRC_SEGMENTS_NOT_SUPPORTED" },
    {  "value":       2366, "name": "MQRC_WRONG_CF_LEVEL" },
    {  "value":       2367, "name": "MQRC_CONFIG_CREATE_OBJECT" },
    {  "value":       2368, "name": "MQRC_CONFIG_CHANGE_OBJECT" },
    {  "value":       2369, "name": "MQRC_CONFIG_DELETE_OBJECT" },
    {  "value":       2370, "name": "MQRC_CONFIG_REFRESH_OBJECT" },
    {  "value":       2371, "name": "MQRC_CHANNEL_SSL_ERROR" },
    {  "value":       2372, "name": "MQRC_PARTICIPANT_NOT_DEFINED" },
    {  "value":       2373, "name": "MQRC_CF_STRUC_FAILED" },
    {  "value":       2374, "name": "MQRC_API_EXIT_ERROR" },
    {  "value":       2375, "name": "MQRC_API_EXIT_INIT_ERROR" },
    {  "value":       2376, "name": "MQRC_API_EXIT_TERM_ERROR" },
    {  "value":       2377, "name": "MQRC_EXIT_REASON_ERROR" },
    {  "value":       2378, "name": "MQRC_RESERVED_VALUE_ERROR" },
    {  "value":       2379, "name": "MQRC_NO_DATA_AVAILABLE" },
    {  "value":       2380, "name": "MQRC_SCO_ERROR" },
    {  "value":       2381, "name": "MQRC_KEY_REPOSITORY_ERROR" },
    {  "value":       2382, "name": "MQRC_CRYPTO_HARDWARE_ERROR" },
    {  "value":       2383, "name": "MQRC_AUTH_INFO_REC_COUNT_ERROR" },
    {  "value":       2384, "name": "MQRC_AUTH_INFO_REC_ERROR" },
    {  "value":       2385, "name": "MQRC_AIR_ERROR" },
    {  "value":       2386, "name": "MQRC_AUTH_INFO_TYPE_ERROR" },
    {  "value":       2387, "name": "MQRC_AUTH_INFO_CONN_NAME_ERROR" },
    {  "value":       2388, "name": "MQRC_LDAP_USER_NAME_ERROR" },
    {  "value":       2389, "name": "MQRC_LDAP_USER_NAME_LENGTH_ERR" },
    {  "value":       2390, "name": "MQRC_LDAP_PASSWORD_ERROR" },
    {  "value":       2391, "name": "MQRC_SSL_ALREADY_INITIALIZED" },
    {  "value":       2392, "name": "MQRC_SSL_CONFIG_ERROR" },
    {  "value":       2393, "name": "MQRC_SSL_INITIALIZATION_ERROR" },
    {  "value":       2394, "name": "MQRC_Q_INDEX_TYPE_ERROR" },
    {  "value":       2395, "name": "MQRC_CFBS_ERROR" },
    {  "value":       2396, "name": "MQRC_SSL_NOT_ALLOWED" },
    {  "value":       2397, "name": "MQRC_JSSE_ERROR" },
    {  "value":       2398, "name": "MQRC_SSL_PEER_NAME_MISMATCH" },
    {  "value":       2399, "name": "MQRC_SSL_PEER_NAME_ERROR" },
    {  "value":       2400, "name": "MQRC_UNSUPPORTED_CIPHER_SUITE" },
    {  "value":       2401, "name": "MQRC_SSL_CERTIFICATE_REVOKED" },
    {  "value":       2402, "name": "MQRC_SSL_CERT_STORE_ERROR" },
    {  "value":       2406, "name": "MQRC_CLIENT_EXIT_LOAD_ERROR" },
    {  "value":       2407, "name": "MQRC_CLIENT_EXIT_ERROR" },
    {  "value":       2408, "name": "MQRC_UOW_COMMITTED" },
    {  "value":       2409, "name": "MQRC_SSL_KEY_RESET_ERROR" },
    {  "value":       2410, "name": "MQRC_UNKNOWN_COMPONENT_NAME" },
    {  "value":       2411, "name": "MQRC_LOGGER_STATUS" },
    {  "value":       2412, "name": "MQRC_COMMAND_MQSC" },
    {  "value":       2413, "name": "MQRC_COMMAND_PCF" },
    {  "value":       2414, "name": "MQRC_CFIF_ERROR" },
    {  "value":       2415, "name": "MQRC_CFSF_ERROR" },
    {  "value":       2416, "name": "MQRC_CFGR_ERROR" },
    {  "value":       2417, "name": "MQRC_MSG_NOT_ALLOWED_IN_GROUP" },
    {  "value":       2418, "name": "MQRC_FILTER_OPERATOR_ERROR" },
    {  "value":       2419, "name": "MQRC_NESTED_SELECTOR_ERROR" },
    {  "value":       2420, "name": "MQRC_EPH_ERROR" },
    {  "value":       2421, "name": "MQRC_RFH_FORMAT_ERROR" },
    {  "value":       2422, "name": "MQRC_CFBF_ERROR" },
    {  "value":       2423, "name": "MQRC_CLIENT_CHANNEL_CONFLICT" },
    {  "value":       2424, "name": "MQRC_SD_ERROR" },
    {  "value":       2425, "name": "MQRC_TOPIC_STRING_ERROR" },
    {  "value":       2426, "name": "MQRC_STS_ERROR" },
    {  "value":       2428, "name": "MQRC_NO_SUBSCRIPTION" },
    {  "value":       2429, "name": "MQRC_SUBSCRIPTION_IN_USE" },
    {  "value":       2430, "name": "MQRC_STAT_TYPE_ERROR" },
    {  "value":       2431, "name": "MQRC_SUB_USER_DATA_ERROR" },
    {  "value":       2432, "name": "MQRC_SUB_ALREADY_EXISTS" },
    {  "value":       2434, "name": "MQRC_IDENTITY_MISMATCH" },
    {  "value":       2435, "name": "MQRC_ALTER_SUB_ERROR" },
    {  "value":       2436, "name": "MQRC_DURABILITY_NOT_ALLOWED" },
    {  "value":       2437, "name": "MQRC_NO_RETAINED_MSG" },
    {  "value":       2438, "name": "MQRC_SRO_ERROR" },
    {  "value":       2440, "name": "MQRC_SUB_NAME_ERROR" },
    {  "value":       2441, "name": "MQRC_OBJECT_STRING_ERROR" },
    {  "value":       2442, "name": "MQRC_PROPERTY_NAME_ERROR" },
    {  "value":       2443, "name": "MQRC_SEGMENTATION_NOT_ALLOWED" },
    {  "value":       2444, "name": "MQRC_CBD_ERROR" },
    {  "value":       2445, "name": "MQRC_CTLO_ERROR" },
    {  "value":       2446, "name": "MQRC_NO_CALLBACKS_ACTIVE" },
    {  "value":       2448, "name": "MQRC_CALLBACK_NOT_REGISTERED" },
    {  "value":       2457, "name": "MQRC_OPTIONS_CHANGED" },
    {  "value":       2458, "name": "MQRC_READ_AHEAD_MSGS" },
    {  "value":       2459, "name": "MQRC_SELECTOR_SYNTAX_ERROR" },
    {  "value":       2460, "name": "MQRC_HMSG_ERROR" },
    {  "value":       2461, "name": "MQRC_CMHO_ERROR" },
    {  "value":       2462, "name": "MQRC_DMHO_ERROR" },
    {  "value":       2463, "name": "MQRC_SMPO_ERROR" },
    {  "value":       2464, "name": "MQRC_IMPO_ERROR" },
    {  "value":       2465, "name": "MQRC_PROPERTY_NAME_TOO_BIG" },
    {  "value":       2466, "name": "MQRC_PROP_VALUE_NOT_CONVERTED" },
    {  "value":       2467, "name": "MQRC_PROP_TYPE_NOT_SUPPORTED" },
    {  "value":       2469, "name": "MQRC_PROPERTY_VALUE_TOO_BIG" },
    {  "value":       2470, "name": "MQRC_PROP_CONV_NOT_SUPPORTED" },
    {  "value":       2471, "name": "MQRC_PROPERTY_NOT_AVAILABLE" },
    {  "value":       2472, "name": "MQRC_PROP_NUMBER_FORMAT_ERROR" },
    {  "value":       2473, "name": "MQRC_PROPERTY_TYPE_ERROR" },
    {  "value":       2478, "name": "MQRC_PROPERTIES_TOO_BIG" },
    {  "value":       2479, "name": "MQRC_PUT_NOT_RETAINED" },
    {  "value":       2480, "name": "MQRC_ALIAS_TARGTYPE_CHANGED" },
    {  "value":       2481, "name": "MQRC_DMPO_ERROR" },
    {  "value":       2482, "name": "MQRC_PD_ERROR" },
    {  "value":       2483, "name": "MQRC_CALLBACK_TYPE_ERROR" },
    {  "value":       2484, "name": "MQRC_CBD_OPTIONS_ERROR" },
    {  "value":       2485, "name": "MQRC_MAX_MSG_LENGTH_ERROR" },
    {  "value":       2486, "name": "MQRC_CALLBACK_ROUTINE_ERROR" },
    {  "value":       2487, "name": "MQRC_CALLBACK_LINK_ERROR" },
    {  "value":       2488, "name": "MQRC_OPERATION_ERROR" },
    {  "value":       2489, "name": "MQRC_BMHO_ERROR" },
    {  "value":       2490, "name": "MQRC_UNSUPPORTED_PROPERTY" },
    {  "value":       2491, "name": "MQRC_MSG_LENGTH_ERROR" },
    {  "value":       2492, "name": "MQRC_PROP_NAME_NOT_CONVERTED" },
    {  "value":       2494, "name": "MQRC_GET_ENABLED" },
    {  "value":       2495, "name": "MQRC_MODULE_NOT_FOUND" },
    {  "value":       2496, "name": "MQRC_MODULE_INVALID" },
    {  "value":       2497, "name": "MQRC_MODULE_ENTRY_NOT_FOUND" },
    {  "value":       2498, "name": "MQRC_MIXED_CONTENT_NOT_ALLOWED" },
    {  "value":       2499, "name": "MQRC_MSG_HANDLE_IN_USE" },
    {  "value":       2500, "name": "MQRC_HCONN_ASYNC_ACTIVE" },
    {  "value":       2501, "name": "MQRC_MHBO_ERROR" },
    {  "value":       2502, "name": "MQRC_PUBLICATION_FAILURE" },
    {  "value":       2503, "name": "MQRC_SUB_INHIBITED" },
    {  "value":       2504, "name": "MQRC_SELECTOR_ALWAYS_FALSE" },
    {  "value":       2507, "name": "MQRC_XEPO_ERROR" },
    {  "value":       2509, "name": "MQRC_DURABILITY_NOT_ALTERABLE" },
    {  "value":       2510, "name": "MQRC_TOPIC_NOT_ALTERABLE" },
    {  "value":       2512, "name": "MQRC_SUBLEVEL_NOT_ALTERABLE" },
    {  "value":       2513, "name": "MQRC_PROPERTY_NAME_LENGTH_ERR" },
    {  "value":       2514, "name": "MQRC_DUPLICATE_GROUP_SUB" },
    {  "value":       2515, "name": "MQRC_GROUPING_NOT_ALTERABLE" },
    {  "value":       2516, "name": "MQRC_SELECTOR_INVALID_FOR_TYPE" },
    {  "value":       2517, "name": "MQRC_HOBJ_QUIESCED" },
    {  "value":       2518, "name": "MQRC_HOBJ_QUIESCED_NO_MSGS" },
    {  "value":       2519, "name": "MQRC_SELECTION_STRING_ERROR" },
    {  "value":       2520, "name": "MQRC_RES_OBJECT_STRING_ERROR" },
    {  "value":       2521, "name": "MQRC_CONNECTION_SUSPENDED" },
    {  "value":       2522, "name": "MQRC_INVALID_DESTINATION" },
    {  "value":       2523, "name": "MQRC_INVALID_SUBSCRIPTION" },
    {  "value":       2524, "name": "MQRC_SELECTOR_NOT_ALTERABLE" },
    {  "value":       2525, "name": "MQRC_RETAINED_MSG_Q_ERROR" },
    {  "value":       2526, "name": "MQRC_RETAINED_NOT_DELIVERED" },
    {  "value":       2527, "name": "MQRC_RFH_RESTRICTED_FORMAT_ERR" },
    {  "value":       2528, "name": "MQRC_CONNECTION_STOPPED" },
    {  "value":       2529, "name": "MQRC_ASYNC_UOW_CONFLICT" },
    {  "value":       2530, "name": "MQRC_ASYNC_XA_CONFLICT" },
    {  "value":       2531, "name": "MQRC_PUBSUB_INHIBITED" },
    {  "value":       2532, "name": "MQRC_MSG_HANDLE_COPY_FAILURE" },
    {  "value":       2533, "name": "MQRC_DEST_CLASS_NOT_ALTERABLE" },
    {  "value":       2534, "name": "MQRC_OPERATION_NOT_ALLOWED" },
    {  "value":       2535, "name": "MQRC_ACTION_ERROR" },
    {  "value":       2537, "name": "MQRC_CHANNEL_NOT_AVAILABLE" },
    {  "value":       2538, "name": "MQRC_HOST_NOT_AVAILABLE" },
    {  "value":       2539, "name": "MQRC_CHANNEL_CONFIG_ERROR" },
    {  "value":       2540, "name": "MQRC_UNKNOWN_CHANNEL_NAME" },
    {  "value":       2541, "name": "MQRC_LOOPING_PUBLICATION" },
    {  "value":       2542, "name": "MQRC_ALREADY_JOINED" },
    {  "value":       2543, "name": "MQRC_STANDBY_Q_MGR" },
    {  "value":       2544, "name": "MQRC_RECONNECTING" },
    {  "value":       2545, "name": "MQRC_RECONNECTED" },
    {  "value":       2546, "name": "MQRC_RECONNECT_QMID_MISMATCH" },
    {  "value":       2547, "name": "MQRC_RECONNECT_INCOMPATIBLE" },
    {  "value":       2548, "name": "MQRC_RECONNECT_FAILED" },
    {  "value":       2549, "name": "MQRC_CALL_INTERRUPTED" },
    {  "value":       2550, "name": "MQRC_NO_SUBS_MATCHED" },
    {  "value":       2551, "name": "MQRC_SELECTION_NOT_AVAILABLE" },
    {  "value":       2552, "name": "MQRC_CHANNEL_SSL_WARNING" },
    {  "value":       2553, "name": "MQRC_OCSP_URL_ERROR" },
    {  "value":       2554, "name": "MQRC_CONTENT_ERROR" },
    {  "value":       2555, "name": "MQRC_RECONNECT_Q_MGR_REQD" },
    {  "value":       2556, "name": "MQRC_RECONNECT_TIMED_OUT" },
    {  "value":       2557, "name": "MQRC_PUBLISH_EXIT_ERROR" },
    {  "value":       2558, "name": "MQRC_COMMINFO_ERROR" },
    {  "value":       2559, "name": "MQRC_DEF_SYNCPOINT_INHIBITED" },
    {  "value":       2560, "name": "MQRC_MULTICAST_ONLY" },
    {  "value":       2561, "name": "MQRC_DATA_SET_NOT_AVAILABLE" },
    {  "value":       2562, "name": "MQRC_GROUPING_NOT_ALLOWED" },
    {  "value":       2563, "name": "MQRC_GROUP_ADDRESS_ERROR" },
    {  "value":       2564, "name": "MQRC_MULTICAST_CONFIG_ERROR" },
    {  "value":       2565, "name": "MQRC_MULTICAST_INTERFACE_ERROR" },
    {  "value":       2566, "name": "MQRC_MULTICAST_SEND_ERROR" },
    {  "value":       2567, "name": "MQRC_MULTICAST_INTERNAL_ERROR" },
    {  "value":       2568, "name": "MQRC_CONNECTION_NOT_AVAILABLE" },
    {  "value":       2569, "name": "MQRC_SYNCPOINT_NOT_ALLOWED" },
    {  "value":       2570, "name": "MQRC_SSL_ALT_PROVIDER_REQUIRED" },
    {  "value":       2571, "name": "MQRC_MCAST_PUB_STATUS" },
    {  "value":       2572, "name": "MQRC_MCAST_SUB_STATUS" },
    {  "value":       2573, "name": "MQRC_PRECONN_EXIT_LOAD_ERROR" },
    {  "value":       2574, "name": "MQRC_PRECONN_EXIT_NOT_FOUND" },
    {  "value":       2575, "name": "MQRC_PRECONN_EXIT_ERROR" },
    {  "value":       2576, "name": "MQRC_CD_ARRAY_ERROR" },
    {  "value":       2577, "name": "MQRC_CHANNEL_BLOCKED" },
    {  "value":       2578, "name": "MQRC_CHANNEL_BLOCKED_WARNING" },
    {  "value":       2579, "name": "MQRC_SUBSCRIPTION_CREATE" },
    {  "value":       2580, "name": "MQRC_SUBSCRIPTION_DELETE" },
    {  "value":       2581, "name": "MQRC_SUBSCRIPTION_CHANGE" },
    {  "value":       2582, "name": "MQRC_SUBSCRIPTION_REFRESH" },
    {  "value":       2583, "name": "MQRC_INSTALLATION_MISMATCH" },
    {  "value":       2584, "name": "MQRC_NOT_PRIVILEGED" },
    {  "value":       2586, "name": "MQRC_PROPERTIES_DISABLED" },
    {  "value":       2587, "name": "MQRC_HMSG_NOT_AVAILABLE" },
    {  "value":       2588, "name": "MQRC_EXIT_PROPS_NOT_SUPPORTED" },
    {  "value":       2589, "name": "MQRC_INSTALLATION_MISSING" },
    {  "value":       2590, "name": "MQRC_FASTPATH_NOT_AVAILABLE" },
    {  "value":       2591, "name": "MQRC_CIPHER_SPEC_NOT_SUITE_B" },
    {  "value":       2592, "name": "MQRC_SUITE_B_ERROR" },
    {  "value":       2593, "name": "MQRC_CERT_VAL_POLICY_ERROR" },
    {  "value":       2594, "name": "MQRC_PASSWORD_PROTECTION_ERROR" },
    {  "value":       2595, "name": "MQRC_CSP_ERROR" },
    {  "value":       2596, "name": "MQRC_CERT_LABEL_NOT_ALLOWED" },
    {  "value":       2598, "name": "MQRC_ADMIN_TOPIC_STRING_ERROR" },
    {  "value":       2599, "name": "MQRC_AMQP_NOT_AVAILABLE" },
    {  "value":       2600, "name": "MQRC_CCDT_URL_ERROR" },
    {  "value":       2601, "name": "MQRC_Q_MGR_RECONNECT_REQUESTED" },
    {  "value":       2602, "name": "MQRC_BNO_ERROR" },
    {  "value":       2603, "name": "MQRC_OUTBOUND_SNI_NOT_VALID" },
    {  "value":       2604, "name": "MQRC_HTTPS_KEYSTORE_ERROR" },
    {  "value":       2701, "name": "MQCAMO_CLOSE_DATE" },
    {  "value":       2701, "name": "MQCAMO_FIRST" },
    {  "value":       2702, "name": "MQCAMO_CLOSE_TIME" },
    {  "value":       2703, "name": "MQCAMO_CONN_DATE" },
    {  "value":       2704, "name": "MQCAMO_CONN_TIME" },
    {  "value":       2705, "name": "MQCAMO_DISC_DATE" },
    {  "value":       2706, "name": "MQCAMO_DISC_TIME" },
    {  "value":       2707, "name": "MQCAMO_END_DATE" },
    {  "value":       2708, "name": "MQCAMO_END_TIME" },
    {  "value":       2709, "name": "MQCAMO_OPEN_DATE" },
    {  "value":       2710, "name": "MQCAMO_OPEN_TIME" },
    {  "value":       2711, "name": "MQCAMO_START_DATE" },
    {  "value":       2712, "name": "MQCAMO_START_TIME" },
    {  "value":       2713, "name": "MQCAMO_MONITOR_CLASS" },
    {  "value":       2714, "name": "MQCAMO_MONITOR_TYPE" },
    {  "value":       2715, "name": "MQCAMO_LAST_USED" },
    {  "value":       2715, "name": "MQCAMO_MONITOR_DESC" },
    {  "value":       3001, "name": "MQCACF_FIRST" },
    {  "value":       3001, "name": "MQCACF_FROM_Q_NAME" },
    {  "value":       3001, "name": "MQRCCF_CFH_TYPE_ERROR" },
    {  "value":       3002, "name": "MQCACF_TO_Q_NAME" },
    {  "value":       3002, "name": "MQRCCF_CFH_LENGTH_ERROR" },
    {  "value":       3003, "name": "MQCACF_FROM_PROCESS_NAME" },
    {  "value":       3003, "name": "MQRCCF_CFH_VERSION_ERROR" },
    {  "value":       3004, "name": "MQCACF_TO_PROCESS_NAME" },
    {  "value":       3004, "name": "MQRCCF_CFH_MSG_SEQ_NUMBER_ERR" },
    {  "value":       3005, "name": "MQCACF_FROM_NAMELIST_NAME" },
    {  "value":       3005, "name": "MQRCCF_CFH_CONTROL_ERROR" },
    {  "value":       3006, "name": "MQCACF_TO_NAMELIST_NAME" },
    {  "value":       3006, "name": "MQRCCF_CFH_PARM_COUNT_ERROR" },
    {  "value":       3007, "name": "MQCACF_FROM_CHANNEL_NAME" },
    {  "value":       3007, "name": "MQRCCF_CFH_COMMAND_ERROR" },
    {  "value":       3008, "name": "MQCACF_TO_CHANNEL_NAME" },
    {  "value":       3008, "name": "MQRCCF_COMMAND_FAILED" },
    {  "value":       3009, "name": "MQCACF_FROM_AUTH_INFO_NAME" },
    {  "value":       3009, "name": "MQRCCF_CFIN_LENGTH_ERROR" },
    {  "value":       3010, "name": "MQCACF_TO_AUTH_INFO_NAME" },
    {  "value":       3010, "name": "MQRCCF_CFST_LENGTH_ERROR" },
    {  "value":       3011, "name": "MQCACF_Q_NAMES" },
    {  "value":       3011, "name": "MQRCCF_CFST_STRING_LENGTH_ERR" },
    {  "value":       3012, "name": "MQCACF_PROCESS_NAMES" },
    {  "value":       3012, "name": "MQRCCF_FORCE_VALUE_ERROR" },
    {  "value":       3013, "name": "MQCACF_NAMELIST_NAMES" },
    {  "value":       3013, "name": "MQRCCF_STRUCTURE_TYPE_ERROR" },
    {  "value":       3014, "name": "MQCACF_ESCAPE_TEXT" },
    {  "value":       3014, "name": "MQRCCF_CFIN_PARM_ID_ERROR" },
    {  "value":       3015, "name": "MQCACF_LOCAL_Q_NAMES" },
    {  "value":       3015, "name": "MQRCCF_CFST_PARM_ID_ERROR" },
    {  "value":       3016, "name": "MQCACF_MODEL_Q_NAMES" },
    {  "value":       3016, "name": "MQRCCF_MSG_LENGTH_ERROR" },
    {  "value":       3017, "name": "MQCACF_ALIAS_Q_NAMES" },
    {  "value":       3017, "name": "MQRCCF_CFIN_DUPLICATE_PARM" },
    {  "value":       3018, "name": "MQCACF_REMOTE_Q_NAMES" },
    {  "value":       3018, "name": "MQRCCF_CFST_DUPLICATE_PARM" },
    {  "value":       3019, "name": "MQCACF_SENDER_CHANNEL_NAMES" },
    {  "value":       3019, "name": "MQRCCF_PARM_COUNT_TOO_SMALL" },
    {  "value":       3020, "name": "MQCACF_SERVER_CHANNEL_NAMES" },
    {  "value":       3020, "name": "MQRCCF_PARM_COUNT_TOO_BIG" },
    {  "value":       3021, "name": "MQCACF_REQUESTER_CHANNEL_NAMES" },
    {  "value":       3021, "name": "MQRCCF_Q_ALREADY_IN_CELL" },
    {  "value":       3022, "name": "MQCACF_RECEIVER_CHANNEL_NAMES" },
    {  "value":       3022, "name": "MQRCCF_Q_TYPE_ERROR" },
    {  "value":       3023, "name": "MQCACF_OBJECT_Q_MGR_NAME" },
    {  "value":       3023, "name": "MQRCCF_MD_FORMAT_ERROR" },
    {  "value":       3024, "name": "MQCACF_APPL_NAME" },
    {  "value":       3024, "name": "MQRCCF_CFSL_LENGTH_ERROR" },
    {  "value":       3025, "name": "MQCACF_USER_IDENTIFIER" },
    {  "value":       3025, "name": "MQRCCF_REPLACE_VALUE_ERROR" },
    {  "value":       3026, "name": "MQCACF_AUX_ERROR_DATA_STR_1" },
    {  "value":       3026, "name": "MQRCCF_CFIL_DUPLICATE_VALUE" },
    {  "value":       3027, "name": "MQCACF_AUX_ERROR_DATA_STR_2" },
    {  "value":       3027, "name": "MQRCCF_CFIL_COUNT_ERROR" },
    {  "value":       3028, "name": "MQCACF_AUX_ERROR_DATA_STR_3" },
    {  "value":       3028, "name": "MQRCCF_CFIL_LENGTH_ERROR" },
    {  "value":       3029, "name": "MQCACF_BRIDGE_NAME" },
    {  "value":       3029, "name": "MQRCCF_MODE_VALUE_ERROR" },
    {  "value":       3029, "name": "MQRCCF_QUIESCE_VALUE_ERROR" },
    {  "value":       3030, "name": "MQCACF_STREAM_NAME" },
    {  "value":       3030, "name": "MQRCCF_MSG_SEQ_NUMBER_ERROR" },
    {  "value":       3031, "name": "MQCACF_TOPIC" },
    {  "value":       3031, "name": "MQRCCF_PING_DATA_COUNT_ERROR" },
    {  "value":       3032, "name": "MQCACF_PARENT_Q_MGR_NAME" },
    {  "value":       3032, "name": "MQRCCF_PING_DATA_COMPARE_ERROR" },
    {  "value":       3033, "name": "MQCACF_CORREL_ID" },
    {  "value":       3033, "name": "MQRCCF_CFSL_PARM_ID_ERROR" },
    {  "value":       3034, "name": "MQCACF_PUBLISH_TIMESTAMP" },
    {  "value":       3034, "name": "MQRCCF_CHANNEL_TYPE_ERROR" },
    {  "value":       3035, "name": "MQCACF_STRING_DATA" },
    {  "value":       3035, "name": "MQRCCF_PARM_SEQUENCE_ERROR" },
    {  "value":       3036, "name": "MQCACF_SUPPORTED_STREAM_NAME" },
    {  "value":       3036, "name": "MQRCCF_XMIT_PROTOCOL_TYPE_ERR" },
    {  "value":       3037, "name": "MQCACF_REG_TOPIC" },
    {  "value":       3037, "name": "MQRCCF_BATCH_SIZE_ERROR" },
    {  "value":       3038, "name": "MQCACF_REG_TIME" },
    {  "value":       3038, "name": "MQRCCF_DISC_INT_ERROR" },
    {  "value":       3039, "name": "MQCACF_REG_USER_ID" },
    {  "value":       3039, "name": "MQRCCF_SHORT_RETRY_ERROR" },
    {  "value":       3040, "name": "MQCACF_CHILD_Q_MGR_NAME" },
    {  "value":       3040, "name": "MQRCCF_SHORT_TIMER_ERROR" },
    {  "value":       3041, "name": "MQCACF_REG_STREAM_NAME" },
    {  "value":       3041, "name": "MQRCCF_LONG_RETRY_ERROR" },
    {  "value":       3042, "name": "MQCACF_REG_Q_MGR_NAME" },
    {  "value":       3042, "name": "MQRCCF_LONG_TIMER_ERROR" },
    {  "value":       3043, "name": "MQCACF_REG_Q_NAME" },
    {  "value":       3043, "name": "MQRCCF_SEQ_NUMBER_WRAP_ERROR" },
    {  "value":       3044, "name": "MQCACF_REG_CORREL_ID" },
    {  "value":       3044, "name": "MQRCCF_MAX_MSG_LENGTH_ERROR" },
    {  "value":       3045, "name": "MQCACF_EVENT_USER_ID" },
    {  "value":       3045, "name": "MQRCCF_PUT_AUTH_ERROR" },
    {  "value":       3046, "name": "MQCACF_OBJECT_NAME" },
    {  "value":       3046, "name": "MQRCCF_PURGE_VALUE_ERROR" },
    {  "value":       3047, "name": "MQCACF_EVENT_Q_MGR" },
    {  "value":       3047, "name": "MQRCCF_CFIL_PARM_ID_ERROR" },
    {  "value":       3048, "name": "MQCACF_AUTH_INFO_NAMES" },
    {  "value":       3048, "name": "MQRCCF_MSG_TRUNCATED" },
    {  "value":       3049, "name": "MQCACF_EVENT_APPL_IDENTITY" },
    {  "value":       3049, "name": "MQRCCF_CCSID_ERROR" },
    {  "value":       3050, "name": "MQCACF_EVENT_APPL_NAME" },
    {  "value":       3050, "name": "MQRCCF_ENCODING_ERROR" },
    {  "value":       3051, "name": "MQCACF_EVENT_APPL_ORIGIN" },
    {  "value":       3051, "name": "MQRCCF_QUEUES_VALUE_ERROR" },
    {  "value":       3052, "name": "MQCACF_SUBSCRIPTION_NAME" },
    {  "value":       3052, "name": "MQRCCF_DATA_CONV_VALUE_ERROR" },
    {  "value":       3053, "name": "MQCACF_REG_SUB_NAME" },
    {  "value":       3053, "name": "MQRCCF_INDOUBT_VALUE_ERROR" },
    {  "value":       3054, "name": "MQCACF_SUBSCRIPTION_IDENTITY" },
    {  "value":       3054, "name": "MQRCCF_ESCAPE_TYPE_ERROR" },
    {  "value":       3055, "name": "MQCACF_REG_SUB_IDENTITY" },
    {  "value":       3055, "name": "MQRCCF_REPOS_VALUE_ERROR" },
    {  "value":       3056, "name": "MQCACF_SUBSCRIPTION_USER_DATA" },
    {  "value":       3057, "name": "MQCACF_REG_SUB_USER_DATA" },
    {  "value":       3058, "name": "MQCACF_APPL_TAG" },
    {  "value":       3059, "name": "MQCACF_DATA_SET_NAME" },
    {  "value":       3060, "name": "MQCACF_UOW_START_DATE" },
    {  "value":       3061, "name": "MQCACF_UOW_START_TIME" },
    {  "value":       3062, "name": "MQCACF_UOW_LOG_START_DATE" },
    {  "value":       3062, "name": "MQRCCF_CHANNEL_TABLE_ERROR" },
    {  "value":       3063, "name": "MQCACF_UOW_LOG_START_TIME" },
    {  "value":       3063, "name": "MQRCCF_MCA_TYPE_ERROR" },
    {  "value":       3064, "name": "MQCACF_UOW_LOG_EXTENT_NAME" },
    {  "value":       3064, "name": "MQRCCF_CHL_INST_TYPE_ERROR" },
    {  "value":       3065, "name": "MQCACF_PRINCIPAL_ENTITY_NAMES" },
    {  "value":       3065, "name": "MQRCCF_CHL_STATUS_NOT_FOUND" },
    {  "value":       3066, "name": "MQCACF_GROUP_ENTITY_NAMES" },
    {  "value":       3066, "name": "MQRCCF_CFSL_DUPLICATE_PARM" },
    {  "value":       3067, "name": "MQCACF_AUTH_PROFILE_NAME" },
    {  "value":       3067, "name": "MQRCCF_CFSL_TOTAL_LENGTH_ERROR" },
    {  "value":       3068, "name": "MQCACF_ENTITY_NAME" },
    {  "value":       3068, "name": "MQRCCF_CFSL_COUNT_ERROR" },
    {  "value":       3069, "name": "MQCACF_SERVICE_COMPONENT" },
    {  "value":       3069, "name": "MQRCCF_CFSL_STRING_LENGTH_ERR" },
    {  "value":       3070, "name": "MQCACF_RESPONSE_Q_MGR_NAME" },
    {  "value":       3070, "name": "MQRCCF_BROKER_DELETED" },
    {  "value":       3071, "name": "MQCACF_CURRENT_LOG_EXTENT_NAME" },
    {  "value":       3071, "name": "MQRCCF_STREAM_ERROR" },
    {  "value":       3072, "name": "MQCACF_RESTART_LOG_EXTENT_NAME" },
    {  "value":       3072, "name": "MQRCCF_TOPIC_ERROR" },
    {  "value":       3073, "name": "MQCACF_MEDIA_LOG_EXTENT_NAME" },
    {  "value":       3073, "name": "MQRCCF_NOT_REGISTERED" },
    {  "value":       3074, "name": "MQCACF_LOG_PATH" },
    {  "value":       3074, "name": "MQRCCF_Q_MGR_NAME_ERROR" },
    {  "value":       3075, "name": "MQCACF_COMMAND_MQSC" },
    {  "value":       3075, "name": "MQRCCF_INCORRECT_STREAM" },
    {  "value":       3076, "name": "MQCACF_Q_MGR_CPF" },
    {  "value":       3076, "name": "MQRCCF_Q_NAME_ERROR" },
    {  "value":       3077, "name": "MQRCCF_NO_RETAINED_MSG" },
    {  "value":       3078, "name": "MQCACF_USAGE_LOG_RBA" },
    {  "value":       3078, "name": "MQRCCF_DUPLICATE_IDENTITY" },
    {  "value":       3079, "name": "MQCACF_USAGE_LOG_LRSN" },
    {  "value":       3079, "name": "MQRCCF_INCORRECT_Q" },
    {  "value":       3080, "name": "MQCACF_COMMAND_SCOPE" },
    {  "value":       3080, "name": "MQRCCF_CORREL_ID_ERROR" },
    {  "value":       3081, "name": "MQCACF_ASID" },
    {  "value":       3081, "name": "MQRCCF_NOT_AUTHORIZED" },
    {  "value":       3082, "name": "MQCACF_PSB_NAME" },
    {  "value":       3082, "name": "MQRCCF_UNKNOWN_STREAM" },
    {  "value":       3083, "name": "MQCACF_PST_ID" },
    {  "value":       3083, "name": "MQRCCF_REG_OPTIONS_ERROR" },
    {  "value":       3084, "name": "MQCACF_TASK_NUMBER" },
    {  "value":       3084, "name": "MQRCCF_PUB_OPTIONS_ERROR" },
    {  "value":       3085, "name": "MQCACF_TRANSACTION_ID" },
    {  "value":       3085, "name": "MQRCCF_UNKNOWN_BROKER" },
    {  "value":       3086, "name": "MQCACF_Q_MGR_UOW_ID" },
    {  "value":       3086, "name": "MQRCCF_Q_MGR_CCSID_ERROR" },
    {  "value":       3087, "name": "MQRCCF_DEL_OPTIONS_ERROR" },
    {  "value":       3088, "name": "MQCACF_ORIGIN_NAME" },
    {  "value":       3088, "name": "MQRCCF_CLUSTER_NAME_CONFLICT" },
    {  "value":       3089, "name": "MQCACF_ENV_INFO" },
    {  "value":       3089, "name": "MQRCCF_REPOS_NAME_CONFLICT" },
    {  "value":       3090, "name": "MQCACF_SECURITY_PROFILE" },
    {  "value":       3090, "name": "MQRCCF_CLUSTER_Q_USAGE_ERROR" },
    {  "value":       3091, "name": "MQCACF_CONFIGURATION_DATE" },
    {  "value":       3091, "name": "MQRCCF_ACTION_VALUE_ERROR" },
    {  "value":       3092, "name": "MQCACF_CONFIGURATION_TIME" },
    {  "value":       3092, "name": "MQRCCF_COMMS_LIBRARY_ERROR" },
    {  "value":       3093, "name": "MQCACF_FROM_CF_STRUC_NAME" },
    {  "value":       3093, "name": "MQRCCF_NETBIOS_NAME_ERROR" },
    {  "value":       3094, "name": "MQCACF_TO_CF_STRUC_NAME" },
    {  "value":       3094, "name": "MQRCCF_BROKER_COMMAND_FAILED" },
    {  "value":       3095, "name": "MQCACF_CF_STRUC_NAMES" },
    {  "value":       3095, "name": "MQRCCF_CFST_CONFLICTING_PARM" },
    {  "value":       3096, "name": "MQCACF_FAIL_DATE" },
    {  "value":       3096, "name": "MQRCCF_PATH_NOT_VALID" },
    {  "value":       3097, "name": "MQCACF_FAIL_TIME" },
    {  "value":       3097, "name": "MQRCCF_PARM_SYNTAX_ERROR" },
    {  "value":       3098, "name": "MQCACF_BACKUP_DATE" },
    {  "value":       3098, "name": "MQRCCF_PWD_LENGTH_ERROR" },
    {  "value":       3099, "name": "MQCACF_BACKUP_TIME" },
    {  "value":       3100, "name": "MQCACF_SYSTEM_NAME" },
    {  "value":       3101, "name": "MQCACF_CF_STRUC_BACKUP_START" },
    {  "value":       3102, "name": "MQCACF_CF_STRUC_BACKUP_END" },
    {  "value":       3103, "name": "MQCACF_CF_STRUC_LOG_Q_MGRS" },
    {  "value":       3104, "name": "MQCACF_FROM_STORAGE_CLASS" },
    {  "value":       3105, "name": "MQCACF_TO_STORAGE_CLASS" },
    {  "value":       3106, "name": "MQCACF_STORAGE_CLASS_NAMES" },
    {  "value":       3108, "name": "MQCACF_DSG_NAME" },
    {  "value":       3109, "name": "MQCACF_DB2_NAME" },
    {  "value":       3110, "name": "MQCACF_SYSP_CMD_USER_ID" },
    {  "value":       3111, "name": "MQCACF_SYSP_OTMA_GROUP" },
    {  "value":       3112, "name": "MQCACF_SYSP_OTMA_MEMBER" },
    {  "value":       3113, "name": "MQCACF_SYSP_OTMA_DRU_EXIT" },
    {  "value":       3114, "name": "MQCACF_SYSP_OTMA_TPIPE_PFX" },
    {  "value":       3115, "name": "MQCACF_SYSP_ARCHIVE_PFX1" },
    {  "value":       3116, "name": "MQCACF_SYSP_ARCHIVE_UNIT1" },
    {  "value":       3117, "name": "MQCACF_SYSP_LOG_CORREL_ID" },
    {  "value":       3118, "name": "MQCACF_SYSP_UNIT_VOLSER" },
    {  "value":       3119, "name": "MQCACF_SYSP_Q_MGR_TIME" },
    {  "value":       3120, "name": "MQCACF_SYSP_Q_MGR_DATE" },
    {  "value":       3121, "name": "MQCACF_SYSP_Q_MGR_RBA" },
    {  "value":       3122, "name": "MQCACF_SYSP_LOG_RBA" },
    {  "value":       3123, "name": "MQCACF_SYSP_SERVICE" },
    {  "value":       3124, "name": "MQCACF_FROM_LISTENER_NAME" },
    {  "value":       3125, "name": "MQCACF_TO_LISTENER_NAME" },
    {  "value":       3126, "name": "MQCACF_FROM_SERVICE_NAME" },
    {  "value":       3127, "name": "MQCACF_TO_SERVICE_NAME" },
    {  "value":       3128, "name": "MQCACF_LAST_PUT_DATE" },
    {  "value":       3129, "name": "MQCACF_LAST_PUT_TIME" },
    {  "value":       3130, "name": "MQCACF_LAST_GET_DATE" },
    {  "value":       3131, "name": "MQCACF_LAST_GET_TIME" },
    {  "value":       3132, "name": "MQCACF_OPERATION_DATE" },
    {  "value":       3133, "name": "MQCACF_OPERATION_TIME" },
    {  "value":       3134, "name": "MQCACF_ACTIVITY_DESC" },
    {  "value":       3135, "name": "MQCACF_APPL_IDENTITY_DATA" },
    {  "value":       3136, "name": "MQCACF_APPL_ORIGIN_DATA" },
    {  "value":       3137, "name": "MQCACF_PUT_DATE" },
    {  "value":       3138, "name": "MQCACF_PUT_TIME" },
    {  "value":       3139, "name": "MQCACF_REPLY_TO_Q" },
    {  "value":       3140, "name": "MQCACF_REPLY_TO_Q_MGR" },
    {  "value":       3141, "name": "MQCACF_RESOLVED_Q_NAME" },
    {  "value":       3142, "name": "MQCACF_STRUC_ID" },
    {  "value":       3143, "name": "MQCACF_VALUE_NAME" },
    {  "value":       3144, "name": "MQCACF_SERVICE_START_DATE" },
    {  "value":       3145, "name": "MQCACF_SERVICE_START_TIME" },
    {  "value":       3146, "name": "MQCACF_SYSP_OFFLINE_RBA" },
    {  "value":       3147, "name": "MQCACF_SYSP_ARCHIVE_PFX2" },
    {  "value":       3148, "name": "MQCACF_SYSP_ARCHIVE_UNIT2" },
    {  "value":       3149, "name": "MQCACF_TO_TOPIC_NAME" },
    {  "value":       3150, "name": "MQCACF_FROM_TOPIC_NAME" },
    {  "value":       3150, "name": "MQRCCF_FILTER_ERROR" },
    {  "value":       3151, "name": "MQCACF_TOPIC_NAMES" },
    {  "value":       3151, "name": "MQRCCF_WRONG_USER" },
    {  "value":       3152, "name": "MQCACF_SUB_NAME" },
    {  "value":       3152, "name": "MQRCCF_DUPLICATE_SUBSCRIPTION" },
    {  "value":       3153, "name": "MQCACF_DESTINATION_Q_MGR" },
    {  "value":       3153, "name": "MQRCCF_SUB_NAME_ERROR" },
    {  "value":       3154, "name": "MQCACF_DESTINATION" },
    {  "value":       3154, "name": "MQRCCF_SUB_IDENTITY_ERROR" },
    {  "value":       3155, "name": "MQRCCF_SUBSCRIPTION_IN_USE" },
    {  "value":       3156, "name": "MQCACF_SUB_USER_ID" },
    {  "value":       3156, "name": "MQRCCF_SUBSCRIPTION_LOCKED" },
    {  "value":       3157, "name": "MQRCCF_ALREADY_JOINED" },
    {  "value":       3159, "name": "MQCACF_SUB_USER_DATA" },
    {  "value":       3160, "name": "MQCACF_SUB_SELECTOR" },
    {  "value":       3160, "name": "MQRCCF_OBJECT_IN_USE" },
    {  "value":       3161, "name": "MQCACF_LAST_PUB_DATE" },
    {  "value":       3161, "name": "MQRCCF_UNKNOWN_FILE_NAME" },
    {  "value":       3162, "name": "MQCACF_LAST_PUB_TIME" },
    {  "value":       3162, "name": "MQRCCF_FILE_NOT_AVAILABLE" },
    {  "value":       3163, "name": "MQCACF_FROM_SUB_NAME" },
    {  "value":       3163, "name": "MQRCCF_DISC_RETRY_ERROR" },
    {  "value":       3164, "name": "MQCACF_TO_SUB_NAME" },
    {  "value":       3164, "name": "MQRCCF_ALLOC_RETRY_ERROR" },
    {  "value":       3165, "name": "MQRCCF_ALLOC_SLOW_TIMER_ERROR" },
    {  "value":       3166, "name": "MQRCCF_ALLOC_FAST_TIMER_ERROR" },
    {  "value":       3167, "name": "MQCACF_LAST_MSG_TIME" },
    {  "value":       3167, "name": "MQRCCF_PORT_NUMBER_ERROR" },
    {  "value":       3168, "name": "MQCACF_LAST_MSG_DATE" },
    {  "value":       3168, "name": "MQRCCF_CHL_SYSTEM_NOT_ACTIVE" },
    {  "value":       3169, "name": "MQCACF_SUBSCRIPTION_POINT" },
    {  "value":       3169, "name": "MQRCCF_ENTITY_NAME_MISSING" },
    {  "value":       3170, "name": "MQCACF_FILTER" },
    {  "value":       3170, "name": "MQRCCF_PROFILE_NAME_ERROR" },
    {  "value":       3171, "name": "MQCACF_NONE" },
    {  "value":       3171, "name": "MQRCCF_AUTH_VALUE_ERROR" },
    {  "value":       3172, "name": "MQCACF_ADMIN_TOPIC_NAMES" },
    {  "value":       3172, "name": "MQRCCF_AUTH_VALUE_MISSING" },
    {  "value":       3173, "name": "MQCACF_ROUTING_FINGER_PRINT" },
    {  "value":       3173, "name": "MQRCCF_OBJECT_TYPE_MISSING" },
    {  "value":       3174, "name": "MQCACF_APPL_DESC" },
    {  "value":       3174, "name": "MQRCCF_CONNECTION_ID_ERROR" },
    {  "value":       3175, "name": "MQCACF_Q_MGR_START_DATE" },
    {  "value":       3175, "name": "MQRCCF_LOG_TYPE_ERROR" },
    {  "value":       3176, "name": "MQCACF_Q_MGR_START_TIME" },
    {  "value":       3176, "name": "MQRCCF_PROGRAM_NOT_AVAILABLE" },
    {  "value":       3177, "name": "MQCACF_FROM_COMM_INFO_NAME" },
    {  "value":       3177, "name": "MQRCCF_PROGRAM_AUTH_FAILED" },
    {  "value":       3178, "name": "MQCACF_TO_COMM_INFO_NAME" },
    {  "value":       3179, "name": "MQCACF_CF_OFFLOAD_SIZE1" },
    {  "value":       3180, "name": "MQCACF_CF_OFFLOAD_SIZE2" },
    {  "value":       3181, "name": "MQCACF_CF_OFFLOAD_SIZE3" },
    {  "value":       3182, "name": "MQCACF_CF_SMDS_GENERIC_NAME" },
    {  "value":       3183, "name": "MQCACF_CF_SMDS" },
    {  "value":       3184, "name": "MQCACF_RECOVERY_DATE" },
    {  "value":       3185, "name": "MQCACF_RECOVERY_TIME" },
    {  "value":       3186, "name": "MQCACF_CF_SMDSCONN" },
    {  "value":       3187, "name": "MQCACF_CF_STRUC_NAME" },
    {  "value":       3188, "name": "MQCACF_ALTERNATE_USERID" },
    {  "value":       3189, "name": "MQCACF_CHAR_ATTRS" },
    {  "value":       3190, "name": "MQCACF_DYNAMIC_Q_NAME" },
    {  "value":       3191, "name": "MQCACF_HOST_NAME" },
    {  "value":       3192, "name": "MQCACF_MQCB_NAME" },
    {  "value":       3193, "name": "MQCACF_OBJECT_STRING" },
    {  "value":       3194, "name": "MQCACF_RESOLVED_LOCAL_Q_MGR" },
    {  "value":       3195, "name": "MQCACF_RESOLVED_LOCAL_Q_NAME" },
    {  "value":       3196, "name": "MQCACF_RESOLVED_OBJECT_STRING" },
    {  "value":       3197, "name": "MQCACF_RESOLVED_Q_MGR" },
    {  "value":       3198, "name": "MQCACF_SELECTION_STRING" },
    {  "value":       3199, "name": "MQCACF_XA_INFO" },
    {  "value":       3200, "name": "MQCACF_APPL_FUNCTION" },
    {  "value":       3200, "name": "MQRCCF_NONE_FOUND" },
    {  "value":       3201, "name": "MQCACF_XQH_REMOTE_Q_NAME" },
    {  "value":       3201, "name": "MQRCCF_SECURITY_SWITCH_OFF" },
    {  "value":       3202, "name": "MQCACF_XQH_REMOTE_Q_MGR" },
    {  "value":       3202, "name": "MQRCCF_SECURITY_REFRESH_FAILED" },
    {  "value":       3203, "name": "MQCACF_XQH_PUT_TIME" },
    {  "value":       3203, "name": "MQRCCF_PARM_CONFLICT" },
    {  "value":       3204, "name": "MQCACF_XQH_PUT_DATE" },
    {  "value":       3204, "name": "MQRCCF_COMMAND_INHIBITED" },
    {  "value":       3205, "name": "MQCACF_EXCL_OPERATOR_MESSAGES" },
    {  "value":       3205, "name": "MQRCCF_OBJECT_BEING_DELETED" },
    {  "value":       3206, "name": "MQCACF_CSP_USER_IDENTIFIER" },
    {  "value":       3207, "name": "MQCACF_AMQP_CLIENT_ID" },
    {  "value":       3207, "name": "MQRCCF_STORAGE_CLASS_IN_USE" },
    {  "value":       3208, "name": "MQCACF_ARCHIVE_LOG_EXTENT_NAME" },
    {  "value":       3208, "name": "MQRCCF_OBJECT_NAME_RESTRICTED" },
    {  "value":       3209, "name": "MQCACF_APPL_IMMOVABLE_DATE" },
    {  "value":       3209, "name": "MQRCCF_OBJECT_LIMIT_EXCEEDED" },
    {  "value":       3210, "name": "MQCACF_APPL_IMMOVABLE_TIME" },
    {  "value":       3210, "name": "MQRCCF_OBJECT_OPEN_FORCE" },
    {  "value":       3211, "name": "MQCACF_NHA_INSTANCE_NAME" },
    {  "value":       3211, "name": "MQRCCF_DISPOSITION_CONFLICT" },
    {  "value":       3212, "name": "MQCACF_Q_MGR_DATA_PATH" },
    {  "value":       3212, "name": "MQRCCF_Q_MGR_NOT_IN_QSG" },
    {  "value":       3213, "name": "MQCACF_UNIFORM_CLUSTER_NAME" },
    {  "value":       3213, "name": "MQRCCF_ATTR_VALUE_FIXED" },
    {  "value":       3214, "name": "MQCACF_LOG_START_DATE" },
    {  "value":       3215, "name": "MQCACF_LOG_START_LSN" },
    {  "value":       3215, "name": "MQRCCF_NAMELIST_ERROR" },
    {  "value":       3216, "name": "MQCACF_LOG_START_TIME" },
    {  "value":       3217, "name": "MQCACF_NHA_GROUP_INITIAL_DATE" },
    {  "value":       3217, "name": "MQRCCF_NO_CHANNEL_INITIATOR" },
    {  "value":       3218, "name": "MQCACF_NHA_GROUP_INITIAL_LSN" },
    {  "value":       3218, "name": "MQRCCF_CHANNEL_INITIATOR_ERROR" },
    {  "value":       3219, "name": "MQCACF_NHA_GROUP_INITIAL_TIME" },
    {  "value":       3220, "name": "MQCACF_NHA_REPL_ADDRESS" },
    {  "value":       3221, "name": "MQCACF_DISK_WRITTEN_LSN" },
    {  "value":       3222, "name": "MQCACF_NHA_ACKNOWLEDGED_LSN" },
    {  "value":       3222, "name": "MQRCCF_COMMAND_LEVEL_CONFLICT" },
    {  "value":       3223, "name": "MQCACF_NHA_GROUP_ADDRESS" },
    {  "value":       3223, "name": "MQRCCF_Q_ATTR_CONFLICT" },
    {  "value":       3224, "name": "MQCACF_NHA_GROUP_SYNC_ISOTIME" },
    {  "value":       3224, "name": "MQRCCF_EVENTS_DISABLED" },
    {  "value":       3225, "name": "MQCACF_NHA_GROUP_INIT_ISOTIME" },
    {  "value":       3225, "name": "MQRCCF_COMMAND_SCOPE_ERROR" },
    {  "value":       3226, "name": "MQCACF_NHA_GROUP_LIVE_ISOTIME" },
    {  "value":       3226, "name": "MQRCCF_COMMAND_REPLY_ERROR" },
    {  "value":       3227, "name": "MQCACF_NHA_GROUP_LSN" },
    {  "value":       3227, "name": "MQRCCF_FUNCTION_RESTRICTED" },
    {  "value":       3228, "name": "MQCACF_NHA_GROUP_NAME" },
    {  "value":       3228, "name": "MQRCCF_PARM_MISSING" },
    {  "value":       3229, "name": "MQCACF_NHA_GROUP_RECOV_LSN" },
    {  "value":       3229, "name": "MQRCCF_PARM_VALUE_ERROR" },
    {  "value":       3230, "name": "MQCACF_NHA_GROUP_RECOV_ISOTIME" },
    {  "value":       3230, "name": "MQRCCF_COMMAND_LENGTH_ERROR" },
    {  "value":       3231, "name": "MQCACF_NHA_SYNC_ISOTIME" },
    {  "value":       3231, "name": "MQRCCF_COMMAND_ORIGIN_ERROR" },
    {  "value":       3232, "name": "MQCACF_EVENT_DUPLICATE_FROM" },
    {  "value":       3232, "name": "MQCACF_LAST_USED" },
    {  "value":       3232, "name": "MQRCCF_LISTENER_CONFLICT" },
    {  "value":       3233, "name": "MQRCCF_LISTENER_STARTED" },
    {  "value":       3234, "name": "MQRCCF_LISTENER_STOPPED" },
    {  "value":       3235, "name": "MQRCCF_CHANNEL_ERROR" },
    {  "value":       3236, "name": "MQRCCF_CF_STRUC_ERROR" },
    {  "value":       3237, "name": "MQRCCF_UNKNOWN_USER_ID" },
    {  "value":       3238, "name": "MQRCCF_UNEXPECTED_ERROR" },
    {  "value":       3239, "name": "MQRCCF_NO_XCF_PARTNER" },
    {  "value":       3240, "name": "MQRCCF_CFGR_PARM_ID_ERROR" },
    {  "value":       3241, "name": "MQRCCF_CFIF_LENGTH_ERROR" },
    {  "value":       3242, "name": "MQRCCF_CFIF_OPERATOR_ERROR" },
    {  "value":       3243, "name": "MQRCCF_CFIF_PARM_ID_ERROR" },
    {  "value":       3244, "name": "MQRCCF_CFSF_FILTER_VAL_LEN_ERR" },
    {  "value":       3245, "name": "MQRCCF_CFSF_LENGTH_ERROR" },
    {  "value":       3246, "name": "MQRCCF_CFSF_OPERATOR_ERROR" },
    {  "value":       3247, "name": "MQRCCF_CFSF_PARM_ID_ERROR" },
    {  "value":       3248, "name": "MQRCCF_TOO_MANY_FILTERS" },
    {  "value":       3249, "name": "MQRCCF_LISTENER_RUNNING" },
    {  "value":       3250, "name": "MQRCCF_LSTR_STATUS_NOT_FOUND" },
    {  "value":       3251, "name": "MQRCCF_SERVICE_RUNNING" },
    {  "value":       3252, "name": "MQRCCF_SERV_STATUS_NOT_FOUND" },
    {  "value":       3253, "name": "MQRCCF_SERVICE_STOPPED" },
    {  "value":       3254, "name": "MQRCCF_CFBS_DUPLICATE_PARM" },
    {  "value":       3255, "name": "MQRCCF_CFBS_LENGTH_ERROR" },
    {  "value":       3256, "name": "MQRCCF_CFBS_PARM_ID_ERROR" },
    {  "value":       3257, "name": "MQRCCF_CFBS_STRING_LENGTH_ERR" },
    {  "value":       3258, "name": "MQRCCF_CFGR_LENGTH_ERROR" },
    {  "value":       3259, "name": "MQRCCF_CFGR_PARM_COUNT_ERROR" },
    {  "value":       3260, "name": "MQRCCF_CONN_NOT_STOPPED" },
    {  "value":       3261, "name": "MQRCCF_SERVICE_REQUEST_PENDING" },
    {  "value":       3262, "name": "MQRCCF_NO_START_CMD" },
    {  "value":       3263, "name": "MQRCCF_NO_STOP_CMD" },
    {  "value":       3264, "name": "MQRCCF_CFBF_LENGTH_ERROR" },
    {  "value":       3265, "name": "MQRCCF_CFBF_PARM_ID_ERROR" },
    {  "value":       3266, "name": "MQRCCF_CFBF_OPERATOR_ERROR" },
    {  "value":       3267, "name": "MQRCCF_CFBF_FILTER_VAL_LEN_ERR" },
    {  "value":       3268, "name": "MQRCCF_LISTENER_STILL_ACTIVE" },
    {  "value":       3269, "name": "MQRCCF_DEF_XMIT_Q_CLUS_ERROR" },
    {  "value":       3300, "name": "MQRCCF_TOPICSTR_ALREADY_EXISTS" },
    {  "value":       3301, "name": "MQRCCF_SHARING_CONVS_ERROR" },
    {  "value":       3302, "name": "MQRCCF_SHARING_CONVS_TYPE" },
    {  "value":       3303, "name": "MQRCCF_SECURITY_CASE_CONFLICT" },
    {  "value":       3305, "name": "MQRCCF_TOPIC_TYPE_ERROR" },
    {  "value":       3306, "name": "MQRCCF_MAX_INSTANCES_ERROR" },
    {  "value":       3307, "name": "MQRCCF_MAX_INSTS_PER_CLNT_ERR" },
    {  "value":       3308, "name": "MQRCCF_TOPIC_STRING_NOT_FOUND" },
    {  "value":       3309, "name": "MQRCCF_SUBSCRIPTION_POINT_ERR" },
    {  "value":       3311, "name": "MQRCCF_SUB_ALREADY_EXISTS" },
    {  "value":       3312, "name": "MQRCCF_UNKNOWN_OBJECT_NAME" },
    {  "value":       3313, "name": "MQRCCF_REMOTE_Q_NAME_ERROR" },
    {  "value":       3314, "name": "MQRCCF_DURABILITY_NOT_ALLOWED" },
    {  "value":       3315, "name": "MQRCCF_HOBJ_ERROR" },
    {  "value":       3316, "name": "MQRCCF_DEST_NAME_ERROR" },
    {  "value":       3317, "name": "MQRCCF_INVALID_DESTINATION" },
    {  "value":       3318, "name": "MQRCCF_PUBSUB_INHIBITED" },
    {  "value":       3319, "name": "MQRCCF_GROUPUR_CHECKS_FAILED" },
    {  "value":       3320, "name": "MQRCCF_COMM_INFO_TYPE_ERROR" },
    {  "value":       3321, "name": "MQRCCF_USE_CLIENT_ID_ERROR" },
    {  "value":       3322, "name": "MQRCCF_CLIENT_ID_NOT_FOUND" },
    {  "value":       3323, "name": "MQRCCF_CLIENT_ID_ERROR" },
    {  "value":       3324, "name": "MQRCCF_PORT_IN_USE" },
    {  "value":       3325, "name": "MQRCCF_SSL_ALT_PROVIDER_REQD" },
    {  "value":       3326, "name": "MQRCCF_CHLAUTH_TYPE_ERROR" },
    {  "value":       3327, "name": "MQRCCF_CHLAUTH_ACTION_ERROR" },
    {  "value":       3328, "name": "MQRCCF_POLICY_NOT_FOUND" },
    {  "value":       3329, "name": "MQRCCF_ENCRYPTION_ALG_ERROR" },
    {  "value":       3330, "name": "MQRCCF_SIGNATURE_ALG_ERROR" },
    {  "value":       3331, "name": "MQRCCF_TOLERATION_POL_ERROR" },
    {  "value":       3332, "name": "MQRCCF_POLICY_VERSION_ERROR" },
    {  "value":       3333, "name": "MQRCCF_RECIPIENT_DN_MISSING" },
    {  "value":       3334, "name": "MQRCCF_POLICY_NAME_MISSING" },
    {  "value":       3335, "name": "MQRCCF_CHLAUTH_USERSRC_ERROR" },
    {  "value":       3336, "name": "MQRCCF_WRONG_CHLAUTH_TYPE" },
    {  "value":       3337, "name": "MQRCCF_CHLAUTH_ALREADY_EXISTS" },
    {  "value":       3338, "name": "MQRCCF_CHLAUTH_NOT_FOUND" },
    {  "value":       3339, "name": "MQRCCF_WRONG_CHLAUTH_ACTION" },
    {  "value":       3340, "name": "MQRCCF_WRONG_CHLAUTH_USERSRC" },
    {  "value":       3341, "name": "MQRCCF_CHLAUTH_WARN_ERROR" },
    {  "value":       3342, "name": "MQRCCF_WRONG_CHLAUTH_MATCH" },
    {  "value":       3343, "name": "MQRCCF_IPADDR_RANGE_CONFLICT" },
    {  "value":       3344, "name": "MQRCCF_CHLAUTH_MAX_EXCEEDED" },
    {  "value":       3345, "name": "MQRCCF_ADDRESS_ERROR" },
    {  "value":       3345, "name": "MQRCCF_IPADDR_ERROR" },
    {  "value":       3346, "name": "MQRCCF_IPADDR_RANGE_ERROR" },
    {  "value":       3347, "name": "MQRCCF_PROFILE_NAME_MISSING" },
    {  "value":       3348, "name": "MQRCCF_CHLAUTH_CLNTUSER_ERROR" },
    {  "value":       3349, "name": "MQRCCF_CHLAUTH_NAME_ERROR" },
    {  "value":       3350, "name": "MQRCCF_CHLAUTH_RUNCHECK_ERROR" },
    {  "value":       3351, "name": "MQRCCF_CF_STRUC_ALREADY_FAILED" },
    {  "value":       3352, "name": "MQRCCF_CFCONLOS_CHECKS_FAILED" },
    {  "value":       3353, "name": "MQRCCF_SUITE_B_ERROR" },
    {  "value":       3354, "name": "MQRCCF_CHANNEL_NOT_STARTED" },
    {  "value":       3355, "name": "MQRCCF_CUSTOM_ERROR" },
    {  "value":       3356, "name": "MQRCCF_BACKLOG_OUT_OF_RANGE" },
    {  "value":       3357, "name": "MQRCCF_CHLAUTH_DISABLED" },
    {  "value":       3358, "name": "MQRCCF_SMDS_REQUIRES_DSGROUP" },
    {  "value":       3359, "name": "MQRCCF_PSCLUS_DISABLED_TOPDEF" },
    {  "value":       3360, "name": "MQRCCF_PSCLUS_TOPIC_EXISTS" },
    {  "value":       3361, "name": "MQRCCF_SSL_CIPHER_SUITE_ERROR" },
    {  "value":       3362, "name": "MQRCCF_SOCKET_ERROR" },
    {  "value":       3363, "name": "MQRCCF_CLUS_XMIT_Q_USAGE_ERROR" },
    {  "value":       3364, "name": "MQRCCF_CERT_VAL_POLICY_ERROR" },
    {  "value":       3365, "name": "MQRCCF_INVALID_PROTOCOL" },
    {  "value":       3366, "name": "MQRCCF_REVDNS_DISABLED" },
    {  "value":       3367, "name": "MQRCCF_CLROUTE_NOT_ALTERABLE" },
    {  "value":       3368, "name": "MQRCCF_CLUSTER_TOPIC_CONFLICT" },
    {  "value":       3369, "name": "MQRCCF_DEFCLXQ_MODEL_Q_ERROR" },
    {  "value":       3370, "name": "MQRCCF_CHLAUTH_CHKCLI_ERROR" },
    {  "value":       3371, "name": "MQRCCF_CERT_LABEL_NOT_ALLOWED" },
    {  "value":       3372, "name": "MQRCCF_Q_MGR_ATTR_CONFLICT" },
    {  "value":       3373, "name": "MQRCCF_ENTITY_TYPE_MISSING" },
    {  "value":       3374, "name": "MQRCCF_CLWL_EXIT_NAME_ERROR" },
    {  "value":       3375, "name": "MQRCCF_SERVICE_NAME_ERROR" },
    {  "value":       3376, "name": "MQRCCF_REMOTE_CHL_TYPE_ERROR" },
    {  "value":       3377, "name": "MQRCCF_TOPIC_RESTRICTED" },
    {  "value":       3378, "name": "MQRCCF_CURRENT_LOG_EXTENT" },
    {  "value":       3379, "name": "MQRCCF_LOG_EXTENT_NOT_FOUND" },
    {  "value":       3380, "name": "MQRCCF_LOG_NOT_REDUCED" },
    {  "value":       3381, "name": "MQRCCF_LOG_EXTENT_ERROR" },
    {  "value":       3382, "name": "MQRCCF_ACCESS_BLOCKED" },
    {  "value":       3383, "name": "MQRCCF_PS_REQUIRED_MQUC" },
    {  "value":       3384, "name": "MQRCCF_STREAMQ_DEST_NOT_SUPP" },
    {  "value":       3385, "name": "MQRCCF_STREAMQ_DEST_CONFLICT" },
    {  "value":       3386, "name": "MQRCCF_STREAMQ_NOT_SUPPORTED" },
    {  "value":       3387, "name": "MQRCCF_STREAMQ_CONFLICT" },
    {  "value":       3389, "name": "MQRCCF_INCOMPATIBLE_QM_IN_QSG" },
    {  "value":       3390, "name": "MQRCCF_ATTR_VALUE_ERROR_QSG_QM" },
    {  "value":       3391, "name": "MQRCCF_AUTHORIZED" },
    {  "value":       3501, "name": "MQCACH_CHANNEL_NAME" },
    {  "value":       3501, "name": "MQCACH_FIRST" },
    {  "value":       3502, "name": "MQCACH_DESC" },
    {  "value":       3503, "name": "MQCACH_MODE_NAME" },
    {  "value":       3504, "name": "MQCACH_TP_NAME" },
    {  "value":       3505, "name": "MQCACH_XMIT_Q_NAME" },
    {  "value":       3506, "name": "MQCACH_CONNECTION_NAME" },
    {  "value":       3507, "name": "MQCACH_MCA_NAME" },
    {  "value":       3508, "name": "MQCACH_SEC_EXIT_NAME" },
    {  "value":       3509, "name": "MQCACH_MSG_EXIT_NAME" },
    {  "value":       3510, "name": "MQCACH_SEND_EXIT_NAME" },
    {  "value":       3511, "name": "MQCACH_RCV_EXIT_NAME" },
    {  "value":       3512, "name": "MQCACH_CHANNEL_NAMES" },
    {  "value":       3513, "name": "MQCACH_SEC_EXIT_USER_DATA" },
    {  "value":       3514, "name": "MQCACH_MSG_EXIT_USER_DATA" },
    {  "value":       3515, "name": "MQCACH_SEND_EXIT_USER_DATA" },
    {  "value":       3516, "name": "MQCACH_RCV_EXIT_USER_DATA" },
    {  "value":       3517, "name": "MQCACH_USER_ID" },
    {  "value":       3518, "name": "MQCACH_PASSWORD" },
    {  "value":       3520, "name": "MQCACH_LOCAL_ADDRESS" },
    {  "value":       3521, "name": "MQCACH_LOCAL_NAME" },
    {  "value":       3524, "name": "MQCACH_LAST_MSG_TIME" },
    {  "value":       3525, "name": "MQCACH_LAST_MSG_DATE" },
    {  "value":       3527, "name": "MQCACH_MCA_USER_ID" },
    {  "value":       3528, "name": "MQCACH_CHANNEL_START_TIME" },
    {  "value":       3529, "name": "MQCACH_CHANNEL_START_DATE" },
    {  "value":       3530, "name": "MQCACH_MCA_JOB_NAME" },
    {  "value":       3531, "name": "MQCACH_LAST_LUWID" },
    {  "value":       3532, "name": "MQCACH_CURRENT_LUWID" },
    {  "value":       3533, "name": "MQCACH_FORMAT_NAME" },
    {  "value":       3534, "name": "MQCACH_MR_EXIT_NAME" },
    {  "value":       3535, "name": "MQCACH_MR_EXIT_USER_DATA" },
    {  "value":       3544, "name": "MQCACH_SSL_CIPHER_SPEC" },
    {  "value":       3545, "name": "MQCACH_SSL_PEER_NAME" },
    {  "value":       3546, "name": "MQCACH_SSL_HANDSHAKE_STAGE" },
    {  "value":       3547, "name": "MQCACH_SSL_SHORT_PEER_NAME" },
    {  "value":       3548, "name": "MQCACH_REMOTE_APPL_TAG" },
    {  "value":       3549, "name": "MQCACH_SSL_CERT_USER_ID" },
    {  "value":       3550, "name": "MQCACH_SSL_CERT_ISSUER_NAME" },
    {  "value":       3551, "name": "MQCACH_LU_NAME" },
    {  "value":       3552, "name": "MQCACH_IP_ADDRESS" },
    {  "value":       3553, "name": "MQCACH_TCP_NAME" },
    {  "value":       3554, "name": "MQCACH_LISTENER_NAME" },
    {  "value":       3555, "name": "MQCACH_LISTENER_DESC" },
    {  "value":       3556, "name": "MQCACH_LISTENER_START_DATE" },
    {  "value":       3557, "name": "MQCACH_LISTENER_START_TIME" },
    {  "value":       3558, "name": "MQCACH_SSL_KEY_RESET_DATE" },
    {  "value":       3559, "name": "MQCACH_SSL_KEY_RESET_TIME" },
    {  "value":       3560, "name": "MQCACH_REMOTE_VERSION" },
    {  "value":       3561, "name": "MQCACH_REMOTE_PRODUCT" },
    {  "value":       3562, "name": "MQCACH_GROUP_ADDRESS" },
    {  "value":       3563, "name": "MQCACH_JAAS_CONFIG" },
    {  "value":       3564, "name": "MQCACH_CLIENT_ID" },
    {  "value":       3565, "name": "MQCACH_SSL_KEY_PASSPHRASE" },
    {  "value":       3566, "name": "MQCACH_CONNECTION_NAME_LIST" },
    {  "value":       3567, "name": "MQCACH_CLIENT_USER_ID" },
    {  "value":       3568, "name": "MQCACH_MCA_USER_ID_LIST" },
    {  "value":       3569, "name": "MQCACH_SSL_CIPHER_SUITE" },
    {  "value":       3570, "name": "MQCACH_WEBCONTENT_PATH" },
    {  "value":       3571, "name": "MQCACH_TOPIC_ROOT" },
    {  "value":       3572, "name": "MQCACH_TEMPORARY_MODEL_Q" },
    {  "value":       3573, "name": "MQCACH_LAST_USED" },
    {  "value":       3573, "name": "MQCACH_TEMPORARY_Q_PREFIX" },
    {  "value":       3840, "name": "MQDCC_TARGET_ENC_MASK" },
    {  "value":       3840, "name": "MQENC_FLOAT_MASK" },
    {  "value":       4000, "name": "MQCA_LAST" },
    {  "value":       4000, "name": "MQCA_USER_LIST" },
    {  "value":       4000, "name": "MQ_MSG_HEADER_LENGTH" },
    {  "value":       4001, "name": "MQHA_BAG_HANDLE" },
    {  "value":       4001, "name": "MQHA_FIRST" },
    {  "value":       4001, "name": "MQHA_LAST_USED" },
    {  "value":       4001, "name": "MQRCCF_OBJECT_ALREADY_EXISTS" },
    {  "value":       4002, "name": "MQRCCF_OBJECT_WRONG_TYPE" },
    {  "value":       4003, "name": "MQRCCF_LIKE_OBJECT_WRONG_TYPE" },
    {  "value":       4004, "name": "MQRCCF_OBJECT_OPEN" },
    {  "value":       4005, "name": "MQRCCF_ATTR_VALUE_ERROR" },
    {  "value":       4006, "name": "MQRCCF_UNKNOWN_Q_MGR" },
    {  "value":       4007, "name": "MQRCCF_Q_WRONG_TYPE" },
    {  "value":       4008, "name": "MQRCCF_OBJECT_NAME_ERROR" },
    {  "value":       4009, "name": "MQRCCF_ALLOCATE_FAILED" },
    {  "value":       4010, "name": "MQRCCF_HOST_NOT_AVAILABLE" },
    {  "value":       4011, "name": "MQRCCF_CONFIGURATION_ERROR" },
    {  "value":       4012, "name": "MQRCCF_CONNECTION_REFUSED" },
    {  "value":       4013, "name": "MQRCCF_ENTRY_ERROR" },
    {  "value":       4014, "name": "MQRCCF_SEND_FAILED" },
    {  "value":       4015, "name": "MQRCCF_RECEIVED_DATA_ERROR" },
    {  "value":       4016, "name": "MQRCCF_RECEIVE_FAILED" },
    {  "value":       4017, "name": "MQRCCF_CONNECTION_CLOSED" },
    {  "value":       4018, "name": "MQRCCF_NO_STORAGE" },
    {  "value":       4019, "name": "MQRCCF_NO_COMMS_MANAGER" },
    {  "value":       4020, "name": "MQRCCF_LISTENER_NOT_STARTED" },
    {  "value":       4024, "name": "MQRCCF_BIND_FAILED" },
    {  "value":       4025, "name": "MQRCCF_CHANNEL_INDOUBT" },
    {  "value":       4026, "name": "MQRCCF_MQCONN_FAILED" },
    {  "value":       4027, "name": "MQRCCF_MQOPEN_FAILED" },
    {  "value":       4028, "name": "MQRCCF_MQGET_FAILED" },
    {  "value":       4029, "name": "MQRCCF_MQPUT_FAILED" },
    {  "value":       4030, "name": "MQRCCF_PING_ERROR" },
    {  "value":       4031, "name": "MQRCCF_CHANNEL_IN_USE" },
    {  "value":       4032, "name": "MQRCCF_CHANNEL_NOT_FOUND" },
    {  "value":       4033, "name": "MQRCCF_UNKNOWN_REMOTE_CHANNEL" },
    {  "value":       4034, "name": "MQRCCF_REMOTE_QM_UNAVAILABLE" },
    {  "value":       4035, "name": "MQRCCF_REMOTE_QM_TERMINATING" },
    {  "value":       4036, "name": "MQRCCF_MQINQ_FAILED" },
    {  "value":       4037, "name": "MQRCCF_NOT_XMIT_Q" },
    {  "value":       4038, "name": "MQRCCF_CHANNEL_DISABLED" },
    {  "value":       4039, "name": "MQRCCF_USER_EXIT_NOT_AVAILABLE" },
    {  "value":       4040, "name": "MQRCCF_COMMIT_FAILED" },
    {  "value":       4041, "name": "MQRCCF_WRONG_CHANNEL_TYPE" },
    {  "value":       4042, "name": "MQRCCF_CHANNEL_ALREADY_EXISTS" },
    {  "value":       4043, "name": "MQRCCF_DATA_TOO_LARGE" },
    {  "value":       4044, "name": "MQRCCF_CHANNEL_NAME_ERROR" },
    {  "value":       4045, "name": "MQRCCF_XMIT_Q_NAME_ERROR" },
    {  "value":       4047, "name": "MQRCCF_MCA_NAME_ERROR" },
    {  "value":       4048, "name": "MQRCCF_SEND_EXIT_NAME_ERROR" },
    {  "value":       4049, "name": "MQRCCF_SEC_EXIT_NAME_ERROR" },
    {  "value":       4050, "name": "MQRCCF_MSG_EXIT_NAME_ERROR" },
    {  "value":       4051, "name": "MQRCCF_RCV_EXIT_NAME_ERROR" },
    {  "value":       4052, "name": "MQRCCF_XMIT_Q_NAME_WRONG_TYPE" },
    {  "value":       4053, "name": "MQRCCF_MCA_NAME_WRONG_TYPE" },
    {  "value":       4054, "name": "MQRCCF_DISC_INT_WRONG_TYPE" },
    {  "value":       4055, "name": "MQRCCF_SHORT_RETRY_WRONG_TYPE" },
    {  "value":       4056, "name": "MQRCCF_SHORT_TIMER_WRONG_TYPE" },
    {  "value":       4057, "name": "MQRCCF_LONG_RETRY_WRONG_TYPE" },
    {  "value":       4058, "name": "MQRCCF_LONG_TIMER_WRONG_TYPE" },
    {  "value":       4059, "name": "MQRCCF_PUT_AUTH_WRONG_TYPE" },
    {  "value":       4060, "name": "MQRCCF_KEEP_ALIVE_INT_ERROR" },
    {  "value":       4061, "name": "MQRCCF_MISSING_CONN_NAME" },
    {  "value":       4062, "name": "MQRCCF_CONN_NAME_ERROR" },
    {  "value":       4063, "name": "MQRCCF_MQSET_FAILED" },
    {  "value":       4064, "name": "MQRCCF_CHANNEL_NOT_ACTIVE" },
    {  "value":       4065, "name": "MQRCCF_TERMINATED_BY_SEC_EXIT" },
    {  "value":       4067, "name": "MQRCCF_DYNAMIC_Q_SCOPE_ERROR" },
    {  "value":       4068, "name": "MQRCCF_CELL_DIR_NOT_AVAILABLE" },
    {  "value":       4069, "name": "MQRCCF_MR_COUNT_ERROR" },
    {  "value":       4070, "name": "MQRCCF_MR_COUNT_WRONG_TYPE" },
    {  "value":       4071, "name": "MQRCCF_MR_EXIT_NAME_ERROR" },
    {  "value":       4072, "name": "MQRCCF_MR_EXIT_NAME_WRONG_TYPE" },
    {  "value":       4073, "name": "MQRCCF_MR_INTERVAL_ERROR" },
    {  "value":       4074, "name": "MQRCCF_MR_INTERVAL_WRONG_TYPE" },
    {  "value":       4075, "name": "MQRCCF_NPM_SPEED_ERROR" },
    {  "value":       4076, "name": "MQRCCF_NPM_SPEED_WRONG_TYPE" },
    {  "value":       4077, "name": "MQRCCF_HB_INTERVAL_ERROR" },
    {  "value":       4078, "name": "MQRCCF_HB_INTERVAL_WRONG_TYPE" },
    {  "value":       4079, "name": "MQRCCF_CHAD_ERROR" },
    {  "value":       4080, "name": "MQRCCF_CHAD_WRONG_TYPE" },
    {  "value":       4081, "name": "MQRCCF_CHAD_EVENT_ERROR" },
    {  "value":       4082, "name": "MQRCCF_CHAD_EVENT_WRONG_TYPE" },
    {  "value":       4083, "name": "MQRCCF_CHAD_EXIT_ERROR" },
    {  "value":       4084, "name": "MQRCCF_CHAD_EXIT_WRONG_TYPE" },
    {  "value":       4085, "name": "MQRCCF_SUPPRESSED_BY_EXIT" },
    {  "value":       4086, "name": "MQRCCF_BATCH_INT_ERROR" },
    {  "value":       4087, "name": "MQRCCF_BATCH_INT_WRONG_TYPE" },
    {  "value":       4088, "name": "MQRCCF_NET_PRIORITY_ERROR" },
    {  "value":       4089, "name": "MQRCCF_NET_PRIORITY_WRONG_TYPE" },
    {  "value":       4090, "name": "MQRCCF_CHANNEL_CLOSED" },
    {  "value":       4091, "name": "MQRCCF_Q_STATUS_NOT_FOUND" },
    {  "value":       4092, "name": "MQRCCF_SSL_CIPHER_SPEC_ERROR" },
    {  "value":       4093, "name": "MQRCCF_SSL_PEER_NAME_ERROR" },
    {  "value":       4094, "name": "MQRCCF_SSL_CLIENT_AUTH_ERROR" },
    {  "value":       4095, "name": "MQMF_REJECT_UNSUP_MASK" },
    {  "value":       4095, "name": "MQRCCF_RETAINED_NOT_SUPPORTED" },
    {  "value":       4095, "name": "MQ_MAX_PROPERTY_NAME_LENGTH" },
    {  "value":       4096, "name": "MQCNO_ACCOUNTING_MQI_ENABLED" },
    {  "value":       4096, "name": "MQGMO_SYNCPOINT_IF_PERSISTENT" },
    {  "value":       4096, "name": "MQOO_ALTERNATE_USER_AUTHORITY" },
    {  "value":       4096, "name": "MQPMO_ALTERNATE_USER_AUTHORITY" },
    {  "value":       4096, "name": "MQRCCF_KWD_VALUE_WRONG_TYPE" },
    {  "value":       4096, "name": "MQREGO_PERSISTENT_AS_PUBLISH" },
    {  "value":       4096, "name": "MQROUTE_DELIVER_YES" },
    {  "value":       4096, "name": "MQSO_NEW_PUBLICATIONS_ONLY" },
    {  "value":       4096, "name": "MQZAO_SUBSCRIBE" },
    {  "value":       4097, "name": "MQRCCF_APPL_STATUS_NOT_FOUND" },
    {  "value":       4098, "name": "MQRCCF_NHA_NOT_AVAILABLE" },
    {  "value":       4099, "name": "MQRCCF_Q_MGR_STATUS_NOT_FOUND" },
    {  "value":       4352, "name": "MQCTES_BACKOUT" },
    {  "value":       4352, "name": "MQCUOWC_BACKOUT" },
    {  "value":       6000, "name": "MQHA_LAST" },
    {  "value":       6001, "name": "MQBA_FIRST" },
    {  "value":       6100, "name": "MQRC_REOPEN_EXCL_INPUT_ERROR" },
    {  "value":       6101, "name": "MQRC_REOPEN_INQUIRE_ERROR" },
    {  "value":       6102, "name": "MQRC_REOPEN_SAVED_CONTEXT_ERR" },
    {  "value":       6103, "name": "MQRC_REOPEN_TEMPORARY_Q_ERROR" },
    {  "value":       6104, "name": "MQRC_ATTRIBUTE_LOCKED" },
    {  "value":       6105, "name": "MQRC_CURSOR_NOT_VALID" },
    {  "value":       6106, "name": "MQRC_ENCODING_ERROR" },
    {  "value":       6107, "name": "MQRC_STRUC_ID_ERROR" },
    {  "value":       6108, "name": "MQRC_NULL_POINTER" },
    {  "value":       6109, "name": "MQRC_NO_CONNECTION_REFERENCE" },
    {  "value":       6110, "name": "MQRC_NO_BUFFER" },
    {  "value":       6111, "name": "MQRC_BINARY_DATA_LENGTH_ERROR" },
    {  "value":       6112, "name": "MQRC_BUFFER_NOT_AUTOMATIC" },
    {  "value":       6113, "name": "MQRC_INSUFFICIENT_BUFFER" },
    {  "value":       6114, "name": "MQRC_INSUFFICIENT_DATA" },
    {  "value":       6115, "name": "MQRC_DATA_TRUNCATED" },
    {  "value":       6116, "name": "MQRC_ZERO_LENGTH" },
    {  "value":       6117, "name": "MQRC_NEGATIVE_LENGTH" },
    {  "value":       6118, "name": "MQRC_NEGATIVE_OFFSET" },
    {  "value":       6119, "name": "MQRC_INCONSISTENT_FORMAT" },
    {  "value":       6120, "name": "MQRC_INCONSISTENT_OBJECT_STATE" },
    {  "value":       6121, "name": "MQRC_CONTEXT_OBJECT_NOT_VALID" },
    {  "value":       6122, "name": "MQRC_CONTEXT_OPEN_ERROR" },
    {  "value":       6123, "name": "MQRC_STRUC_LENGTH_ERROR" },
    {  "value":       6124, "name": "MQRC_NOT_CONNECTED" },
    {  "value":       6125, "name": "MQRC_NOT_OPEN" },
    {  "value":       6126, "name": "MQRC_DISTRIBUTION_LIST_EMPTY" },
    {  "value":       6127, "name": "MQRC_INCONSISTENT_OPEN_OPTIONS" },
    {  "value":       6128, "name": "MQRC_WRONG_VERSION" },
    {  "value":       6129, "name": "MQRC_REFERENCE_ERROR" },
    {  "value":       6130, "name": "MQRC_XR_NOT_AVAILABLE" },
    {  "value":       6144, "name": "MQRO_COD_WITH_DATA" },
    {  "value":       7001, "name": "MQBACF_EVENT_ACCOUNTING_TOKEN" },
    {  "value":       7001, "name": "MQBACF_FIRST" },
    {  "value":       7002, "name": "MQBACF_EVENT_SECURITY_ID" },
    {  "value":       7003, "name": "MQBACF_RESPONSE_SET" },
    {  "value":       7004, "name": "MQBACF_RESPONSE_ID" },
    {  "value":       7005, "name": "MQBACF_EXTERNAL_UOW_ID" },
    {  "value":       7006, "name": "MQBACF_CONNECTION_ID" },
    {  "value":       7007, "name": "MQBACF_GENERIC_CONNECTION_ID" },
    {  "value":       7008, "name": "MQBACF_ORIGIN_UOW_ID" },
    {  "value":       7009, "name": "MQBACF_Q_MGR_UOW_ID" },
    {  "value":       7010, "name": "MQBACF_ACCOUNTING_TOKEN" },
    {  "value":       7011, "name": "MQBACF_CORREL_ID" },
    {  "value":       7012, "name": "MQBACF_GROUP_ID" },
    {  "value":       7013, "name": "MQBACF_MSG_ID" },
    {  "value":       7014, "name": "MQBACF_CF_LEID" },
    {  "value":       7015, "name": "MQBACF_DESTINATION_CORREL_ID" },
    {  "value":       7016, "name": "MQBACF_SUB_ID" },
    {  "value":       7019, "name": "MQBACF_ALTERNATE_SECURITYID" },
    {  "value":       7020, "name": "MQBACF_MESSAGE_DATA" },
    {  "value":       7021, "name": "MQBACF_MQBO_STRUCT" },
    {  "value":       7022, "name": "MQBACF_MQCB_FUNCTION" },
    {  "value":       7023, "name": "MQBACF_MQCBC_STRUCT" },
    {  "value":       7024, "name": "MQBACF_MQCBD_STRUCT" },
    {  "value":       7025, "name": "MQBACF_MQCD_STRUCT" },
    {  "value":       7026, "name": "MQBACF_MQCNO_STRUCT" },
    {  "value":       7027, "name": "MQBACF_MQGMO_STRUCT" },
    {  "value":       7028, "name": "MQBACF_MQMD_STRUCT" },
    {  "value":       7029, "name": "MQBACF_MQPMO_STRUCT" },
    {  "value":       7030, "name": "MQBACF_MQSD_STRUCT" },
    {  "value":       7031, "name": "MQBACF_MQSTS_STRUCT" },
    {  "value":       7032, "name": "MQBACF_SUB_CORREL_ID" },
    {  "value":       7033, "name": "MQBACF_XA_XID" },
    {  "value":       7034, "name": "MQBACF_XQH_CORREL_ID" },
    {  "value":       7035, "name": "MQBACF_XQH_MSG_ID" },
    {  "value":       7036, "name": "MQBACF_REQUEST_ID" },
    {  "value":       7037, "name": "MQBACF_PROPERTIES_DATA" },
    {  "value":       7038, "name": "MQBACF_CONN_TAG" },
    {  "value":       7039, "name": "MQBACF_LAST_USED" },
    {  "value":       7039, "name": "MQBACF_MQBNO_STRUCT" },
    {  "value":       8000, "name": "MQBA_LAST" },
    {  "value":       8000, "name": "MQFIELD_WQR_StrucId" },
    {  "value":       8001, "name": "MQFIELD_WQR_Version" },
    {  "value":       8001, "name": "MQGACF_COMMAND_CONTEXT" },
    {  "value":       8001, "name": "MQGACF_FIRST" },
    {  "value":       8001, "name": "MQGA_FIRST" },
    {  "value":       8002, "name": "MQFIELD_WQR_StrucLength" },
    {  "value":       8002, "name": "MQGACF_COMMAND_DATA" },
    {  "value":       8003, "name": "MQFIELD_WQR_QFlags" },
    {  "value":       8003, "name": "MQGACF_TRACE_ROUTE" },
    {  "value":       8004, "name": "MQFIELD_WQR_QName" },
    {  "value":       8004, "name": "MQGACF_OPERATION" },
    {  "value":       8005, "name": "MQFIELD_WQR_QMgrIdentifier" },
    {  "value":       8005, "name": "MQGACF_ACTIVITY" },
    {  "value":       8006, "name": "MQFIELD_WQR_ClusterRecOffset" },
    {  "value":       8006, "name": "MQGACF_EMBEDDED_MQMD" },
    {  "value":       8007, "name": "MQFIELD_WQR_QType" },
    {  "value":       8007, "name": "MQGACF_MESSAGE" },
    {  "value":       8008, "name": "MQFIELD_WQR_QDesc" },
    {  "value":       8008, "name": "MQGACF_MQMD" },
    {  "value":       8009, "name": "MQFIELD_WQR_DefBind" },
    {  "value":       8009, "name": "MQGACF_VALUE_NAMING" },
    {  "value":       8010, "name": "MQFIELD_WQR_DefPersistence" },
    {  "value":       8010, "name": "MQGACF_Q_ACCOUNTING_DATA" },
    {  "value":       8011, "name": "MQFIELD_WQR_DefPriority" },
    {  "value":       8011, "name": "MQGACF_Q_STATISTICS_DATA" },
    {  "value":       8012, "name": "MQFIELD_WQR_InhibitPut" },
    {  "value":       8012, "name": "MQGACF_CHL_STATISTICS_DATA" },
    {  "value":       8013, "name": "MQFIELD_WQR_CLWLQueuePriority" },
    {  "value":       8013, "name": "MQGACF_ACTIVITY_TRACE" },
    {  "value":       8014, "name": "MQFIELD_WQR_CLWLQueueRank" },
    {  "value":       8014, "name": "MQGACF_APP_DIST_LIST" },
    {  "value":       8015, "name": "MQFIELD_WQR_DefPutResponse" },
    {  "value":       8015, "name": "MQGACF_MONITOR_CLASS" },
    {  "value":       8016, "name": "MQFIELD_WQR_CapExpiry" },
    {  "value":       8016, "name": "MQGACF_MONITOR_TYPE" },
    {  "value":       8017, "name": "MQGACF_MONITOR_ELEMENT" },
    {  "value":       8018, "name": "MQGACF_APPL_STATUS" },
    {  "value":       8019, "name": "MQGACF_CHANGED_APPLS" },
    {  "value":       8020, "name": "MQGACF_ALL_APPLS" },
    {  "value":       8021, "name": "MQGACF_APPL_BALANCE" },
    {  "value":       8021, "name": "MQGACF_LAST_USED" },
    {  "value":       8192, "name": "MQCBDO_FAIL_IF_QUIESCING" },
    {  "value":       8192, "name": "MQCNO_ACCOUNTING_MQI_DISABLED" },
    {  "value":       8192, "name": "MQCTLO_FAIL_IF_QUIESCING" },
    {  "value":       8192, "name": "MQGMO_FAIL_IF_QUIESCING" },
    {  "value":       8192, "name": "MQOO_FAIL_IF_QUIESCING" },
    {  "value":       8192, "name": "MQPMO_FAIL_IF_QUIESCING" },
    {  "value":       8192, "name": "MQREGO_PERSISTENT_AS_Q" },
    {  "value":       8192, "name": "MQROUTE_DELIVER_NO" },
    {  "value":       8192, "name": "MQSO_FAIL_IF_QUIESCING" },
    {  "value":       8192, "name": "MQSRO_FAIL_IF_QUIESCING" },
    {  "value":       8192, "name": "MQZAO_RESUME" },
    {  "value":       8192, "name": "MQ_CSP_TOKEN_LENGTH" },
    {  "value":       9000, "name": "MQGA_LAST" },
    {  "value":       9000, "name": "MQOA_LAST" },
    {  "value":      10000, "name": "MQIAMO_MONITOR_PERCENT" },
    {  "value":      10240, "name": "MQ_SELECTOR_LENGTH" },
    {  "value":      10240, "name": "MQ_SUB_NAME_LENGTH" },
    {  "value":      10240, "name": "MQ_TOPIC_STR_LENGTH" },
    {  "value":      10240, "name": "MQ_USER_DATA_LENGTH" },
    {  "value":      14336, "name": "MQRO_COD_WITH_FULL_DATA" },
    {  "value":      16383, "name": "MQZAO_ALL_MQI" },
    {  "value":      16384, "name": "MQCBDO_EVENT_CALL" },
    {  "value":      16384, "name": "MQCNO_ACCOUNTING_Q_ENABLED" },
    {  "value":      16384, "name": "MQGMO_CONVERT" },
    {  "value":      16384, "name": "MQOO_BIND_ON_OPEN" },
    {  "value":      16384, "name": "MQPMO_NO_CONTEXT" },
    {  "value":      16384, "name": "MQREGO_ADD_NAME" },
    {  "value":      16384, "name": "MQRO_PASS_DISCARD_AND_EXPIRY" },
    {  "value":      29440, "name": "MQRC_SUB_JOIN_NOT_ALTERABLE" },
    {  "value":      32768, "name": "MQCBDO_MC_EVENT_CALL" },
    {  "value":      32768, "name": "MQCNO_ACCOUNTING_Q_DISABLED" },
    {  "value":      32768, "name": "MQGMO_LOGICAL_ORDER" },
    {  "value":      32768, "name": "MQOO_BIND_NOT_FIXED" },
    {  "value":      32768, "name": "MQPMO_LOGICAL_ORDER" },
    {  "value":      32768, "name": "MQREGO_NO_ALTERATION" },
    {  "value":      32768, "name": "MQ_COMMAND_MQSC_LENGTH" },
    {  "value":      65535, "name": "MQFB_SYSTEM_LAST" },
    {  "value":      65535, "name": "MQMT_SYSTEM_LAST" },
    {  "value":      65535, "name": "MQOPER_SYSTEM_LAST" },
    {  "value":      65536, "name": "MQAT_USER_FIRST" },
    {  "value":      65536, "name": "MQBNO_BALTYPE_RA_MANAGED" },
    {  "value":      65536, "name": "MQCNO_NO_CONV_SHARING" },
    {  "value":      65536, "name": "MQCTES_ENDTASK" },
    {  "value":      65536, "name": "MQCUOWC_CONTINUE" },
    {  "value":      65536, "name": "MQFB_APPL_FIRST" },
    {  "value":      65536, "name": "MQGMO_COMPLETE_MSG" },
    {  "value":      65536, "name": "MQMT_APPL_FIRST" },
    {  "value":      65536, "name": "MQOO_RESOLVE_NAMES" },
    {  "value":      65536, "name": "MQOPER_APPL_FIRST" },
    {  "value":      65536, "name": "MQOP_SUSPEND" },
    {  "value":      65536, "name": "MQPMO_ASYNC_RESPONSE" },
    {  "value":      65536, "name": "MQREGO_FULL_RESPONSE" },
    {  "value":      65536, "name": "MQUA_FIRST" },
    {  "value":      65536, "name": "MQZAO_CREATE" },
    {  "value":      65536, "name": "MQ_MQTT_MAX_KEEP_ALIVE" },
    {  "value":      65539, "name": "MQROUTE_ACCUMULATE_NONE" },
    {  "value":      65540, "name": "MQROUTE_ACCUMULATE_IN_MSG" },
    {  "value":      65541, "name": "MQROUTE_ACCUMULATE_AND_REPLY" },
    {  "value":     131072, "name": "MQGMO_ALL_MSGS_AVAILABLE" },
    {  "value":     131072, "name": "MQOO_CO_OP" },
    {  "value":     131072, "name": "MQOP_RESUME" },
    {  "value":     131072, "name": "MQPMO_SYNC_RESPONSE" },
    {  "value":     131072, "name": "MQREGO_JOIN_SHARED" },
    {  "value":     131072, "name": "MQZAO_DELETE" },
    {  "value":     261888, "name": "MQRO_ACCEPT_UNSUP_IF_XMIT_MASK" },
    {  "value":     262144, "name": "MQCNO_ALL_CONVS_SHARE" },
    {  "value":     262144, "name": "MQGMO_ALL_SEGMENTS_AVAILABLE" },
    {  "value":     262144, "name": "MQOO_RESOLVE_LOCAL_Q" },
    {  "value":     262144, "name": "MQOO_RESOLVE_LOCAL_TOPIC" },
    {  "value":     262144, "name": "MQPMO_RESOLVE_LOCAL_Q" },
    {  "value":     262144, "name": "MQREGO_JOIN_EXCLUSIVE" },
    {  "value":     262144, "name": "MQSO_ALTERNATE_USER_AUTHORITY" },
    {  "value":     262144, "name": "MQZAO_DISPLAY" },
    {  "value":     524288, "name": "MQCNO_CD_FOR_OUTPUT_ONLY" },
    {  "value":     524288, "name": "MQOO_NO_READ_AHEAD" },
    {  "value":     524288, "name": "MQPMO_WARN_IF_NO_SUBS_MATCHED" },
    {  "value":     524288, "name": "MQREGO_LEAVE_ONLY" },
    {  "value":     524288, "name": "MQZAO_CHANGE" },
    {  "value":    1000000, "name": "MQIAMO_MONITOR_MICROSEC" },
    {  "value":    1044480, "name": "MQMF_ACCEPT_UNSUP_IF_XMIT_MASK" },
    {  "value":    1047552, "name": "MQPD_ACCEPT_UNSUP_IF_XMIT_MASK" },
    {  "value":    1048576, "name": "MQCNO_USE_CD_SELECTION" },
    {  "value":    1048576, "name": "MQGMO_MARK_BROWSE_HANDLE" },
    {  "value":    1048576, "name": "MQIAMO_MONITOR_MB" },
    {  "value":    1048576, "name": "MQOO_READ_AHEAD" },
    {  "value":    1048576, "name": "MQPD_SUPPORT_REQUIRED" },
    {  "value":    1048576, "name": "MQREGO_VARIABLE_USER_ID" },
    {  "value":    1048576, "name": "MQSO_WILDCARD_CHAR" },
    {  "value":    1048576, "name": "MQZAO_CLEAR" },
    {  "value":    2097152, "name": "MQCNO_GENERATE_CONN_TAG" },
    {  "value":    2097152, "name": "MQGMO_MARK_BROWSE_CO_OP" },
    {  "value":    2097152, "name": "MQOO_NO_MULTICAST" },
    {  "value":    2097152, "name": "MQPMO_PUB_OPTIONS_MASK" },
    {  "value":    2097152, "name": "MQPMO_RETAIN" },
    {  "value":    2097152, "name": "MQREGO_LOCKED" },
    {  "value":    2097152, "name": "MQRO_EXPIRATION" },
    {  "value":    2097152, "name": "MQSO_WILDCARD_TOPIC" },
    {  "value":    2097152, "name": "MQZAO_CONTROL" },
    {  "value":    4194304, "name": "MQGMO_UNMARK_BROWSE_CO_OP" },
    {  "value":    4194304, "name": "MQOO_BIND_ON_GROUP" },
    {  "value":    4194304, "name": "MQSO_SET_CORREL_ID" },
    {  "value":    4194304, "name": "MQZAO_CONTROL_EXTENDED" },
    {  "value":    6291456, "name": "MQRO_EXPIRATION_WITH_DATA" },
    {  "value":    8388608, "name": "MQGMO_UNMARK_BROWSE_HANDLE" },
    {  "value":    8388608, "name": "MQPMO_MD_FOR_OUTPUT_ONLY" },
    {  "value":    8388608, "name": "MQZAO_AUTHORIZE" },
    {  "value":   14680064, "name": "MQRO_EXPIRATION_WITH_FULL_DATA" },
    {  "value":   16646144, "name": "MQZAO_ALL_ADMIN" },
    {  "value":   16777216, "name": "MQCNO_RECONNECT" },
    {  "value":   16777216, "name": "MQGMO_UNMARKED_BROWSE_MSG" },
    {  "value":   16777216, "name": "MQRO_EXCEPTION" },
    {  "value":   16777216, "name": "MQZAO_REMOVE" },
    {  "value":   17825808, "name": "MQGMO_BROWSE_HANDLE" },
    {  "value":   18874384, "name": "MQGMO_BROWSE_CO_OP" },
    {  "value":   33554432, "name": "MQCNO_RECONNECT_DISABLED" },
    {  "value":   33554432, "name": "MQGMO_PROPERTIES_FORCE_MQRFH2" },
    {  "value":   33554432, "name": "MQZAO_SYSTEM" },
    {  "value":   50216959, "name": "MQZAO_ALL" },
    {  "value":   50331648, "name": "MQRO_EXCEPTION_WITH_DATA" },
    {  "value":   67108864, "name": "MQCNO_RECONNECT_Q_MGR" },
    {  "value":   67108864, "name": "MQGMO_NO_PROPERTIES" },
    {  "value":   67108864, "name": "MQPMO_SCOPE_QMGR" },
    {  "value":   67108864, "name": "MQSO_SCOPE_QMGR" },
    {  "value":   67108864, "name": "MQZAO_CREATE_ONLY" },
    {  "value":  100000000, "name": "MQIAMO_MONITOR_GB" },
    {  "value":  117440512, "name": "MQRO_EXCEPTION_WITH_FULL_DATA" },
    {  "value":  134217728, "name": "MQCNO_ACTIVITY_TRACE_ENABLED" },
    {  "value":  134217728, "name": "MQGMO_PROPERTIES_IN_HANDLE" },
    {  "value":  134217728, "name": "MQPMO_SUPPRESS_REPLYTO" },
    {  "value":  134217728, "name": "MQRO_DISCARD_MSG" },
    {  "value":  134217728, "name": "MQSO_NO_READ_AHEAD" },
    {  "value":  268435455, "name": "MQCOMPRESS_ANY" },
    {  "value":  268435456, "name": "MQCNO_ACTIVITY_TRACE_DISABLED" },
    {  "value":  268435456, "name": "MQGMO_PROPERTIES_COMPATIBILITY" },
    {  "value":  268435456, "name": "MQPMO_NOT_OWN_SUBS" },
    {  "value":  268435456, "name": "MQSO_READ_AHEAD" },
    {  "value":  270270464, "name": "MQRO_REJECT_UNSUP_MASK" },
    {  "value":  999999999, "name": "MQAT_USER_LAST" },
    {  "value":  999999999, "name": "MQFB_APPL_LAST" },
    {  "value":  999999999, "name": "MQMT_APPL_LAST" },
    {  "value":  999999999, "name": "MQOPER_APPL_LAST" },
    {  "value":  999999999, "name": "MQUA_LAST" },
]



"""
  -----------------------------------------------------------------
   End of CMQSTRC
  -----------------------------------------------------------------
"""
