# coding: utf-8

"""
    AssistedInstall

    Assisted installation  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from assisted_service_client.api_client import ApiClient


class InstallerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def bind_host(self, infra_env_id, host_id, bind_host_params, **kwargs):  # noqa: E501
        """bind_host  # noqa: E501

        Bind host to a cluster  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bind_host(infra_env_id, host_id, bind_host_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The infra env of the host that is being bound. (required)
        :param str host_id: The host that is being bound. (required)
        :param BindHostParams bind_host_params: The parameters for the host binding. (required)
        :return: Host
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.bind_host_with_http_info(infra_env_id, host_id, bind_host_params, **kwargs)  # noqa: E501
        else:
            (data) = self.bind_host_with_http_info(infra_env_id, host_id, bind_host_params, **kwargs)  # noqa: E501
            return data

    def bind_host_with_http_info(self, infra_env_id, host_id, bind_host_params, **kwargs):  # noqa: E501
        """bind_host  # noqa: E501

        Bind host to a cluster  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.bind_host_with_http_info(infra_env_id, host_id, bind_host_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The infra env of the host that is being bound. (required)
        :param str host_id: The host that is being bound. (required)
        :param BindHostParams bind_host_params: The parameters for the host binding. (required)
        :return: Host
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['infra_env_id', 'host_id', 'bind_host_params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method bind_host" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'infra_env_id' is set
        if ('infra_env_id' not in params or
                params['infra_env_id'] is None):
            raise ValueError("Missing the required parameter `infra_env_id` when calling `bind_host`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `bind_host`")  # noqa: E501
        # verify the required parameter 'bind_host_params' is set
        if ('bind_host_params' not in params or
                params['bind_host_params'] is None):
            raise ValueError("Missing the required parameter `bind_host_params` when calling `bind_host`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'infra_env_id' in params:
            path_params['infra_env_id'] = params['infra_env_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'bind_host_params' in params:
            body_params = params['bind_host_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/infra-envs/{infra_env_id}/hosts/{host_id}/actions/bind', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Host',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cancel_installation(self, cluster_id, **kwargs):  # noqa: E501
        """cancel_installation  # noqa: E501

        Cancels an ongoing installation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_installation(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose installation is to be canceled. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cancel_installation_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cancel_installation_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def cancel_installation_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """cancel_installation  # noqa: E501

        Cancels an ongoing installation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_installation_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose installation is to be canceled. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_installation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `cancel_installation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/actions/cancel', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def complete_installation(self, cluster_id, completion_params, **kwargs):  # noqa: E501
        """complete_installation  # noqa: E501

        Agent API to mark a finalizing installation as complete.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.complete_installation(cluster_id, completion_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose installation is being completing. (required)
        :param CompletionParams completion_params: The final status of the cluster installation. (required)
        :param str discovery_agent_version: The software version of the discovery agent that is completing the installation.
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.complete_installation_with_http_info(cluster_id, completion_params, **kwargs)  # noqa: E501
        else:
            (data) = self.complete_installation_with_http_info(cluster_id, completion_params, **kwargs)  # noqa: E501
            return data

    def complete_installation_with_http_info(self, cluster_id, completion_params, **kwargs):  # noqa: E501
        """complete_installation  # noqa: E501

        Agent API to mark a finalizing installation as complete.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.complete_installation_with_http_info(cluster_id, completion_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose installation is being completing. (required)
        :param CompletionParams completion_params: The final status of the cluster installation. (required)
        :param str discovery_agent_version: The software version of the discovery agent that is completing the installation.
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'completion_params', 'discovery_agent_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method complete_installation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `complete_installation`")  # noqa: E501
        # verify the required parameter 'completion_params' is set
        if ('completion_params' not in params or
                params['completion_params'] is None):
            raise ValueError("Missing the required parameter `completion_params` when calling `complete_installation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'discovery_agent_version' in params:
            header_params['discovery_agent_version'] = params['discovery_agent_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'completion_params' in params:
            body_params = params['completion_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/actions/complete_installation', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deregister_cluster(self, cluster_id, **kwargs):  # noqa: E501
        """deregister_cluster  # noqa: E501

        Deletes an OpenShift cluster definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deregister_cluster(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to be deregistered. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.deregister_cluster_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.deregister_cluster_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def deregister_cluster_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """deregister_cluster  # noqa: E501

        Deletes an OpenShift cluster definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deregister_cluster_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to be deregistered. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deregister_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `deregister_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deregister_host(self, cluster_id, host_id, **kwargs):  # noqa: E501
        """deregister_host  # noqa: E501

        Deregisters an OpenShift host.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deregister_host(cluster_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster of the host that should be deregistered. (required)
        :param str host_id: The host that should be deregistered. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.deregister_host_with_http_info(cluster_id, host_id, **kwargs)  # noqa: E501
        else:
            (data) = self.deregister_host_with_http_info(cluster_id, host_id, **kwargs)  # noqa: E501
            return data

    def deregister_host_with_http_info(self, cluster_id, host_id, **kwargs):  # noqa: E501
        """deregister_host  # noqa: E501

        Deregisters an OpenShift host.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deregister_host_with_http_info(cluster_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster of the host that should be deregistered. (required)
        :param str host_id: The host that should be deregistered. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'host_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deregister_host" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `deregister_host`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `deregister_host`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/hosts/{host_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def deregister_infra_env(self, infra_env_id, **kwargs):  # noqa: E501
        """deregister_infra_env  # noqa: E501

        Deletes an InfraEnv.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deregister_infra_env(infra_env_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv to be deleted. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.deregister_infra_env_with_http_info(infra_env_id, **kwargs)  # noqa: E501
        else:
            (data) = self.deregister_infra_env_with_http_info(infra_env_id, **kwargs)  # noqa: E501
            return data

    def deregister_infra_env_with_http_info(self, infra_env_id, **kwargs):  # noqa: E501
        """deregister_infra_env  # noqa: E501

        Deletes an InfraEnv.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.deregister_infra_env_with_http_info(infra_env_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv to be deleted. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['infra_env_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deregister_infra_env" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'infra_env_id' is set
        if ('infra_env_id' not in params or
                params['infra_env_id'] is None):
            raise ValueError("Missing the required parameter `infra_env_id` when calling `deregister_infra_env`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'infra_env_id' in params:
            path_params['infra_env_id'] = params['infra_env_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/infra-envs/{infra_env_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def disable_host(self, cluster_id, host_id, **kwargs):  # noqa: E501
        """disable_host  # noqa: E501

        Disables a host for inclusion in the cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.disable_host(cluster_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster of the host that is being disabled. (required)
        :param str host_id: The host that is being disabled. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.disable_host_with_http_info(cluster_id, host_id, **kwargs)  # noqa: E501
        else:
            (data) = self.disable_host_with_http_info(cluster_id, host_id, **kwargs)  # noqa: E501
            return data

    def disable_host_with_http_info(self, cluster_id, host_id, **kwargs):  # noqa: E501
        """disable_host  # noqa: E501

        Disables a host for inclusion in the cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.disable_host_with_http_info(cluster_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster of the host that is being disabled. (required)
        :param str host_id: The host that is being disabled. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'host_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method disable_host" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `disable_host`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `disable_host`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/hosts/{host_id}/actions/enable', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_cluster_files(self, cluster_id, file_name, **kwargs):  # noqa: E501
        """download_cluster_files  # noqa: E501

        Downloads files relating to the installed/installing cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_cluster_files(cluster_id, file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster that owns the file that should be downloaded. (required)
        :param str file_name: The file to be downloaded. (required)
        :param str discovery_agent_version: The software version of the discovery agent that is downloading the file.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.download_cluster_files_with_http_info(cluster_id, file_name, **kwargs)  # noqa: E501
        else:
            (data) = self.download_cluster_files_with_http_info(cluster_id, file_name, **kwargs)  # noqa: E501
            return data

    def download_cluster_files_with_http_info(self, cluster_id, file_name, **kwargs):  # noqa: E501
        """download_cluster_files  # noqa: E501

        Downloads files relating to the installed/installing cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_cluster_files_with_http_info(cluster_id, file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster that owns the file that should be downloaded. (required)
        :param str file_name: The file to be downloaded. (required)
        :param str discovery_agent_version: The software version of the discovery agent that is downloading the file.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'file_name', 'discovery_agent_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_cluster_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `download_cluster_files`")  # noqa: E501
        # verify the required parameter 'file_name' is set
        if ('file_name' not in params or
                params['file_name'] is None):
            raise ValueError("Missing the required parameter `file_name` when calling `download_cluster_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []
        if 'file_name' in params:
            query_params.append(('file_name', params['file_name']))  # noqa: E501

        header_params = {}
        if 'discovery_agent_version' in params:
            header_params['discovery_agent_version'] = params['discovery_agent_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth', 'urlAuth', 'userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/downloads/files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_cluster_iso(self, cluster_id, **kwargs):  # noqa: E501
        """download_cluster_iso  # noqa: E501

        Downloads the OpenShift per-cluster Discovery ISO.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_cluster_iso(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose ISO should be downloaded. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.download_cluster_iso_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.download_cluster_iso_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def download_cluster_iso_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """download_cluster_iso  # noqa: E501

        Downloads the OpenShift per-cluster Discovery ISO.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_cluster_iso_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose ISO should be downloaded. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_cluster_iso" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `download_cluster_iso`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['urlAuth', 'userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/downloads/image', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_cluster_iso_headers(self, cluster_id, **kwargs):  # noqa: E501
        """download_cluster_iso_headers  # noqa: E501

        Downloads the OpenShift per-cluster Discovery ISO Headers only.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_cluster_iso_headers(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose ISO headers should be downloaded. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.download_cluster_iso_headers_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.download_cluster_iso_headers_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def download_cluster_iso_headers_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """download_cluster_iso_headers  # noqa: E501

        Downloads the OpenShift per-cluster Discovery ISO Headers only.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_cluster_iso_headers_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose ISO headers should be downloaded. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_cluster_iso_headers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `download_cluster_iso_headers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['urlAuth', 'userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/downloads/image', 'HEAD',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_cluster_kubeconfig(self, cluster_id, **kwargs):  # noqa: E501
        """download_cluster_kubeconfig  # noqa: E501

        Downloads the kubeconfig file for this cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_cluster_kubeconfig(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose kubeconfig should be downloaded. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.download_cluster_kubeconfig_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.download_cluster_kubeconfig_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def download_cluster_kubeconfig_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """download_cluster_kubeconfig  # noqa: E501

        Downloads the kubeconfig file for this cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_cluster_kubeconfig_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose kubeconfig should be downloaded. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_cluster_kubeconfig" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `download_cluster_kubeconfig`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['urlAuth', 'userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/downloads/kubeconfig', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_cluster_logs(self, cluster_id, **kwargs):  # noqa: E501
        """download_cluster_logs  # noqa: E501

        Download cluster logs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_cluster_logs(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose logs should be downloaded. (required)
        :param str logs_type: The type of logs to be downloaded.
        :param str host_id: A specific host in the cluster whose logs should be downloaded.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.download_cluster_logs_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.download_cluster_logs_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def download_cluster_logs_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """download_cluster_logs  # noqa: E501

        Download cluster logs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_cluster_logs_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose logs should be downloaded. (required)
        :param str logs_type: The type of logs to be downloaded.
        :param str host_id: A specific host in the cluster whose logs should be downloaded.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'logs_type', 'host_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_cluster_logs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `download_cluster_logs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []
        if 'logs_type' in params:
            query_params.append(('logs_type', params['logs_type']))  # noqa: E501
        if 'host_id' in params:
            query_params.append(('host_id', params['host_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['urlAuth', 'userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_host_ignition(self, cluster_id, host_id, **kwargs):  # noqa: E501
        """download_host_ignition  # noqa: E501

        Downloads the customized ignition file for this host, produces octet string  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_host_ignition(cluster_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster of the host whose ignition file should be downloaded. (required)
        :param str host_id: The host whose ignition file should be downloaded. (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.download_host_ignition_with_http_info(cluster_id, host_id, **kwargs)  # noqa: E501
        else:
            (data) = self.download_host_ignition_with_http_info(cluster_id, host_id, **kwargs)  # noqa: E501
            return data

    def download_host_ignition_with_http_info(self, cluster_id, host_id, **kwargs):  # noqa: E501
        """download_host_ignition  # noqa: E501

        Downloads the customized ignition file for this host, produces octet string  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_host_ignition_with_http_info(cluster_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster of the host whose ignition file should be downloaded. (required)
        :param str host_id: The host whose ignition file should be downloaded. (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'host_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_host_ignition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `download_host_ignition`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `download_host_ignition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth', 'userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/hosts/{host_id}/downloads/ignition', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_host_logs(self, cluster_id, host_id, **kwargs):  # noqa: E501
        """download_host_logs  # noqa: E501

        Download host logs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_host_logs(cluster_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster of the host whose logs should be downloaded. (required)
        :param str host_id: The host whose logs should be downloaded. (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.download_host_logs_with_http_info(cluster_id, host_id, **kwargs)  # noqa: E501
        else:
            (data) = self.download_host_logs_with_http_info(cluster_id, host_id, **kwargs)  # noqa: E501
            return data

    def download_host_logs_with_http_info(self, cluster_id, host_id, **kwargs):  # noqa: E501
        """download_host_logs  # noqa: E501

        Download host logs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_host_logs_with_http_info(cluster_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster of the host whose logs should be downloaded. (required)
        :param str host_id: The host whose logs should be downloaded. (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'host_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_host_logs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `download_host_logs`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `download_host_logs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['urlAuth', 'userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/hosts/{host_id}/logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_infra_env_discovery_image(self, infra_env_id, **kwargs):  # noqa: E501
        """download_infra_env_discovery_image  # noqa: E501

        Downloads the discovery image.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_infra_env_discovery_image(infra_env_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv whose image should be downloaded. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.download_infra_env_discovery_image_with_http_info(infra_env_id, **kwargs)  # noqa: E501
        else:
            (data) = self.download_infra_env_discovery_image_with_http_info(infra_env_id, **kwargs)  # noqa: E501
            return data

    def download_infra_env_discovery_image_with_http_info(self, infra_env_id, **kwargs):  # noqa: E501
        """download_infra_env_discovery_image  # noqa: E501

        Downloads the discovery image.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_infra_env_discovery_image_with_http_info(infra_env_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv whose image should be downloaded. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['infra_env_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_infra_env_discovery_image" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'infra_env_id' is set
        if ('infra_env_id' not in params or
                params['infra_env_id'] is None):
            raise ValueError("Missing the required parameter `infra_env_id` when calling `download_infra_env_discovery_image`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'infra_env_id' in params:
            path_params['infra_env_id'] = params['infra_env_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['urlAuth', 'userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/infra-envs/{infra_env_id}/downloads/image', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_infra_env_discovery_image_headers(self, infra_env_id, **kwargs):  # noqa: E501
        """download_infra_env_discovery_image_headers  # noqa: E501

        Downloads the discovery image Headers only.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_infra_env_discovery_image_headers(infra_env_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv whose image headers should be retrieved. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.download_infra_env_discovery_image_headers_with_http_info(infra_env_id, **kwargs)  # noqa: E501
        else:
            (data) = self.download_infra_env_discovery_image_headers_with_http_info(infra_env_id, **kwargs)  # noqa: E501
            return data

    def download_infra_env_discovery_image_headers_with_http_info(self, infra_env_id, **kwargs):  # noqa: E501
        """download_infra_env_discovery_image_headers  # noqa: E501

        Downloads the discovery image Headers only.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_infra_env_discovery_image_headers_with_http_info(infra_env_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv whose image headers should be retrieved. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['infra_env_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_infra_env_discovery_image_headers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'infra_env_id' is set
        if ('infra_env_id' not in params or
                params['infra_env_id'] is None):
            raise ValueError("Missing the required parameter `infra_env_id` when calling `download_infra_env_discovery_image_headers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'infra_env_id' in params:
            path_params['infra_env_id'] = params['infra_env_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['urlAuth', 'userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/infra-envs/{infra_env_id}/downloads/image', 'HEAD',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_minimal_initrd(self, infra_env_id, **kwargs):  # noqa: E501
        """download_minimal_initrd  # noqa: E501

        Get the initial ramdisk for minimal ISO based installations.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_minimal_initrd(infra_env_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The infra env of the host that should be retrieved. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.download_minimal_initrd_with_http_info(infra_env_id, **kwargs)  # noqa: E501
        else:
            (data) = self.download_minimal_initrd_with_http_info(infra_env_id, **kwargs)  # noqa: E501
            return data

    def download_minimal_initrd_with_http_info(self, infra_env_id, **kwargs):  # noqa: E501
        """download_minimal_initrd  # noqa: E501

        Get the initial ramdisk for minimal ISO based installations.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_minimal_initrd_with_http_info(infra_env_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The infra env of the host that should be retrieved. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['infra_env_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_minimal_initrd" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'infra_env_id' is set
        if ('infra_env_id' not in params or
                params['infra_env_id'] is None):
            raise ValueError("Missing the required parameter `infra_env_id` when calling `download_minimal_initrd`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'infra_env_id' in params:
            path_params['infra_env_id'] = params['infra_env_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['urlAuth', 'userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/infra-envs/{infra_env_id}/downloads/minimal-initrd', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def enable_host(self, cluster_id, host_id, **kwargs):  # noqa: E501
        """enable_host  # noqa: E501

        Enables a host for inclusion in the cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.enable_host(cluster_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster of the host that is being enabled. (required)
        :param str host_id: The host that is being enabled. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.enable_host_with_http_info(cluster_id, host_id, **kwargs)  # noqa: E501
        else:
            (data) = self.enable_host_with_http_info(cluster_id, host_id, **kwargs)  # noqa: E501
            return data

    def enable_host_with_http_info(self, cluster_id, host_id, **kwargs):  # noqa: E501
        """enable_host  # noqa: E501

        Enables a host for inclusion in the cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.enable_host_with_http_info(cluster_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster of the host that is being enabled. (required)
        :param str host_id: The host that is being enabled. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'host_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enable_host" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `enable_host`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `enable_host`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/hosts/{host_id}/actions/enable', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def generate_cluster_iso(self, cluster_id, image_create_params, **kwargs):  # noqa: E501
        """generate_cluster_iso  # noqa: E501

        Creates a new OpenShift per-cluster Discovery ISO.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_cluster_iso(cluster_id, image_create_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose ISO should be generated. (required)
        :param ImageCreateParams image_create_params: The parameters for the generated ISO. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.generate_cluster_iso_with_http_info(cluster_id, image_create_params, **kwargs)  # noqa: E501
        else:
            (data) = self.generate_cluster_iso_with_http_info(cluster_id, image_create_params, **kwargs)  # noqa: E501
            return data

    def generate_cluster_iso_with_http_info(self, cluster_id, image_create_params, **kwargs):  # noqa: E501
        """generate_cluster_iso  # noqa: E501

        Creates a new OpenShift per-cluster Discovery ISO.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_cluster_iso_with_http_info(cluster_id, image_create_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose ISO should be generated. (required)
        :param ImageCreateParams image_create_params: The parameters for the generated ISO. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'image_create_params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_cluster_iso" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `generate_cluster_iso`")  # noqa: E501
        # verify the required parameter 'image_create_params' is set
        if ('image_create_params' not in params or
                params['image_create_params'] is None):
            raise ValueError("Missing the required parameter `image_create_params` when calling `generate_cluster_iso`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'image_create_params' in params:
            body_params = params['image_create_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/downloads/image', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cluster(self, cluster_id, **kwargs):  # noqa: E501
        """get_cluster  # noqa: E501

        Retrieves the details of the OpenShift cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cluster(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to be retrieved. (required)
        :param str discovery_agent_version: The software version of the discovery agent that is retrieving the cluster details.
        :param bool get_unregistered_clusters: Whether to return clusters that have been unregistered.
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cluster_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cluster_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def get_cluster_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """get_cluster  # noqa: E501

        Retrieves the details of the OpenShift cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cluster_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to be retrieved. (required)
        :param str discovery_agent_version: The software version of the discovery agent that is retrieving the cluster details.
        :param bool get_unregistered_clusters: Whether to return clusters that have been unregistered.
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'discovery_agent_version', 'get_unregistered_clusters']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `get_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'discovery_agent_version' in params:
            header_params['discovery_agent_version'] = params['discovery_agent_version']  # noqa: E501
        if 'get_unregistered_clusters' in params:
            header_params['get_unregistered_clusters'] = params['get_unregistered_clusters']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth', 'userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cluster_default_config(self, **kwargs):  # noqa: E501
        """get_cluster_default_config  # noqa: E501

        Get the default values for various cluster properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cluster_default_config(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ClusterDefaultConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cluster_default_config_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_cluster_default_config_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_cluster_default_config_with_http_info(self, **kwargs):  # noqa: E501
        """get_cluster_default_config  # noqa: E501

        Get the default values for various cluster properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cluster_default_config_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ClusterDefaultConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cluster_default_config" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/default-config', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClusterDefaultConfig',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cluster_host_requirements(self, cluster_id, **kwargs):  # noqa: E501
        """get_cluster_host_requirements  # noqa: E501

        Get host requirements of a cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cluster_host_requirements(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to return operators for. (required)
        :return: ClusterHostRequirementsList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cluster_host_requirements_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cluster_host_requirements_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def get_cluster_host_requirements_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """get_cluster_host_requirements  # noqa: E501

        Get host requirements of a cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cluster_host_requirements_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to return operators for. (required)
        :return: ClusterHostRequirementsList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cluster_host_requirements" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `get_cluster_host_requirements`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/host-requirements', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClusterHostRequirementsList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cluster_install_config(self, cluster_id, **kwargs):  # noqa: E501
        """get_cluster_install_config  # noqa: E501

        Get the cluster's install config YAML.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cluster_install_config(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose install config is being retrieved. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cluster_install_config_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cluster_install_config_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def get_cluster_install_config_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """get_cluster_install_config  # noqa: E501

        Get the cluster's install config YAML.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cluster_install_config_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose install config is being retrieved. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cluster_install_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `get_cluster_install_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/install-config', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cluster_supported_platforms(self, cluster_id, **kwargs):  # noqa: E501
        """get_cluster_supported_platforms  # noqa: E501

        A list of platforms that this cluster can support in its current configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cluster_supported_platforms(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose platform types should be retrieved. (required)
        :return: list[PlatformType]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cluster_supported_platforms_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cluster_supported_platforms_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def get_cluster_supported_platforms_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """get_cluster_supported_platforms  # noqa: E501

        A list of platforms that this cluster can support in its current configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cluster_supported_platforms_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose platform types should be retrieved. (required)
        :return: list[PlatformType]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cluster_supported_platforms" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `get_cluster_supported_platforms`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/clusters/{cluster_id}/supported-platforms', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PlatformType]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_credentials(self, cluster_id, **kwargs):  # noqa: E501
        """get_credentials  # noqa: E501

        Get the cluster admin credentials.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_credentials(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose admin credentials should be retrieved. (required)
        :return: Credentials
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_credentials_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_credentials_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def get_credentials_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """get_credentials  # noqa: E501

        Get the cluster admin credentials.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_credentials_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose admin credentials should be retrieved. (required)
        :return: Credentials
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_credentials" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `get_credentials`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/credentials', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Credentials',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_discovery_ignition(self, cluster_id, **kwargs):  # noqa: E501
        """get_discovery_ignition  # noqa: E501

        Get the discovery ignition for the cluster based on its attributes and overridden ignition value before generating the discovery ISO. Used to test the validity of the discovery ignition when it is being overridden. For downloading the generated discovery ignition use /clusters/$CLUSTER_ID/downloads/files?file_name=discovery.ign   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_discovery_ignition(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster for which the discovery ignition config should be retrieved. (required)
        :return: DiscoveryIgnitionParams
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_discovery_ignition_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_discovery_ignition_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def get_discovery_ignition_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """get_discovery_ignition  # noqa: E501

        Get the discovery ignition for the cluster based on its attributes and overridden ignition value before generating the discovery ISO. Used to test the validity of the discovery ignition when it is being overridden. For downloading the generated discovery ignition use /clusters/$CLUSTER_ID/downloads/files?file_name=discovery.ign   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_discovery_ignition_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster for which the discovery ignition config should be retrieved. (required)
        :return: DiscoveryIgnitionParams
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_discovery_ignition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `get_discovery_ignition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/discovery-ignition', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DiscoveryIgnitionParams',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_free_addresses(self, cluster_id, network, **kwargs):  # noqa: E501
        """get_free_addresses  # noqa: E501

        Retrieves the free address list for a network.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_free_addresses(cluster_id, network, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to return free addresses for. (required)
        :param str network: The cluster network to return free addresses for. (required)
        :param int limit: The maximum number of free addresses to return.
        :param str prefix: A prefix for the free addresses to return.
        :return: FreeAddressesList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_free_addresses_with_http_info(cluster_id, network, **kwargs)  # noqa: E501
        else:
            (data) = self.get_free_addresses_with_http_info(cluster_id, network, **kwargs)  # noqa: E501
            return data

    def get_free_addresses_with_http_info(self, cluster_id, network, **kwargs):  # noqa: E501
        """get_free_addresses  # noqa: E501

        Retrieves the free address list for a network.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_free_addresses_with_http_info(cluster_id, network, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to return free addresses for. (required)
        :param str network: The cluster network to return free addresses for. (required)
        :param int limit: The maximum number of free addresses to return.
        :param str prefix: A prefix for the free addresses to return.
        :return: FreeAddressesList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'network', 'limit', 'prefix']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_free_addresses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `get_free_addresses`")  # noqa: E501
        # verify the required parameter 'network' is set
        if ('network' not in params or
                params['network'] is None):
            raise ValueError("Missing the required parameter `network` when calling `get_free_addresses`")  # noqa: E501

        if 'limit' in params and params['limit'] > 8000:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_free_addresses`, must be a value less than or equal to `8000`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_free_addresses`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []
        if 'network' in params:
            query_params.append(('network', params['network']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'prefix' in params:
            query_params.append(('prefix', params['prefix']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/free_addresses', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FreeAddressesList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_host(self, cluster_id, host_id, **kwargs):  # noqa: E501
        """get_host  # noqa: E501

        Retrieves the details of the OpenShift host.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_host(cluster_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster of the host that should be retrieved. (required)
        :param str host_id: The host that should be retrieved. (required)
        :return: Host
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_host_with_http_info(cluster_id, host_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_host_with_http_info(cluster_id, host_id, **kwargs)  # noqa: E501
            return data

    def get_host_with_http_info(self, cluster_id, host_id, **kwargs):  # noqa: E501
        """get_host  # noqa: E501

        Retrieves the details of the OpenShift host.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_host_with_http_info(cluster_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster of the host that should be retrieved. (required)
        :param str host_id: The host that should be retrieved. (required)
        :return: Host
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'host_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_host" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `get_host`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `get_host`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/hosts/{host_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Host',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_host_ignition(self, cluster_id, host_id, **kwargs):  # noqa: E501
        """get_host_ignition  # noqa: E501

        Get the customized ignition file for this host as a string  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_host_ignition(cluster_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster of the host whose customized ignition file should be retrieved. (required)
        :param str host_id: The host whose customized ignition file should be retrieved. (required)
        :return: HostIgnitionParams
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_host_ignition_with_http_info(cluster_id, host_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_host_ignition_with_http_info(cluster_id, host_id, **kwargs)  # noqa: E501
            return data

    def get_host_ignition_with_http_info(self, cluster_id, host_id, **kwargs):  # noqa: E501
        """get_host_ignition  # noqa: E501

        Get the customized ignition file for this host as a string  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_host_ignition_with_http_info(cluster_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster of the host whose customized ignition file should be retrieved. (required)
        :param str host_id: The host whose customized ignition file should be retrieved. (required)
        :return: HostIgnitionParams
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'host_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_host_ignition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `get_host_ignition`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `get_host_ignition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/hosts/{host_id}/ignition', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HostIgnitionParams',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_infra_env(self, infra_env_id, **kwargs):  # noqa: E501
        """get_infra_env  # noqa: E501

        Retrieves the details of the InfraEnv.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_infra_env(infra_env_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv to be retrieved. (required)
        :return: InfraEnv
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_infra_env_with_http_info(infra_env_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_infra_env_with_http_info(infra_env_id, **kwargs)  # noqa: E501
            return data

    def get_infra_env_with_http_info(self, infra_env_id, **kwargs):  # noqa: E501
        """get_infra_env  # noqa: E501

        Retrieves the details of the InfraEnv.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_infra_env_with_http_info(infra_env_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv to be retrieved. (required)
        :return: InfraEnv
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['infra_env_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_infra_env" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'infra_env_id' is set
        if ('infra_env_id' not in params or
                params['infra_env_id'] is None):
            raise ValueError("Missing the required parameter `infra_env_id` when calling `get_infra_env`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'infra_env_id' in params:
            path_params['infra_env_id'] = params['infra_env_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth', 'userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/infra-envs/{infra_env_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InfraEnv',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_preflight_requirements(self, cluster_id, **kwargs):  # noqa: E501
        """get_preflight_requirements  # noqa: E501

        Get preflight requirements for a cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_preflight_requirements(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to return preflight requrements for. (required)
        :return: PreflightHardwareRequirements
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_preflight_requirements_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_preflight_requirements_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def get_preflight_requirements_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """get_preflight_requirements  # noqa: E501

        Get preflight requirements for a cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_preflight_requirements_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to return preflight requrements for. (required)
        :return: PreflightHardwareRequirements
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_preflight_requirements" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `get_preflight_requirements`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/preflight-requirements', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PreflightHardwareRequirements',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_presigned_for_cluster_files(self, cluster_id, file_name, **kwargs):  # noqa: E501
        """get_presigned_for_cluster_files  # noqa: E501

        Retrieves a pre-signed S3 URL for downloading cluster files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_presigned_for_cluster_files(cluster_id, file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster that owns the file that should be downloaded. (required)
        :param str file_name: The file to be downloaded. (required)
        :param str logs_type: If downloading logs, the type of logs to download.
        :param str host_id: If downloading a file related to a host, the relevant host.
        :param str additional_name: If downloading a manifest, the file name, prefaced with folder name, for example, openshift/99-openshift-xyz.yaml.
        :return: Presigned
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_presigned_for_cluster_files_with_http_info(cluster_id, file_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_presigned_for_cluster_files_with_http_info(cluster_id, file_name, **kwargs)  # noqa: E501
            return data

    def get_presigned_for_cluster_files_with_http_info(self, cluster_id, file_name, **kwargs):  # noqa: E501
        """get_presigned_for_cluster_files  # noqa: E501

        Retrieves a pre-signed S3 URL for downloading cluster files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_presigned_for_cluster_files_with_http_info(cluster_id, file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster that owns the file that should be downloaded. (required)
        :param str file_name: The file to be downloaded. (required)
        :param str logs_type: If downloading logs, the type of logs to download.
        :param str host_id: If downloading a file related to a host, the relevant host.
        :param str additional_name: If downloading a manifest, the file name, prefaced with folder name, for example, openshift/99-openshift-xyz.yaml.
        :return: Presigned
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'file_name', 'logs_type', 'host_id', 'additional_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_presigned_for_cluster_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `get_presigned_for_cluster_files`")  # noqa: E501
        # verify the required parameter 'file_name' is set
        if ('file_name' not in params or
                params['file_name'] is None):
            raise ValueError("Missing the required parameter `file_name` when calling `get_presigned_for_cluster_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []
        if 'file_name' in params:
            query_params.append(('file_name', params['file_name']))  # noqa: E501
        if 'logs_type' in params:
            query_params.append(('logs_type', params['logs_type']))  # noqa: E501
        if 'host_id' in params:
            query_params.append(('host_id', params['host_id']))  # noqa: E501
        if 'additional_name' in params:
            query_params.append(('additional_name', params['additional_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/downloads/files-presigned', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Presigned',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def install_cluster(self, cluster_id, **kwargs):  # noqa: E501
        """install_cluster  # noqa: E501

        Installs the OpenShift cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.install_cluster(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to be installed. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.install_cluster_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.install_cluster_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def install_cluster_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """install_cluster  # noqa: E501

        Installs the OpenShift cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.install_cluster_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to be installed. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method install_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `install_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/actions/install', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def install_host(self, cluster_id, host_id, **kwargs):  # noqa: E501
        """install_host  # noqa: E501

        install specific host for day2 cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.install_host(cluster_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster of the host that is being installed. (required)
        :param str host_id: The host that is being installed. (required)
        :return: Host
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.install_host_with_http_info(cluster_id, host_id, **kwargs)  # noqa: E501
        else:
            (data) = self.install_host_with_http_info(cluster_id, host_id, **kwargs)  # noqa: E501
            return data

    def install_host_with_http_info(self, cluster_id, host_id, **kwargs):  # noqa: E501
        """install_host  # noqa: E501

        install specific host for day2 cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.install_host_with_http_info(cluster_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster of the host that is being installed. (required)
        :param str host_id: The host that is being installed. (required)
        :return: Host
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'host_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method install_host" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `install_host`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `install_host`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/hosts/{host_id}/actions/install', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Host',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def install_hosts(self, cluster_id, **kwargs):  # noqa: E501
        """install_hosts  # noqa: E501

        Installs the OpenShift cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.install_hosts(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The existing cluster whose hosts should be added. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.install_hosts_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.install_hosts_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def install_hosts_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """install_hosts  # noqa: E501

        Installs the OpenShift cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.install_hosts_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The existing cluster whose hosts should be added. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method install_hosts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `install_hosts`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/actions/install_hosts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_clusters(self, **kwargs):  # noqa: E501
        """list_clusters  # noqa: E501

        Retrieves the list of OpenShift clusters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_clusters(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool get_unregistered_clusters: Whether to return clusters that have been unregistered.
        :param str openshift_cluster_id: A specific cluster to retrieve.
        :param list[str] ams_subscription_ids: If non-empty, returned Clusters are filtered to those with matching subscription IDs.
        :param bool with_hosts: Include hosts in the returned list.
        :return: ClusterList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_clusters_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_clusters_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_clusters_with_http_info(self, **kwargs):  # noqa: E501
        """list_clusters  # noqa: E501

        Retrieves the list of OpenShift clusters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_clusters_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool get_unregistered_clusters: Whether to return clusters that have been unregistered.
        :param str openshift_cluster_id: A specific cluster to retrieve.
        :param list[str] ams_subscription_ids: If non-empty, returned Clusters are filtered to those with matching subscription IDs.
        :param bool with_hosts: Include hosts in the returned list.
        :return: ClusterList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['get_unregistered_clusters', 'openshift_cluster_id', 'ams_subscription_ids', 'with_hosts']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_clusters" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'openshift_cluster_id' in params:
            query_params.append(('openshift_cluster_id', params['openshift_cluster_id']))  # noqa: E501
        if 'ams_subscription_ids' in params:
            query_params.append(('ams_subscription_ids', params['ams_subscription_ids']))  # noqa: E501
            collection_formats['ams_subscription_ids'] = 'csv'  # noqa: E501
        if 'with_hosts' in params:
            query_params.append(('with_hosts', params['with_hosts']))  # noqa: E501

        header_params = {}
        if 'get_unregistered_clusters' in params:
            header_params['get_unregistered_clusters'] = params['get_unregistered_clusters']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClusterList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_hosts(self, cluster_id, **kwargs):  # noqa: E501
        """list_hosts  # noqa: E501

        Retrieves the list of OpenShift hosts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_hosts(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose hosts should be listed. (required)
        :param str discovery_agent_version: The software version of the discovery agent that is listing hosts.
        :return: HostList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_hosts_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_hosts_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def list_hosts_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """list_hosts  # noqa: E501

        Retrieves the list of OpenShift hosts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_hosts_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose hosts should be listed. (required)
        :param str discovery_agent_version: The software version of the discovery agent that is listing hosts.
        :return: HostList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'discovery_agent_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_hosts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `list_hosts`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'discovery_agent_version' in params:
            header_params['discovery_agent_version'] = params['discovery_agent_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth', 'userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/hosts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HostList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_infra_envs(self, **kwargs):  # noqa: E501
        """list_infra_envs  # noqa: E501

        Retrieves the list of InfraEnvs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_infra_envs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InfraEnvList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_infra_envs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_infra_envs_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_infra_envs_with_http_info(self, **kwargs):  # noqa: E501
        """list_infra_envs  # noqa: E501

        Retrieves the list of InfraEnvs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_infra_envs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InfraEnvList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_infra_envs" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/infra-envs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InfraEnvList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_of_cluster_operators(self, cluster_id, **kwargs):  # noqa: E501
        """list_of_cluster_operators  # noqa: E501

        Lists operators to be monitored for a cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_of_cluster_operators(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to return operators for. (required)
        :param str operator_name: An operator in the specified cluster to return its data.
        :return: MonitoredOperatorsList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_of_cluster_operators_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_of_cluster_operators_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def list_of_cluster_operators_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """list_of_cluster_operators  # noqa: E501

        Lists operators to be monitored for a cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_of_cluster_operators_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to return operators for. (required)
        :param str operator_name: An operator in the specified cluster to return its data.
        :return: MonitoredOperatorsList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'operator_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_of_cluster_operators" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `list_of_cluster_operators`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []
        if 'operator_name' in params:
            query_params.append(('operator_name', params['operator_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/monitored_operators', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MonitoredOperatorsList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def register_add_hosts_cluster(self, new_add_hosts_cluster_params, **kwargs):  # noqa: E501
        """register_add_hosts_cluster  # noqa: E501

        Creates a new OpenShift cluster definition for adding nodes to and existing OCP cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_add_hosts_cluster(new_add_hosts_cluster_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddHostsClusterCreateParams new_add_hosts_cluster_params: Parameters for creating a new cluster for adding nodes. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.register_add_hosts_cluster_with_http_info(new_add_hosts_cluster_params, **kwargs)  # noqa: E501
        else:
            (data) = self.register_add_hosts_cluster_with_http_info(new_add_hosts_cluster_params, **kwargs)  # noqa: E501
            return data

    def register_add_hosts_cluster_with_http_info(self, new_add_hosts_cluster_params, **kwargs):  # noqa: E501
        """register_add_hosts_cluster  # noqa: E501

        Creates a new OpenShift cluster definition for adding nodes to and existing OCP cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_add_hosts_cluster_with_http_info(new_add_hosts_cluster_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddHostsClusterCreateParams new_add_hosts_cluster_params: Parameters for creating a new cluster for adding nodes. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['new_add_hosts_cluster_params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method register_add_hosts_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'new_add_hosts_cluster_params' is set
        if ('new_add_hosts_cluster_params' not in params or
                params['new_add_hosts_cluster_params'] is None):
            raise ValueError("Missing the required parameter `new_add_hosts_cluster_params` when calling `register_add_hosts_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'new_add_hosts_cluster_params' in params:
            body_params = params['new_add_hosts_cluster_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/add_hosts_clusters', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def register_cluster(self, new_cluster_params, **kwargs):  # noqa: E501
        """register_cluster  # noqa: E501

        Creates a new OpenShift cluster definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_cluster(new_cluster_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ClusterCreateParams new_cluster_params: The properties describing the new cluster. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.register_cluster_with_http_info(new_cluster_params, **kwargs)  # noqa: E501
        else:
            (data) = self.register_cluster_with_http_info(new_cluster_params, **kwargs)  # noqa: E501
            return data

    def register_cluster_with_http_info(self, new_cluster_params, **kwargs):  # noqa: E501
        """register_cluster  # noqa: E501

        Creates a new OpenShift cluster definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_cluster_with_http_info(new_cluster_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ClusterCreateParams new_cluster_params: The properties describing the new cluster. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['new_cluster_params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method register_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'new_cluster_params' is set
        if ('new_cluster_params' not in params or
                params['new_cluster_params'] is None):
            raise ValueError("Missing the required parameter `new_cluster_params` when calling `register_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'new_cluster_params' in params:
            body_params = params['new_cluster_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def register_infra_env(self, infraenv_create_params, **kwargs):  # noqa: E501
        """register_infra_env  # noqa: E501

        Creates a new OpenShift Discovery ISO.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_infra_env(infraenv_create_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InfraEnvCreateParams infraenv_create_params: The parameters for the generated ISO. (required)
        :return: InfraEnv
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.register_infra_env_with_http_info(infraenv_create_params, **kwargs)  # noqa: E501
        else:
            (data) = self.register_infra_env_with_http_info(infraenv_create_params, **kwargs)  # noqa: E501
            return data

    def register_infra_env_with_http_info(self, infraenv_create_params, **kwargs):  # noqa: E501
        """register_infra_env  # noqa: E501

        Creates a new OpenShift Discovery ISO.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_infra_env_with_http_info(infraenv_create_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InfraEnvCreateParams infraenv_create_params: The parameters for the generated ISO. (required)
        :return: InfraEnv
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['infraenv_create_params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method register_infra_env" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'infraenv_create_params' is set
        if ('infraenv_create_params' not in params or
                params['infraenv_create_params'] is None):
            raise ValueError("Missing the required parameter `infraenv_create_params` when calling `register_infra_env`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'infraenv_create_params' in params:
            body_params = params['infraenv_create_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/infra-envs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InfraEnv',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def report_monitored_operator_status(self, cluster_id, report_params, **kwargs):  # noqa: E501
        """report_monitored_operator_status  # noqa: E501

        Controller API to report of monitored operators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.report_monitored_operator_status(cluster_id, report_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose operators are being monitored. (required)
        :param OperatorMonitorReport report_params: The operators monitor report. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.report_monitored_operator_status_with_http_info(cluster_id, report_params, **kwargs)  # noqa: E501
        else:
            (data) = self.report_monitored_operator_status_with_http_info(cluster_id, report_params, **kwargs)  # noqa: E501
            return data

    def report_monitored_operator_status_with_http_info(self, cluster_id, report_params, **kwargs):  # noqa: E501
        """report_monitored_operator_status  # noqa: E501

        Controller API to report of monitored operators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.report_monitored_operator_status_with_http_info(cluster_id, report_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose operators are being monitored. (required)
        :param OperatorMonitorReport report_params: The operators monitor report. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'report_params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method report_monitored_operator_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `report_monitored_operator_status`")  # noqa: E501
        # verify the required parameter 'report_params' is set
        if ('report_params' not in params or
                params['report_params'] is None):
            raise ValueError("Missing the required parameter `report_params` when calling `report_monitored_operator_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'report_params' in params:
            body_params = params['report_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/monitored_operators', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reset_cluster(self, cluster_id, **kwargs):  # noqa: E501
        """reset_cluster  # noqa: E501

        Resets a failed installation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_cluster(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose installation is to be reset. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.reset_cluster_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.reset_cluster_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def reset_cluster_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """reset_cluster  # noqa: E501

        Resets a failed installation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_cluster_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose installation is to be reset. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `reset_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/actions/reset', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reset_host(self, cluster_id, host_id, **kwargs):  # noqa: E501
        """reset_host  # noqa: E501

        reset a failed host for day2 cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_host(cluster_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster of the host that is being reset. (required)
        :param str host_id: The host that is being reset. (required)
        :return: Host
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.reset_host_with_http_info(cluster_id, host_id, **kwargs)  # noqa: E501
        else:
            (data) = self.reset_host_with_http_info(cluster_id, host_id, **kwargs)  # noqa: E501
            return data

    def reset_host_with_http_info(self, cluster_id, host_id, **kwargs):  # noqa: E501
        """reset_host  # noqa: E501

        reset a failed host for day2 cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_host_with_http_info(cluster_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster of the host that is being reset. (required)
        :param str host_id: The host that is being reset. (required)
        :return: Host
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'host_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_host" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `reset_host`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `reset_host`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/hosts/{host_id}/actions/reset', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Host',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reset_host_validation(self, cluster_id, host_id, validation_id, **kwargs):  # noqa: E501
        """Reset failed host validation.  # noqa: E501

        Reset failed host validation.  It may be performed on any host validation with persistent validation result.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_host_validation(cluster_id, host_id, validation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster of the host that its validation is being reset. (required)
        :param str host_id: The host that its validation is being reset. (required)
        :param str validation_id: The id of the validation being reset. (required)
        :return: Host
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.reset_host_validation_with_http_info(cluster_id, host_id, validation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.reset_host_validation_with_http_info(cluster_id, host_id, validation_id, **kwargs)  # noqa: E501
            return data

    def reset_host_validation_with_http_info(self, cluster_id, host_id, validation_id, **kwargs):  # noqa: E501
        """Reset failed host validation.  # noqa: E501

        Reset failed host validation.  It may be performed on any host validation with persistent validation result.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reset_host_validation_with_http_info(cluster_id, host_id, validation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster of the host that its validation is being reset. (required)
        :param str host_id: The host that its validation is being reset. (required)
        :param str validation_id: The id of the validation being reset. (required)
        :return: Host
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'host_id', 'validation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_host_validation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `reset_host_validation`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `reset_host_validation`")  # noqa: E501
        # verify the required parameter 'validation_id' is set
        if ('validation_id' not in params or
                params['validation_id'] is None):
            raise ValueError("Missing the required parameter `validation_id` when calling `reset_host_validation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501
        if 'validation_id' in params:
            path_params['validation_id'] = params['validation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/hosts/{host_id}/actions/reset-validation/{validation_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Host',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def unbind_host(self, infra_env_id, host_id, **kwargs):  # noqa: E501
        """unbind_host  # noqa: E501

        Unbind host to a cluster  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unbind_host(infra_env_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The infra env of the host that is being bound. (required)
        :param str host_id: The host that is being bound. (required)
        :return: Host
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.unbind_host_with_http_info(infra_env_id, host_id, **kwargs)  # noqa: E501
        else:
            (data) = self.unbind_host_with_http_info(infra_env_id, host_id, **kwargs)  # noqa: E501
            return data

    def unbind_host_with_http_info(self, infra_env_id, host_id, **kwargs):  # noqa: E501
        """unbind_host  # noqa: E501

        Unbind host to a cluster  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.unbind_host_with_http_info(infra_env_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The infra env of the host that is being bound. (required)
        :param str host_id: The host that is being bound. (required)
        :return: Host
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['infra_env_id', 'host_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unbind_host" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'infra_env_id' is set
        if ('infra_env_id' not in params or
                params['infra_env_id'] is None):
            raise ValueError("Missing the required parameter `infra_env_id` when calling `unbind_host`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `unbind_host`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'infra_env_id' in params:
            path_params['infra_env_id'] = params['infra_env_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/infra-envs/{infra_env_id}/hosts/{host_id}/actions/unbind', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Host',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_cluster(self, cluster_id, cluster_update_params, **kwargs):  # noqa: E501
        """update_cluster  # noqa: E501

        Updates an OpenShift cluster definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_cluster(cluster_id, cluster_update_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to be updated. (required)
        :param ClusterUpdateParams cluster_update_params: The properties to update. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_cluster_with_http_info(cluster_id, cluster_update_params, **kwargs)  # noqa: E501
        else:
            (data) = self.update_cluster_with_http_info(cluster_id, cluster_update_params, **kwargs)  # noqa: E501
            return data

    def update_cluster_with_http_info(self, cluster_id, cluster_update_params, **kwargs):  # noqa: E501
        """update_cluster  # noqa: E501

        Updates an OpenShift cluster definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_cluster_with_http_info(cluster_id, cluster_update_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to be updated. (required)
        :param ClusterUpdateParams cluster_update_params: The properties to update. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'cluster_update_params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `update_cluster`")  # noqa: E501
        # verify the required parameter 'cluster_update_params' is set
        if ('cluster_update_params' not in params or
                params['cluster_update_params'] is None):
            raise ValueError("Missing the required parameter `cluster_update_params` when calling `update_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cluster_update_params' in params:
            body_params = params['cluster_update_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_cluster_install_config(self, cluster_id, install_config_params, **kwargs):  # noqa: E501
        """update_cluster_install_config  # noqa: E501

        Override values in the install config.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_cluster_install_config(cluster_id, install_config_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose install config is being updated. (required)
        :param str install_config_params: Install config overrides. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_cluster_install_config_with_http_info(cluster_id, install_config_params, **kwargs)  # noqa: E501
        else:
            (data) = self.update_cluster_install_config_with_http_info(cluster_id, install_config_params, **kwargs)  # noqa: E501
            return data

    def update_cluster_install_config_with_http_info(self, cluster_id, install_config_params, **kwargs):  # noqa: E501
        """update_cluster_install_config  # noqa: E501

        Override values in the install config.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_cluster_install_config_with_http_info(cluster_id, install_config_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose install config is being updated. (required)
        :param str install_config_params: Install config overrides. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'install_config_params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_cluster_install_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `update_cluster_install_config`")  # noqa: E501
        # verify the required parameter 'install_config_params' is set
        if ('install_config_params' not in params or
                params['install_config_params'] is None):
            raise ValueError("Missing the required parameter `install_config_params` when calling `update_cluster_install_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'install_config_params' in params:
            body_params = params['install_config_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/install-config', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_cluster_logs_progress(self, cluster_id, logs_progress_params, **kwargs):  # noqa: E501
        """update_cluster_logs_progress  # noqa: E501

        Update log collection state and progress.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_cluster_logs_progress(cluster_id, logs_progress_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose log progress is being updated. (required)
        :param LogsProgressParams logs_progress_params: Parameters for updating log progress. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_cluster_logs_progress_with_http_info(cluster_id, logs_progress_params, **kwargs)  # noqa: E501
        else:
            (data) = self.update_cluster_logs_progress_with_http_info(cluster_id, logs_progress_params, **kwargs)  # noqa: E501
            return data

    def update_cluster_logs_progress_with_http_info(self, cluster_id, logs_progress_params, **kwargs):  # noqa: E501
        """update_cluster_logs_progress  # noqa: E501

        Update log collection state and progress.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_cluster_logs_progress_with_http_info(cluster_id, logs_progress_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose log progress is being updated. (required)
        :param LogsProgressParams logs_progress_params: Parameters for updating log progress. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'logs_progress_params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_cluster_logs_progress" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `update_cluster_logs_progress`")  # noqa: E501
        # verify the required parameter 'logs_progress_params' is set
        if ('logs_progress_params' not in params or
                params['logs_progress_params'] is None):
            raise ValueError("Missing the required parameter `logs_progress_params` when calling `update_cluster_logs_progress`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'logs_progress_params' in params:
            body_params = params['logs_progress_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/logs_progress', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_discovery_ignition(self, cluster_id, discovery_ignition_params, **kwargs):  # noqa: E501
        """update_discovery_ignition  # noqa: E501

        Override values in the discovery ignition config.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_discovery_ignition(cluster_id, discovery_ignition_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster for which the discovery ignition config should be updated. (required)
        :param DiscoveryIgnitionParams discovery_ignition_params: Overrides for the discovery ignition config. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_discovery_ignition_with_http_info(cluster_id, discovery_ignition_params, **kwargs)  # noqa: E501
        else:
            (data) = self.update_discovery_ignition_with_http_info(cluster_id, discovery_ignition_params, **kwargs)  # noqa: E501
            return data

    def update_discovery_ignition_with_http_info(self, cluster_id, discovery_ignition_params, **kwargs):  # noqa: E501
        """update_discovery_ignition  # noqa: E501

        Override values in the discovery ignition config.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_discovery_ignition_with_http_info(cluster_id, discovery_ignition_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster for which the discovery ignition config should be updated. (required)
        :param DiscoveryIgnitionParams discovery_ignition_params: Overrides for the discovery ignition config. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'discovery_ignition_params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_discovery_ignition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `update_discovery_ignition`")  # noqa: E501
        # verify the required parameter 'discovery_ignition_params' is set
        if ('discovery_ignition_params' not in params or
                params['discovery_ignition_params'] is None):
            raise ValueError("Missing the required parameter `discovery_ignition_params` when calling `update_discovery_ignition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'discovery_ignition_params' in params:
            body_params = params['discovery_ignition_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/discovery-ignition', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_host_ignition(self, cluster_id, host_id, host_ignition_params, **kwargs):  # noqa: E501
        """update_host_ignition  # noqa: E501

        Patch the ignition file for this host  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_host_ignition(cluster_id, host_id, host_ignition_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster of the host whose ignition file should be updated. (required)
        :param str host_id: The host whose ignition file should be updated. (required)
        :param HostIgnitionParams host_ignition_params: Ignition config overrides. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_host_ignition_with_http_info(cluster_id, host_id, host_ignition_params, **kwargs)  # noqa: E501
        else:
            (data) = self.update_host_ignition_with_http_info(cluster_id, host_id, host_ignition_params, **kwargs)  # noqa: E501
            return data

    def update_host_ignition_with_http_info(self, cluster_id, host_id, host_ignition_params, **kwargs):  # noqa: E501
        """update_host_ignition  # noqa: E501

        Patch the ignition file for this host  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_host_ignition_with_http_info(cluster_id, host_id, host_ignition_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster of the host whose ignition file should be updated. (required)
        :param str host_id: The host whose ignition file should be updated. (required)
        :param HostIgnitionParams host_ignition_params: Ignition config overrides. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'host_id', 'host_ignition_params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_host_ignition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `update_host_ignition`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `update_host_ignition`")  # noqa: E501
        # verify the required parameter 'host_ignition_params' is set
        if ('host_ignition_params' not in params or
                params['host_ignition_params'] is None):
            raise ValueError("Missing the required parameter `host_ignition_params` when calling `update_host_ignition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'host_ignition_params' in params:
            body_params = params['host_ignition_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/hosts/{host_id}/ignition', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_host_install_progress(self, cluster_id, host_id, host_progress, **kwargs):  # noqa: E501
        """update_host_install_progress  # noqa: E501

        Update installation progress.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_host_install_progress(cluster_id, host_id, host_progress, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The ID of the cluster to retrieve. (required)
        :param str host_id: The ID of the host to retrieve. (required)
        :param HostProgress host_progress: New progress value. (required)
        :param str discovery_agent_version: The software version of the discovery agent that is updating progress.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_host_install_progress_with_http_info(cluster_id, host_id, host_progress, **kwargs)  # noqa: E501
        else:
            (data) = self.update_host_install_progress_with_http_info(cluster_id, host_id, host_progress, **kwargs)  # noqa: E501
            return data

    def update_host_install_progress_with_http_info(self, cluster_id, host_id, host_progress, **kwargs):  # noqa: E501
        """update_host_install_progress  # noqa: E501

        Update installation progress.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_host_install_progress_with_http_info(cluster_id, host_id, host_progress, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The ID of the cluster to retrieve. (required)
        :param str host_id: The ID of the host to retrieve. (required)
        :param HostProgress host_progress: New progress value. (required)
        :param str discovery_agent_version: The software version of the discovery agent that is updating progress.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'host_id', 'host_progress', 'discovery_agent_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_host_install_progress" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `update_host_install_progress`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `update_host_install_progress`")  # noqa: E501
        # verify the required parameter 'host_progress' is set
        if ('host_progress' not in params or
                params['host_progress'] is None):
            raise ValueError("Missing the required parameter `host_progress` when calling `update_host_install_progress`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'discovery_agent_version' in params:
            header_params['discovery_agent_version'] = params['discovery_agent_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'host_progress' in params:
            body_params = params['host_progress']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/hosts/{host_id}/progress', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_host_installer_args(self, cluster_id, host_id, installer_args_params, **kwargs):  # noqa: E501
        """update_host_installer_args  # noqa: E501

        Updates a host's installer arguments.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_host_installer_args(cluster_id, host_id, installer_args_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster of the host whose installer arguments should be updated. (required)
        :param str host_id: The host whose installer arguments should be updated. (required)
        :param InstallerArgsParams installer_args_params: The updated installer arguments. (required)
        :return: Host
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_host_installer_args_with_http_info(cluster_id, host_id, installer_args_params, **kwargs)  # noqa: E501
        else:
            (data) = self.update_host_installer_args_with_http_info(cluster_id, host_id, installer_args_params, **kwargs)  # noqa: E501
            return data

    def update_host_installer_args_with_http_info(self, cluster_id, host_id, installer_args_params, **kwargs):  # noqa: E501
        """update_host_installer_args  # noqa: E501

        Updates a host's installer arguments.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_host_installer_args_with_http_info(cluster_id, host_id, installer_args_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster of the host whose installer arguments should be updated. (required)
        :param str host_id: The host whose installer arguments should be updated. (required)
        :param InstallerArgsParams installer_args_params: The updated installer arguments. (required)
        :return: Host
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'host_id', 'installer_args_params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_host_installer_args" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `update_host_installer_args`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `update_host_installer_args`")  # noqa: E501
        # verify the required parameter 'installer_args_params' is set
        if ('installer_args_params' not in params or
                params['installer_args_params'] is None):
            raise ValueError("Missing the required parameter `installer_args_params` when calling `update_host_installer_args`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'installer_args_params' in params:
            body_params = params['installer_args_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/hosts/{host_id}/installer-args', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Host',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_host_logs_progress(self, cluster_id, host_id, logs_progress_params, **kwargs):  # noqa: E501
        """update_host_logs_progress  # noqa: E501

        Update log collection state and progress.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_host_logs_progress(cluster_id, host_id, logs_progress_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose log progress is being updated. (required)
        :param str host_id: The host whose log progress is being updated. (required)
        :param LogsProgressParams logs_progress_params: Parameters for updating log progress. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_host_logs_progress_with_http_info(cluster_id, host_id, logs_progress_params, **kwargs)  # noqa: E501
        else:
            (data) = self.update_host_logs_progress_with_http_info(cluster_id, host_id, logs_progress_params, **kwargs)  # noqa: E501
            return data

    def update_host_logs_progress_with_http_info(self, cluster_id, host_id, logs_progress_params, **kwargs):  # noqa: E501
        """update_host_logs_progress  # noqa: E501

        Update log collection state and progress.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_host_logs_progress_with_http_info(cluster_id, host_id, logs_progress_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose log progress is being updated. (required)
        :param str host_id: The host whose log progress is being updated. (required)
        :param LogsProgressParams logs_progress_params: Parameters for updating log progress. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'host_id', 'logs_progress_params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_host_logs_progress" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `update_host_logs_progress`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `update_host_logs_progress`")  # noqa: E501
        # verify the required parameter 'logs_progress_params' is set
        if ('logs_progress_params' not in params or
                params['logs_progress_params'] is None):
            raise ValueError("Missing the required parameter `logs_progress_params` when calling `update_host_logs_progress`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'logs_progress_params' in params:
            body_params = params['logs_progress_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/hosts/{host_id}/logs_progress', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_infra_env(self, infra_env_id, infra_env_update_params, **kwargs):  # noqa: E501
        """update_infra_env  # noqa: E501

        Updates an InfraEnv.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_infra_env(infra_env_id, infra_env_update_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv to be updated. (required)
        :param InfraEnvUpdateParams infra_env_update_params: The properties to update. (required)
        :return: InfraEnv
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_infra_env_with_http_info(infra_env_id, infra_env_update_params, **kwargs)  # noqa: E501
        else:
            (data) = self.update_infra_env_with_http_info(infra_env_id, infra_env_update_params, **kwargs)  # noqa: E501
            return data

    def update_infra_env_with_http_info(self, infra_env_id, infra_env_update_params, **kwargs):  # noqa: E501
        """update_infra_env  # noqa: E501

        Updates an InfraEnv.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_infra_env_with_http_info(infra_env_id, infra_env_update_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv to be updated. (required)
        :param InfraEnvUpdateParams infra_env_update_params: The properties to update. (required)
        :return: InfraEnv
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['infra_env_id', 'infra_env_update_params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_infra_env" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'infra_env_id' is set
        if ('infra_env_id' not in params or
                params['infra_env_id'] is None):
            raise ValueError("Missing the required parameter `infra_env_id` when calling `update_infra_env`")  # noqa: E501
        # verify the required parameter 'infra_env_update_params' is set
        if ('infra_env_update_params' not in params or
                params['infra_env_update_params'] is None):
            raise ValueError("Missing the required parameter `infra_env_update_params` when calling `update_infra_env`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'infra_env_id' in params:
            path_params['infra_env_id'] = params['infra_env_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'infra_env_update_params' in params:
            body_params = params['infra_env_update_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/infra-envs/{infra_env_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InfraEnv',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_cluster_ingress_cert(self, cluster_id, ingress_cert_params, **kwargs):  # noqa: E501
        """upload_cluster_ingress_cert  # noqa: E501

        Transfer the ingress certificate for the cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_cluster_ingress_cert(cluster_id, ingress_cert_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to associate with the ingress certificate. (required)
        :param IngressCertParams ingress_cert_params: The ingress certificate. (required)
        :param str discovery_agent_version: The software version of the discovery agent that is uploading the ingress certificate.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_cluster_ingress_cert_with_http_info(cluster_id, ingress_cert_params, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_cluster_ingress_cert_with_http_info(cluster_id, ingress_cert_params, **kwargs)  # noqa: E501
            return data

    def upload_cluster_ingress_cert_with_http_info(self, cluster_id, ingress_cert_params, **kwargs):  # noqa: E501
        """upload_cluster_ingress_cert  # noqa: E501

        Transfer the ingress certificate for the cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_cluster_ingress_cert_with_http_info(cluster_id, ingress_cert_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to associate with the ingress certificate. (required)
        :param IngressCertParams ingress_cert_params: The ingress certificate. (required)
        :param str discovery_agent_version: The software version of the discovery agent that is uploading the ingress certificate.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'ingress_cert_params', 'discovery_agent_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_cluster_ingress_cert" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `upload_cluster_ingress_cert`")  # noqa: E501
        # verify the required parameter 'ingress_cert_params' is set
        if ('ingress_cert_params' not in params or
                params['ingress_cert_params'] is None):
            raise ValueError("Missing the required parameter `ingress_cert_params` when calling `upload_cluster_ingress_cert`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'discovery_agent_version' in params:
            header_params['discovery_agent_version'] = params['discovery_agent_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ingress_cert_params' in params:
            body_params = params['ingress_cert_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/uploads/ingress-cert', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_host_logs(self, cluster_id, host_id, **kwargs):  # noqa: E501
        """upload_host_logs  # noqa: E501

        Agent API to upload logs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_host_logs(cluster_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster of the host whose logs should be uploaded. (required)
        :param str host_id: The host whose logs should be uploaded. (required)
        :param file upfile: The log file to be uploaded.
        :param str discovery_agent_version: The software version of the discovery agent that is uploading the logs.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_host_logs_with_http_info(cluster_id, host_id, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_host_logs_with_http_info(cluster_id, host_id, **kwargs)  # noqa: E501
            return data

    def upload_host_logs_with_http_info(self, cluster_id, host_id, **kwargs):  # noqa: E501
        """upload_host_logs  # noqa: E501

        Agent API to upload logs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_host_logs_with_http_info(cluster_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster of the host whose logs should be uploaded. (required)
        :param str host_id: The host whose logs should be uploaded. (required)
        :param file upfile: The log file to be uploaded.
        :param str discovery_agent_version: The software version of the discovery agent that is uploading the logs.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'host_id', 'upfile', 'discovery_agent_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_host_logs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `upload_host_logs`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `upload_host_logs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'discovery_agent_version' in params:
            header_params['discovery_agent_version'] = params['discovery_agent_version']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'upfile' in params:
            local_var_files['upfile'] = params['upfile']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/hosts/{host_id}/logs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_logs(self, cluster_id, logs_type, **kwargs):  # noqa: E501
        """upload_logs  # noqa: E501

        Agent API to upload logs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_logs(cluster_id, logs_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose logs should be uploaded. (required)
        :param str logs_type: The type of log file to be uploaded. (required)
        :param file upfile: The log file to be uploaded.
        :param str host_id: The host whose logs should be uploaded.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_logs_with_http_info(cluster_id, logs_type, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_logs_with_http_info(cluster_id, logs_type, **kwargs)  # noqa: E501
            return data

    def upload_logs_with_http_info(self, cluster_id, logs_type, **kwargs):  # noqa: E501
        """upload_logs  # noqa: E501

        Agent API to upload logs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_logs_with_http_info(cluster_id, logs_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose logs should be uploaded. (required)
        :param str logs_type: The type of log file to be uploaded. (required)
        :param file upfile: The log file to be uploaded.
        :param str host_id: The host whose logs should be uploaded.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'logs_type', 'upfile', 'host_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_logs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `upload_logs`")  # noqa: E501
        # verify the required parameter 'logs_type' is set
        if ('logs_type' not in params or
                params['logs_type'] is None):
            raise ValueError("Missing the required parameter `logs_type` when calling `upload_logs`")  # noqa: E501

        if ('upfile' in params and
                len(params['upfile']) > 104857600):
            raise ValueError("Invalid value for parameter `upfile` when calling `upload_logs`, length must be less than or equal to `104857600`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []
        if 'logs_type' in params:
            query_params.append(('logs_type', params['logs_type']))  # noqa: E501
        if 'host_id' in params:
            query_params.append(('host_id', params['host_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'upfile' in params:
            local_var_files['upfile'] = params['upfile']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/logs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_cancel_installation(self, cluster_id, **kwargs):  # noqa: E501
        """v2_cancel_installation  # noqa: E501

        Cancels an ongoing installation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_cancel_installation(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose installation is to be canceled. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_cancel_installation_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_cancel_installation_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def v2_cancel_installation_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """v2_cancel_installation  # noqa: E501

        Cancels an ongoing installation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_cancel_installation_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose installation is to be canceled. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_cancel_installation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `v2_cancel_installation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/clusters/{cluster_id}/actions/cancel', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_complete_installation(self, cluster_id, completion_params, **kwargs):  # noqa: E501
        """v2_complete_installation  # noqa: E501

        Agent API to mark a finalizing installation as complete.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_complete_installation(cluster_id, completion_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose installation is being completing. (required)
        :param CompletionParams completion_params: The final status of the cluster installation. (required)
        :param str discovery_agent_version: The software version of the discovery agent that is completing the installation.
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_complete_installation_with_http_info(cluster_id, completion_params, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_complete_installation_with_http_info(cluster_id, completion_params, **kwargs)  # noqa: E501
            return data

    def v2_complete_installation_with_http_info(self, cluster_id, completion_params, **kwargs):  # noqa: E501
        """v2_complete_installation  # noqa: E501

        Agent API to mark a finalizing installation as complete.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_complete_installation_with_http_info(cluster_id, completion_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose installation is being completing. (required)
        :param CompletionParams completion_params: The final status of the cluster installation. (required)
        :param str discovery_agent_version: The software version of the discovery agent that is completing the installation.
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'completion_params', 'discovery_agent_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_complete_installation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `v2_complete_installation`")  # noqa: E501
        # verify the required parameter 'completion_params' is set
        if ('completion_params' not in params or
                params['completion_params'] is None):
            raise ValueError("Missing the required parameter `completion_params` when calling `v2_complete_installation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'discovery_agent_version' in params:
            header_params['discovery_agent_version'] = params['discovery_agent_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'completion_params' in params:
            body_params = params['completion_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/clusters/{cluster_id}/actions/complete-installation', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_deregister_cluster(self, cluster_id, **kwargs):  # noqa: E501
        """v2_deregister_cluster  # noqa: E501

        Deletes an OpenShift cluster definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_deregister_cluster(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to be deregistered. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_deregister_cluster_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_deregister_cluster_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def v2_deregister_cluster_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """v2_deregister_cluster  # noqa: E501

        Deletes an OpenShift cluster definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_deregister_cluster_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to be deregistered. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_deregister_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `v2_deregister_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/clusters/{cluster_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_deregister_host(self, infra_env_id, host_id, **kwargs):  # noqa: E501
        """v2_deregister_host  # noqa: E501

        Deregisters an OpenShift host.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_deregister_host(infra_env_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The infra env of the host that should be deregistered. (required)
        :param str host_id: The host that should be deregistered. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_deregister_host_with_http_info(infra_env_id, host_id, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_deregister_host_with_http_info(infra_env_id, host_id, **kwargs)  # noqa: E501
            return data

    def v2_deregister_host_with_http_info(self, infra_env_id, host_id, **kwargs):  # noqa: E501
        """v2_deregister_host  # noqa: E501

        Deregisters an OpenShift host.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_deregister_host_with_http_info(infra_env_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The infra env of the host that should be deregistered. (required)
        :param str host_id: The host that should be deregistered. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['infra_env_id', 'host_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_deregister_host" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'infra_env_id' is set
        if ('infra_env_id' not in params or
                params['infra_env_id'] is None):
            raise ValueError("Missing the required parameter `infra_env_id` when calling `v2_deregister_host`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `v2_deregister_host`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'infra_env_id' in params:
            path_params['infra_env_id'] = params['infra_env_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/infra-envs/{infra_env_id}/hosts/{host_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_download_cluster_credentials(self, cluster_id, file_name, **kwargs):  # noqa: E501
        """v2_download_cluster_credentials  # noqa: E501

        Downloads credentials relating to the installed/installing cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_download_cluster_credentials(cluster_id, file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster that owns the credential file that should be downloaded. (required)
        :param str file_name: The credential file to be downloaded. (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_download_cluster_credentials_with_http_info(cluster_id, file_name, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_download_cluster_credentials_with_http_info(cluster_id, file_name, **kwargs)  # noqa: E501
            return data

    def v2_download_cluster_credentials_with_http_info(self, cluster_id, file_name, **kwargs):  # noqa: E501
        """v2_download_cluster_credentials  # noqa: E501

        Downloads credentials relating to the installed/installing cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_download_cluster_credentials_with_http_info(cluster_id, file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster that owns the credential file that should be downloaded. (required)
        :param str file_name: The credential file to be downloaded. (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'file_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_download_cluster_credentials" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `v2_download_cluster_credentials`")  # noqa: E501
        # verify the required parameter 'file_name' is set
        if ('file_name' not in params or
                params['file_name'] is None):
            raise ValueError("Missing the required parameter `file_name` when calling `v2_download_cluster_credentials`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []
        if 'file_name' in params:
            query_params.append(('file_name', params['file_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth', 'urlAuth', 'userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/clusters/{cluster_id}/downloads/credentials', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_download_cluster_files(self, cluster_id, file_name, **kwargs):  # noqa: E501
        """v2_download_cluster_files  # noqa: E501

        Downloads files relating to the installed/installing cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_download_cluster_files(cluster_id, file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster that owns the file that should be downloaded. (required)
        :param str file_name: The file to be downloaded. (required)
        :param str discovery_agent_version: The software version of the discovery agent that is downloading the file.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_download_cluster_files_with_http_info(cluster_id, file_name, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_download_cluster_files_with_http_info(cluster_id, file_name, **kwargs)  # noqa: E501
            return data

    def v2_download_cluster_files_with_http_info(self, cluster_id, file_name, **kwargs):  # noqa: E501
        """v2_download_cluster_files  # noqa: E501

        Downloads files relating to the installed/installing cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_download_cluster_files_with_http_info(cluster_id, file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster that owns the file that should be downloaded. (required)
        :param str file_name: The file to be downloaded. (required)
        :param str discovery_agent_version: The software version of the discovery agent that is downloading the file.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'file_name', 'discovery_agent_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_download_cluster_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `v2_download_cluster_files`")  # noqa: E501
        # verify the required parameter 'file_name' is set
        if ('file_name' not in params or
                params['file_name'] is None):
            raise ValueError("Missing the required parameter `file_name` when calling `v2_download_cluster_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []
        if 'file_name' in params:
            query_params.append(('file_name', params['file_name']))  # noqa: E501

        header_params = {}
        if 'discovery_agent_version' in params:
            header_params['discovery_agent_version'] = params['discovery_agent_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth', 'urlAuth', 'userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/clusters/{cluster_id}/downloads/files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_download_cluster_logs(self, cluster_id, **kwargs):  # noqa: E501
        """v2_download_cluster_logs  # noqa: E501

        Download cluster logs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_download_cluster_logs(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose logs should be downloaded. (required)
        :param str logs_type: The type of logs to be downloaded.
        :param str host_id: A specific host in the cluster whose logs should be downloaded.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_download_cluster_logs_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_download_cluster_logs_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def v2_download_cluster_logs_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """v2_download_cluster_logs  # noqa: E501

        Download cluster logs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_download_cluster_logs_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose logs should be downloaded. (required)
        :param str logs_type: The type of logs to be downloaded.
        :param str host_id: A specific host in the cluster whose logs should be downloaded.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'logs_type', 'host_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_download_cluster_logs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `v2_download_cluster_logs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []
        if 'logs_type' in params:
            query_params.append(('logs_type', params['logs_type']))  # noqa: E501
        if 'host_id' in params:
            query_params.append(('host_id', params['host_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['urlAuth', 'userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/clusters/{cluster_id}/logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_download_host_ignition(self, infra_env_id, host_id, **kwargs):  # noqa: E501
        """v2_download_host_ignition  # noqa: E501

        Downloads the customized ignition file for this bound host, produces octet stream. For unbound host - error is returned  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_download_host_ignition(infra_env_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The infra-env of the host whose ignition file should be downloaded. (required)
        :param str host_id: The host whose ignition file should be downloaded. (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_download_host_ignition_with_http_info(infra_env_id, host_id, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_download_host_ignition_with_http_info(infra_env_id, host_id, **kwargs)  # noqa: E501
            return data

    def v2_download_host_ignition_with_http_info(self, infra_env_id, host_id, **kwargs):  # noqa: E501
        """v2_download_host_ignition  # noqa: E501

        Downloads the customized ignition file for this bound host, produces octet stream. For unbound host - error is returned  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_download_host_ignition_with_http_info(infra_env_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The infra-env of the host whose ignition file should be downloaded. (required)
        :param str host_id: The host whose ignition file should be downloaded. (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['infra_env_id', 'host_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_download_host_ignition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'infra_env_id' is set
        if ('infra_env_id' not in params or
                params['infra_env_id'] is None):
            raise ValueError("Missing the required parameter `infra_env_id` when calling `v2_download_host_ignition`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `v2_download_host_ignition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'infra_env_id' in params:
            path_params['infra_env_id'] = params['infra_env_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth', 'userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/infra-env/{infra_env_id}/hosts/{host_id}/downloads/ignition', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_download_infra_env_files(self, infra_env_id, file_name, **kwargs):  # noqa: E501
        """v2_download_infra_env_files  # noqa: E501

        Downloads the customized ignition file for this host  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_download_infra_env_files(infra_env_id, file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv whose file should be downloaded. (required)
        :param str file_name: The file to be downloaded. (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_download_infra_env_files_with_http_info(infra_env_id, file_name, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_download_infra_env_files_with_http_info(infra_env_id, file_name, **kwargs)  # noqa: E501
            return data

    def v2_download_infra_env_files_with_http_info(self, infra_env_id, file_name, **kwargs):  # noqa: E501
        """v2_download_infra_env_files  # noqa: E501

        Downloads the customized ignition file for this host  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_download_infra_env_files_with_http_info(infra_env_id, file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv whose file should be downloaded. (required)
        :param str file_name: The file to be downloaded. (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['infra_env_id', 'file_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_download_infra_env_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'infra_env_id' is set
        if ('infra_env_id' not in params or
                params['infra_env_id'] is None):
            raise ValueError("Missing the required parameter `infra_env_id` when calling `v2_download_infra_env_files`")  # noqa: E501
        # verify the required parameter 'file_name' is set
        if ('file_name' not in params or
                params['file_name'] is None):
            raise ValueError("Missing the required parameter `file_name` when calling `v2_download_infra_env_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'infra_env_id' in params:
            path_params['infra_env_id'] = params['infra_env_id']  # noqa: E501

        query_params = []
        if 'file_name' in params:
            query_params.append(('file_name', params['file_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth', 'urlAuth', 'userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/infra-envs/{infra_env_id}/downloads/files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_get_cluster(self, cluster_id, **kwargs):  # noqa: E501
        """v2_get_cluster  # noqa: E501

        Retrieves the details of the OpenShift cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_get_cluster(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to be retrieved. (required)
        :param str discovery_agent_version: The software version of the discovery agent that is retrieving the cluster details.
        :param bool get_unregistered_clusters: Whether to return clusters that have been unregistered.
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_get_cluster_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_get_cluster_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def v2_get_cluster_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """v2_get_cluster  # noqa: E501

        Retrieves the details of the OpenShift cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_get_cluster_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to be retrieved. (required)
        :param str discovery_agent_version: The software version of the discovery agent that is retrieving the cluster details.
        :param bool get_unregistered_clusters: Whether to return clusters that have been unregistered.
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'discovery_agent_version', 'get_unregistered_clusters']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_get_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `v2_get_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'discovery_agent_version' in params:
            header_params['discovery_agent_version'] = params['discovery_agent_version']  # noqa: E501
        if 'get_unregistered_clusters' in params:
            header_params['get_unregistered_clusters'] = params['get_unregistered_clusters']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth', 'userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/clusters/{cluster_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_get_cluster_default_config(self, **kwargs):  # noqa: E501
        """v2_get_cluster_default_config  # noqa: E501

        Get the default values for various cluster properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_get_cluster_default_config(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ClusterDefaultConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_get_cluster_default_config_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.v2_get_cluster_default_config_with_http_info(**kwargs)  # noqa: E501
            return data

    def v2_get_cluster_default_config_with_http_info(self, **kwargs):  # noqa: E501
        """v2_get_cluster_default_config  # noqa: E501

        Get the default values for various cluster properties.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_get_cluster_default_config_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ClusterDefaultConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_get_cluster_default_config" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/clusters/default-config', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClusterDefaultConfig',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_get_cluster_install_config(self, cluster_id, **kwargs):  # noqa: E501
        """v2_get_cluster_install_config  # noqa: E501

        Get the cluster's install config YAML.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_get_cluster_install_config(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose install config is being retrieved. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_get_cluster_install_config_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_get_cluster_install_config_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def v2_get_cluster_install_config_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """v2_get_cluster_install_config  # noqa: E501

        Get the cluster's install config YAML.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_get_cluster_install_config_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose install config is being retrieved. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_get_cluster_install_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `v2_get_cluster_install_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/clusters/{cluster_id}/install-config', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_get_credentials(self, cluster_id, **kwargs):  # noqa: E501
        """v2_get_credentials  # noqa: E501

        Get the cluster admin credentials.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_get_credentials(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose admin credentials should be retrieved. (required)
        :return: Credentials
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_get_credentials_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_get_credentials_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def v2_get_credentials_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """v2_get_credentials  # noqa: E501

        Get the cluster admin credentials.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_get_credentials_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose admin credentials should be retrieved. (required)
        :return: Credentials
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_get_credentials" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `v2_get_credentials`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/clusters/{cluster_id}/credentials', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Credentials',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_get_host(self, infra_env_id, host_id, **kwargs):  # noqa: E501
        """v2_get_host  # noqa: E501

        Retrieves the details of the OpenShift host.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_get_host(infra_env_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The infra env of the host that should be retrieved. (required)
        :param str host_id: The host that should be retrieved. (required)
        :return: Host
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_get_host_with_http_info(infra_env_id, host_id, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_get_host_with_http_info(infra_env_id, host_id, **kwargs)  # noqa: E501
            return data

    def v2_get_host_with_http_info(self, infra_env_id, host_id, **kwargs):  # noqa: E501
        """v2_get_host  # noqa: E501

        Retrieves the details of the OpenShift host.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_get_host_with_http_info(infra_env_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The infra env of the host that should be retrieved. (required)
        :param str host_id: The host that should be retrieved. (required)
        :return: Host
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['infra_env_id', 'host_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_get_host" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'infra_env_id' is set
        if ('infra_env_id' not in params or
                params['infra_env_id'] is None):
            raise ValueError("Missing the required parameter `infra_env_id` when calling `v2_get_host`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `v2_get_host`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'infra_env_id' in params:
            path_params['infra_env_id'] = params['infra_env_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/infra-envs/{infra_env_id}/hosts/{host_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Host',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_get_host_ignition(self, infra_env_id, host_id, **kwargs):  # noqa: E501
        """v2_get_host_ignition  # noqa: E501

        Fetch the ignition file for this host as a string. In case of unbound host produces an error  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_get_host_ignition(infra_env_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The infra env of the host whose ignition file should be obtained. (required)
        :param str host_id: The host whose ignition file should be obtained. (required)
        :return: HostIgnitionParams
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_get_host_ignition_with_http_info(infra_env_id, host_id, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_get_host_ignition_with_http_info(infra_env_id, host_id, **kwargs)  # noqa: E501
            return data

    def v2_get_host_ignition_with_http_info(self, infra_env_id, host_id, **kwargs):  # noqa: E501
        """v2_get_host_ignition  # noqa: E501

        Fetch the ignition file for this host as a string. In case of unbound host produces an error  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_get_host_ignition_with_http_info(infra_env_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The infra env of the host whose ignition file should be obtained. (required)
        :param str host_id: The host whose ignition file should be obtained. (required)
        :return: HostIgnitionParams
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['infra_env_id', 'host_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_get_host_ignition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'infra_env_id' is set
        if ('infra_env_id' not in params or
                params['infra_env_id'] is None):
            raise ValueError("Missing the required parameter `infra_env_id` when calling `v2_get_host_ignition`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `v2_get_host_ignition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'infra_env_id' in params:
            path_params['infra_env_id'] = params['infra_env_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/infra-envs/{infra_env_id}/hosts/{host_id}/ignition', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HostIgnitionParams',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_get_next_steps(self, infra_env_id, host_id, **kwargs):  # noqa: E501
        """v2_get_next_steps  # noqa: E501

        Retrieves the next operations that the host agent needs to perform.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_get_next_steps(infra_env_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The infra env of the host that is retrieving instructions. (required)
        :param str host_id: The host that is retrieving instructions. (required)
        :param str discovery_agent_version: The software version of the discovery agent that is retrieving instructions.
        :return: Steps
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_get_next_steps_with_http_info(infra_env_id, host_id, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_get_next_steps_with_http_info(infra_env_id, host_id, **kwargs)  # noqa: E501
            return data

    def v2_get_next_steps_with_http_info(self, infra_env_id, host_id, **kwargs):  # noqa: E501
        """v2_get_next_steps  # noqa: E501

        Retrieves the next operations that the host agent needs to perform.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_get_next_steps_with_http_info(infra_env_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The infra env of the host that is retrieving instructions. (required)
        :param str host_id: The host that is retrieving instructions. (required)
        :param str discovery_agent_version: The software version of the discovery agent that is retrieving instructions.
        :return: Steps
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['infra_env_id', 'host_id', 'discovery_agent_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_get_next_steps" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'infra_env_id' is set
        if ('infra_env_id' not in params or
                params['infra_env_id'] is None):
            raise ValueError("Missing the required parameter `infra_env_id` when calling `v2_get_next_steps`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `v2_get_next_steps`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'infra_env_id' in params:
            path_params['infra_env_id'] = params['infra_env_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'discovery_agent_version' in params:
            header_params['discovery_agent_version'] = params['discovery_agent_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/infra-envs/{infra_env_id}/hosts/{host_id}/instructions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Steps',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_get_preflight_requirements(self, cluster_id, **kwargs):  # noqa: E501
        """v2_get_preflight_requirements  # noqa: E501

        Get preflight requirements for a cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_get_preflight_requirements(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to return preflight requrements for. (required)
        :return: PreflightHardwareRequirements
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_get_preflight_requirements_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_get_preflight_requirements_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def v2_get_preflight_requirements_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """v2_get_preflight_requirements  # noqa: E501

        Get preflight requirements for a cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_get_preflight_requirements_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to return preflight requrements for. (required)
        :return: PreflightHardwareRequirements
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_get_preflight_requirements" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `v2_get_preflight_requirements`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/clusters/{cluster_id}/preflight-requirements', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PreflightHardwareRequirements',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_get_presigned_for_cluster_credentials(self, cluster_id, file_name, **kwargs):  # noqa: E501
        """v2_get_presigned_for_cluster_credentials  # noqa: E501

        Get the cluster admin credentials.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_get_presigned_for_cluster_credentials(cluster_id, file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster that owns the file that should be downloaded. (required)
        :param str file_name: The file to be downloaded. (required)
        :return: Presigned
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_get_presigned_for_cluster_credentials_with_http_info(cluster_id, file_name, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_get_presigned_for_cluster_credentials_with_http_info(cluster_id, file_name, **kwargs)  # noqa: E501
            return data

    def v2_get_presigned_for_cluster_credentials_with_http_info(self, cluster_id, file_name, **kwargs):  # noqa: E501
        """v2_get_presigned_for_cluster_credentials  # noqa: E501

        Get the cluster admin credentials.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_get_presigned_for_cluster_credentials_with_http_info(cluster_id, file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster that owns the file that should be downloaded. (required)
        :param str file_name: The file to be downloaded. (required)
        :return: Presigned
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'file_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_get_presigned_for_cluster_credentials" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `v2_get_presigned_for_cluster_credentials`")  # noqa: E501
        # verify the required parameter 'file_name' is set
        if ('file_name' not in params or
                params['file_name'] is None):
            raise ValueError("Missing the required parameter `file_name` when calling `v2_get_presigned_for_cluster_credentials`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []
        if 'file_name' in params:
            query_params.append(('file_name', params['file_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/clusters/{cluster_id}/downloads/credentials-presigned', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Presigned',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_get_presigned_for_cluster_files(self, cluster_id, file_name, **kwargs):  # noqa: E501
        """v2_get_presigned_for_cluster_files  # noqa: E501

        Retrieves a pre-signed S3 URL for downloading cluster files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_get_presigned_for_cluster_files(cluster_id, file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster that owns the file that should be downloaded. (required)
        :param str file_name: The file to be downloaded. (required)
        :param str logs_type: If downloading logs, the type of logs to download.
        :param str host_id: If downloading a file related to a host, the relevant host.
        :param str additional_name: If downloading a manifest, the file name, prefaced with folder name, for example, openshift/99-openshift-xyz.yaml.
        :return: Presigned
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_get_presigned_for_cluster_files_with_http_info(cluster_id, file_name, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_get_presigned_for_cluster_files_with_http_info(cluster_id, file_name, **kwargs)  # noqa: E501
            return data

    def v2_get_presigned_for_cluster_files_with_http_info(self, cluster_id, file_name, **kwargs):  # noqa: E501
        """v2_get_presigned_for_cluster_files  # noqa: E501

        Retrieves a pre-signed S3 URL for downloading cluster files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_get_presigned_for_cluster_files_with_http_info(cluster_id, file_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster that owns the file that should be downloaded. (required)
        :param str file_name: The file to be downloaded. (required)
        :param str logs_type: If downloading logs, the type of logs to download.
        :param str host_id: If downloading a file related to a host, the relevant host.
        :param str additional_name: If downloading a manifest, the file name, prefaced with folder name, for example, openshift/99-openshift-xyz.yaml.
        :return: Presigned
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'file_name', 'logs_type', 'host_id', 'additional_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_get_presigned_for_cluster_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `v2_get_presigned_for_cluster_files`")  # noqa: E501
        # verify the required parameter 'file_name' is set
        if ('file_name' not in params or
                params['file_name'] is None):
            raise ValueError("Missing the required parameter `file_name` when calling `v2_get_presigned_for_cluster_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []
        if 'file_name' in params:
            query_params.append(('file_name', params['file_name']))  # noqa: E501
        if 'logs_type' in params:
            query_params.append(('logs_type', params['logs_type']))  # noqa: E501
        if 'host_id' in params:
            query_params.append(('host_id', params['host_id']))  # noqa: E501
        if 'additional_name' in params:
            query_params.append(('additional_name', params['additional_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/clusters/{cluster_id}/downloads/files-presigned', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Presigned',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_import_cluster(self, new_import_cluster_params, **kwargs):  # noqa: E501
        """v2_import_cluster  # noqa: E501

        Import an AI cluster using minimal data assosiated with existing OCP cluster, in order to allow adding day2 hosts to that cluster  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_import_cluster(new_import_cluster_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ImportClusterParams new_import_cluster_params: Parameters for importing a OCP cluster for adding nodes. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_import_cluster_with_http_info(new_import_cluster_params, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_import_cluster_with_http_info(new_import_cluster_params, **kwargs)  # noqa: E501
            return data

    def v2_import_cluster_with_http_info(self, new_import_cluster_params, **kwargs):  # noqa: E501
        """v2_import_cluster  # noqa: E501

        Import an AI cluster using minimal data assosiated with existing OCP cluster, in order to allow adding day2 hosts to that cluster  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_import_cluster_with_http_info(new_import_cluster_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ImportClusterParams new_import_cluster_params: Parameters for importing a OCP cluster for adding nodes. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['new_import_cluster_params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_import_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'new_import_cluster_params' is set
        if ('new_import_cluster_params' not in params or
                params['new_import_cluster_params'] is None):
            raise ValueError("Missing the required parameter `new_import_cluster_params` when calling `v2_import_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'new_import_cluster_params' in params:
            body_params = params['new_import_cluster_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/clusters/import', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_install_cluster(self, cluster_id, **kwargs):  # noqa: E501
        """v2_install_cluster  # noqa: E501

        Installs the OpenShift cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_install_cluster(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to be installed. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_install_cluster_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_install_cluster_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def v2_install_cluster_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """v2_install_cluster  # noqa: E501

        Installs the OpenShift cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_install_cluster_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to be installed. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_install_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `v2_install_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/clusters/{cluster_id}/actions/install', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_install_host(self, infra_env_id, host_id, **kwargs):  # noqa: E501
        """v2_install_host  # noqa: E501

        install specific host for day2 cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_install_host(infra_env_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv of the host that is being installed. (required)
        :param str host_id: The host that is being installed. (required)
        :return: Host
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_install_host_with_http_info(infra_env_id, host_id, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_install_host_with_http_info(infra_env_id, host_id, **kwargs)  # noqa: E501
            return data

    def v2_install_host_with_http_info(self, infra_env_id, host_id, **kwargs):  # noqa: E501
        """v2_install_host  # noqa: E501

        install specific host for day2 cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_install_host_with_http_info(infra_env_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv of the host that is being installed. (required)
        :param str host_id: The host that is being installed. (required)
        :return: Host
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['infra_env_id', 'host_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_install_host" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'infra_env_id' is set
        if ('infra_env_id' not in params or
                params['infra_env_id'] is None):
            raise ValueError("Missing the required parameter `infra_env_id` when calling `v2_install_host`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `v2_install_host`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'infra_env_id' in params:
            path_params['infra_env_id'] = params['infra_env_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/infra-envs/{infra_env_id}/hosts/{host_id}/actions/install', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Host',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_list_clusters(self, **kwargs):  # noqa: E501
        """v2_list_clusters  # noqa: E501

        Retrieves the list of OpenShift clusters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_list_clusters(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool get_unregistered_clusters: Whether to return clusters that have been unregistered.
        :param str openshift_cluster_id: A specific cluster to retrieve.
        :param list[str] ams_subscription_ids: If non-empty, returned Clusters are filtered to those with matching subscription IDs.
        :param bool with_hosts: Include hosts in the returned list.
        :return: ClusterList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_list_clusters_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.v2_list_clusters_with_http_info(**kwargs)  # noqa: E501
            return data

    def v2_list_clusters_with_http_info(self, **kwargs):  # noqa: E501
        """v2_list_clusters  # noqa: E501

        Retrieves the list of OpenShift clusters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_list_clusters_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool get_unregistered_clusters: Whether to return clusters that have been unregistered.
        :param str openshift_cluster_id: A specific cluster to retrieve.
        :param list[str] ams_subscription_ids: If non-empty, returned Clusters are filtered to those with matching subscription IDs.
        :param bool with_hosts: Include hosts in the returned list.
        :return: ClusterList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['get_unregistered_clusters', 'openshift_cluster_id', 'ams_subscription_ids', 'with_hosts']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_list_clusters" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'openshift_cluster_id' in params:
            query_params.append(('openshift_cluster_id', params['openshift_cluster_id']))  # noqa: E501
        if 'ams_subscription_ids' in params:
            query_params.append(('ams_subscription_ids', params['ams_subscription_ids']))  # noqa: E501
            collection_formats['ams_subscription_ids'] = 'csv'  # noqa: E501
        if 'with_hosts' in params:
            query_params.append(('with_hosts', params['with_hosts']))  # noqa: E501

        header_params = {}
        if 'get_unregistered_clusters' in params:
            header_params['get_unregistered_clusters'] = params['get_unregistered_clusters']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/clusters', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClusterList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_list_feature_support_levels(self, **kwargs):  # noqa: E501
        """v2_list_feature_support_levels  # noqa: E501

        Retrieves the support levels for features for each OpenShift version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_list_feature_support_levels(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: FeatureSupportLevels
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_list_feature_support_levels_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.v2_list_feature_support_levels_with_http_info(**kwargs)  # noqa: E501
            return data

    def v2_list_feature_support_levels_with_http_info(self, **kwargs):  # noqa: E501
        """v2_list_feature_support_levels  # noqa: E501

        Retrieves the support levels for features for each OpenShift version.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_list_feature_support_levels_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: FeatureSupportLevels
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_list_feature_support_levels" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/feature-support-levels', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FeatureSupportLevels',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_list_hosts(self, infra_env_id, **kwargs):  # noqa: E501
        """v2_list_hosts  # noqa: E501

        Retrieves the list of OpenShift hosts that belong to infra-env.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_list_hosts(infra_env_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv that the hosts are asociated with. (required)
        :return: HostList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_list_hosts_with_http_info(infra_env_id, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_list_hosts_with_http_info(infra_env_id, **kwargs)  # noqa: E501
            return data

    def v2_list_hosts_with_http_info(self, infra_env_id, **kwargs):  # noqa: E501
        """v2_list_hosts  # noqa: E501

        Retrieves the list of OpenShift hosts that belong to infra-env.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_list_hosts_with_http_info(infra_env_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv that the hosts are asociated with. (required)
        :return: HostList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['infra_env_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_list_hosts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'infra_env_id' is set
        if ('infra_env_id' not in params or
                params['infra_env_id'] is None):
            raise ValueError("Missing the required parameter `infra_env_id` when calling `v2_list_hosts`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'infra_env_id' in params:
            path_params['infra_env_id'] = params['infra_env_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth', 'userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/infra-envs/{infra_env_id}/hosts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HostList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_list_of_cluster_operators(self, cluster_id, **kwargs):  # noqa: E501
        """v2_list_of_cluster_operators  # noqa: E501

        Lists operators to be monitored for a cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_list_of_cluster_operators(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to return operators for. (required)
        :param str operator_name: An operator in the specified cluster to return its data.
        :return: MonitoredOperatorsList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_list_of_cluster_operators_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_list_of_cluster_operators_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def v2_list_of_cluster_operators_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """v2_list_of_cluster_operators  # noqa: E501

        Lists operators to be monitored for a cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_list_of_cluster_operators_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to return operators for. (required)
        :param str operator_name: An operator in the specified cluster to return its data.
        :return: MonitoredOperatorsList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'operator_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_list_of_cluster_operators" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `v2_list_of_cluster_operators`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []
        if 'operator_name' in params:
            query_params.append(('operator_name', params['operator_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/clusters/{cluster_id}/monitored-operators', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MonitoredOperatorsList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_post_step_reply(self, infra_env_id, host_id, **kwargs):  # noqa: E501
        """v2_post_step_reply  # noqa: E501

        Posts the result of the operations from the host agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_post_step_reply(infra_env_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The infra env of the host that is posting results. (required)
        :param str host_id: The host that is posting results. (required)
        :param str discovery_agent_version: The software version of the discovery agent that is posting results.
        :param StepReply reply: The results to be posted.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_post_step_reply_with_http_info(infra_env_id, host_id, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_post_step_reply_with_http_info(infra_env_id, host_id, **kwargs)  # noqa: E501
            return data

    def v2_post_step_reply_with_http_info(self, infra_env_id, host_id, **kwargs):  # noqa: E501
        """v2_post_step_reply  # noqa: E501

        Posts the result of the operations from the host agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_post_step_reply_with_http_info(infra_env_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The infra env of the host that is posting results. (required)
        :param str host_id: The host that is posting results. (required)
        :param str discovery_agent_version: The software version of the discovery agent that is posting results.
        :param StepReply reply: The results to be posted.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['infra_env_id', 'host_id', 'discovery_agent_version', 'reply']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_post_step_reply" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'infra_env_id' is set
        if ('infra_env_id' not in params or
                params['infra_env_id'] is None):
            raise ValueError("Missing the required parameter `infra_env_id` when calling `v2_post_step_reply`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `v2_post_step_reply`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'infra_env_id' in params:
            path_params['infra_env_id'] = params['infra_env_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'discovery_agent_version' in params:
            header_params['discovery_agent_version'] = params['discovery_agent_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'reply' in params:
            body_params = params['reply']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/infra-envs/{infra_env_id}/hosts/{host_id}/instructions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_register_cluster(self, new_cluster_params, **kwargs):  # noqa: E501
        """v2_register_cluster  # noqa: E501

        Creates a new OpenShift cluster definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_register_cluster(new_cluster_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ClusterCreateParams new_cluster_params: The properties describing the new cluster. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_register_cluster_with_http_info(new_cluster_params, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_register_cluster_with_http_info(new_cluster_params, **kwargs)  # noqa: E501
            return data

    def v2_register_cluster_with_http_info(self, new_cluster_params, **kwargs):  # noqa: E501
        """v2_register_cluster  # noqa: E501

        Creates a new OpenShift cluster definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_register_cluster_with_http_info(new_cluster_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ClusterCreateParams new_cluster_params: The properties describing the new cluster. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['new_cluster_params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_register_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'new_cluster_params' is set
        if ('new_cluster_params' not in params or
                params['new_cluster_params'] is None):
            raise ValueError("Missing the required parameter `new_cluster_params` when calling `v2_register_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'new_cluster_params' in params:
            body_params = params['new_cluster_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/clusters', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_register_host(self, infra_env_id, new_host_params, **kwargs):  # noqa: E501
        """v2_register_host  # noqa: E501

        Registers a new OpenShift agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_register_host(infra_env_id, new_host_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv that the agent is associated with. (required)
        :param HostCreateParams new_host_params: The description of the agent being registered. (required)
        :param str discovery_agent_version: The software version of the discovery agent that is registering the agent.
        :return: HostRegistrationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_register_host_with_http_info(infra_env_id, new_host_params, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_register_host_with_http_info(infra_env_id, new_host_params, **kwargs)  # noqa: E501
            return data

    def v2_register_host_with_http_info(self, infra_env_id, new_host_params, **kwargs):  # noqa: E501
        """v2_register_host  # noqa: E501

        Registers a new OpenShift agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_register_host_with_http_info(infra_env_id, new_host_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv that the agent is associated with. (required)
        :param HostCreateParams new_host_params: The description of the agent being registered. (required)
        :param str discovery_agent_version: The software version of the discovery agent that is registering the agent.
        :return: HostRegistrationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['infra_env_id', 'new_host_params', 'discovery_agent_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_register_host" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'infra_env_id' is set
        if ('infra_env_id' not in params or
                params['infra_env_id'] is None):
            raise ValueError("Missing the required parameter `infra_env_id` when calling `v2_register_host`")  # noqa: E501
        # verify the required parameter 'new_host_params' is set
        if ('new_host_params' not in params or
                params['new_host_params'] is None):
            raise ValueError("Missing the required parameter `new_host_params` when calling `v2_register_host`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'infra_env_id' in params:
            path_params['infra_env_id'] = params['infra_env_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'discovery_agent_version' in params:
            header_params['discovery_agent_version'] = params['discovery_agent_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'new_host_params' in params:
            body_params = params['new_host_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/infra-envs/{infra_env_id}/hosts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HostRegistrationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_report_monitored_operator_status(self, cluster_id, report_params, **kwargs):  # noqa: E501
        """v2_report_monitored_operator_status  # noqa: E501

        Controller API to report of monitored operators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_report_monitored_operator_status(cluster_id, report_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose operators are being monitored. (required)
        :param OperatorMonitorReport report_params: The operators monitor report. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_report_monitored_operator_status_with_http_info(cluster_id, report_params, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_report_monitored_operator_status_with_http_info(cluster_id, report_params, **kwargs)  # noqa: E501
            return data

    def v2_report_monitored_operator_status_with_http_info(self, cluster_id, report_params, **kwargs):  # noqa: E501
        """v2_report_monitored_operator_status  # noqa: E501

        Controller API to report of monitored operators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_report_monitored_operator_status_with_http_info(cluster_id, report_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose operators are being monitored. (required)
        :param OperatorMonitorReport report_params: The operators monitor report. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'report_params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_report_monitored_operator_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `v2_report_monitored_operator_status`")  # noqa: E501
        # verify the required parameter 'report_params' is set
        if ('report_params' not in params or
                params['report_params'] is None):
            raise ValueError("Missing the required parameter `report_params` when calling `v2_report_monitored_operator_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'report_params' in params:
            body_params = params['report_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/clusters/{cluster_id}/monitored-operators', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_reset_cluster(self, cluster_id, **kwargs):  # noqa: E501
        """v2_reset_cluster  # noqa: E501

        Resets a failed installation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_reset_cluster(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose installation is to be reset. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_reset_cluster_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_reset_cluster_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def v2_reset_cluster_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """v2_reset_cluster  # noqa: E501

        Resets a failed installation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_reset_cluster_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose installation is to be reset. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_reset_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `v2_reset_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/clusters/{cluster_id}/actions/reset', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_reset_host(self, infra_env_id, host_id, **kwargs):  # noqa: E501
        """v2_reset_host  # noqa: E501

        reset a failed host for day2 cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_reset_host(infra_env_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv of the host that is being reset. (required)
        :param str host_id: The host that is being reset. (required)
        :return: Host
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_reset_host_with_http_info(infra_env_id, host_id, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_reset_host_with_http_info(infra_env_id, host_id, **kwargs)  # noqa: E501
            return data

    def v2_reset_host_with_http_info(self, infra_env_id, host_id, **kwargs):  # noqa: E501
        """v2_reset_host  # noqa: E501

        reset a failed host for day2 cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_reset_host_with_http_info(infra_env_id, host_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv of the host that is being reset. (required)
        :param str host_id: The host that is being reset. (required)
        :return: Host
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['infra_env_id', 'host_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_reset_host" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'infra_env_id' is set
        if ('infra_env_id' not in params or
                params['infra_env_id'] is None):
            raise ValueError("Missing the required parameter `infra_env_id` when calling `v2_reset_host`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `v2_reset_host`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'infra_env_id' in params:
            path_params['infra_env_id'] = params['infra_env_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/infra-envs/{infra_env_id}/hosts/{host_id}/actions/reset', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Host',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_reset_host_validation(self, infra_env_id, host_id, validation_id, **kwargs):  # noqa: E501
        """Reset failed host validation.  # noqa: E501

        Reset failed host validation. It may be performed on any host validation with persistent validation result.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_reset_host_validation(infra_env_id, host_id, validation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv of the host that its validation is being reset. (required)
        :param str host_id: The host that its validation is being reset. (required)
        :param str validation_id: The id of the validation being reset. (required)
        :return: Host
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_reset_host_validation_with_http_info(infra_env_id, host_id, validation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_reset_host_validation_with_http_info(infra_env_id, host_id, validation_id, **kwargs)  # noqa: E501
            return data

    def v2_reset_host_validation_with_http_info(self, infra_env_id, host_id, validation_id, **kwargs):  # noqa: E501
        """Reset failed host validation.  # noqa: E501

        Reset failed host validation. It may be performed on any host validation with persistent validation result.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_reset_host_validation_with_http_info(infra_env_id, host_id, validation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv of the host that its validation is being reset. (required)
        :param str host_id: The host that its validation is being reset. (required)
        :param str validation_id: The id of the validation being reset. (required)
        :return: Host
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['infra_env_id', 'host_id', 'validation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_reset_host_validation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'infra_env_id' is set
        if ('infra_env_id' not in params or
                params['infra_env_id'] is None):
            raise ValueError("Missing the required parameter `infra_env_id` when calling `v2_reset_host_validation`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `v2_reset_host_validation`")  # noqa: E501
        # verify the required parameter 'validation_id' is set
        if ('validation_id' not in params or
                params['validation_id'] is None):
            raise ValueError("Missing the required parameter `validation_id` when calling `v2_reset_host_validation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'infra_env_id' in params:
            path_params['infra_env_id'] = params['infra_env_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501
        if 'validation_id' in params:
            path_params['validation_id'] = params['validation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/infra-envs/{infra_env_id}/hosts/{host_id}/actions/reset-validation/{validation_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Host',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_update_cluster(self, cluster_id, cluster_update_params, **kwargs):  # noqa: E501
        """v2_update_cluster  # noqa: E501

        Updates an OpenShift cluster definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_update_cluster(cluster_id, cluster_update_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to be updated. (required)
        :param V2ClusterUpdateParams cluster_update_params: The properties to update. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_update_cluster_with_http_info(cluster_id, cluster_update_params, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_update_cluster_with_http_info(cluster_id, cluster_update_params, **kwargs)  # noqa: E501
            return data

    def v2_update_cluster_with_http_info(self, cluster_id, cluster_update_params, **kwargs):  # noqa: E501
        """v2_update_cluster  # noqa: E501

        Updates an OpenShift cluster definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_update_cluster_with_http_info(cluster_id, cluster_update_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to be updated. (required)
        :param V2ClusterUpdateParams cluster_update_params: The properties to update. (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'cluster_update_params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_update_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `v2_update_cluster`")  # noqa: E501
        # verify the required parameter 'cluster_update_params' is set
        if ('cluster_update_params' not in params or
                params['cluster_update_params'] is None):
            raise ValueError("Missing the required parameter `cluster_update_params` when calling `v2_update_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cluster_update_params' in params:
            body_params = params['cluster_update_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/clusters/{cluster_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_update_cluster_install_config(self, cluster_id, install_config_params, **kwargs):  # noqa: E501
        """v2_update_cluster_install_config  # noqa: E501

        Override values in the install config.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_update_cluster_install_config(cluster_id, install_config_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose install config is being updated. (required)
        :param str install_config_params: Install config overrides. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_update_cluster_install_config_with_http_info(cluster_id, install_config_params, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_update_cluster_install_config_with_http_info(cluster_id, install_config_params, **kwargs)  # noqa: E501
            return data

    def v2_update_cluster_install_config_with_http_info(self, cluster_id, install_config_params, **kwargs):  # noqa: E501
        """v2_update_cluster_install_config  # noqa: E501

        Override values in the install config.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_update_cluster_install_config_with_http_info(cluster_id, install_config_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose install config is being updated. (required)
        :param str install_config_params: Install config overrides. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'install_config_params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_update_cluster_install_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `v2_update_cluster_install_config`")  # noqa: E501
        # verify the required parameter 'install_config_params' is set
        if ('install_config_params' not in params or
                params['install_config_params'] is None):
            raise ValueError("Missing the required parameter `install_config_params` when calling `v2_update_cluster_install_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'install_config_params' in params:
            body_params = params['install_config_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/clusters/{cluster_id}/install-config', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_update_cluster_logs_progress(self, cluster_id, logs_progress_params, **kwargs):  # noqa: E501
        """v2_update_cluster_logs_progress  # noqa: E501

        Update log collection state and progress.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_update_cluster_logs_progress(cluster_id, logs_progress_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose log progress is being updated. (required)
        :param LogsProgressParams logs_progress_params: Parameters for updating log progress. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_update_cluster_logs_progress_with_http_info(cluster_id, logs_progress_params, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_update_cluster_logs_progress_with_http_info(cluster_id, logs_progress_params, **kwargs)  # noqa: E501
            return data

    def v2_update_cluster_logs_progress_with_http_info(self, cluster_id, logs_progress_params, **kwargs):  # noqa: E501
        """v2_update_cluster_logs_progress  # noqa: E501

        Update log collection state and progress.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_update_cluster_logs_progress_with_http_info(cluster_id, logs_progress_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose log progress is being updated. (required)
        :param LogsProgressParams logs_progress_params: Parameters for updating log progress. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'logs_progress_params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_update_cluster_logs_progress" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `v2_update_cluster_logs_progress`")  # noqa: E501
        # verify the required parameter 'logs_progress_params' is set
        if ('logs_progress_params' not in params or
                params['logs_progress_params'] is None):
            raise ValueError("Missing the required parameter `logs_progress_params` when calling `v2_update_cluster_logs_progress`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'logs_progress_params' in params:
            body_params = params['logs_progress_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/clusters/{cluster_id}/logs-progress', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_update_host(self, infra_env_id, host_id, host_update_params, **kwargs):  # noqa: E501
        """v2_update_host  # noqa: E501

        Update an Openshift host  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_update_host(infra_env_id, host_id, host_update_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The infra_env_id of the host to be updated. (required)
        :param str host_id: The host that should be updated. (required)
        :param HostUpdateParams host_update_params: The properties to update. (required)
        :return: Host
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_update_host_with_http_info(infra_env_id, host_id, host_update_params, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_update_host_with_http_info(infra_env_id, host_id, host_update_params, **kwargs)  # noqa: E501
            return data

    def v2_update_host_with_http_info(self, infra_env_id, host_id, host_update_params, **kwargs):  # noqa: E501
        """v2_update_host  # noqa: E501

        Update an Openshift host  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_update_host_with_http_info(infra_env_id, host_id, host_update_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The infra_env_id of the host to be updated. (required)
        :param str host_id: The host that should be updated. (required)
        :param HostUpdateParams host_update_params: The properties to update. (required)
        :return: Host
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['infra_env_id', 'host_id', 'host_update_params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_update_host" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'infra_env_id' is set
        if ('infra_env_id' not in params or
                params['infra_env_id'] is None):
            raise ValueError("Missing the required parameter `infra_env_id` when calling `v2_update_host`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `v2_update_host`")  # noqa: E501
        # verify the required parameter 'host_update_params' is set
        if ('host_update_params' not in params or
                params['host_update_params'] is None):
            raise ValueError("Missing the required parameter `host_update_params` when calling `v2_update_host`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'infra_env_id' in params:
            path_params['infra_env_id'] = params['infra_env_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'host_update_params' in params:
            body_params = params['host_update_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/infra-envs/{infra_env_id}/hosts/{host_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Host',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_update_host_ignition(self, infra_env_id, host_id, host_ignition_params, **kwargs):  # noqa: E501
        """v2_update_host_ignition  # noqa: E501

        Patch the ignition file for this host  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_update_host_ignition(infra_env_id, host_id, host_ignition_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv of the host whose ignition file should be updated. (required)
        :param str host_id: The host whose ignition file should be updated. (required)
        :param HostIgnitionParams host_ignition_params: Ignition config overrides. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_update_host_ignition_with_http_info(infra_env_id, host_id, host_ignition_params, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_update_host_ignition_with_http_info(infra_env_id, host_id, host_ignition_params, **kwargs)  # noqa: E501
            return data

    def v2_update_host_ignition_with_http_info(self, infra_env_id, host_id, host_ignition_params, **kwargs):  # noqa: E501
        """v2_update_host_ignition  # noqa: E501

        Patch the ignition file for this host  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_update_host_ignition_with_http_info(infra_env_id, host_id, host_ignition_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv of the host whose ignition file should be updated. (required)
        :param str host_id: The host whose ignition file should be updated. (required)
        :param HostIgnitionParams host_ignition_params: Ignition config overrides. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['infra_env_id', 'host_id', 'host_ignition_params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_update_host_ignition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'infra_env_id' is set
        if ('infra_env_id' not in params or
                params['infra_env_id'] is None):
            raise ValueError("Missing the required parameter `infra_env_id` when calling `v2_update_host_ignition`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `v2_update_host_ignition`")  # noqa: E501
        # verify the required parameter 'host_ignition_params' is set
        if ('host_ignition_params' not in params or
                params['host_ignition_params'] is None):
            raise ValueError("Missing the required parameter `host_ignition_params` when calling `v2_update_host_ignition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'infra_env_id' in params:
            path_params['infra_env_id'] = params['infra_env_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'host_ignition_params' in params:
            body_params = params['host_ignition_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/infra-envs/{infra_env_id}/hosts/{host_id}/ignition', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_update_host_install_progress(self, infra_env_id, host_id, host_progress, **kwargs):  # noqa: E501
        """v2_update_host_install_progress  # noqa: E501

        Update installation progress.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_update_host_install_progress(infra_env_id, host_id, host_progress, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv of the host being updated. (required)
        :param str host_id: The ID of the host to update. (required)
        :param HostProgress host_progress: New progress value. (required)
        :param str discovery_agent_version: The software version of the discovery agent that is updating progress.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_update_host_install_progress_with_http_info(infra_env_id, host_id, host_progress, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_update_host_install_progress_with_http_info(infra_env_id, host_id, host_progress, **kwargs)  # noqa: E501
            return data

    def v2_update_host_install_progress_with_http_info(self, infra_env_id, host_id, host_progress, **kwargs):  # noqa: E501
        """v2_update_host_install_progress  # noqa: E501

        Update installation progress.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_update_host_install_progress_with_http_info(infra_env_id, host_id, host_progress, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv of the host being updated. (required)
        :param str host_id: The ID of the host to update. (required)
        :param HostProgress host_progress: New progress value. (required)
        :param str discovery_agent_version: The software version of the discovery agent that is updating progress.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['infra_env_id', 'host_id', 'host_progress', 'discovery_agent_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_update_host_install_progress" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'infra_env_id' is set
        if ('infra_env_id' not in params or
                params['infra_env_id'] is None):
            raise ValueError("Missing the required parameter `infra_env_id` when calling `v2_update_host_install_progress`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `v2_update_host_install_progress`")  # noqa: E501
        # verify the required parameter 'host_progress' is set
        if ('host_progress' not in params or
                params['host_progress'] is None):
            raise ValueError("Missing the required parameter `host_progress` when calling `v2_update_host_install_progress`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'infra_env_id' in params:
            path_params['infra_env_id'] = params['infra_env_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'discovery_agent_version' in params:
            header_params['discovery_agent_version'] = params['discovery_agent_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'host_progress' in params:
            body_params = params['host_progress']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/infra-envs/{infra_env_id}/hosts/{host_id}/progress', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_update_host_installer_args(self, infra_env_id, host_id, installer_args_params, **kwargs):  # noqa: E501
        """v2_update_host_installer_args  # noqa: E501

        Updates a host's installer arguments.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_update_host_installer_args(infra_env_id, host_id, installer_args_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv of the host whose installer arguments should be updated. (required)
        :param str host_id: The host whose installer arguments should be updated. (required)
        :param InstallerArgsParams installer_args_params: The updated installer arguments. (required)
        :return: Host
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_update_host_installer_args_with_http_info(infra_env_id, host_id, installer_args_params, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_update_host_installer_args_with_http_info(infra_env_id, host_id, installer_args_params, **kwargs)  # noqa: E501
            return data

    def v2_update_host_installer_args_with_http_info(self, infra_env_id, host_id, installer_args_params, **kwargs):  # noqa: E501
        """v2_update_host_installer_args  # noqa: E501

        Updates a host's installer arguments.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_update_host_installer_args_with_http_info(infra_env_id, host_id, installer_args_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv of the host whose installer arguments should be updated. (required)
        :param str host_id: The host whose installer arguments should be updated. (required)
        :param InstallerArgsParams installer_args_params: The updated installer arguments. (required)
        :return: Host
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['infra_env_id', 'host_id', 'installer_args_params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_update_host_installer_args" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'infra_env_id' is set
        if ('infra_env_id' not in params or
                params['infra_env_id'] is None):
            raise ValueError("Missing the required parameter `infra_env_id` when calling `v2_update_host_installer_args`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `v2_update_host_installer_args`")  # noqa: E501
        # verify the required parameter 'installer_args_params' is set
        if ('installer_args_params' not in params or
                params['installer_args_params'] is None):
            raise ValueError("Missing the required parameter `installer_args_params` when calling `v2_update_host_installer_args`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'infra_env_id' in params:
            path_params['infra_env_id'] = params['infra_env_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'installer_args_params' in params:
            body_params = params['installer_args_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/infra-envs/{infra_env_id}/hosts/{host_id}/installer-args', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Host',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_update_host_logs_progress(self, infra_env_id, host_id, logs_progress_params, **kwargs):  # noqa: E501
        """v2_update_host_logs_progress  # noqa: E501

        Update log collection state and progress.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_update_host_logs_progress(infra_env_id, host_id, logs_progress_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv whose log progress is being updated. (required)
        :param str host_id: The host whose log progress is being updated. (required)
        :param LogsProgressParams logs_progress_params: Parameters for updating log progress. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_update_host_logs_progress_with_http_info(infra_env_id, host_id, logs_progress_params, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_update_host_logs_progress_with_http_info(infra_env_id, host_id, logs_progress_params, **kwargs)  # noqa: E501
            return data

    def v2_update_host_logs_progress_with_http_info(self, infra_env_id, host_id, logs_progress_params, **kwargs):  # noqa: E501
        """v2_update_host_logs_progress  # noqa: E501

        Update log collection state and progress.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_update_host_logs_progress_with_http_info(infra_env_id, host_id, logs_progress_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str infra_env_id: The InfraEnv whose log progress is being updated. (required)
        :param str host_id: The host whose log progress is being updated. (required)
        :param LogsProgressParams logs_progress_params: Parameters for updating log progress. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['infra_env_id', 'host_id', 'logs_progress_params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_update_host_logs_progress" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'infra_env_id' is set
        if ('infra_env_id' not in params or
                params['infra_env_id'] is None):
            raise ValueError("Missing the required parameter `infra_env_id` when calling `v2_update_host_logs_progress`")  # noqa: E501
        # verify the required parameter 'host_id' is set
        if ('host_id' not in params or
                params['host_id'] is None):
            raise ValueError("Missing the required parameter `host_id` when calling `v2_update_host_logs_progress`")  # noqa: E501
        # verify the required parameter 'logs_progress_params' is set
        if ('logs_progress_params' not in params or
                params['logs_progress_params'] is None):
            raise ValueError("Missing the required parameter `logs_progress_params` when calling `v2_update_host_logs_progress`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'infra_env_id' in params:
            path_params['infra_env_id'] = params['infra_env_id']  # noqa: E501
        if 'host_id' in params:
            path_params['host_id'] = params['host_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'logs_progress_params' in params:
            body_params = params['logs_progress_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/infra-envs/{infra_env_id}/hosts/{host_id}/logs-progress', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_upload_cluster_ingress_cert(self, cluster_id, ingress_cert_params, **kwargs):  # noqa: E501
        """v2_upload_cluster_ingress_cert  # noqa: E501

        Transfer the ingress certificate for the cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_upload_cluster_ingress_cert(cluster_id, ingress_cert_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to associate with the ingress certificate. (required)
        :param IngressCertParams ingress_cert_params: The ingress certificate. (required)
        :param str discovery_agent_version: The software version of the discovery agent that is uploading the ingress certificate.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_upload_cluster_ingress_cert_with_http_info(cluster_id, ingress_cert_params, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_upload_cluster_ingress_cert_with_http_info(cluster_id, ingress_cert_params, **kwargs)  # noqa: E501
            return data

    def v2_upload_cluster_ingress_cert_with_http_info(self, cluster_id, ingress_cert_params, **kwargs):  # noqa: E501
        """v2_upload_cluster_ingress_cert  # noqa: E501

        Transfer the ingress certificate for the cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_upload_cluster_ingress_cert_with_http_info(cluster_id, ingress_cert_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to associate with the ingress certificate. (required)
        :param IngressCertParams ingress_cert_params: The ingress certificate. (required)
        :param str discovery_agent_version: The software version of the discovery agent that is uploading the ingress certificate.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'ingress_cert_params', 'discovery_agent_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_upload_cluster_ingress_cert" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `v2_upload_cluster_ingress_cert`")  # noqa: E501
        # verify the required parameter 'ingress_cert_params' is set
        if ('ingress_cert_params' not in params or
                params['ingress_cert_params'] is None):
            raise ValueError("Missing the required parameter `ingress_cert_params` when calling `v2_upload_cluster_ingress_cert`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'discovery_agent_version' in params:
            header_params['discovery_agent_version'] = params['discovery_agent_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ingress_cert_params' in params:
            body_params = params['ingress_cert_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/clusters/{cluster_id}/uploads/ingress-cert', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_upload_logs(self, cluster_id, logs_type, **kwargs):  # noqa: E501
        """v2_upload_logs  # noqa: E501

        Agent API to upload logs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_upload_logs(cluster_id, logs_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose logs should be uploaded. (required)
        :param str logs_type: The type of log file to be uploaded. (required)
        :param file upfile: The log file to be uploaded.
        :param str infra_env_id: The infra_env_id of the host.
        :param str host_id: The host whose logs should be uploaded.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_upload_logs_with_http_info(cluster_id, logs_type, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_upload_logs_with_http_info(cluster_id, logs_type, **kwargs)  # noqa: E501
            return data

    def v2_upload_logs_with_http_info(self, cluster_id, logs_type, **kwargs):  # noqa: E501
        """v2_upload_logs  # noqa: E501

        Agent API to upload logs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_upload_logs_with_http_info(cluster_id, logs_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose logs should be uploaded. (required)
        :param str logs_type: The type of log file to be uploaded. (required)
        :param file upfile: The log file to be uploaded.
        :param str infra_env_id: The infra_env_id of the host.
        :param str host_id: The host whose logs should be uploaded.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'logs_type', 'upfile', 'infra_env_id', 'host_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_upload_logs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `v2_upload_logs`")  # noqa: E501
        # verify the required parameter 'logs_type' is set
        if ('logs_type' not in params or
                params['logs_type'] is None):
            raise ValueError("Missing the required parameter `logs_type` when calling `v2_upload_logs`")  # noqa: E501

        if ('upfile' in params and
                len(params['upfile']) > 104857600):
            raise ValueError("Invalid value for parameter `upfile` when calling `v2_upload_logs`, length must be less than or equal to `104857600`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []
        if 'logs_type' in params:
            query_params.append(('logs_type', params['logs_type']))  # noqa: E501
        if 'infra_env_id' in params:
            query_params.append(('infra_env_id', params['infra_env_id']))  # noqa: E501
        if 'host_id' in params:
            query_params.append(('host_id', params['host_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'upfile' in params:
            local_var_files['upfile'] = params['upfile']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/clusters/{cluster_id}/logs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
