# coding: utf-8

"""
    AssistedInstall

    Assisted installation  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from assisted_service_client.api_client import ApiClient


class OperatorsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def list_of_cluster_operators(self, cluster_id, **kwargs):  # noqa: E501
        """list_of_cluster_operators  # noqa: E501

        Lists operators to be monitored for a cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_of_cluster_operators(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to return operators for. (required)
        :param str operator_name: An operator in the specified cluster to return its data.
        :return: MonitoredOperatorsList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_of_cluster_operators_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_of_cluster_operators_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def list_of_cluster_operators_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """list_of_cluster_operators  # noqa: E501

        Lists operators to be monitored for a cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_of_cluster_operators_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to return operators for. (required)
        :param str operator_name: An operator in the specified cluster to return its data.
        :return: MonitoredOperatorsList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'operator_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_of_cluster_operators" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `list_of_cluster_operators`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []
        if 'operator_name' in params:
            query_params.append(('operator_name', params['operator_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/monitored_operators', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MonitoredOperatorsList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_operator_properties(self, operator_name, **kwargs):  # noqa: E501
        """list_operator_properties  # noqa: E501

        Lists properties for an operator.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_operator_properties(operator_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str operator_name: The operator name. (required)
        :return: OperatorProperties
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_operator_properties_with_http_info(operator_name, **kwargs)  # noqa: E501
        else:
            (data) = self.list_operator_properties_with_http_info(operator_name, **kwargs)  # noqa: E501
            return data

    def list_operator_properties_with_http_info(self, operator_name, **kwargs):  # noqa: E501
        """list_operator_properties  # noqa: E501

        Lists properties for an operator.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_operator_properties_with_http_info(operator_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str operator_name: The operator name. (required)
        :return: OperatorProperties
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['operator_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_operator_properties" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'operator_name' is set
        if ('operator_name' not in params or
                params['operator_name'] is None):
            raise ValueError("Missing the required parameter `operator_name` when calling `list_operator_properties`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'operator_name' in params:
            path_params['operator_name'] = params['operator_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/supported-operators/{operator_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OperatorProperties',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_supported_operators(self, **kwargs):  # noqa: E501
        """list_supported_operators  # noqa: E501

        Retrieves the list of supported operators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_supported_operators(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_supported_operators_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_supported_operators_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_supported_operators_with_http_info(self, **kwargs):  # noqa: E501
        """list_supported_operators  # noqa: E501

        Retrieves the list of supported operators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_supported_operators_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_supported_operators" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/supported-operators', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def report_monitored_operator_status(self, cluster_id, report_params, **kwargs):  # noqa: E501
        """report_monitored_operator_status  # noqa: E501

        Controller API to report of monitored operators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.report_monitored_operator_status(cluster_id, report_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose operators are being monitored. (required)
        :param OperatorMonitorReport report_params: The operators monitor report. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.report_monitored_operator_status_with_http_info(cluster_id, report_params, **kwargs)  # noqa: E501
        else:
            (data) = self.report_monitored_operator_status_with_http_info(cluster_id, report_params, **kwargs)  # noqa: E501
            return data

    def report_monitored_operator_status_with_http_info(self, cluster_id, report_params, **kwargs):  # noqa: E501
        """report_monitored_operator_status  # noqa: E501

        Controller API to report of monitored operators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.report_monitored_operator_status_with_http_info(cluster_id, report_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose operators are being monitored. (required)
        :param OperatorMonitorReport report_params: The operators monitor report. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'report_params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method report_monitored_operator_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `report_monitored_operator_status`")  # noqa: E501
        # verify the required parameter 'report_params' is set
        if ('report_params' not in params or
                params['report_params'] is None):
            raise ValueError("Missing the required parameter `report_params` when calling `report_monitored_operator_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'report_params' in params:
            body_params = params['report_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v1/clusters/{cluster_id}/monitored_operators', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_list_of_cluster_operators(self, cluster_id, **kwargs):  # noqa: E501
        """v2_list_of_cluster_operators  # noqa: E501

        Lists operators to be monitored for a cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_list_of_cluster_operators(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to return operators for. (required)
        :param str operator_name: An operator in the specified cluster to return its data.
        :return: MonitoredOperatorsList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_list_of_cluster_operators_with_http_info(cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_list_of_cluster_operators_with_http_info(cluster_id, **kwargs)  # noqa: E501
            return data

    def v2_list_of_cluster_operators_with_http_info(self, cluster_id, **kwargs):  # noqa: E501
        """v2_list_of_cluster_operators  # noqa: E501

        Lists operators to be monitored for a cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_list_of_cluster_operators_with_http_info(cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster to return operators for. (required)
        :param str operator_name: An operator in the specified cluster to return its data.
        :return: MonitoredOperatorsList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'operator_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_list_of_cluster_operators" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `v2_list_of_cluster_operators`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []
        if 'operator_name' in params:
            query_params.append(('operator_name', params['operator_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/clusters/{cluster_id}/monitored-operators', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MonitoredOperatorsList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_list_operator_properties(self, operator_name, **kwargs):  # noqa: E501
        """v2_list_operator_properties  # noqa: E501

        Lists properties for an operator.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_list_operator_properties(operator_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str operator_name: The operator name. (required)
        :return: OperatorProperties
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_list_operator_properties_with_http_info(operator_name, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_list_operator_properties_with_http_info(operator_name, **kwargs)  # noqa: E501
            return data

    def v2_list_operator_properties_with_http_info(self, operator_name, **kwargs):  # noqa: E501
        """v2_list_operator_properties  # noqa: E501

        Lists properties for an operator.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_list_operator_properties_with_http_info(operator_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str operator_name: The operator name. (required)
        :return: OperatorProperties
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['operator_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_list_operator_properties" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'operator_name' is set
        if ('operator_name' not in params or
                params['operator_name'] is None):
            raise ValueError("Missing the required parameter `operator_name` when calling `v2_list_operator_properties`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'operator_name' in params:
            path_params['operator_name'] = params['operator_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/supported-operators/{operator_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OperatorProperties',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_list_supported_operators(self, **kwargs):  # noqa: E501
        """v2_list_supported_operators  # noqa: E501

        Retrieves the list of supported operators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_list_supported_operators(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_list_supported_operators_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.v2_list_supported_operators_with_http_info(**kwargs)  # noqa: E501
            return data

    def v2_list_supported_operators_with_http_info(self, **kwargs):  # noqa: E501
        """v2_list_supported_operators  # noqa: E501

        Retrieves the list of supported operators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_list_supported_operators_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_list_supported_operators" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/supported-operators', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_report_monitored_operator_status(self, cluster_id, report_params, **kwargs):  # noqa: E501
        """v2_report_monitored_operator_status  # noqa: E501

        Controller API to report of monitored operators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_report_monitored_operator_status(cluster_id, report_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose operators are being monitored. (required)
        :param OperatorMonitorReport report_params: The operators monitor report. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.v2_report_monitored_operator_status_with_http_info(cluster_id, report_params, **kwargs)  # noqa: E501
        else:
            (data) = self.v2_report_monitored_operator_status_with_http_info(cluster_id, report_params, **kwargs)  # noqa: E501
            return data

    def v2_report_monitored_operator_status_with_http_info(self, cluster_id, report_params, **kwargs):  # noqa: E501
        """v2_report_monitored_operator_status  # noqa: E501

        Controller API to report of monitored operators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_report_monitored_operator_status_with_http_info(cluster_id, report_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cluster_id: The cluster whose operators are being monitored. (required)
        :param OperatorMonitorReport report_params: The operators monitor report. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cluster_id', 'report_params']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_report_monitored_operator_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `v2_report_monitored_operator_status`")  # noqa: E501
        # verify the required parameter 'report_params' is set
        if ('report_params' not in params or
                params['report_params'] is None):
            raise ValueError("Missing the required parameter `report_params` when calling `v2_report_monitored_operator_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'report_params' in params:
            body_params = params['report_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['agentAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/clusters/{cluster_id}/monitored-operators', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
