# coding: utf-8

"""
    AssistedInstall

    Assisted installation  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class Cluster(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'kind': 'str',
        'high_availability_mode': 'str',
        'id': 'str',
        'href': 'str',
        'name': 'str',
        'user_name': 'str',
        'org_id': 'str',
        'email_domain': 'str',
        'openshift_version': 'str',
        'ocp_release_image': 'str',
        'openshift_cluster_id': 'str',
        'image_info': 'ImageInfo',
        'platform': 'Platform',
        'base_dns_domain': 'str',
        'cluster_network_cidr': 'str',
        'cluster_network_host_prefix': 'int',
        'service_network_cidr': 'str',
        'api_vip': 'str',
        'api_vip_dns_name': 'str',
        'machine_network_cidr': 'str',
        'ingress_vip': 'str',
        'ssh_public_key': 'str',
        'http_proxy': 'str',
        'https_proxy': 'str',
        'no_proxy': 'str',
        'status': 'str',
        'status_info': 'str',
        'status_updated_at': 'datetime',
        'progress': 'ClusterProgressInfo',
        'disk_encryption': 'DiskEncryption',
        'hosts': 'list[Host]',
        'ready_host_count': 'int',
        'enabled_host_count': 'int',
        'total_host_count': 'int',
        'schedulable_masters': 'bool',
        'updated_at': 'datetime',
        'created_at': 'datetime',
        'install_started_at': 'datetime',
        'install_completed_at': 'datetime',
        'host_networks': 'list[HostNetwork]',
        'pull_secret_set': 'bool',
        'vip_dhcp_allocation': 'bool',
        'validations_info': 'str',
        'logs_info': 'LogsState',
        'install_config_overrides': 'str',
        'ignition_config_overrides': 'str',
        'controller_logs_collected_at': 'datetime',
        'controller_logs_started_at': 'datetime',
        'connectivity_majority_groups': 'str',
        'deleted_at': 'datetime',
        'user_managed_networking': 'bool',
        'additional_ntp_source': 'str',
        'monitored_operators': 'list[MonitoredOperator]',
        'ams_subscription_id': 'str',
        'hyperthreading': 'str',
        'feature_usage': 'str',
        'network_type': 'str',
        'cluster_networks': 'list[ClusterNetwork]',
        'service_networks': 'list[ServiceNetwork]',
        'machine_networks': 'list[MachineNetwork]',
        'cpu_architecture': 'str',
        'ignition_endpoint': 'IgnitionEndpoint'
    }

    attribute_map = {
        'kind': 'kind',
        'high_availability_mode': 'high_availability_mode',
        'id': 'id',
        'href': 'href',
        'name': 'name',
        'user_name': 'user_name',
        'org_id': 'org_id',
        'email_domain': 'email_domain',
        'openshift_version': 'openshift_version',
        'ocp_release_image': 'ocp_release_image',
        'openshift_cluster_id': 'openshift_cluster_id',
        'image_info': 'image_info',
        'platform': 'platform',
        'base_dns_domain': 'base_dns_domain',
        'cluster_network_cidr': 'cluster_network_cidr',
        'cluster_network_host_prefix': 'cluster_network_host_prefix',
        'service_network_cidr': 'service_network_cidr',
        'api_vip': 'api_vip',
        'api_vip_dns_name': 'api_vip_dns_name',
        'machine_network_cidr': 'machine_network_cidr',
        'ingress_vip': 'ingress_vip',
        'ssh_public_key': 'ssh_public_key',
        'http_proxy': 'http_proxy',
        'https_proxy': 'https_proxy',
        'no_proxy': 'no_proxy',
        'status': 'status',
        'status_info': 'status_info',
        'status_updated_at': 'status_updated_at',
        'progress': 'progress',
        'disk_encryption': 'disk_encryption',
        'hosts': 'hosts',
        'ready_host_count': 'ready_host_count',
        'enabled_host_count': 'enabled_host_count',
        'total_host_count': 'total_host_count',
        'schedulable_masters': 'schedulable_masters',
        'updated_at': 'updated_at',
        'created_at': 'created_at',
        'install_started_at': 'install_started_at',
        'install_completed_at': 'install_completed_at',
        'host_networks': 'host_networks',
        'pull_secret_set': 'pull_secret_set',
        'vip_dhcp_allocation': 'vip_dhcp_allocation',
        'validations_info': 'validations_info',
        'logs_info': 'logs_info',
        'install_config_overrides': 'install_config_overrides',
        'ignition_config_overrides': 'ignition_config_overrides',
        'controller_logs_collected_at': 'controller_logs_collected_at',
        'controller_logs_started_at': 'controller_logs_started_at',
        'connectivity_majority_groups': 'connectivity_majority_groups',
        'deleted_at': 'deleted_at',
        'user_managed_networking': 'user_managed_networking',
        'additional_ntp_source': 'additional_ntp_source',
        'monitored_operators': 'monitored_operators',
        'ams_subscription_id': 'ams_subscription_id',
        'hyperthreading': 'hyperthreading',
        'feature_usage': 'feature_usage',
        'network_type': 'network_type',
        'cluster_networks': 'cluster_networks',
        'service_networks': 'service_networks',
        'machine_networks': 'machine_networks',
        'cpu_architecture': 'cpu_architecture',
        'ignition_endpoint': 'ignition_endpoint'
    }

    def __init__(self, kind=None, high_availability_mode='Full', id=None, href=None, name=None, user_name=None, org_id=None, email_domain=None, openshift_version=None, ocp_release_image=None, openshift_cluster_id=None, image_info=None, platform=None, base_dns_domain=None, cluster_network_cidr=None, cluster_network_host_prefix=None, service_network_cidr=None, api_vip=None, api_vip_dns_name=None, machine_network_cidr=None, ingress_vip=None, ssh_public_key=None, http_proxy=None, https_proxy=None, no_proxy=None, status=None, status_info=None, status_updated_at=None, progress=None, disk_encryption=None, hosts=None, ready_host_count=None, enabled_host_count=None, total_host_count=None, schedulable_masters=False, updated_at=None, created_at=None, install_started_at=None, install_completed_at=None, host_networks=None, pull_secret_set=None, vip_dhcp_allocation=None, validations_info=None, logs_info=None, install_config_overrides=None, ignition_config_overrides=None, controller_logs_collected_at=None, controller_logs_started_at=None, connectivity_majority_groups=None, deleted_at=None, user_managed_networking=None, additional_ntp_source=None, monitored_operators=None, ams_subscription_id=None, hyperthreading=None, feature_usage=None, network_type=None, cluster_networks=None, service_networks=None, machine_networks=None, cpu_architecture='x86_64', ignition_endpoint=None):  # noqa: E501
        """Cluster - a model defined in Swagger"""  # noqa: E501

        self._kind = None
        self._high_availability_mode = None
        self._id = None
        self._href = None
        self._name = None
        self._user_name = None
        self._org_id = None
        self._email_domain = None
        self._openshift_version = None
        self._ocp_release_image = None
        self._openshift_cluster_id = None
        self._image_info = None
        self._platform = None
        self._base_dns_domain = None
        self._cluster_network_cidr = None
        self._cluster_network_host_prefix = None
        self._service_network_cidr = None
        self._api_vip = None
        self._api_vip_dns_name = None
        self._machine_network_cidr = None
        self._ingress_vip = None
        self._ssh_public_key = None
        self._http_proxy = None
        self._https_proxy = None
        self._no_proxy = None
        self._status = None
        self._status_info = None
        self._status_updated_at = None
        self._progress = None
        self._disk_encryption = None
        self._hosts = None
        self._ready_host_count = None
        self._enabled_host_count = None
        self._total_host_count = None
        self._schedulable_masters = None
        self._updated_at = None
        self._created_at = None
        self._install_started_at = None
        self._install_completed_at = None
        self._host_networks = None
        self._pull_secret_set = None
        self._vip_dhcp_allocation = None
        self._validations_info = None
        self._logs_info = None
        self._install_config_overrides = None
        self._ignition_config_overrides = None
        self._controller_logs_collected_at = None
        self._controller_logs_started_at = None
        self._connectivity_majority_groups = None
        self._deleted_at = None
        self._user_managed_networking = None
        self._additional_ntp_source = None
        self._monitored_operators = None
        self._ams_subscription_id = None
        self._hyperthreading = None
        self._feature_usage = None
        self._network_type = None
        self._cluster_networks = None
        self._service_networks = None
        self._machine_networks = None
        self._cpu_architecture = None
        self._ignition_endpoint = None
        self.discriminator = None

        self.kind = kind
        if high_availability_mode is not None:
            self.high_availability_mode = high_availability_mode
        self.id = id
        self.href = href
        if name is not None:
            self.name = name
        if user_name is not None:
            self.user_name = user_name
        if org_id is not None:
            self.org_id = org_id
        if email_domain is not None:
            self.email_domain = email_domain
        if openshift_version is not None:
            self.openshift_version = openshift_version
        if ocp_release_image is not None:
            self.ocp_release_image = ocp_release_image
        if openshift_cluster_id is not None:
            self.openshift_cluster_id = openshift_cluster_id
        self.image_info = image_info
        if platform is not None:
            self.platform = platform
        if base_dns_domain is not None:
            self.base_dns_domain = base_dns_domain
        if cluster_network_cidr is not None:
            self.cluster_network_cidr = cluster_network_cidr
        if cluster_network_host_prefix is not None:
            self.cluster_network_host_prefix = cluster_network_host_prefix
        if service_network_cidr is not None:
            self.service_network_cidr = service_network_cidr
        if api_vip is not None:
            self.api_vip = api_vip
        if api_vip_dns_name is not None:
            self.api_vip_dns_name = api_vip_dns_name
        if machine_network_cidr is not None:
            self.machine_network_cidr = machine_network_cidr
        if ingress_vip is not None:
            self.ingress_vip = ingress_vip
        if ssh_public_key is not None:
            self.ssh_public_key = ssh_public_key
        if http_proxy is not None:
            self.http_proxy = http_proxy
        if https_proxy is not None:
            self.https_proxy = https_proxy
        if no_proxy is not None:
            self.no_proxy = no_proxy
        self.status = status
        self.status_info = status_info
        if status_updated_at is not None:
            self.status_updated_at = status_updated_at
        if progress is not None:
            self.progress = progress
        if disk_encryption is not None:
            self.disk_encryption = disk_encryption
        if hosts is not None:
            self.hosts = hosts
        if ready_host_count is not None:
            self.ready_host_count = ready_host_count
        if enabled_host_count is not None:
            self.enabled_host_count = enabled_host_count
        if total_host_count is not None:
            self.total_host_count = total_host_count
        if schedulable_masters is not None:
            self.schedulable_masters = schedulable_masters
        if updated_at is not None:
            self.updated_at = updated_at
        if created_at is not None:
            self.created_at = created_at
        if install_started_at is not None:
            self.install_started_at = install_started_at
        if install_completed_at is not None:
            self.install_completed_at = install_completed_at
        if host_networks is not None:
            self.host_networks = host_networks
        if pull_secret_set is not None:
            self.pull_secret_set = pull_secret_set
        if vip_dhcp_allocation is not None:
            self.vip_dhcp_allocation = vip_dhcp_allocation
        if validations_info is not None:
            self.validations_info = validations_info
        if logs_info is not None:
            self.logs_info = logs_info
        if install_config_overrides is not None:
            self.install_config_overrides = install_config_overrides
        if ignition_config_overrides is not None:
            self.ignition_config_overrides = ignition_config_overrides
        if controller_logs_collected_at is not None:
            self.controller_logs_collected_at = controller_logs_collected_at
        if controller_logs_started_at is not None:
            self.controller_logs_started_at = controller_logs_started_at
        if connectivity_majority_groups is not None:
            self.connectivity_majority_groups = connectivity_majority_groups
        if deleted_at is not None:
            self.deleted_at = deleted_at
        if user_managed_networking is not None:
            self.user_managed_networking = user_managed_networking
        if additional_ntp_source is not None:
            self.additional_ntp_source = additional_ntp_source
        if monitored_operators is not None:
            self.monitored_operators = monitored_operators
        if ams_subscription_id is not None:
            self.ams_subscription_id = ams_subscription_id
        if hyperthreading is not None:
            self.hyperthreading = hyperthreading
        if feature_usage is not None:
            self.feature_usage = feature_usage
        if network_type is not None:
            self.network_type = network_type
        if cluster_networks is not None:
            self.cluster_networks = cluster_networks
        if service_networks is not None:
            self.service_networks = service_networks
        if machine_networks is not None:
            self.machine_networks = machine_networks
        if cpu_architecture is not None:
            self.cpu_architecture = cpu_architecture
        if ignition_endpoint is not None:
            self.ignition_endpoint = ignition_endpoint

    @property
    def kind(self):
        """Gets the kind of this Cluster.  # noqa: E501

        Indicates the type of this object. Will be 'Cluster' if this is a complete object, 'AddHostsCluster' for cluster that add hosts to existing OCP cluster,   # noqa: E501

        :return: The kind of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._kind

    @kind.setter
    def kind(self, kind):
        """Sets the kind of this Cluster.

        Indicates the type of this object. Will be 'Cluster' if this is a complete object, 'AddHostsCluster' for cluster that add hosts to existing OCP cluster,   # noqa: E501

        :param kind: The kind of this Cluster.  # noqa: E501
        :type: str
        """
        if kind is None:
            raise ValueError("Invalid value for `kind`, must not be `None`")  # noqa: E501
        allowed_values = ["Cluster", "AddHostsCluster"]  # noqa: E501
        if kind not in allowed_values:
            raise ValueError(
                "Invalid value for `kind` ({0}), must be one of {1}"  # noqa: E501
                .format(kind, allowed_values)
            )

        self._kind = kind

    @property
    def high_availability_mode(self):
        """Gets the high_availability_mode of this Cluster.  # noqa: E501

        Guaranteed availability of the installed cluster. 'Full' installs a Highly-Available cluster over multiple master nodes whereas 'None' installs a full cluster over one node.   # noqa: E501

        :return: The high_availability_mode of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._high_availability_mode

    @high_availability_mode.setter
    def high_availability_mode(self, high_availability_mode):
        """Sets the high_availability_mode of this Cluster.

        Guaranteed availability of the installed cluster. 'Full' installs a Highly-Available cluster over multiple master nodes whereas 'None' installs a full cluster over one node.   # noqa: E501

        :param high_availability_mode: The high_availability_mode of this Cluster.  # noqa: E501
        :type: str
        """
        allowed_values = ["Full", "None"]  # noqa: E501
        if high_availability_mode not in allowed_values:
            raise ValueError(
                "Invalid value for `high_availability_mode` ({0}), must be one of {1}"  # noqa: E501
                .format(high_availability_mode, allowed_values)
            )

        self._high_availability_mode = high_availability_mode

    @property
    def id(self):
        """Gets the id of this Cluster.  # noqa: E501

        Unique identifier of the object.  # noqa: E501

        :return: The id of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Cluster.

        Unique identifier of the object.  # noqa: E501

        :param id: The id of this Cluster.  # noqa: E501
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def href(self):
        """Gets the href of this Cluster.  # noqa: E501

        Self link.  # noqa: E501

        :return: The href of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._href

    @href.setter
    def href(self, href):
        """Sets the href of this Cluster.

        Self link.  # noqa: E501

        :param href: The href of this Cluster.  # noqa: E501
        :type: str
        """
        if href is None:
            raise ValueError("Invalid value for `href`, must not be `None`")  # noqa: E501

        self._href = href

    @property
    def name(self):
        """Gets the name of this Cluster.  # noqa: E501

        Name of the OpenShift cluster.  # noqa: E501

        :return: The name of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Cluster.

        Name of the OpenShift cluster.  # noqa: E501

        :param name: The name of this Cluster.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def user_name(self):
        """Gets the user_name of this Cluster.  # noqa: E501


        :return: The user_name of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._user_name

    @user_name.setter
    def user_name(self, user_name):
        """Sets the user_name of this Cluster.


        :param user_name: The user_name of this Cluster.  # noqa: E501
        :type: str
        """

        self._user_name = user_name

    @property
    def org_id(self):
        """Gets the org_id of this Cluster.  # noqa: E501


        :return: The org_id of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._org_id

    @org_id.setter
    def org_id(self, org_id):
        """Sets the org_id of this Cluster.


        :param org_id: The org_id of this Cluster.  # noqa: E501
        :type: str
        """

        self._org_id = org_id

    @property
    def email_domain(self):
        """Gets the email_domain of this Cluster.  # noqa: E501


        :return: The email_domain of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._email_domain

    @email_domain.setter
    def email_domain(self, email_domain):
        """Sets the email_domain of this Cluster.


        :param email_domain: The email_domain of this Cluster.  # noqa: E501
        :type: str
        """

        self._email_domain = email_domain

    @property
    def openshift_version(self):
        """Gets the openshift_version of this Cluster.  # noqa: E501

        Version of the OpenShift cluster.  # noqa: E501

        :return: The openshift_version of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._openshift_version

    @openshift_version.setter
    def openshift_version(self, openshift_version):
        """Sets the openshift_version of this Cluster.

        Version of the OpenShift cluster.  # noqa: E501

        :param openshift_version: The openshift_version of this Cluster.  # noqa: E501
        :type: str
        """

        self._openshift_version = openshift_version

    @property
    def ocp_release_image(self):
        """Gets the ocp_release_image of this Cluster.  # noqa: E501

        OpenShift release image URI.  # noqa: E501

        :return: The ocp_release_image of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._ocp_release_image

    @ocp_release_image.setter
    def ocp_release_image(self, ocp_release_image):
        """Sets the ocp_release_image of this Cluster.

        OpenShift release image URI.  # noqa: E501

        :param ocp_release_image: The ocp_release_image of this Cluster.  # noqa: E501
        :type: str
        """

        self._ocp_release_image = ocp_release_image

    @property
    def openshift_cluster_id(self):
        """Gets the openshift_cluster_id of this Cluster.  # noqa: E501

        Cluster ID on OCP system.  # noqa: E501

        :return: The openshift_cluster_id of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._openshift_cluster_id

    @openshift_cluster_id.setter
    def openshift_cluster_id(self, openshift_cluster_id):
        """Sets the openshift_cluster_id of this Cluster.

        Cluster ID on OCP system.  # noqa: E501

        :param openshift_cluster_id: The openshift_cluster_id of this Cluster.  # noqa: E501
        :type: str
        """

        self._openshift_cluster_id = openshift_cluster_id

    @property
    def image_info(self):
        """Gets the image_info of this Cluster.  # noqa: E501


        :return: The image_info of this Cluster.  # noqa: E501
        :rtype: ImageInfo
        """
        return self._image_info

    @image_info.setter
    def image_info(self, image_info):
        """Sets the image_info of this Cluster.


        :param image_info: The image_info of this Cluster.  # noqa: E501
        :type: ImageInfo
        """
        if image_info is None:
            raise ValueError("Invalid value for `image_info`, must not be `None`")  # noqa: E501

        self._image_info = image_info

    @property
    def platform(self):
        """Gets the platform of this Cluster.  # noqa: E501


        :return: The platform of this Cluster.  # noqa: E501
        :rtype: Platform
        """
        return self._platform

    @platform.setter
    def platform(self, platform):
        """Sets the platform of this Cluster.


        :param platform: The platform of this Cluster.  # noqa: E501
        :type: Platform
        """

        self._platform = platform

    @property
    def base_dns_domain(self):
        """Gets the base_dns_domain of this Cluster.  # noqa: E501

        Base domain of the cluster. All DNS records must be sub-domains of this base and include the cluster name.  # noqa: E501

        :return: The base_dns_domain of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._base_dns_domain

    @base_dns_domain.setter
    def base_dns_domain(self, base_dns_domain):
        """Sets the base_dns_domain of this Cluster.

        Base domain of the cluster. All DNS records must be sub-domains of this base and include the cluster name.  # noqa: E501

        :param base_dns_domain: The base_dns_domain of this Cluster.  # noqa: E501
        :type: str
        """

        self._base_dns_domain = base_dns_domain

    @property
    def cluster_network_cidr(self):
        """Gets the cluster_network_cidr of this Cluster.  # noqa: E501

        IP address block from which Pod IPs are allocated. This block must not overlap with existing physical networks. These IP addresses are used for the Pod network, and if you need to access the Pods from an external network, configure load balancers and routers to manage the traffic.  # noqa: E501

        :return: The cluster_network_cidr of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._cluster_network_cidr

    @cluster_network_cidr.setter
    def cluster_network_cidr(self, cluster_network_cidr):
        """Sets the cluster_network_cidr of this Cluster.

        IP address block from which Pod IPs are allocated. This block must not overlap with existing physical networks. These IP addresses are used for the Pod network, and if you need to access the Pods from an external network, configure load balancers and routers to manage the traffic.  # noqa: E501

        :param cluster_network_cidr: The cluster_network_cidr of this Cluster.  # noqa: E501
        :type: str
        """

        self._cluster_network_cidr = cluster_network_cidr

    @property
    def cluster_network_host_prefix(self):
        """Gets the cluster_network_host_prefix of this Cluster.  # noqa: E501

        The subnet prefix length to assign to each individual node. For example, if clusterNetworkHostPrefix is set to 23, then each node is assigned a /23 subnet out of the given cidr (clusterNetworkCIDR), which allows for 510 (2^(32 - 23) - 2) pod IPs addresses. If you are required to provide access to nodes from an external network, configure load balancers and routers to manage the traffic.  # noqa: E501

        :return: The cluster_network_host_prefix of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._cluster_network_host_prefix

    @cluster_network_host_prefix.setter
    def cluster_network_host_prefix(self, cluster_network_host_prefix):
        """Sets the cluster_network_host_prefix of this Cluster.

        The subnet prefix length to assign to each individual node. For example, if clusterNetworkHostPrefix is set to 23, then each node is assigned a /23 subnet out of the given cidr (clusterNetworkCIDR), which allows for 510 (2^(32 - 23) - 2) pod IPs addresses. If you are required to provide access to nodes from an external network, configure load balancers and routers to manage the traffic.  # noqa: E501

        :param cluster_network_host_prefix: The cluster_network_host_prefix of this Cluster.  # noqa: E501
        :type: int
        """
        if cluster_network_host_prefix is not None and cluster_network_host_prefix > 128:  # noqa: E501
            raise ValueError("Invalid value for `cluster_network_host_prefix`, must be a value less than or equal to `128`")  # noqa: E501
        if cluster_network_host_prefix is not None and cluster_network_host_prefix < 1:  # noqa: E501
            raise ValueError("Invalid value for `cluster_network_host_prefix`, must be a value greater than or equal to `1`")  # noqa: E501

        self._cluster_network_host_prefix = cluster_network_host_prefix

    @property
    def service_network_cidr(self):
        """Gets the service_network_cidr of this Cluster.  # noqa: E501

        The IP address pool to use for service IP addresses. You can enter only one IP address pool. If you need to access the services from an external network, configure load balancers and routers to manage the traffic.  # noqa: E501

        :return: The service_network_cidr of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._service_network_cidr

    @service_network_cidr.setter
    def service_network_cidr(self, service_network_cidr):
        """Sets the service_network_cidr of this Cluster.

        The IP address pool to use for service IP addresses. You can enter only one IP address pool. If you need to access the services from an external network, configure load balancers and routers to manage the traffic.  # noqa: E501

        :param service_network_cidr: The service_network_cidr of this Cluster.  # noqa: E501
        :type: str
        """

        self._service_network_cidr = service_network_cidr

    @property
    def api_vip(self):
        """Gets the api_vip of this Cluster.  # noqa: E501

        The virtual IP used to reach the OpenShift cluster's API.  # noqa: E501

        :return: The api_vip of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._api_vip

    @api_vip.setter
    def api_vip(self, api_vip):
        """Sets the api_vip of this Cluster.

        The virtual IP used to reach the OpenShift cluster's API.  # noqa: E501

        :param api_vip: The api_vip of this Cluster.  # noqa: E501
        :type: str
        """

        self._api_vip = api_vip

    @property
    def api_vip_dns_name(self):
        """Gets the api_vip_dns_name of this Cluster.  # noqa: E501

        The domain name used to reach the OpenShift cluster API.  # noqa: E501

        :return: The api_vip_dns_name of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._api_vip_dns_name

    @api_vip_dns_name.setter
    def api_vip_dns_name(self, api_vip_dns_name):
        """Sets the api_vip_dns_name of this Cluster.

        The domain name used to reach the OpenShift cluster API.  # noqa: E501

        :param api_vip_dns_name: The api_vip_dns_name of this Cluster.  # noqa: E501
        :type: str
        """

        self._api_vip_dns_name = api_vip_dns_name

    @property
    def machine_network_cidr(self):
        """Gets the machine_network_cidr of this Cluster.  # noqa: E501

        A CIDR that all hosts belonging to the cluster should have an interfaces with IP address that belongs to this CIDR. The api_vip belongs to this CIDR.  # noqa: E501

        :return: The machine_network_cidr of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._machine_network_cidr

    @machine_network_cidr.setter
    def machine_network_cidr(self, machine_network_cidr):
        """Sets the machine_network_cidr of this Cluster.

        A CIDR that all hosts belonging to the cluster should have an interfaces with IP address that belongs to this CIDR. The api_vip belongs to this CIDR.  # noqa: E501

        :param machine_network_cidr: The machine_network_cidr of this Cluster.  # noqa: E501
        :type: str
        """

        self._machine_network_cidr = machine_network_cidr

    @property
    def ingress_vip(self):
        """Gets the ingress_vip of this Cluster.  # noqa: E501

        The virtual IP used for cluster ingress traffic.  # noqa: E501

        :return: The ingress_vip of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._ingress_vip

    @ingress_vip.setter
    def ingress_vip(self, ingress_vip):
        """Sets the ingress_vip of this Cluster.

        The virtual IP used for cluster ingress traffic.  # noqa: E501

        :param ingress_vip: The ingress_vip of this Cluster.  # noqa: E501
        :type: str
        """

        self._ingress_vip = ingress_vip

    @property
    def ssh_public_key(self):
        """Gets the ssh_public_key of this Cluster.  # noqa: E501

        SSH public key for debugging OpenShift nodes.  # noqa: E501

        :return: The ssh_public_key of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._ssh_public_key

    @ssh_public_key.setter
    def ssh_public_key(self, ssh_public_key):
        """Sets the ssh_public_key of this Cluster.

        SSH public key for debugging OpenShift nodes.  # noqa: E501

        :param ssh_public_key: The ssh_public_key of this Cluster.  # noqa: E501
        :type: str
        """

        self._ssh_public_key = ssh_public_key

    @property
    def http_proxy(self):
        """Gets the http_proxy of this Cluster.  # noqa: E501

        A proxy URL to use for creating HTTP connections outside the cluster. http://\\<username\\>:\\<pswd\\>@\\<ip\\>:\\<port\\>   # noqa: E501

        :return: The http_proxy of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._http_proxy

    @http_proxy.setter
    def http_proxy(self, http_proxy):
        """Sets the http_proxy of this Cluster.

        A proxy URL to use for creating HTTP connections outside the cluster. http://\\<username\\>:\\<pswd\\>@\\<ip\\>:\\<port\\>   # noqa: E501

        :param http_proxy: The http_proxy of this Cluster.  # noqa: E501
        :type: str
        """

        self._http_proxy = http_proxy

    @property
    def https_proxy(self):
        """Gets the https_proxy of this Cluster.  # noqa: E501

        A proxy URL to use for creating HTTPS connections outside the cluster. http://\\<username\\>:\\<pswd\\>@\\<ip\\>:\\<port\\>   # noqa: E501

        :return: The https_proxy of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._https_proxy

    @https_proxy.setter
    def https_proxy(self, https_proxy):
        """Sets the https_proxy of this Cluster.

        A proxy URL to use for creating HTTPS connections outside the cluster. http://\\<username\\>:\\<pswd\\>@\\<ip\\>:\\<port\\>   # noqa: E501

        :param https_proxy: The https_proxy of this Cluster.  # noqa: E501
        :type: str
        """

        self._https_proxy = https_proxy

    @property
    def no_proxy(self):
        """Gets the no_proxy of this Cluster.  # noqa: E501

        A comma-separated list of destination domain names, domains, IP addresses, or other network CIDRs to exclude from proxying.  # noqa: E501

        :return: The no_proxy of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._no_proxy

    @no_proxy.setter
    def no_proxy(self, no_proxy):
        """Sets the no_proxy of this Cluster.

        A comma-separated list of destination domain names, domains, IP addresses, or other network CIDRs to exclude from proxying.  # noqa: E501

        :param no_proxy: The no_proxy of this Cluster.  # noqa: E501
        :type: str
        """

        self._no_proxy = no_proxy

    @property
    def status(self):
        """Gets the status of this Cluster.  # noqa: E501

        Status of the OpenShift cluster.  # noqa: E501

        :return: The status of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Cluster.

        Status of the OpenShift cluster.  # noqa: E501

        :param status: The status of this Cluster.  # noqa: E501
        :type: str
        """
        if status is None:
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501
        allowed_values = ["insufficient", "ready", "error", "preparing-for-installation", "pending-for-input", "installing", "finalizing", "installed", "adding-hosts", "cancelled", "installing-pending-user-action"]  # noqa: E501
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def status_info(self):
        """Gets the status_info of this Cluster.  # noqa: E501

        Additional information pertaining to the status of the OpenShift cluster.  # noqa: E501

        :return: The status_info of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._status_info

    @status_info.setter
    def status_info(self, status_info):
        """Sets the status_info of this Cluster.

        Additional information pertaining to the status of the OpenShift cluster.  # noqa: E501

        :param status_info: The status_info of this Cluster.  # noqa: E501
        :type: str
        """
        if status_info is None:
            raise ValueError("Invalid value for `status_info`, must not be `None`")  # noqa: E501

        self._status_info = status_info

    @property
    def status_updated_at(self):
        """Gets the status_updated_at of this Cluster.  # noqa: E501

        The last time that the cluster status was updated.  # noqa: E501

        :return: The status_updated_at of this Cluster.  # noqa: E501
        :rtype: datetime
        """
        return self._status_updated_at

    @status_updated_at.setter
    def status_updated_at(self, status_updated_at):
        """Sets the status_updated_at of this Cluster.

        The last time that the cluster status was updated.  # noqa: E501

        :param status_updated_at: The status_updated_at of this Cluster.  # noqa: E501
        :type: datetime
        """

        self._status_updated_at = status_updated_at

    @property
    def progress(self):
        """Gets the progress of this Cluster.  # noqa: E501

        Installation progress percentages of the cluster.  # noqa: E501

        :return: The progress of this Cluster.  # noqa: E501
        :rtype: ClusterProgressInfo
        """
        return self._progress

    @progress.setter
    def progress(self, progress):
        """Sets the progress of this Cluster.

        Installation progress percentages of the cluster.  # noqa: E501

        :param progress: The progress of this Cluster.  # noqa: E501
        :type: ClusterProgressInfo
        """

        self._progress = progress

    @property
    def disk_encryption(self):
        """Gets the disk_encryption of this Cluster.  # noqa: E501

        Information regarding hosts' installation disks encryption.  # noqa: E501

        :return: The disk_encryption of this Cluster.  # noqa: E501
        :rtype: DiskEncryption
        """
        return self._disk_encryption

    @disk_encryption.setter
    def disk_encryption(self, disk_encryption):
        """Sets the disk_encryption of this Cluster.

        Information regarding hosts' installation disks encryption.  # noqa: E501

        :param disk_encryption: The disk_encryption of this Cluster.  # noqa: E501
        :type: DiskEncryption
        """

        self._disk_encryption = disk_encryption

    @property
    def hosts(self):
        """Gets the hosts of this Cluster.  # noqa: E501

        Hosts that are associated with this cluster.  # noqa: E501

        :return: The hosts of this Cluster.  # noqa: E501
        :rtype: list[Host]
        """
        return self._hosts

    @hosts.setter
    def hosts(self, hosts):
        """Sets the hosts of this Cluster.

        Hosts that are associated with this cluster.  # noqa: E501

        :param hosts: The hosts of this Cluster.  # noqa: E501
        :type: list[Host]
        """

        self._hosts = hosts

    @property
    def ready_host_count(self):
        """Gets the ready_host_count of this Cluster.  # noqa: E501

        hosts associated to this cluster that are in 'known' state.  # noqa: E501

        :return: The ready_host_count of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._ready_host_count

    @ready_host_count.setter
    def ready_host_count(self, ready_host_count):
        """Sets the ready_host_count of this Cluster.

        hosts associated to this cluster that are in 'known' state.  # noqa: E501

        :param ready_host_count: The ready_host_count of this Cluster.  # noqa: E501
        :type: int
        """

        self._ready_host_count = ready_host_count

    @property
    def enabled_host_count(self):
        """Gets the enabled_host_count of this Cluster.  # noqa: E501

        hosts associated to this cluster that are not in 'disabled' state.  # noqa: E501

        :return: The enabled_host_count of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._enabled_host_count

    @enabled_host_count.setter
    def enabled_host_count(self, enabled_host_count):
        """Sets the enabled_host_count of this Cluster.

        hosts associated to this cluster that are not in 'disabled' state.  # noqa: E501

        :param enabled_host_count: The enabled_host_count of this Cluster.  # noqa: E501
        :type: int
        """

        self._enabled_host_count = enabled_host_count

    @property
    def total_host_count(self):
        """Gets the total_host_count of this Cluster.  # noqa: E501

        All hosts associated to this cluster.  # noqa: E501

        :return: The total_host_count of this Cluster.  # noqa: E501
        :rtype: int
        """
        return self._total_host_count

    @total_host_count.setter
    def total_host_count(self, total_host_count):
        """Sets the total_host_count of this Cluster.

        All hosts associated to this cluster.  # noqa: E501

        :param total_host_count: The total_host_count of this Cluster.  # noqa: E501
        :type: int
        """

        self._total_host_count = total_host_count

    @property
    def schedulable_masters(self):
        """Gets the schedulable_masters of this Cluster.  # noqa: E501

        Schedule workloads on masters  # noqa: E501

        :return: The schedulable_masters of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._schedulable_masters

    @schedulable_masters.setter
    def schedulable_masters(self, schedulable_masters):
        """Sets the schedulable_masters of this Cluster.

        Schedule workloads on masters  # noqa: E501

        :param schedulable_masters: The schedulable_masters of this Cluster.  # noqa: E501
        :type: bool
        """

        self._schedulable_masters = schedulable_masters

    @property
    def updated_at(self):
        """Gets the updated_at of this Cluster.  # noqa: E501

        The last time that this cluster was updated.  # noqa: E501

        :return: The updated_at of this Cluster.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this Cluster.

        The last time that this cluster was updated.  # noqa: E501

        :param updated_at: The updated_at of this Cluster.  # noqa: E501
        :type: datetime
        """

        self._updated_at = updated_at

    @property
    def created_at(self):
        """Gets the created_at of this Cluster.  # noqa: E501

        The time that this cluster was created.  # noqa: E501

        :return: The created_at of this Cluster.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Cluster.

        The time that this cluster was created.  # noqa: E501

        :param created_at: The created_at of this Cluster.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def install_started_at(self):
        """Gets the install_started_at of this Cluster.  # noqa: E501

        The time that this cluster started installation.  # noqa: E501

        :return: The install_started_at of this Cluster.  # noqa: E501
        :rtype: datetime
        """
        return self._install_started_at

    @install_started_at.setter
    def install_started_at(self, install_started_at):
        """Sets the install_started_at of this Cluster.

        The time that this cluster started installation.  # noqa: E501

        :param install_started_at: The install_started_at of this Cluster.  # noqa: E501
        :type: datetime
        """

        self._install_started_at = install_started_at

    @property
    def install_completed_at(self):
        """Gets the install_completed_at of this Cluster.  # noqa: E501

        The time that this cluster completed installation.  # noqa: E501

        :return: The install_completed_at of this Cluster.  # noqa: E501
        :rtype: datetime
        """
        return self._install_completed_at

    @install_completed_at.setter
    def install_completed_at(self, install_completed_at):
        """Sets the install_completed_at of this Cluster.

        The time that this cluster completed installation.  # noqa: E501

        :param install_completed_at: The install_completed_at of this Cluster.  # noqa: E501
        :type: datetime
        """

        self._install_completed_at = install_completed_at

    @property
    def host_networks(self):
        """Gets the host_networks of this Cluster.  # noqa: E501

        List of host networks to be filled during query.  # noqa: E501

        :return: The host_networks of this Cluster.  # noqa: E501
        :rtype: list[HostNetwork]
        """
        return self._host_networks

    @host_networks.setter
    def host_networks(self, host_networks):
        """Sets the host_networks of this Cluster.

        List of host networks to be filled during query.  # noqa: E501

        :param host_networks: The host_networks of this Cluster.  # noqa: E501
        :type: list[HostNetwork]
        """

        self._host_networks = host_networks

    @property
    def pull_secret_set(self):
        """Gets the pull_secret_set of this Cluster.  # noqa: E501

        True if the pull secret has been added to the cluster.  # noqa: E501

        :return: The pull_secret_set of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._pull_secret_set

    @pull_secret_set.setter
    def pull_secret_set(self, pull_secret_set):
        """Sets the pull_secret_set of this Cluster.

        True if the pull secret has been added to the cluster.  # noqa: E501

        :param pull_secret_set: The pull_secret_set of this Cluster.  # noqa: E501
        :type: bool
        """

        self._pull_secret_set = pull_secret_set

    @property
    def vip_dhcp_allocation(self):
        """Gets the vip_dhcp_allocation of this Cluster.  # noqa: E501

        Indicate if virtual IP DHCP allocation mode is enabled.  # noqa: E501

        :return: The vip_dhcp_allocation of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._vip_dhcp_allocation

    @vip_dhcp_allocation.setter
    def vip_dhcp_allocation(self, vip_dhcp_allocation):
        """Sets the vip_dhcp_allocation of this Cluster.

        Indicate if virtual IP DHCP allocation mode is enabled.  # noqa: E501

        :param vip_dhcp_allocation: The vip_dhcp_allocation of this Cluster.  # noqa: E501
        :type: bool
        """

        self._vip_dhcp_allocation = vip_dhcp_allocation

    @property
    def validations_info(self):
        """Gets the validations_info of this Cluster.  # noqa: E501

        JSON-formatted string containing the validation results for each validation id grouped by category (network, hosts-data, etc.)  # noqa: E501

        :return: The validations_info of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._validations_info

    @validations_info.setter
    def validations_info(self, validations_info):
        """Sets the validations_info of this Cluster.

        JSON-formatted string containing the validation results for each validation id grouped by category (network, hosts-data, etc.)  # noqa: E501

        :param validations_info: The validations_info of this Cluster.  # noqa: E501
        :type: str
        """

        self._validations_info = validations_info

    @property
    def logs_info(self):
        """Gets the logs_info of this Cluster.  # noqa: E501

        The progress of log collection or empty if logs are not applicable  # noqa: E501

        :return: The logs_info of this Cluster.  # noqa: E501
        :rtype: LogsState
        """
        return self._logs_info

    @logs_info.setter
    def logs_info(self, logs_info):
        """Sets the logs_info of this Cluster.

        The progress of log collection or empty if logs are not applicable  # noqa: E501

        :param logs_info: The logs_info of this Cluster.  # noqa: E501
        :type: LogsState
        """

        self._logs_info = logs_info

    @property
    def install_config_overrides(self):
        """Gets the install_config_overrides of this Cluster.  # noqa: E501

        JSON-formatted string containing the user overrides for the install-config.yaml file.  # noqa: E501

        :return: The install_config_overrides of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._install_config_overrides

    @install_config_overrides.setter
    def install_config_overrides(self, install_config_overrides):
        """Sets the install_config_overrides of this Cluster.

        JSON-formatted string containing the user overrides for the install-config.yaml file.  # noqa: E501

        :param install_config_overrides: The install_config_overrides of this Cluster.  # noqa: E501
        :type: str
        """

        self._install_config_overrides = install_config_overrides

    @property
    def ignition_config_overrides(self):
        """Gets the ignition_config_overrides of this Cluster.  # noqa: E501

        Json formatted string containing the user overrides for the initial ignition config  # noqa: E501

        :return: The ignition_config_overrides of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._ignition_config_overrides

    @ignition_config_overrides.setter
    def ignition_config_overrides(self, ignition_config_overrides):
        """Sets the ignition_config_overrides of this Cluster.

        Json formatted string containing the user overrides for the initial ignition config  # noqa: E501

        :param ignition_config_overrides: The ignition_config_overrides of this Cluster.  # noqa: E501
        :type: str
        """

        self._ignition_config_overrides = ignition_config_overrides

    @property
    def controller_logs_collected_at(self):
        """Gets the controller_logs_collected_at of this Cluster.  # noqa: E501


        :return: The controller_logs_collected_at of this Cluster.  # noqa: E501
        :rtype: datetime
        """
        return self._controller_logs_collected_at

    @controller_logs_collected_at.setter
    def controller_logs_collected_at(self, controller_logs_collected_at):
        """Sets the controller_logs_collected_at of this Cluster.


        :param controller_logs_collected_at: The controller_logs_collected_at of this Cluster.  # noqa: E501
        :type: datetime
        """

        self._controller_logs_collected_at = controller_logs_collected_at

    @property
    def controller_logs_started_at(self):
        """Gets the controller_logs_started_at of this Cluster.  # noqa: E501


        :return: The controller_logs_started_at of this Cluster.  # noqa: E501
        :rtype: datetime
        """
        return self._controller_logs_started_at

    @controller_logs_started_at.setter
    def controller_logs_started_at(self, controller_logs_started_at):
        """Sets the controller_logs_started_at of this Cluster.


        :param controller_logs_started_at: The controller_logs_started_at of this Cluster.  # noqa: E501
        :type: datetime
        """

        self._controller_logs_started_at = controller_logs_started_at

    @property
    def connectivity_majority_groups(self):
        """Gets the connectivity_majority_groups of this Cluster.  # noqa: E501

        Json formatted string containing the majority groups for connectivity checks.  # noqa: E501

        :return: The connectivity_majority_groups of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._connectivity_majority_groups

    @connectivity_majority_groups.setter
    def connectivity_majority_groups(self, connectivity_majority_groups):
        """Sets the connectivity_majority_groups of this Cluster.

        Json formatted string containing the majority groups for connectivity checks.  # noqa: E501

        :param connectivity_majority_groups: The connectivity_majority_groups of this Cluster.  # noqa: E501
        :type: str
        """

        self._connectivity_majority_groups = connectivity_majority_groups

    @property
    def deleted_at(self):
        """Gets the deleted_at of this Cluster.  # noqa: E501

        The time that the cluster was deleted.  # noqa: E501

        :return: The deleted_at of this Cluster.  # noqa: E501
        :rtype: datetime
        """
        return self._deleted_at

    @deleted_at.setter
    def deleted_at(self, deleted_at):
        """Sets the deleted_at of this Cluster.

        The time that the cluster was deleted.  # noqa: E501

        :param deleted_at: The deleted_at of this Cluster.  # noqa: E501
        :type: datetime
        """

        self._deleted_at = deleted_at

    @property
    def user_managed_networking(self):
        """Gets the user_managed_networking of this Cluster.  # noqa: E501

        Indicate if the networking is managed by the user.  # noqa: E501

        :return: The user_managed_networking of this Cluster.  # noqa: E501
        :rtype: bool
        """
        return self._user_managed_networking

    @user_managed_networking.setter
    def user_managed_networking(self, user_managed_networking):
        """Sets the user_managed_networking of this Cluster.

        Indicate if the networking is managed by the user.  # noqa: E501

        :param user_managed_networking: The user_managed_networking of this Cluster.  # noqa: E501
        :type: bool
        """

        self._user_managed_networking = user_managed_networking

    @property
    def additional_ntp_source(self):
        """Gets the additional_ntp_source of this Cluster.  # noqa: E501

        A comma-separated list of NTP sources (name or IP) going to be added to all the hosts.  # noqa: E501

        :return: The additional_ntp_source of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._additional_ntp_source

    @additional_ntp_source.setter
    def additional_ntp_source(self, additional_ntp_source):
        """Sets the additional_ntp_source of this Cluster.

        A comma-separated list of NTP sources (name or IP) going to be added to all the hosts.  # noqa: E501

        :param additional_ntp_source: The additional_ntp_source of this Cluster.  # noqa: E501
        :type: str
        """

        self._additional_ntp_source = additional_ntp_source

    @property
    def monitored_operators(self):
        """Gets the monitored_operators of this Cluster.  # noqa: E501

        Operators that are associated with this cluster.  # noqa: E501

        :return: The monitored_operators of this Cluster.  # noqa: E501
        :rtype: list[MonitoredOperator]
        """
        return self._monitored_operators

    @monitored_operators.setter
    def monitored_operators(self, monitored_operators):
        """Sets the monitored_operators of this Cluster.

        Operators that are associated with this cluster.  # noqa: E501

        :param monitored_operators: The monitored_operators of this Cluster.  # noqa: E501
        :type: list[MonitoredOperator]
        """

        self._monitored_operators = monitored_operators

    @property
    def ams_subscription_id(self):
        """Gets the ams_subscription_id of this Cluster.  # noqa: E501

        Unique identifier of the AMS subscription in OCM.  # noqa: E501

        :return: The ams_subscription_id of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._ams_subscription_id

    @ams_subscription_id.setter
    def ams_subscription_id(self, ams_subscription_id):
        """Sets the ams_subscription_id of this Cluster.

        Unique identifier of the AMS subscription in OCM.  # noqa: E501

        :param ams_subscription_id: The ams_subscription_id of this Cluster.  # noqa: E501
        :type: str
        """

        self._ams_subscription_id = ams_subscription_id

    @property
    def hyperthreading(self):
        """Gets the hyperthreading of this Cluster.  # noqa: E501

        Enable/disable hyperthreading on master nodes, worker nodes, or all nodes  # noqa: E501

        :return: The hyperthreading of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._hyperthreading

    @hyperthreading.setter
    def hyperthreading(self, hyperthreading):
        """Sets the hyperthreading of this Cluster.

        Enable/disable hyperthreading on master nodes, worker nodes, or all nodes  # noqa: E501

        :param hyperthreading: The hyperthreading of this Cluster.  # noqa: E501
        :type: str
        """
        allowed_values = ["masters", "workers", "all", "none"]  # noqa: E501
        if hyperthreading not in allowed_values:
            raise ValueError(
                "Invalid value for `hyperthreading` ({0}), must be one of {1}"  # noqa: E501
                .format(hyperthreading, allowed_values)
            )

        self._hyperthreading = hyperthreading

    @property
    def feature_usage(self):
        """Gets the feature_usage of this Cluster.  # noqa: E501

        JSON-formatted string containing the usage information by feature name  # noqa: E501

        :return: The feature_usage of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._feature_usage

    @feature_usage.setter
    def feature_usage(self, feature_usage):
        """Sets the feature_usage of this Cluster.

        JSON-formatted string containing the usage information by feature name  # noqa: E501

        :param feature_usage: The feature_usage of this Cluster.  # noqa: E501
        :type: str
        """

        self._feature_usage = feature_usage

    @property
    def network_type(self):
        """Gets the network_type of this Cluster.  # noqa: E501

        The desired network type used.  # noqa: E501

        :return: The network_type of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._network_type

    @network_type.setter
    def network_type(self, network_type):
        """Sets the network_type of this Cluster.

        The desired network type used.  # noqa: E501

        :param network_type: The network_type of this Cluster.  # noqa: E501
        :type: str
        """
        allowed_values = ["OpenShiftSDN", "OVNKubernetes"]  # noqa: E501
        if network_type not in allowed_values:
            raise ValueError(
                "Invalid value for `network_type` ({0}), must be one of {1}"  # noqa: E501
                .format(network_type, allowed_values)
            )

        self._network_type = network_type

    @property
    def cluster_networks(self):
        """Gets the cluster_networks of this Cluster.  # noqa: E501

        Cluster networks that are associated with this cluster.  # noqa: E501

        :return: The cluster_networks of this Cluster.  # noqa: E501
        :rtype: list[ClusterNetwork]
        """
        return self._cluster_networks

    @cluster_networks.setter
    def cluster_networks(self, cluster_networks):
        """Sets the cluster_networks of this Cluster.

        Cluster networks that are associated with this cluster.  # noqa: E501

        :param cluster_networks: The cluster_networks of this Cluster.  # noqa: E501
        :type: list[ClusterNetwork]
        """

        self._cluster_networks = cluster_networks

    @property
    def service_networks(self):
        """Gets the service_networks of this Cluster.  # noqa: E501

        Service networks that are associated with this cluster.  # noqa: E501

        :return: The service_networks of this Cluster.  # noqa: E501
        :rtype: list[ServiceNetwork]
        """
        return self._service_networks

    @service_networks.setter
    def service_networks(self, service_networks):
        """Sets the service_networks of this Cluster.

        Service networks that are associated with this cluster.  # noqa: E501

        :param service_networks: The service_networks of this Cluster.  # noqa: E501
        :type: list[ServiceNetwork]
        """

        self._service_networks = service_networks

    @property
    def machine_networks(self):
        """Gets the machine_networks of this Cluster.  # noqa: E501

        Machine networks that are associated with this cluster.  # noqa: E501

        :return: The machine_networks of this Cluster.  # noqa: E501
        :rtype: list[MachineNetwork]
        """
        return self._machine_networks

    @machine_networks.setter
    def machine_networks(self, machine_networks):
        """Sets the machine_networks of this Cluster.

        Machine networks that are associated with this cluster.  # noqa: E501

        :param machine_networks: The machine_networks of this Cluster.  # noqa: E501
        :type: list[MachineNetwork]
        """

        self._machine_networks = machine_networks

    @property
    def cpu_architecture(self):
        """Gets the cpu_architecture of this Cluster.  # noqa: E501

        The CPU architecture of the image (x86_64/arm64/etc).  # noqa: E501

        :return: The cpu_architecture of this Cluster.  # noqa: E501
        :rtype: str
        """
        return self._cpu_architecture

    @cpu_architecture.setter
    def cpu_architecture(self, cpu_architecture):
        """Sets the cpu_architecture of this Cluster.

        The CPU architecture of the image (x86_64/arm64/etc).  # noqa: E501

        :param cpu_architecture: The cpu_architecture of this Cluster.  # noqa: E501
        :type: str
        """

        self._cpu_architecture = cpu_architecture

    @property
    def ignition_endpoint(self):
        """Gets the ignition_endpoint of this Cluster.  # noqa: E501

        Explicit ignition endpoint overrides the default ignition endpoint.  # noqa: E501

        :return: The ignition_endpoint of this Cluster.  # noqa: E501
        :rtype: IgnitionEndpoint
        """
        return self._ignition_endpoint

    @ignition_endpoint.setter
    def ignition_endpoint(self, ignition_endpoint):
        """Sets the ignition_endpoint of this Cluster.

        Explicit ignition endpoint overrides the default ignition endpoint.  # noqa: E501

        :param ignition_endpoint: The ignition_endpoint of this Cluster.  # noqa: E501
        :type: IgnitionEndpoint
        """

        self._ignition_endpoint = ignition_endpoint

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Cluster, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Cluster):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
