# OpenFinOps Documentation

Welcome to the OpenFinOps documentation! This guide will help you get started with the open-source FinOps platform for AI/ML cost observability and optimization.

## 📚 Documentation Structure

### Getting Started
- **[Quick Start](getting-started/quickstart.md)** - Get up and running in 5 minutes
- **[Installation Guide](getting-started/installation.md)** - Detailed installation instructions
- **[Core Concepts](getting-started/concepts.md)** - Understanding OpenFinOps architecture
- **[Configuration](getting-started/configuration.md)** - How to configure OpenFinOps

### API Reference
- **[Observability API](api/observability-api.md)** - Complete observability platform API
- **[VizlyChart API](api/vizlychart-api.md)** - Visualization library reference
- **[Dashboard API](api/dashboard-api.md)** - Role-based dashboard APIs
- **[Telemetry Agents](api/telemetry-agents.md)** - Cloud telemetry agent APIs

### Tutorials
- **[Basic Usage](tutorials/basic-usage.md)** - Learn the basics
- **[LLM Training Monitoring](tutorials/llm-monitoring.md)** - Track LLM training costs
- **[Multi-Cloud Cost Tracking](tutorials/multi-cloud.md)** - Monitor AWS, Azure, GCP
- **[Custom Dashboards](tutorials/custom-dashboards.md)** - Build your own dashboards
- **[Cost Attribution](tutorials/cost-attribution.md)** - Attribute costs by team/project

### Guides
- **[Deployment Guide](guides/deployment.md)** - Production deployment
- **[Cloud Integration](guides/cloud-integration.md)** - Connect to cloud providers
- **[Security](guides/security.md)** - Security best practices
- **[Performance Tuning](guides/performance.md)** - Optimize performance
- **[Troubleshooting](guides/troubleshooting.md)** - Common issues and solutions

### Architecture
- **[System Architecture](OBSERVABILITY_ARCHITECTURE.md)** - Overall system design
- **[Telemetry Architecture](TELEMETRY_AGENT_DEPLOYMENT.md)** - Telemetry collection
- **[Data Flow](architecture/data-flow.md)** - How data flows through the system
- **[Scaling](architecture/scaling.md)** - Horizontal and vertical scaling

### Reference
- **[CLI Commands](reference/cli.md)** - Command-line interface
- **[Configuration Reference](reference/configuration.md)** - All configuration options
- **[Metrics Reference](reference/metrics.md)** - Available metrics
- **[API Endpoints](reference/api-endpoints.md)** - REST API endpoints

## 🚀 Quick Links

### For New Users
1. [Installation Guide](getting-started/installation.md)
2. [Quick Start](getting-started/quickstart.md)
3. [Basic Tutorial](tutorials/basic-usage.md)

### For Developers
1. [API Reference](api/observability-api.md)
2. [Architecture Guide](OBSERVABILITY_ARCHITECTURE.md)
3. [Contributing Guide](../CONTRIBUTING.md)

### For Operators
1. [Deployment Guide](guides/deployment.md)
2. [Configuration Reference](reference/configuration.md)
3. [Troubleshooting](guides/troubleshooting.md)

## 🎯 Key Features Documentation

### Observability Platform
- **LLM Training Monitoring**: Track GPU utilization, training metrics, and costs
- **RAG Pipeline Analytics**: Monitor vector databases and retrieval accuracy
- **Cost Observatory**: Centralized cost tracking across all resources
- **AI Recommendations**: Intelligent cost optimization suggestions

### VizlyChart Library
- **Professional Charts**: Line, bar, scatter, 3D, and more
- **Real-time Streaming**: Live updating visualizations
- **Interactive Dashboards**: Build engaging dashboards
- **Export Capabilities**: PNG, SVG, PDF export

### Multi-Cloud Support
- **AWS Integration**: CloudWatch, Cost Explorer, SageMaker
- **Azure Integration**: Azure Monitor, Cost Management
- **GCP Integration**: Cloud Monitoring, Cloud Billing
- **AI Platforms**: OpenAI, Anthropic tracking

## 📞 Getting Help

- **GitHub Issues**: [Report bugs](https://github.com/rdmurugan/OpenFinOps/issues)
- **Discussions**: [Ask questions](https://github.com/rdmurugan/OpenFinOps/discussions)
- **Email**: durai@infinidatum.net

## 🤝 Contributing

See our [Contributing Guide](../CONTRIBUTING.md) for information on how to contribute to OpenFinOps.

## 📄 License

OpenFinOps is licensed under the Apache License 2.0. See [LICENSE](../LICENSE) for details.
