# OpenFinOps Examples

This directory contains example scripts demonstrating various features of OpenFinOps.

## 📋 Available Examples

### Getting Started
- **`quickstart.py`** - Basic usage of OpenFinOps (start here!)

### Dashboards
- **`web_dashboard_demo.py`** - Web-based dashboard demonstration

### Cloud Integration
- **`multi_cloud_cost_generator.py`** - Multi-cloud cost tracking example
- **`enterprise_data_connectors_demo.py`** - Enterprise data connector examples

## 🚀 Running Examples

```bash
# Basic quick start
python examples/quickstart.py

# Web dashboard demo
python examples/web_dashboard_demo.py

# Multi-cloud cost tracking
python examples/multi_cloud_cost_generator.py
```

## 📚 Learning Path

1. Start with `quickstart.py` to understand basic concepts
2. Try `web_dashboard_demo.py` to see the web interface
3. Explore `multi_cloud_cost_generator.py` for cloud integration
4. Check `enterprise_data_connectors_demo.py` for advanced features

## 💡 Need Help?

- Read the [main documentation](../docs/)
- Check the [API reference](../docs/API_REFERENCE.md)
- Open an issue on GitHub
- Contribute your own examples!

## 🤝 Contributing Examples

Have a cool example to share? We'd love to include it!

See [CONTRIBUTING.md](../CONTRIBUTING.md) for details.
