# A Python package for Random Feature Method (RFM)

## Quick Install

```bash
conda create -n pyRFM python=3.10 -y
conda activate pyRFM
pip install pyrfm
```

To get the [source code](https://github.com/IFaay/pyRFM/tree/master/pyrfm)
and [examples](https://github.com/IFaay/pyRFM/tree/master/examples), you can clone the
repository:

```bash
git clone https://github.com/IFaay/pyRFM.git
cd pyRFM
```

## Update

```bash
pip install --upgrade --force-reinstall pyrfm
# git pull  # Update local source
```

and re-download / pull the source code.

## Remark

All examples run successfully on a host equipped with 8GB of GPU memory and 32GB of RAM.
Example scripts are located in the [examples](https://github.com/IFaay/pyRFM/tree/master/examples) folder.

## Reference

[1] J. Chen, X. Chi, W. E, and Z. Yang, “Bridging traditional and machine learning-based algorithms for solving pdes:
The random feature method,” J. Mach. Learn., vol. 1, no. 3, pp. 268–298, 2022, doi: 10.4208/jml.220726.

[2] J. Chen, W. E, and Y. Luo, “The random feature method for time-dependent problems,” East Asian Journal on Applied
Mathematics, vol. 13, no. 3, pp. 435–463, 2023, doi: 10.4208/eajam.2023-065.050423.

[3] J. Chen, W. E, and Y. Sun, “Optimization of Random Feature Method in the High-Precision Regime,” Com Appl Math
Comput, Mar. 2024, doi: 10.1007/s42967-024-00389-8.
