"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolve = void 0;
function isResolvable(obj) {
    return obj.toJSON !== undefined;
}
function resolve(value, options = {}) {
    var _a, _b, _c, _d;
    const args = (_a = options.args) !== null && _a !== void 0 ? _a : [];
    const omitEmpty = (_b = options.omitEmpty) !== null && _b !== void 0 ? _b : false;
    if (value == null) {
        return value;
    }
    if (isResolvable(value)) {
        const resolved = value.toJSON();
        return resolve(resolved, options);
    }
    // if value is a function, call it and resolve the result.
    if (typeof value === "function") {
        const resolved = value.apply(undefined, args);
        return resolve(resolved, options);
    }
    if (typeof value !== "object") {
        return value;
    }
    if (Array.isArray(value)) {
        if (omitEmpty && value.length === 0) {
            return undefined;
        }
        return value.map((x) => resolve(x, options)).filter((x) => x != null); // filter undefined/null/omitted
    }
    // only allow data types (i.e. objects without constructors)
    if (value.constructor && ((_c = value.constructor) === null || _c === void 0 ? void 0 : _c.name) !== "Object") {
        throw new Error(`only data types can be resolved. trying to resolve object of type ${(_d = value.constructor) === null || _d === void 0 ? void 0 : _d.name}`);
    }
    const result = {};
    for (const [k, v] of Object.entries(value)) {
        const resolved = resolve(v, options);
        // skip undefined values
        if (resolved === undefined) {
            continue;
        }
        result[k] = resolved;
    }
    if (omitEmpty && Object.keys(result).length === 0) {
        return undefined;
    }
    return result;
}
exports.resolve = resolve;
//# sourceMappingURL=data:application/json;base64,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